#!/bin/bash

[ "$UID" -eq 0 ] || exec sudo bash "$0" "$@"

if [ "$(id -u)" -gt 0 ]; then
	echo "poweroff needs to be run as root or using sudo"
	exit 1
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/s6-rc ]]; then
		sync && ( /usr/lib/s6-rc/poweroff $@ | /usr/bin/s6-linux-init-hpr -p $@ ) && sync && sleep 3 && /usr/bin/busybox poweroff -f;
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/66 ]]; then
		sync && ( /usr/lib/s6-66/poweroff $@ | /usr/bin/66 poweroff $@ ) && sync && sleep 3 && /usr/bin/busybox poweroff -f;
elif [[ $(ps -p1 | grep -ic "runit") -eq 1 ]]; then
		sync && touch /run/initctl && ( /usr/lib/runit/runit-init 0  | /usr/sbin/init 0 ) && ( /usr/lib/runit/shutdown $@ | /usr/sbin/shutdown $@ ) && sync && sleep 3 && /usr/bin/busybox poweroff -f;
elif [[ $(ps -p1 | grep -ic "dinit") -eq 1 ]] || ( [[ $(ps -p1 | grep -ic "init") -eq 1 ]] && [[ $(init --version | grep -ic "Dinit") -eq 1 ]] ); then
		sync && ( /usr/lib/dinit/shutdown $@ | /usr/sbin/shutdown $@ ) && sync && sleep 3 && /usr/bin/busybox poweroff -f;
elif [[ $(ps -p1 | grep -ic "init") -eq 1 ]] && [[ $(init --version | grep -ic "SysV") -eq 1 ]]; then
		sync  && ( /usr/lib/sysvinit/init 0 | /usr/sbin/init 0 ) && sleep 3 && ( /usr/lib/sysvinit/poweroff $@ | /usr/sbin/poweroff $@ ) && sync && sleep 3 && /usr/bin/busybox poweroff -f;
elif [[ $(ps -p1 | grep -ic "systemd") -eq 1 ]]; then
		sync && ( /usr/lib/systemd/systemctl poweroff $@ | /usr/sbin/poweroff $@ ) && sync && sleep 3 && /usr/bin/busybox poweroff -f;
else sync && touch /run/initctl && /usr/sbin/poweroff $@ >/dev/null 2>&1 | /lib/s6-rc/poweroff $@ >/dev/null 2>&1 | /lib/s6-66/poweroff $@ >/dev/null 2>&1 | /lib/runit/shutdown $@; >/dev/null 2>&1 | /lib/openrc/openrc-shutdown -p now >/dev/null 2>&1 | /lib/dinit/shutdown $@; >/dev/null 2>&1 | /lib/sysvinit/poweroff $@; >/dev/null 2>&1 | /lib/systemd/systemctl poweroff $@; >/dev/null 2>&1 | /usr/bin/busybox poweroff -f

fi
