# Copyright (C) 2006,2007 Daiki Ueno <ueno@unixuser.org>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'htree'
require 'ostruct'

module Treil
  class HTMLMapWriter < Writer
    def self.accept?(output)
      Pathname.new(output).extname =~ /\A\.html?\z/i
    end

    def write(rect)
      output = Pathname.new(@output)
      png_output = output.dirname + (output.basename(output.extname).to_s +
                                       '.png')
      png_writer = Writer.instance(png_output.to_s, @config)
      png_writer.write(rect)
      output.open('w') do |file|
        obj = OpenStruct.new
        obj.rect = rect
        obj.png = png_output
        HTree.expand_template(Pathname.new(__FILE__).dirname + 'htmlmap.html',
                              obj, file)
      end
    end

    register(self)
  end
end
