////////////////////////////////////////////////////////////////////////////////
// 
// InteriorFacets.cc
//
//    produced: 19/04/98 jr
// 
////////////////////////////////////////////////////////////////////////////////
#include <iostream>
#include <ctype.h>
#include <string.h>

#include "VertexFacetTable.hh"

#include "Field.hh"
#include "Chirotope.hh"
#include "Permutation.hh"
#include "InteriorFacets.hh"

namespace topcom {

  InteriorFacets::InteriorFacets(const Chirotope& chiro, const Facets& facets) :
    _chiroptr(&chiro),
    _cofaces(),
    interiorfacets_data() {
    size_type count(0);
    const size_type no(facets.no());
    const size_type rank(facets.rank());
    SimplicialComplex perm_interiors;
    Permutation perm(no, rank);
    MessageStreams::debug() << message::lock
			    << "computing interior facets ..." << std::endl
			    << message::unlock;
    do {
      Simplex simp(perm);
      if ((*_chiroptr)[simp] == FieldConstants::ZERO) {
	continue;
      }
      MessageStreams::debug() << message::lock
			      << "computing interior facets of " << simp << " in " << facets << " ..." << std::endl
			      << message::unlock;
      if (facets.contains(simp) || facets.contains_face(simp)) {
	continue;
      }
      Simplex facet(simp);
      for (Simplex::iterator iter = simp.begin(); iter != simp.end(); ++iter) {
	facet -= *iter;
	MessageStreams::debug() << message::lock
				<< "checking facet " << facet << " ..." << std::endl
				<< message::unlock;
	if (!facets.contains(facet) && !facets.contains_face(facet)) {
	  perm_interiors += facet;
	}
	MessageStreams::debug() << message::lock
				<< "... done." << std::endl
				<< message::unlock;
	facet += *iter;
      }
#ifdef COMPUTATIONS_DEBUG
      if (perm_interiors.empty()) {
	std::cerr << message::lock
		  << "InteriorFacets::InteriorFacets(const Facets&): "
		  << "no interior facet for " << simp << std::endl
		  << message::unlock;
      }
#endif
      (*this)[simp] = perm_interiors;
      perm_interiors.clear();
      if (++count % CommandlineOptions::report_frequency() == 0) {
	MessageStreams::verbose() << message::lock
				  << count << " simplices processed so far." << std::endl
				  << message::unlock;
      }
    } while (perm.lexnext());
    MessageStreams::debug() << message::lock
			    << "... done computation of interior facets." << std::endl
			    << message::unlock;

    // store the reverse map in _cofaces:
    for (interiorfacets_data::const_iterator ifiter = this->begin();
	 ifiter != this->end();
	 ++ifiter) {
#ifdef TOPCOM_CONTAINERS
      const Simplex& simp(ifiter->key());
      const SimplicialComplex& sc(ifiter->data());
#else
      const Simplex simp(ifiter->first);
      const SimplicialComplex sc(ifiter->second);
#endif
      for (SimplicialComplex::const_iterator sciter = sc.begin();
	   sciter != sc.end();
	   ++sciter) {
	const Simplex facet(*sciter);
	interiorfacets_data::iterator finditer = _cofaces.find(facet);
	MessageStreams::debug() << message::lock
				<< "mapping interior facet " << facet << " to simplex " << simp << std::endl
				<< message::unlock;
	if (finditer == _cofaces.end()) {
#ifdef TOPCOM_CONTAINERS
	  _cofaces.insert(facet, simp);
#else
	  _cofaces.insert(std::pair<Simplex, Simplex>(facet, simp));
#endif
	}
	else {
#ifdef TOPCOM_CONTAINERS
	  finditer->data() += simp;
#else
	  finditer->second += simp;
#endif
	}
      }
    }
    MessageStreams::debug() << message::lock
			    << "...done computation of cofaces map." << std::endl
			    << message::unlock;
    MessageStreams::debug() << message::lock
			    << "... done; table: " << *this << std::endl
			    << message::unlock;
  }

}; // namespace topcom

// eof InteriorFacets.cc
