## TFSA-2021-104: Null dereference in Grappler's `TrySimplify`

### CVE Number
CVE-2021-29616

### Impact
The implementation of
[`TrySimplify`](https://github.com/tensorflow/tensorflow/blob/c22d88d6ff33031aa113e48aa3fc9aa74ed79595/tensorflow/core/grappler/optimizers/arithmetic_optimizer.cc#L390-L401)
has undefined behavior due to dereferencing a null pointer in corner cases that
result in optimizing a node with no inputs.

### Patches
We have patched the issue in GitHub commit
[e6340f0665d53716ef3197ada88936c2a5f7a2d3](https://github.com/tensorflow/tensorflow/commit/e6340f0665d53716ef3197ada88936c2a5f7a2d3).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.
