/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_48 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 9871, "epsg", 9871,
        "MOLDOR11-IRF", 1, 1,
        "GRS 1980", "Greenwich",
        "MOLDOR11_Intermediate_Reference_Frame", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MOLDOR11-IRF\",DATUM[\"MOLDOR11_Intermediate_Re");
    add_srs_wkt (p, 1,
        "ference_Frame\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 3,
        "315\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 6,
        ",EAST],AUTHORITY[\"EPSG\",\"9871\"]]");
    p = add_epsg_def_ex (filter, first, last, 9874, "epsg", 9874,
        "PNG94 / PNGMG94 zone 57", 0, 0,
        "GRS 1980", "Greenwich",
        "Papua_New_Guinea_Geodetic_Datum_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PNG94 / PNGMG94 zone 57\",GEOGCS[\"PNG94\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Papua_New_Guinea_Geodetic_Datum_1994\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1076\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"5546\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",159],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "0000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9874\"]]");
    p = add_epsg_def_ex (filter, first, last, 9875, "epsg", 9875,
        "PNG94 / PNGMG94 zone 58", 0, 0,
        "GRS 1980", "Greenwich",
        "Papua_New_Guinea_Geodetic_Datum_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PNG94 / PNGMG94 zone 58\",GEOGCS[\"PNG94\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Papua_New_Guinea_Geodetic_Datum_1994\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1076\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"5546\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",165],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "0000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9875\"]]");
    p = add_epsg_def_ex (filter, first, last, 9880, "epsg", 9880,
        "MOLDOR11 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "MOLDOR11_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.35 +lon_0=-1.9 +k=1 +x_0=226574.20");
    add_proj4text (p, 1,
        "32 +y_0=390894.838 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MOLDOR11 Grid\",GEOGCS[\"MOLDOR11-IRF\",DATUM[\"");
    add_srs_wkt (p, 1,
        "MOLDOR11_Intermediate_Reference_Frame\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"1315\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9871\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",53.35],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-1.9],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",226574.2032],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",390894.838],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9880\"]]");
    p = add_epsg_def_ex (filter, first, last, 9881, "epsg", 9881,
        "MOLDOR11 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "MOLDOR11_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.35 +lon_0=-1.9 +k=1 +x_0=226574.20");
    add_proj4text (p, 1,
        "32 +y_0=390894.838 +ellps=GRS80 +units=m +geoidgrids=uk_");
    add_proj4text (p, 2,
        "os_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"MOLDOR11 Grid + ODN height\",PROJCS[\"MOLDOR1");
    add_srs_wkt (p, 1,
        "1 Grid\",GEOGCS[\"MOLDOR11-IRF\",DATUM[\"MOLDOR11_Interm");
    add_srs_wkt (p, 2,
        "ediate_Reference_Frame\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1315\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9871\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",53.35],PARAMETER[\"central_meridian\",-1.9],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "226574.2032],PARAMETER[\"false_northing\",390894.838],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9880\"]],VERT_CS[\"ODN height\",VERT_DATUM[\"Ordnance ");
    add_srs_wkt (p, 14,
        "Datum Newlyn\",2005,AUTHORITY[\"EPSG\",\"5101\"]],UNIT[\"");
    add_srs_wkt (p, 15,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-r");
    add_srs_wkt (p, 16,
        "elated height\",UP],AUTHORITY[\"EPSG\",\"5701\"]],AUTHOR");
    add_srs_wkt (p, 17,
        "ITY[\"EPSG\",\"9881\"]]");
    p = add_epsg_def_ex (filter, first, last, 9883, "epsg", 9883,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + CD Norway depth\",GEOGCS[\"ETRS89\",");
    add_srs_wkt (p, 1,
        "DATUM[\"European_Terrestrial_Reference_System_1989\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4258\"]],VERT_CS[\"CD Norway depth\",VERT_DATUM[");
    add_srs_wkt (p, 8,
        "\"Norwegian Chart Datum\",2005,AUTHORITY[\"EPSG\",\"1301");
    add_srs_wkt (p, 9,
        "\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 10,
        "[\"Depth\",DOWN],AUTHORITY[\"EPSG\",\"9672\"]],AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9883\"]]");
    p = add_epsg_def_ex (filter, first, last, 9893, "epsg", 9893,
        "LUREF", 1, 1,
        "International 1924", "Greenwich",
        "Luxembourg_Reference_Frame", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-189.6806,18.3463,-42");
    add_proj4text (p, 1,
        ".7695,-0.33746,-3.09264,2.53861,0.4598 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"LUREF\",DATUM[\"Luxembourg Reference Frame\",E");
    add_srs_wkt (p, 1,
        "LLIPSOID[\"International 1924\",6378388,297,LENGTHUNIT[\"");
    add_srs_wkt (p, 2,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 3,
        ",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic ");
    add_srs_wkt (p, 4,
        "latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433]],AXIS[\"geodetic longitude (Lon)\",east");
    add_srs_wkt (p, 6,
        ",ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 7,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 8,
        "re\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Luxembourg.\"]");
    add_srs_wkt (p, 9,
        ",BBOX[49.44,5.73,50.19,6.53]],ID[\"EPSG\",9893]]");
    p = add_epsg_def_ex (filter, first, last, 9897, "epsg", 9897,
        "LUREF / Luxembourg TM", 0, 0,
        "International 1924", "Greenwich",
        "Luxembourg_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=49.8333333333333 +lon_0=6.16666666666");
    add_proj4text (p, 1,
        "667 +k=1 +x_0=80000 +y_0=100000 +ellps=intl +towgs84=-18");
    add_proj4text (p, 2,
        "9.6806,18.3463,-42.7695,-0.33746,-3.09264,2.53861,0.4598");
    add_proj4text (p, 3,
        " +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"LUREF / Luxembourg TM + NG95 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"LUREF / Luxembourg TM\",GEOGCS[\"LUREF\",DATUM[\"Luxem");
    add_srs_wkt (p, 2,
        "bourg_Reference_Frame\",SPHEROID[\"International 1924\",");
    add_srs_wkt (p, 3,
        "6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6181\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4181\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",49.8333333333333],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",6.16666666666667],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",80000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",100000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"2169\"]],VERT_CS[\"NG95 height\",VERT_DATUM");
    add_srs_wkt (p, 14,
        "[\"Nivellement General du Luxembourg 1995\",2005,AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"5172\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 16,
        "\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHOR");
    add_srs_wkt (p, 17,
        "ITY[\"EPSG\",\"5774\"]],AUTHORITY[\"EPSG\",\"9897\"]]");
    p = add_epsg_def_ex (filter, first, last, 9907, "epsg", 9907,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=be_ign_hBG18.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + Ostend height\",GEOGCS[\"ETRS89\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"European_Terrestrial_Reference_System_1989\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4258\"]],VERT_CS[\"Ostend height\",VERT_DATUM[\"O");
    add_srs_wkt (p, 8,
        "stend\",2005,AUTHORITY[\"EPSG\",\"5110\"]],UNIT[\"metre\"");
    add_srs_wkt (p, 9,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related ");
    add_srs_wkt (p, 10,
        "height\",UP],AUTHORITY[\"EPSG\",\"5710\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9907\"]]");
    p = add_epsg_def_ex (filter, first, last, 9920, "epsg", 9920,
        "OSGB36 / British National Grid", 0, 0,
        "Airy 1830", "Greenwich",
        "Ordnance_Survey_of_Great_Britain_1936", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=49 +lon_0=-2 +k=0.9996012717 +x_0=400");
    add_proj4text (p, 1,
        "000 +y_0=-100000 +ellps=airy +units=m +geoidgrids=uk_os_");
    add_proj4text (p, 2,
        "OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"OSGB36 / British National Grid + BI height\",");
    add_srs_wkt (p, 1,
        "PROJCS[\"OSGB36 / British National Grid\",GEOGCS[\"OSGB3");
    add_srs_wkt (p, 2,
        "6\",DATUM[\"Ordnance_Survey_of_Great_Britain_1936\",SPHE");
    add_srs_wkt (p, 3,
        "ROID[\"Airy 1830\",6377563.396,299.3249646,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"7001\"]],AUTHORITY[\"EPSG\",\"6277\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4277\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",49],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-2],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "012717],PARAMETER[\"false_easting\",400000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",-100000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"27700\"]],VERT_CS[\"BI heig");
    add_srs_wkt (p, 14,
        "ht\",VERT_DATUM[\"British Isles height ensemble\",2005,A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"1288\"]],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 16,
        "\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],");
    add_srs_wkt (p, 17,
        "AUTHORITY[\"EPSG\",\"9451\"]],AUTHORITY[\"EPSG\",\"9920\"");
    add_srs_wkt (p, 18,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 9922, "epsg", 9922,
        "IRENET95 / Irish Transverse Mercator", 0, 0,
        "GRS 1980", "Greenwich",
        "IRENET95", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=0.99982 +x_0=600000");
    add_proj4text (p, 1,
        " +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +geoidgrids=uk_os_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / ITM + BI height\",PROJCS[\"IRENET95 ");
    add_srs_wkt (p, 1,
        "/ Irish Transverse Mercator\",GEOGCS[\"IRENET95\",DATUM[");
    add_srs_wkt (p, 2,
        "\"IRENET95\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6173");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4173\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",53");
    add_srs_wkt (p, 8,
        ".5],PARAMETER[\"central_meridian\",-8],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.99982],PARAMETER[\"false_easting\",600000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",750000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2157\"]],VERT_CS[");
    add_srs_wkt (p, 13,
        "\"BI height\",VERT_DATUM[\"British Isles height ensemble");
    add_srs_wkt (p, 14,
        "\",2005,AUTHORITY[\"EPSG\",\"1288\"]],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related heig");
    add_srs_wkt (p, 16,
        "ht\",UP],AUTHORITY[\"EPSG\",\"9451\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9922\"]]");
    p = add_epsg_def_ex (filter, first, last, 9924, "epsg", 9924,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + DHHN2016 height\",GEOGCS[\"ETRS89\",");
    add_srs_wkt (p, 1,
        "DATUM[\"European_Terrestrial_Reference_System_1989\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4258\"]],VERT_CS[\"DHHN2016 height\",VERT_DATUM[");
    add_srs_wkt (p, 8,
        "\"Deutsches Haupthoehennetz 2016\",2005,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 9,
        "\",\"1170\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 10,
        "\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"7837\"]],AUTHORITY[\"EPSG\",\"9924\"]]");
    p = add_epsg_def_ex (filter, first, last, 9928, "epsg", 9928,
        "DB_REF / 3-degree Gauss-Kruger zone 2 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF2003 zone 2\",PROJCS[\"DB_REF / 3-degre");
    add_srs_wkt (p, 1,
        "e Gauss-Kruger zone 2 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"");
    add_srs_wkt (p, 2,
        "Deutsche_Bahn_Reference_System\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 3,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "5681\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",2500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5682\"]");
    add_srs_wkt (p, 13,
        "],VERT_CS[\"GNTRANS height\",VERT_DATUM[\"GNTRANS\",2005");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"1316\"]],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP");
    add_srs_wkt (p, 16,
        "],AUTHORITY[\"EPSG\",\"9923\"]],AUTHORITY[\"EPSG\",\"992");
    add_srs_wkt (p, 17,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 9929, "epsg", 9929,
        "DB_REF / 3-degree Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF2003 zone 3\",PROJCS[\"DB_REF / 3-degre");
    add_srs_wkt (p, 1,
        "e Gauss-Kruger zone 3 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"");
    add_srs_wkt (p, 2,
        "Deutsche_Bahn_Reference_System\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 3,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "5681\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",3500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5683\"]");
    add_srs_wkt (p, 13,
        "],VERT_CS[\"GNTRANS height\",VERT_DATUM[\"GNTRANS\",2005");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"1316\"]],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP");
    add_srs_wkt (p, 16,
        "],AUTHORITY[\"EPSG\",\"9923\"]],AUTHORITY[\"EPSG\",\"992");
    add_srs_wkt (p, 17,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 9930, "epsg", 9930,
        "DB_REF / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF2003 zone 4\",PROJCS[\"DB_REF / 3-degre");
    add_srs_wkt (p, 1,
        "e Gauss-Kruger zone 4 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"");
    add_srs_wkt (p, 2,
        "Deutsche_Bahn_Reference_System\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 3,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "5681\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "2],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5684\"");
    add_srs_wkt (p, 13,
        "]],VERT_CS[\"GNTRANS height\",VERT_DATUM[\"GNTRANS\",200");
    add_srs_wkt (p, 14,
        "5,AUTHORITY[\"EPSG\",\"1316\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",U");
    add_srs_wkt (p, 16,
        "P],AUTHORITY[\"EPSG\",\"9923\"]],AUTHORITY[\"EPSG\",\"99");
    add_srs_wkt (p, 17,
        "30\"]]");
    p = add_epsg_def_ex (filter, first, last, 9931, "epsg", 9931,
        "DB_REF / 3-degree Gauss-Kruger zone 5 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF2003 zone 5\",PROJCS[\"DB_REF / 3-degre");
    add_srs_wkt (p, 1,
        "e Gauss-Kruger zone 5 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"");
    add_srs_wkt (p, 2,
        "Deutsche_Bahn_Reference_System\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 3,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "5681\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",5500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5685\"");
    add_srs_wkt (p, 13,
        "]],VERT_CS[\"GNTRANS height\",VERT_DATUM[\"GNTRANS\",200");
    add_srs_wkt (p, 14,
        "5,AUTHORITY[\"EPSG\",\"1316\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",U");
    add_srs_wkt (p, 16,
        "P],AUTHORITY[\"EPSG\",\"9923\"]],AUTHORITY[\"EPSG\",\"99");
    add_srs_wkt (p, 17,
        "31\"]]");
    p = add_epsg_def_ex (filter, first, last, 9932, "epsg", 9932,
        "DB_REF / 3-degree Gauss-Kruger zone 2 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF2016 zone 2\",PROJCS[\"DB_REF / 3-degre");
    add_srs_wkt (p, 1,
        "e Gauss-Kruger zone 2 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"");
    add_srs_wkt (p, 2,
        "Deutsche_Bahn_Reference_System\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 3,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "5681\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",2500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5682\"]");
    add_srs_wkt (p, 13,
        "],VERT_CS[\"GNTRANS2016 height\",VERT_DATUM[\"GNTRANS201");
    add_srs_wkt (p, 14,
        "6\",2005,AUTHORITY[\"EPSG\",\"1318\"]],UNIT[\"metre\",1,");
    add_srs_wkt (p, 15,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related hei");
    add_srs_wkt (p, 16,
        "ght\",UP],AUTHORITY[\"EPSG\",\"9927\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 17,
        "\",\"9932\"]]");
    p = add_epsg_def_ex (filter, first, last, 9933, "epsg", 9933,
        "DB_REF / 3-degree Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF2016 zone 3\",PROJCS[\"DB_REF / 3-degre");
    add_srs_wkt (p, 1,
        "e Gauss-Kruger zone 3 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"");
    add_srs_wkt (p, 2,
        "Deutsche_Bahn_Reference_System\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 3,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "5681\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",3500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5683\"]");
    add_srs_wkt (p, 13,
        "],VERT_CS[\"GNTRANS2016 height\",VERT_DATUM[\"GNTRANS201");
    add_srs_wkt (p, 14,
        "6\",2005,AUTHORITY[\"EPSG\",\"1318\"]],UNIT[\"metre\",1,");
    add_srs_wkt (p, 15,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related hei");
    add_srs_wkt (p, 16,
        "ght\",UP],AUTHORITY[\"EPSG\",\"9927\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 17,
        "\",\"9933\"]]");
    p = add_epsg_def_ex (filter, first, last, 9934, "epsg", 9934,
        "DB_REF / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF2016 zone 4\",PROJCS[\"DB_REF / 3-degre");
    add_srs_wkt (p, 1,
        "e Gauss-Kruger zone 4 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"");
    add_srs_wkt (p, 2,
        "Deutsche_Bahn_Reference_System\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 3,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "5681\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "2],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5684\"");
    add_srs_wkt (p, 13,
        "]],VERT_CS[\"GNTRANS2016 height\",VERT_DATUM[\"GNTRANS20");
    add_srs_wkt (p, 14,
        "16\",2005,AUTHORITY[\"EPSG\",\"1318\"]],UNIT[\"metre\",1");
    add_srs_wkt (p, 15,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related he");
    add_srs_wkt (p, 16,
        "ight\",UP],AUTHORITY[\"EPSG\",\"9927\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 17,
        "G\",\"9934\"]]");
    p = add_epsg_def_ex (filter, first, last, 9935, "epsg", 9935,
        "DB_REF / 3-degree Gauss-Kruger zone 5 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF2016 zone 5\",PROJCS[\"DB_REF / 3-degre");
    add_srs_wkt (p, 1,
        "e Gauss-Kruger zone 5 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"");
    add_srs_wkt (p, 2,
        "Deutsche_Bahn_Reference_System\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 3,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "5681\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",5500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5685\"");
    add_srs_wkt (p, 13,
        "]],VERT_CS[\"GNTRANS2016 height\",VERT_DATUM[\"GNTRANS20");
    add_srs_wkt (p, 14,
        "16\",2005,AUTHORITY[\"EPSG\",\"1318\"]],UNIT[\"metre\",1");
    add_srs_wkt (p, 15,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related he");
    add_srs_wkt (p, 16,
        "ight\",UP],AUTHORITY[\"EPSG\",\"9927\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 17,
        "G\",\"9935\"]]");
    p = add_epsg_def_ex (filter, first, last, 9939, "epsg", 9939,
        "EBBWV14-IRF", 1, 1,
        "GRS 1980", "Greenwich",
        "EBBWV14_Intermediate_Reference_Frame", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"EBBWV14-IRF\",DATUM[\"EBBWV14_Intermediate_Refe");
    add_srs_wkt (p, 1,
        "rence_Frame\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"131");
    add_srs_wkt (p, 3,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"9939\"]]");
    p = add_epsg_def_ex (filter, first, last, 9943, "epsg", 9943,
        "EBBWV14 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "EBBWV14_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=51.75 +lon_0=-3.1 +k=1 +x_0=106702.32");
    add_proj4text (p, 1,
        "6 +y_0=119968.1395 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"EBBWV14 Grid\",GEOGCS[\"EBBWV14-IRF\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "BBWV14_Intermediate_Reference_Frame\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"1319\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9939\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",51.75],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-3.1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",106702.326],PARAMETER[\"false_northing\",1199");
    add_srs_wkt (p, 10,
        "68.1395],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9943\"]]");
    p = add_epsg_def_ex (filter, first, last, 9944, "epsg", 9944,
        "EBBWV14 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "EBBWV14_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=51.75 +lon_0=-3.1 +k=1 +x_0=106702.32");
    add_proj4text (p, 1,
        "6 +y_0=119968.1395 +ellps=GRS80 +units=m +geoidgrids=uk_");
    add_proj4text (p, 2,
        "os_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"EBBWV14 Grid + ODN height\",PROJCS[\"EBBWV14 ");
    add_srs_wkt (p, 1,
        "Grid\",GEOGCS[\"EBBWV14-IRF\",DATUM[\"EBBWV14_Intermedia");
    add_srs_wkt (p, 2,
        "te_Reference_Frame\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1319\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9939\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",51.75],PARAMETER[\"central_meridian\",-3.1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",10670");
    add_srs_wkt (p, 10,
        "2.326],PARAMETER[\"false_northing\",119968.1395],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"994");
    add_srs_wkt (p, 13,
        "3\"]],VERT_CS[\"ODN height\",VERT_DATUM[\"Ordnance Datum");
    add_srs_wkt (p, 14,
        " Newlyn\",2005,AUTHORITY[\"EPSG\",\"5101\"]],UNIT[\"metr");
    add_srs_wkt (p, 15,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-relat");
    add_srs_wkt (p, 16,
        "ed height\",UP],AUTHORITY[\"EPSG\",\"5701\"]],AUTHORITY[");
    add_srs_wkt (p, 17,
        "\"EPSG\",\"9944\"]]");
    p = add_epsg_def_ex (filter, first, last, 20004, "epsg", 20004,
        "Pulkovo 1995 / Gauss-Kruger zone 4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 4\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20004\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 20005, "epsg", 20005,
        "Pulkovo 1995 / Gauss-Kruger zone 5", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 5\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",5500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20005\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 20006, "epsg", 20006,
        "Pulkovo 1995 / Gauss-Kruger zone 6", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 6\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",6500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20006\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 20007, "epsg", 20007,
        "Pulkovo 1995 / Gauss-Kruger zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 7\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",7500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20007\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 20008, "epsg", 20008,
        "Pulkovo 1995 / Gauss-Kruger zone 8", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 8\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",8500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20008\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 20009, "epsg", 20009,
        "Pulkovo 1995 / Gauss-Kruger zone 9", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 9\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",9500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20009\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 20010, "epsg", 20010,
        "Pulkovo 1995 / Gauss-Kruger zone 10", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 10\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",10500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20010");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20011, "epsg", 20011,
        "Pulkovo 1995 / Gauss-Kruger zone 11", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 11\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",11500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20011");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20012, "epsg", 20012,
        "Pulkovo 1995 / Gauss-Kruger zone 12", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 12\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",12500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20012");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20013, "epsg", 20013,
        "Pulkovo 1995 / Gauss-Kruger zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 13\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",13500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20013");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20014, "epsg", 20014,
        "Pulkovo 1995 / Gauss-Kruger zone 14", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",14500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20014");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20015, "epsg", 20015,
        "Pulkovo 1995 / Gauss-Kruger zone 15", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 15\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",15500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20015");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20016, "epsg", 20016,
        "Pulkovo 1995 / Gauss-Kruger zone 16", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",16500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20016");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20017, "epsg", 20017,
        "Pulkovo 1995 / Gauss-Kruger zone 17", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 17\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",17500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20017");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20018, "epsg", 20018,
        "Pulkovo 1995 / Gauss-Kruger zone 18", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",18500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2001");
    add_srs_wkt (p, 12,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 20019, "epsg", 20019,
        "Pulkovo 1995 / Gauss-Kruger zone 19", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 19\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",19500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2001");
    add_srs_wkt (p, 12,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 20020, "epsg", 20020,
        "Pulkovo 1995 / Gauss-Kruger zone 20", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",20500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 20021, "epsg", 20021,
        "Pulkovo 1995 / Gauss-Kruger zone 21", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 21\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",21500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 20022, "epsg", 20022,
        "Pulkovo 1995 / Gauss-Kruger zone 22", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 22\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",22500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 20023, "epsg", 20023,
        "Pulkovo 1995 / Gauss-Kruger zone 23", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 23\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",23500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 20024, "epsg", 20024,
        "Pulkovo 1995 / Gauss-Kruger zone 24", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=24500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 24\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "41],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",24500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 20025, "epsg", 20025,
        "Pulkovo 1995 / Gauss-Kruger zone 25", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=25500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 25\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "47],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",25500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 20026, "epsg", 20026,
        "Pulkovo 1995 / Gauss-Kruger zone 26", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=26500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 26\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "53],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",26500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 20027, "epsg", 20027,
        "Pulkovo 1995 / Gauss-Kruger zone 27", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=27500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 27\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "59],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",27500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "7\"]]");
    p = add_epsg_def_ex (filter, first, last, 20028, "epsg", 20028,
        "Pulkovo 1995 / Gauss-Kruger zone 28", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=28500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 28\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "65],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",28500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 20029, "epsg", 20029,
        "Pulkovo 1995 / Gauss-Kruger zone 29", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=29500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 29\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "71],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",29500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 20030, "epsg", 20030,
        "Pulkovo 1995 / Gauss-Kruger zone 30", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=30500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 30\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "77],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",30500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2003");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 20031, "epsg", 20031,
        "Pulkovo 1995 / Gauss-Kruger zone 31", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=31500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-");
    add_proj4text (p, 2,
        "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 31\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "177],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",31500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2003");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 20032, "epsg", 20032,
        "Pulkovo 1995 / Gauss-Kruger zone 32", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=32500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-");
    add_proj4text (p, 2,
        "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 32\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "171],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",32500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2003");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 20064, "epsg", 20064,
        "Pulkovo 1995 / Gauss-Kruger 4N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 4N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",21],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "20064\"]]");
    p = add_epsg_def_ex (filter, first, last, 20065, "epsg", 20065,
        "Pulkovo 1995 / Gauss-Kruger 5N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 5N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",27],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "20065\"]]");
    p = add_epsg_def_ex (filter, first, last, 20066, "epsg", 20066,
        "Pulkovo 1995 / Gauss-Kruger 6N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 6N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",33],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "20066\"]]");
    p = add_epsg_def_ex (filter, first, last, 20067, "epsg", 20067,
        "Pulkovo 1995 / Gauss-Kruger 7N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 7N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",39],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "20067\"]]");
    p = add_epsg_def_ex (filter, first, last, 20068, "epsg", 20068,
        "Pulkovo 1995 / Gauss-Kruger 8N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 8N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",45],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "20068\"]]");
    p = add_epsg_def_ex (filter, first, last, 20069, "epsg", 20069,
        "Pulkovo 1995 / Gauss-Kruger 9N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 9N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",51],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "20069\"]]");
    p = add_epsg_def_ex (filter, first, last, 20070, "epsg", 20070,
        "Pulkovo 1995 / Gauss-Kruger 10N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 10N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",57],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20070\"]]");
    p = add_epsg_def_ex (filter, first, last, 20071, "epsg", 20071,
        "Pulkovo 1995 / Gauss-Kruger 11N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 11N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",63],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20071\"]]");
    p = add_epsg_def_ex (filter, first, last, 20072, "epsg", 20072,
        "Pulkovo 1995 / Gauss-Kruger 12N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 12N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",69],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20072\"]]");
    p = add_epsg_def_ex (filter, first, last, 20073, "epsg", 20073,
        "Pulkovo 1995 / Gauss-Kruger 13N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 13N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",75],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20073\"]]");
    p = add_epsg_def_ex (filter, first, last, 20074, "epsg", 20074,
        "Pulkovo 1995 / Gauss-Kruger 14N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 14N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",81],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20074\"]]");
    p = add_epsg_def_ex (filter, first, last, 20075, "epsg", 20075,
        "Pulkovo 1995 / Gauss-Kruger 15N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 15N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",87],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20075\"]]");
    p = add_epsg_def_ex (filter, first, last, 20076, "epsg", 20076,
        "Pulkovo 1995 / Gauss-Kruger 16N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 16N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",93],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20076\"]]");
    p = add_epsg_def_ex (filter, first, last, 20077, "epsg", 20077,
        "Pulkovo 1995 / Gauss-Kruger 17N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 17N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",99],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20077\"]]");
    p = add_epsg_def_ex (filter, first, last, 20078, "epsg", 20078,
        "Pulkovo 1995 / Gauss-Kruger 18N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 18N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",105],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20078\"]]");
    p = add_epsg_def_ex (filter, first, last, 20079, "epsg", 20079,
        "Pulkovo 1995 / Gauss-Kruger 19N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 19N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",111],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20079\"]]");
    p = add_epsg_def_ex (filter, first, last, 20080, "epsg", 20080,
        "Pulkovo 1995 / Gauss-Kruger 20N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 20N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",117],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20080\"]]");
    p = add_epsg_def_ex (filter, first, last, 20081, "epsg", 20081,
        "Pulkovo 1995 / Gauss-Kruger 21N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 21N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",123],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20081\"]]");
    p = add_epsg_def_ex (filter, first, last, 20082, "epsg", 20082,
        "Pulkovo 1995 / Gauss-Kruger 22N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 22N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",129],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20082\"]]");
    p = add_epsg_def_ex (filter, first, last, 20083, "epsg", 20083,
        "Pulkovo 1995 / Gauss-Kruger 23N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 23N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",135],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20083\"]]");
    p = add_epsg_def_ex (filter, first, last, 20084, "epsg", 20084,
        "Pulkovo 1995 / Gauss-Kruger 24N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 24N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",141],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20084\"]]");
    p = add_epsg_def_ex (filter, first, last, 20085, "epsg", 20085,
        "Pulkovo 1995 / Gauss-Kruger 25N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 25N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",147],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20085\"]]");
    p = add_epsg_def_ex (filter, first, last, 20086, "epsg", 20086,
        "Pulkovo 1995 / Gauss-Kruger 26N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 26N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",153],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20086\"]]");
    p = add_epsg_def_ex (filter, first, last, 20087, "epsg", 20087,
        "Pulkovo 1995 / Gauss-Kruger 27N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 27N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",159],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20087\"]]");
    p = add_epsg_def_ex (filter, first, last, 20088, "epsg", 20088,
        "Pulkovo 1995 / Gauss-Kruger 28N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 28N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",165],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20088\"]]");
    p = add_epsg_def_ex (filter, first, last, 20089, "epsg", 20089,
        "Pulkovo 1995 / Gauss-Kruger 29N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 29N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",171],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20089\"]]");
    p = add_epsg_def_ex (filter, first, last, 20090, "epsg", 20090,
        "Pulkovo 1995 / Gauss-Kruger 30N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 30N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",177],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20090\"]]");
    p = add_epsg_def_ex (filter, first, last, 20091, "epsg", 20091,
        "Pulkovo 1995 / Gauss-Kruger 31N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 31N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-177],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20091\"]]");
    p = add_epsg_def_ex (filter, first, last, 20092, "epsg", 20092,
        "Pulkovo 1995 / Gauss-Kruger 32N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 32N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-171],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20092\"]]");
    p = add_epsg_def_ex (filter, first, last, 20135, "epsg", 20135,
        "Adindan / UTM zone 35N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=clrk80 +towgs84=-166,-15,204,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Adindan / UTM zone 35N\",GEOGCS[\"Adindan\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Adindan\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6201\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4201\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",27],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"20135\"]]");
    p = add_epsg_def_ex (filter, first, last, 20136, "epsg", 20136,
        "Adindan / UTM zone 36N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=clrk80 +towgs84=-166,-15,204,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Adindan / UTM zone 36N\",GEOGCS[\"Adindan\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Adindan\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6201\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4201\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",33],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"20136\"]]");
    p = add_epsg_def_ex (filter, first, last, 20137, "epsg", 20137,
        "Adindan / UTM zone 37N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=clrk80 +towgs84=-166,-15,204,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Adindan / UTM zone 37N\",GEOGCS[\"Adindan\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Adindan\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6201\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4201\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",39],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"20137\"]]");
    p = add_epsg_def_ex (filter, first, last, 20138, "epsg", 20138,
        "Adindan / UTM zone 38N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=clrk80 +towgs84=-166,-15,204,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Adindan / UTM zone 38N\",GEOGCS[\"Adindan\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Adindan\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6201\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4201\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",45],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"20138\"]]");
    p = add_epsg_def_ex (filter, first, last, 20248, "epsg", 20248,
        "AGD66 / AMG zone 48 (deprecated)", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 48 (deprecated)\",GEOGCS[\"AGD");
    add_srs_wkt (p, 1,
        "66\",DATUM[\"Australian_Geodetic_Datum_1966\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Australian National Spheroid\",6378160,298.25,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7003\"]],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4202\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",105],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"20248\"]]");
    p = add_epsg_def_ex (filter, first, last, 20249, "epsg", 20249,
        "AGD66 / AMG zone 49", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 49\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",111],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20249\"]]");
    p = add_epsg_def_ex (filter, first, last, 20250, "epsg", 20250,
        "AGD66 / AMG zone 50", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 50\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",117],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20250\"]]");
    p = add_epsg_def_ex (filter, first, last, 20251, "epsg", 20251,
        "AGD66 / AMG zone 51", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 51\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",123],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20251\"]]");
    p = add_epsg_def_ex (filter, first, last, 20252, "epsg", 20252,
        "AGD66 / AMG zone 52", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 52\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",129],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20252\"]]");
    p = add_epsg_def_ex (filter, first, last, 20253, "epsg", 20253,
        "AGD66 / AMG zone 53", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 53\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",135],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20253\"]]");
    p = add_epsg_def_ex (filter, first, last, 20254, "epsg", 20254,
        "AGD66 / AMG zone 54", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 54\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",141],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20254\"]]");
    p = add_epsg_def_ex (filter, first, last, 20255, "epsg", 20255,
        "AGD66 / AMG zone 55", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 55\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",147],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20255\"]]");
    p = add_epsg_def_ex (filter, first, last, 20256, "epsg", 20256,
        "AGD66 / AMG zone 56", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 56\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",153],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20256\"]]");
    p = add_epsg_def_ex (filter, first, last, 20257, "epsg", 20257,
        "AGD66 / AMG zone 57", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 57\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",159],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20257\"]]");
    p = add_epsg_def_ex (filter, first, last, 20258, "epsg", 20258,
        "AGD66 / AMG zone 58", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 58\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",165],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20258\"]]");
    p = add_epsg_def_ex (filter, first, last, 20348, "epsg", 20348,
        "AGD84 / AMG zone 48 (deprecated)", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 48 (deprecated)\",GEOGCS[\"AGD");
    add_srs_wkt (p, 1,
        "84\",DATUM[\"Australian_Geodetic_Datum_1984\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Australian National Spheroid\",6378160,298.25,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7003\"]],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4203\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",105],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"20348\"]]");
    p = add_epsg_def_ex (filter, first, last, 20349, "epsg", 20349,
        "AGD84 / AMG zone 49", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 49\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",111],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20349\"]]");
    p = add_epsg_def_ex (filter, first, last, 20350, "epsg", 20350,
        "AGD84 / AMG zone 50", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 50\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",117],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20350\"]]");
    p = add_epsg_def_ex (filter, first, last, 20351, "epsg", 20351,
        "AGD84 / AMG zone 51", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 51\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",123],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20351\"]]");
    p = add_epsg_def_ex (filter, first, last, 20352, "epsg", 20352,
        "AGD84 / AMG zone 52", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 52\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",129],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20352\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

