
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <XCAFNoteObjects_NoteObject.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_XCAFNoteObjects(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("XCAFNoteObjects"));
py::object klass;

//Python trampoline classes

// classes

    // Class XCAFNoteObjects_NoteObject from ./opencascade/XCAFNoteObjects_NoteObject.hxx
    klass = m.attr("XCAFNoteObjects_NoteObject");


    // nested enums

    static_cast<py::class_<XCAFNoteObjects_NoteObject ,opencascade::handle<XCAFNoteObjects_NoteObject>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<XCAFNoteObjects_NoteObject> & >()  , py::arg("theObj") )
    // custom constructors
    // methods
        .def("HasPlane",
             (Standard_Boolean (XCAFNoteObjects_NoteObject::*)() const) static_cast<Standard_Boolean (XCAFNoteObjects_NoteObject::*)() const>(&XCAFNoteObjects_NoteObject::HasPlane),
             R"#(Returns True if plane is specified)#" 
          )
        .def("SetPlane",
             (void (XCAFNoteObjects_NoteObject::*)( const gp_Ax2 &  ) ) static_cast<void (XCAFNoteObjects_NoteObject::*)( const gp_Ax2 &  ) >(&XCAFNoteObjects_NoteObject::SetPlane),
             R"#(Sets a right-handed coordinate system of the plane)#"  , py::arg("thePlane")
          )
        .def("HasPoint",
             (Standard_Boolean (XCAFNoteObjects_NoteObject::*)() const) static_cast<Standard_Boolean (XCAFNoteObjects_NoteObject::*)() const>(&XCAFNoteObjects_NoteObject::HasPoint),
             R"#(Returns True if the attachment point on the annotated object is specified)#" 
          )
        .def("SetPoint",
             (void (XCAFNoteObjects_NoteObject::*)( const gp_Pnt &  ) ) static_cast<void (XCAFNoteObjects_NoteObject::*)( const gp_Pnt &  ) >(&XCAFNoteObjects_NoteObject::SetPoint),
             R"#(Sets the anchor point on the annotated object)#"  , py::arg("thePnt")
          )
        .def("HasPointText",
             (Standard_Boolean (XCAFNoteObjects_NoteObject::*)() const) static_cast<Standard_Boolean (XCAFNoteObjects_NoteObject::*)() const>(&XCAFNoteObjects_NoteObject::HasPointText),
             R"#(Returns True if the text position is specified)#" 
          )
        .def("SetPointText",
             (void (XCAFNoteObjects_NoteObject::*)( const gp_Pnt &  ) ) static_cast<void (XCAFNoteObjects_NoteObject::*)( const gp_Pnt &  ) >(&XCAFNoteObjects_NoteObject::SetPointText),
             R"#(Sets the text position)#"  , py::arg("thePnt")
          )
        .def("SetPresentation",
             (void (XCAFNoteObjects_NoteObject::*)( const TopoDS_Shape &  ) ) static_cast<void (XCAFNoteObjects_NoteObject::*)( const TopoDS_Shape &  ) >(&XCAFNoteObjects_NoteObject::SetPresentation),
             R"#(Sets a tessellated annotation)#"  , py::arg("thePresentation")
          )
        .def("Reset",
             (void (XCAFNoteObjects_NoteObject::*)() ) static_cast<void (XCAFNoteObjects_NoteObject::*)() >(&XCAFNoteObjects_NoteObject::Reset),
             R"#(Resets data to the state after calling the default constructor)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFNoteObjects_NoteObject::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFNoteObjects_NoteObject::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFNoteObjects_NoteObject::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFNoteObjects_NoteObject::*)() const>(&XCAFNoteObjects_NoteObject::DynamicType),
             R"#(None)#"
             
         )
       .def("GetPlane",
             (const gp_Ax2 & (XCAFNoteObjects_NoteObject::*)() const) static_cast<const gp_Ax2 & (XCAFNoteObjects_NoteObject::*)() const>(&XCAFNoteObjects_NoteObject::GetPlane),
             R"#(Returns a right-handed coordinate system of the plane)#"
             
         )
       .def("GetPoint",
             (const gp_Pnt & (XCAFNoteObjects_NoteObject::*)() const) static_cast<const gp_Pnt & (XCAFNoteObjects_NoteObject::*)() const>(&XCAFNoteObjects_NoteObject::GetPoint),
             R"#(Returns the attachment point on the annotated object)#"
             
         )
       .def("GetPointText",
             (const gp_Pnt & (XCAFNoteObjects_NoteObject::*)() const) static_cast<const gp_Pnt & (XCAFNoteObjects_NoteObject::*)() const>(&XCAFNoteObjects_NoteObject::GetPointText),
             R"#(Returns the text position)#"
             
         )
       .def("GetPresentation",
             (const TopoDS_Shape & (XCAFNoteObjects_NoteObject::*)() const) static_cast<const TopoDS_Shape & (XCAFNoteObjects_NoteObject::*)() const>(&XCAFNoteObjects_NoteObject::GetPresentation),
             R"#(Returns a tessellated annotation if specified)#"
             
         )
;

// functions
// ./opencascade/XCAFNoteObjects_NoteObject.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
