# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.privatedns.aio import PrivateDnsManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPrivateDnsManagementRecordSetsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PrivateDnsManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_create_or_update(self, resource_group):
        response = await self.client.record_sets.create_or_update(
            resource_group_name=resource_group.name,
            private_zone_name="str",
            record_type="str",
            relative_record_set_name="str",
            parameters={
                "aRecords": [{"ipv4Address": "str"}],
                "aaaaRecords": [{"ipv6Address": "str"}],
                "cnameRecord": {"cname": "str"},
                "etag": "str",
                "fqdn": "str",
                "id": "str",
                "isAutoRegistered": bool,
                "metadata": {"str": "str"},
                "mxRecords": [{"exchange": "str", "preference": 0}],
                "name": "str",
                "ptrRecords": [{"ptrdname": "str"}],
                "soaRecord": {
                    "email": "str",
                    "expireTime": 0,
                    "host": "str",
                    "minimumTtl": 0,
                    "refreshTime": 0,
                    "retryTime": 0,
                    "serialNumber": 0,
                },
                "srvRecords": [{"port": 0, "priority": 0, "target": "str", "weight": 0}],
                "ttl": 0,
                "txtRecords": [{"value": ["str"]}],
                "type": "str",
            },
            api_version="2024-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_update(self, resource_group):
        response = await self.client.record_sets.update(
            resource_group_name=resource_group.name,
            private_zone_name="str",
            record_type="str",
            relative_record_set_name="str",
            parameters={
                "aRecords": [{"ipv4Address": "str"}],
                "aaaaRecords": [{"ipv6Address": "str"}],
                "cnameRecord": {"cname": "str"},
                "etag": "str",
                "fqdn": "str",
                "id": "str",
                "isAutoRegistered": bool,
                "metadata": {"str": "str"},
                "mxRecords": [{"exchange": "str", "preference": 0}],
                "name": "str",
                "ptrRecords": [{"ptrdname": "str"}],
                "soaRecord": {
                    "email": "str",
                    "expireTime": 0,
                    "host": "str",
                    "minimumTtl": 0,
                    "refreshTime": 0,
                    "retryTime": 0,
                    "serialNumber": 0,
                },
                "srvRecords": [{"port": 0, "priority": 0, "target": "str", "weight": 0}],
                "ttl": 0,
                "txtRecords": [{"value": ["str"]}],
                "type": "str",
            },
            api_version="2024-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delete(self, resource_group):
        response = await self.client.record_sets.delete(
            resource_group_name=resource_group.name,
            private_zone_name="str",
            record_type="str",
            relative_record_set_name="str",
            api_version="2024-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.record_sets.get(
            resource_group_name=resource_group.name,
            private_zone_name="str",
            record_type="str",
            relative_record_set_name="str",
            api_version="2024-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_type(self, resource_group):
        response = self.client.record_sets.list_by_type(
            resource_group_name=resource_group.name,
            private_zone_name="str",
            record_type="str",
            api_version="2024-06-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = self.client.record_sets.list(
            resource_group_name=resource_group.name,
            private_zone_name="str",
            api_version="2024-06-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
