# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource.templatespecs.v2022_02_01.aio import TemplateSpecsClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestTemplateSpecsTemplateSpecsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(TemplateSpecsClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_template_specs_create_or_update(self, resource_group):
        response = await self.client.template_specs.create_or_update(
            resource_group_name=resource_group.name,
            template_spec_name="str",
            template_spec={
                "location": "str",
                "description": "str",
                "displayName": "str",
                "id": "str",
                "metadata": {},
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "versions": {
                    "str": {
                        "description": "str",
                        "timeCreated": "2020-02-20 00:00:00",
                        "timeModified": "2020-02-20 00:00:00",
                    }
                },
            },
            api_version="2022-02-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_template_specs_update(self, resource_group):
        response = await self.client.template_specs.update(
            resource_group_name=resource_group.name,
            template_spec_name="str",
            api_version="2022-02-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_template_specs_get(self, resource_group):
        response = await self.client.template_specs.get(
            resource_group_name=resource_group.name,
            template_spec_name="str",
            api_version="2022-02-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_template_specs_delete(self, resource_group):
        response = await self.client.template_specs.delete(
            resource_group_name=resource_group.name,
            template_spec_name="str",
            api_version="2022-02-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_template_specs_list_by_subscription(self, resource_group):
        response = self.client.template_specs.list_by_subscription(
            api_version="2022-02-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_template_specs_list_by_resource_group(self, resource_group):
        response = self.client.template_specs.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2022-02-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_template_specs_get_built_in(self, resource_group):
        response = await self.client.template_specs.get_built_in(
            template_spec_name="str",
            api_version="2022-02-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_template_specs_list_built_ins(self, resource_group):
        response = self.client.template_specs.list_built_ins(
            api_version="2022-02-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
