/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service;

import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.chefproject.core.Notification;
import org.chefproject.core.NotificationEdit;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.InUseException;
import org.chefproject.service.generic.GenericNotificationService;

public class NotificationService {
    protected static GenericNotificationService M_service = null;

    protected static void find() {
        if (M_service == null && (M_service = (GenericNotificationService)((Object)TurbineServices.getInstance().getService(GenericNotificationService.SERVICE_NAME))) == null) {
            Log.warn("chef", "NotificationService.find: missing service: " + GenericNotificationService.SERVICE_NAME);
        }
    }

    public static GenericNotificationService getInstance() {
        NotificationService.find();
        return M_service;
    }

    public static NotificationEdit addNotification() {
        NotificationService.find();
        return M_service.addNotification();
    }

    public static Notification getNotification(String id) throws IdUnusedException {
        NotificationService.find();
        return M_service.getNotification(id);
    }

    public static NotificationEdit editNotification(String id) throws IdUnusedException, InUseException {
        NotificationService.find();
        return M_service.editNotification(id);
    }

    public static void commitEdit(NotificationEdit notification) {
        NotificationService.find();
        M_service.commitEdit(notification);
    }

    public static void cancelEdit(NotificationEdit notification) {
        NotificationService.find();
        M_service.cancelEdit(notification);
    }

    public static void removeNotification(NotificationEdit notification) {
        NotificationService.find();
        M_service.removeNotification(notification);
    }

    public static String notificationReference(String id) {
        NotificationService.find();
        return M_service.notificationReference(id);
    }
}

