#!/usr/bin/env bash

include './src/plugins/kernel_install/utils.sh'
include './src/plugins/kernel_install/fedora.sh'
include './src/lib/kwio.sh'
include './src/lib/kwlib.sh'
include './tests/unit/utils.sh'

function setUp()
{
  mk_fake_boot "$SHUNIT_TMPDIR"
}

function tearDown()
{
  rm -rf "$SHUNIT_TMPDIR"
}

function test_update_fedora_boot_loader()
{

  declare -a cmd_sequence=(
    'grub2-editenv - unset menu_auto_hide'
    'sed --in-place --expression='\'s/GRUB_ENABLE_BLSCFG=true/GRUB_ENABLE_BLSCFG=false/g\'' /etc/default/grub'
    'dracut --force --kver xpto'
  )

  output=$(generate_fedora_temporary_root_file_system 'TEST_MODE' 'xpto' '' 'GRUB')
  compare_command_sequence 'Check simple flow' "$LINENO" 'cmd_sequence' "$output"

  declare -a cmd_sequence=(
    'sudo --preserve-env grub2-editenv - unset menu_auto_hide'
    'sudo --preserve-env sed --in-place --expression='\'s/GRUB_ENABLE_BLSCFG=true/GRUB_ENABLE_BLSCFG=false/g\'' /etc/default/grub'
    'sudo --preserve-env dracut --force --kver xpto'
  )

  output=$(generate_fedora_temporary_root_file_system 'TEST_MODE' 'xpto' 'local' 'GRUB')
  compare_command_sequence 'Check local deploy' "$LINENO" 'cmd_sequence' "$output"
}

invoke_shunit
