
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractItemDelegate.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAbstractItemDelegate>
#include <QAbstractItemModel>
#include <QAbstractItemView>
#include <QChildEvent>
#include <QEvent>
#include <QFontMetrics>
#include <QHelpEvent>
#include <QMetaMethod>
#include <QModelIndex>
#include <QObject>
#include <QPainter>
#include <QSize>
#include <QStyleOptionViewItem>
#include <QThread>
#include <QTimerEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractItemDelegate

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractItemDelegate::staticMetaObject);
}


// QWidget *QAbstractItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_createEditor_c6860 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QWidget * > ();
}

static void _call_f_createEditor_c6860 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QStyleOptionViewItem &arg2 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QWidget * > ((QWidget *)((QAbstractItemDelegate *)cls)->createEditor (arg1, arg2, arg3));
}


// void QAbstractItemDelegate::destroyEditor(QWidget *editor, const QModelIndex &index)


static void _init_f_destroyEditor_c3602 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_destroyEditor_c3602 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractItemDelegate *)cls)->destroyEditor (arg1, arg2);
}


// bool QAbstractItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_editorEvent_9073 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("index");
  decl->add_arg<const QModelIndex & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_editorEvent_9073 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = gsi::arg_reader<QEvent * >() (args, heap);
  QAbstractItemModel *arg2 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  const QStyleOptionViewItem &arg3 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractItemDelegate *)cls)->editorEvent (arg1, arg2, arg3, arg4));
}


// bool QAbstractItemDelegate::helpEvent(QHelpEvent *event, QAbstractItemView *view, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_helpEvent_9380 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHelpEvent * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("view");
  decl->add_arg<QAbstractItemView * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("index");
  decl->add_arg<const QModelIndex & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_helpEvent_9380 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHelpEvent *arg1 = gsi::arg_reader<QHelpEvent * >() (args, heap);
  QAbstractItemView *arg2 = gsi::arg_reader<QAbstractItemView * >() (args, heap);
  const QStyleOptionViewItem &arg3 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractItemDelegate *)cls)->helpEvent (arg1, arg2, arg3, arg4));
}


// void QAbstractItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_paint_c6971 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_paint_c6971 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QStyleOptionViewItem &arg2 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractItemDelegate *)cls)->paint (arg1, arg2, arg3);
}


// QVector<int> QAbstractItemDelegate::paintingRoles()


static void _init_f_paintingRoles_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVector<int> > ();
}

static void _call_f_paintingRoles_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVector<int> > ((QVector<int>)((QAbstractItemDelegate *)cls)->paintingRoles ());
}


// void QAbstractItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)


static void _init_f_setEditorData_c3602 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setEditorData_c3602 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractItemDelegate *)cls)->setEditorData (arg1, arg2);
}


// void QAbstractItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)


static void _init_f_setModelData_c5913 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setModelData_c5913 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  QAbstractItemModel *arg2 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractItemDelegate *)cls)->setModelData (arg1, arg2, arg3);
}


// QSize QAbstractItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_sizeHint_c5653 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c5653 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStyleOptionViewItem &arg1 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QSize > ((QSize)((QAbstractItemDelegate *)cls)->sizeHint (arg1, arg2));
}


// void QAbstractItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_updateEditorGeometry_c6860 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_updateEditorGeometry_c6860 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QStyleOptionViewItem &arg2 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractItemDelegate *)cls)->updateEditorGeometry (arg1, arg2, arg3);
}


// static QString QAbstractItemDelegate::elidedText(const QFontMetrics &fontMetrics, int width, Qt::TextElideMode mode, const QString &text)


static void _init_f_elidedText_7038 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fontMetrics");
  decl->add_arg<const QFontMetrics & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("width");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::TextElideMode>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("text");
  decl->add_arg<const QString & > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_f_elidedText_7038 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFontMetrics &arg1 = gsi::arg_reader<const QFontMetrics & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::TextElideMode>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<Qt::TextElideMode>::target_type & >() (args, heap);
  const QString &arg4 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)QAbstractItemDelegate::elidedText (arg1, arg2, qt_gsi::QtToCppAdaptor<Qt::TextElideMode>(arg3).cref(), arg4));
}


// static QString QAbstractItemDelegate::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractItemDelegate::tr (arg1, arg2, arg3));
}


// static QString QAbstractItemDelegate::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractItemDelegate::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAbstractItemDelegate () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("createEditor", "@brief Method QWidget *QAbstractItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)\n", true, &_init_f_createEditor_c6860, &_call_f_createEditor_c6860);
  methods += new qt_gsi::GenericMethod ("destroyEditor", "@brief Method void QAbstractItemDelegate::destroyEditor(QWidget *editor, const QModelIndex &index)\n", true, &_init_f_destroyEditor_c3602, &_call_f_destroyEditor_c3602);
  methods += new qt_gsi::GenericMethod ("editorEvent", "@brief Method bool QAbstractItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)\n", false, &_init_f_editorEvent_9073, &_call_f_editorEvent_9073);
  methods += new qt_gsi::GenericMethod ("helpEvent", "@brief Method bool QAbstractItemDelegate::helpEvent(QHelpEvent *event, QAbstractItemView *view, const QStyleOptionViewItem &option, const QModelIndex &index)\n", false, &_init_f_helpEvent_9380, &_call_f_helpEvent_9380);
  methods += new qt_gsi::GenericMethod ("paint", "@brief Method void QAbstractItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)\n", true, &_init_f_paint_c6971, &_call_f_paint_c6971);
  methods += new qt_gsi::GenericMethod ("paintingRoles", "@brief Method QVector<int> QAbstractItemDelegate::paintingRoles()\n", true, &_init_f_paintingRoles_c0, &_call_f_paintingRoles_c0);
  methods += new qt_gsi::GenericMethod ("setEditorData", "@brief Method void QAbstractItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)\n", true, &_init_f_setEditorData_c3602, &_call_f_setEditorData_c3602);
  methods += new qt_gsi::GenericMethod ("setModelData", "@brief Method void QAbstractItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)\n", true, &_init_f_setModelData_c5913, &_call_f_setModelData_c5913);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Method QSize QAbstractItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)\n", true, &_init_f_sizeHint_c5653, &_call_f_sizeHint_c5653);
  methods += new qt_gsi::GenericMethod ("updateEditorGeometry", "@brief Method void QAbstractItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)\n", true, &_init_f_updateEditorGeometry_c6860, &_call_f_updateEditorGeometry_c6860);
  methods += gsi::qt_signal<QWidget *, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > ("closeEditor(QWidget *, QAbstractItemDelegate::EndEditHint)", "closeEditor", gsi::arg("editor"), gsi::arg("hint"), "@brief Signal declaration for QAbstractItemDelegate::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QWidget * > ("commitData(QWidget *)", "commitData", gsi::arg("editor"), "@brief Signal declaration for QAbstractItemDelegate::commitData(QWidget *editor)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QAbstractItemDelegate::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QAbstractItemDelegate::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("sizeHintChanged(const QModelIndex &)", "sizeHintChanged", gsi::arg("arg1"), "@brief Signal declaration for QAbstractItemDelegate::sizeHintChanged(const QModelIndex &)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("elidedText", "@brief Static method QString QAbstractItemDelegate::elidedText(const QFontMetrics &fontMetrics, int width, Qt::TextElideMode mode, const QString &text)\nThis method is static and can be called without an instance.", &_init_f_elidedText_7038, &_call_f_elidedText_7038);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractItemDelegate::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractItemDelegate::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QAbstractItemDelegate> decl_QAbstractItemDelegate (qtdecl_QObject (), "QtWidgets", "QAbstractItemDelegate_Native",
  methods_QAbstractItemDelegate (),
  "@hide\n@alias QAbstractItemDelegate");

GSI_QTWIDGETS_PUBLIC gsi::Class<QAbstractItemDelegate> &qtdecl_QAbstractItemDelegate () { return decl_QAbstractItemDelegate; }

}


class QAbstractItemDelegate_Adaptor : public QAbstractItemDelegate, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractItemDelegate_Adaptor();

  //  [adaptor ctor] QAbstractItemDelegate::QAbstractItemDelegate(QObject *parent)
  QAbstractItemDelegate_Adaptor() : QAbstractItemDelegate()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAbstractItemDelegate::QAbstractItemDelegate(QObject *parent)
  QAbstractItemDelegate_Adaptor(QObject *parent) : QAbstractItemDelegate(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QAbstractItemDelegate::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAbstractItemDelegate_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAbstractItemDelegate::isSignalConnected(signal);
  }

  //  [expose] int QAbstractItemDelegate::receivers(const char *signal)
  int fp_QAbstractItemDelegate_receivers_c1731 (const char *signal) const {
    return QAbstractItemDelegate::receivers(signal);
  }

  //  [expose] QObject *QAbstractItemDelegate::sender()
  QObject * fp_QAbstractItemDelegate_sender_c0 () const {
    return QAbstractItemDelegate::sender();
  }

  //  [expose] int QAbstractItemDelegate::senderSignalIndex()
  int fp_QAbstractItemDelegate_senderSignalIndex_c0 () const {
    return QAbstractItemDelegate::senderSignalIndex();
  }

  //  [emitter impl] void QAbstractItemDelegate::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  void emitter_QAbstractItemDelegate_closeEditor_4926(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  {
    emit QAbstractItemDelegate::closeEditor(editor, hint);
  }

  //  [emitter impl] void QAbstractItemDelegate::commitData(QWidget *editor)
  void emitter_QAbstractItemDelegate_commitData_1315(QWidget *editor)
  {
    emit QAbstractItemDelegate::commitData(editor);
  }

  //  [adaptor impl] QWidget *QAbstractItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)
  QWidget * cbs_createEditor_c6860_0(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    return QAbstractItemDelegate::createEditor(parent, option, index);
  }

  virtual QWidget * createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_createEditor_c6860_0.can_issue()) {
      return cb_createEditor_c6860_0.issue<QAbstractItemDelegate_Adaptor, QWidget *, QWidget *, const QStyleOptionViewItem &, const QModelIndex &>(&QAbstractItemDelegate_Adaptor::cbs_createEditor_c6860_0, parent, option, index);
    } else {
      return QAbstractItemDelegate::createEditor(parent, option, index);
    }
  }

  //  [adaptor impl] void QAbstractItemDelegate::destroyEditor(QWidget *editor, const QModelIndex &index)
  void cbs_destroyEditor_c3602_0(QWidget *editor, const QModelIndex &index) const
  {
    QAbstractItemDelegate::destroyEditor(editor, index);
  }

  virtual void destroyEditor(QWidget *editor, const QModelIndex &index) const
  {
    if (cb_destroyEditor_c3602_0.can_issue()) {
      cb_destroyEditor_c3602_0.issue<QAbstractItemDelegate_Adaptor, QWidget *, const QModelIndex &>(&QAbstractItemDelegate_Adaptor::cbs_destroyEditor_c3602_0, editor, index);
    } else {
      QAbstractItemDelegate::destroyEditor(editor, index);
    }
  }

  //  [emitter impl] void QAbstractItemDelegate::destroyed(QObject *)
  void emitter_QAbstractItemDelegate_destroyed_1302(QObject *arg1)
  {
    emit QAbstractItemDelegate::destroyed(arg1);
  }

  //  [adaptor impl] bool QAbstractItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)
  bool cbs_editorEvent_9073_0(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)
  {
    return QAbstractItemDelegate::editorEvent(event, model, option, index);
  }

  virtual bool editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)
  {
    if (cb_editorEvent_9073_0.can_issue()) {
      return cb_editorEvent_9073_0.issue<QAbstractItemDelegate_Adaptor, bool, QEvent *, QAbstractItemModel *, const QStyleOptionViewItem &, const QModelIndex &>(&QAbstractItemDelegate_Adaptor::cbs_editorEvent_9073_0, event, model, option, index);
    } else {
      return QAbstractItemDelegate::editorEvent(event, model, option, index);
    }
  }

  //  [adaptor impl] bool QAbstractItemDelegate::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QAbstractItemDelegate::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAbstractItemDelegate_Adaptor, bool, QEvent *>(&QAbstractItemDelegate_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QAbstractItemDelegate::event(arg1);
    }
  }

  //  [adaptor impl] bool QAbstractItemDelegate::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAbstractItemDelegate::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAbstractItemDelegate_Adaptor, bool, QObject *, QEvent *>(&QAbstractItemDelegate_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAbstractItemDelegate::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QAbstractItemDelegate::helpEvent(QHelpEvent *event, QAbstractItemView *view, const QStyleOptionViewItem &option, const QModelIndex &index)
  bool cbs_helpEvent_9380_0(QHelpEvent *event, QAbstractItemView *view, const QStyleOptionViewItem &option, const QModelIndex &index)
  {
    return QAbstractItemDelegate::helpEvent(event, view, option, index);
  }

  virtual bool helpEvent(QHelpEvent *event, QAbstractItemView *view, const QStyleOptionViewItem &option, const QModelIndex &index)
  {
    if (cb_helpEvent_9380_0.can_issue()) {
      return cb_helpEvent_9380_0.issue<QAbstractItemDelegate_Adaptor, bool, QHelpEvent *, QAbstractItemView *, const QStyleOptionViewItem &, const QModelIndex &>(&QAbstractItemDelegate_Adaptor::cbs_helpEvent_9380_0, event, view, option, index);
    } else {
      return QAbstractItemDelegate::helpEvent(event, view, option, index);
    }
  }

  //  [emitter impl] void QAbstractItemDelegate::objectNameChanged(const QString &objectName)
  void emitter_QAbstractItemDelegate_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QAbstractItemDelegate::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QAbstractItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)
  void cbs_paint_c6971_0(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    __SUPPRESS_UNUSED_WARNING (painter);
    __SUPPRESS_UNUSED_WARNING (option);
    __SUPPRESS_UNUSED_WARNING (index);
    throw qt_gsi::AbstractMethodCalledException("paint");
  }

  virtual void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_paint_c6971_0.can_issue()) {
      cb_paint_c6971_0.issue<QAbstractItemDelegate_Adaptor, QPainter *, const QStyleOptionViewItem &, const QModelIndex &>(&QAbstractItemDelegate_Adaptor::cbs_paint_c6971_0, painter, option, index);
    } else {
      throw qt_gsi::AbstractMethodCalledException("paint");
    }
  }

  //  [adaptor impl] QVector<int> QAbstractItemDelegate::paintingRoles()
  QVector<int> cbs_paintingRoles_c0_0() const
  {
    return QAbstractItemDelegate::paintingRoles();
  }

  virtual QVector<int> paintingRoles() const
  {
    if (cb_paintingRoles_c0_0.can_issue()) {
      return cb_paintingRoles_c0_0.issue<QAbstractItemDelegate_Adaptor, QVector<int> >(&QAbstractItemDelegate_Adaptor::cbs_paintingRoles_c0_0);
    } else {
      return QAbstractItemDelegate::paintingRoles();
    }
  }

  //  [adaptor impl] void QAbstractItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)
  void cbs_setEditorData_c3602_0(QWidget *editor, const QModelIndex &index) const
  {
    QAbstractItemDelegate::setEditorData(editor, index);
  }

  virtual void setEditorData(QWidget *editor, const QModelIndex &index) const
  {
    if (cb_setEditorData_c3602_0.can_issue()) {
      cb_setEditorData_c3602_0.issue<QAbstractItemDelegate_Adaptor, QWidget *, const QModelIndex &>(&QAbstractItemDelegate_Adaptor::cbs_setEditorData_c3602_0, editor, index);
    } else {
      QAbstractItemDelegate::setEditorData(editor, index);
    }
  }

  //  [adaptor impl] void QAbstractItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)
  void cbs_setModelData_c5913_0(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
  {
    QAbstractItemDelegate::setModelData(editor, model, index);
  }

  virtual void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
  {
    if (cb_setModelData_c5913_0.can_issue()) {
      cb_setModelData_c5913_0.issue<QAbstractItemDelegate_Adaptor, QWidget *, QAbstractItemModel *, const QModelIndex &>(&QAbstractItemDelegate_Adaptor::cbs_setModelData_c5913_0, editor, model, index);
    } else {
      QAbstractItemDelegate::setModelData(editor, model, index);
    }
  }

  //  [adaptor impl] QSize QAbstractItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)
  QSize cbs_sizeHint_c5653_0(const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    __SUPPRESS_UNUSED_WARNING (option);
    __SUPPRESS_UNUSED_WARNING (index);
    throw qt_gsi::AbstractMethodCalledException("sizeHint");
  }

  virtual QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_sizeHint_c5653_0.can_issue()) {
      return cb_sizeHint_c5653_0.issue<QAbstractItemDelegate_Adaptor, QSize, const QStyleOptionViewItem &, const QModelIndex &>(&QAbstractItemDelegate_Adaptor::cbs_sizeHint_c5653_0, option, index);
    } else {
      throw qt_gsi::AbstractMethodCalledException("sizeHint");
    }
  }

  //  [emitter impl] void QAbstractItemDelegate::sizeHintChanged(const QModelIndex &)
  void emitter_QAbstractItemDelegate_sizeHintChanged_2395(const QModelIndex &arg1)
  {
    emit QAbstractItemDelegate::sizeHintChanged(arg1);
  }

  //  [adaptor impl] void QAbstractItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)
  void cbs_updateEditorGeometry_c6860_0(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    QAbstractItemDelegate::updateEditorGeometry(editor, option, index);
  }

  virtual void updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_updateEditorGeometry_c6860_0.can_issue()) {
      cb_updateEditorGeometry_c6860_0.issue<QAbstractItemDelegate_Adaptor, QWidget *, const QStyleOptionViewItem &, const QModelIndex &>(&QAbstractItemDelegate_Adaptor::cbs_updateEditorGeometry_c6860_0, editor, option, index);
    } else {
      QAbstractItemDelegate::updateEditorGeometry(editor, option, index);
    }
  }

  //  [adaptor impl] void QAbstractItemDelegate::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QAbstractItemDelegate::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAbstractItemDelegate_Adaptor, QChildEvent *>(&QAbstractItemDelegate_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QAbstractItemDelegate::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemDelegate::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QAbstractItemDelegate::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAbstractItemDelegate_Adaptor, QEvent *>(&QAbstractItemDelegate_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QAbstractItemDelegate::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemDelegate::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAbstractItemDelegate::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAbstractItemDelegate_Adaptor, const QMetaMethod &>(&QAbstractItemDelegate_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAbstractItemDelegate::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAbstractItemDelegate::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QAbstractItemDelegate::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAbstractItemDelegate_Adaptor, QTimerEvent *>(&QAbstractItemDelegate_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QAbstractItemDelegate::timerEvent(arg1);
    }
  }

  gsi::Callback cb_createEditor_c6860_0;
  gsi::Callback cb_destroyEditor_c3602_0;
  gsi::Callback cb_editorEvent_9073_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_helpEvent_9380_0;
  gsi::Callback cb_paint_c6971_0;
  gsi::Callback cb_paintingRoles_c0_0;
  gsi::Callback cb_setEditorData_c3602_0;
  gsi::Callback cb_setModelData_c5913_0;
  gsi::Callback cb_sizeHint_c5653_0;
  gsi::Callback cb_updateEditorGeometry_c6860_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAbstractItemDelegate_Adaptor::~QAbstractItemDelegate_Adaptor() { }

//  Constructor QAbstractItemDelegate::QAbstractItemDelegate(QObject *parent) (adaptor class)

static void _init_ctor_QAbstractItemDelegate_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QAbstractItemDelegate_Adaptor> ();
}

static void _call_ctor_QAbstractItemDelegate_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QAbstractItemDelegate_Adaptor *> (new QAbstractItemDelegate_Adaptor (arg1));
}


// void QAbstractItemDelegate::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractItemDelegate_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QAbstractItemDelegate::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)

static void _init_emitter_closeEditor_4926 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemDelegate::NoHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_closeEditor_4926 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemDelegate::EndEditHint>(heap, QAbstractItemDelegate::NoHint), heap);
  ((QAbstractItemDelegate_Adaptor *)cls)->emitter_QAbstractItemDelegate_closeEditor_4926 (arg1, arg2);
}


// emitter void QAbstractItemDelegate::commitData(QWidget *editor)

static void _init_emitter_commitData_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_commitData_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  ((QAbstractItemDelegate_Adaptor *)cls)->emitter_QAbstractItemDelegate_commitData_1315 (arg1);
}


// QWidget *QAbstractItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_createEditor_c6860_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QWidget * > ();
}

static void _call_cbs_createEditor_c6860_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QWidget * > ((QWidget *)((QAbstractItemDelegate_Adaptor *)cls)->cbs_createEditor_c6860_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_createEditor_c6860_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_createEditor_c6860_0 = cb;
}


// void QAbstractItemDelegate::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractItemDelegate_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QAbstractItemDelegate::destroyEditor(QWidget *editor, const QModelIndex &index)

static void _init_cbs_destroyEditor_c3602_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_destroyEditor_c3602_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractItemDelegate_Adaptor *)cls)->cbs_destroyEditor_c3602_0 (arg1, arg2);
}

static void _set_callback_cbs_destroyEditor_c3602_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_destroyEditor_c3602_0 = cb;
}


// emitter void QAbstractItemDelegate::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QAbstractItemDelegate_Adaptor *)cls)->emitter_QAbstractItemDelegate_destroyed_1302 (arg1);
}


// void QAbstractItemDelegate::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractItemDelegate_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QAbstractItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_editorEvent_9073_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("index");
  decl->add_arg<const QModelIndex & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_editorEvent_9073_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  QAbstractItemModel *arg2 = args.read<QAbstractItemModel * > (heap);
  const QStyleOptionViewItem &arg3 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QAbstractItemDelegate_Adaptor *)cls)->cbs_editorEvent_9073_0 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_editorEvent_9073_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_editorEvent_9073_0 = cb;
}


// bool QAbstractItemDelegate::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractItemDelegate_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAbstractItemDelegate::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractItemDelegate_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QAbstractItemDelegate::helpEvent(QHelpEvent *event, QAbstractItemView *view, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_helpEvent_9380_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHelpEvent * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("view");
  decl->add_arg<QAbstractItemView * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("index");
  decl->add_arg<const QModelIndex & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_helpEvent_9380_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHelpEvent *arg1 = args.read<QHelpEvent * > (heap);
  QAbstractItemView *arg2 = args.read<QAbstractItemView * > (heap);
  const QStyleOptionViewItem &arg3 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QAbstractItemDelegate_Adaptor *)cls)->cbs_helpEvent_9380_0 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_helpEvent_9380_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_helpEvent_9380_0 = cb;
}


// exposed bool QAbstractItemDelegate::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractItemDelegate_Adaptor *)cls)->fp_QAbstractItemDelegate_isSignalConnected_c2394 (arg1));
}


// emitter void QAbstractItemDelegate::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QAbstractItemDelegate_Adaptor *)cls)->emitter_QAbstractItemDelegate_objectNameChanged_4567 (arg1);
}


// void QAbstractItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_paint_c6971_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paint_c6971_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractItemDelegate_Adaptor *)cls)->cbs_paint_c6971_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paint_c6971_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_paint_c6971_0 = cb;
}


// QVector<int> QAbstractItemDelegate::paintingRoles()

static void _init_cbs_paintingRoles_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVector<int> > ();
}

static void _call_cbs_paintingRoles_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVector<int> > ((QVector<int>)((QAbstractItemDelegate_Adaptor *)cls)->cbs_paintingRoles_c0_0 ());
}

static void _set_callback_cbs_paintingRoles_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_paintingRoles_c0_0 = cb;
}


// exposed int QAbstractItemDelegate::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAbstractItemDelegate_Adaptor *)cls)->fp_QAbstractItemDelegate_receivers_c1731 (arg1));
}


// exposed QObject *QAbstractItemDelegate::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAbstractItemDelegate_Adaptor *)cls)->fp_QAbstractItemDelegate_sender_c0 ());
}


// exposed int QAbstractItemDelegate::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractItemDelegate_Adaptor *)cls)->fp_QAbstractItemDelegate_senderSignalIndex_c0 ());
}


// void QAbstractItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)

static void _init_cbs_setEditorData_c3602_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setEditorData_c3602_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractItemDelegate_Adaptor *)cls)->cbs_setEditorData_c3602_0 (arg1, arg2);
}

static void _set_callback_cbs_setEditorData_c3602_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_setEditorData_c3602_0 = cb;
}


// void QAbstractItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)

static void _init_cbs_setModelData_c5913_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_setModelData_c5913_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  QAbstractItemModel *arg2 = args.read<QAbstractItemModel * > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractItemDelegate_Adaptor *)cls)->cbs_setModelData_c5913_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_setModelData_c5913_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_setModelData_c5913_0 = cb;
}


// QSize QAbstractItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_sizeHint_c5653_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c5653_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStyleOptionViewItem &arg1 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  ret.write<QSize > ((QSize)((QAbstractItemDelegate_Adaptor *)cls)->cbs_sizeHint_c5653_0 (arg1, arg2));
}

static void _set_callback_cbs_sizeHint_c5653_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_sizeHint_c5653_0 = cb;
}


// emitter void QAbstractItemDelegate::sizeHintChanged(const QModelIndex &)

static void _init_emitter_sizeHintChanged_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_sizeHintChanged_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QAbstractItemDelegate_Adaptor *)cls)->emitter_QAbstractItemDelegate_sizeHintChanged_2395 (arg1);
}


// void QAbstractItemDelegate::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractItemDelegate_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QAbstractItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_updateEditorGeometry_c6860_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorGeometry_c6860_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractItemDelegate_Adaptor *)cls)->cbs_updateEditorGeometry_c6860_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_updateEditorGeometry_c6860_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemDelegate_Adaptor *)cls)->cb_updateEditorGeometry_c6860_0 = cb;
}


namespace gsi
{

gsi::Class<QAbstractItemDelegate> &qtdecl_QAbstractItemDelegate ();

static gsi::Methods methods_QAbstractItemDelegate_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractItemDelegate::QAbstractItemDelegate(QObject *parent)\nThis method creates an object of class QAbstractItemDelegate.", &_init_ctor_QAbstractItemDelegate_Adaptor_1302, &_call_ctor_QAbstractItemDelegate_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAbstractItemDelegate::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_closeEditor", "@brief Emitter for signal void QAbstractItemDelegate::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nCall this method to emit this signal.", false, &_init_emitter_closeEditor_4926, &_call_emitter_closeEditor_4926);
  methods += new qt_gsi::GenericMethod ("emit_commitData", "@brief Emitter for signal void QAbstractItemDelegate::commitData(QWidget *editor)\nCall this method to emit this signal.", false, &_init_emitter_commitData_1315, &_call_emitter_commitData_1315);
  methods += new qt_gsi::GenericMethod ("createEditor", "@brief Virtual method QWidget *QAbstractItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_createEditor_c6860_0, &_call_cbs_createEditor_c6860_0);
  methods += new qt_gsi::GenericMethod ("createEditor", "@hide", true, &_init_cbs_createEditor_c6860_0, &_call_cbs_createEditor_c6860_0, &_set_callback_cbs_createEditor_c6860_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAbstractItemDelegate::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("destroyEditor", "@brief Virtual method void QAbstractItemDelegate::destroyEditor(QWidget *editor, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_destroyEditor_c3602_0, &_call_cbs_destroyEditor_c3602_0);
  methods += new qt_gsi::GenericMethod ("destroyEditor", "@hide", true, &_init_cbs_destroyEditor_c3602_0, &_call_cbs_destroyEditor_c3602_0, &_set_callback_cbs_destroyEditor_c3602_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QAbstractItemDelegate::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAbstractItemDelegate::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("editorEvent", "@brief Virtual method bool QAbstractItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_editorEvent_9073_0, &_call_cbs_editorEvent_9073_0);
  methods += new qt_gsi::GenericMethod ("editorEvent", "@hide", false, &_init_cbs_editorEvent_9073_0, &_call_cbs_editorEvent_9073_0, &_set_callback_cbs_editorEvent_9073_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAbstractItemDelegate::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAbstractItemDelegate::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("helpEvent", "@brief Virtual method bool QAbstractItemDelegate::helpEvent(QHelpEvent *event, QAbstractItemView *view, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_helpEvent_9380_0, &_call_cbs_helpEvent_9380_0);
  methods += new qt_gsi::GenericMethod ("helpEvent", "@hide", false, &_init_cbs_helpEvent_9380_0, &_call_cbs_helpEvent_9380_0, &_set_callback_cbs_helpEvent_9380_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAbstractItemDelegate::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QAbstractItemDelegate::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paint", "@brief Virtual method void QAbstractItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paint_c6971_0, &_call_cbs_paint_c6971_0);
  methods += new qt_gsi::GenericMethod ("paint", "@hide", true, &_init_cbs_paint_c6971_0, &_call_cbs_paint_c6971_0, &_set_callback_cbs_paint_c6971_0);
  methods += new qt_gsi::GenericMethod ("paintingRoles", "@brief Virtual method QVector<int> QAbstractItemDelegate::paintingRoles()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintingRoles_c0_0, &_call_cbs_paintingRoles_c0_0);
  methods += new qt_gsi::GenericMethod ("paintingRoles", "@hide", true, &_init_cbs_paintingRoles_c0_0, &_call_cbs_paintingRoles_c0_0, &_set_callback_cbs_paintingRoles_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAbstractItemDelegate::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAbstractItemDelegate::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAbstractItemDelegate::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setEditorData", "@brief Virtual method void QAbstractItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_setEditorData_c3602_0, &_call_cbs_setEditorData_c3602_0);
  methods += new qt_gsi::GenericMethod ("setEditorData", "@hide", true, &_init_cbs_setEditorData_c3602_0, &_call_cbs_setEditorData_c3602_0, &_set_callback_cbs_setEditorData_c3602_0);
  methods += new qt_gsi::GenericMethod ("setModelData", "@brief Virtual method void QAbstractItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_setModelData_c5913_0, &_call_cbs_setModelData_c5913_0);
  methods += new qt_gsi::GenericMethod ("setModelData", "@hide", true, &_init_cbs_setModelData_c5913_0, &_call_cbs_setModelData_c5913_0, &_set_callback_cbs_setModelData_c5913_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QAbstractItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c5653_0, &_call_cbs_sizeHint_c5653_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c5653_0, &_call_cbs_sizeHint_c5653_0, &_set_callback_cbs_sizeHint_c5653_0);
  methods += new qt_gsi::GenericMethod ("emit_sizeHintChanged", "@brief Emitter for signal void QAbstractItemDelegate::sizeHintChanged(const QModelIndex &)\nCall this method to emit this signal.", false, &_init_emitter_sizeHintChanged_2395, &_call_emitter_sizeHintChanged_2395);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAbstractItemDelegate::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("updateEditorGeometry", "@brief Virtual method void QAbstractItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_updateEditorGeometry_c6860_0, &_call_cbs_updateEditorGeometry_c6860_0);
  methods += new qt_gsi::GenericMethod ("updateEditorGeometry", "@hide", true, &_init_cbs_updateEditorGeometry_c6860_0, &_call_cbs_updateEditorGeometry_c6860_0, &_set_callback_cbs_updateEditorGeometry_c6860_0);
  return methods;
}

gsi::Class<QAbstractItemDelegate_Adaptor> decl_QAbstractItemDelegate_Adaptor (qtdecl_QAbstractItemDelegate (), "QtWidgets", "QAbstractItemDelegate",
  methods_QAbstractItemDelegate_Adaptor (),
  "@qt\n@brief Binding of QAbstractItemDelegate");

}


//  Implementation of the enum wrapper class for QAbstractItemDelegate::EndEditHint
namespace qt_gsi
{

static gsi::Enum<QAbstractItemDelegate::EndEditHint> decl_QAbstractItemDelegate_EndEditHint_Enum ("QtWidgets", "QAbstractItemDelegate_EndEditHint",
    gsi::enum_const ("NoHint", QAbstractItemDelegate::NoHint, "@brief Enum constant QAbstractItemDelegate::NoHint") +
    gsi::enum_const ("EditNextItem", QAbstractItemDelegate::EditNextItem, "@brief Enum constant QAbstractItemDelegate::EditNextItem") +
    gsi::enum_const ("EditPreviousItem", QAbstractItemDelegate::EditPreviousItem, "@brief Enum constant QAbstractItemDelegate::EditPreviousItem") +
    gsi::enum_const ("SubmitModelCache", QAbstractItemDelegate::SubmitModelCache, "@brief Enum constant QAbstractItemDelegate::SubmitModelCache") +
    gsi::enum_const ("RevertModelCache", QAbstractItemDelegate::RevertModelCache, "@brief Enum constant QAbstractItemDelegate::RevertModelCache"),
  "@qt\n@brief This class represents the QAbstractItemDelegate::EndEditHint enum");

static gsi::QFlagsClass<QAbstractItemDelegate::EndEditHint > decl_QAbstractItemDelegate_EndEditHint_Enums ("QtWidgets", "QAbstractItemDelegate_QFlags_EndEditHint",
  "@qt\n@brief This class represents the QFlags<QAbstractItemDelegate::EndEditHint> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractItemDelegate> inject_QAbstractItemDelegate_EndEditHint_Enum_in_parent (decl_QAbstractItemDelegate_EndEditHint_Enum.defs ());
static gsi::ClassExt<QAbstractItemDelegate> decl_QAbstractItemDelegate_EndEditHint_Enum_as_child (decl_QAbstractItemDelegate_EndEditHint_Enum, "EndEditHint");
static gsi::ClassExt<QAbstractItemDelegate> decl_QAbstractItemDelegate_EndEditHint_Enums_as_child (decl_QAbstractItemDelegate_EndEditHint_Enums, "QFlags_EndEditHint");

}

