package logql

// Code generated by peg /Users/antoine/code/src/github.com/humanlogio/api/go/pkg/logql/grammar.peg DO NOT EDIT.

import (
	"fmt"
	"github.com/humanlogio/api/go/types/v1"
	"io"
	"os"
	"sort"
	"strconv"
	"strings"
	"time"
)

const endSymbol rune = 1114112

/* The rule types inferred from the grammar are below. */
type pegRule uint16

const (
	ruleUnknown pegRule = iota
	ruleGrammar
	ruleQueryContext
	ruleQueryContextItem
	ruleQueryFrom
	ruleQueryTo
	ruleQueryMachineContext
	ruleQuerySessionContext
	ruleStatements
	ruleStatement
	ruleRenderStatement
	ruleFilterOperator
	ruleSummarizeOperator
	ruleSummarizeParameters
	ruleSummarizeParameter
	ruleSummarizeByGroupExpressions
	ruleSummarizeByGroupExpression
	ruleProjectOperator
	ruleProjectArg
	ruleProjectAwayOperator
	ruleProjectAwayArg
	ruleProjectKeepOperator
	ruleProjectKeepArg
	ruleExtendOperator
	ruleExtendArg
	ruleCountOperator
	ruleDistinctOperator
	ruleDistinctOperatorArg
	ruleSampleOperator
	ruleSearchOperator
	ruleSearchOperatorCaseSensitivity
	ruleSearchOperatorPredicate
	ruleSortOperator
	ruleSortOperatorArg
	ruleTakeOperator
	ruleTopOperator
	ruleRenderSplitOperator
	ruleRenderSplitByOperator
	ruleRenderSplitByOperatorArg
	ruleExpr
	ruleExpr1
	ruleExpr2
	ruleExpr3
	ruleExpr4
	ruleExpr5
	ruleLiteral
	ruleFuncCall
	ruleFuncName
	ruleFuncArgs
	ruleFuncArg
	ruleIdentifier
	ruleString
	ruleF64
	ruleI64
	ruleBool
	ruleReservedKeyword
	ruleArray
	ruleArrayItem
	ruleObject
	ruleObjectItem
	ruleObjectKey
	ruleDuration
	ruleTimestamp
	ruleDoubleQuoteStringChar
	ruleExponent
	ruleDigits
	ruleRFC3339Nano
	ruleRFC3339NanoDate
	ruleRFC3339NanoTime
	ruleRFC3339NanoTimezone
	ruleNumber
	ruleNOT
	ruleNEG
	ruleNUM_ADD
	ruleNUM_SUB
	ruleNUM_DIV
	ruleNUM_MUL
	ruleNUM_MOD
	ruleLOG_AND
	ruleLOG_OR
	ruleCMP_EQ
	ruleCMP_NOTEQ
	ruleCMP_GT
	ruleCMP_GTE
	ruleCMP_LT
	ruleCMP_LTE
	ruleSET_IN
	ruleSET_NOTIN
	ruleSTR_EQ_NOCS
	ruleSTR_NOTEQ_NOCS
	ruleSTR_CONTAINS
	ruleSTR_NOT_CONTAINS
	ruleSTR_CONTAINS_CS
	ruleSTR_NOT_CONTAINS_CS
	ruleSTR_STARTSWITH
	ruleSTR_NOT_STARTSWITH
	ruleSTR_STARTSWITH_CS
	ruleSTR_NOT_STARTSWITH_CS
	ruleSTR_ENDSWITH
	ruleSTR_NOT_ENDSWITH
	ruleSTR_ENDSWITH_CS
	ruleSTR_NOT_ENDSWITH_CS
	ruleSTR_IN_NOCS
	ruleSTR_NOT_IN_NOCS
	ruleSTR_NOT_MATCHES_REGEX
	ruleSTR_MATCHES_REGEX
	ruleSTR_HAS
	ruleSTR_HAS_CS
	rulePIPE
	ruleL_PARENS
	ruleR_PARENS
	ruleL_BRACKET
	ruleR_BRACKET
	ruleL_SQUIGGLY
	ruleR_SQUIGGLY
	ruleCOLON
	ruleCOMMA
	ruleSpace
	ruleMustSpace
	ruleWhitespace
	ruleEOL
	ruleEOF
	ruleAction0
	ruleAction1
	ruleAction2
	ruleAction3
	ruleAction4
	ruleAction5
	ruleAction6
	ruleAction7
	ruleAction8
	ruleAction9
	ruleAction10
	ruleAction11
	ruleAction12
	ruleAction13
	ruleAction14
	ruleAction15
	ruleAction16
	ruleAction17
	ruleAction18
	ruleAction19
	ruleAction20
	ruleAction21
	ruleAction22
	ruleAction23
	ruleAction24
	ruleAction25
	ruleAction26
	ruleAction27
	ruleAction28
	ruleAction29
	ruleAction30
	ruleAction31
	ruleAction32
	ruleAction33
	ruleAction34
	ruleAction35
	ruleAction36
	ruleAction37
	ruleAction38
	ruleAction39
	ruleAction40
	ruleAction41
	ruleAction42
	ruleAction43
	ruleAction44
	ruleAction45
	ruleAction46
	ruleAction47
	ruleAction48
	ruleAction49
	ruleAction50
	ruleAction51
	ruleAction52
	ruleAction53
	ruleAction54
	ruleAction55
	ruleAction56
	ruleAction57
	ruleAction58
	ruleAction59
	ruleAction60
	ruleAction61
	ruleAction62
	ruleAction63
	ruleAction64
	ruleAction65
	ruleAction66
	ruleAction67
	ruleAction68
	ruleAction69
	ruleAction70
	ruleAction71
	ruleAction72
	ruleAction73
	ruleAction74
	ruleAction75
	ruleAction76
	ruleAction77
	ruleAction78
	ruleAction79
	ruleAction80
	ruleAction81
	ruleAction82
	ruleAction83
	ruleAction84
	ruleAction85
	ruleAction86
	ruleAction87
	ruleAction88
	ruleAction89
	ruleAction90
	ruleAction91
	ruleAction92
	ruleAction93
	ruleAction94
	ruleAction95
	ruleAction96
	ruleAction97
	ruleAction98
	ruleAction99
	ruleAction100
	ruleAction101
	ruleAction102
	ruleAction103
	ruleAction104
	ruleAction105
	ruleAction106
	ruleAction107
	ruleAction108
	ruleAction109
	ruleAction110
	ruleAction111
	ruleAction112
	ruleAction113
	ruleAction114
	ruleAction115
	ruleAction116
	ruleAction117
	ruleAction118
	ruleAction119
	ruleAction120
	ruleAction121
	rulePegText
	ruleAction122
	ruleAction123
	ruleAction124
	ruleAction125
	ruleAction126
	ruleAction127
	ruleAction128
	ruleAction129
	ruleAction130
	ruleAction131
	ruleAction132
	ruleAction133
	ruleAction134
	ruleAction135
	ruleAction136
	ruleAction137
	ruleAction138
	ruleAction139
	ruleAction140
	ruleAction141
	ruleAction142
)

var rul3s = [...]string{
	"Unknown",
	"Grammar",
	"QueryContext",
	"QueryContextItem",
	"QueryFrom",
	"QueryTo",
	"QueryMachineContext",
	"QuerySessionContext",
	"Statements",
	"Statement",
	"RenderStatement",
	"FilterOperator",
	"SummarizeOperator",
	"SummarizeParameters",
	"SummarizeParameter",
	"SummarizeByGroupExpressions",
	"SummarizeByGroupExpression",
	"ProjectOperator",
	"ProjectArg",
	"ProjectAwayOperator",
	"ProjectAwayArg",
	"ProjectKeepOperator",
	"ProjectKeepArg",
	"ExtendOperator",
	"ExtendArg",
	"CountOperator",
	"DistinctOperator",
	"DistinctOperatorArg",
	"SampleOperator",
	"SearchOperator",
	"SearchOperatorCaseSensitivity",
	"SearchOperatorPredicate",
	"SortOperator",
	"SortOperatorArg",
	"TakeOperator",
	"TopOperator",
	"RenderSplitOperator",
	"RenderSplitByOperator",
	"RenderSplitByOperatorArg",
	"Expr",
	"Expr1",
	"Expr2",
	"Expr3",
	"Expr4",
	"Expr5",
	"Literal",
	"FuncCall",
	"FuncName",
	"FuncArgs",
	"FuncArg",
	"Identifier",
	"String",
	"F64",
	"I64",
	"Bool",
	"ReservedKeyword",
	"Array",
	"ArrayItem",
	"Object",
	"ObjectItem",
	"ObjectKey",
	"Duration",
	"Timestamp",
	"DoubleQuoteStringChar",
	"Exponent",
	"Digits",
	"RFC3339Nano",
	"RFC3339NanoDate",
	"RFC3339NanoTime",
	"RFC3339NanoTimezone",
	"Number",
	"NOT",
	"NEG",
	"NUM_ADD",
	"NUM_SUB",
	"NUM_DIV",
	"NUM_MUL",
	"NUM_MOD",
	"LOG_AND",
	"LOG_OR",
	"CMP_EQ",
	"CMP_NOTEQ",
	"CMP_GT",
	"CMP_GTE",
	"CMP_LT",
	"CMP_LTE",
	"SET_IN",
	"SET_NOTIN",
	"STR_EQ_NOCS",
	"STR_NOTEQ_NOCS",
	"STR_CONTAINS",
	"STR_NOT_CONTAINS",
	"STR_CONTAINS_CS",
	"STR_NOT_CONTAINS_CS",
	"STR_STARTSWITH",
	"STR_NOT_STARTSWITH",
	"STR_STARTSWITH_CS",
	"STR_NOT_STARTSWITH_CS",
	"STR_ENDSWITH",
	"STR_NOT_ENDSWITH",
	"STR_ENDSWITH_CS",
	"STR_NOT_ENDSWITH_CS",
	"STR_IN_NOCS",
	"STR_NOT_IN_NOCS",
	"STR_NOT_MATCHES_REGEX",
	"STR_MATCHES_REGEX",
	"STR_HAS",
	"STR_HAS_CS",
	"PIPE",
	"L_PARENS",
	"R_PARENS",
	"L_BRACKET",
	"R_BRACKET",
	"L_SQUIGGLY",
	"R_SQUIGGLY",
	"COLON",
	"COMMA",
	"Space",
	"MustSpace",
	"Whitespace",
	"EOL",
	"EOF",
	"Action0",
	"Action1",
	"Action2",
	"Action3",
	"Action4",
	"Action5",
	"Action6",
	"Action7",
	"Action8",
	"Action9",
	"Action10",
	"Action11",
	"Action12",
	"Action13",
	"Action14",
	"Action15",
	"Action16",
	"Action17",
	"Action18",
	"Action19",
	"Action20",
	"Action21",
	"Action22",
	"Action23",
	"Action24",
	"Action25",
	"Action26",
	"Action27",
	"Action28",
	"Action29",
	"Action30",
	"Action31",
	"Action32",
	"Action33",
	"Action34",
	"Action35",
	"Action36",
	"Action37",
	"Action38",
	"Action39",
	"Action40",
	"Action41",
	"Action42",
	"Action43",
	"Action44",
	"Action45",
	"Action46",
	"Action47",
	"Action48",
	"Action49",
	"Action50",
	"Action51",
	"Action52",
	"Action53",
	"Action54",
	"Action55",
	"Action56",
	"Action57",
	"Action58",
	"Action59",
	"Action60",
	"Action61",
	"Action62",
	"Action63",
	"Action64",
	"Action65",
	"Action66",
	"Action67",
	"Action68",
	"Action69",
	"Action70",
	"Action71",
	"Action72",
	"Action73",
	"Action74",
	"Action75",
	"Action76",
	"Action77",
	"Action78",
	"Action79",
	"Action80",
	"Action81",
	"Action82",
	"Action83",
	"Action84",
	"Action85",
	"Action86",
	"Action87",
	"Action88",
	"Action89",
	"Action90",
	"Action91",
	"Action92",
	"Action93",
	"Action94",
	"Action95",
	"Action96",
	"Action97",
	"Action98",
	"Action99",
	"Action100",
	"Action101",
	"Action102",
	"Action103",
	"Action104",
	"Action105",
	"Action106",
	"Action107",
	"Action108",
	"Action109",
	"Action110",
	"Action111",
	"Action112",
	"Action113",
	"Action114",
	"Action115",
	"Action116",
	"Action117",
	"Action118",
	"Action119",
	"Action120",
	"Action121",
	"PegText",
	"Action122",
	"Action123",
	"Action124",
	"Action125",
	"Action126",
	"Action127",
	"Action128",
	"Action129",
	"Action130",
	"Action131",
	"Action132",
	"Action133",
	"Action134",
	"Action135",
	"Action136",
	"Action137",
	"Action138",
	"Action139",
	"Action140",
	"Action141",
	"Action142",
}

type token32 struct {
	pegRule
	begin, end uint32
}

func (t *token32) String() string {
	return fmt.Sprintf("\x1B[34m%v\x1B[m %v %v", rul3s[t.pegRule], t.begin, t.end)
}

type node32 struct {
	token32
	up, next *node32
}

func (node *node32) print(w io.Writer, pretty bool, buffer string) {
	var print func(node *node32, depth int)
	print = func(node *node32, depth int) {
		for node != nil {
			for c := 0; c < depth; c++ {
				fmt.Fprintf(w, " ")
			}
			rule := rul3s[node.pegRule]
			quote := strconv.Quote(string(([]rune(buffer)[node.begin:node.end])))
			if !pretty {
				fmt.Fprintf(w, "%v %v\n", rule, quote)
			} else {
				fmt.Fprintf(w, "\x1B[36m%v\x1B[m %v\n", rule, quote)
			}
			if node.up != nil {
				print(node.up, depth+1)
			}
			node = node.next
		}
	}
	print(node, 0)
}

func (node *node32) Print(w io.Writer, buffer string) {
	node.print(w, false, buffer)
}

func (node *node32) PrettyPrint(w io.Writer, buffer string) {
	node.print(w, true, buffer)
}

type tokens32 struct {
	tree []token32
}

func (t *tokens32) Trim(length uint32) {
	t.tree = t.tree[:length]
}

func (t *tokens32) Print() {
	for _, token := range t.tree {
		fmt.Println(token.String())
	}
}

func (t *tokens32) AST() *node32 {
	type element struct {
		node *node32
		down *element
	}
	tokens := t.Tokens()
	var stack *element
	for _, token := range tokens {
		if token.begin == token.end {
			continue
		}
		node := &node32{token32: token}
		for stack != nil && stack.node.begin >= token.begin && stack.node.end <= token.end {
			stack.node.next = node.up
			node.up = stack.node
			stack = stack.down
		}
		stack = &element{node: node, down: stack}
	}
	if stack != nil {
		return stack.node
	}
	return nil
}

func (t *tokens32) PrintSyntaxTree(buffer string) {
	t.AST().Print(os.Stdout, buffer)
}

func (t *tokens32) WriteSyntaxTree(w io.Writer, buffer string) {
	t.AST().Print(w, buffer)
}

func (t *tokens32) PrettyPrintSyntaxTree(buffer string) {
	t.AST().PrettyPrint(os.Stdout, buffer)
}

func (t *tokens32) Add(rule pegRule, begin, end, index uint32) {
	tree, i := t.tree, int(index)
	if i >= len(tree) {
		t.tree = append(tree, token32{pegRule: rule, begin: begin, end: end})
		return
	}
	tree[i] = token32{pegRule: rule, begin: begin, end: end}
}

func (t *tokens32) Tokens() []token32 {
	return t.tree
}

type logQL struct {

	// the query being built
	LogQuery *typesv1.LogQuery

	// stack for recursive generic structures
	Exprs []*typesv1.Expr

	// accumulate statements
	Stmts      []*typesv1.Statement
	RenderStmt *typesv1.RenderStatement

	// scratch space for table operators
	FilterOp      *typesv1.FilterOperator
	SummarizeOp   *typesv1.SummarizeOperator
	ProjectOp     *typesv1.ProjectOperator
	ProjectAwayOp *typesv1.ProjectAwayOperator
	ProjectKeepOp *typesv1.ProjectKeepOperator
	ExtendOp      *typesv1.ExtendOperator
	CountOp       *typesv1.CountOperator
	DistinctOp    *typesv1.DistinctOperator
	SampleOp      *typesv1.SampleOperator
	SearchOp      *typesv1.SearchOperator
	SortOp        *typesv1.SortOperator
	TakeOp        *typesv1.TakeOperator
	TopOp         *typesv1.TopOperator

	// scratch space for search predicates
	identifier string

	// scratch space for render statements
	SplitByOp *typesv1.SplitOperator

	// scratch space, not needed but `Literal` being a type is convenient
	Literal *typesv1.Val

	// scalars
	String    string
	F64       float64
	I64       int64
	Bool      bool
	Timestamp time.Time
	Duration  time.Duration

	// stack for non-expr recursive structures
	Arrs      [][]*typesv1.Val
	ObjsKVs   [][]*typesv1.KV
	FuncCalls []*typesv1.FuncCall

	// errors seen along the way
	err error

	Buffer string
	buffer []rune
	rules  [266]func() bool
	parse  func(rule ...int) error
	reset  func()
	Pretty bool
	tokens32
}

func (p *logQL) Parse(rule ...int) error {
	return p.parse(rule...)
}

func (p *logQL) Reset() {
	p.reset()
}

type textPosition struct {
	line, symbol int
}

type textPositionMap map[int]textPosition

func translatePositions(buffer []rune, positions []int) textPositionMap {
	length, translations, j, line, symbol := len(positions), make(textPositionMap, len(positions)), 0, 1, 0
	sort.Ints(positions)

search:
	for i, c := range buffer {
		if c == '\n' {
			line, symbol = line+1, 0
		} else {
			symbol++
		}
		if i == positions[j] {
			translations[positions[j]] = textPosition{line, symbol}
			for j++; j < length; j++ {
				if i != positions[j] {
					continue search
				}
			}
			break search
		}
	}

	return translations
}

type parseError struct {
	p   *logQL
	max token32
}

func (e *parseError) Error() string {
	tokens, err := []token32{e.max}, "\n"
	positions, p := make([]int, 2*len(tokens)), 0
	for _, token := range tokens {
		positions[p], p = int(token.begin), p+1
		positions[p], p = int(token.end), p+1
	}
	translations := translatePositions(e.p.buffer, positions)
	format := "parse error near %v (line %v symbol %v - line %v symbol %v):\n%v\n"
	if e.p.Pretty {
		format = "parse error near \x1B[34m%v\x1B[m (line %v symbol %v - line %v symbol %v):\n%v\n"
	}
	for _, token := range tokens {
		begin, end := int(token.begin), int(token.end)
		err += fmt.Sprintf(format,
			rul3s[token.pegRule],
			translations[begin].line, translations[begin].symbol,
			translations[end].line, translations[end].symbol,
			strconv.Quote(string(e.p.buffer[begin:end])))
	}

	return err
}

func (p *logQL) PrintSyntaxTree() {
	if p.Pretty {
		p.tokens32.PrettyPrintSyntaxTree(p.Buffer)
	} else {
		p.tokens32.PrintSyntaxTree(p.Buffer)
	}
}

func (p *logQL) WriteSyntaxTree(w io.Writer) {
	p.tokens32.WriteSyntaxTree(w, p.Buffer)
}

func (p *logQL) SprintSyntaxTree() string {
	var bldr strings.Builder
	p.WriteSyntaxTree(&bldr)
	return bldr.String()
}

func (p *logQL) Execute() {
	buffer, _buffer, text, begin, end := p.Buffer, p.buffer, "", 0, 0
	for _, token := range p.Tokens() {
		switch token.pegRule {

		case rulePegText:
			begin, end = int(token.begin), int(token.end)
			text = string(_buffer[begin:end])

		case ruleAction0:
			p.SetQuery(p.Stmts)
		case ruleAction1:
			p.SetQuery(p.Stmts)
		case ruleAction2:
			p.SetFrom(p.popExpr())
		case ruleAction3:
			p.SetTo(p.popExpr())
		case ruleAction4:
			p.SetContextMachine(typesv1.BinaryOp_CMP_EQ, p.popExpr())
		case ruleAction5:
			p.SetContextMachine(typesv1.BinaryOp_CMP_NOTEQ, p.popExpr())
		case ruleAction6:
			p.SetContextMachine(typesv1.BinaryOp_SET_IN, p.popExpr())
		case ruleAction7:
			p.SetContextMachine(typesv1.BinaryOp_SET_NOTIN, p.popExpr())
		case ruleAction8:
			p.SetContextSession(typesv1.BinaryOp_CMP_EQ, p.popExpr())
		case ruleAction9:
			p.SetContextSession(typesv1.BinaryOp_CMP_NOTEQ, p.popExpr())
		case ruleAction10:
			p.SetContextSession(typesv1.BinaryOp_SET_IN, p.popExpr())
		case ruleAction11:
			p.SetContextSession(typesv1.BinaryOp_SET_NOTIN, p.popExpr())
		case ruleAction12:
			p.addFilterStatement(p.FilterOp)
		case ruleAction13:
			p.addSummarizeStatement(p.SummarizeOp)
		case ruleAction14:
			p.addProjectStatement(p.ProjectOp)
		case ruleAction15:
			p.addProjectAwayStatement(p.ProjectAwayOp)
		case ruleAction16:
			p.addProjectKeepStatement(p.ProjectKeepOp)
		case ruleAction17:
			p.addExtendStatement(p.ExtendOp)
		case ruleAction18:
			p.addCountStatement(p.CountOp)
		case ruleAction19:
			p.addDistinctStatement(p.DistinctOp)
		case ruleAction20:
			p.addSampleStatement(p.SampleOp)
		case ruleAction21:
			p.addSearchStatement(p.SearchOp)
		case ruleAction22:
			p.addSortStatement(p.SortOp)
		case ruleAction23:
			p.addTakeStatement(p.TakeOp)
		case ruleAction24:
			p.addTopStatement(p.TopOp)
		case ruleAction25:
			p.setRenderSplitByStatement(p.SplitByOp)
		case ruleAction26:
			p.setFilterOp(p.popExpr())
		case ruleAction27:
			p.startSummarizeOp()
		case ruleAction28:
			p.startSummarizeParameterNamedFunc(text)
		case ruleAction29:
			p.endSummarizeParameterNamedFunc(p.popFunc())
		case ruleAction30:
			p.addSummarizeParameterUnnamedFunc(p.popFunc())
		case ruleAction31:
			p.startSummarizeByUnnamedGroupExpression(text)
		case ruleAction32:
			p.endSummarizeByUnnamedGroupExpression(p.popExpr())
		case ruleAction33:
			p.addSummarizeByUnnamedGroupExpression(p.popExpr())
		case ruleAction34:
			p.startProjectOp()
		case ruleAction35:
			p.startProjectOpArg(text)
		case ruleAction36:
			p.setProjectOpArgValue(p.popExpr())
		case ruleAction37:
			p.startProjectAwayOp()
		case ruleAction38:
			p.addProjectAwayOpArg(text)
		case ruleAction39:
			p.startProjectKeepOp()
		case ruleAction40:
			p.addProjectKeepOpArg(text)
		case ruleAction41:
			p.startExtendOp()
		case ruleAction42:
			p.setExtendOpArgColumnName(text)
		case ruleAction43:
			p.setExtendOpArgValue(p.popExpr())
		case ruleAction44:
			p.startCountOp()
		case ruleAction45:
			p.startDistinctOp()
		case ruleAction46:
			p.addDistinctOpArg(text)
		case ruleAction47:
			p.startSampleOp()
		case ruleAction48:
			p.setSampleOpCount(p.I64)
		case ruleAction49:
			p.startSearchOp()
		case ruleAction50:
			p.setSearchOpKindDefault()
		case ruleAction51:
			p.setSearchOpKindCaseInsensitive()
		case ruleAction52:
			p.setSearchOpKindCaseSensitive()
		case ruleAction53:
			p.setSearchOpPredicateLiteral(text)
		case ruleAction54:
			p.identifier = text
		case ruleAction55:
			p.setSearchOpPredicateFieldSearch(p.identifier, p.String)
		case ruleAction56:
			p.setSearchOpPredicateExactSearch(p.identifier, p.String)
		case ruleAction57:
			p.setSearchOpPredicateRegexSearch(p.identifier, p.String)
		case ruleAction58:
			p.startSortOp()
		case ruleAction59:
			p.startSortOpArg(text)
		case ruleAction60:
			p.setSortOpArgOrderAsc()
		case ruleAction61:
			p.setSortOpArgOrderDesc()
		case ruleAction62:
			p.startTakeOp()
		case ruleAction63:
			p.setTakeOpCount(p.I64)
		case ruleAction64:
			p.startTopOp()
		case ruleAction65:
			p.setTopOpCount(p.I64)
		case ruleAction66:
			p.setTopOpByColumnScalar(p.popExpr())
		case ruleAction67:
			p.setTopOpByColumnOrderAsc()
		case ruleAction68:
			p.setTopOpByColumnOrderDesc()
		case ruleAction69:
			p.startRenderSplitOp()
		case ruleAction70:
			p.addRenderSplitByOp(p.popExpr())
		case ruleAction71:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_NUM_ADD, rhs))
		case ruleAction72:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_NUM_SUB, rhs))
		case ruleAction73:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_NUM_MUL, rhs))
		case ruleAction74:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_NUM_DIV, rhs))
		case ruleAction75:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_NUM_MOD, rhs))
		case ruleAction76:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_LOG_AND, rhs))
		case ruleAction77:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_LOG_OR, rhs))
		case ruleAction78:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_CMP_EQ, rhs))
		case ruleAction79:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_CMP_NOTEQ, rhs))
		case ruleAction80:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_CMP_GT, rhs))
		case ruleAction81:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_CMP_GTE, rhs))
		case ruleAction82:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_CMP_LT, rhs))
		case ruleAction83:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_CMP_LTE, rhs))
		case ruleAction84:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_SET_IN, rhs))
		case ruleAction85:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_SET_NOTIN, rhs))
		case ruleAction86:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_EQ_NOCS, rhs))
		case ruleAction87:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOTEQ_NOCS, rhs))
		case ruleAction88:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_CONTAINS, rhs))
		case ruleAction89:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_CONTAINS, rhs))
		case ruleAction90:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_CONTAINS_CS, rhs))
		case ruleAction91:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_CONTAINS_CS, rhs))
		case ruleAction92:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_STARTSWITH, rhs))
		case ruleAction93:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_STARTSWITH, rhs))
		case ruleAction94:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_STARTSWITH_CS, rhs))
		case ruleAction95:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_STARTSWITH_CS, rhs))
		case ruleAction96:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_ENDSWITH, rhs))
		case ruleAction97:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_ENDSWITH, rhs))
		case ruleAction98:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_ENDSWITH_CS, rhs))
		case ruleAction99:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_ENDSWITH_CS, rhs))
		case ruleAction100:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_IN_NOCS, rhs))
		case ruleAction101:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_IN_NOCS, rhs))
		case ruleAction102:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_MATCHES_REGEX, rhs))
		case ruleAction103:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_MATCHES_REGEX, rhs))
		case ruleAction104:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_HAS, rhs))
		case ruleAction105:
			rhs, lhs := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_HAS_CS, rhs))
		case ruleAction106:
			index, x := p.popExpr(), p.popExpr()
			p.pushExpr(typesv1.ExprIndexor(x, index))
		case ruleAction107:
			p.pushExpr(typesv1.ExprUnary(typesv1.UnaryOp_NOT, typesv1.ExprLiteral(p.Literal)))
			p.Literal = nil
		case ruleAction108:
			arg := p.popExpr()
			p.pushExpr(typesv1.ExprUnary(typesv1.UnaryOp_NOT, arg))
		case ruleAction109:
			p.pushExpr(typesv1.ExprUnary(typesv1.UnaryOp_NEG, typesv1.ExprLiteral(p.Literal)))
			p.Literal = nil
		case ruleAction110:
			arg := p.popExpr()
			p.pushExpr(typesv1.ExprUnary(typesv1.UnaryOp_NEG, arg))
		case ruleAction111:
			p.pushExpr(typesv1.ExprLiteral(p.Literal))
			p.Literal = nil
		case ruleAction112:
			fn := p.popFunc()
			p.pushExpr(typesv1.ExprFuncCall(fn.Name, fn.Args...))
		case ruleAction113:
			p.Literal = typesv1.ValStr(p.String)
		case ruleAction114:
			p.Literal = typesv1.ValDuration(p.Duration)
		case ruleAction115:
			p.Literal = typesv1.ValTime(p.Timestamp)
		case ruleAction116:
			p.Literal = typesv1.ValF64(p.F64)
		case ruleAction117:
			p.Literal = typesv1.ValI64(p.I64)
		case ruleAction118:
			p.Literal = typesv1.ValBool(p.Bool)
		case ruleAction119:
			p.Literal = typesv1.ValArr(p.popArray()...)
		case ruleAction120:
			p.Literal = typesv1.ValObj(p.popObj()...)
		case ruleAction121:
			p.pushFunc()
		case ruleAction122:
			p.setFuncName(text)
		case ruleAction123:
			p.addFuncArg(p.popExpr())
		case ruleAction124:
			p.pushExpr(typesv1.ExprIdentifier(text))
		case ruleAction125:
			p.pushExpr(typesv1.ExprIdentifier(text))
		case ruleAction126:
			p.pushExpr(typesv1.ExprIdentifier(text))
		case ruleAction127:
			p.String = p.parseDoubleQuoteString(text)
		case ruleAction128:
			p.F64 = p.parseFloat64(text)
		case ruleAction129:
			p.F64 = p.parseFloat64(text)
		case ruleAction130:
			p.F64 = p.parseFloat64(text)
		case ruleAction131:
			p.I64 = 0
		case ruleAction132:
			p.I64 = p.parseInt64(text)
		case ruleAction133:
			p.Bool = true
		case ruleAction134:
			p.Bool = false
		case ruleAction135:
			p.pushArray()
		case ruleAction136:
			p.addArrItem(p.Literal)
			p.Literal = nil
		case ruleAction137:
			p.pushObj()
		case ruleAction138:
			p.closeObjItem(p.Literal)
			p.Literal = nil
		case ruleAction139:
			p.startObjItem(p.String)
		case ruleAction140:
			p.Duration = p.parseDurationF64(p.F64, text)
		case ruleAction141:
			p.Duration = p.parseDurationI64(p.I64, text)
		case ruleAction142:
			p.Timestamp = p.parseTime(time.RFC3339Nano, text)

		}
	}
	_, _, _, _, _ = buffer, _buffer, text, begin, end
}

func Pretty(pretty bool) func(*logQL) error {
	return func(p *logQL) error {
		p.Pretty = pretty
		return nil
	}
}

func Size(size int) func(*logQL) error {
	return func(p *logQL) error {
		p.tokens32 = tokens32{tree: make([]token32, 0, size)}
		return nil
	}
}
func (p *logQL) Init(options ...func(*logQL) error) error {
	var (
		max                  token32
		position, tokenIndex uint32
		buffer               []rune
	)
	for _, option := range options {
		err := option(p)
		if err != nil {
			return err
		}
	}
	p.reset = func() {
		max = token32{}
		position, tokenIndex = 0, 0

		p.buffer = []rune(p.Buffer)
		if len(p.buffer) == 0 || p.buffer[len(p.buffer)-1] != endSymbol {
			p.buffer = append(p.buffer, endSymbol)
		}
		buffer = p.buffer
	}
	p.reset()

	_rules := p.rules
	tree := p.tokens32
	p.parse = func(rule ...int) error {
		r := 1
		if len(rule) > 0 {
			r = rule[0]
		}
		matches := p.rules[r]()
		p.tokens32 = tree
		if matches {
			p.Trim(tokenIndex)
			return nil
		}
		return &parseError{p, max}
	}

	add := func(rule pegRule, begin uint32) {
		tree.Add(rule, begin, position, tokenIndex)
		tokenIndex++
		if begin != position && position > max.end {
			max = token32{rule, begin, position}
		}
	}

	matchDot := func() bool {
		if buffer[position] != endSymbol {
			position++
			return true
		}
		return false
	}

	/*matchChar := func(c byte) bool {
		if buffer[position] == c {
			position++
			return true
		}
		return false
	}*/

	/*matchRange := func(lower byte, upper byte) bool {
		if c := buffer[position]; c >= lower && c <= upper {
			position++
			return true
		}
		return false
	}*/

	_rules = [...]func() bool{
		nil,
		/* 0 Grammar <- <(Space ((Statements Action0) / ((QueryContext MustSpace)? Statements Action1) / QueryContext)? RenderStatement? EOF)> */
		func() bool {
			position0, tokenIndex0 := position, tokenIndex
			{
				position1 := position
				if !_rules[ruleSpace]() {
					goto l0
				}
				{
					position2, tokenIndex2 := position, tokenIndex
					{
						position4, tokenIndex4 := position, tokenIndex
						if !_rules[ruleStatements]() {
							goto l5
						}
						if !_rules[ruleAction0]() {
							goto l5
						}
						goto l4
					l5:
						position, tokenIndex = position4, tokenIndex4
						{
							position7, tokenIndex7 := position, tokenIndex
							if !_rules[ruleQueryContext]() {
								goto l7
							}
							if !_rules[ruleMustSpace]() {
								goto l7
							}
							goto l8
						l7:
							position, tokenIndex = position7, tokenIndex7
						}
					l8:
						if !_rules[ruleStatements]() {
							goto l6
						}
						if !_rules[ruleAction1]() {
							goto l6
						}
						goto l4
					l6:
						position, tokenIndex = position4, tokenIndex4
						if !_rules[ruleQueryContext]() {
							goto l2
						}
					}
				l4:
					goto l3
				l2:
					position, tokenIndex = position2, tokenIndex2
				}
			l3:
				{
					position9, tokenIndex9 := position, tokenIndex
					if !_rules[ruleRenderStatement]() {
						goto l9
					}
					goto l10
				l9:
					position, tokenIndex = position9, tokenIndex9
				}
			l10:
				if !_rules[ruleEOF]() {
					goto l0
				}
				add(ruleGrammar, position1)
			}
			return true
		l0:
			position, tokenIndex = position0, tokenIndex0
			return false
		},
		/* 1 QueryContext <- <(L_SQUIGGLY Space QueryContextItem+ R_SQUIGGLY)> */
		func() bool {
			position11, tokenIndex11 := position, tokenIndex
			{
				position12 := position
				if !_rules[ruleL_SQUIGGLY]() {
					goto l11
				}
				if !_rules[ruleSpace]() {
					goto l11
				}
				if !_rules[ruleQueryContextItem]() {
					goto l11
				}
			l13:
				{
					position14, tokenIndex14 := position, tokenIndex
					if !_rules[ruleQueryContextItem]() {
						goto l14
					}
					goto l13
				l14:
					position, tokenIndex = position14, tokenIndex14
				}
				if !_rules[ruleR_SQUIGGLY]() {
					goto l11
				}
				add(ruleQueryContext, position12)
			}
			return true
		l11:
			position, tokenIndex = position11, tokenIndex11
			return false
		},
		/* 2 QueryContextItem <- <((QueryMachineContext / QuerySessionContext / QueryFrom / QueryTo) Space)> */
		func() bool {
			position15, tokenIndex15 := position, tokenIndex
			{
				position16 := position
				{
					position17, tokenIndex17 := position, tokenIndex
					if !_rules[ruleQueryMachineContext]() {
						goto l18
					}
					goto l17
				l18:
					position, tokenIndex = position17, tokenIndex17
					if !_rules[ruleQuerySessionContext]() {
						goto l19
					}
					goto l17
				l19:
					position, tokenIndex = position17, tokenIndex17
					if !_rules[ruleQueryFrom]() {
						goto l20
					}
					goto l17
				l20:
					position, tokenIndex = position17, tokenIndex17
					if !_rules[ruleQueryTo]() {
						goto l15
					}
				}
			l17:
				if !_rules[ruleSpace]() {
					goto l15
				}
				add(ruleQueryContextItem, position16)
			}
			return true
		l15:
			position, tokenIndex = position15, tokenIndex15
			return false
		},
		/* 3 QueryFrom <- <('f' 'r' 'o' 'm' Space CMP_EQ Space Expr Action2)> */
		func() bool {
			position21, tokenIndex21 := position, tokenIndex
			{
				position22 := position
				if buffer[position] != rune('f') {
					goto l21
				}
				position++
				if buffer[position] != rune('r') {
					goto l21
				}
				position++
				if buffer[position] != rune('o') {
					goto l21
				}
				position++
				if buffer[position] != rune('m') {
					goto l21
				}
				position++
				if !_rules[ruleSpace]() {
					goto l21
				}
				if !_rules[ruleCMP_EQ]() {
					goto l21
				}
				if !_rules[ruleSpace]() {
					goto l21
				}
				if !_rules[ruleExpr]() {
					goto l21
				}
				if !_rules[ruleAction2]() {
					goto l21
				}
				add(ruleQueryFrom, position22)
			}
			return true
		l21:
			position, tokenIndex = position21, tokenIndex21
			return false
		},
		/* 4 QueryTo <- <('t' 'o' Space CMP_EQ Space Expr Action3)> */
		func() bool {
			position23, tokenIndex23 := position, tokenIndex
			{
				position24 := position
				if buffer[position] != rune('t') {
					goto l23
				}
				position++
				if buffer[position] != rune('o') {
					goto l23
				}
				position++
				if !_rules[ruleSpace]() {
					goto l23
				}
				if !_rules[ruleCMP_EQ]() {
					goto l23
				}
				if !_rules[ruleSpace]() {
					goto l23
				}
				if !_rules[ruleExpr]() {
					goto l23
				}
				if !_rules[ruleAction3]() {
					goto l23
				}
				add(ruleQueryTo, position24)
			}
			return true
		l23:
			position, tokenIndex = position23, tokenIndex23
			return false
		},
		/* 5 QueryMachineContext <- <('m' 'a' 'c' 'h' 'i' 'n' 'e' Space ((CMP_EQ Space Expr Action4) / (CMP_NOTEQ Space Expr Action5) / (SET_IN Space Expr Action6) / (SET_NOTIN Space Expr Action7)))> */
		func() bool {
			position25, tokenIndex25 := position, tokenIndex
			{
				position26 := position
				if buffer[position] != rune('m') {
					goto l25
				}
				position++
				if buffer[position] != rune('a') {
					goto l25
				}
				position++
				if buffer[position] != rune('c') {
					goto l25
				}
				position++
				if buffer[position] != rune('h') {
					goto l25
				}
				position++
				if buffer[position] != rune('i') {
					goto l25
				}
				position++
				if buffer[position] != rune('n') {
					goto l25
				}
				position++
				if buffer[position] != rune('e') {
					goto l25
				}
				position++
				if !_rules[ruleSpace]() {
					goto l25
				}
				{
					position27, tokenIndex27 := position, tokenIndex
					if !_rules[ruleCMP_EQ]() {
						goto l28
					}
					if !_rules[ruleSpace]() {
						goto l28
					}
					if !_rules[ruleExpr]() {
						goto l28
					}
					if !_rules[ruleAction4]() {
						goto l28
					}
					goto l27
				l28:
					position, tokenIndex = position27, tokenIndex27
					if !_rules[ruleCMP_NOTEQ]() {
						goto l29
					}
					if !_rules[ruleSpace]() {
						goto l29
					}
					if !_rules[ruleExpr]() {
						goto l29
					}
					if !_rules[ruleAction5]() {
						goto l29
					}
					goto l27
				l29:
					position, tokenIndex = position27, tokenIndex27
					if !_rules[ruleSET_IN]() {
						goto l30
					}
					if !_rules[ruleSpace]() {
						goto l30
					}
					if !_rules[ruleExpr]() {
						goto l30
					}
					if !_rules[ruleAction6]() {
						goto l30
					}
					goto l27
				l30:
					position, tokenIndex = position27, tokenIndex27
					if !_rules[ruleSET_NOTIN]() {
						goto l25
					}
					if !_rules[ruleSpace]() {
						goto l25
					}
					if !_rules[ruleExpr]() {
						goto l25
					}
					if !_rules[ruleAction7]() {
						goto l25
					}
				}
			l27:
				add(ruleQueryMachineContext, position26)
			}
			return true
		l25:
			position, tokenIndex = position25, tokenIndex25
			return false
		},
		/* 6 QuerySessionContext <- <('s' 'e' 's' 's' 'i' 'o' 'n' Space ((CMP_EQ Space Expr Action8) / (CMP_NOTEQ Space Expr Action9) / (SET_IN Space Expr Action10) / (SET_NOTIN Space Expr Action11)))> */
		func() bool {
			position31, tokenIndex31 := position, tokenIndex
			{
				position32 := position
				if buffer[position] != rune('s') {
					goto l31
				}
				position++
				if buffer[position] != rune('e') {
					goto l31
				}
				position++
				if buffer[position] != rune('s') {
					goto l31
				}
				position++
				if buffer[position] != rune('s') {
					goto l31
				}
				position++
				if buffer[position] != rune('i') {
					goto l31
				}
				position++
				if buffer[position] != rune('o') {
					goto l31
				}
				position++
				if buffer[position] != rune('n') {
					goto l31
				}
				position++
				if !_rules[ruleSpace]() {
					goto l31
				}
				{
					position33, tokenIndex33 := position, tokenIndex
					if !_rules[ruleCMP_EQ]() {
						goto l34
					}
					if !_rules[ruleSpace]() {
						goto l34
					}
					if !_rules[ruleExpr]() {
						goto l34
					}
					if !_rules[ruleAction8]() {
						goto l34
					}
					goto l33
				l34:
					position, tokenIndex = position33, tokenIndex33
					if !_rules[ruleCMP_NOTEQ]() {
						goto l35
					}
					if !_rules[ruleSpace]() {
						goto l35
					}
					if !_rules[ruleExpr]() {
						goto l35
					}
					if !_rules[ruleAction9]() {
						goto l35
					}
					goto l33
				l35:
					position, tokenIndex = position33, tokenIndex33
					if !_rules[ruleSET_IN]() {
						goto l36
					}
					if !_rules[ruleSpace]() {
						goto l36
					}
					if !_rules[ruleExpr]() {
						goto l36
					}
					if !_rules[ruleAction10]() {
						goto l36
					}
					goto l33
				l36:
					position, tokenIndex = position33, tokenIndex33
					if !_rules[ruleSET_NOTIN]() {
						goto l31
					}
					if !_rules[ruleSpace]() {
						goto l31
					}
					if !_rules[ruleExpr]() {
						goto l31
					}
					if !_rules[ruleAction11]() {
						goto l31
					}
				}
			l33:
				add(ruleQuerySessionContext, position32)
			}
			return true
		l31:
			position, tokenIndex = position31, tokenIndex31
			return false
		},
		/* 7 Statements <- <(Statement (Space PIPE Space Statement)*)> */
		func() bool {
			position37, tokenIndex37 := position, tokenIndex
			{
				position38 := position
				if !_rules[ruleStatement]() {
					goto l37
				}
			l39:
				{
					position40, tokenIndex40 := position, tokenIndex
					if !_rules[ruleSpace]() {
						goto l40
					}
					if !_rules[rulePIPE]() {
						goto l40
					}
					if !_rules[ruleSpace]() {
						goto l40
					}
					if !_rules[ruleStatement]() {
						goto l40
					}
					goto l39
				l40:
					position, tokenIndex = position40, tokenIndex40
				}
				add(ruleStatements, position38)
			}
			return true
		l37:
			position, tokenIndex = position37, tokenIndex37
			return false
		},
		/* 8 Statement <- <(((('f' 'i' 'l' 't' 'e' 'r') / ('w' 'h' 'e' 'r' 'e')) FilterOperator Action12) / ('s' 'u' 'm' 'm' 'a' 'r' 'i' 'z' 'e' SummarizeOperator Action13) / ('p' 'r' 'o' 'j' 'e' 'c' 't' ProjectOperator Action14) / ('p' 'r' 'o' 'j' 'e' 'c' 't' '-' 'a' 'w' 'a' 'y' ProjectAwayOperator Action15) / ('p' 'r' 'o' 'j' 'e' 'c' 't' '-' 'k' 'e' 'e' 'p' ProjectKeepOperator Action16) / ('e' 'x' 't' 'e' 'n' 'd' ExtendOperator Action17) / ('c' 'o' 'u' 'n' 't' CountOperator Action18) / ('d' 'i' 's' 't' 'i' 'n' 'c' 't' DistinctOperator Action19) / ('s' 'a' 'm' 'p' 'l' 'e' SampleOperator Action20) / ('s' 'e' 'a' 'r' 'c' 'h' SearchOperator Action21) / ('s' 'o' 'r' 't' SortOperator Action22) / ('t' 'a' 'k' 'e' TakeOperator Action23) / ('t' 'o' 'p' TopOperator Action24))> */
		func() bool {
			position41, tokenIndex41 := position, tokenIndex
			{
				position42 := position
				{
					position43, tokenIndex43 := position, tokenIndex
					{
						position45, tokenIndex45 := position, tokenIndex
						if buffer[position] != rune('f') {
							goto l46
						}
						position++
						if buffer[position] != rune('i') {
							goto l46
						}
						position++
						if buffer[position] != rune('l') {
							goto l46
						}
						position++
						if buffer[position] != rune('t') {
							goto l46
						}
						position++
						if buffer[position] != rune('e') {
							goto l46
						}
						position++
						if buffer[position] != rune('r') {
							goto l46
						}
						position++
						goto l45
					l46:
						position, tokenIndex = position45, tokenIndex45
						if buffer[position] != rune('w') {
							goto l44
						}
						position++
						if buffer[position] != rune('h') {
							goto l44
						}
						position++
						if buffer[position] != rune('e') {
							goto l44
						}
						position++
						if buffer[position] != rune('r') {
							goto l44
						}
						position++
						if buffer[position] != rune('e') {
							goto l44
						}
						position++
					}
				l45:
					if !_rules[ruleFilterOperator]() {
						goto l44
					}
					if !_rules[ruleAction12]() {
						goto l44
					}
					goto l43
				l44:
					position, tokenIndex = position43, tokenIndex43
					if buffer[position] != rune('s') {
						goto l47
					}
					position++
					if buffer[position] != rune('u') {
						goto l47
					}
					position++
					if buffer[position] != rune('m') {
						goto l47
					}
					position++
					if buffer[position] != rune('m') {
						goto l47
					}
					position++
					if buffer[position] != rune('a') {
						goto l47
					}
					position++
					if buffer[position] != rune('r') {
						goto l47
					}
					position++
					if buffer[position] != rune('i') {
						goto l47
					}
					position++
					if buffer[position] != rune('z') {
						goto l47
					}
					position++
					if buffer[position] != rune('e') {
						goto l47
					}
					position++
					if !_rules[ruleSummarizeOperator]() {
						goto l47
					}
					if !_rules[ruleAction13]() {
						goto l47
					}
					goto l43
				l47:
					position, tokenIndex = position43, tokenIndex43
					if buffer[position] != rune('p') {
						goto l48
					}
					position++
					if buffer[position] != rune('r') {
						goto l48
					}
					position++
					if buffer[position] != rune('o') {
						goto l48
					}
					position++
					if buffer[position] != rune('j') {
						goto l48
					}
					position++
					if buffer[position] != rune('e') {
						goto l48
					}
					position++
					if buffer[position] != rune('c') {
						goto l48
					}
					position++
					if buffer[position] != rune('t') {
						goto l48
					}
					position++
					if !_rules[ruleProjectOperator]() {
						goto l48
					}
					if !_rules[ruleAction14]() {
						goto l48
					}
					goto l43
				l48:
					position, tokenIndex = position43, tokenIndex43
					if buffer[position] != rune('p') {
						goto l49
					}
					position++
					if buffer[position] != rune('r') {
						goto l49
					}
					position++
					if buffer[position] != rune('o') {
						goto l49
					}
					position++
					if buffer[position] != rune('j') {
						goto l49
					}
					position++
					if buffer[position] != rune('e') {
						goto l49
					}
					position++
					if buffer[position] != rune('c') {
						goto l49
					}
					position++
					if buffer[position] != rune('t') {
						goto l49
					}
					position++
					if buffer[position] != rune('-') {
						goto l49
					}
					position++
					if buffer[position] != rune('a') {
						goto l49
					}
					position++
					if buffer[position] != rune('w') {
						goto l49
					}
					position++
					if buffer[position] != rune('a') {
						goto l49
					}
					position++
					if buffer[position] != rune('y') {
						goto l49
					}
					position++
					if !_rules[ruleProjectAwayOperator]() {
						goto l49
					}
					if !_rules[ruleAction15]() {
						goto l49
					}
					goto l43
				l49:
					position, tokenIndex = position43, tokenIndex43
					if buffer[position] != rune('p') {
						goto l50
					}
					position++
					if buffer[position] != rune('r') {
						goto l50
					}
					position++
					if buffer[position] != rune('o') {
						goto l50
					}
					position++
					if buffer[position] != rune('j') {
						goto l50
					}
					position++
					if buffer[position] != rune('e') {
						goto l50
					}
					position++
					if buffer[position] != rune('c') {
						goto l50
					}
					position++
					if buffer[position] != rune('t') {
						goto l50
					}
					position++
					if buffer[position] != rune('-') {
						goto l50
					}
					position++
					if buffer[position] != rune('k') {
						goto l50
					}
					position++
					if buffer[position] != rune('e') {
						goto l50
					}
					position++
					if buffer[position] != rune('e') {
						goto l50
					}
					position++
					if buffer[position] != rune('p') {
						goto l50
					}
					position++
					if !_rules[ruleProjectKeepOperator]() {
						goto l50
					}
					if !_rules[ruleAction16]() {
						goto l50
					}
					goto l43
				l50:
					position, tokenIndex = position43, tokenIndex43
					if buffer[position] != rune('e') {
						goto l51
					}
					position++
					if buffer[position] != rune('x') {
						goto l51
					}
					position++
					if buffer[position] != rune('t') {
						goto l51
					}
					position++
					if buffer[position] != rune('e') {
						goto l51
					}
					position++
					if buffer[position] != rune('n') {
						goto l51
					}
					position++
					if buffer[position] != rune('d') {
						goto l51
					}
					position++
					if !_rules[ruleExtendOperator]() {
						goto l51
					}
					if !_rules[ruleAction17]() {
						goto l51
					}
					goto l43
				l51:
					position, tokenIndex = position43, tokenIndex43
					if buffer[position] != rune('c') {
						goto l52
					}
					position++
					if buffer[position] != rune('o') {
						goto l52
					}
					position++
					if buffer[position] != rune('u') {
						goto l52
					}
					position++
					if buffer[position] != rune('n') {
						goto l52
					}
					position++
					if buffer[position] != rune('t') {
						goto l52
					}
					position++
					if !_rules[ruleCountOperator]() {
						goto l52
					}
					if !_rules[ruleAction18]() {
						goto l52
					}
					goto l43
				l52:
					position, tokenIndex = position43, tokenIndex43
					if buffer[position] != rune('d') {
						goto l53
					}
					position++
					if buffer[position] != rune('i') {
						goto l53
					}
					position++
					if buffer[position] != rune('s') {
						goto l53
					}
					position++
					if buffer[position] != rune('t') {
						goto l53
					}
					position++
					if buffer[position] != rune('i') {
						goto l53
					}
					position++
					if buffer[position] != rune('n') {
						goto l53
					}
					position++
					if buffer[position] != rune('c') {
						goto l53
					}
					position++
					if buffer[position] != rune('t') {
						goto l53
					}
					position++
					if !_rules[ruleDistinctOperator]() {
						goto l53
					}
					if !_rules[ruleAction19]() {
						goto l53
					}
					goto l43
				l53:
					position, tokenIndex = position43, tokenIndex43
					if buffer[position] != rune('s') {
						goto l54
					}
					position++
					if buffer[position] != rune('a') {
						goto l54
					}
					position++
					if buffer[position] != rune('m') {
						goto l54
					}
					position++
					if buffer[position] != rune('p') {
						goto l54
					}
					position++
					if buffer[position] != rune('l') {
						goto l54
					}
					position++
					if buffer[position] != rune('e') {
						goto l54
					}
					position++
					if !_rules[ruleSampleOperator]() {
						goto l54
					}
					if !_rules[ruleAction20]() {
						goto l54
					}
					goto l43
				l54:
					position, tokenIndex = position43, tokenIndex43
					if buffer[position] != rune('s') {
						goto l55
					}
					position++
					if buffer[position] != rune('e') {
						goto l55
					}
					position++
					if buffer[position] != rune('a') {
						goto l55
					}
					position++
					if buffer[position] != rune('r') {
						goto l55
					}
					position++
					if buffer[position] != rune('c') {
						goto l55
					}
					position++
					if buffer[position] != rune('h') {
						goto l55
					}
					position++
					if !_rules[ruleSearchOperator]() {
						goto l55
					}
					if !_rules[ruleAction21]() {
						goto l55
					}
					goto l43
				l55:
					position, tokenIndex = position43, tokenIndex43
					if buffer[position] != rune('s') {
						goto l56
					}
					position++
					if buffer[position] != rune('o') {
						goto l56
					}
					position++
					if buffer[position] != rune('r') {
						goto l56
					}
					position++
					if buffer[position] != rune('t') {
						goto l56
					}
					position++
					if !_rules[ruleSortOperator]() {
						goto l56
					}
					if !_rules[ruleAction22]() {
						goto l56
					}
					goto l43
				l56:
					position, tokenIndex = position43, tokenIndex43
					if buffer[position] != rune('t') {
						goto l57
					}
					position++
					if buffer[position] != rune('a') {
						goto l57
					}
					position++
					if buffer[position] != rune('k') {
						goto l57
					}
					position++
					if buffer[position] != rune('e') {
						goto l57
					}
					position++
					if !_rules[ruleTakeOperator]() {
						goto l57
					}
					if !_rules[ruleAction23]() {
						goto l57
					}
					goto l43
				l57:
					position, tokenIndex = position43, tokenIndex43
					if buffer[position] != rune('t') {
						goto l41
					}
					position++
					if buffer[position] != rune('o') {
						goto l41
					}
					position++
					if buffer[position] != rune('p') {
						goto l41
					}
					position++
					if !_rules[ruleTopOperator]() {
						goto l41
					}
					if !_rules[ruleAction24]() {
						goto l41
					}
				}
			l43:
				add(ruleStatement, position42)
			}
			return true
		l41:
			position, tokenIndex = position41, tokenIndex41
			return false
		},
		/* 9 RenderStatement <- <(Space PIPE Space ('r' 'e' 'n' 'd' 'e' 'r') MustSpace RenderSplitOperator Action25)> */
		func() bool {
			position58, tokenIndex58 := position, tokenIndex
			{
				position59 := position
				if !_rules[ruleSpace]() {
					goto l58
				}
				if !_rules[rulePIPE]() {
					goto l58
				}
				if !_rules[ruleSpace]() {
					goto l58
				}
				if buffer[position] != rune('r') {
					goto l58
				}
				position++
				if buffer[position] != rune('e') {
					goto l58
				}
				position++
				if buffer[position] != rune('n') {
					goto l58
				}
				position++
				if buffer[position] != rune('d') {
					goto l58
				}
				position++
				if buffer[position] != rune('e') {
					goto l58
				}
				position++
				if buffer[position] != rune('r') {
					goto l58
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l58
				}
				if !_rules[ruleRenderSplitOperator]() {
					goto l58
				}
				if !_rules[ruleAction25]() {
					goto l58
				}
				add(ruleRenderStatement, position59)
			}
			return true
		l58:
			position, tokenIndex = position58, tokenIndex58
			return false
		},
		/* 10 FilterOperator <- <(MustSpace Expr Action26)> */
		func() bool {
			position60, tokenIndex60 := position, tokenIndex
			{
				position61 := position
				if !_rules[ruleMustSpace]() {
					goto l60
				}
				if !_rules[ruleExpr]() {
					goto l60
				}
				if !_rules[ruleAction26]() {
					goto l60
				}
				add(ruleFilterOperator, position61)
			}
			return true
		l60:
			position, tokenIndex = position60, tokenIndex60
			return false
		},
		/* 11 SummarizeOperator <- <(MustSpace Action27 SummarizeParameters SummarizeByGroupExpressions?)> */
		func() bool {
			position62, tokenIndex62 := position, tokenIndex
			{
				position63 := position
				if !_rules[ruleMustSpace]() {
					goto l62
				}
				if !_rules[ruleAction27]() {
					goto l62
				}
				if !_rules[ruleSummarizeParameters]() {
					goto l62
				}
				{
					position64, tokenIndex64 := position, tokenIndex
					if !_rules[ruleSummarizeByGroupExpressions]() {
						goto l64
					}
					goto l65
				l64:
					position, tokenIndex = position64, tokenIndex64
				}
			l65:
				add(ruleSummarizeOperator, position63)
			}
			return true
		l62:
			position, tokenIndex = position62, tokenIndex62
			return false
		},
		/* 12 SummarizeParameters <- <(SummarizeParameter (Space ',' Space SummarizeParameter)* Space)> */
		func() bool {
			position66, tokenIndex66 := position, tokenIndex
			{
				position67 := position
				if !_rules[ruleSummarizeParameter]() {
					goto l66
				}
			l68:
				{
					position69, tokenIndex69 := position, tokenIndex
					if !_rules[ruleSpace]() {
						goto l69
					}
					if buffer[position] != rune(',') {
						goto l69
					}
					position++
					if !_rules[ruleSpace]() {
						goto l69
					}
					if !_rules[ruleSummarizeParameter]() {
						goto l69
					}
					goto l68
				l69:
					position, tokenIndex = position69, tokenIndex69
				}
				if !_rules[ruleSpace]() {
					goto l66
				}
				add(ruleSummarizeParameters, position67)
			}
			return true
		l66:
			position, tokenIndex = position66, tokenIndex66
			return false
		},
		/* 13 SummarizeParameter <- <((Identifier Action28 (Space '=' Space FuncCall) Action29) / (FuncCall Action30))> */
		func() bool {
			position70, tokenIndex70 := position, tokenIndex
			{
				position71 := position
				{
					position72, tokenIndex72 := position, tokenIndex
					if !_rules[ruleIdentifier]() {
						goto l73
					}
					if !_rules[ruleAction28]() {
						goto l73
					}
					if !_rules[ruleSpace]() {
						goto l73
					}
					if buffer[position] != rune('=') {
						goto l73
					}
					position++
					if !_rules[ruleSpace]() {
						goto l73
					}
					if !_rules[ruleFuncCall]() {
						goto l73
					}
					if !_rules[ruleAction29]() {
						goto l73
					}
					goto l72
				l73:
					position, tokenIndex = position72, tokenIndex72
					if !_rules[ruleFuncCall]() {
						goto l70
					}
					if !_rules[ruleAction30]() {
						goto l70
					}
				}
			l72:
				add(ruleSummarizeParameter, position71)
			}
			return true
		l70:
			position, tokenIndex = position70, tokenIndex70
			return false
		},
		/* 14 SummarizeByGroupExpressions <- <('b' 'y' MustSpace SummarizeByGroupExpression (Space ',' Space SummarizeByGroupExpression)* Space)> */
		func() bool {
			position74, tokenIndex74 := position, tokenIndex
			{
				position75 := position
				if buffer[position] != rune('b') {
					goto l74
				}
				position++
				if buffer[position] != rune('y') {
					goto l74
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l74
				}
				if !_rules[ruleSummarizeByGroupExpression]() {
					goto l74
				}
			l76:
				{
					position77, tokenIndex77 := position, tokenIndex
					if !_rules[ruleSpace]() {
						goto l77
					}
					if buffer[position] != rune(',') {
						goto l77
					}
					position++
					if !_rules[ruleSpace]() {
						goto l77
					}
					if !_rules[ruleSummarizeByGroupExpression]() {
						goto l77
					}
					goto l76
				l77:
					position, tokenIndex = position77, tokenIndex77
				}
				if !_rules[ruleSpace]() {
					goto l74
				}
				add(ruleSummarizeByGroupExpressions, position75)
			}
			return true
		l74:
			position, tokenIndex = position74, tokenIndex74
			return false
		},
		/* 15 SummarizeByGroupExpression <- <((Identifier Action31 (Space '=' Space Expr Action32)) / (Expr Action33))> */
		func() bool {
			position78, tokenIndex78 := position, tokenIndex
			{
				position79 := position
				{
					position80, tokenIndex80 := position, tokenIndex
					if !_rules[ruleIdentifier]() {
						goto l81
					}
					if !_rules[ruleAction31]() {
						goto l81
					}
					if !_rules[ruleSpace]() {
						goto l81
					}
					if buffer[position] != rune('=') {
						goto l81
					}
					position++
					if !_rules[ruleSpace]() {
						goto l81
					}
					if !_rules[ruleExpr]() {
						goto l81
					}
					if !_rules[ruleAction32]() {
						goto l81
					}
					goto l80
				l81:
					position, tokenIndex = position80, tokenIndex80
					if !_rules[ruleExpr]() {
						goto l78
					}
					if !_rules[ruleAction33]() {
						goto l78
					}
				}
			l80:
				add(ruleSummarizeByGroupExpression, position79)
			}
			return true
		l78:
			position, tokenIndex = position78, tokenIndex78
			return false
		},
		/* 16 ProjectOperator <- <(MustSpace Action34 ProjectArg (Space ',' Space ProjectArg)* Space)> */
		func() bool {
			position82, tokenIndex82 := position, tokenIndex
			{
				position83 := position
				if !_rules[ruleMustSpace]() {
					goto l82
				}
				if !_rules[ruleAction34]() {
					goto l82
				}
				if !_rules[ruleProjectArg]() {
					goto l82
				}
			l84:
				{
					position85, tokenIndex85 := position, tokenIndex
					if !_rules[ruleSpace]() {
						goto l85
					}
					if buffer[position] != rune(',') {
						goto l85
					}
					position++
					if !_rules[ruleSpace]() {
						goto l85
					}
					if !_rules[ruleProjectArg]() {
						goto l85
					}
					goto l84
				l85:
					position, tokenIndex = position85, tokenIndex85
				}
				if !_rules[ruleSpace]() {
					goto l82
				}
				add(ruleProjectOperator, position83)
			}
			return true
		l82:
			position, tokenIndex = position82, tokenIndex82
			return false
		},
		/* 17 ProjectArg <- <(Identifier Action35 (Space '=' Space Expr Action36)?)> */
		func() bool {
			position86, tokenIndex86 := position, tokenIndex
			{
				position87 := position
				if !_rules[ruleIdentifier]() {
					goto l86
				}
				if !_rules[ruleAction35]() {
					goto l86
				}
				{
					position88, tokenIndex88 := position, tokenIndex
					if !_rules[ruleSpace]() {
						goto l88
					}
					if buffer[position] != rune('=') {
						goto l88
					}
					position++
					if !_rules[ruleSpace]() {
						goto l88
					}
					if !_rules[ruleExpr]() {
						goto l88
					}
					if !_rules[ruleAction36]() {
						goto l88
					}
					goto l89
				l88:
					position, tokenIndex = position88, tokenIndex88
				}
			l89:
				add(ruleProjectArg, position87)
			}
			return true
		l86:
			position, tokenIndex = position86, tokenIndex86
			return false
		},
		/* 18 ProjectAwayOperator <- <(MustSpace Action37 ProjectAwayArg (Space ',' Space ProjectAwayArg)* Space)> */
		func() bool {
			position90, tokenIndex90 := position, tokenIndex
			{
				position91 := position
				if !_rules[ruleMustSpace]() {
					goto l90
				}
				if !_rules[ruleAction37]() {
					goto l90
				}
				if !_rules[ruleProjectAwayArg]() {
					goto l90
				}
			l92:
				{
					position93, tokenIndex93 := position, tokenIndex
					if !_rules[ruleSpace]() {
						goto l93
					}
					if buffer[position] != rune(',') {
						goto l93
					}
					position++
					if !_rules[ruleSpace]() {
						goto l93
					}
					if !_rules[ruleProjectAwayArg]() {
						goto l93
					}
					goto l92
				l93:
					position, tokenIndex = position93, tokenIndex93
				}
				if !_rules[ruleSpace]() {
					goto l90
				}
				add(ruleProjectAwayOperator, position91)
			}
			return true
		l90:
			position, tokenIndex = position90, tokenIndex90
			return false
		},
		/* 19 ProjectAwayArg <- <(Identifier Action38)> */
		func() bool {
			position94, tokenIndex94 := position, tokenIndex
			{
				position95 := position
				if !_rules[ruleIdentifier]() {
					goto l94
				}
				if !_rules[ruleAction38]() {
					goto l94
				}
				add(ruleProjectAwayArg, position95)
			}
			return true
		l94:
			position, tokenIndex = position94, tokenIndex94
			return false
		},
		/* 20 ProjectKeepOperator <- <(MustSpace Action39 ProjectKeepArg (Space ',' Space ProjectKeepArg)* Space)> */
		func() bool {
			position96, tokenIndex96 := position, tokenIndex
			{
				position97 := position
				if !_rules[ruleMustSpace]() {
					goto l96
				}
				if !_rules[ruleAction39]() {
					goto l96
				}
				if !_rules[ruleProjectKeepArg]() {
					goto l96
				}
			l98:
				{
					position99, tokenIndex99 := position, tokenIndex
					if !_rules[ruleSpace]() {
						goto l99
					}
					if buffer[position] != rune(',') {
						goto l99
					}
					position++
					if !_rules[ruleSpace]() {
						goto l99
					}
					if !_rules[ruleProjectKeepArg]() {
						goto l99
					}
					goto l98
				l99:
					position, tokenIndex = position99, tokenIndex99
				}
				if !_rules[ruleSpace]() {
					goto l96
				}
				add(ruleProjectKeepOperator, position97)
			}
			return true
		l96:
			position, tokenIndex = position96, tokenIndex96
			return false
		},
		/* 21 ProjectKeepArg <- <(Identifier Action40)> */
		func() bool {
			position100, tokenIndex100 := position, tokenIndex
			{
				position101 := position
				if !_rules[ruleIdentifier]() {
					goto l100
				}
				if !_rules[ruleAction40]() {
					goto l100
				}
				add(ruleProjectKeepArg, position101)
			}
			return true
		l100:
			position, tokenIndex = position100, tokenIndex100
			return false
		},
		/* 22 ExtendOperator <- <(MustSpace Action41 ExtendArg (Space ',' Space ExtendArg)* Space)> */
		func() bool {
			position102, tokenIndex102 := position, tokenIndex
			{
				position103 := position
				if !_rules[ruleMustSpace]() {
					goto l102
				}
				if !_rules[ruleAction41]() {
					goto l102
				}
				if !_rules[ruleExtendArg]() {
					goto l102
				}
			l104:
				{
					position105, tokenIndex105 := position, tokenIndex
					if !_rules[ruleSpace]() {
						goto l105
					}
					if buffer[position] != rune(',') {
						goto l105
					}
					position++
					if !_rules[ruleSpace]() {
						goto l105
					}
					if !_rules[ruleExtendArg]() {
						goto l105
					}
					goto l104
				l105:
					position, tokenIndex = position105, tokenIndex105
				}
				if !_rules[ruleSpace]() {
					goto l102
				}
				add(ruleExtendOperator, position103)
			}
			return true
		l102:
			position, tokenIndex = position102, tokenIndex102
			return false
		},
		/* 23 ExtendArg <- <(Identifier Action42 Space '=' Space Expr Action43)> */
		func() bool {
			position106, tokenIndex106 := position, tokenIndex
			{
				position107 := position
				if !_rules[ruleIdentifier]() {
					goto l106
				}
				if !_rules[ruleAction42]() {
					goto l106
				}
				if !_rules[ruleSpace]() {
					goto l106
				}
				if buffer[position] != rune('=') {
					goto l106
				}
				position++
				if !_rules[ruleSpace]() {
					goto l106
				}
				if !_rules[ruleExpr]() {
					goto l106
				}
				if !_rules[ruleAction43]() {
					goto l106
				}
				add(ruleExtendArg, position107)
			}
			return true
		l106:
			position, tokenIndex = position106, tokenIndex106
			return false
		},
		/* 24 CountOperator <- <Action44> */
		func() bool {
			position108, tokenIndex108 := position, tokenIndex
			{
				position109 := position
				if !_rules[ruleAction44]() {
					goto l108
				}
				add(ruleCountOperator, position109)
			}
			return true
		l108:
			position, tokenIndex = position108, tokenIndex108
			return false
		},
		/* 25 DistinctOperator <- <(Action45 MustSpace DistinctOperatorArg (Space ',' Space DistinctOperatorArg)*)> */
		func() bool {
			position110, tokenIndex110 := position, tokenIndex
			{
				position111 := position
				if !_rules[ruleAction45]() {
					goto l110
				}
				if !_rules[ruleMustSpace]() {
					goto l110
				}
				if !_rules[ruleDistinctOperatorArg]() {
					goto l110
				}
			l112:
				{
					position113, tokenIndex113 := position, tokenIndex
					if !_rules[ruleSpace]() {
						goto l113
					}
					if buffer[position] != rune(',') {
						goto l113
					}
					position++
					if !_rules[ruleSpace]() {
						goto l113
					}
					if !_rules[ruleDistinctOperatorArg]() {
						goto l113
					}
					goto l112
				l113:
					position, tokenIndex = position113, tokenIndex113
				}
				add(ruleDistinctOperator, position111)
			}
			return true
		l110:
			position, tokenIndex = position110, tokenIndex110
			return false
		},
		/* 26 DistinctOperatorArg <- <(Identifier Action46)> */
		func() bool {
			position114, tokenIndex114 := position, tokenIndex
			{
				position115 := position
				if !_rules[ruleIdentifier]() {
					goto l114
				}
				if !_rules[ruleAction46]() {
					goto l114
				}
				add(ruleDistinctOperatorArg, position115)
			}
			return true
		l114:
			position, tokenIndex = position114, tokenIndex114
			return false
		},
		/* 27 SampleOperator <- <(MustSpace Action47 I64 Space Action48)> */
		func() bool {
			position116, tokenIndex116 := position, tokenIndex
			{
				position117 := position
				if !_rules[ruleMustSpace]() {
					goto l116
				}
				if !_rules[ruleAction47]() {
					goto l116
				}
				if !_rules[ruleI64]() {
					goto l116
				}
				if !_rules[ruleSpace]() {
					goto l116
				}
				if !_rules[ruleAction48]() {
					goto l116
				}
				add(ruleSampleOperator, position117)
			}
			return true
		l116:
			position, tokenIndex = position116, tokenIndex116
			return false
		},
		/* 28 SearchOperator <- <(MustSpace Action49 ('k' 'i' 'n' 'd' Space '=' Space SearchOperatorCaseSensitivity MustSpace)? SearchOperatorPredicate)> */
		func() bool {
			position118, tokenIndex118 := position, tokenIndex
			{
				position119 := position
				if !_rules[ruleMustSpace]() {
					goto l118
				}
				if !_rules[ruleAction49]() {
					goto l118
				}
				{
					position120, tokenIndex120 := position, tokenIndex
					if buffer[position] != rune('k') {
						goto l120
					}
					position++
					if buffer[position] != rune('i') {
						goto l120
					}
					position++
					if buffer[position] != rune('n') {
						goto l120
					}
					position++
					if buffer[position] != rune('d') {
						goto l120
					}
					position++
					if !_rules[ruleSpace]() {
						goto l120
					}
					if buffer[position] != rune('=') {
						goto l120
					}
					position++
					if !_rules[ruleSpace]() {
						goto l120
					}
					if !_rules[ruleSearchOperatorCaseSensitivity]() {
						goto l120
					}
					if !_rules[ruleMustSpace]() {
						goto l120
					}
					goto l121
				l120:
					position, tokenIndex = position120, tokenIndex120
				}
			l121:
				if !_rules[ruleSearchOperatorPredicate]() {
					goto l118
				}
				add(ruleSearchOperator, position119)
			}
			return true
		l118:
			position, tokenIndex = position118, tokenIndex118
			return false
		},
		/* 29 SearchOperatorCaseSensitivity <- <(('d' 'e' 'f' 'a' 'u' 'l' 't' Action50) / ('c' 'a' 's' 'e' '_' 'i' 'n' 's' 'e' 'n' 's' 'i' 't' 'i' 'v' 'e' Action51) / ('c' 'a' 's' 'e' '_' 's' 'e' 'n' 's' 'i' 't' 'i' 'v' 'e' Action52))> */
		func() bool {
			position122, tokenIndex122 := position, tokenIndex
			{
				position123 := position
				{
					position124, tokenIndex124 := position, tokenIndex
					if buffer[position] != rune('d') {
						goto l125
					}
					position++
					if buffer[position] != rune('e') {
						goto l125
					}
					position++
					if buffer[position] != rune('f') {
						goto l125
					}
					position++
					if buffer[position] != rune('a') {
						goto l125
					}
					position++
					if buffer[position] != rune('u') {
						goto l125
					}
					position++
					if buffer[position] != rune('l') {
						goto l125
					}
					position++
					if buffer[position] != rune('t') {
						goto l125
					}
					position++
					if !_rules[ruleAction50]() {
						goto l125
					}
					goto l124
				l125:
					position, tokenIndex = position124, tokenIndex124
					if buffer[position] != rune('c') {
						goto l126
					}
					position++
					if buffer[position] != rune('a') {
						goto l126
					}
					position++
					if buffer[position] != rune('s') {
						goto l126
					}
					position++
					if buffer[position] != rune('e') {
						goto l126
					}
					position++
					if buffer[position] != rune('_') {
						goto l126
					}
					position++
					if buffer[position] != rune('i') {
						goto l126
					}
					position++
					if buffer[position] != rune('n') {
						goto l126
					}
					position++
					if buffer[position] != rune('s') {
						goto l126
					}
					position++
					if buffer[position] != rune('e') {
						goto l126
					}
					position++
					if buffer[position] != rune('n') {
						goto l126
					}
					position++
					if buffer[position] != rune('s') {
						goto l126
					}
					position++
					if buffer[position] != rune('i') {
						goto l126
					}
					position++
					if buffer[position] != rune('t') {
						goto l126
					}
					position++
					if buffer[position] != rune('i') {
						goto l126
					}
					position++
					if buffer[position] != rune('v') {
						goto l126
					}
					position++
					if buffer[position] != rune('e') {
						goto l126
					}
					position++
					if !_rules[ruleAction51]() {
						goto l126
					}
					goto l124
				l126:
					position, tokenIndex = position124, tokenIndex124
					if buffer[position] != rune('c') {
						goto l122
					}
					position++
					if buffer[position] != rune('a') {
						goto l122
					}
					position++
					if buffer[position] != rune('s') {
						goto l122
					}
					position++
					if buffer[position] != rune('e') {
						goto l122
					}
					position++
					if buffer[position] != rune('_') {
						goto l122
					}
					position++
					if buffer[position] != rune('s') {
						goto l122
					}
					position++
					if buffer[position] != rune('e') {
						goto l122
					}
					position++
					if buffer[position] != rune('n') {
						goto l122
					}
					position++
					if buffer[position] != rune('s') {
						goto l122
					}
					position++
					if buffer[position] != rune('i') {
						goto l122
					}
					position++
					if buffer[position] != rune('t') {
						goto l122
					}
					position++
					if buffer[position] != rune('i') {
						goto l122
					}
					position++
					if buffer[position] != rune('v') {
						goto l122
					}
					position++
					if buffer[position] != rune('e') {
						goto l122
					}
					position++
					if !_rules[ruleAction52]() {
						goto l122
					}
				}
			l124:
				add(ruleSearchOperatorCaseSensitivity, position123)
			}
			return true
		l122:
			position, tokenIndex = position122, tokenIndex122
			return false
		},
		/* 30 SearchOperatorPredicate <- <((Literal Action53) / (Identifier Action54 ((':' String Action55) / ('=' '=' String Action56) / (MustSpace ('m' 'a' 't' 'c' 'h' 'e' 's' ' ' 'r' 'e' 'g' 'e' 'x') MustSpace String Action57))))> */
		func() bool {
			position127, tokenIndex127 := position, tokenIndex
			{
				position128 := position
				{
					position129, tokenIndex129 := position, tokenIndex
					if !_rules[ruleLiteral]() {
						goto l130
					}
					if !_rules[ruleAction53]() {
						goto l130
					}
					goto l129
				l130:
					position, tokenIndex = position129, tokenIndex129
					if !_rules[ruleIdentifier]() {
						goto l127
					}
					if !_rules[ruleAction54]() {
						goto l127
					}
					{
						position131, tokenIndex131 := position, tokenIndex
						if buffer[position] != rune(':') {
							goto l132
						}
						position++
						if !_rules[ruleString]() {
							goto l132
						}
						if !_rules[ruleAction55]() {
							goto l132
						}
						goto l131
					l132:
						position, tokenIndex = position131, tokenIndex131
						if buffer[position] != rune('=') {
							goto l133
						}
						position++
						if buffer[position] != rune('=') {
							goto l133
						}
						position++
						if !_rules[ruleString]() {
							goto l133
						}
						if !_rules[ruleAction56]() {
							goto l133
						}
						goto l131
					l133:
						position, tokenIndex = position131, tokenIndex131
						if !_rules[ruleMustSpace]() {
							goto l127
						}
						if buffer[position] != rune('m') {
							goto l127
						}
						position++
						if buffer[position] != rune('a') {
							goto l127
						}
						position++
						if buffer[position] != rune('t') {
							goto l127
						}
						position++
						if buffer[position] != rune('c') {
							goto l127
						}
						position++
						if buffer[position] != rune('h') {
							goto l127
						}
						position++
						if buffer[position] != rune('e') {
							goto l127
						}
						position++
						if buffer[position] != rune('s') {
							goto l127
						}
						position++
						if buffer[position] != rune(' ') {
							goto l127
						}
						position++
						if buffer[position] != rune('r') {
							goto l127
						}
						position++
						if buffer[position] != rune('e') {
							goto l127
						}
						position++
						if buffer[position] != rune('g') {
							goto l127
						}
						position++
						if buffer[position] != rune('e') {
							goto l127
						}
						position++
						if buffer[position] != rune('x') {
							goto l127
						}
						position++
						if !_rules[ruleMustSpace]() {
							goto l127
						}
						if !_rules[ruleString]() {
							goto l127
						}
						if !_rules[ruleAction57]() {
							goto l127
						}
					}
				l131:
				}
			l129:
				add(ruleSearchOperatorPredicate, position128)
			}
			return true
		l127:
			position, tokenIndex = position127, tokenIndex127
			return false
		},
		/* 31 SortOperator <- <(MustSpace Action58 ('b' 'y') MustSpace SortOperatorArg (Space ',' Space SortOperatorArg)* Space)> */
		func() bool {
			position134, tokenIndex134 := position, tokenIndex
			{
				position135 := position
				if !_rules[ruleMustSpace]() {
					goto l134
				}
				if !_rules[ruleAction58]() {
					goto l134
				}
				if buffer[position] != rune('b') {
					goto l134
				}
				position++
				if buffer[position] != rune('y') {
					goto l134
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l134
				}
				if !_rules[ruleSortOperatorArg]() {
					goto l134
				}
			l136:
				{
					position137, tokenIndex137 := position, tokenIndex
					if !_rules[ruleSpace]() {
						goto l137
					}
					if buffer[position] != rune(',') {
						goto l137
					}
					position++
					if !_rules[ruleSpace]() {
						goto l137
					}
					if !_rules[ruleSortOperatorArg]() {
						goto l137
					}
					goto l136
				l137:
					position, tokenIndex = position137, tokenIndex137
				}
				if !_rules[ruleSpace]() {
					goto l134
				}
				add(ruleSortOperator, position135)
			}
			return true
		l134:
			position, tokenIndex = position134, tokenIndex134
			return false
		},
		/* 32 SortOperatorArg <- <(Identifier Action59 (MustSpace (('a' 's' 'c' Action60) / ('d' 'e' 's' 'c' Action61)))?)> */
		func() bool {
			position138, tokenIndex138 := position, tokenIndex
			{
				position139 := position
				if !_rules[ruleIdentifier]() {
					goto l138
				}
				if !_rules[ruleAction59]() {
					goto l138
				}
				{
					position140, tokenIndex140 := position, tokenIndex
					if !_rules[ruleMustSpace]() {
						goto l140
					}
					{
						position142, tokenIndex142 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l143
						}
						position++
						if buffer[position] != rune('s') {
							goto l143
						}
						position++
						if buffer[position] != rune('c') {
							goto l143
						}
						position++
						if !_rules[ruleAction60]() {
							goto l143
						}
						goto l142
					l143:
						position, tokenIndex = position142, tokenIndex142
						if buffer[position] != rune('d') {
							goto l140
						}
						position++
						if buffer[position] != rune('e') {
							goto l140
						}
						position++
						if buffer[position] != rune('s') {
							goto l140
						}
						position++
						if buffer[position] != rune('c') {
							goto l140
						}
						position++
						if !_rules[ruleAction61]() {
							goto l140
						}
					}
				l142:
					goto l141
				l140:
					position, tokenIndex = position140, tokenIndex140
				}
			l141:
				add(ruleSortOperatorArg, position139)
			}
			return true
		l138:
			position, tokenIndex = position138, tokenIndex138
			return false
		},
		/* 33 TakeOperator <- <(MustSpace Action62 I64 Action63)> */
		func() bool {
			position144, tokenIndex144 := position, tokenIndex
			{
				position145 := position
				if !_rules[ruleMustSpace]() {
					goto l144
				}
				if !_rules[ruleAction62]() {
					goto l144
				}
				if !_rules[ruleI64]() {
					goto l144
				}
				if !_rules[ruleAction63]() {
					goto l144
				}
				add(ruleTakeOperator, position145)
			}
			return true
		l144:
			position, tokenIndex = position144, tokenIndex144
			return false
		},
		/* 34 TopOperator <- <(MustSpace Action64 I64 MustSpace Action65 ('b' 'y') MustSpace Expr Action66 (MustSpace (('a' 's' 'c' Action67) / ('d' 'e' 's' 'c' Action68)))?)> */
		func() bool {
			position146, tokenIndex146 := position, tokenIndex
			{
				position147 := position
				if !_rules[ruleMustSpace]() {
					goto l146
				}
				if !_rules[ruleAction64]() {
					goto l146
				}
				if !_rules[ruleI64]() {
					goto l146
				}
				if !_rules[ruleMustSpace]() {
					goto l146
				}
				if !_rules[ruleAction65]() {
					goto l146
				}
				if buffer[position] != rune('b') {
					goto l146
				}
				position++
				if buffer[position] != rune('y') {
					goto l146
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l146
				}
				if !_rules[ruleExpr]() {
					goto l146
				}
				if !_rules[ruleAction66]() {
					goto l146
				}
				{
					position148, tokenIndex148 := position, tokenIndex
					if !_rules[ruleMustSpace]() {
						goto l148
					}
					{
						position150, tokenIndex150 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l151
						}
						position++
						if buffer[position] != rune('s') {
							goto l151
						}
						position++
						if buffer[position] != rune('c') {
							goto l151
						}
						position++
						if !_rules[ruleAction67]() {
							goto l151
						}
						goto l150
					l151:
						position, tokenIndex = position150, tokenIndex150
						if buffer[position] != rune('d') {
							goto l148
						}
						position++
						if buffer[position] != rune('e') {
							goto l148
						}
						position++
						if buffer[position] != rune('s') {
							goto l148
						}
						position++
						if buffer[position] != rune('c') {
							goto l148
						}
						position++
						if !_rules[ruleAction68]() {
							goto l148
						}
					}
				l150:
					goto l149
				l148:
					position, tokenIndex = position148, tokenIndex148
				}
			l149:
				add(ruleTopOperator, position147)
			}
			return true
		l146:
			position, tokenIndex = position146, tokenIndex146
			return false
		},
		/* 35 RenderSplitOperator <- <('s' 'p' 'l' 'i' 't' Action69 MustSpace RenderSplitByOperator)> */
		func() bool {
			position152, tokenIndex152 := position, tokenIndex
			{
				position153 := position
				if buffer[position] != rune('s') {
					goto l152
				}
				position++
				if buffer[position] != rune('p') {
					goto l152
				}
				position++
				if buffer[position] != rune('l') {
					goto l152
				}
				position++
				if buffer[position] != rune('i') {
					goto l152
				}
				position++
				if buffer[position] != rune('t') {
					goto l152
				}
				position++
				if !_rules[ruleAction69]() {
					goto l152
				}
				if !_rules[ruleMustSpace]() {
					goto l152
				}
				if !_rules[ruleRenderSplitByOperator]() {
					goto l152
				}
				add(ruleRenderSplitOperator, position153)
			}
			return true
		l152:
			position, tokenIndex = position152, tokenIndex152
			return false
		},
		/* 36 RenderSplitByOperator <- <('b' 'y' MustSpace RenderSplitByOperatorArg (Space ',' Space RenderSplitByOperatorArg)* Space)> */
		func() bool {
			position154, tokenIndex154 := position, tokenIndex
			{
				position155 := position
				if buffer[position] != rune('b') {
					goto l154
				}
				position++
				if buffer[position] != rune('y') {
					goto l154
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l154
				}
				if !_rules[ruleRenderSplitByOperatorArg]() {
					goto l154
				}
			l156:
				{
					position157, tokenIndex157 := position, tokenIndex
					if !_rules[ruleSpace]() {
						goto l157
					}
					if buffer[position] != rune(',') {
						goto l157
					}
					position++
					if !_rules[ruleSpace]() {
						goto l157
					}
					if !_rules[ruleRenderSplitByOperatorArg]() {
						goto l157
					}
					goto l156
				l157:
					position, tokenIndex = position157, tokenIndex157
				}
				if !_rules[ruleSpace]() {
					goto l154
				}
				add(ruleRenderSplitByOperator, position155)
			}
			return true
		l154:
			position, tokenIndex = position154, tokenIndex154
			return false
		},
		/* 37 RenderSplitByOperatorArg <- <(Expr Action70)> */
		func() bool {
			position158, tokenIndex158 := position, tokenIndex
			{
				position159 := position
				if !_rules[ruleExpr]() {
					goto l158
				}
				if !_rules[ruleAction70]() {
					goto l158
				}
				add(ruleRenderSplitByOperatorArg, position159)
			}
			return true
		l158:
			position, tokenIndex = position158, tokenIndex158
			return false
		},
		/* 38 Expr <- <(Expr1 ((Space NUM_ADD Expr1 Space Action71) / (Space NUM_SUB Expr1 Space Action72))*)> */
		func() bool {
			position160, tokenIndex160 := position, tokenIndex
			{
				position161 := position
				if !_rules[ruleExpr1]() {
					goto l160
				}
			l162:
				{
					position163, tokenIndex163 := position, tokenIndex
					{
						position164, tokenIndex164 := position, tokenIndex
						if !_rules[ruleSpace]() {
							goto l165
						}
						if !_rules[ruleNUM_ADD]() {
							goto l165
						}
						if !_rules[ruleExpr1]() {
							goto l165
						}
						if !_rules[ruleSpace]() {
							goto l165
						}
						if !_rules[ruleAction71]() {
							goto l165
						}
						goto l164
					l165:
						position, tokenIndex = position164, tokenIndex164
						if !_rules[ruleSpace]() {
							goto l163
						}
						if !_rules[ruleNUM_SUB]() {
							goto l163
						}
						if !_rules[ruleExpr1]() {
							goto l163
						}
						if !_rules[ruleSpace]() {
							goto l163
						}
						if !_rules[ruleAction72]() {
							goto l163
						}
					}
				l164:
					goto l162
				l163:
					position, tokenIndex = position163, tokenIndex163
				}
				add(ruleExpr, position161)
			}
			return true
		l160:
			position, tokenIndex = position160, tokenIndex160
			return false
		},
		/* 39 Expr1 <- <(Expr2 ((Space NUM_MUL Expr2 Space Action73) / (Space NUM_DIV Expr2 Space Action74) / (Space NUM_MOD Expr2 Space Action75))*)> */
		func() bool {
			position166, tokenIndex166 := position, tokenIndex
			{
				position167 := position
				if !_rules[ruleExpr2]() {
					goto l166
				}
			l168:
				{
					position169, tokenIndex169 := position, tokenIndex
					{
						position170, tokenIndex170 := position, tokenIndex
						if !_rules[ruleSpace]() {
							goto l171
						}
						if !_rules[ruleNUM_MUL]() {
							goto l171
						}
						if !_rules[ruleExpr2]() {
							goto l171
						}
						if !_rules[ruleSpace]() {
							goto l171
						}
						if !_rules[ruleAction73]() {
							goto l171
						}
						goto l170
					l171:
						position, tokenIndex = position170, tokenIndex170
						if !_rules[ruleSpace]() {
							goto l172
						}
						if !_rules[ruleNUM_DIV]() {
							goto l172
						}
						if !_rules[ruleExpr2]() {
							goto l172
						}
						if !_rules[ruleSpace]() {
							goto l172
						}
						if !_rules[ruleAction74]() {
							goto l172
						}
						goto l170
					l172:
						position, tokenIndex = position170, tokenIndex170
						if !_rules[ruleSpace]() {
							goto l169
						}
						if !_rules[ruleNUM_MOD]() {
							goto l169
						}
						if !_rules[ruleExpr2]() {
							goto l169
						}
						if !_rules[ruleSpace]() {
							goto l169
						}
						if !_rules[ruleAction75]() {
							goto l169
						}
					}
				l170:
					goto l168
				l169:
					position, tokenIndex = position169, tokenIndex169
				}
				add(ruleExpr1, position167)
			}
			return true
		l166:
			position, tokenIndex = position166, tokenIndex166
			return false
		},
		/* 40 Expr2 <- <(Expr3 ((Space LOG_AND Expr3 Space Action76) / (Space LOG_OR Expr3 Space Action77))*)> */
		func() bool {
			position173, tokenIndex173 := position, tokenIndex
			{
				position174 := position
				if !_rules[ruleExpr3]() {
					goto l173
				}
			l175:
				{
					position176, tokenIndex176 := position, tokenIndex
					{
						position177, tokenIndex177 := position, tokenIndex
						if !_rules[ruleSpace]() {
							goto l178
						}
						if !_rules[ruleLOG_AND]() {
							goto l178
						}
						if !_rules[ruleExpr3]() {
							goto l178
						}
						if !_rules[ruleSpace]() {
							goto l178
						}
						if !_rules[ruleAction76]() {
							goto l178
						}
						goto l177
					l178:
						position, tokenIndex = position177, tokenIndex177
						if !_rules[ruleSpace]() {
							goto l176
						}
						if !_rules[ruleLOG_OR]() {
							goto l176
						}
						if !_rules[ruleExpr3]() {
							goto l176
						}
						if !_rules[ruleSpace]() {
							goto l176
						}
						if !_rules[ruleAction77]() {
							goto l176
						}
					}
				l177:
					goto l175
				l176:
					position, tokenIndex = position176, tokenIndex176
				}
				add(ruleExpr2, position174)
			}
			return true
		l173:
			position, tokenIndex = position173, tokenIndex173
			return false
		},
		/* 41 Expr3 <- <(Expr4 ((Space CMP_EQ Expr4 Action78) / (Space CMP_NOTEQ Expr4 Action79) / (Space CMP_GT Expr4 Action80) / (Space CMP_GTE Expr4 Action81) / (Space CMP_LT Expr4 Action82) / (Space CMP_LTE Expr4 Action83) / (Space SET_IN Expr4 Action84) / (Space SET_NOTIN Expr4 Action85) / (Space STR_EQ_NOCS Expr4 Action86) / (Space STR_NOTEQ_NOCS Expr4 Action87) / (Space STR_CONTAINS Expr4 Action88) / (Space STR_NOT_CONTAINS Expr4 Action89) / (Space STR_CONTAINS_CS Expr4 Action90) / (Space STR_NOT_CONTAINS_CS Expr4 Action91) / (Space STR_STARTSWITH Expr4 Action92) / (Space STR_NOT_STARTSWITH Expr4 Action93) / (Space STR_STARTSWITH_CS Expr4 Action94) / (Space STR_NOT_STARTSWITH_CS Expr4 Action95) / (Space STR_ENDSWITH Expr4 Action96) / (Space STR_NOT_ENDSWITH Expr4 Action97) / (Space STR_ENDSWITH_CS Expr4 Action98) / (Space STR_NOT_ENDSWITH_CS Expr4 Action99) / (Space STR_IN_NOCS Expr4 Action100) / (Space STR_NOT_IN_NOCS Expr4 Action101) / (Space STR_NOT_MATCHES_REGEX Expr4 Action102) / (Space STR_MATCHES_REGEX Expr4 Action103) / (Space STR_HAS Expr4 Action104) / (Space STR_HAS_CS Expr4 Action105))*)> */
		func() bool {
			position179, tokenIndex179 := position, tokenIndex
			{
				position180 := position
				if !_rules[ruleExpr4]() {
					goto l179
				}
			l181:
				{
					position182, tokenIndex182 := position, tokenIndex
					{
						position183, tokenIndex183 := position, tokenIndex
						if !_rules[ruleSpace]() {
							goto l184
						}
						if !_rules[ruleCMP_EQ]() {
							goto l184
						}
						if !_rules[ruleExpr4]() {
							goto l184
						}
						if !_rules[ruleAction78]() {
							goto l184
						}
						goto l183
					l184:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l185
						}
						if !_rules[ruleCMP_NOTEQ]() {
							goto l185
						}
						if !_rules[ruleExpr4]() {
							goto l185
						}
						if !_rules[ruleAction79]() {
							goto l185
						}
						goto l183
					l185:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l186
						}
						if !_rules[ruleCMP_GT]() {
							goto l186
						}
						if !_rules[ruleExpr4]() {
							goto l186
						}
						if !_rules[ruleAction80]() {
							goto l186
						}
						goto l183
					l186:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l187
						}
						if !_rules[ruleCMP_GTE]() {
							goto l187
						}
						if !_rules[ruleExpr4]() {
							goto l187
						}
						if !_rules[ruleAction81]() {
							goto l187
						}
						goto l183
					l187:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l188
						}
						if !_rules[ruleCMP_LT]() {
							goto l188
						}
						if !_rules[ruleExpr4]() {
							goto l188
						}
						if !_rules[ruleAction82]() {
							goto l188
						}
						goto l183
					l188:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l189
						}
						if !_rules[ruleCMP_LTE]() {
							goto l189
						}
						if !_rules[ruleExpr4]() {
							goto l189
						}
						if !_rules[ruleAction83]() {
							goto l189
						}
						goto l183
					l189:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l190
						}
						if !_rules[ruleSET_IN]() {
							goto l190
						}
						if !_rules[ruleExpr4]() {
							goto l190
						}
						if !_rules[ruleAction84]() {
							goto l190
						}
						goto l183
					l190:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l191
						}
						if !_rules[ruleSET_NOTIN]() {
							goto l191
						}
						if !_rules[ruleExpr4]() {
							goto l191
						}
						if !_rules[ruleAction85]() {
							goto l191
						}
						goto l183
					l191:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l192
						}
						if !_rules[ruleSTR_EQ_NOCS]() {
							goto l192
						}
						if !_rules[ruleExpr4]() {
							goto l192
						}
						if !_rules[ruleAction86]() {
							goto l192
						}
						goto l183
					l192:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l193
						}
						if !_rules[ruleSTR_NOTEQ_NOCS]() {
							goto l193
						}
						if !_rules[ruleExpr4]() {
							goto l193
						}
						if !_rules[ruleAction87]() {
							goto l193
						}
						goto l183
					l193:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l194
						}
						if !_rules[ruleSTR_CONTAINS]() {
							goto l194
						}
						if !_rules[ruleExpr4]() {
							goto l194
						}
						if !_rules[ruleAction88]() {
							goto l194
						}
						goto l183
					l194:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l195
						}
						if !_rules[ruleSTR_NOT_CONTAINS]() {
							goto l195
						}
						if !_rules[ruleExpr4]() {
							goto l195
						}
						if !_rules[ruleAction89]() {
							goto l195
						}
						goto l183
					l195:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l196
						}
						if !_rules[ruleSTR_CONTAINS_CS]() {
							goto l196
						}
						if !_rules[ruleExpr4]() {
							goto l196
						}
						if !_rules[ruleAction90]() {
							goto l196
						}
						goto l183
					l196:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l197
						}
						if !_rules[ruleSTR_NOT_CONTAINS_CS]() {
							goto l197
						}
						if !_rules[ruleExpr4]() {
							goto l197
						}
						if !_rules[ruleAction91]() {
							goto l197
						}
						goto l183
					l197:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l198
						}
						if !_rules[ruleSTR_STARTSWITH]() {
							goto l198
						}
						if !_rules[ruleExpr4]() {
							goto l198
						}
						if !_rules[ruleAction92]() {
							goto l198
						}
						goto l183
					l198:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l199
						}
						if !_rules[ruleSTR_NOT_STARTSWITH]() {
							goto l199
						}
						if !_rules[ruleExpr4]() {
							goto l199
						}
						if !_rules[ruleAction93]() {
							goto l199
						}
						goto l183
					l199:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l200
						}
						if !_rules[ruleSTR_STARTSWITH_CS]() {
							goto l200
						}
						if !_rules[ruleExpr4]() {
							goto l200
						}
						if !_rules[ruleAction94]() {
							goto l200
						}
						goto l183
					l200:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l201
						}
						if !_rules[ruleSTR_NOT_STARTSWITH_CS]() {
							goto l201
						}
						if !_rules[ruleExpr4]() {
							goto l201
						}
						if !_rules[ruleAction95]() {
							goto l201
						}
						goto l183
					l201:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l202
						}
						if !_rules[ruleSTR_ENDSWITH]() {
							goto l202
						}
						if !_rules[ruleExpr4]() {
							goto l202
						}
						if !_rules[ruleAction96]() {
							goto l202
						}
						goto l183
					l202:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l203
						}
						if !_rules[ruleSTR_NOT_ENDSWITH]() {
							goto l203
						}
						if !_rules[ruleExpr4]() {
							goto l203
						}
						if !_rules[ruleAction97]() {
							goto l203
						}
						goto l183
					l203:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l204
						}
						if !_rules[ruleSTR_ENDSWITH_CS]() {
							goto l204
						}
						if !_rules[ruleExpr4]() {
							goto l204
						}
						if !_rules[ruleAction98]() {
							goto l204
						}
						goto l183
					l204:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l205
						}
						if !_rules[ruleSTR_NOT_ENDSWITH_CS]() {
							goto l205
						}
						if !_rules[ruleExpr4]() {
							goto l205
						}
						if !_rules[ruleAction99]() {
							goto l205
						}
						goto l183
					l205:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l206
						}
						if !_rules[ruleSTR_IN_NOCS]() {
							goto l206
						}
						if !_rules[ruleExpr4]() {
							goto l206
						}
						if !_rules[ruleAction100]() {
							goto l206
						}
						goto l183
					l206:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l207
						}
						if !_rules[ruleSTR_NOT_IN_NOCS]() {
							goto l207
						}
						if !_rules[ruleExpr4]() {
							goto l207
						}
						if !_rules[ruleAction101]() {
							goto l207
						}
						goto l183
					l207:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l208
						}
						if !_rules[ruleSTR_NOT_MATCHES_REGEX]() {
							goto l208
						}
						if !_rules[ruleExpr4]() {
							goto l208
						}
						if !_rules[ruleAction102]() {
							goto l208
						}
						goto l183
					l208:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l209
						}
						if !_rules[ruleSTR_MATCHES_REGEX]() {
							goto l209
						}
						if !_rules[ruleExpr4]() {
							goto l209
						}
						if !_rules[ruleAction103]() {
							goto l209
						}
						goto l183
					l209:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l210
						}
						if !_rules[ruleSTR_HAS]() {
							goto l210
						}
						if !_rules[ruleExpr4]() {
							goto l210
						}
						if !_rules[ruleAction104]() {
							goto l210
						}
						goto l183
					l210:
						position, tokenIndex = position183, tokenIndex183
						if !_rules[ruleSpace]() {
							goto l182
						}
						if !_rules[ruleSTR_HAS_CS]() {
							goto l182
						}
						if !_rules[ruleExpr4]() {
							goto l182
						}
						if !_rules[ruleAction105]() {
							goto l182
						}
					}
				l183:
					goto l181
				l182:
					position, tokenIndex = position182, tokenIndex182
				}
				add(ruleExpr3, position180)
			}
			return true
		l179:
			position, tokenIndex = position179, tokenIndex179
			return false
		},
		/* 42 Expr4 <- <(Expr5 (Space L_BRACKET Expr5 R_BRACKET Action106)*)> */
		func() bool {
			position211, tokenIndex211 := position, tokenIndex
			{
				position212 := position
				if !_rules[ruleExpr5]() {
					goto l211
				}
			l213:
				{
					position214, tokenIndex214 := position, tokenIndex
					if !_rules[ruleSpace]() {
						goto l214
					}
					if !_rules[ruleL_BRACKET]() {
						goto l214
					}
					if !_rules[ruleExpr5]() {
						goto l214
					}
					if !_rules[ruleR_BRACKET]() {
						goto l214
					}
					if !_rules[ruleAction106]() {
						goto l214
					}
					goto l213
				l214:
					position, tokenIndex = position214, tokenIndex214
				}
				add(ruleExpr4, position212)
			}
			return true
		l211:
			position, tokenIndex = position211, tokenIndex211
			return false
		},
		/* 43 Expr5 <- <((L_PARENS Expr R_PARENS Space) / (NOT Literal Space Action107) / (NOT L_PARENS Expr R_PARENS Space Action108) / (NEG Literal Space Action109) / (NEG L_PARENS Expr R_PARENS Space Action110) / (Literal Space Action111) / (FuncCall Space Action112) / Identifier)> */
		func() bool {
			position215, tokenIndex215 := position, tokenIndex
			{
				position216 := position
				{
					position217, tokenIndex217 := position, tokenIndex
					if !_rules[ruleL_PARENS]() {
						goto l218
					}
					if !_rules[ruleExpr]() {
						goto l218
					}
					if !_rules[ruleR_PARENS]() {
						goto l218
					}
					if !_rules[ruleSpace]() {
						goto l218
					}
					goto l217
				l218:
					position, tokenIndex = position217, tokenIndex217
					if !_rules[ruleNOT]() {
						goto l219
					}
					if !_rules[ruleLiteral]() {
						goto l219
					}
					if !_rules[ruleSpace]() {
						goto l219
					}
					if !_rules[ruleAction107]() {
						goto l219
					}
					goto l217
				l219:
					position, tokenIndex = position217, tokenIndex217
					if !_rules[ruleNOT]() {
						goto l220
					}
					if !_rules[ruleL_PARENS]() {
						goto l220
					}
					if !_rules[ruleExpr]() {
						goto l220
					}
					if !_rules[ruleR_PARENS]() {
						goto l220
					}
					if !_rules[ruleSpace]() {
						goto l220
					}
					if !_rules[ruleAction108]() {
						goto l220
					}
					goto l217
				l220:
					position, tokenIndex = position217, tokenIndex217
					if !_rules[ruleNEG]() {
						goto l221
					}
					if !_rules[ruleLiteral]() {
						goto l221
					}
					if !_rules[ruleSpace]() {
						goto l221
					}
					if !_rules[ruleAction109]() {
						goto l221
					}
					goto l217
				l221:
					position, tokenIndex = position217, tokenIndex217
					if !_rules[ruleNEG]() {
						goto l222
					}
					if !_rules[ruleL_PARENS]() {
						goto l222
					}
					if !_rules[ruleExpr]() {
						goto l222
					}
					if !_rules[ruleR_PARENS]() {
						goto l222
					}
					if !_rules[ruleSpace]() {
						goto l222
					}
					if !_rules[ruleAction110]() {
						goto l222
					}
					goto l217
				l222:
					position, tokenIndex = position217, tokenIndex217
					if !_rules[ruleLiteral]() {
						goto l223
					}
					if !_rules[ruleSpace]() {
						goto l223
					}
					if !_rules[ruleAction111]() {
						goto l223
					}
					goto l217
				l223:
					position, tokenIndex = position217, tokenIndex217
					if !_rules[ruleFuncCall]() {
						goto l224
					}
					if !_rules[ruleSpace]() {
						goto l224
					}
					if !_rules[ruleAction112]() {
						goto l224
					}
					goto l217
				l224:
					position, tokenIndex = position217, tokenIndex217
					if !_rules[ruleIdentifier]() {
						goto l215
					}
				}
			l217:
				add(ruleExpr5, position216)
			}
			return true
		l215:
			position, tokenIndex = position215, tokenIndex215
			return false
		},
		/* 44 Literal <- <((String Action113) / (('d' 'u' 'r' ':')? Duration Action114) / (('t' 's' ':')? Timestamp Action115) / (F64 Action116) / (I64 Action117) / (Bool Action118) / ('d' 'y' 'n' 'a' 'm' 'i' 'c' '(' Array ')' Action119) / ('d' 'y' 'n' 'a' 'm' 'i' 'c' '(' Object ')' Action120))> */
		func() bool {
			position225, tokenIndex225 := position, tokenIndex
			{
				position226 := position
				{
					position227, tokenIndex227 := position, tokenIndex
					if !_rules[ruleString]() {
						goto l228
					}
					if !_rules[ruleAction113]() {
						goto l228
					}
					goto l227
				l228:
					position, tokenIndex = position227, tokenIndex227
					{
						position230, tokenIndex230 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l230
						}
						position++
						if buffer[position] != rune('u') {
							goto l230
						}
						position++
						if buffer[position] != rune('r') {
							goto l230
						}
						position++
						if buffer[position] != rune(':') {
							goto l230
						}
						position++
						goto l231
					l230:
						position, tokenIndex = position230, tokenIndex230
					}
				l231:
					if !_rules[ruleDuration]() {
						goto l229
					}
					if !_rules[ruleAction114]() {
						goto l229
					}
					goto l227
				l229:
					position, tokenIndex = position227, tokenIndex227
					{
						position233, tokenIndex233 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l233
						}
						position++
						if buffer[position] != rune('s') {
							goto l233
						}
						position++
						if buffer[position] != rune(':') {
							goto l233
						}
						position++
						goto l234
					l233:
						position, tokenIndex = position233, tokenIndex233
					}
				l234:
					if !_rules[ruleTimestamp]() {
						goto l232
					}
					if !_rules[ruleAction115]() {
						goto l232
					}
					goto l227
				l232:
					position, tokenIndex = position227, tokenIndex227
					if !_rules[ruleF64]() {
						goto l235
					}
					if !_rules[ruleAction116]() {
						goto l235
					}
					goto l227
				l235:
					position, tokenIndex = position227, tokenIndex227
					if !_rules[ruleI64]() {
						goto l236
					}
					if !_rules[ruleAction117]() {
						goto l236
					}
					goto l227
				l236:
					position, tokenIndex = position227, tokenIndex227
					if !_rules[ruleBool]() {
						goto l237
					}
					if !_rules[ruleAction118]() {
						goto l237
					}
					goto l227
				l237:
					position, tokenIndex = position227, tokenIndex227
					if buffer[position] != rune('d') {
						goto l238
					}
					position++
					if buffer[position] != rune('y') {
						goto l238
					}
					position++
					if buffer[position] != rune('n') {
						goto l238
					}
					position++
					if buffer[position] != rune('a') {
						goto l238
					}
					position++
					if buffer[position] != rune('m') {
						goto l238
					}
					position++
					if buffer[position] != rune('i') {
						goto l238
					}
					position++
					if buffer[position] != rune('c') {
						goto l238
					}
					position++
					if buffer[position] != rune('(') {
						goto l238
					}
					position++
					if !_rules[ruleArray]() {
						goto l238
					}
					if buffer[position] != rune(')') {
						goto l238
					}
					position++
					if !_rules[ruleAction119]() {
						goto l238
					}
					goto l227
				l238:
					position, tokenIndex = position227, tokenIndex227
					if buffer[position] != rune('d') {
						goto l225
					}
					position++
					if buffer[position] != rune('y') {
						goto l225
					}
					position++
					if buffer[position] != rune('n') {
						goto l225
					}
					position++
					if buffer[position] != rune('a') {
						goto l225
					}
					position++
					if buffer[position] != rune('m') {
						goto l225
					}
					position++
					if buffer[position] != rune('i') {
						goto l225
					}
					position++
					if buffer[position] != rune('c') {
						goto l225
					}
					position++
					if buffer[position] != rune('(') {
						goto l225
					}
					position++
					if !_rules[ruleObject]() {
						goto l225
					}
					if buffer[position] != rune(')') {
						goto l225
					}
					position++
					if !_rules[ruleAction120]() {
						goto l225
					}
				}
			l227:
				add(ruleLiteral, position226)
			}
			return true
		l225:
			position, tokenIndex = position225, tokenIndex225
			return false
		},
		/* 45 FuncCall <- <(Action121 FuncName '(' FuncArgs? ')' Space)> */
		func() bool {
			position239, tokenIndex239 := position, tokenIndex
			{
				position240 := position
				if !_rules[ruleAction121]() {
					goto l239
				}
				if !_rules[ruleFuncName]() {
					goto l239
				}
				if buffer[position] != rune('(') {
					goto l239
				}
				position++
				{
					position241, tokenIndex241 := position, tokenIndex
					if !_rules[ruleFuncArgs]() {
						goto l241
					}
					goto l242
				l241:
					position, tokenIndex = position241, tokenIndex241
				}
			l242:
				if buffer[position] != rune(')') {
					goto l239
				}
				position++
				if !_rules[ruleSpace]() {
					goto l239
				}
				add(ruleFuncCall, position240)
			}
			return true
		l239:
			position, tokenIndex = position239, tokenIndex239
			return false
		},
		/* 46 FuncName <- <(!ReservedKeyword <(([a-z] / [A-Z] / '_') ([a-z] / [A-Z] / '_' / [0-9])*)> Action122)> */
		func() bool {
			position243, tokenIndex243 := position, tokenIndex
			{
				position244 := position
				{
					position245, tokenIndex245 := position, tokenIndex
					if !_rules[ruleReservedKeyword]() {
						goto l245
					}
					goto l243
				l245:
					position, tokenIndex = position245, tokenIndex245
				}
				{
					position246 := position
					{
						position247, tokenIndex247 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l248
						}
						position++
						goto l247
					l248:
						position, tokenIndex = position247, tokenIndex247
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l249
						}
						position++
						goto l247
					l249:
						position, tokenIndex = position247, tokenIndex247
						if buffer[position] != rune('_') {
							goto l243
						}
						position++
					}
				l247:
				l250:
					{
						position251, tokenIndex251 := position, tokenIndex
						{
							position252, tokenIndex252 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l253
							}
							position++
							goto l252
						l253:
							position, tokenIndex = position252, tokenIndex252
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l254
							}
							position++
							goto l252
						l254:
							position, tokenIndex = position252, tokenIndex252
							if buffer[position] != rune('_') {
								goto l255
							}
							position++
							goto l252
						l255:
							position, tokenIndex = position252, tokenIndex252
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l251
							}
							position++
						}
					l252:
						goto l250
					l251:
						position, tokenIndex = position251, tokenIndex251
					}
					add(rulePegText, position246)
				}
				if !_rules[ruleAction122]() {
					goto l243
				}
				add(ruleFuncName, position244)
			}
			return true
		l243:
			position, tokenIndex = position243, tokenIndex243
			return false
		},
		/* 47 FuncArgs <- <(FuncArg (Space ',' Space FuncArg)* Space)> */
		func() bool {
			position256, tokenIndex256 := position, tokenIndex
			{
				position257 := position
				if !_rules[ruleFuncArg]() {
					goto l256
				}
			l258:
				{
					position259, tokenIndex259 := position, tokenIndex
					if !_rules[ruleSpace]() {
						goto l259
					}
					if buffer[position] != rune(',') {
						goto l259
					}
					position++
					if !_rules[ruleSpace]() {
						goto l259
					}
					if !_rules[ruleFuncArg]() {
						goto l259
					}
					goto l258
				l259:
					position, tokenIndex = position259, tokenIndex259
				}
				if !_rules[ruleSpace]() {
					goto l256
				}
				add(ruleFuncArgs, position257)
			}
			return true
		l256:
			position, tokenIndex = position256, tokenIndex256
			return false
		},
		/* 48 FuncArg <- <(Expr Action123)> */
		func() bool {
			position260, tokenIndex260 := position, tokenIndex
			{
				position261 := position
				if !_rules[ruleExpr]() {
					goto l260
				}
				if !_rules[ruleAction123]() {
					goto l260
				}
				add(ruleFuncArg, position261)
			}
			return true
		l260:
			position, tokenIndex = position260, tokenIndex260
			return false
		},
		/* 49 Identifier <- <((<(([a-z] / [A-Z] / '_') ([a-z] / [A-Z] / [0-9] / '_')*)> Action124) / ('[' '\'' <([a-z] / [A-Z] / [0-9] / '_' / '-' / '.' / ' ')*> ('\'' ']') Action125) / ('[' '"' <([a-z] / [A-Z] / [0-9] / '_' / '-' / '.' / ' ')*> ('"' ']') Action126))> */
		func() bool {
			position262, tokenIndex262 := position, tokenIndex
			{
				position263 := position
				{
					position264, tokenIndex264 := position, tokenIndex
					{
						position266 := position
						{
							position267, tokenIndex267 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l268
							}
							position++
							goto l267
						l268:
							position, tokenIndex = position267, tokenIndex267
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l269
							}
							position++
							goto l267
						l269:
							position, tokenIndex = position267, tokenIndex267
							if buffer[position] != rune('_') {
								goto l265
							}
							position++
						}
					l267:
					l270:
						{
							position271, tokenIndex271 := position, tokenIndex
							{
								position272, tokenIndex272 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('z') {
									goto l273
								}
								position++
								goto l272
							l273:
								position, tokenIndex = position272, tokenIndex272
								if c := buffer[position]; c < rune('A') || c > rune('Z') {
									goto l274
								}
								position++
								goto l272
							l274:
								position, tokenIndex = position272, tokenIndex272
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l275
								}
								position++
								goto l272
							l275:
								position, tokenIndex = position272, tokenIndex272
								if buffer[position] != rune('_') {
									goto l271
								}
								position++
							}
						l272:
							goto l270
						l271:
							position, tokenIndex = position271, tokenIndex271
						}
						add(rulePegText, position266)
					}
					if !_rules[ruleAction124]() {
						goto l265
					}
					goto l264
				l265:
					position, tokenIndex = position264, tokenIndex264
					if buffer[position] != rune('[') {
						goto l276
					}
					position++
					if buffer[position] != rune('\'') {
						goto l276
					}
					position++
					{
						position277 := position
					l278:
						{
							position279, tokenIndex279 := position, tokenIndex
							{
								position280, tokenIndex280 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('z') {
									goto l281
								}
								position++
								goto l280
							l281:
								position, tokenIndex = position280, tokenIndex280
								if c := buffer[position]; c < rune('A') || c > rune('Z') {
									goto l282
								}
								position++
								goto l280
							l282:
								position, tokenIndex = position280, tokenIndex280
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l283
								}
								position++
								goto l280
							l283:
								position, tokenIndex = position280, tokenIndex280
								if buffer[position] != rune('_') {
									goto l284
								}
								position++
								goto l280
							l284:
								position, tokenIndex = position280, tokenIndex280
								if buffer[position] != rune('-') {
									goto l285
								}
								position++
								goto l280
							l285:
								position, tokenIndex = position280, tokenIndex280
								if buffer[position] != rune('.') {
									goto l286
								}
								position++
								goto l280
							l286:
								position, tokenIndex = position280, tokenIndex280
								if buffer[position] != rune(' ') {
									goto l279
								}
								position++
							}
						l280:
							goto l278
						l279:
							position, tokenIndex = position279, tokenIndex279
						}
						add(rulePegText, position277)
					}
					if buffer[position] != rune('\'') {
						goto l276
					}
					position++
					if buffer[position] != rune(']') {
						goto l276
					}
					position++
					if !_rules[ruleAction125]() {
						goto l276
					}
					goto l264
				l276:
					position, tokenIndex = position264, tokenIndex264
					if buffer[position] != rune('[') {
						goto l262
					}
					position++
					if buffer[position] != rune('"') {
						goto l262
					}
					position++
					{
						position287 := position
					l288:
						{
							position289, tokenIndex289 := position, tokenIndex
							{
								position290, tokenIndex290 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('z') {
									goto l291
								}
								position++
								goto l290
							l291:
								position, tokenIndex = position290, tokenIndex290
								if c := buffer[position]; c < rune('A') || c > rune('Z') {
									goto l292
								}
								position++
								goto l290
							l292:
								position, tokenIndex = position290, tokenIndex290
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l293
								}
								position++
								goto l290
							l293:
								position, tokenIndex = position290, tokenIndex290
								if buffer[position] != rune('_') {
									goto l294
								}
								position++
								goto l290
							l294:
								position, tokenIndex = position290, tokenIndex290
								if buffer[position] != rune('-') {
									goto l295
								}
								position++
								goto l290
							l295:
								position, tokenIndex = position290, tokenIndex290
								if buffer[position] != rune('.') {
									goto l296
								}
								position++
								goto l290
							l296:
								position, tokenIndex = position290, tokenIndex290
								if buffer[position] != rune(' ') {
									goto l289
								}
								position++
							}
						l290:
							goto l288
						l289:
							position, tokenIndex = position289, tokenIndex289
						}
						add(rulePegText, position287)
					}
					if buffer[position] != rune('"') {
						goto l262
					}
					position++
					if buffer[position] != rune(']') {
						goto l262
					}
					position++
					if !_rules[ruleAction126]() {
						goto l262
					}
				}
			l264:
				add(ruleIdentifier, position263)
			}
			return true
		l262:
			position, tokenIndex = position262, tokenIndex262
			return false
		},
		/* 50 String <- <(<('"' DoubleQuoteStringChar* '"')> Action127)> */
		func() bool {
			position297, tokenIndex297 := position, tokenIndex
			{
				position298 := position
				{
					position299 := position
					if buffer[position] != rune('"') {
						goto l297
					}
					position++
				l300:
					{
						position301, tokenIndex301 := position, tokenIndex
						if !_rules[ruleDoubleQuoteStringChar]() {
							goto l301
						}
						goto l300
					l301:
						position, tokenIndex = position301, tokenIndex301
					}
					if buffer[position] != rune('"') {
						goto l297
					}
					position++
					add(rulePegText, position299)
				}
				if !_rules[ruleAction127]() {
					goto l297
				}
				add(ruleString, position298)
			}
			return true
		l297:
			position, tokenIndex = position297, tokenIndex297
			return false
		},
		/* 51 F64 <- <((<(Digits '.' Digits? Exponent?)> Action128) / (<('.' Digits Exponent?)> Action129) / (<(Digits Exponent)> Action130))> */
		func() bool {
			position302, tokenIndex302 := position, tokenIndex
			{
				position303 := position
				{
					position304, tokenIndex304 := position, tokenIndex
					{
						position306 := position
						if !_rules[ruleDigits]() {
							goto l305
						}
						if buffer[position] != rune('.') {
							goto l305
						}
						position++
						{
							position307, tokenIndex307 := position, tokenIndex
							if !_rules[ruleDigits]() {
								goto l307
							}
							goto l308
						l307:
							position, tokenIndex = position307, tokenIndex307
						}
					l308:
						{
							position309, tokenIndex309 := position, tokenIndex
							if !_rules[ruleExponent]() {
								goto l309
							}
							goto l310
						l309:
							position, tokenIndex = position309, tokenIndex309
						}
					l310:
						add(rulePegText, position306)
					}
					if !_rules[ruleAction128]() {
						goto l305
					}
					goto l304
				l305:
					position, tokenIndex = position304, tokenIndex304
					{
						position312 := position
						if buffer[position] != rune('.') {
							goto l311
						}
						position++
						if !_rules[ruleDigits]() {
							goto l311
						}
						{
							position313, tokenIndex313 := position, tokenIndex
							if !_rules[ruleExponent]() {
								goto l313
							}
							goto l314
						l313:
							position, tokenIndex = position313, tokenIndex313
						}
					l314:
						add(rulePegText, position312)
					}
					if !_rules[ruleAction129]() {
						goto l311
					}
					goto l304
				l311:
					position, tokenIndex = position304, tokenIndex304
					{
						position315 := position
						if !_rules[ruleDigits]() {
							goto l302
						}
						if !_rules[ruleExponent]() {
							goto l302
						}
						add(rulePegText, position315)
					}
					if !_rules[ruleAction130]() {
						goto l302
					}
				}
			l304:
				add(ruleF64, position303)
			}
			return true
		l302:
			position, tokenIndex = position302, tokenIndex302
			return false
		},
		/* 52 I64 <- <(('0' Action131) / (<([1-9] ('_'* [0-9])*)> Action132))> */
		func() bool {
			position316, tokenIndex316 := position, tokenIndex
			{
				position317 := position
				{
					position318, tokenIndex318 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l319
					}
					position++
					if !_rules[ruleAction131]() {
						goto l319
					}
					goto l318
				l319:
					position, tokenIndex = position318, tokenIndex318
					{
						position320 := position
						if c := buffer[position]; c < rune('1') || c > rune('9') {
							goto l316
						}
						position++
					l321:
						{
							position322, tokenIndex322 := position, tokenIndex
						l323:
							{
								position324, tokenIndex324 := position, tokenIndex
								if buffer[position] != rune('_') {
									goto l324
								}
								position++
								goto l323
							l324:
								position, tokenIndex = position324, tokenIndex324
							}
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l322
							}
							position++
							goto l321
						l322:
							position, tokenIndex = position322, tokenIndex322
						}
						add(rulePegText, position320)
					}
					if !_rules[ruleAction132]() {
						goto l316
					}
				}
			l318:
				add(ruleI64, position317)
			}
			return true
		l316:
			position, tokenIndex = position316, tokenIndex316
			return false
		},
		/* 53 Bool <- <(('t' 'r' 'u' 'e' Action133) / ('f' 'a' 'l' 's' 'e' Action134))> */
		func() bool {
			position325, tokenIndex325 := position, tokenIndex
			{
				position326 := position
				{
					position327, tokenIndex327 := position, tokenIndex
					if buffer[position] != rune('t') {
						goto l328
					}
					position++
					if buffer[position] != rune('r') {
						goto l328
					}
					position++
					if buffer[position] != rune('u') {
						goto l328
					}
					position++
					if buffer[position] != rune('e') {
						goto l328
					}
					position++
					if !_rules[ruleAction133]() {
						goto l328
					}
					goto l327
				l328:
					position, tokenIndex = position327, tokenIndex327
					if buffer[position] != rune('f') {
						goto l325
					}
					position++
					if buffer[position] != rune('a') {
						goto l325
					}
					position++
					if buffer[position] != rune('l') {
						goto l325
					}
					position++
					if buffer[position] != rune('s') {
						goto l325
					}
					position++
					if buffer[position] != rune('e') {
						goto l325
					}
					position++
					if !_rules[ruleAction134]() {
						goto l325
					}
				}
			l327:
				add(ruleBool, position326)
			}
			return true
		l325:
			position, tokenIndex = position325, tokenIndex325
			return false
		},
		/* 54 ReservedKeyword <- <(('l' 'v' 'l') / ('m' 's' 'g') / ('k' 'v') / Bool)> */
		func() bool {
			position329, tokenIndex329 := position, tokenIndex
			{
				position330 := position
				{
					position331, tokenIndex331 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l332
					}
					position++
					if buffer[position] != rune('v') {
						goto l332
					}
					position++
					if buffer[position] != rune('l') {
						goto l332
					}
					position++
					goto l331
				l332:
					position, tokenIndex = position331, tokenIndex331
					if buffer[position] != rune('m') {
						goto l333
					}
					position++
					if buffer[position] != rune('s') {
						goto l333
					}
					position++
					if buffer[position] != rune('g') {
						goto l333
					}
					position++
					goto l331
				l333:
					position, tokenIndex = position331, tokenIndex331
					if buffer[position] != rune('k') {
						goto l334
					}
					position++
					if buffer[position] != rune('v') {
						goto l334
					}
					position++
					goto l331
				l334:
					position, tokenIndex = position331, tokenIndex331
					if !_rules[ruleBool]() {
						goto l329
					}
				}
			l331:
				add(ruleReservedKeyword, position330)
			}
			return true
		l329:
			position, tokenIndex = position329, tokenIndex329
			return false
		},
		/* 55 Array <- <(L_BRACKET Action135 (ArrayItem (COMMA ArrayItem)*)? R_BRACKET)> */
		func() bool {
			position335, tokenIndex335 := position, tokenIndex
			{
				position336 := position
				if !_rules[ruleL_BRACKET]() {
					goto l335
				}
				if !_rules[ruleAction135]() {
					goto l335
				}
				{
					position337, tokenIndex337 := position, tokenIndex
					if !_rules[ruleArrayItem]() {
						goto l337
					}
				l339:
					{
						position340, tokenIndex340 := position, tokenIndex
						if !_rules[ruleCOMMA]() {
							goto l340
						}
						if !_rules[ruleArrayItem]() {
							goto l340
						}
						goto l339
					l340:
						position, tokenIndex = position340, tokenIndex340
					}
					goto l338
				l337:
					position, tokenIndex = position337, tokenIndex337
				}
			l338:
				if !_rules[ruleR_BRACKET]() {
					goto l335
				}
				add(ruleArray, position336)
			}
			return true
		l335:
			position, tokenIndex = position335, tokenIndex335
			return false
		},
		/* 56 ArrayItem <- <(Literal Action136)> */
		func() bool {
			position341, tokenIndex341 := position, tokenIndex
			{
				position342 := position
				if !_rules[ruleLiteral]() {
					goto l341
				}
				if !_rules[ruleAction136]() {
					goto l341
				}
				add(ruleArrayItem, position342)
			}
			return true
		l341:
			position, tokenIndex = position341, tokenIndex341
			return false
		},
		/* 57 Object <- <(L_SQUIGGLY Action137 (ObjectItem (COMMA ObjectItem)*)? R_SQUIGGLY)> */
		func() bool {
			position343, tokenIndex343 := position, tokenIndex
			{
				position344 := position
				if !_rules[ruleL_SQUIGGLY]() {
					goto l343
				}
				if !_rules[ruleAction137]() {
					goto l343
				}
				{
					position345, tokenIndex345 := position, tokenIndex
					if !_rules[ruleObjectItem]() {
						goto l345
					}
				l347:
					{
						position348, tokenIndex348 := position, tokenIndex
						if !_rules[ruleCOMMA]() {
							goto l348
						}
						if !_rules[ruleObjectItem]() {
							goto l348
						}
						goto l347
					l348:
						position, tokenIndex = position348, tokenIndex348
					}
					goto l346
				l345:
					position, tokenIndex = position345, tokenIndex345
				}
			l346:
				if !_rules[ruleR_SQUIGGLY]() {
					goto l343
				}
				add(ruleObject, position344)
			}
			return true
		l343:
			position, tokenIndex = position343, tokenIndex343
			return false
		},
		/* 58 ObjectItem <- <(ObjectKey COLON Literal Action138)> */
		func() bool {
			position349, tokenIndex349 := position, tokenIndex
			{
				position350 := position
				if !_rules[ruleObjectKey]() {
					goto l349
				}
				if !_rules[ruleCOLON]() {
					goto l349
				}
				if !_rules[ruleLiteral]() {
					goto l349
				}
				if !_rules[ruleAction138]() {
					goto l349
				}
				add(ruleObjectItem, position350)
			}
			return true
		l349:
			position, tokenIndex = position349, tokenIndex349
			return false
		},
		/* 59 ObjectKey <- <(String Action139)> */
		func() bool {
			position351, tokenIndex351 := position, tokenIndex
			{
				position352 := position
				if !_rules[ruleString]() {
					goto l351
				}
				if !_rules[ruleAction139]() {
					goto l351
				}
				add(ruleObjectKey, position352)
			}
			return true
		l351:
			position, tokenIndex = position351, tokenIndex351
			return false
		},
		/* 60 Duration <- <((F64 <(('u' 's') / ('µ' 's') / ('m' 's') / 's' / 'm' / 'h' / 'd' / 'w')> Action140) / (I64 <(('n' 's') / ('u' 's') / ('µ' 's') / ('m' 's') / 's' / 'm' / 'h' / 'd' / 'w')> Action141))> */
		func() bool {
			position353, tokenIndex353 := position, tokenIndex
			{
				position354 := position
				{
					position355, tokenIndex355 := position, tokenIndex
					if !_rules[ruleF64]() {
						goto l356
					}
					{
						position357 := position
						{
							position358, tokenIndex358 := position, tokenIndex
							if buffer[position] != rune('u') {
								goto l359
							}
							position++
							if buffer[position] != rune('s') {
								goto l359
							}
							position++
							goto l358
						l359:
							position, tokenIndex = position358, tokenIndex358
							if buffer[position] != rune('µ') {
								goto l360
							}
							position++
							if buffer[position] != rune('s') {
								goto l360
							}
							position++
							goto l358
						l360:
							position, tokenIndex = position358, tokenIndex358
							if buffer[position] != rune('m') {
								goto l361
							}
							position++
							if buffer[position] != rune('s') {
								goto l361
							}
							position++
							goto l358
						l361:
							position, tokenIndex = position358, tokenIndex358
							if buffer[position] != rune('s') {
								goto l362
							}
							position++
							goto l358
						l362:
							position, tokenIndex = position358, tokenIndex358
							if buffer[position] != rune('m') {
								goto l363
							}
							position++
							goto l358
						l363:
							position, tokenIndex = position358, tokenIndex358
							if buffer[position] != rune('h') {
								goto l364
							}
							position++
							goto l358
						l364:
							position, tokenIndex = position358, tokenIndex358
							if buffer[position] != rune('d') {
								goto l365
							}
							position++
							goto l358
						l365:
							position, tokenIndex = position358, tokenIndex358
							if buffer[position] != rune('w') {
								goto l356
							}
							position++
						}
					l358:
						add(rulePegText, position357)
					}
					if !_rules[ruleAction140]() {
						goto l356
					}
					goto l355
				l356:
					position, tokenIndex = position355, tokenIndex355
					if !_rules[ruleI64]() {
						goto l353
					}
					{
						position366 := position
						{
							position367, tokenIndex367 := position, tokenIndex
							if buffer[position] != rune('n') {
								goto l368
							}
							position++
							if buffer[position] != rune('s') {
								goto l368
							}
							position++
							goto l367
						l368:
							position, tokenIndex = position367, tokenIndex367
							if buffer[position] != rune('u') {
								goto l369
							}
							position++
							if buffer[position] != rune('s') {
								goto l369
							}
							position++
							goto l367
						l369:
							position, tokenIndex = position367, tokenIndex367
							if buffer[position] != rune('µ') {
								goto l370
							}
							position++
							if buffer[position] != rune('s') {
								goto l370
							}
							position++
							goto l367
						l370:
							position, tokenIndex = position367, tokenIndex367
							if buffer[position] != rune('m') {
								goto l371
							}
							position++
							if buffer[position] != rune('s') {
								goto l371
							}
							position++
							goto l367
						l371:
							position, tokenIndex = position367, tokenIndex367
							if buffer[position] != rune('s') {
								goto l372
							}
							position++
							goto l367
						l372:
							position, tokenIndex = position367, tokenIndex367
							if buffer[position] != rune('m') {
								goto l373
							}
							position++
							goto l367
						l373:
							position, tokenIndex = position367, tokenIndex367
							if buffer[position] != rune('h') {
								goto l374
							}
							position++
							goto l367
						l374:
							position, tokenIndex = position367, tokenIndex367
							if buffer[position] != rune('d') {
								goto l375
							}
							position++
							goto l367
						l375:
							position, tokenIndex = position367, tokenIndex367
							if buffer[position] != rune('w') {
								goto l353
							}
							position++
						}
					l367:
						add(rulePegText, position366)
					}
					if !_rules[ruleAction141]() {
						goto l353
					}
				}
			l355:
				add(ruleDuration, position354)
			}
			return true
		l353:
			position, tokenIndex = position353, tokenIndex353
			return false
		},
		/* 61 Timestamp <- <(<RFC3339Nano> Action142)> */
		func() bool {
			position376, tokenIndex376 := position, tokenIndex
			{
				position377 := position
				{
					position378 := position
					if !_rules[ruleRFC3339Nano]() {
						goto l376
					}
					add(rulePegText, position378)
				}
				if !_rules[ruleAction142]() {
					goto l376
				}
				add(ruleTimestamp, position377)
			}
			return true
		l376:
			position, tokenIndex = position376, tokenIndex376
			return false
		},
		/* 62 DoubleQuoteStringChar <- <(('\\' ('\'' / '"' / '?' / '\\' / '%' / 'a' / 'b' / 'f' / 'n' / 'r' / 't' / 'v')) / (!('"' / '\n' / '\\') .))> */
		func() bool {
			position379, tokenIndex379 := position, tokenIndex
			{
				position380 := position
				{
					position381, tokenIndex381 := position, tokenIndex
					if buffer[position] != rune('\\') {
						goto l382
					}
					position++
					{
						position383, tokenIndex383 := position, tokenIndex
						if buffer[position] != rune('\'') {
							goto l384
						}
						position++
						goto l383
					l384:
						position, tokenIndex = position383, tokenIndex383
						if buffer[position] != rune('"') {
							goto l385
						}
						position++
						goto l383
					l385:
						position, tokenIndex = position383, tokenIndex383
						if buffer[position] != rune('?') {
							goto l386
						}
						position++
						goto l383
					l386:
						position, tokenIndex = position383, tokenIndex383
						if buffer[position] != rune('\\') {
							goto l387
						}
						position++
						goto l383
					l387:
						position, tokenIndex = position383, tokenIndex383
						if buffer[position] != rune('%') {
							goto l388
						}
						position++
						goto l383
					l388:
						position, tokenIndex = position383, tokenIndex383
						if buffer[position] != rune('a') {
							goto l389
						}
						position++
						goto l383
					l389:
						position, tokenIndex = position383, tokenIndex383
						if buffer[position] != rune('b') {
							goto l390
						}
						position++
						goto l383
					l390:
						position, tokenIndex = position383, tokenIndex383
						if buffer[position] != rune('f') {
							goto l391
						}
						position++
						goto l383
					l391:
						position, tokenIndex = position383, tokenIndex383
						if buffer[position] != rune('n') {
							goto l392
						}
						position++
						goto l383
					l392:
						position, tokenIndex = position383, tokenIndex383
						if buffer[position] != rune('r') {
							goto l393
						}
						position++
						goto l383
					l393:
						position, tokenIndex = position383, tokenIndex383
						if buffer[position] != rune('t') {
							goto l394
						}
						position++
						goto l383
					l394:
						position, tokenIndex = position383, tokenIndex383
						if buffer[position] != rune('v') {
							goto l382
						}
						position++
					}
				l383:
					goto l381
				l382:
					position, tokenIndex = position381, tokenIndex381
					{
						position395, tokenIndex395 := position, tokenIndex
						{
							position396, tokenIndex396 := position, tokenIndex
							if buffer[position] != rune('"') {
								goto l397
							}
							position++
							goto l396
						l397:
							position, tokenIndex = position396, tokenIndex396
							if buffer[position] != rune('\n') {
								goto l398
							}
							position++
							goto l396
						l398:
							position, tokenIndex = position396, tokenIndex396
							if buffer[position] != rune('\\') {
								goto l395
							}
							position++
						}
					l396:
						goto l379
					l395:
						position, tokenIndex = position395, tokenIndex395
					}
					if !matchDot() {
						goto l379
					}
				}
			l381:
				add(ruleDoubleQuoteStringChar, position380)
			}
			return true
		l379:
			position, tokenIndex = position379, tokenIndex379
			return false
		},
		/* 63 Exponent <- <(('e' / 'E') ('+' / '-')? Digits)> */
		func() bool {
			position399, tokenIndex399 := position, tokenIndex
			{
				position400 := position
				{
					position401, tokenIndex401 := position, tokenIndex
					if buffer[position] != rune('e') {
						goto l402
					}
					position++
					goto l401
				l402:
					position, tokenIndex = position401, tokenIndex401
					if buffer[position] != rune('E') {
						goto l399
					}
					position++
				}
			l401:
				{
					position403, tokenIndex403 := position, tokenIndex
					{
						position405, tokenIndex405 := position, tokenIndex
						if buffer[position] != rune('+') {
							goto l406
						}
						position++
						goto l405
					l406:
						position, tokenIndex = position405, tokenIndex405
						if buffer[position] != rune('-') {
							goto l403
						}
						position++
					}
				l405:
					goto l404
				l403:
					position, tokenIndex = position403, tokenIndex403
				}
			l404:
				if !_rules[ruleDigits]() {
					goto l399
				}
				add(ruleExponent, position400)
			}
			return true
		l399:
			position, tokenIndex = position399, tokenIndex399
			return false
		},
		/* 64 Digits <- <([0-9] ('_'* [0-9])*)> */
		func() bool {
			position407, tokenIndex407 := position, tokenIndex
			{
				position408 := position
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l407
				}
				position++
			l409:
				{
					position410, tokenIndex410 := position, tokenIndex
				l411:
					{
						position412, tokenIndex412 := position, tokenIndex
						if buffer[position] != rune('_') {
							goto l412
						}
						position++
						goto l411
					l412:
						position, tokenIndex = position412, tokenIndex412
					}
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l410
					}
					position++
					goto l409
				l410:
					position, tokenIndex = position410, tokenIndex410
				}
				add(ruleDigits, position408)
			}
			return true
		l407:
			position, tokenIndex = position407, tokenIndex407
			return false
		},
		/* 65 RFC3339Nano <- <(RFC3339NanoDate 'T' RFC3339NanoTime RFC3339NanoTimezone)> */
		func() bool {
			position413, tokenIndex413 := position, tokenIndex
			{
				position414 := position
				if !_rules[ruleRFC3339NanoDate]() {
					goto l413
				}
				if buffer[position] != rune('T') {
					goto l413
				}
				position++
				if !_rules[ruleRFC3339NanoTime]() {
					goto l413
				}
				if !_rules[ruleRFC3339NanoTimezone]() {
					goto l413
				}
				add(ruleRFC3339Nano, position414)
			}
			return true
		l413:
			position, tokenIndex = position413, tokenIndex413
			return false
		},
		/* 66 RFC3339NanoDate <- <(Number '-' Number '-' Number)> */
		func() bool {
			position415, tokenIndex415 := position, tokenIndex
			{
				position416 := position
				if !_rules[ruleNumber]() {
					goto l415
				}
				if buffer[position] != rune('-') {
					goto l415
				}
				position++
				if !_rules[ruleNumber]() {
					goto l415
				}
				if buffer[position] != rune('-') {
					goto l415
				}
				position++
				if !_rules[ruleNumber]() {
					goto l415
				}
				add(ruleRFC3339NanoDate, position416)
			}
			return true
		l415:
			position, tokenIndex = position415, tokenIndex415
			return false
		},
		/* 67 RFC3339NanoTime <- <(Number ':' Number ':' Number ('.' Number)?)> */
		func() bool {
			position417, tokenIndex417 := position, tokenIndex
			{
				position418 := position
				if !_rules[ruleNumber]() {
					goto l417
				}
				if buffer[position] != rune(':') {
					goto l417
				}
				position++
				if !_rules[ruleNumber]() {
					goto l417
				}
				if buffer[position] != rune(':') {
					goto l417
				}
				position++
				if !_rules[ruleNumber]() {
					goto l417
				}
				{
					position419, tokenIndex419 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l419
					}
					position++
					if !_rules[ruleNumber]() {
						goto l419
					}
					goto l420
				l419:
					position, tokenIndex = position419, tokenIndex419
				}
			l420:
				add(ruleRFC3339NanoTime, position418)
			}
			return true
		l417:
			position, tokenIndex = position417, tokenIndex417
			return false
		},
		/* 68 RFC3339NanoTimezone <- <('Z' / ('+' Number ':' Number))> */
		func() bool {
			position421, tokenIndex421 := position, tokenIndex
			{
				position422 := position
				{
					position423, tokenIndex423 := position, tokenIndex
					if buffer[position] != rune('Z') {
						goto l424
					}
					position++
					goto l423
				l424:
					position, tokenIndex = position423, tokenIndex423
					if buffer[position] != rune('+') {
						goto l421
					}
					position++
					if !_rules[ruleNumber]() {
						goto l421
					}
					if buffer[position] != rune(':') {
						goto l421
					}
					position++
					if !_rules[ruleNumber]() {
						goto l421
					}
				}
			l423:
				add(ruleRFC3339NanoTimezone, position422)
			}
			return true
		l421:
			position, tokenIndex = position421, tokenIndex421
			return false
		},
		/* 69 Number <- <<[0-9]+>> */
		func() bool {
			position425, tokenIndex425 := position, tokenIndex
			{
				position426 := position
				{
					position427 := position
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l425
					}
					position++
				l428:
					{
						position429, tokenIndex429 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l429
						}
						position++
						goto l428
					l429:
						position, tokenIndex = position429, tokenIndex429
					}
					add(rulePegText, position427)
				}
				add(ruleNumber, position426)
			}
			return true
		l425:
			position, tokenIndex = position425, tokenIndex425
			return false
		},
		/* 70 NOT <- <('!' Space)> */
		func() bool {
			position430, tokenIndex430 := position, tokenIndex
			{
				position431 := position
				if buffer[position] != rune('!') {
					goto l430
				}
				position++
				if !_rules[ruleSpace]() {
					goto l430
				}
				add(ruleNOT, position431)
			}
			return true
		l430:
			position, tokenIndex = position430, tokenIndex430
			return false
		},
		/* 71 NEG <- <('-' Space)> */
		func() bool {
			position432, tokenIndex432 := position, tokenIndex
			{
				position433 := position
				if buffer[position] != rune('-') {
					goto l432
				}
				position++
				if !_rules[ruleSpace]() {
					goto l432
				}
				add(ruleNEG, position433)
			}
			return true
		l432:
			position, tokenIndex = position432, tokenIndex432
			return false
		},
		/* 72 NUM_ADD <- <('+' Space)> */
		func() bool {
			position434, tokenIndex434 := position, tokenIndex
			{
				position435 := position
				if buffer[position] != rune('+') {
					goto l434
				}
				position++
				if !_rules[ruleSpace]() {
					goto l434
				}
				add(ruleNUM_ADD, position435)
			}
			return true
		l434:
			position, tokenIndex = position434, tokenIndex434
			return false
		},
		/* 73 NUM_SUB <- <('-' Space)> */
		func() bool {
			position436, tokenIndex436 := position, tokenIndex
			{
				position437 := position
				if buffer[position] != rune('-') {
					goto l436
				}
				position++
				if !_rules[ruleSpace]() {
					goto l436
				}
				add(ruleNUM_SUB, position437)
			}
			return true
		l436:
			position, tokenIndex = position436, tokenIndex436
			return false
		},
		/* 74 NUM_DIV <- <('/' Space)> */
		func() bool {
			position438, tokenIndex438 := position, tokenIndex
			{
				position439 := position
				if buffer[position] != rune('/') {
					goto l438
				}
				position++
				if !_rules[ruleSpace]() {
					goto l438
				}
				add(ruleNUM_DIV, position439)
			}
			return true
		l438:
			position, tokenIndex = position438, tokenIndex438
			return false
		},
		/* 75 NUM_MUL <- <('*' Space)> */
		func() bool {
			position440, tokenIndex440 := position, tokenIndex
			{
				position441 := position
				if buffer[position] != rune('*') {
					goto l440
				}
				position++
				if !_rules[ruleSpace]() {
					goto l440
				}
				add(ruleNUM_MUL, position441)
			}
			return true
		l440:
			position, tokenIndex = position440, tokenIndex440
			return false
		},
		/* 76 NUM_MOD <- <('%' Space)> */
		func() bool {
			position442, tokenIndex442 := position, tokenIndex
			{
				position443 := position
				if buffer[position] != rune('%') {
					goto l442
				}
				position++
				if !_rules[ruleSpace]() {
					goto l442
				}
				add(ruleNUM_MOD, position443)
			}
			return true
		l442:
			position, tokenIndex = position442, tokenIndex442
			return false
		},
		/* 77 LOG_AND <- <('a' 'n' 'd' MustSpace)> */
		func() bool {
			position444, tokenIndex444 := position, tokenIndex
			{
				position445 := position
				if buffer[position] != rune('a') {
					goto l444
				}
				position++
				if buffer[position] != rune('n') {
					goto l444
				}
				position++
				if buffer[position] != rune('d') {
					goto l444
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l444
				}
				add(ruleLOG_AND, position445)
			}
			return true
		l444:
			position, tokenIndex = position444, tokenIndex444
			return false
		},
		/* 78 LOG_OR <- <('o' 'r' MustSpace)> */
		func() bool {
			position446, tokenIndex446 := position, tokenIndex
			{
				position447 := position
				if buffer[position] != rune('o') {
					goto l446
				}
				position++
				if buffer[position] != rune('r') {
					goto l446
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l446
				}
				add(ruleLOG_OR, position447)
			}
			return true
		l446:
			position, tokenIndex = position446, tokenIndex446
			return false
		},
		/* 79 CMP_EQ <- <('=' '=' Space)> */
		func() bool {
			position448, tokenIndex448 := position, tokenIndex
			{
				position449 := position
				if buffer[position] != rune('=') {
					goto l448
				}
				position++
				if buffer[position] != rune('=') {
					goto l448
				}
				position++
				if !_rules[ruleSpace]() {
					goto l448
				}
				add(ruleCMP_EQ, position449)
			}
			return true
		l448:
			position, tokenIndex = position448, tokenIndex448
			return false
		},
		/* 80 CMP_NOTEQ <- <('!' '=' Space)> */
		func() bool {
			position450, tokenIndex450 := position, tokenIndex
			{
				position451 := position
				if buffer[position] != rune('!') {
					goto l450
				}
				position++
				if buffer[position] != rune('=') {
					goto l450
				}
				position++
				if !_rules[ruleSpace]() {
					goto l450
				}
				add(ruleCMP_NOTEQ, position451)
			}
			return true
		l450:
			position, tokenIndex = position450, tokenIndex450
			return false
		},
		/* 81 CMP_GT <- <('>' Space)> */
		func() bool {
			position452, tokenIndex452 := position, tokenIndex
			{
				position453 := position
				if buffer[position] != rune('>') {
					goto l452
				}
				position++
				if !_rules[ruleSpace]() {
					goto l452
				}
				add(ruleCMP_GT, position453)
			}
			return true
		l452:
			position, tokenIndex = position452, tokenIndex452
			return false
		},
		/* 82 CMP_GTE <- <('>' '=' Space)> */
		func() bool {
			position454, tokenIndex454 := position, tokenIndex
			{
				position455 := position
				if buffer[position] != rune('>') {
					goto l454
				}
				position++
				if buffer[position] != rune('=') {
					goto l454
				}
				position++
				if !_rules[ruleSpace]() {
					goto l454
				}
				add(ruleCMP_GTE, position455)
			}
			return true
		l454:
			position, tokenIndex = position454, tokenIndex454
			return false
		},
		/* 83 CMP_LT <- <('<' Space)> */
		func() bool {
			position456, tokenIndex456 := position, tokenIndex
			{
				position457 := position
				if buffer[position] != rune('<') {
					goto l456
				}
				position++
				if !_rules[ruleSpace]() {
					goto l456
				}
				add(ruleCMP_LT, position457)
			}
			return true
		l456:
			position, tokenIndex = position456, tokenIndex456
			return false
		},
		/* 84 CMP_LTE <- <('<' '=' Space)> */
		func() bool {
			position458, tokenIndex458 := position, tokenIndex
			{
				position459 := position
				if buffer[position] != rune('<') {
					goto l458
				}
				position++
				if buffer[position] != rune('=') {
					goto l458
				}
				position++
				if !_rules[ruleSpace]() {
					goto l458
				}
				add(ruleCMP_LTE, position459)
			}
			return true
		l458:
			position, tokenIndex = position458, tokenIndex458
			return false
		},
		/* 85 SET_IN <- <('i' 'n' MustSpace)> */
		func() bool {
			position460, tokenIndex460 := position, tokenIndex
			{
				position461 := position
				if buffer[position] != rune('i') {
					goto l460
				}
				position++
				if buffer[position] != rune('n') {
					goto l460
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l460
				}
				add(ruleSET_IN, position461)
			}
			return true
		l460:
			position, tokenIndex = position460, tokenIndex460
			return false
		},
		/* 86 SET_NOTIN <- <('!' 'i' 'n' MustSpace)> */
		func() bool {
			position462, tokenIndex462 := position, tokenIndex
			{
				position463 := position
				if buffer[position] != rune('!') {
					goto l462
				}
				position++
				if buffer[position] != rune('i') {
					goto l462
				}
				position++
				if buffer[position] != rune('n') {
					goto l462
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l462
				}
				add(ruleSET_NOTIN, position463)
			}
			return true
		l462:
			position, tokenIndex = position462, tokenIndex462
			return false
		},
		/* 87 STR_EQ_NOCS <- <('=' '~' Space)> */
		func() bool {
			position464, tokenIndex464 := position, tokenIndex
			{
				position465 := position
				if buffer[position] != rune('=') {
					goto l464
				}
				position++
				if buffer[position] != rune('~') {
					goto l464
				}
				position++
				if !_rules[ruleSpace]() {
					goto l464
				}
				add(ruleSTR_EQ_NOCS, position465)
			}
			return true
		l464:
			position, tokenIndex = position464, tokenIndex464
			return false
		},
		/* 88 STR_NOTEQ_NOCS <- <('!' '~' Space)> */
		func() bool {
			position466, tokenIndex466 := position, tokenIndex
			{
				position467 := position
				if buffer[position] != rune('!') {
					goto l466
				}
				position++
				if buffer[position] != rune('~') {
					goto l466
				}
				position++
				if !_rules[ruleSpace]() {
					goto l466
				}
				add(ruleSTR_NOTEQ_NOCS, position467)
			}
			return true
		l466:
			position, tokenIndex = position466, tokenIndex466
			return false
		},
		/* 89 STR_CONTAINS <- <('c' 'o' 'n' 't' 'a' 'i' 'n' 's' MustSpace)> */
		func() bool {
			position468, tokenIndex468 := position, tokenIndex
			{
				position469 := position
				if buffer[position] != rune('c') {
					goto l468
				}
				position++
				if buffer[position] != rune('o') {
					goto l468
				}
				position++
				if buffer[position] != rune('n') {
					goto l468
				}
				position++
				if buffer[position] != rune('t') {
					goto l468
				}
				position++
				if buffer[position] != rune('a') {
					goto l468
				}
				position++
				if buffer[position] != rune('i') {
					goto l468
				}
				position++
				if buffer[position] != rune('n') {
					goto l468
				}
				position++
				if buffer[position] != rune('s') {
					goto l468
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l468
				}
				add(ruleSTR_CONTAINS, position469)
			}
			return true
		l468:
			position, tokenIndex = position468, tokenIndex468
			return false
		},
		/* 90 STR_NOT_CONTAINS <- <('!' 'c' 'o' 'n' 't' 'a' 'i' 'n' 's' MustSpace)> */
		func() bool {
			position470, tokenIndex470 := position, tokenIndex
			{
				position471 := position
				if buffer[position] != rune('!') {
					goto l470
				}
				position++
				if buffer[position] != rune('c') {
					goto l470
				}
				position++
				if buffer[position] != rune('o') {
					goto l470
				}
				position++
				if buffer[position] != rune('n') {
					goto l470
				}
				position++
				if buffer[position] != rune('t') {
					goto l470
				}
				position++
				if buffer[position] != rune('a') {
					goto l470
				}
				position++
				if buffer[position] != rune('i') {
					goto l470
				}
				position++
				if buffer[position] != rune('n') {
					goto l470
				}
				position++
				if buffer[position] != rune('s') {
					goto l470
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l470
				}
				add(ruleSTR_NOT_CONTAINS, position471)
			}
			return true
		l470:
			position, tokenIndex = position470, tokenIndex470
			return false
		},
		/* 91 STR_CONTAINS_CS <- <('c' 'o' 'n' 't' 'a' 'i' 'n' 's' '_' 'c' 's' MustSpace)> */
		func() bool {
			position472, tokenIndex472 := position, tokenIndex
			{
				position473 := position
				if buffer[position] != rune('c') {
					goto l472
				}
				position++
				if buffer[position] != rune('o') {
					goto l472
				}
				position++
				if buffer[position] != rune('n') {
					goto l472
				}
				position++
				if buffer[position] != rune('t') {
					goto l472
				}
				position++
				if buffer[position] != rune('a') {
					goto l472
				}
				position++
				if buffer[position] != rune('i') {
					goto l472
				}
				position++
				if buffer[position] != rune('n') {
					goto l472
				}
				position++
				if buffer[position] != rune('s') {
					goto l472
				}
				position++
				if buffer[position] != rune('_') {
					goto l472
				}
				position++
				if buffer[position] != rune('c') {
					goto l472
				}
				position++
				if buffer[position] != rune('s') {
					goto l472
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l472
				}
				add(ruleSTR_CONTAINS_CS, position473)
			}
			return true
		l472:
			position, tokenIndex = position472, tokenIndex472
			return false
		},
		/* 92 STR_NOT_CONTAINS_CS <- <('!' 'c' 'o' 'n' 't' 'a' 'i' 'n' 's' '_' 'c' 's' MustSpace)> */
		func() bool {
			position474, tokenIndex474 := position, tokenIndex
			{
				position475 := position
				if buffer[position] != rune('!') {
					goto l474
				}
				position++
				if buffer[position] != rune('c') {
					goto l474
				}
				position++
				if buffer[position] != rune('o') {
					goto l474
				}
				position++
				if buffer[position] != rune('n') {
					goto l474
				}
				position++
				if buffer[position] != rune('t') {
					goto l474
				}
				position++
				if buffer[position] != rune('a') {
					goto l474
				}
				position++
				if buffer[position] != rune('i') {
					goto l474
				}
				position++
				if buffer[position] != rune('n') {
					goto l474
				}
				position++
				if buffer[position] != rune('s') {
					goto l474
				}
				position++
				if buffer[position] != rune('_') {
					goto l474
				}
				position++
				if buffer[position] != rune('c') {
					goto l474
				}
				position++
				if buffer[position] != rune('s') {
					goto l474
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l474
				}
				add(ruleSTR_NOT_CONTAINS_CS, position475)
			}
			return true
		l474:
			position, tokenIndex = position474, tokenIndex474
			return false
		},
		/* 93 STR_STARTSWITH <- <('s' 't' 'a' 'r' 't' 's' 'w' 'i' 't' 'h' MustSpace)> */
		func() bool {
			position476, tokenIndex476 := position, tokenIndex
			{
				position477 := position
				if buffer[position] != rune('s') {
					goto l476
				}
				position++
				if buffer[position] != rune('t') {
					goto l476
				}
				position++
				if buffer[position] != rune('a') {
					goto l476
				}
				position++
				if buffer[position] != rune('r') {
					goto l476
				}
				position++
				if buffer[position] != rune('t') {
					goto l476
				}
				position++
				if buffer[position] != rune('s') {
					goto l476
				}
				position++
				if buffer[position] != rune('w') {
					goto l476
				}
				position++
				if buffer[position] != rune('i') {
					goto l476
				}
				position++
				if buffer[position] != rune('t') {
					goto l476
				}
				position++
				if buffer[position] != rune('h') {
					goto l476
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l476
				}
				add(ruleSTR_STARTSWITH, position477)
			}
			return true
		l476:
			position, tokenIndex = position476, tokenIndex476
			return false
		},
		/* 94 STR_NOT_STARTSWITH <- <('!' 's' 't' 'a' 'r' 't' 's' 'w' 'i' 't' 'h' MustSpace)> */
		func() bool {
			position478, tokenIndex478 := position, tokenIndex
			{
				position479 := position
				if buffer[position] != rune('!') {
					goto l478
				}
				position++
				if buffer[position] != rune('s') {
					goto l478
				}
				position++
				if buffer[position] != rune('t') {
					goto l478
				}
				position++
				if buffer[position] != rune('a') {
					goto l478
				}
				position++
				if buffer[position] != rune('r') {
					goto l478
				}
				position++
				if buffer[position] != rune('t') {
					goto l478
				}
				position++
				if buffer[position] != rune('s') {
					goto l478
				}
				position++
				if buffer[position] != rune('w') {
					goto l478
				}
				position++
				if buffer[position] != rune('i') {
					goto l478
				}
				position++
				if buffer[position] != rune('t') {
					goto l478
				}
				position++
				if buffer[position] != rune('h') {
					goto l478
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l478
				}
				add(ruleSTR_NOT_STARTSWITH, position479)
			}
			return true
		l478:
			position, tokenIndex = position478, tokenIndex478
			return false
		},
		/* 95 STR_STARTSWITH_CS <- <('s' 't' 'a' 'r' 't' 's' 'w' 'i' 't' 'h' '_' 'c' 's' MustSpace)> */
		func() bool {
			position480, tokenIndex480 := position, tokenIndex
			{
				position481 := position
				if buffer[position] != rune('s') {
					goto l480
				}
				position++
				if buffer[position] != rune('t') {
					goto l480
				}
				position++
				if buffer[position] != rune('a') {
					goto l480
				}
				position++
				if buffer[position] != rune('r') {
					goto l480
				}
				position++
				if buffer[position] != rune('t') {
					goto l480
				}
				position++
				if buffer[position] != rune('s') {
					goto l480
				}
				position++
				if buffer[position] != rune('w') {
					goto l480
				}
				position++
				if buffer[position] != rune('i') {
					goto l480
				}
				position++
				if buffer[position] != rune('t') {
					goto l480
				}
				position++
				if buffer[position] != rune('h') {
					goto l480
				}
				position++
				if buffer[position] != rune('_') {
					goto l480
				}
				position++
				if buffer[position] != rune('c') {
					goto l480
				}
				position++
				if buffer[position] != rune('s') {
					goto l480
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l480
				}
				add(ruleSTR_STARTSWITH_CS, position481)
			}
			return true
		l480:
			position, tokenIndex = position480, tokenIndex480
			return false
		},
		/* 96 STR_NOT_STARTSWITH_CS <- <('!' 's' 't' 'a' 'r' 't' 's' 'w' 'i' 't' 'h' '_' 'c' 's' MustSpace)> */
		func() bool {
			position482, tokenIndex482 := position, tokenIndex
			{
				position483 := position
				if buffer[position] != rune('!') {
					goto l482
				}
				position++
				if buffer[position] != rune('s') {
					goto l482
				}
				position++
				if buffer[position] != rune('t') {
					goto l482
				}
				position++
				if buffer[position] != rune('a') {
					goto l482
				}
				position++
				if buffer[position] != rune('r') {
					goto l482
				}
				position++
				if buffer[position] != rune('t') {
					goto l482
				}
				position++
				if buffer[position] != rune('s') {
					goto l482
				}
				position++
				if buffer[position] != rune('w') {
					goto l482
				}
				position++
				if buffer[position] != rune('i') {
					goto l482
				}
				position++
				if buffer[position] != rune('t') {
					goto l482
				}
				position++
				if buffer[position] != rune('h') {
					goto l482
				}
				position++
				if buffer[position] != rune('_') {
					goto l482
				}
				position++
				if buffer[position] != rune('c') {
					goto l482
				}
				position++
				if buffer[position] != rune('s') {
					goto l482
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l482
				}
				add(ruleSTR_NOT_STARTSWITH_CS, position483)
			}
			return true
		l482:
			position, tokenIndex = position482, tokenIndex482
			return false
		},
		/* 97 STR_ENDSWITH <- <('e' 'n' 'd' 's' 'w' 'i' 't' 'h' MustSpace)> */
		func() bool {
			position484, tokenIndex484 := position, tokenIndex
			{
				position485 := position
				if buffer[position] != rune('e') {
					goto l484
				}
				position++
				if buffer[position] != rune('n') {
					goto l484
				}
				position++
				if buffer[position] != rune('d') {
					goto l484
				}
				position++
				if buffer[position] != rune('s') {
					goto l484
				}
				position++
				if buffer[position] != rune('w') {
					goto l484
				}
				position++
				if buffer[position] != rune('i') {
					goto l484
				}
				position++
				if buffer[position] != rune('t') {
					goto l484
				}
				position++
				if buffer[position] != rune('h') {
					goto l484
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l484
				}
				add(ruleSTR_ENDSWITH, position485)
			}
			return true
		l484:
			position, tokenIndex = position484, tokenIndex484
			return false
		},
		/* 98 STR_NOT_ENDSWITH <- <('!' 'e' 'n' 'd' 's' 'w' 'i' 't' 'h' MustSpace)> */
		func() bool {
			position486, tokenIndex486 := position, tokenIndex
			{
				position487 := position
				if buffer[position] != rune('!') {
					goto l486
				}
				position++
				if buffer[position] != rune('e') {
					goto l486
				}
				position++
				if buffer[position] != rune('n') {
					goto l486
				}
				position++
				if buffer[position] != rune('d') {
					goto l486
				}
				position++
				if buffer[position] != rune('s') {
					goto l486
				}
				position++
				if buffer[position] != rune('w') {
					goto l486
				}
				position++
				if buffer[position] != rune('i') {
					goto l486
				}
				position++
				if buffer[position] != rune('t') {
					goto l486
				}
				position++
				if buffer[position] != rune('h') {
					goto l486
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l486
				}
				add(ruleSTR_NOT_ENDSWITH, position487)
			}
			return true
		l486:
			position, tokenIndex = position486, tokenIndex486
			return false
		},
		/* 99 STR_ENDSWITH_CS <- <('e' 'n' 'd' 's' 'w' 'i' 't' 'h' '_' 'c' 's' MustSpace)> */
		func() bool {
			position488, tokenIndex488 := position, tokenIndex
			{
				position489 := position
				if buffer[position] != rune('e') {
					goto l488
				}
				position++
				if buffer[position] != rune('n') {
					goto l488
				}
				position++
				if buffer[position] != rune('d') {
					goto l488
				}
				position++
				if buffer[position] != rune('s') {
					goto l488
				}
				position++
				if buffer[position] != rune('w') {
					goto l488
				}
				position++
				if buffer[position] != rune('i') {
					goto l488
				}
				position++
				if buffer[position] != rune('t') {
					goto l488
				}
				position++
				if buffer[position] != rune('h') {
					goto l488
				}
				position++
				if buffer[position] != rune('_') {
					goto l488
				}
				position++
				if buffer[position] != rune('c') {
					goto l488
				}
				position++
				if buffer[position] != rune('s') {
					goto l488
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l488
				}
				add(ruleSTR_ENDSWITH_CS, position489)
			}
			return true
		l488:
			position, tokenIndex = position488, tokenIndex488
			return false
		},
		/* 100 STR_NOT_ENDSWITH_CS <- <('!' 'e' 'n' 'd' 's' 'w' 'i' 't' 'h' '_' 'c' 's' MustSpace)> */
		func() bool {
			position490, tokenIndex490 := position, tokenIndex
			{
				position491 := position
				if buffer[position] != rune('!') {
					goto l490
				}
				position++
				if buffer[position] != rune('e') {
					goto l490
				}
				position++
				if buffer[position] != rune('n') {
					goto l490
				}
				position++
				if buffer[position] != rune('d') {
					goto l490
				}
				position++
				if buffer[position] != rune('s') {
					goto l490
				}
				position++
				if buffer[position] != rune('w') {
					goto l490
				}
				position++
				if buffer[position] != rune('i') {
					goto l490
				}
				position++
				if buffer[position] != rune('t') {
					goto l490
				}
				position++
				if buffer[position] != rune('h') {
					goto l490
				}
				position++
				if buffer[position] != rune('_') {
					goto l490
				}
				position++
				if buffer[position] != rune('c') {
					goto l490
				}
				position++
				if buffer[position] != rune('s') {
					goto l490
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l490
				}
				add(ruleSTR_NOT_ENDSWITH_CS, position491)
			}
			return true
		l490:
			position, tokenIndex = position490, tokenIndex490
			return false
		},
		/* 101 STR_IN_NOCS <- <('i' 'n' '~' MustSpace)> */
		func() bool {
			position492, tokenIndex492 := position, tokenIndex
			{
				position493 := position
				if buffer[position] != rune('i') {
					goto l492
				}
				position++
				if buffer[position] != rune('n') {
					goto l492
				}
				position++
				if buffer[position] != rune('~') {
					goto l492
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l492
				}
				add(ruleSTR_IN_NOCS, position493)
			}
			return true
		l492:
			position, tokenIndex = position492, tokenIndex492
			return false
		},
		/* 102 STR_NOT_IN_NOCS <- <('!' 'i' 'n' '~' MustSpace)> */
		func() bool {
			position494, tokenIndex494 := position, tokenIndex
			{
				position495 := position
				if buffer[position] != rune('!') {
					goto l494
				}
				position++
				if buffer[position] != rune('i') {
					goto l494
				}
				position++
				if buffer[position] != rune('n') {
					goto l494
				}
				position++
				if buffer[position] != rune('~') {
					goto l494
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l494
				}
				add(ruleSTR_NOT_IN_NOCS, position495)
			}
			return true
		l494:
			position, tokenIndex = position494, tokenIndex494
			return false
		},
		/* 103 STR_NOT_MATCHES_REGEX <- <('!' 'm' 'a' 't' 'c' 'h' 'e' 's' ' ' 'r' 'e' 'g' 'e' 'x' MustSpace)> */
		func() bool {
			position496, tokenIndex496 := position, tokenIndex
			{
				position497 := position
				if buffer[position] != rune('!') {
					goto l496
				}
				position++
				if buffer[position] != rune('m') {
					goto l496
				}
				position++
				if buffer[position] != rune('a') {
					goto l496
				}
				position++
				if buffer[position] != rune('t') {
					goto l496
				}
				position++
				if buffer[position] != rune('c') {
					goto l496
				}
				position++
				if buffer[position] != rune('h') {
					goto l496
				}
				position++
				if buffer[position] != rune('e') {
					goto l496
				}
				position++
				if buffer[position] != rune('s') {
					goto l496
				}
				position++
				if buffer[position] != rune(' ') {
					goto l496
				}
				position++
				if buffer[position] != rune('r') {
					goto l496
				}
				position++
				if buffer[position] != rune('e') {
					goto l496
				}
				position++
				if buffer[position] != rune('g') {
					goto l496
				}
				position++
				if buffer[position] != rune('e') {
					goto l496
				}
				position++
				if buffer[position] != rune('x') {
					goto l496
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l496
				}
				add(ruleSTR_NOT_MATCHES_REGEX, position497)
			}
			return true
		l496:
			position, tokenIndex = position496, tokenIndex496
			return false
		},
		/* 104 STR_MATCHES_REGEX <- <('m' 'a' 't' 'c' 'h' 'e' 's' ' ' 'r' 'e' 'g' 'e' 'x' MustSpace)> */
		func() bool {
			position498, tokenIndex498 := position, tokenIndex
			{
				position499 := position
				if buffer[position] != rune('m') {
					goto l498
				}
				position++
				if buffer[position] != rune('a') {
					goto l498
				}
				position++
				if buffer[position] != rune('t') {
					goto l498
				}
				position++
				if buffer[position] != rune('c') {
					goto l498
				}
				position++
				if buffer[position] != rune('h') {
					goto l498
				}
				position++
				if buffer[position] != rune('e') {
					goto l498
				}
				position++
				if buffer[position] != rune('s') {
					goto l498
				}
				position++
				if buffer[position] != rune(' ') {
					goto l498
				}
				position++
				if buffer[position] != rune('r') {
					goto l498
				}
				position++
				if buffer[position] != rune('e') {
					goto l498
				}
				position++
				if buffer[position] != rune('g') {
					goto l498
				}
				position++
				if buffer[position] != rune('e') {
					goto l498
				}
				position++
				if buffer[position] != rune('x') {
					goto l498
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l498
				}
				add(ruleSTR_MATCHES_REGEX, position499)
			}
			return true
		l498:
			position, tokenIndex = position498, tokenIndex498
			return false
		},
		/* 105 STR_HAS <- <('h' 'a' 's' MustSpace)> */
		func() bool {
			position500, tokenIndex500 := position, tokenIndex
			{
				position501 := position
				if buffer[position] != rune('h') {
					goto l500
				}
				position++
				if buffer[position] != rune('a') {
					goto l500
				}
				position++
				if buffer[position] != rune('s') {
					goto l500
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l500
				}
				add(ruleSTR_HAS, position501)
			}
			return true
		l500:
			position, tokenIndex = position500, tokenIndex500
			return false
		},
		/* 106 STR_HAS_CS <- <('h' 'a' 's' '_' 'c' 's' MustSpace)> */
		func() bool {
			position502, tokenIndex502 := position, tokenIndex
			{
				position503 := position
				if buffer[position] != rune('h') {
					goto l502
				}
				position++
				if buffer[position] != rune('a') {
					goto l502
				}
				position++
				if buffer[position] != rune('s') {
					goto l502
				}
				position++
				if buffer[position] != rune('_') {
					goto l502
				}
				position++
				if buffer[position] != rune('c') {
					goto l502
				}
				position++
				if buffer[position] != rune('s') {
					goto l502
				}
				position++
				if !_rules[ruleMustSpace]() {
					goto l502
				}
				add(ruleSTR_HAS_CS, position503)
			}
			return true
		l502:
			position, tokenIndex = position502, tokenIndex502
			return false
		},
		/* 107 PIPE <- <('|' Space)> */
		func() bool {
			position504, tokenIndex504 := position, tokenIndex
			{
				position505 := position
				if buffer[position] != rune('|') {
					goto l504
				}
				position++
				if !_rules[ruleSpace]() {
					goto l504
				}
				add(rulePIPE, position505)
			}
			return true
		l504:
			position, tokenIndex = position504, tokenIndex504
			return false
		},
		/* 108 L_PARENS <- <('(' Space)> */
		func() bool {
			position506, tokenIndex506 := position, tokenIndex
			{
				position507 := position
				if buffer[position] != rune('(') {
					goto l506
				}
				position++
				if !_rules[ruleSpace]() {
					goto l506
				}
				add(ruleL_PARENS, position507)
			}
			return true
		l506:
			position, tokenIndex = position506, tokenIndex506
			return false
		},
		/* 109 R_PARENS <- <(')' Space)> */
		func() bool {
			position508, tokenIndex508 := position, tokenIndex
			{
				position509 := position
				if buffer[position] != rune(')') {
					goto l508
				}
				position++
				if !_rules[ruleSpace]() {
					goto l508
				}
				add(ruleR_PARENS, position509)
			}
			return true
		l508:
			position, tokenIndex = position508, tokenIndex508
			return false
		},
		/* 110 L_BRACKET <- <('[' Space)> */
		func() bool {
			position510, tokenIndex510 := position, tokenIndex
			{
				position511 := position
				if buffer[position] != rune('[') {
					goto l510
				}
				position++
				if !_rules[ruleSpace]() {
					goto l510
				}
				add(ruleL_BRACKET, position511)
			}
			return true
		l510:
			position, tokenIndex = position510, tokenIndex510
			return false
		},
		/* 111 R_BRACKET <- <(']' Space)> */
		func() bool {
			position512, tokenIndex512 := position, tokenIndex
			{
				position513 := position
				if buffer[position] != rune(']') {
					goto l512
				}
				position++
				if !_rules[ruleSpace]() {
					goto l512
				}
				add(ruleR_BRACKET, position513)
			}
			return true
		l512:
			position, tokenIndex = position512, tokenIndex512
			return false
		},
		/* 112 L_SQUIGGLY <- <('{' Space)> */
		func() bool {
			position514, tokenIndex514 := position, tokenIndex
			{
				position515 := position
				if buffer[position] != rune('{') {
					goto l514
				}
				position++
				if !_rules[ruleSpace]() {
					goto l514
				}
				add(ruleL_SQUIGGLY, position515)
			}
			return true
		l514:
			position, tokenIndex = position514, tokenIndex514
			return false
		},
		/* 113 R_SQUIGGLY <- <'}'> */
		func() bool {
			position516, tokenIndex516 := position, tokenIndex
			{
				position517 := position
				if buffer[position] != rune('}') {
					goto l516
				}
				position++
				add(ruleR_SQUIGGLY, position517)
			}
			return true
		l516:
			position, tokenIndex = position516, tokenIndex516
			return false
		},
		/* 114 COLON <- <(':' Space)> */
		func() bool {
			position518, tokenIndex518 := position, tokenIndex
			{
				position519 := position
				if buffer[position] != rune(':') {
					goto l518
				}
				position++
				if !_rules[ruleSpace]() {
					goto l518
				}
				add(ruleCOLON, position519)
			}
			return true
		l518:
			position, tokenIndex = position518, tokenIndex518
			return false
		},
		/* 115 COMMA <- <(',' Space)> */
		func() bool {
			position520, tokenIndex520 := position, tokenIndex
			{
				position521 := position
				if buffer[position] != rune(',') {
					goto l520
				}
				position++
				if !_rules[ruleSpace]() {
					goto l520
				}
				add(ruleCOMMA, position521)
			}
			return true
		l520:
			position, tokenIndex = position520, tokenIndex520
			return false
		},
		/* 116 Space <- <Whitespace*> */
		func() bool {
			{
				position523 := position
			l524:
				{
					position525, tokenIndex525 := position, tokenIndex
					if !_rules[ruleWhitespace]() {
						goto l525
					}
					goto l524
				l525:
					position, tokenIndex = position525, tokenIndex525
				}
				add(ruleSpace, position523)
			}
			return true
		},
		/* 117 MustSpace <- <Whitespace+> */
		func() bool {
			position526, tokenIndex526 := position, tokenIndex
			{
				position527 := position
				if !_rules[ruleWhitespace]() {
					goto l526
				}
			l528:
				{
					position529, tokenIndex529 := position, tokenIndex
					if !_rules[ruleWhitespace]() {
						goto l529
					}
					goto l528
				l529:
					position, tokenIndex = position529, tokenIndex529
				}
				add(ruleMustSpace, position527)
			}
			return true
		l526:
			position, tokenIndex = position526, tokenIndex526
			return false
		},
		/* 118 Whitespace <- <(' ' / '\t' / EOL)> */
		func() bool {
			position530, tokenIndex530 := position, tokenIndex
			{
				position531 := position
				{
					position532, tokenIndex532 := position, tokenIndex
					if buffer[position] != rune(' ') {
						goto l533
					}
					position++
					goto l532
				l533:
					position, tokenIndex = position532, tokenIndex532
					if buffer[position] != rune('\t') {
						goto l534
					}
					position++
					goto l532
				l534:
					position, tokenIndex = position532, tokenIndex532
					if !_rules[ruleEOL]() {
						goto l530
					}
				}
			l532:
				add(ruleWhitespace, position531)
			}
			return true
		l530:
			position, tokenIndex = position530, tokenIndex530
			return false
		},
		/* 119 EOL <- <(('\r' '\n') / '\n' / '\r')> */
		func() bool {
			position535, tokenIndex535 := position, tokenIndex
			{
				position536 := position
				{
					position537, tokenIndex537 := position, tokenIndex
					if buffer[position] != rune('\r') {
						goto l538
					}
					position++
					if buffer[position] != rune('\n') {
						goto l538
					}
					position++
					goto l537
				l538:
					position, tokenIndex = position537, tokenIndex537
					if buffer[position] != rune('\n') {
						goto l539
					}
					position++
					goto l537
				l539:
					position, tokenIndex = position537, tokenIndex537
					if buffer[position] != rune('\r') {
						goto l535
					}
					position++
				}
			l537:
				add(ruleEOL, position536)
			}
			return true
		l535:
			position, tokenIndex = position535, tokenIndex535
			return false
		},
		/* 120 EOF <- <!.> */
		func() bool {
			position540, tokenIndex540 := position, tokenIndex
			{
				position541 := position
				{
					position542, tokenIndex542 := position, tokenIndex
					if !matchDot() {
						goto l542
					}
					goto l540
				l542:
					position, tokenIndex = position542, tokenIndex542
				}
				add(ruleEOF, position541)
			}
			return true
		l540:
			position, tokenIndex = position540, tokenIndex540
			return false
		},
		/* 122 Action0 <- <{ p.SetQuery(p.Stmts) }> */
		func() bool {
			{
				add(ruleAction0, position)
			}
			return true
		},
		/* 123 Action1 <- <{ p.SetQuery(p.Stmts) }> */
		func() bool {
			{
				add(ruleAction1, position)
			}
			return true
		},
		/* 124 Action2 <- <{ p.SetFrom(p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction2, position)
			}
			return true
		},
		/* 125 Action3 <- <{ p.SetTo(p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction3, position)
			}
			return true
		},
		/* 126 Action4 <- <{ p.SetContextMachine(typesv1.BinaryOp_CMP_EQ, p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction4, position)
			}
			return true
		},
		/* 127 Action5 <- <{ p.SetContextMachine(typesv1.BinaryOp_CMP_NOTEQ, p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction5, position)
			}
			return true
		},
		/* 128 Action6 <- <{ p.SetContextMachine(typesv1.BinaryOp_SET_IN, p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction6, position)
			}
			return true
		},
		/* 129 Action7 <- <{ p.SetContextMachine(typesv1.BinaryOp_SET_NOTIN, p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction7, position)
			}
			return true
		},
		/* 130 Action8 <- <{ p.SetContextSession(typesv1.BinaryOp_CMP_EQ, p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction8, position)
			}
			return true
		},
		/* 131 Action9 <- <{ p.SetContextSession(typesv1.BinaryOp_CMP_NOTEQ, p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction9, position)
			}
			return true
		},
		/* 132 Action10 <- <{ p.SetContextSession(typesv1.BinaryOp_SET_IN, p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction10, position)
			}
			return true
		},
		/* 133 Action11 <- <{ p.SetContextSession(typesv1.BinaryOp_SET_NOTIN, p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction11, position)
			}
			return true
		},
		/* 134 Action12 <- <{ p.addFilterStatement(p.FilterOp) }> */
		func() bool {
			{
				add(ruleAction12, position)
			}
			return true
		},
		/* 135 Action13 <- <{ p.addSummarizeStatement(p.SummarizeOp) }> */
		func() bool {
			{
				add(ruleAction13, position)
			}
			return true
		},
		/* 136 Action14 <- <{ p.addProjectStatement(p.ProjectOp) }> */
		func() bool {
			{
				add(ruleAction14, position)
			}
			return true
		},
		/* 137 Action15 <- <{ p.addProjectAwayStatement(p.ProjectAwayOp) }> */
		func() bool {
			{
				add(ruleAction15, position)
			}
			return true
		},
		/* 138 Action16 <- <{ p.addProjectKeepStatement(p.ProjectKeepOp) }> */
		func() bool {
			{
				add(ruleAction16, position)
			}
			return true
		},
		/* 139 Action17 <- <{ p.addExtendStatement(p.ExtendOp) }> */
		func() bool {
			{
				add(ruleAction17, position)
			}
			return true
		},
		/* 140 Action18 <- <{ p.addCountStatement(p.CountOp) }> */
		func() bool {
			{
				add(ruleAction18, position)
			}
			return true
		},
		/* 141 Action19 <- <{ p.addDistinctStatement(p.DistinctOp) }> */
		func() bool {
			{
				add(ruleAction19, position)
			}
			return true
		},
		/* 142 Action20 <- <{ p.addSampleStatement(p.SampleOp) }> */
		func() bool {
			{
				add(ruleAction20, position)
			}
			return true
		},
		/* 143 Action21 <- <{ p.addSearchStatement(p.SearchOp) }> */
		func() bool {
			{
				add(ruleAction21, position)
			}
			return true
		},
		/* 144 Action22 <- <{ p.addSortStatement(p.SortOp) }> */
		func() bool {
			{
				add(ruleAction22, position)
			}
			return true
		},
		/* 145 Action23 <- <{ p.addTakeStatement(p.TakeOp) }> */
		func() bool {
			{
				add(ruleAction23, position)
			}
			return true
		},
		/* 146 Action24 <- <{ p.addTopStatement(p.TopOp) }> */
		func() bool {
			{
				add(ruleAction24, position)
			}
			return true
		},
		/* 147 Action25 <- <{ p.setRenderSplitByStatement(p.SplitByOp) }> */
		func() bool {
			{
				add(ruleAction25, position)
			}
			return true
		},
		/* 148 Action26 <- <{ p.setFilterOp(p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction26, position)
			}
			return true
		},
		/* 149 Action27 <- <{ p.startSummarizeOp() }> */
		func() bool {
			{
				add(ruleAction27, position)
			}
			return true
		},
		/* 150 Action28 <- <{ p.startSummarizeParameterNamedFunc(text) }> */
		func() bool {
			{
				add(ruleAction28, position)
			}
			return true
		},
		/* 151 Action29 <- <{ p.endSummarizeParameterNamedFunc(p.popFunc()) }> */
		func() bool {
			{
				add(ruleAction29, position)
			}
			return true
		},
		/* 152 Action30 <- <{ p.addSummarizeParameterUnnamedFunc(p.popFunc()) }> */
		func() bool {
			{
				add(ruleAction30, position)
			}
			return true
		},
		/* 153 Action31 <- <{ p.startSummarizeByUnnamedGroupExpression(text) }> */
		func() bool {
			{
				add(ruleAction31, position)
			}
			return true
		},
		/* 154 Action32 <- <{ p.endSummarizeByUnnamedGroupExpression(p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction32, position)
			}
			return true
		},
		/* 155 Action33 <- <{ p.addSummarizeByUnnamedGroupExpression(p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction33, position)
			}
			return true
		},
		/* 156 Action34 <- <{ p.startProjectOp() }> */
		func() bool {
			{
				add(ruleAction34, position)
			}
			return true
		},
		/* 157 Action35 <- <{ p.startProjectOpArg(text) }> */
		func() bool {
			{
				add(ruleAction35, position)
			}
			return true
		},
		/* 158 Action36 <- <{ p.setProjectOpArgValue(p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction36, position)
			}
			return true
		},
		/* 159 Action37 <- <{ p.startProjectAwayOp() }> */
		func() bool {
			{
				add(ruleAction37, position)
			}
			return true
		},
		/* 160 Action38 <- <{ p.addProjectAwayOpArg(text) }> */
		func() bool {
			{
				add(ruleAction38, position)
			}
			return true
		},
		/* 161 Action39 <- <{ p.startProjectKeepOp() }> */
		func() bool {
			{
				add(ruleAction39, position)
			}
			return true
		},
		/* 162 Action40 <- <{ p.addProjectKeepOpArg(text) }> */
		func() bool {
			{
				add(ruleAction40, position)
			}
			return true
		},
		/* 163 Action41 <- <{ p.startExtendOp() }> */
		func() bool {
			{
				add(ruleAction41, position)
			}
			return true
		},
		/* 164 Action42 <- <{ p.setExtendOpArgColumnName(text) }> */
		func() bool {
			{
				add(ruleAction42, position)
			}
			return true
		},
		/* 165 Action43 <- <{ p.setExtendOpArgValue(p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction43, position)
			}
			return true
		},
		/* 166 Action44 <- <{ p.startCountOp() }> */
		func() bool {
			{
				add(ruleAction44, position)
			}
			return true
		},
		/* 167 Action45 <- <{ p.startDistinctOp() }> */
		func() bool {
			{
				add(ruleAction45, position)
			}
			return true
		},
		/* 168 Action46 <- <{ p.addDistinctOpArg(text) }> */
		func() bool {
			{
				add(ruleAction46, position)
			}
			return true
		},
		/* 169 Action47 <- <{ p.startSampleOp() }> */
		func() bool {
			{
				add(ruleAction47, position)
			}
			return true
		},
		/* 170 Action48 <- <{ p.setSampleOpCount(p.I64) }> */
		func() bool {
			{
				add(ruleAction48, position)
			}
			return true
		},
		/* 171 Action49 <- <{ p.startSearchOp() }> */
		func() bool {
			{
				add(ruleAction49, position)
			}
			return true
		},
		/* 172 Action50 <- <{ p.setSearchOpKindDefault() }> */
		func() bool {
			{
				add(ruleAction50, position)
			}
			return true
		},
		/* 173 Action51 <- <{ p.setSearchOpKindCaseInsensitive() }> */
		func() bool {
			{
				add(ruleAction51, position)
			}
			return true
		},
		/* 174 Action52 <- <{ p.setSearchOpKindCaseSensitive() }> */
		func() bool {
			{
				add(ruleAction52, position)
			}
			return true
		},
		/* 175 Action53 <- <{ p.setSearchOpPredicateLiteral(text) }> */
		func() bool {
			{
				add(ruleAction53, position)
			}
			return true
		},
		/* 176 Action54 <- <{ p.identifier = text }> */
		func() bool {
			{
				add(ruleAction54, position)
			}
			return true
		},
		/* 177 Action55 <- <{ p.setSearchOpPredicateFieldSearch(p.identifier, p.String) }> */
		func() bool {
			{
				add(ruleAction55, position)
			}
			return true
		},
		/* 178 Action56 <- <{ p.setSearchOpPredicateExactSearch(p.identifier, p.String) }> */
		func() bool {
			{
				add(ruleAction56, position)
			}
			return true
		},
		/* 179 Action57 <- <{ p.setSearchOpPredicateRegexSearch(p.identifier, p.String) }> */
		func() bool {
			{
				add(ruleAction57, position)
			}
			return true
		},
		/* 180 Action58 <- <{ p.startSortOp() }> */
		func() bool {
			{
				add(ruleAction58, position)
			}
			return true
		},
		/* 181 Action59 <- <{ p.startSortOpArg(text) }> */
		func() bool {
			{
				add(ruleAction59, position)
			}
			return true
		},
		/* 182 Action60 <- <{ p.setSortOpArgOrderAsc() }> */
		func() bool {
			{
				add(ruleAction60, position)
			}
			return true
		},
		/* 183 Action61 <- <{ p.setSortOpArgOrderDesc() }> */
		func() bool {
			{
				add(ruleAction61, position)
			}
			return true
		},
		/* 184 Action62 <- <{ p.startTakeOp() }> */
		func() bool {
			{
				add(ruleAction62, position)
			}
			return true
		},
		/* 185 Action63 <- <{ p.setTakeOpCount(p.I64) }> */
		func() bool {
			{
				add(ruleAction63, position)
			}
			return true
		},
		/* 186 Action64 <- <{ p.startTopOp() }> */
		func() bool {
			{
				add(ruleAction64, position)
			}
			return true
		},
		/* 187 Action65 <- <{ p.setTopOpCount(p.I64) }> */
		func() bool {
			{
				add(ruleAction65, position)
			}
			return true
		},
		/* 188 Action66 <- <{ p.setTopOpByColumnScalar(p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction66, position)
			}
			return true
		},
		/* 189 Action67 <- <{ p.setTopOpByColumnOrderAsc() }> */
		func() bool {
			{
				add(ruleAction67, position)
			}
			return true
		},
		/* 190 Action68 <- <{ p.setTopOpByColumnOrderDesc() }> */
		func() bool {
			{
				add(ruleAction68, position)
			}
			return true
		},
		/* 191 Action69 <- <{p.startRenderSplitOp()}> */
		func() bool {
			{
				add(ruleAction69, position)
			}
			return true
		},
		/* 192 Action70 <- <{ p.addRenderSplitByOp(p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction70, position)
			}
			return true
		},
		/* 193 Action71 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_NUM_ADD, rhs)) }> */
		func() bool {
			{
				add(ruleAction71, position)
			}
			return true
		},
		/* 194 Action72 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_NUM_SUB, rhs)) }> */
		func() bool {
			{
				add(ruleAction72, position)
			}
			return true
		},
		/* 195 Action73 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_NUM_MUL, rhs)) }> */
		func() bool {
			{
				add(ruleAction73, position)
			}
			return true
		},
		/* 196 Action74 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_NUM_DIV, rhs)) }> */
		func() bool {
			{
				add(ruleAction74, position)
			}
			return true
		},
		/* 197 Action75 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_NUM_MOD, rhs)) }> */
		func() bool {
			{
				add(ruleAction75, position)
			}
			return true
		},
		/* 198 Action76 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_LOG_AND, rhs)) }> */
		func() bool {
			{
				add(ruleAction76, position)
			}
			return true
		},
		/* 199 Action77 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_LOG_OR, rhs)) }> */
		func() bool {
			{
				add(ruleAction77, position)
			}
			return true
		},
		/* 200 Action78 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_CMP_EQ, rhs)) }> */
		func() bool {
			{
				add(ruleAction78, position)
			}
			return true
		},
		/* 201 Action79 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_CMP_NOTEQ, rhs)) }> */
		func() bool {
			{
				add(ruleAction79, position)
			}
			return true
		},
		/* 202 Action80 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_CMP_GT, rhs)) }> */
		func() bool {
			{
				add(ruleAction80, position)
			}
			return true
		},
		/* 203 Action81 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_CMP_GTE, rhs)) }> */
		func() bool {
			{
				add(ruleAction81, position)
			}
			return true
		},
		/* 204 Action82 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_CMP_LT, rhs)) }> */
		func() bool {
			{
				add(ruleAction82, position)
			}
			return true
		},
		/* 205 Action83 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_CMP_LTE, rhs)) }> */
		func() bool {
			{
				add(ruleAction83, position)
			}
			return true
		},
		/* 206 Action84 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_SET_IN, rhs)) }> */
		func() bool {
			{
				add(ruleAction84, position)
			}
			return true
		},
		/* 207 Action85 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_SET_NOTIN, rhs)) }> */
		func() bool {
			{
				add(ruleAction85, position)
			}
			return true
		},
		/* 208 Action86 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_EQ_NOCS, rhs)) }> */
		func() bool {
			{
				add(ruleAction86, position)
			}
			return true
		},
		/* 209 Action87 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOTEQ_NOCS, rhs)) }> */
		func() bool {
			{
				add(ruleAction87, position)
			}
			return true
		},
		/* 210 Action88 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_CONTAINS, rhs)) }> */
		func() bool {
			{
				add(ruleAction88, position)
			}
			return true
		},
		/* 211 Action89 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_CONTAINS, rhs)) }> */
		func() bool {
			{
				add(ruleAction89, position)
			}
			return true
		},
		/* 212 Action90 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_CONTAINS_CS, rhs)) }> */
		func() bool {
			{
				add(ruleAction90, position)
			}
			return true
		},
		/* 213 Action91 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_CONTAINS_CS, rhs)) }> */
		func() bool {
			{
				add(ruleAction91, position)
			}
			return true
		},
		/* 214 Action92 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_STARTSWITH, rhs)) }> */
		func() bool {
			{
				add(ruleAction92, position)
			}
			return true
		},
		/* 215 Action93 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_STARTSWITH, rhs)) }> */
		func() bool {
			{
				add(ruleAction93, position)
			}
			return true
		},
		/* 216 Action94 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_STARTSWITH_CS, rhs)) }> */
		func() bool {
			{
				add(ruleAction94, position)
			}
			return true
		},
		/* 217 Action95 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_STARTSWITH_CS, rhs)) }> */
		func() bool {
			{
				add(ruleAction95, position)
			}
			return true
		},
		/* 218 Action96 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_ENDSWITH, rhs)) }> */
		func() bool {
			{
				add(ruleAction96, position)
			}
			return true
		},
		/* 219 Action97 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_ENDSWITH, rhs)) }> */
		func() bool {
			{
				add(ruleAction97, position)
			}
			return true
		},
		/* 220 Action98 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_ENDSWITH_CS, rhs)) }> */
		func() bool {
			{
				add(ruleAction98, position)
			}
			return true
		},
		/* 221 Action99 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_ENDSWITH_CS, rhs)) }> */
		func() bool {
			{
				add(ruleAction99, position)
			}
			return true
		},
		/* 222 Action100 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_IN_NOCS, rhs)) }> */
		func() bool {
			{
				add(ruleAction100, position)
			}
			return true
		},
		/* 223 Action101 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_IN_NOCS, rhs)) }> */
		func() bool {
			{
				add(ruleAction101, position)
			}
			return true
		},
		/* 224 Action102 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_NOT_MATCHES_REGEX, rhs)) }> */
		func() bool {
			{
				add(ruleAction102, position)
			}
			return true
		},
		/* 225 Action103 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_MATCHES_REGEX, rhs)) }> */
		func() bool {
			{
				add(ruleAction103, position)
			}
			return true
		},
		/* 226 Action104 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_HAS, rhs)) }> */
		func() bool {
			{
				add(ruleAction104, position)
			}
			return true
		},
		/* 227 Action105 <- <{ rhs, lhs := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprBinary(lhs, typesv1.BinaryOp_STR_HAS_CS, rhs)) }> */
		func() bool {
			{
				add(ruleAction105, position)
			}
			return true
		},
		/* 228 Action106 <- <{ index, x := p.popExpr(), p.popExpr(); p.pushExpr(typesv1.ExprIndexor(x, index)) }> */
		func() bool {
			{
				add(ruleAction106, position)
			}
			return true
		},
		/* 229 Action107 <- <{ p.pushExpr(typesv1.ExprUnary(typesv1.UnaryOp_NOT, typesv1.ExprLiteral(p.Literal))); p.Literal = nil }> */
		func() bool {
			{
				add(ruleAction107, position)
			}
			return true
		},
		/* 230 Action108 <- <{ arg := p.popExpr(); p.pushExpr(typesv1.ExprUnary(typesv1.UnaryOp_NOT, arg)) }> */
		func() bool {
			{
				add(ruleAction108, position)
			}
			return true
		},
		/* 231 Action109 <- <{ p.pushExpr(typesv1.ExprUnary(typesv1.UnaryOp_NEG, typesv1.ExprLiteral(p.Literal))); p.Literal = nil }> */
		func() bool {
			{
				add(ruleAction109, position)
			}
			return true
		},
		/* 232 Action110 <- <{ arg := p.popExpr(); p.pushExpr(typesv1.ExprUnary(typesv1.UnaryOp_NEG, arg)) }> */
		func() bool {
			{
				add(ruleAction110, position)
			}
			return true
		},
		/* 233 Action111 <- <{ p.pushExpr(typesv1.ExprLiteral(p.Literal)); p.Literal = nil }> */
		func() bool {
			{
				add(ruleAction111, position)
			}
			return true
		},
		/* 234 Action112 <- <{ fn := p.popFunc(); p.pushExpr(typesv1.ExprFuncCall(fn.Name, fn.Args...)) }> */
		func() bool {
			{
				add(ruleAction112, position)
			}
			return true
		},
		/* 235 Action113 <- <{ p.Literal = typesv1.ValStr(p.String) }> */
		func() bool {
			{
				add(ruleAction113, position)
			}
			return true
		},
		/* 236 Action114 <- <{ p.Literal = typesv1.ValDuration(p.Duration) }> */
		func() bool {
			{
				add(ruleAction114, position)
			}
			return true
		},
		/* 237 Action115 <- <{ p.Literal = typesv1.ValTime(p.Timestamp) }> */
		func() bool {
			{
				add(ruleAction115, position)
			}
			return true
		},
		/* 238 Action116 <- <{ p.Literal = typesv1.ValF64(p.F64) }> */
		func() bool {
			{
				add(ruleAction116, position)
			}
			return true
		},
		/* 239 Action117 <- <{ p.Literal = typesv1.ValI64(p.I64) }> */
		func() bool {
			{
				add(ruleAction117, position)
			}
			return true
		},
		/* 240 Action118 <- <{ p.Literal = typesv1.ValBool(p.Bool) }> */
		func() bool {
			{
				add(ruleAction118, position)
			}
			return true
		},
		/* 241 Action119 <- <{ p.Literal = typesv1.ValArr(p.popArray()...) }> */
		func() bool {
			{
				add(ruleAction119, position)
			}
			return true
		},
		/* 242 Action120 <- <{ p.Literal = typesv1.ValObj(p.popObj()...) }> */
		func() bool {
			{
				add(ruleAction120, position)
			}
			return true
		},
		/* 243 Action121 <- <{ p.pushFunc() }> */
		func() bool {
			{
				add(ruleAction121, position)
			}
			return true
		},
		nil,
		/* 245 Action122 <- <{ p.setFuncName(text) }> */
		func() bool {
			{
				add(ruleAction122, position)
			}
			return true
		},
		/* 246 Action123 <- <{ p.addFuncArg(p.popExpr()) }> */
		func() bool {
			{
				add(ruleAction123, position)
			}
			return true
		},
		/* 247 Action124 <- <{ p.pushExpr(typesv1.ExprIdentifier(text)) }> */
		func() bool {
			{
				add(ruleAction124, position)
			}
			return true
		},
		/* 248 Action125 <- <{ p.pushExpr(typesv1.ExprIdentifier(text)) }> */
		func() bool {
			{
				add(ruleAction125, position)
			}
			return true
		},
		/* 249 Action126 <- <{ p.pushExpr(typesv1.ExprIdentifier(text)) }> */
		func() bool {
			{
				add(ruleAction126, position)
			}
			return true
		},
		/* 250 Action127 <- <{ p.String = p.parseDoubleQuoteString(text) }> */
		func() bool {
			{
				add(ruleAction127, position)
			}
			return true
		},
		/* 251 Action128 <- <{ p.F64 = p.parseFloat64(text) }> */
		func() bool {
			{
				add(ruleAction128, position)
			}
			return true
		},
		/* 252 Action129 <- <{ p.F64 = p.parseFloat64(text) }> */
		func() bool {
			{
				add(ruleAction129, position)
			}
			return true
		},
		/* 253 Action130 <- <{ p.F64 = p.parseFloat64(text) }> */
		func() bool {
			{
				add(ruleAction130, position)
			}
			return true
		},
		/* 254 Action131 <- <{ p.I64 = 0 }> */
		func() bool {
			{
				add(ruleAction131, position)
			}
			return true
		},
		/* 255 Action132 <- <{ p.I64 = p.parseInt64(text) }> */
		func() bool {
			{
				add(ruleAction132, position)
			}
			return true
		},
		/* 256 Action133 <- <{ p.Bool = true }> */
		func() bool {
			{
				add(ruleAction133, position)
			}
			return true
		},
		/* 257 Action134 <- <{ p.Bool = false }> */
		func() bool {
			{
				add(ruleAction134, position)
			}
			return true
		},
		/* 258 Action135 <- <{ p.pushArray() }> */
		func() bool {
			{
				add(ruleAction135, position)
			}
			return true
		},
		/* 259 Action136 <- <{ p.addArrItem(p.Literal); p.Literal = nil }> */
		func() bool {
			{
				add(ruleAction136, position)
			}
			return true
		},
		/* 260 Action137 <- <{ p.pushObj() }> */
		func() bool {
			{
				add(ruleAction137, position)
			}
			return true
		},
		/* 261 Action138 <- <{ p.closeObjItem(p.Literal); p.Literal = nil }> */
		func() bool {
			{
				add(ruleAction138, position)
			}
			return true
		},
		/* 262 Action139 <- <{ p.startObjItem(p.String) }> */
		func() bool {
			{
				add(ruleAction139, position)
			}
			return true
		},
		/* 263 Action140 <- <{ p.Duration = p.parseDurationF64(p.F64, text) }> */
		func() bool {
			{
				add(ruleAction140, position)
			}
			return true
		},
		/* 264 Action141 <- <{ p.Duration = p.parseDurationI64(p.I64, text) }> */
		func() bool {
			{
				add(ruleAction141, position)
			}
			return true
		},
		/* 265 Action142 <- <{ p.Timestamp = p.parseTime(time.RFC3339Nano, text) }> */
		func() bool {
			{
				add(ruleAction142, position)
			}
			return true
		},
	}
	p.rules = _rules
	return nil
}
