# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


# DO NOT ADD THINGS OTHER THAN ERROR MESSAGES HERE.
# This file gets parsed into a JS dictionary of all known error message ids in
# gen_aboutneterror_codes.py . If we end up needing fluent attributes or
# refactoring them in some way, the script will need updating.

# Variables:
# $hostname (String) - Hostname of the website with SSL error.
# $errorMessage (String) - Error message corresponding to the type of error we are experiencing.
ssl-connection-error = Un error occurreva durante un connexion a { $hostname }. { $errorMessage }
# Variables:
# $error (string) - NSS error code string that specifies type of cert error. e.g. unknown issuer, invalid cert, etc.
cert-error-code-prefix = Codice de error: { $error }
psmerr-ssl-disabled = Connexion secur impossibile perque le protocollo SSL ha essite disactivate.
psmerr-ssl2-disabled = On non pote connecter se securmente perque le sito usa un version plus vetule e insecur del protocollo SSL.
# This is a multi-line message.
psmerr-hostreusedissuerandserial =
    Tu ha recipite un certificato invalide.  Per favor contacta le administrator del servitor o le correspondente de email e da les le sequente information:
    
    Tu certificato contine le mesme numero serial que un altere certificato emittite per le autoritate de certification.  Per favor obtene un nove certificato continente un numero serial unic.
ssl-error-export-only-server = Impossibile communicar in maniera secur. Le par non supporta cryptographia de alte nivello.
ssl-error-us-only-server = Impossibile communicar in maniera secur. Le par require cryptographia de un alte nivello que non es supportate.
ssl-error-no-cypher-overlap = Impossibile communicar in maniera secur con le par: nulle algorithmo cryptographic in commun.
ssl-error-no-certificate = Incapace a trovar le certificato o le clave necessari pro le authentication.
ssl-error-bad-certificate = Incapace a communicar in maniera secur con le par: le certificato del par esseva rejectate.
ssl-error-bad-client = Le servitor incontrava mal datos ex le cliente.
ssl-error-bad-server = Le cliente incontrava mal datos ex le servitor.
ssl-error-unsupported-certificate-type = Typo de certificato non admittite.
ssl-error-unsupported-version = Le par usa un version non supportate del protocollo de securitate.
ssl-error-wrong-certificate = Authentication de cliente fallite: le clave private in le base de datos del claves non concorda con le clave public in le base de datos del certificato.
ssl-error-bad-cert-domain = Incapace a communicar con securitate con le par: le nomine de dominio requirite non corresponde al certificato del servitor.
ssl-error-post-warning = Codice de error SSL incognite.
ssl-error-ssl2-disabled = Le par supporta solo le version 2 de SSL, que es disactivate.
ssl-error-bad-mac-read = SSL recipeva un registration con un codice de authentication de message incorrecte.
ssl-error-bad-mac-alert = Le par SSL reporta un codice de authentication de message incorrecte.
ssl-error-bad-cert-alert = Le par SSL non pote verificar tu certificate.
ssl-error-revoked-cert-alert = Le par SSL rejectava tu certificato como revocate.
ssl-error-expired-cert-alert = Le par SSL rejectava tu certificato como expirate.
ssl-error-ssl-disabled = Impossibile connecter se: SSL disativate.
ssl-error-fortezza-pqg = Impossibile connecter: le par SSL es in un altere dominio de FORTEZZA.
ssl-error-unknown-cipher-suite = Un suite de cifra SSL incognite ha essite requestate.
ssl-error-no-ciphers-supported = Nulle suite de cifra es presente e activate in iste programma.
ssl-error-bad-block-padding = SSL recipeva un registration con bloco de impletion errate.
ssl-error-rx-record-too-long = SSL recipeva un registration que excedeva le longor maxime permissibile.
ssl-error-tx-record-too-long = SSL tentava de inviar un registration que excedeva le longor maxime permissibile.
ssl-error-rx-malformed-hello-request = SSL recipeva un message de negotiation de connexion Hello Request mal formate.
ssl-error-rx-malformed-client-hello = SSL recipeva un message de negotiation de connexion Client Hello mal formate.
ssl-error-rx-malformed-server-hello = SSL recipeva un message de negotiation de connexion Server Hello mal formate.
ssl-error-rx-malformed-certificate = SSL recipeva un message de negotiation de connexion Certificate mal formate.
ssl-error-rx-malformed-server-key-exch = SSL recipeva un message de negotiation de connexion Server Key Exchange mal formate.
ssl-error-rx-malformed-cert-request = SSL recipeva un message de negotiation de connexion Certificate Request mal formate.
ssl-error-rx-malformed-hello-done = SSL recipeva un message de negotiation de connexion Server Hello Done mal formate.
ssl-error-rx-malformed-cert-verify = SSL recipeva un message de negotiation de connexion Certificate Verify mal formate.
ssl-error-rx-malformed-client-key-exch = SSL recipeva un message de negotiation de connexion Client Key Exchange mal formate.
ssl-error-rx-malformed-finished = SSL recipeva un message de negotiation de connexion Finished mal formate.
ssl-error-rx-malformed-change-cipher = SSL recipeva un registro "Change Cipher Spec" mal formate.
ssl-error-rx-malformed-alert = SSL recipeva un registration de aviso malformate.
ssl-error-rx-malformed-handshake = SSL recipeva un registro Handshake mal formate.
ssl-error-rx-malformed-application-data = SSL recipeva un registration de datos de application malformate.
ssl-error-rx-unexpected-hello-request = SSL recipeva un message de negotiation de connexion Hello Request inexpectate.
ssl-error-rx-unexpected-client-hello = SSL recipeva un message de negotiation de connexion Client Hello inexpectate.
ssl-error-rx-unexpected-server-hello = SSL recipeva un message de negotiation de connexion Server Hello inexpectate.
ssl-error-rx-unexpected-certificate = SSL recipeva un message de negotiation de connexion Certificate inexpectate.
ssl-error-rx-unexpected-server-key-exch = SSL recipeva un message de negotiation de connexion Server Key Exchange inexpectate.
ssl-error-rx-unexpected-cert-request = SSL recipeva un message de negotiation de connexion Certificate Request inexpectate.
ssl-error-rx-unexpected-hello-done = SSL recipeva un message de negotiation de connexion Server Hello Done inexpectate.
ssl-error-rx-unexpected-cert-verify = SSL recipeva un message de negotiation de connexion Certificate Verify inexpectate.
ssl-error-rx-unexpected-client-key-exch = SSL recipeva un message de negotiation de connexion Client Key Exchange inexpectate.
ssl-error-rx-unexpected-finished = SSL recipeva un message de negotiation de connexion Finished inexpectate.
ssl-error-rx-unexpected-change-cipher = SSL recipeva un registro "Change Cipher Spec" inexpectate.
ssl-error-rx-unexpected-alert = SSL recipeva un registration de aviso inexpectate.
ssl-error-rx-unexpected-handshake = SSL recipeva un registro Handshake inexpectate.
ssl-error-rx-unexpected-application-data = SSL recipeva un registration de datos de application inexpectate.
ssl-error-rx-unknown-record-type = SSL recipeva un registration con un typo de contento incognite.
ssl-error-rx-unknown-handshake = SSL recipeva un message de negotiation de connexion con un typo de message incognite.
ssl-error-rx-unknown-alert = SSL recipeva un registration de alerta con un description del alerta incognite.
ssl-error-close-notify-alert = Le par SSL claudeva iste connexion.
ssl-error-handshake-unexpected-alert = Le par SSL non expectava le message de negotiation de connexion que illo recipeva.
ssl-error-decompression-failure-alert = Le par SSL era incapace a decomprimer con successo un registration SSL recipite.
ssl-error-handshake-failure-alert = Le par SSL era incapace a negotiar un collection acceptabile de parametros de securitate.
ssl-error-illegal-parameter-alert = Le par SSL rejectava un message de negotiation de connexion a causa de contento inacceptabile.
ssl-error-unsupported-cert-alert = Le par SSL non gere certificatos del typo que illo recipeva.
ssl-error-certificate-unknown-alert = Le par SSL habeva alcun problema non specificate con le certificato que illo recipeva.
ssl-error-generate-random-failure = SSL incontrava un falta de su generator de numeros aleatori.
ssl-error-sign-hashes-failure = Incapace a signar digitalmente le datos requirite pro verificar tu certificato.
ssl-error-extract-public-key-failure = SSL era incapace a extraher le clave public ex le certificato de par.
ssl-error-server-key-exchange-failure = Falta non specificate durante que on processava le negotiation de connexion SSL Server Key Exchange.
ssl-error-client-key-exchange-failure = Falta non specificate durante que on processava le negotiation de connexion SSL Client Key Exchange.
ssl-error-encryption-failure = Le algorithmo de cryptation de datos in massa ha fallite in le suite de cifra seligite.
ssl-error-decryption-failure = Le algorithmo de decryptation de datos in massa ha fallite in le suite de cifra seligite.
ssl-error-socket-write-failure = Le tentativa de scriber datos cryptate al socket subjacente ha fallite.
ssl-error-md5-digest-failure = Le function de digest MD5 falleva.
ssl-error-sha-digest-failure = Le function de digest SHA-1 falleva.
ssl-error-mac-computation-failure = Computation MAC fallite.
ssl-error-sym-key-context-failure = Falta a crear le contexto de claves symmetric.
ssl-error-sym-key-unwrap-failure = Falta a disinveloppar le clave symmetric in le message de excambio de claves de cliente.
ssl-error-pub-key-size-limit-exceeded = Le servitor SSL ha tentate usar un clave public de grado domestic con un suite de cifra destinate al exportation.
ssl-error-iv-param-failure = Le codice PKCS11 falleva a traducer un IV in un parametro.
ssl-error-init-cipher-suite-failure = Falta de initialisar le suite de cifra seligite.
ssl-error-session-key-gen-failure = Le cliente falleva a crear le clave de session pro le session SSL.
ssl-error-no-server-key-for-alg = Le servitor ha nulle claves pro le tentativa del algoritmo de cambio del clave.
ssl-error-token-insertion-removal = Le token PKCS#11 ha essite inserite o removite durante que un operation esseva in curso.
ssl-error-token-slot-not-found = Nulle token PKCS#11 ha essite trovate pro facer le operation requirite.
ssl-error-no-compression-overlap = Incapace a communicar in maniera secur con le par: nulle algorithmos de compression in commun.
ssl-error-handshake-not-completed = Impossibile initiar un altere negotiation de connexion SSL usque le negotiation actual non es complete.
ssl-error-bad-handshake-hash-value = Recipite valores hash incorrecte in le negotiation de connexion con le par.
ssl-error-cert-kea-mismatch = Le certificato providite non pote esser usate con le algorithmo de excambio de claves seligite.
ssl-error-no-trusted-ssl-client-ca = Nulle autoritate de certification es digne de fide pro le authentication cliente SSL.
ssl-error-session-not-found = Le identificante del session cliente SSL non ha essite trovate in le cache de session del servitor.
ssl-error-decryption-failed-alert = Le par non poteva decryptar un registro SSL que illo recipeva.
ssl-error-record-overflow-alert = Le par recipeva un registration SSL que esseva plus longe que permittite.
ssl-error-unknown-ca-alert = Le par non recognosce, ni confide in le CA que emitteva tu certificato.
ssl-error-access-denied-alert = Le par recipeva un certificato valide, ma le accesso era negate.
ssl-error-decode-error-alert = Le par non ha potite decodificar un message de negotiation de connexion SSL.
ssl-error-decrypt-error-alert = Le par reporta un falta in le verification del signatura o in le excambio de claves.
ssl-error-export-restriction-alert = Le negotiation de reportos de pares non es in conformitate con le regulationes de exportation.
ssl-error-protocol-version-alert = Le par reporta un version de protocollo incompatibile o non supportate.
ssl-error-insufficient-security-alert = Le servitor require cifras plus secur que illos supportate per le cliente.
ssl-error-internal-error-alert = Le par reporta que a illo occurreva un error interne.
ssl-error-user-canceled-alert = Le usator in le par ha cancellate le negotiation de connexion.
ssl-error-no-renegotiation-alert = Le par non permitte le renegotiation del parametros de securitate SSL.
ssl-error-server-cache-not-configured = Cache del servitor SSL non configurate e non disactivate pro iste interfacie de connexion.
ssl-error-unsupported-extension-alert = Le par SSL non supporta le extension hello TLS requirite.
ssl-error-certificate-unobtainable-alert = Le par SSL non pote obtener tu certificato ex le URL supplite.
ssl-error-unrecognized-name-alert = Le par SSL ha nulle certificato pro le nomine de DNS requirite.
ssl-error-bad-cert-status-response-alert = Le par SSL non poteva obtener un responsa OCSP pro su certificato.
ssl-error-bad-cert-hash-value-alert = Le par SSL reportava un valor errate del hash del certificato.
ssl-error-rx-unexpected-new-session-ticket = SSL recipeva un message de negotiation de connexion New Session Ticket inexpectate.
ssl-error-rx-malformed-new-session-ticket = SSL recipeva un message de negotiation de connexion New Session Ticket mal formate.
ssl-error-decompression-failure = SSL recipeva un registration comprimite que non pote ser decomprimite.
ssl-error-renegotiation-not-allowed = Le renegotiation non es permittite sur iste interfacie de connexion SSL.
ssl-error-unsafe-negotiation = Le par tentava un negotiation de connexion obsolete (potentialmente vulnerabile).
ssl-error-rx-unexpected-uncompressed-record = SSL recipeva un registration non comprimite inexpectate.
ssl-error-weak-server-ephemeral-dh-key = SSL recipeva un clave Diffie-Hellman ephemere debile in le message de negotiation de connexion Server Key Exchange.
ssl-error-next-protocol-data-invalid = SSL recipeva datos de extension NPN non valide.
ssl-error-feature-not-supported-for-ssl2 = Le function SSL non es supportate pro connexiones SSL 2.0.
ssl-error-feature-not-supported-for-servers = Le function SSL non es supportate pro servitores.
ssl-error-feature-not-supported-for-clients = Le function SSL non es supportate pro clientes.
ssl-error-invalid-version-range = Le campo del version SSL non es valide.
ssl-error-cipher-disallowed-for-version = Le par SSL seligeva un suite de cifra non autorisate pro le version seligite del protocollo.
ssl-error-rx-malformed-hello-verify-request = SSL recipeva un message de negotiation de connexion Hello Verify Request mal formate.
ssl-error-rx-unexpected-hello-verify-request = SSL recipeva un message de negotiation de connexion Hello Verify Request mal inexpectate.
ssl-error-feature-not-supported-for-version = Le function SSL non es supportate pro iste version del protocollo.
ssl-error-rx-unexpected-cert-status = SSL recipeva un message de negotiation de connexion Certificate Status inexpectate.
ssl-error-unsupported-hash-algorithm = Algorithmo de hash non supportate, usate per le par TLS.
ssl-error-digest-failure = Le function de digest falleva.
ssl-error-incorrect-signature-algorithm = Algorithmo de signatura incorrecte specificate in un elemento signate digitalmente.
ssl-error-next-protocol-no-callback = Le extension de negotiation del protocollo sequente ha essite activate, ma le appello de retorno esseva vacuate ante esser requirite.
ssl-error-next-protocol-no-protocol = Le servitor admitte nulle protocollos cuje cliente annuncia in le extension ALPN.
ssl-error-inappropriate-fallback-alert = Le servitor ha rejectate le negotiation de connexion perque le cliente regredeva a un version inferior de TLS que illo que le servitor admitte.
ssl-error-weak-server-cert-key = Le certificato del servitor includeva un clave public troppo debile.
ssl-error-rx-short-dtls-read = Il non ha satis de spatio in buffer pro le registro DTLS.
ssl-error-no-supported-signature-algorithm = Nulle algorithmo de signatura TLS supportate era configurate.
ssl-error-unsupported-signature-algorithm = Le par usava un combination non supportate de signatura e de algorithmo de hash.
ssl-error-missing-extended-master-secret = Le par ha tentate reprender sin un extension extended_master_secret correcte.
ssl-error-unexpected-extended-master-secret = Le par ha tentate reprender con un extension extended_master_secret correcte.
sec-error-io = Un error de I/O occurreva durante le autorisation de securitate.
sec-error-library-failure = falta de bibliotheca de securitate.
sec-error-bad-data = bibliotheca de securitate: recipite mal datos.
sec-error-output-len = bibliotheca de securitate: error de longor de emission.
sec-error-input-len = bibliotheca de securitate: error de longor de immission.
sec-error-invalid-args = bibliotheca de securitate: argumentos non valide.
sec-error-invalid-algorithm = bibliotheca de securitate: algorithmo non valide.
sec-error-invalid-ava = bibliotheca de securitate: AVA non valide.
sec-error-invalid-time = Catena de tempore formatate impropriemente.
sec-error-bad-der = bibliotheca de securitate: message codificate per DER, formatate impropriemente.
sec-error-bad-signature = Le certificato del par ha un signatura non valide.
sec-error-expired-certificate = Le certificato del par es expirate.
sec-error-revoked-certificate = Le certificato del par ha essite revocate.
sec-error-unknown-issuer = Le certificato del par non es recognite.
sec-error-bad-key = Le clave public del par non es valide.
sec-error-bad-password = Le contrasigno de securitate inserite es incorrecte.
sec-error-retry-password = Le nove contrasigno ha essite scribite incorrectemente. Per favor retenta.
sec-error-no-nodelock = bibliotheca de securitate: nulle blocage de nodo.
sec-error-bad-database = bibliotheca de securitate: mal base de datos.
sec-error-no-memory = bibliotheca de securitate: error de allocation de memoria.
sec-error-untrusted-issuer = Le emissor del certificato del par ha essite marcate per le usator como non digne de fide.
sec-error-untrusted-cert = Le certificato del par ha essite marcate per le usator como non digne de fide.
sec-error-duplicate-cert = Le certificate existe jam in tu base de datos.
sec-error-duplicate-cert-name = Nomine del certificato discargate duplicate, uno jam in tu base de datos.
sec-error-adding-cert = Error a adder le certificato al base de datos.
sec-error-filing-key = Error a readder le clave pro iste certificato.
sec-error-no-key = Le clave private pro iste certificato non pote ser trovate in le base de datos
sec-error-cert-valid = Iste certificato es valide.
sec-error-cert-not-valid = Iste certificato es invalide.
sec-error-cert-no-response = Bibliotheca de certificato: nulle responsa
sec-error-expired-issuer-certificate = Le certificato del emissor de certificatos ha expirate. Verifica le data e hora de tu systema.
sec-error-crl-expired = Le CRL pro le emissor de certificatos ha expirate. Actualisa lo o verifica le data e hora de tu systema.
sec-error-crl-bad-signature = Le CRL pro le emittitor del certificato ha un signatura non valide.
sec-error-crl-invalid = Le nove CRL ha un formato non valide.
sec-error-extension-value-invalid = Le valor de extension del certificato non es valide.
sec-error-extension-not-found = Extension del certificato non trovate.
sec-error-ca-cert-invalid = Le certificato del emittitor non es valide.
sec-error-path-len-constraint-invalid = Le longor del route del certificato es invalide.
sec-error-cert-usages-invalid = Le campo usos del certificato es invalide.
sec-internal-only = **modulo SOLMENTE interne**
sec-error-invalid-key = Le clave non gere le operation requirite.
sec-error-unknown-critical-extension = Le certificato contine un extension critic incognite.
sec-error-old-crl = Le nove CRL non es plus recente de illo actual.
sec-error-no-email-cert = Ni cryptate ni signate: tu non ha ancora un certificato de e-mail.
sec-error-no-recipient-certs-query = Non cryptate: tu non ha certificatos pro cata un del destinatarios.
sec-error-not-a-recipient = Impossibile decryptar: tu non es un destinatario, o le certificato e le clave private correspondente non ha essite trovate.
sec-error-pkcs7-keyalg-mismatch = Impossibile decryptar: le algorithmo de cryptation de claves non corresponde a tu certificato.
sec-error-pkcs7-bad-signature = Le verification de signatura ha fallite: nulle signatario trovate, troppo de signatarios trovate, o datos improprie o corrumpite.
sec-error-unsupported-keyalg = Algorithmo del clave non supportate o incognite.
sec-error-decryption-disallowed = Impossibile decryptar: datos cryptate con un algorithmo o dimension de clave non permittite.
xp-sec-fortezza-bad-card = Le carta Fortezza non ha essite initialisate correctemente. Per favor remove lo e retorna lo a su emissor.
xp-sec-fortezza-no-card = Nulle cartas de Fortezza trovate
xp-sec-fortezza-none-selected = Nulle carta de Fortezza seligite
xp-sec-fortezza-more-info = Por favor elige un personalitate pro obtener informationes re illo
xp-sec-fortezza-person-not-found = Personality non trovate
xp-sec-fortezza-no-more-info = Nulle altere informationes re ille Personalitate
xp-sec-fortezza-bad-pin = Pin invalide
xp-sec-fortezza-person-error = Impossibile initialisar le personalitates de Fortezza.
sec-error-no-krl = Nulle KRL pro iste certificato de sito trovate.
sec-error-krl-expired = Le KRL pro iste certificato de sito ha expirate.
sec-error-krl-bad-signature = Le KRL pro iste certificato de sito ha un signatura non valide.
sec-error-revoked-key = Le clave pro iste certificato de sito ha essite revocate.
sec-error-krl-invalid = Le nove KRL ha un formato non valide.
sec-error-need-random = bibliotheca de securitate: datos casual necessari.
sec-error-no-module = bibliotheca de securitate: nulle modulo de securitate pote exequer le operation requestate.
sec-error-no-token = Le carta de securitate o le token non existe, debe esser initialisate, o ha essite removite.
sec-error-read-only = bibliotheca de securitate: base de datos solo a leger.
sec-error-no-slot-selected = Nulle slot o token ha essite seligite.
sec-error-cert-nickname-collision = Un certificato con le mesme supernomine jam existe.
sec-error-key-nickname-collision = Un clave con le mesme supernomine jam existe.
sec-error-safe-not-created = error durante que esseva create un objecto secur
sec-error-baggage-not-created = error durante que esseva create un objecto bagage
xp-java-remove-principal-error = Il non se poteva remover le principal
xp-java-delete-privilege-error = Il non se poteva deler le privilegio
xp-java-cert-not-exists-error = Iste principal non ha un certificato
sec-error-bad-export-algorithm = Le algorithmo requirite non es permittite.
sec-error-exporting-certificates = Error in le tentativa de exportar certificatos.
sec-error-importing-certificates = Error in le tentativa de importar certificatos.
sec-error-pkcs12-decoding-pfx = Incapace a importar. Error de decodification. File non valide.
sec-error-pkcs12-invalid-mac = Incapace a importar. MAC non valide. Contrasigno incorrecte o file corrupte.
sec-error-pkcs12-unsupported-mac-algorithm = Incapace a importar. Algorithmo MAC non gerite.
sec-error-pkcs12-unsupported-transport-mode = Incapace a importar. Solo le integritate del contrasigno e le modos de confidentialitate es gerite.
sec-error-pkcs12-corrupt-pfx-structure = Incapace a importar. Le structura del file es corrupte.
sec-error-pkcs12-unsupported-pbe-algorithm = Impossibile importar. Algorithmo cryptographic non supportate.
sec-error-pkcs12-unsupported-version = Incapace a importar. Version de file non gerite.
sec-error-pkcs12-privacy-password-incorrect = Incapace a importar. Contrasigno de confidentialitate incorrecte.
sec-error-pkcs12-cert-collision = Incapace a importar. Le mesme supernomine jam existe in le base de datos.
sec-error-user-cancelled = Le usator pulsava Cancel.
sec-error-pkcs12-duplicate-data = Non importate, jam in le base de datos.
sec-error-message-send-aborted = Message non inviate.
sec-error-inadequate-key-usage = Le uso del clave de certificato non es adequate al operation tentate.
sec-error-inadequate-cert-type = Typo de certificato non approbate pro le application.
sec-error-cert-addr-mismatch = Le adresse in le signatura del certificato non concorda con illo in le capites del message.
sec-error-pkcs12-unable-to-import-key = Incapace a importar. Error in le tentativa de importar le clave private.
sec-error-pkcs12-importing-cert-chain = Incapace a importar. Error in le tentativa de importar le catena de certificatos.
sec-error-pkcs12-unable-to-locate-object-by-name = Incapace a importar. Incapace a localisar un certificato o un clave per le supernomine.
sec-error-pkcs12-unable-to-export-key = Incapace a importar. Le clave private non pote ser locate e exportate.
sec-error-pkcs12-unable-to-write = Incapace a exportar. Incapace a scriber le file a exportar.
sec-error-pkcs12-unable-to-read = Incapace a importar. Incapace a scriber le file a importar.
sec-error-pkcs12-key-database-not-initialized = Incapace a exportar. Base de datos de clave corrumpite o cancellate.
sec-error-keygen-fail = Incapace a generar le copula de claves public/private.
sec-error-invalid-password = Le contrasigno inserite non es valide. Tenta con uno differente.
sec-error-retry-old-password = Le contrasigno ancian ha essite scribite incorrectemente. Per favor retenta.
sec-error-bad-nickname = Le supernomine del certificato es ja in uso.
sec-error-not-fortezza-issuer = Le catena FORTEZZA del par ha un certificato non FORTEZZA.
sec-error-cannot-move-sensitive-key = Un clave sensibile non pote esser movite al fissura ubi illo es necessari.
sec-error-js-invalid-module-name = Nomine de modulo invalide.
sec-error-js-invalid-dll = route/nomine file del modulo non valide
sec-error-js-add-mod-failure = Incapace a adder modulo
sec-error-js-del-mod-failure = Incapace a deler modulo
sec-error-old-krl = Le nove KRL non es plus recente de illo actual.
sec-error-ckl-conflict = Le nove CKL ha emissor differente que le CKL actual. Dele le CKL actual.
sec-error-cert-not-in-name-space = Le Autoritate Certificante pro iste certificato non es permittite a emitter un certificato con iste nomine.
sec-error-krl-not-yet-valid = Le lista de claves revocate pro iste certificato non es ancora valide.
sec-error-crl-not-yet-valid = Le lista de certificatos revocate pro iste certificato non es ancora valide.
sec-error-unknown-cert = Le certificato requirite es introvabile.
sec-error-unknown-signer = Le certificato del signator es introvabile.
sec-error-cert-bad-access-location = Le position pro le servitor de stato del certificato ha un formato non valide.
sec-error-ocsp-unknown-response-type = Le responsa OCSP non pote ser decodificate totalmente; illo es de un typo incognite.
sec-error-ocsp-bad-http-response = Le servitor OCSP retornava datos HTTP inexpectate/invalide.
sec-error-ocsp-malformed-request = Le servitor OCSP trovava le requesta corrumpite o mal formate.
sec-error-ocsp-server-error = Le servitor OCSP suffreva de un error interne.
sec-error-ocsp-try-server-later = Le servitor OCSP suggere de reprobar plus tarde.
sec-error-ocsp-request-needs-sig = Le servitor OCSP require un signatura sur iste requesta.
sec-error-ocsp-unauthorized-request = Le servitor OCSP refusava iste requesta como non autorisate.
sec-error-ocsp-unknown-response-status = Le servitor OCSP retornava un stato irrecognoscibile.
sec-error-ocsp-unknown-cert = Le servitor OCSP ha nulle stato pro le certificato.
sec-error-ocsp-not-enabled = Tu debe activar OCSP ante que exequer iste operation.
sec-error-ocsp-no-default-responder = Tu debe predefinir le responditor OCSP ante exequer iste operation.
sec-error-ocsp-malformed-response = Le responsa ex le servitor OCSP era corrupte o mal formate.
sec-error-ocsp-unauthorized-response = Le signator del responsa OCSP non es autorisate a dar le stato pro iste certificato.
sec-error-ocsp-future-response = Le responsa del OCSP non es ancora valide (contine un data in le futur).
sec-error-ocsp-old-response = Le responsa del OCSP contine un information obsolete.
sec-error-digest-not-found = Le digesto CMS o PKCS #7 non ha essite trovate in un message signate.
sec-error-unsupported-message-type = Le typo de message CMS o PKCS #7 non es gerite.
sec-error-module-stuck = Impossibile remover le modulo PKCS #11 perque illo es ancora in uso.
sec-error-bad-template = Impossibile decodificar le datos ASN.1. Le modello specificate non era valide.
sec-error-crl-not-found = Nulle CRL concordante trovate.
sec-error-reused-issuer-and-serial = Tu tenta importar un certificato con le mesme emittitor/numero-serial de un altere certificato, ma que non es lo mesme.
sec-error-busy = NSS non pote arrestar se. Objectos es ancora in uso.
sec-error-extra-input = Message codificate-DER contineva datos extra non usate.
sec-error-unsupported-elliptic-curve = Curva elliptic non gerite.
sec-error-unsupported-ec-point-form = Forma de puncto de curva elliptic non gerite.
sec-error-unrecognized-oid = Identificator de objecto incognite.
sec-error-ocsp-invalid-signing-cert = Certificato de signatura OCSP non valide in le responsa OCSP.
sec-error-revoked-certificate-crl = Le certificato es revocate in un lista de revocation de certificatos del emittitor.
sec-error-revoked-certificate-ocsp = Le responditor OCSP del emissor informa que le certificato es revocate.
sec-error-crl-invalid-version = Le lista de certificatos revocate del emissor ha un numero de version incognite.
sec-error-crl-v1-critical-extension = Le lista de certificatos revocate V1 del emissor ha un extension critic.
sec-error-crl-unknown-critical-extension = Le lista de certificatos revocate V2 del emissor ha un extension critic incognite.
sec-error-unknown-object-type = Typo de objecto incognite specificate.
sec-error-incompatible-pkcs11 = Le driver PKCS #11 viola le specificationes in un maniera incompatibile.
sec-error-no-event = Nulle nove evento de slot es actualmente disponibile.
sec-error-crl-already-exists = Le CRL existe jam.
sec-error-not-initialized = NSS non es initialisate.
sec-error-token-not-logged-in = Le operation falleva perque le token PKCS#11 non ha aperite session.
sec-error-ocsp-responder-cert-invalid = Le certificato del responditor OCSP configurate non es valide.
sec-error-ocsp-bad-signature = Le responsa de OCSP ha un signatura invalide.
sec-error-out-of-search-limits = Le recerca de validation del certificato es foras del limites de recerca
sec-error-invalid-policy-mapping = Le mappa del politica contine irregularitates
sec-error-policy-validation-failed = Le catena de certificato falle de politica de validation
sec-error-unknown-aia-location-type = Typo de position incognite in le extension AIA del certificato
sec-error-bad-http-response = Le servitor rendeva un mal responsa HTTP
sec-error-bad-ldap-response = Le servitor rendeva un mal responsa LDAP
sec-error-failed-to-encode-data = Falta a codificar datos per le codificator ASN1
sec-error-bad-info-access-location = Mal information del position de accesso in le certificato de extension
sec-error-libpkix-internal = Error interne de Libpkix durante le validation del certificato.
sec-error-pkcs11-general-error = Un modulo PKCS #11 retornava CKR_GENERAL_ERROR, indicante le occurrentia de un error irrecovrabile.
sec-error-pkcs11-function-failed = Un modulo PKCS #11 retornava CKR_FUNCTION_FAILED, indicante le function requirite non pote ser exequite. Reprobar de novo pote haber successo.
sec-error-pkcs11-device-error = Un modulo PKCS #11 retornava CKR_DEVICE_ERROR, indicante le occurrentia de un problema con le token o le slot.
sec-error-bad-info-access-method = Methodo de accesso al informationes incognite in extension de certificato.
sec-error-crl-import-failed = Error al tentativa de importar un CRL.
sec-error-expired-password = Contrasigno expirate.
sec-error-locked-password = Contrasigno blocate.
sec-error-unknown-pkcs11-error = Error incognite PKCS #11.
sec-error-bad-crl-dp-url = URL non valide o non gerite in un puncto de distribution CRL.
sec-error-cert-signature-algorithm-disabled = Le certificato era signate per un algorithmo de signatura disactivate perque non secur.
mozilla-pkix-error-key-pinning-failure = Le servitor usa fixation de claves (HPKP) ma nulle catena de certificatos digne de fide que corresponde le insimul de claves fixe ha potite esser construite. Violationes de fixation de clave non pote esser supplantate.
mozilla-pkix-error-ca-cert-used-as-end-entity = Le servitor usa un certificato con un extension de restrictiones basic que lo identifica como un autoritate de certification. Pro un certificato installate correctemente, isto non deberea esser le caso.
mozilla-pkix-error-inadequate-key-size = Le servitor ha presentate un certificato con un dimension de clave que es troppo parve pro establir un connexion secur.
mozilla-pkix-error-v1-cert-used-as-ca = Un certificato X.509 version 1 que non es un ancora de confidentia esseva usate pro le certificato del servitor. Certificatos X.509 verision 1 es obsolete e non deberea esser usate pro signar altere certificatos.
mozilla-pkix-error-not-yet-valid-certificate = Le servitor presentava un certificato que non es plus valide.
mozilla-pkix-error-not-yet-valid-issuer-certificate = Un certificato que non es plus valide era presentate pro emitter le certificato del servitor.
mozilla-pkix-error-signature-algorithm-mismatch = Le algorithmo de signatura in le campo signatura del certificato non corresponde al algorithmo in su campo signatureAlgorithm.
mozilla-pkix-error-ocsp-response-for-cert-missing = Le responsa de OCSP non include un stato pro le certificato a verificar.
mozilla-pkix-error-validity-too-long = Le servitor presentava un certificato que es valide durante troppo de tempore.
mozilla-pkix-error-required-tls-feature-missing = Manca un function TLS necessari.
mozilla-pkix-error-invalid-integer-encoding = Le servitor presentava un certificato que contine un codification non valide de un numero integre. Numeros serial negative, modulos RSA negative e codificationes plus longe quam necesse es causas commun.
mozilla-pkix-error-empty-issuer-name = Le servitor presentava un certificato con un nomine distincte del emittitor vacue.
mozilla-pkix-error-additional-policy-constraint-failed = Un altere coercition de regulamento falleva durante le validation de iste certificato.
mozilla-pkix-error-self-signed-cert = Le certificato non es fidite per que illo es auto-signate.
