//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_25.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot25(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[25] = {2.443048616413472e-02,2.200163986518768e-01,6.119490588603562e-01,1.201766537740989e+00,1.991817805291175e+00,
    2.985315465638807e+00,4.186410501044280e+00,5.600293399082735e+00,7.233327963732224e+00,9.093226798308924e+00,1.118928132171246e+01,1.353266493027597e+01,
    1.613683670538979e+01,1.901808690620518e+01,2.219628800888456e+01,2.569595308971719e+01,2.954777038606832e+01,3.379090709646603e+01,3.847661995637610e+01,
    4.367422804234256e+01,4.948170724011150e+01,5.604632615155951e+01,6.361055216022205e+01,7.263762604545185e+01,8.431659754470152e+01};
  constexpr double aw[25] = {3.050851292043992e-01,2.511308563320018e-01,1.700324556771637e-01,9.454893547708650e-02,4.307915915676566e-02,
    1.603194106841214e-02,4.853263826171954e-03,1.189011781749646e-03,2.342698921092547e-04,3.684019053780712e-05,4.581682707955464e-06,4.457029966817791e-07,
    3.346793404021368e-08,1.909040543811879e-09,8.111877364930081e-11,2.506655523899630e-12,5.465944031815584e-14,8.094261893465156e-16,7.742382957043270e-18,
    4.470984365408032e-20,1.417093599573452e-22,2.137658308360210e-25,1.215244123404523e-28,1.673801667907695e-32,1.833794048573428e-37};
  constexpr double x[9600] = {  1.896781561611456e-03, -1.857862178993128e-05,  1.363502617601414e-07, -8.884049261644665e-10,  5.418116619675158e-12,
 -3.166191532470170e-14,  1.794802138027642e-16, -9.940822957225779e-19,  5.403842404475196e-21, -2.891597888304857e-23,  1.526043086483505e-25, -7.953185239124377e-28,
  1.702951684343407e-02, -1.655619938565035e-04,  1.196946777298350e-06, -7.603603215968863e-09,  4.460924178476160e-11, -2.465223217870516e-13,  1.292959104345135e-15,
 -6.439751390806934e-18,  3.028853272191614e-20, -1.326457638459068e-22,  5.241400578106242e-25, -1.721941996366103e-27,  4.707411878771993e-02, -4.508548942252892e-04,
  3.161430051143700e-06, -1.904866854102847e-08,  1.026698200436387e-10, -4.968642839608379e-13,  2.106712762408174e-15, -7.204019759933742e-18,  1.341821917686991e-20,
  6.343453826302200e-23, -9.684934945700122e-25,  7.549205103834355e-27,  9.159152073175059e-02, -8.575972656354478e-04,  5.736869271962046e-06, -3.173445709960417e-08,
  1.470492299443503e-10, -5.323665203009476e-13,  1.021808398890348e-15,  4.824753106854862e-18, -7.135631720801679e-20,  5.135837285565216e-22, -2.642714312817160e-24,
  9.118579396406512e-27,  1.499297958221721e-01, -1.361693880922128e-03,  8.532561899763947e-06, -4.152166068341648e-08,  1.461997968116360e-10, -1.900337081938365e-13,
 -2.220969807457585e-15,  2.383292597703401e-17, -1.379880725179132e-19,  4.652061035532182e-22,  2.948292352517544e-25, -1.785204615930415e-26,  2.212321541818397e-01,
 -1.933181180521523e-03,  1.111167111503222e-05, -4.465137025362961e-08,  8.306698403401168e-11,  4.849754662412787e-13, -5.918922118243653e-15,  3.152149523574727e-17,
 -6.456475204064418e-20, -5.088974650037231e-22,  6.339597693747120e-24, -3.472819284951458e-26,  3.044475840506323e-01, -2.537940528055945e-03,  1.304957600930473e-05,
 -3.871394530442674e-08, -3.625802005610365e-11,  1.226709637662750e-12, -7.291883476328018e-15,  1.290796217337198e-17,  1.472879035522581e-19, -1.513924548505433e-21,
  5.931674336618212e-24,  1.106976229161281e-26,  3.983441101527123e-01, -3.139669258232992e-03,  1.399150517084731e-05, -2.332689210638143e-08, -1.822103276584461e-10,
  1.660211506975868e-12, -4.397669067780662e-15, -2.683777301290763e-17,  3.179531142420000e-19, -1.058104291168703e-21, -4.968769525536925e-24,  7.273560474551493e-26,
  5.015246258584295e-01, -3.702005038371343e-03,  1.370195388560600e-05, -3.538119142549898e-10, -3.103175611190167e-10,  1.488160488738165e-12,  2.214888399481346e-15,
 -6.104601949747100e-17,  2.397750975233867e-19,  9.879642460955556e-22, -1.451624739916824e-23,  4.013817042360880e-26,  6.124452326221119e-01, -4.190687515362857e-03,
  1.209924190548565e-05,  2.640204167963374e-08, -3.759932656089058e-10,  6.592690907064732e-13,  9.363965101336152e-15, -6.010237200363968e-17, -9.484443591949032e-20,
  2.681544067238790e-21, -7.599349727898332e-24, -7.619921299726109e-26,  7.294359897583419e-01, -4.575634862327095e-03,  9.270293271146028e-06,  5.197571824339128e-08,
 -3.504790526886414e-10, -5.721037128302259e-13,  1.290996259006327e-14, -1.646410788434541e-17, -4.317415750421266e-19,  1.910761505408486e-21,  1.164714384913863e-23,
 -1.143024375250600e-25,  8.507239392363933e-01, -4.832812488211285e-03,  5.463146225177600e-06,  7.132354959308861e-08, -2.321786388886650e-10, -1.735566252066451e-12,
  1.030625877968163e-14,  4.514194131127682e-17, -4.618001024350369e-19, -1.006492218186250e-21,  2.052521642729169e-23,  7.041926678075890e-27,  9.744582236106699e-01,
 -4.945777491012107e-03,  1.057565159623519e-06,  8.046620375055128e-08, -4.901789449489819e-11, -2.349455181707350e-12,  2.383239279281408e-15,  8.320827682446407e-17,
 -1.191586038096240e-19, -3.255492912195468e-21,  6.060398211127527e-24,  1.353053667810486e-25,  1.098737060803789e+00, -4.906795831665189e-03, -3.482915265437613e-06,
  7.742282174541616e-08,  1.494699678557714e-10, -2.145040772917498e-12, -6.894690552838667e-15,  7.029005939764150e-17,  3.286904184521437e-19, -2.467642180013019e-21,
 -1.593489030268322e-23,  8.839820627513204e-26,  1.221636278250311e+00, -4.717449728968955e-03, -7.671518716636650e-06,  6.270648687209984e-08,  3.079320209008771e-10,
 -1.198841919897977e-12, -1.267811347023897e-14,  1.475791279871832e-17,  5.111145667823465e-19,  5.870760106962377e-22, -1.950721670524766e-23, -7.046268584728587e-26,
  1.341239042738313e+00, -4.388680000417989e-03, -1.106334728466633e-05,  3.924812196903357e-08,  3.834560277294065e-10,  9.684952139427212e-14, -1.211552699719736e-14,
 -4.492665830579749e-17,  2.935745250463966e-19,  2.795029998075832e-21, -1.725824176346356e-24, -1.222590963774389e-25,  1.455666353892537e+00, -3.940241006179462e-03,
 -1.331613390347510e-05,  1.175013180787885e-08,  3.597791068058588e-10,  1.215150056838197e-12, -6.014749505629351e-15, -6.950479908908217e-17, -1.071842861639302e-19,
  2.139102699119268e-21,  1.461586151869598e-23, -1.520446818568994e-26,  1.563107802278250e+00, -3.399582877843633e-03, -1.423791471094551e-05, -1.438843045426474e-08,
  2.522023793067883e-10,  1.739222259767808e-12,  1.803641882945428e-15, -4.804520137559355e-17, -3.434243398617123e-19, -2.483905954709886e-22,  1.171464205481053e-23,
  8.099375242736525e-26,  1.661852032081642e+00, -2.800214598343606e-03, -1.381443613029905e-05, -3.432183351672388e-08,  1.012969156269039e-10,  1.547655766091543e-12,
  7.009324620756268e-15, -3.323673058428853e-18, -2.630607787251261e-19, -1.707328582616700e-21, -2.260788503874450e-24,  4.908154510791373e-26,  1.750316298556762e+00,
 -2.179639484203375e-03, -1.221178328926195e-05, -4.487712170258199e-08, -4.232644030035046e-11,  8.475744579557168e-13,  7.420579889809225e-15,  2.963744274183864e-17,
 -1.533840175930230e-20, -1.136732892953526e-21, -8.491575437572316e-24, -2.678284404360800e-26,  1.827074478353979e+00, -1.576988592456164e-03, -9.753203711321505e-06,
 -4.526132592003864e-08, -1.364642285979342e-10,  4.252973815818989e-14,  4.049014056828368e-15,  3.213698286116457e-17,  1.448725700417207e-19,  1.979494729879613e-22,
 -3.151945391443999e-24, -3.458892948114651e-26,  1.890882886808086e+00, -1.030504305910752e-03, -6.872912151965648e-06, -3.717268777938941e-08, -1.619568942417380e-10,
 -4.897247043909782e-13, -6.020324558166820e-17,  1.295281311844087e-17,  1.180389781297625e-19,  6.839892094535191e-22,  2.618546054097755e-24,  2.391608520112294e-27,
  1.940703314736169e+00, -5.750426391288039e-04, -4.053211579610514e-06, -2.428178935600303e-08, -1.279234920162018e-10, -5.871162638663158e-13, -2.207357326268313e-15,
 -5.229197482874753e-18,  1.059770247490364e-20,  2.473561616685754e-22,  2.071411650781839e-24,  1.276893287082825e-26,  1.975723070292661e+00, -2.397639069480928e-04,
 -1.753946651425508e-06, -1.121175445342146e-08, -6.569793906463360e-11, -3.589246449204740e-13, -1.834043197895115e-15, -8.702288243614681e-18, -3.752093733867472e-20,
 -1.391259828595846e-22, -3.681154351325645e-25,  1.326581809073468e-28,  1.995376622302505e+00, -4.612479164003790e-05, -3.443276145530662e-07, -2.277791673307028e-09,
 -1.407132424749323e-11, -8.305558191252855e-14, -4.739342301158102e-16, -2.631674458096750e-18, -1.427384960077250e-20, -7.577488540136253e-23, -3.940384570931975e-25,
 -2.006746991601110e-27,  1.824583178831584e-03, -1.752903605573848e-05,  1.261893780641083e-07, -8.065560485316001e-10,  4.825796039307863e-12, -2.766978292490921e-14,
  1.539183568962547e-16, -8.367019749371354e-19,  4.464808356579849e-21, -2.345748245643291e-23,  1.215781828612616e-25, -6.224390260515200e-28,  1.638585879195518e-02,
 -1.563396229352549e-04,  1.109828619757043e-06, -6.927672291324506e-09,  3.997504800146026e-11, -2.175498076942914e-13,  1.125525453592005e-15, -5.543021265210162e-18,
  2.587284583743945e-20, -1.131469113546924e-22,  4.520419184398367e-25, -1.552147589440270e-27,  4.531987284439483e-02, -4.264506014375573e-04,  2.942383114467192e-06,
 -1.748277023713267e-08,  9.322206550071831e-11, -4.486733498483277e-13,  1.911305153695652e-15, -6.744962452409386e-18,  1.507902306276481e-20,  3.073316820304921e-23,
 -6.806106653896556e-25,  5.620265432056689e-27,  8.825056517002362e-02, -8.131863683404157e-04,  5.369825581846556e-06, -2.946547412431869e-08,  1.366568124885776e-10,
 -5.064636523435988e-13,  1.127572437296983e-15,  2.817553121661612e-18, -5.467418239673176e-20,  4.158022804345368e-22, -2.249660812314253e-24,  8.669787150232173e-27,
  1.446164413801910e-01, -1.295386965668710e-03,  8.048202947198597e-06, -3.921554736117658e-08,  1.419176300960505e-10, -2.358125650962438e-13, -1.612940910593412e-15,
  1.968612783577203e-17, -1.211993013819620e-19,  4.632822539171210e-22, -3.449240746114089e-25, -1.151851333851938e-26,  2.136738555016962e-01, -1.846407794664111e-03,
  1.058412499412285e-05, -4.325212502480950e-08,  9.141617051890702e-11,  3.532638405480097e-13, -5.067667503769510e-15,  2.920831056011328e-17, -7.867963756246300e-20,
 -2.848471802945436e-22,  4.890760369643977e-24, -3.092113525095584e-26,  2.945016613529293e-01, -2.435410248068955e-03,  1.258230708062490e-05, -3.910717686229147e-08,
 -1.344205923695812e-11,  1.056525399614748e-12, -6.872338124496116e-15,  1.679565581840422e-17,  9.713808010035787e-20, -1.270885167612197e-21,  6.130253734939925e-24,
 -1.301849714717227e-27,  3.860074576686314e-01, -3.028903983818059e-03,  1.369516678863721e-05, -2.598259334212473e-08, -1.501166181228346e-10,  1.546763258327806e-12,
 -5.012648614942419e-15, -1.730508801063899e-17,  2.770173189832166e-19, -1.197024666986346e-21, -2.083382119936625e-24,  5.819854596173184e-26,  4.869356939179347e-01,
 -3.592488518687107e-03,  1.366890764884079e-05, -5.078464176535104e-09, -2.801566244271389e-10,  1.521702322401413e-12,  6.175883918437119e-16, -5.291247876278474e-17,
  2.653577700498401e-19,  4.471268506446452e-22, -1.243029088702388e-23,  5.324624729980933e-26,  5.958779340225205e-01, -4.092727473727900e-03,  1.238044414734411e-05,
  2.050326587064061e-08, -3.606982464195573e-10,  8.635538477765688e-13,  7.652667329395670e-15, -6.165750290598838e-17, -4.505248624240529e-21,  2.319642509343637e-21,
 -1.027081408851816e-23, -4.537599486493373e-26,  7.112855895622003e-01, -4.499073773098331e-03,  9.860032350198023e-06,  4.629316741545474e-08, -3.588678642733918e-10,
 -2.692911994100059e-13,  1.226647204362820e-14, -2.909924225600416e-17, -3.557915607163900e-19,  2.275003415536291e-21,  6.561554469690208e-24, -1.148043770185591e-25,
  8.314854276906911e-01, -4.785749489355002e-03,  6.295638831959233e-06,  6.734483946728262e-08, -2.643228314526039e-10, -1.474746031853904e-12,  1.135902910930262e-14,
  2.994291550385312e-17, -4.832937513403906e-19, -1.916021546499811e-22,  1.992374351004447e-23, -3.346237101960188e-26,  9.546981266196669e-01, -4.933471471906960e-03,
  2.016915455904692e-06,  7.930989537622452e-08, -9.524898369359644e-11, -2.264836670676866e-12,  4.642468773286923e-15,  7.757816125890044e-17, -2.306060172022228e-19,
 -2.899465990469212e-21,  1.158168232726223e-23,  1.134903887222013e-25,  1.079060087995710e+00, -4.930905517982190e-03, -2.540935260179256e-06,  7.946283348278556e-08,
  1.050796233870375e-10, -2.285793623325070e-12, -4.793500329758419e-15,  7.927201365292728e-17,  2.294149554593999e-19, -3.016904058097374e-21, -1.128987371064032e-23,
  1.210450825481291e-25,  1.202648616437100e+00, -4.775730138637927e-03, -6.890323723818940e-06,  6.742522618188055e-08,  2.809555207341414e-10, -1.496295789013805e-12,
 -1.203384118812348e-14,  3.129567775218552e-17,  5.175495625695880e-19, -2.448943882015033e-22, -2.181701978717269e-23, -3.286187923586993e-26,  1.323510439346768e+00,
 -4.475198526274462e-03, -1.055554641774881e-05,  4.538270826982494e-08,  3.823892762827487e-10, -2.078646866991657e-13, -1.322698271069333e-14, -3.394647021235566e-17,
  3.916135977715564e-19,  2.613846261583637e-21, -7.425808198136656e-24, -1.348880385578560e-25,  1.439693365257494e+00, -4.046106418402412e-03, -1.313981875746830e-05,
  1.769251058437752e-08,  3.824792446197475e-10,  1.047130023659423e-12, -7.996531668913811e-15, -7.159164579629585e-17, -1.990597484114580e-20,  2.700213884070219e-21,
  1.317814178914361e-23, -5.106781694376322e-26,  1.549280670958272e+00, -3.514105584609357e-03, -1.438521024640753e-05, -1.007304467961099e-08,  2.873042913930761e-10,
  1.765119798326520e-12,  3.038629795420630e-16, -5.908045251754308e-17, -3.430747996988263e-19,  2.911449900864241e-22,  1.523763189009657e-23,  7.758420467661254e-26,
  1.650427576324880e+00, -2.912347571043129e-03, -1.421552269765755e-05, -3.244436727243568e-08,  1.339195717725827e-10,  1.713754270115026e-12,  6.789072390988277e-15,
 -1.273788586338021e-17, -3.255735000041093e-19, -1.748115775085758e-21,  3.856266560703630e-25,  7.159804260221258e-26,  1.741398926952151e+00, -2.279498012575650e-03,
 -1.275378057686711e-05, -4.540877575503791e-08, -2.352725006274984e-11,  1.035530881087082e-12,  8.236924436407117e-15,  2.842409511344416e-17, -6.264318545133071e-20,
 -1.498185425165231e-21, -9.527596300586042e-24, -1.941728871345333e-26,  1.820606980592078e+00, -1.657223783555161e-03, -1.030939415684375e-05, -4.743235346108281e-08,
 -1.345662518785148e-10,  1.510335987844970e-13,  5.014632236100979e-15,  3.685944481813139e-17,  1.493367199031580e-19,  3.857875771256636e-23, -4.889162162873484e-24,
 -4.454397531339551e-26,  1.886648014693026e+00, -1.087316688662289e-03, -7.334855383704223e-06, -3.984230125655896e-08, -1.717341550212936e-10, -4.863671291618196e-13,
  3.592037597605609e-16,  1.714439934496290e-17,  1.445640360786454e-19,  7.897902468112636e-22,  2.642047435293950e-24, -1.664237018531861e-27,  1.938336397055333e+00,
 -6.086695642060255e-04, -4.357270661848087e-06, -2.642543120574117e-08, -1.402072077333124e-10, -6.418027007713135e-13, -2.347567752365104e-15, -4.730449349607092e-18,
  2.113764292127411e-20,  3.423686860677557e-22,  2.702955981159484e-24,  1.602868355578523e-26,  1.974735073457728e+00, -2.543520757375889e-04, -1.895039576652239e-06,
 -1.232282636098079e-08, -7.333706031858040e-11, -4.060060552437096e-13, -2.095289741815554e-15, -9.985914624804955e-18, -4.279146841745555e-20, -1.535491664829696e-22,
 -3.478865120554123e-25,  8.428663178844560e-28,  1.995186435206899e+00, -4.899270434490232e-05, -3.730688511059441e-07, -2.516865780132219e-09, -1.585242659475805e-11,
 -9.536849406505024e-14, -5.544486246530813e-16, -3.135307507306829e-18, -1.730808881660333e-20, -9.345317558862598e-23, -4.938508621111996e-25, -2.553074426743854e-27,
  1.756426565649165e-03, -1.655696389750609e-05,  1.169563489096819e-07, -7.335774522471256e-10,  4.307523391635526e-12, -2.424147748805215e-14,  1.323703778293401e-16,
 -7.064520553934641e-19,  3.701659534486217e-21, -1.910036982587282e-23,  9.724676854562033e-26, -4.892013379878052e-28,  1.577774598118487e-02, -1.477829704296948e-04,
  1.030395187979783e-06, -6.321462940720798e-09,  3.588207436848976e-11, -1.923097379439876e-13,  9.813236641335803e-16, -4.776903497103394e-18,  2.210904662082694e-20,
 -9.637854311733322e-23,  3.876814281092021e-25, -1.373194027148891e-27,  4.365985479608335e-02, -4.037260191970701e-04,  2.741250965788295e-06, -1.606057580289871e-08,
  8.469229965364422e-11, -4.050129618933063e-13,  1.729333136021815e-15, -6.249530348227066e-18,  1.575070063512288e-20,  7.991069387722214e-24, -4.672253498131718e-25,
  4.145341601433477e-27,  8.508154900338022e-02, -7.716056959432516e-04,  5.029029508311384e-06, -2.735850551701554e-08,  1.268035817765023e-10, -4.786396892738825e-13,
  1.184100652006205e-15,  1.290847601851586e-18, -4.123505671249038e-20,  3.332290406708314e-22, -1.884799261908596e-24,  7.876766990230219e-27,  1.395607383907573e-01,
 -1.232845457969902e-03,  7.591078515521585e-06, -3.698451884156687e-08,  1.368567211152379e-10, -2.683315720890101e-13, -1.113543607945794e-15,  1.607103822640901e-17,
 -1.048778210915741e-19,  4.408438349111345e-22, -7.427055391495621e-25, -6.805575464275731e-27,  2.064543189207699e-01, -1.763785536126850e-03,  1.007408794170785e-05,
 -4.173927948451468e-08,  9.732994571247203e-11,  2.411611175228971e-13, -4.286370718564648e-15,  2.656166443262494e-17, -8.572864533112528e-20, -1.150985242551605e-22,
  3.630432245051021e-24, -2.629661042178994e-26,  2.849583620116828e-01, -2.336631043639634e-03,  1.211239924955126e-05, -3.916200158582867e-08,  6.078822220278741e-12,
  8.975432876552989e-13, -6.365083998607668e-15,  1.921909134612255e-17,  5.576116373683498e-20, -1.029513811843123e-21,  5.878644723970556e-24, -9.506811256324519e-27,
  3.741089351254083e-01, -2.920628337843019e-03,  1.336996375563538e-05, -2.814366084197841e-08, -1.204186303399351e-10,  1.421606602894352e-12, -5.379652578624920e-15,
 -9.141359790865647e-18,  2.330012561725377e-19, -1.233564938522055e-21,  1.476543687226789e-25,  4.329574890836040e-26,  4.727839518752637e-01, -3.483454910589140e-03,
  1.358207664055072e-05, -9.317178766496117e-09, -2.496893522681643e-10,  1.519716943009179e-12, -7.433178382473188e-16, -4.425473184617596e-17,  2.730886760900732e-19,
 -1.188839276737332e-24, -9.948194873967955e-24,  5.839557947228743e-26,  5.797065327827265e-01, -3.992796499187159e-03,  1.259245697410040e-05,  1.487965530888219e-08,
 -3.417301358917787e-10,  1.026558890448147e-12,  5.936207443821889e-15, -6.054823175876876e-17,  7.120469453248718e-20,  1.877502034304816e-21, -1.162941241359724e-23,
 -1.702098319703908e-26,  6.934504350523373e-01, -4.418069361186897e-03,  1.038097231509755e-05,  4.052389128856572e-08, -3.613820541408138e-10,  1.411748634965698e-14,
  1.130491550320655e-14, -3.913326493979662e-17, -2.703637745631226e-19,  2.438858206135999e-21,  1.708982024245000e-24, -1.041752150945853e-25,  8.124481738298207e-01,
 -4.732225866307923e-03,  7.077477265022174e-06,  6.289478056002338e-08, -2.910327136472872e-10, -1.193817061254484e-12,  1.198095499040864e-14,  1.451745158671261e-17,
 -4.762966445663360e-19,  5.655412202444150e-22,  1.769347592695847e-23, -6.635977513251876e-26,  9.350024978709774e-01, -4.913558580624441e-03,  2.958017094789855e-06,
  7.743031388895370e-08, -1.392602837809538e-10, -2.128278048273207e-12,  6.696345334218868e-15,  6.862732621710563e-17, -3.255257042465600e-19, -2.345381191470087e-21,
  1.588140000057356e-23,  8.045585746845244e-26,  1.059301885858286e+00, -4.947393713612957e-03, -1.578820390988213e-06,  8.077289803351040e-08,  5.839695072752458e-11,
 -2.373475874376154e-12, -2.487992412474965e-15,  8.479925305128408e-17,  1.140267256835676e-19, -3.354983743969547e-21, -5.466010349590580e-24,  1.413313042118363e-25,
  1.183440679782040e+00, -4.827542272375048e-03, -6.055286771044126e-06,  7.166574649912550e-08,  2.482220769487047e-10, -1.772735394348850e-12, -1.092823880139987e-14,
  4.754571731279680e-17,  4.927940781887133e-19, -1.133506147219584e-21, -2.228135916591464e-23,  1.266373167912847e-26,  1.305444351862749e+00, -4.557360947246843e-03,
 -9.974438428756570e-06,  5.145013375252806e-08,  3.749881951438867e-10, -5.352176024787962e-13, -1.398837117186383e-14, -1.997826532287066e-17,  4.789257826144791e-19,
  2.197294431971267e-21, -1.339523148451786e-23, -1.339464887930987e-25,  1.423300195995582e+00, -4.150270173093415e-03, -1.289013515728508e-05,  2.396861016236668e-08,
  4.013403296475425e-10,  8.311798263349089e-13, -9.994705569923298e-15, -7.057666005511974e-17,  8.614382167870563e-20,  3.170872819701388e-21,  1.006569333796275e-23,
 -9.068779628162986e-26,  1.534993433566376e+00, -3.629589943284025e-03, -1.447734089817754e-05, -5.193945210638404e-09,  3.225392655636456e-10,  1.751334971781483e-12,
 -1.501635043489838e-15, -6.976701661469981e-17, -3.208283923452954e-19,  9.656176470374271e-22,  1.838300804317176e-23,  6.340879646662702e-26,  1.638548326836725e+00,
 -3.027589994397081e-03, -1.459083945512259e-05, -3.001874367803326e-08,  1.697888148506001e-10,  1.871176921465269e-12,  6.277152822773062e-15, -2.415359576587912e-17,
 -3.874051924388600e-19, -1.662692789141650e-21,  4.059077619671184e-24,  9.538030632401322e-26,  1.732073416475921e+00, -2.383712632724097e-03, -1.330022553067166e-05,
 -4.560852000788156e-08, -7.766965822680101e-13,  1.242488542658060e-12,  8.996093664344990e-15,  2.548153393285010e-17, -1.236126862361851e-19, -1.892881869100197e-21,
 -1.010835687286101e-23, -5.816981419447960e-27,  1.813809478977403e+00, -1.742012017959922e-03, -1.089137891239245e-05, -4.955434841532231e-08, -1.302556799254074e-10,
  2.843093829876016e-13,  6.113516116811216e-15,  4.161867805568375e-17,  1.467048055419889e-19, -1.992897504946279e-22, -7.081606704411383e-24, -5.514567866900968e-26,
  1.882178295321616e+00, -1.147955409267564e-03, -7.829768493344897e-06, -4.266722511285294e-08, -1.813335894689577e-10, -4.714359817192743e-13,  9.084300835628422e-16,
  2.224552248898242e-17,  1.748658936887831e-19,  8.922979220732181e-22,  2.436055179164128e-24, -8.169728282322857e-27,  1.935829938984089e+00, -6.448352822053531e-04,
 -4.688269353572591e-06, -2.877453969524198e-08, -1.536169604902953e-10, -6.996451541717051e-13, -2.468540696876110e-15, -3.834530149708010e-18,  3.558878506968665e-20,
  4.656729958917878e-22,  3.489950027988829e-24,  1.982934944356970e-26,  1.973686378988730e+00, -2.701244710605502e-04, -2.050230931874647e-06, -1.356401046882777e-08,
 -8.198352072021962e-11, -4.598082118844363e-13, -2.394915581835456e-15, -1.144628203053108e-17, -4.855814717771669e-20, -1.664272260229438e-22, -2.878345614115069e-25,
  1.969272186484550e-27,  1.994984297721549e+00, -5.210252638153270e-05, -4.048584429735734e-07, -2.786517581021583e-09, -1.790031218299555e-11, -1.097945610108235e-13,
 -6.505255371916814e-16, -3.747039044401476e-18, -2.105679850891447e-20, -1.156485585207159e-22, -6.210519267291237e-25, -3.258695249242498e-27,  1.692015866637463e-03,
 -1.565538893561709e-05,  1.085514836718848e-07, -6.683695958960154e-10,  3.852927074274506e-12, -2.128918062949552e-14,  1.141498108873270e-16, -5.982901511293126e-19,
  3.079173751956078e-21, -1.560872543427915e-23,  7.808580816705468e-26, -3.860649478001688e-28,  1.520263339482230e-02, -1.398337634398839e-04,  9.578594116327362e-07,
 -5.776883740662652e-09,  3.226096322176221e-11, -1.702861650684854e-13,  8.569742872605910e-16, -4.122050206815582e-18,  1.890446251498523e-20, -8.202773562037045e-23,
  3.311292894476987e-25, -1.198891352314842e-27,  4.208762185928400e-02, -3.825444840637968e-04,  2.556394352977481e-06, -1.476810450057986e-08,  7.699320146830629e-11,
 -3.655517090030151e-13,  1.561422091653970e-15, -5.744176819736218e-18,  1.574268587798016e-20, -7.402169573301128e-24, -3.105733165788228e-25,  3.026906943892260e-27,
  8.207355919140108e-02, -7.326528950173676e-04,  4.712589712823507e-06, -2.540467674836459e-08,  1.175171743850217e-10, -4.499260739961196e-13,  1.203474623076533e-15,
  1.493768623046731e-19, -3.051480039307562e-20,  2.644972136930096e-22, -1.558666734546903e-24,  6.934787351458486e-27,  1.347480549959487e-01, -1.173855278287395e-03,
  7.160221134224796e-06, -3.483905005708941e-08,  1.312573898036233e-10, -2.900215420594897e-13, -7.081978962138518e-16,  1.296262114109709e-17, -8.960433774839991e-20,
  4.062297852090063e-22, -9.633655648794045e-25, -3.419178349610328e-27,  1.995572278118345e-01, -1.685169512779826e-03,  9.582702000797965e-06, -4.014875675147379e-08,
  1.011830660749473e-10,  1.469000636560700e-13, -3.581486335235023e-15,  2.377789916803374e-17, -8.752429450794867e-20,  8.386790946127272e-24,  2.578568606339522e-24,
 -2.153405610880328e-26,  2.758026639791362e-01, -2.241608661017266e-03,  1.164360479764384e-05, -3.892924740328202e-08,  2.254655929378238e-11,  7.514078733736006e-13,
 -5.807221854067557e-15,  2.045491152001413e-17,  2.281521945917367e-20, -8.043658220092287e-22,  5.343904017751090e-24, -1.430482978598660e-26,  3.626381588261807e-01,
 -2.815050162492500e-03,  1.302159497128452e-05, -2.984998932993075e-08, -9.329416687048359e-11,  1.290225071705761e-12, -5.537873675280216e-15, -2.391238785187352e-18,
  1.891201434320753e-19, -1.193731633100052e-21,  1.743590208628731e-24,  2.952153119617419e-26,  4.590666445079740e-01, -3.375311135896559e-03,  1.344729908250301e-05,
 -1.307042654383239e-08, -2.195686857057315e-10,  1.487992553047714e-12, -1.860631407345898e-15, -3.558834128756483e-17,  2.665037575679449e-19, -3.476588579196144e-22,
 -7.383393004894351e-24,  5.731603012644990e-26,  5.639378278441063e-01, -3.891433962715685e-03,  1.273890778602140e-05,  9.583392352788787e-09, -3.199100077744448e-10,
  1.149000354844442e-12,  4.282271332547798e-15, -5.727903845204332e-17,  1.303084760883790e-19,  1.404669148056238e-21, -1.184104002262973e-23,  6.464830009521810e-27,
  6.759471943562619e-01, -4.333174616486579e-03,  1.083262234486477e-05,  3.475838973433699e-08, -3.584799862187377e-10,  2.713904271452791e-13,  1.010130376101975e-14,
 -4.637560566647014e-17, -1.823943771639742e-19,  2.420548434096583e-21, -2.488970704067959e-24, -8.562901553012179e-26,  7.936371759837293e-01, -4.672667972156974e-03,
  7.803538483182172e-06,  5.806297708504632e-08, -3.120095039919082e-10, -9.030950207274875e-13,  1.217806194246674e-14, -2.678655236345968e-19, -4.439703775843968e-19,
  1.207482694028020e-21,  1.424086752400039e-23, -8.868504365322293e-26,  9.154014188601457e-01, -4.886218842693584e-03,  3.872437228128017e-06,  7.487098809497581e-08,
 -1.800694730989107e-10, -1.945757553856579e-12,  8.460292672196997e-15,  5.698842046864762e-17, -3.977743713225393e-19, -1.650670950136704e-21,  1.856542119018271e-23,
  4.090497250810521e-26,  1.039493206264178e+00, -4.956134918393184e-03, -6.055142901620753e-07,  8.132506202853218e-08,  1.052429260853238e-11, -2.404395626768708e-12,
 -8.091601243362915e-17,  8.648578327532118e-17, -9.163529305049860e-21, -3.446621741678486e-21,  9.204366947075341e-25,  1.463080847043102e-25,  1.164039164351919e+00,
 -4.872479879072805e-03, -5.172683347148900e-06,  7.533989579531830e-08,  2.102614525060517e-10, -2.017299633336951e-12, -9.383537394219835e-15,  6.249215372682223e-17,
  4.362085813124880e-19, -1.999439703769883e-21, -2.066431308792611e-23,  6.075428165578503e-26,  1.287059370041677e+00, -4.634585784322505e-03, -9.321450730195586e-06,
  5.734591108384554e-08,  3.608905692594004e-10, -8.758503003718537e-13, -1.432211516078590e-14, -3.501733285428970e-18,  5.469959533498929e-19,  1.547418167531105e-21,
 -1.897436685785844e-23, -1.168848607748339e-25,  1.406494850424737e+00, -4.252130421084247e-03, -1.256347862199078e-05,  3.050934620369670e-08,  4.154071958735545e-10,
  5.680126788415799e-13, -1.191459349401525e-14, -6.592443361355726e-17,  2.064744877284924e-19,  3.482048589430744e-21,  5.210521519845913e-24, -1.293891649393974e-25,
  1.520243168943641e+00, -3.745567603232671e-03, -1.450755679705986e-05,  2.442539101490345e-10,  3.570415005499538e-10,  1.690731219768233e-12, -3.592575233200174e-15,
 -7.933035427541385e-17, -2.722198007176376e-19,  1.749761598863649e-21,  2.062741501158981e-23,  3.637963003270796e-26,  1.626202301017551e+00, -3.145708531054390e-03,
 -1.493350385204620e-05, -2.699480476661902e-08,  2.086566198319461e-10,  2.012258147204086e-12,  5.418569088563402e-15, -3.746831998990841e-17, -4.432663289058815e-19,
 -1.409642549359679e-21,  8.754862963114834e-24,  1.174774052377055e-25,  1.722322298378141e+00, -2.492301891225018e-03, -1.384674365004863e-05, -4.541018437159631e-08,
  2.628734142024414e-11,  1.466443841298407e-12,  9.643396191678852e-15,  2.035741968676821e-17, -1.990454248643441e-19, -2.296648572313808e-21, -9.924208611518722e-24,
  1.558938751244132e-26,  1.806663353331748e+00, -1.831556601578495e-03, -1.149832106562992e-05, -5.158457211903276e-08, -1.230051512543358e-10,  4.455394255020727e-13,
  7.343066128698694e-15,  4.613884002867935e-17,  1.338188067452561e-19, -5.341488146195347e-22, -9.735298878983314e-24, -6.527014673591270e-26,  1.877457884113720e+00,
 -1.212691614543591e-03, -8.359489922948887e-06, -4.564258416858871e-08, -1.904904368066188e-10, -4.414965154842764e-13,  1.614603019414910e-15,  2.837314629230065e-17,
  2.086325818572191e-19,  9.799333586468405e-22,  1.874312367474702e-24, -1.798943283600946e-26,  1.933173338263038e+00, -6.837654832977822e-04, -5.048783344757858e-06,
 -3.134760724610843e-08, -1.682102755914773e-10, -7.600333469847174e-13, -2.557241214971533e-15, -2.398739610905995e-18,  5.508715146986471e-20,  6.239461357487046e-22,
  4.454739674724755e-24,  2.408661736201665e-26,  1.972572014115421e+00, -2.872004102879699e-04, -2.221183370534498e-06, -1.495255128341680e-08, -9.178135608646584e-11,
 -5.213133336728911e-13, -2.738080964543371e-15, -1.309803092220451e-17, -5.473179857760206e-20, -1.757490468293374e-22, -1.656464248771133e-25,  3.704930420809744e-27,
  1.994769191004685e+00, -5.548018823594950e-05, -4.400903970222011e-07, -3.091375083700554e-09, -2.026123829806708e-11, -1.267463459689555e-13, -7.655378453932106e-16,
 -4.492559907145496e-18, -2.570412381528638e-20, -1.436102097343031e-22, -7.836795210443968e-25, -4.172604274448352e-27,  1.631081776589606e-03, -1.481804223064464e-05,
  1.008873457352522e-07, -6.099856821025062e-10,  3.453237910493156e-12, -1.873997481724937e-14,  9.869679502830936e-17, -5.081760915177675e-19,  2.569618466620590e-21,
 -1.279996828299344e-23,  6.293538330168284e-26, -3.058886957019812e-28,  1.465819710435489e-02, -1.324396553490105e-04,  8.915249858678497e-07, -5.286874667190487e-09,
  2.905190697213328e-11, -1.510380721839669e-13,  7.495997887758195e-16, -3.561899306803239e-18,  1.617760995713448e-20, -6.978881578538628e-23,  2.819982152606947e-25,
 -1.036723344782751e-27,  4.059725270589556e-02, -3.627817987827816e-04,  2.386333630669869e-06, -1.359271912047290e-08,  7.004417365937667e-11, -3.299510224616464e-13,
  1.407582138020941e-15, -5.246827881323245e-18,  1.528224278494980e-20, -1.742687892193042e-23, -1.967851731073777e-25,  2.185205003728907e-27,  7.921646252908995e-02,
 -6.961403108196874e-04,  4.418723372196391e-06, -2.359482125367111e-08,  1.088072911560577e-10, -4.210944514421562e-13,  1.195335587170502e-15, -6.861995598640001e-19,
 -2.204421045729124e-20,  2.079670072727278e-22, -1.274906230123437e-24,  5.966204621961202e-27,  1.301645994679386e-01, -1.118210527849324e-03,  6.754559160838447e-06,
 -3.278614101177271e-08,  1.253147725186975e-10, -3.029736196342093e-13, -3.832432292398066e-16,  1.032158582669551e-17, -7.570293885396043e-20,  3.654423385210223e-22,
 -1.058981420210265e-24, -1.077637166159888e-27,  1.929668607990211e-01, -1.610407321257051e-03,  9.110712924792144e-06, -3.851077326044470e-08,  1.033138068812793e-10,
  6.861822418155556e-14, -2.954739062771453e-15,  2.100008706420886e-17, -8.558181359326259e-20,  9.392867535110254e-23,  1.731183986996338e-24, -1.705358891940737e-26,
  2.670195784919369e-01, -2.150321199934499e-03,  1.117909023291512e-05, -3.845565392554197e-08,  3.622769335596162e-11,  6.189645860495854e-13, -5.228329601579922e-15,
  2.076165595045230e-17, -2.453693700537012e-21, -6.040069245447097e-22,  4.658117107416629e-24, -1.650314463519861e-26,  3.515840017980326e-01, -2.712333664063007e-03,
  1.265526698219215e-05, -3.114349234018494e-08, -6.882081072975204e-11,  1.157157337478847e-12, -5.526453416505717e-15,  2.988797304004589e-18,  1.476808983895975e-19,
 -1.101639366365649e-21,  2.775176839291579e-24,  1.774037106648187e-26,  4.457794820430278e-01, -3.268417602019943e-03,  1.327034870157812e-05, -1.634819460048328e-08,
 -1.903311762246442e-10,  1.432329912586784e-12, -2.739970982900088e-15, -2.731261455702800e-17,  2.492680426096573e-19, -5.938969987741223e-22, -4.968087199657783e-24,
  5.191127614864532e-26,  5.485765223552352e-01, -3.789147933027576e-03,  1.282397209376328e-05,  4.653720114346754e-09, -2.960295427741782e-10,  1.233043782231499e-12,
  2.743791711702986e-15, -5.239059121304376e-17,  1.724712273945217e-19,  9.423009732844481e-22, -1.115051107212174e-23,  2.388009228240559e-26,  6.587903224780803e-01,
 -4.244942245721500e-03,  1.121552949593626e-05,  2.907885218468030e-08, -3.507361146271567e-10,  4.976596306152956e-13,  8.733996348737456e-15, -5.084418717731286e-17,
 -9.789554302326991e-20,  2.252177503955070e-21, -5.762483436769357e-24, -6.274112108826190e-26,  7.750756520054503e-01, -4.607538777636476e-03,  8.469796617940022e-06,
  5.294217912906299e-08, -3.271573898424215e-10, -6.124730313397722e-13,  1.197893621208516e-14, -1.367735523615838e-17, -3.912257362124570e-19,  1.695095655017474e-21,
  1.006239756002771e-23, -9.932012010300156e-26,  8.959241197275855e-01, -4.851697399626455e-03,  4.752355370797128e-06,  7.169010353829881e-08, -2.168325519028084e-10,
 -1.725050482489418e-12,  9.869870767357060e-15,  4.345497547628245e-17, -4.435077927212086e-19, -8.841435621109136e-22,  1.946360689267905e-23,  1.612908144238567e-28,
  1.019665158293708e+00, -4.957076218416239e-03,  3.698117884063065e-07,  8.110946318071290e-08, -3.738754584792008e-11, -2.377425607534353e-12,  2.318050651447429e-15,
  8.422688985556559e-17, -1.310448885575300e-19, -3.283159174399350e-21,  7.172379675190491e-24,  1.353095104994408e-25,  1.144472284335477e+00, -4.910190982463754e-03,
 -4.249788860094563e-06,  7.836969735797761e-08,  1.678129923920128e-10, -2.220001905147506e-12, -7.450259658703292e-15,  7.514566999781498e-17,  3.501187531858915e-19,
 -2.759006956788949e-21, -1.699041687818564e-23,  1.050880959777990e-25,  1.268376378655848e+00, -4.706308076845471e-03, -8.599292864445130e-06,  6.296135096050348e-08,
  3.399387345206423e-10, -1.218733713062937e-12, -1.416783506791002e-14,  1.473740776699187e-17,  5.878793419998591e-19,  6.943064059029194e-22, -2.343652171314326e-23,
 -8.332424289191745e-26,  1.389287792316539e+00, -4.351060051302387e-03, -1.215716449484677e-05,  3.723059406337891e-08,  4.237627848194529e-10,  2.607754148428485e-13,
 -1.364891297215565e-14, -5.728311673813498e-17,  3.341147587544522e-19,  3.566519610104019e-21, -1.219618213024332e-24, -1.612275510100261e-25,  1.505028936634422e+00,
 -3.861516682476789e-03, -1.446925116295040e-05,  6.221978063335397e-09,  3.898091663423005e-10,  1.576934031643373e-12, -5.925159557155312e-15, -8.687178859307995e-17,
 -1.940890560106709e-19,  2.595899208981313e-21,  2.138391020342368e-23, -4.177267402135921e-27,  1.613378563438772e+00, -3.266412455250495e-03, -1.523606054063260e-05,
 -2.332765784196281e-08,  2.501087880919532e-10,  2.128067381379710e-12,  4.163785897856427e-15, -5.238676696460956e-17, -4.864143985038148e-19, -9.507011986945141e-22,
  1.431094289509791e-23,  1.336958906525976e-25,  1.712128104877942e+00, -2.605246067518787e-03, -1.438813319491444e-05, -4.474220105703812e-08,  5.797275017015004e-11,
  1.703926601784582e-12,  1.011126602364207e-14,  1.259030505202190e-17, -2.886308398438017e-19, -2.671634636671197e-21, -8.603978230133287e-24,  4.595291861232579e-26,
  1.799149187100850e+00, -1.926051945320817e-03, -1.212881813187793e-05, -5.347134518036646e-08, -1.122249688192459e-10,  6.377389546846851e-13,  8.691444520605920e-15,
  5.003244171175499e-17,  1.068643505199174e-19, -9.835421184257413e-22, -1.279143876389037e-23, -7.306233970330627e-26,  1.872469822966229e+00, -1.281810847364253e-03,
 -8.925771810885970e-06, -4.875868105028062e-08, -1.988644730978500e-10, -3.924251789919666e-13,  2.507915025966439e-15,  3.562653040873051e-17,  2.450348376239583e-19,
  1.035265366579489e-21,  7.895327801654457e-25, -3.211429989042978e-26,  1.930355047234917e+00, -7.257073654121109e-04, -5.441615295127537e-06, -3.416393060759644e-08,
 -1.840289985742881e-10, -8.219918802484455e-13, -2.596092502509337e-15, -2.400156638859050e-19,  8.102399937177081e-20,  8.246471040140710e-22,  5.613011420940206e-24,
  2.856940101814055e-26,  1.971386500827697e+00, -3.057133804697827e-04, -2.409780978015609e-06, -1.650816190090253e-08, -1.028955163003801e-10, -5.916320086045881e-13,
 -3.130303904318789e-15, -1.495159961294523e-17, -6.113253923020132e-20, -1.784192670959852e-22,  5.116287920921346e-26,  6.323442821251152e-27,  1.994539985818131e+00,
 -5.915500783239166e-05, -4.792189841472981e-07, -3.436877077927190e-09, -2.299058487373723e-11, -1.467267030928028e-13, -9.036674959838612e-16, -5.404239621692866e-18,
 -3.148552534373346e-20, -1.789562041438277e-22, -9.922538833556880e-25, -5.359348364838128e-27,  1.573378735800193e-03, -1.403931116875229e-05,  9.388706407349310e-08,
 -5.576082468392128e-10,  3.101019377044410e-12, -1.653311620006714e-14,  8.555309748535204e-17, -4.328603549311010e-19,  2.151069461185657e-21, -1.053219027109332e-23,
  5.090888600065566e-26, -2.433027260041120e-28,  1.414231194130944e-02, -1.255535467188329e-04,  8.307748639308004e-07, -4.845265654875087e-09,  2.620326384268874e-11,
 -1.341882229639091e-13,  6.567514979548798e-16, -3.082323668806605e-18,  1.385766355674743e-20, -5.937688241420747e-23,  2.396656556710410e-25, -8.902126681223301e-28,
  3.918330005266696e-02, -3.443250180844638e-04,  2.229733285743245e-06, -1.252301798193031e-08,  6.377135606880968e-11, -2.978773542995213e-13,  1.267413285924049e-15,
 -4.769177270307682e-18,  1.453452791697282e-20, -2.357397213340927e-23, -1.151440177110917e-25,  1.556324937021389e-27,  7.650084860418808e-02, -6.618941096537407e-04,
  4.145758122747726e-06, -2.191972887128931e-08,  1.006703425196466e-10, -3.927100939310181e-13,  1.167304431892779e-15, -1.281170746989721e-18, -1.541459250602964e-20,
  1.619443337193861e-22, -1.032955788873048e-24,  5.042993024793724e-27,  1.257973860665930e-01, -1.065714167011426e-03,  6.372954362413948e-06, -3.082998669042475e-08,
  1.191853668853339e-10, -3.089652840496520e-13, -1.262346374331612e-16,  8.101349718893343e-18, -6.331621815591222e-20,  3.226397375132883e-22, -1.069918556800886e-24,
  4.675491746324090e-28,  1.866681158816850e-01, -1.539341953382504e-03,  8.658535111285302e-06, -3.685043201656881e-08,  1.040230777200384e-10,  4.454619371819811e-15,
 -2.404481791017017e-15,  1.832754221047314e-17, -8.112367225009121e-20,  1.493792152699934e-22,  1.070273297558918e-24, -1.308288169671424e-26,  2.585942516034644e-01,
 -2.062723598015475e-03,  1.072148721566466e-05, -3.778359699350707e-08,  4.739914686259588e-11,  5.004328779804739e-13, -4.651123295766874e-15,  2.036975507947355e-17,
 -2.102124635425391e-20, -4.324181504997811e-22,  3.918870648343915e-24, -1.684976675830989e-26,  3.409347603410682e-01, -2.612603422860601e-03,  1.227567875624750e-05,
 -3.206664903374157e-08, -4.699462694860548e-11,  1.026024861000015e-12, -5.382407421374007e-15,  7.102813070422501e-18,  1.101809639023136e-19, -9.779699480595647e-22,
  3.339646594390518e-24,  8.314932779370892e-27,  4.329168245038635e-01, -3.163089143125601e-03,  1.305683166556359e-05, -1.916813762153584e-08, -1.623995461739601e-10,
  1.358273905384213e-12, -3.396514477470846e-15, -1.971213728949304e-17,  2.248413268607844e-19, -7.491485515633344e-22, -2.852554787927514e-24,  4.396275638619899e-26,
  5.336253566813475e-01, -3.686411402704978e-03,  1.285222196274379e-05,  1.176251730058062e-10, -2.708256338576795e-10,  1.281943522934377e-12,  1.358621330794370e-15,
 -4.641254147589528e-17,  1.986536709736454e-19,  5.210246335136495e-22, -9.832010282201166e-24,  3.505172538367218e-26,  6.419920783647896e-01, -4.153916797060950e-03,
  1.153116906707520e-05,  2.355759956023332e-08, -3.388035952716892e-10,  6.899111058491019e-13,  7.278344323824607e-15, -5.272905382404117e-17, -2.156715173862612e-20,
  1.973526604928684e-21, -7.995756436556928e-24, -3.885224665853439e-26,  7.567849105175026e-01, -4.537328997125487e-03,  9.073341609473107e-06,  4.762513082708003e-08,
 -3.365699885440632e-10, -3.309298756473405e-13,  1.143037904335955e-14, -2.515112192416851e-17, -3.240175829704022e-19,  2.009568339404209e-21,  5.664711296640325e-24,
 -9.887489722766727e-26,  8.765987296498750e-01, -4.810298946668022e-03,  5.590724905467984e-06,  6.795802945667544e-08, -2.488746302309065e-10, -1.475200486866875e-12,
  1.088420159321905e-14,  2.890304881732300e-17, -4.614250004356564e-19, -1.167530390413060e-22,  1.863658349945360e-23, -3.675490652334972e-26,  9.998489156362258e-01,
 -4.950238229395705e-03,  1.337979000096740e-06,  8.013468902577641e-08, -8.419160354124082e-11, -2.294072964931358e-12,  4.600387420439142e-15,  7.820899931700099e-17,
 -2.426971611002781e-19, -2.883691815846898e-21,  1.261672455394010e-23,  1.100716275945434e-25,  1.124769539797092e+00, -4.940385336618919e-03, -3.294737108817283e-06,
  8.069052673741662e-08,  1.218014595990154e-10, -2.372389390950807e-12, -5.205138864479263e-15,  8.463883709372945e-17,  2.397777255764021e-19, -3.335116375569164e-21,
 -1.156419882875654e-23,  1.394497393094761e-25,  1.249418470669275e+00, -4.771989783231572e-03, -7.811986267660166e-06,  6.818707723796746e-08,  3.122082644889013e-10,
 -1.551667750754815e-12, -1.348938784226503e-14,  3.376213567192621e-17,  5.952346855612131e-19, -3.033175421220161e-22, -2.609626159610405e-23, -3.556766797076949e-26,
  1.371692030103213e+00, -4.446414757137493e-03, -1.166960311439767e-05,  4.403420241850439e-08,  4.255793809104447e-10, -8.471951614491831e-14, -1.508400440602299e-14,
 -4.456083920466686e-17,  4.598592518066313e-19,  3.369216358851706e-21, -8.781398066155734e-24, -1.797868388284604e-25,  1.489351987534840e+00, -3.976863666151501e-03,
 -1.435615228520943e-05,  1.270266927935153e-08,  4.197255441758183e-10,  1.404931682664891e-12, -8.429301869830407e-15, -9.142354105543715e-17, -8.541707665888884e-20,
  3.432869394899258e-21,  2.008110401878540e-23, -5.676381375279973e-26,  1.600067464094808e+00, -3.389349370229408e-03, -1.549056131843824e-05, -1.898052760479574e-08,
  2.935414221509184e-10,  2.208610028724904e-12,  2.474752743466783e-15, -6.837747699256193e-17, -5.088935990774809e-19, -2.581096769216408e-22,  2.035647680331339e-23,
  1.387993884557888e-25,  1.701473535854210e+00, -2.722480313994934e-03, -1.491830664226985e-05, -4.352872378517655e-08,  9.450076151403824e-11,  1.949692505440967e-12,
  1.031958155968955e-14,  1.753433972295723e-18, -3.904183651607154e-19, -2.964365960000563e-21, -5.744619490156084e-24,  8.546926895690148e-26,  1.791246812686534e+00,
 -2.025678594747484e-03, -1.278078893348425e-05, -5.515308999895381e-08, -9.726892457908532e-11,  8.634945406662611e-13,  1.013416429838014e-14,  5.278045773161147e-17,
  6.145981915233448e-20, -1.560771565119020e-21, -1.609006770902532e-23, -7.575261258657262e-26,  1.867195984446556e+00, -1.355612103167519e-03, -9.530214414034359e-06,
 -5.199967477915230e-08, -2.060255501987741e-10, -3.193440772817704e-13,  3.620862276716530e-15,  4.406697966599778e-17,  2.824847312874139e-19,  1.033280127465295e-21,
 -1.030375478501884e-24, -5.156757791898624e-26,  1.927362483127721e+00, -7.709314837403283e-04, -5.869802719573499e-06, -3.724329523709806e-08, -2.010908063124628e-10,
 -8.840567201723777e-13, -2.561727635458226e-15,  2.873617968534646e-18,  1.150673944952376e-19,  1.075596056497183e-21,  6.965381087704857e-24,  3.280489199526319e-26,
  1.970123795458069e+00, -3.258129341692609e-04, -2.618160988580882e-06, -1.825337959139734e-08, -1.155145071692640e-10, -6.720100012897138e-13, -3.577295415525348e-15,
 -1.700961113183021e-17, -6.744249243021943e-20, -1.697722563696652e-22,  4.094267450906323e-25,  1.020907261326564e-26,  1.994295427948006e+00, -6.316021418887462e-05,
 -5.227694076237924e-07, -3.829434666517799e-09, -2.615487064786169e-11, -1.703506377143736e-13, -1.070117638612266e-15, -6.523001565209688e-18, -3.870302391451661e-20,
 -2.237878477011214e-22, -1.260565125664797e-24, -6.903926614163686e-27,  1.518682464471412e-03, -1.331416080017838e-05,  8.748290155900074e-08, -5.105296594027491e-10,
  2.789946831212788e-12, -1.461784146512240e-14,  7.434237180651785e-17, -3.697196635137507e-19,  1.806125961248234e-21, -8.694637329473346e-24,  4.132566799774361e-26,
 -1.942509584979993e-28,  1.365303171204283e-02, -1.191329918152629e-04,  7.750613212312664e-07, -4.446655611969971e-09,  2.367037985838128e-11, -1.194136492701376e-13,
  5.763460800012165e-16, -2.671303533417088e-18,  1.188357624228314e-20, -5.053423493897138e-23,  2.034116495294069e-25, -7.604678981836020e-28,  3.784074786804440e-02,
 -3.270713531104587e-04,  2.085387752840454e-06, -1.154872842193118e-08,  5.810743986549122e-11, -2.690101349446661e-13,  1.140254602075115e-15, -4.318414994843459e-18,
  1.361810143823843e-20, -2.695778584664143e-23, -5.743977041914897e-26,  1.089830838149905e-27,  7.391797627894243e-02, -6.297533964187499e-04,  3.892131435611273e-06,
 -2.037032797430953e-08,  9.309312179640277e-11, -3.651758878282626e-13,  1.125347940683986e-15, -1.688713499285025e-18, -1.027717318503398e-20,  1.248099599204684e-22,
 -8.298797845135846e-25,  4.203393844623635e-27,  1.216341987364722e-01, -1.016178423383512e-03,  6.014232068157872e-06, -2.897254673536948e-08,  1.129929999703843e-10,
 -3.094913749374586e-13,  7.392505812706561e-17,  6.252871465824520e-18, -5.246360773925399e-20,  2.805724683230014e-22, -1.026498834603457e-24,  1.423881172478738e-27,
  1.806465239262615e-01, -1.471814211706598e-03,  8.226309390241038e-06, -3.518831621126135e-08,  1.035751673793768e-10, -4.738299498625600e-14, -1.926792877521508e-15,
  1.582482653966768e-17, -7.510464220660160e-20,  1.817131723372282e-22,  5.709473882911357e-25, -9.715963760791438e-27,  2.505120486091513e-01, -1.978751698167648e-03,
  1.027294553538090e-05, -3.695101406937044e-08,  5.633728337631721e-11,  3.955608057046028e-13, -4.092320577557254e-15,  1.947681561170546e-17, -3.394381785378230e-20,
 -2.903042284767238e-22,  3.193229986141021e-24, -1.597837898084440e-26,  3.306783043976175e-01, -2.515948460181338e-03,  1.188702212589772e-05, -3.266134336716567e-08,
 -2.774787390757091e-11,  8.996004481715661e-13, -5.139273078721861e-15,  1.009165327831721e-17,  7.744601886492142e-20, -8.393124260539531e-22,  3.541799902263859e-24,
  1.249969516612867e-27,  4.204718607827918e-01, -3.059596698155817e-03,  1.281210529332198e-05, -2.155380894874973e-08, -1.360898451542477e-10,  1.270921689845359e-12,
 -3.851915653714773e-15, -1.296711830011049e-17,  1.962605651545380e-19, -8.271811710013625e-22, -1.114824560709934e-24,  3.495316925250107e-26,  5.190852541453038e-01,
 -3.583659687643200e-03,  1.282848484977066e-05, -4.009131090691953e-09, -2.449621815735141e-10,  1.299688847371868e-12,  1.503637536523808e-16, -3.982827294535195e-17,
  2.107221129079489e-19,  1.605910800009838e-22, -8.149669562266394e-24,  4.056034645262203e-26,  6.255625716158192e-01, -4.060627726491388e-03,  1.178181982853237e-05,
  1.825611620860479e-08, -3.233782927649956e-10,  8.468597859447574e-13,  5.802492006316994e-15, -5.234711611994395e-17,  4.337247476234492e-20,  1.626236917219303e-21,
 -9.206845059624962e-24, -1.665503796260785e-26,  7.387842577190733e-01, -4.462548212453465e-03,  9.612361625622399e-06,  4.220170779634605e-08, -3.405081043875286e-10,
 -6.615500190614429e-14,  1.059212662217829e-14, -3.432682856832636e-17, -2.486236400724931e-19,  2.151390552927990e-21,  1.496526516311543e-24, -8.929085845030539e-26,
  8.574520518654460e-01, -4.762381004759430e-03,  6.381402316547452e-06,  6.375444143259325e-08, -2.757095006116070e-10, -1.205935565727360e-12,  1.148714133219633e-14,
  1.421034447371880e-17, -4.526848504310168e-19,  5.871198644123813e-22,  1.634449829239635e-23, -6.590174655293611e-26,  9.800754237456337e-01, -4.935714276826098e-03,
  2.290020212101304e-06,  7.842729816821560e-08, -1.287965210162402e-10, -2.158355252856914e-12,  6.666650989540583e-15,  6.888797745137085e-17, -3.363479006903645e-19,
 -2.292068316185161e-21,  1.670387559674186e-23,  7.437741693742370e-26,  1.104961457103797e+00, -4.962840604280164e-03, -2.316343375334170e-06,  8.225380019839249e-08,
  7.330039888678937e-11, -2.468120863868402e-12, -2.746445456516630e-15,  9.031386065053804e-17,  1.129312258402878e-19, -3.668040083609298e-21, -4.940214578506027e-24,
  1.588699363240360e-25,  1.230210818610541e+00, -4.831130244082223e-03, -6.964849456289814e-06,  7.291691240663012e-08,  2.780250834215558e-10, -1.861933963135251e-12,
 -1.228047379102716e-14,  5.243137690822185e-17,  5.652964225063171e-19, -1.362153135808199e-21, -2.642991041105784e-23,  2.137972168922194e-26,  1.353723167113527e+00,
 -4.537542441290040e-03, -1.110045777854383e-05,  5.080985495459510e-08,  4.201728249132182e-10, -4.599359483872531e-13, -1.610803030122362e-14, -2.798805323105435e-17,
  5.729064738933449e-19,  2.858338433051456e-21, -1.675972082246113e-23, -1.793447367844050e-25,  1.473215963731382e+00, -4.090986931215005e-03, -1.416253734026370e-05,
  1.963120085248215e-08,  4.455927048255447e-10,  1.171720853386204e-12, -1.100777728038718e-14, -9.203044760322995e-17,  5.186493154255829e-20,  4.168752240785853e-21,
  1.627251768005942e-23, -1.171326987558088e-25,  1.586260892280968e+00, -3.514101708148231e-03, -1.568868139565072e-05, -1.392794428082896e-08,  3.381429580396263e-10,
  2.243186430062455e-12,  3.319913368319202e-16, -8.464174160730794e-17, -5.020731868612509e-19,  6.762562117566465e-22,  2.627713614468774e-23,  1.270884924450913e-25,
  1.690341653814526e+00, -2.843887390732262e-03, -1.543024888593732e-05, -4.169131404894008e-08,  1.359675682636766e-10,  2.196439868366978e-12,  1.017745744634783e-14,
 -1.248362673650926e-17, -5.002439136772216e-19, -3.105503631282280e-21, -9.678744452158482e-25,  1.326940956774807e-25,  1.782935378540155e+00, -2.130597310806045e-03,
 -1.345134973611554e-05, -5.655751295694404e-08, -7.744621669888950e-11,  1.124614437166471e-12,  1.163018107442541e-14,  5.371748001564337e-17, -7.108032546057619e-21,
 -2.270005744345067e-21, -1.932700615749235e-23, -6.954809638701615e-26,  1.861617020915473e+00, -1.434406294386960e-03, -1.017418324530911e-05, -5.534201869885153e-08,
 -2.114380573715481e-10, -2.165814435164588e-13,  4.986798536023733e-15,  5.368885319022624e-17,  3.183305144824198e-19,  9.396088776568130e-22, -3.839906250516858e-24,
 -7.721067320364360e-26,  1.924181930841154e+00, -8.197336456689109e-04, -6.336621184189356e-06, -4.060550238585346e-08, -2.193779285462188e-10, -9.441187918472474e-13,
 -2.423494967794108e-15,  7.231978363596798e-18,  1.591614666761902e-19,  1.384121645878337e-21,  8.483897769741291e-24,  3.594047523683769e-26,  1.968777220145268e+00,
 -3.476668568283034e-04, -2.848750026633877e-06, -2.021396448960105e-08, -1.298531197361968e-10, -7.638297035923689e-13, -4.084669517261877e-15, -1.926143203573074e-17,
 -7.313765702290835e-20, -1.428899957277751e-22,  9.760202666811728e-25,  1.589576630892708e-26,  1.994034121347033e+00, -6.753356475655156e-05, -5.713506187546948e-07,
 -4.276628848027473e-09, -2.983426199031671e-11, -1.983729470122968e-13, -1.271384758568023e-15, -7.900758339640826e-18, -4.774518374304837e-20, -2.808402134989095e-22,
 -1.606706125290335e-24, -8.918087285611717e-27,  1.466787790259586e-03, -1.263806575211982e-05,  8.161503744661815e-08, -4.681358281119149e-10,  2.514626212775609e-12,
 -1.295159760972639e-14,  6.475449163936050e-17, -3.166286942856881e-19,  1.520924430441427e-21, -7.200521001376947e-24,  3.366097738535865e-26, -1.556562201353773e-28,
  1.318857163621635e-02, -1.131396791205984e-04,  7.238973641605775e-07, -4.086308841531437e-09,  2.141458656218883e-11, -1.064375567350139e-13,  5.066107589368518e-16,
 -2.318629835921556e-18,  1.020305246218868e-20, -4.303247261934058e-23,  1.725014139085505e-25, -6.471850060145148e-28,  3.656497274237271e-02, -3.109271842640602e-04,
  1.952208485527492e-06, -1.066060435066700e-08,  5.299135474509389e-11, -2.430466792580513e-13,  1.025291344893650e-15, -3.898519745809601e-18,  1.261681540209089e-20,
 -2.840520243181655e-23, -1.742895579240797e-26,  7.463900276033936e-28,  7.145972367916684e-02, -5.995693449632524e-04,  3.656388131571074e-06, -1.893781540805971e-08,
  8.605568229517349e-11, -3.387681759160128e-13,  1.074091612196705e-15, -1.951751036120496e-18, -6.339018789470265e-21,  9.508858425521574e-23, -6.615756306103519e-25,
  3.463848131860199e-27,  1.176635536127013e-01, -9.694249845040712e-04,  5.677205037971336e-06, -2.721402472652588e-08,  1.068341541412290e-10, -3.057968642441626e-13,
  2.269644894587663e-16,  4.727855205104639e-18, -4.308526563695083e-20,  2.409484622130505e-22, -9.508284491702780e-25,  1.957688296370738e-27,  1.748882533758816e-01,
 -1.407664690934851e-03,  7.813953800269679e-06, -3.354106150516102e-08,  1.021995905000239e-10, -8.857427836056298e-14, -1.516334344064522e-15,  1.352976827811630e-17,
 -6.824705650817237e-20,  1.968554401025208e-22,  2.062297859494323e-25, -6.960479766281257e-27,  2.427586230516362e-01, -1.898325891325388e-03,  9.835186030984347e-06,
 -3.599148109671758e-08,  6.330984375080061e-11,  3.037577721235797e-13, -3.563579785376037e-15,  1.824669970210635e-17, -4.226123867543056e-20, -1.762061727189034e-22,
  2.523287179982918e-24, -1.438960928740665e-26,  3.208022117421845e-01, -2.422426250728501e-03,  1.149299451147474e-05, -3.296797412714730e-08, -1.096507021276034e-11,
  7.799017940893681e-13, -4.826358252395387e-15,  1.211383391853114e-17,  4.977934258114823e-20, -6.981348098163710e-22,  3.481251643898058e-24, -3.674884228468171e-27,
  4.084367798320135e-01, -2.958169556471377e-03,  1.254121719128700e-05, -2.353303293272333e-08, -1.116217304719687e-10,  1.174800689077657e-12, -4.131591662657065e-15,
 -7.168995149660782e-18,  1.660256478187724e-19, -8.436861048401649e-22,  2.242317021543520e-25,  2.599283133988010e-26,  5.049554749968390e-01, -3.481288901876440e-03,
  1.275771633412083e-05, -7.720745115356496e-09, -2.190186951162857e-10,  1.290680428645548e-12, -8.699834025739937e-16, -3.305205042152913e-17,  2.110713247058743e-19,
 -1.291480941972851e-22, -6.331019379808516e-24,  4.144096856911363e-26,  6.095098348707084e-01, -3.965583499255505e-03,  1.197043099071555e-05,  1.322463268437714e-08,
 -3.051661914759787e-10,  9.687393229906698e-13,  4.364491510027666e-15, -5.009464232876712e-17,  9.516474066890753e-20,  1.249101000772824e-21, -9.513887914672442e-24,
  2.011199497494378e-27,  7.210909392083618e-01, -4.383716268182682e-03,  1.008609349015856e-05,  3.675646341215849e-08, -3.393712889758189e-10,  1.756949907657142e-13,
  9.531274446454450e-15, -4.103946329355273e-17, -1.710040721249279e-19,  2.137018697101828e-21, -2.098288899132147e-24, -7.329799150851174e-26,  8.385093674551474e-01,
 -4.708346301172422e-03,  7.119240405269908e-06,  5.916522509044276e-08, -2.970474298888960e-10, -9.270825131430763e-13,  1.168627044041920e-14,  1.827217096852481e-19,
 -4.205387271317146e-19,  1.176532620062668e-21,  1.298768970942358e-23, -8.490041629984277e-26,  9.603751137281825e-01, -4.913667858527248e-03,  3.217388706771161e-06,
  7.603054330649830e-08, -1.702139838482203e-10, -1.976496990142425e-12,  8.433378818118785e-15,  5.693926222076937e-17, -4.061546145566174e-19, -1.570343654810092e-21,
  1.908266900899915e-23,  3.331874774677398e-26,  1.085079307658649e+00, -4.977407001683447e-03, -1.323899131918094e-06,  8.302899143902354e-08,  2.348525536156174e-11,
 -2.503404774301984e-12, -1.871076228468122e-16,  9.179053805682352e-17, -2.097153549208286e-20, -3.724016487701079e-21,  2.153812982017039e-24,  1.605742171712858e-25,
  1.210780504630710e+00, -4.883276336668884e-03, -6.064435397573848e-06,  7.705192584067454e-08,  2.379683504310484e-10, -2.137056820245132e-12, -1.056795330998681e-14,
  6.953511082877841e-17,  4.976154130625390e-19, -2.383045901170310e-21, -2.418402325620718e-23,  8.038322959500724e-26,  1.335399411824207e+00, -4.623793780209435e-03,
 -1.045077516168639e-05,  5.743779752392733e-08,  4.070557936517053e-10, -8.537709551734899e-13, -1.662057492256677e-14, -8.153190961854956e-18,  6.618812699973470e-19,
  2.035222785482164e-21, -2.422768013431583e-23, -1.562179059784106e-25,  1.456627080713315e+00, -4.203222047652395e-03, -1.388346157327151e-05,  2.693293438679440e-08,
  4.661781034811859e-10,  8.769424027728380e-13, -1.353800115840008e-14, -8.785511828111729e-17,  2.122480728691979e-19,  4.698368271027917e-21,  9.762838020626003e-24,
 -1.781384535760698e-25,  1.571952542363030e+00, -3.640184317430267e-03, -1.582187537722688e-05, -8.159152297551199e-09,  3.828851370684385e-10,  2.220929110682900e-12,
 -2.257738873484087e-15, -1.001052191850959e-16, -4.575321539561008e-19,  1.831008817118217e-21,  3.121574112639987e-23,  9.343144131869930e-26,  1.678716108450498e+00,
 -2.969290157630324e-03, -1.591599953403225e-05, -3.915128388448455e-08,  1.823008556198983e-10,  2.434592197092415e-12,  9.587016889076737e-15, -3.027536223112453e-17,
 -6.111959833073489e-19, -3.012498712177077e-21,  5.991104344356014e-24,  1.837963009259435e-25,  1.774193441971755e+00, -2.240942124209507e-03, -1.413668196302095e-05,
 -5.760103845060831e-08, -5.204132640461412e-11,  1.421681166101092e-12,  1.311770366144711e-14,  5.202756806842749e-17, -1.034405883150779e-19, -3.099613727352617e-21,
 -2.200947177729621e-23, -4.970181699175957e-26,  1.855712321242751e+00, -1.518513972731204e-03, -1.085870595546117e-05, -5.875264564677568e-08, -2.144450111002700e-10,
 -7.767771977533295e-14,  6.637531231176801e-15,  6.437982540643601e-17,  3.484918125118479e-19,  7.090626795062154e-22, -7.921917183545548e-24, -1.093996003774369e-25,
  1.920798438142817e+00, -8.724368052599362e-04, -6.845580634826847e-06, -4.426968867064771e-08, -2.388223624854451e-10, -9.992287382596057e-13, -2.141719348924320e-15,
  1.319101806898077e-17,  2.154836510561399e-19,  1.755531776675927e-21,  1.009131489046062e-23,  3.655136192808273e-26,  1.967339385017190e+00, -3.714636439418128e-04,
 -3.104305393861460e-06, -2.241934175182438e-08, -1.461551052893631e-10, -8.686025264347660e-13, -4.657466336831769e-15, -2.167511064561115e-17, -7.739068145850086e-20,
 -8.765507866981740e-23,  1.845480567205271e-24,  2.411570692609241e-26,  1.993754508586379e+00, -7.231807549507340e-05, -6.256707638183250e-07, -4.787453042597251e-09,
 -3.412570577534582e-11, -2.317232877162558e-13, -1.515608827257506e-15, -9.603581859596041e-18, -5.911332959582281e-20, -3.536800012712272e-22, -2.054417728727958e-24,
 -1.154826032636508e-26,  1.417506729862059e-03, -1.200695114636835e-05,  7.623052908978015e-08, -4.298925428066377e-10,  2.270444664133718e-12, -1.149860793728596e-14,
  5.653307109135785e-17, -2.718595676693869e-19,  1.284378393531987e-21, -5.981566056274902e-24,  2.750857571742914e-26, -1.251740264805500e-28,  1.274729273326502e-02,
 -1.075389758641964e-04,  6.768492907551671e-07, -3.760066272645715e-09,  1.940234812657142e-11, -9.502244907366458e-14,  4.460363800851415e-16, -2.015641040200040e-18,
  8.771495749388235e-21, -3.667205401470013e-23,  1.462323687350402e-25, -5.492870893174794e-28,  3.535170900749010e-02, -2.958071726658340e-04,  1.829212223938466e-06,
 -9.850329468757327e-09,  4.836788100074352e-11, -2.197049153925240e-13,  9.216307849573834e-16, -3.511218248834035e-18,  1.158885789504024e-20, -2.852519781208666e-23,
  9.605400706229607e-27,  4.956167282633798e-28,  6.911854161328691e-02, -5.712043538263966e-04,  3.437176590464764e-06, -1.761374573831023e-08,  7.953356850929757e-11,
 -3.136656998744272e-13,  1.017082577531816e-15, -2.104649662792253e-18, -3.357219899977842e-21,  7.147900713141811e-23, -5.235386952521036e-25,  2.827315396542929e-27,
  1.138746611035931e-01, -9.252850211732157e-04,  5.360692069270531e-06, -2.555326749052324e-08,  1.007826390012810e-10, -2.989091967162020e-13,  3.412949197660058e-16,
  3.480746755148985e-18, -3.507412098234507e-20,  2.047264264930648e-22, -8.585344093221250e-25,  2.197979199902312e-27,  1.693801078039883e-01, -1.346735380053882e-03,
  7.421207700307990e-06, -3.192189279386260e-08,  1.000936227528056e-10, -1.206604907701130e-13, -1.167002045032362e-15,  1.146028588992132e-17, -6.107929562010676e-20,
  1.996623105941508e-22, -4.996337913036226e-26, -4.773143291815730e-27,  2.353199719929850e-01, -1.821354341520484e-03,  9.409551898256633e-06, -3.493439837043634e-08,
  6.857031134849124e-11,  2.242047367997007e-13, -3.072426986642131e-15,  1.681111950615532e-17, -4.693546370190520e-20, -8.738307657131499e-23,  1.931986858763276e-24,
 -1.245512555993939e-26,  3.112938863869623e-01, -2.332066594747388e-03,  1.109682084612613e-05, -3.302480626055657e-08,  3.502949064799979e-12,  6.682971753874789e-13,
 -4.468458606305694e-15,  1.333114179485516e-17,  2.710436281121400e-20, -5.631557870934626e-22,  3.245002743930184e-24, -6.797208691502809e-27,  3.968029320177870e-01,
 -2.858998015234551e-03,  1.224886286531931e-05, -2.513645791180198e-08, -8.913057397875083e-11,  1.073806105674964e-12, -4.262485505393033e-15, -2.338319323283078e-18,
  1.360673112183398e-19, -8.143235662951357e-22,  1.184332366979932e-24,  1.782137401301714e-26,  4.912337745462720e-01, -3.379655387096973e-03,  1.264488894543055e-05,
 -1.101997082253078e-08, -1.934849244202606e-10,  1.259452616387888e-12, -1.701907744510951e-15, -2.641749426679655e-17,  2.022985809152498e-19, -3.464592021317688e-22,
 -4.553072579978685e-24,  3.891526596870388e-26,  5.938399176428809e-01, -3.869266767046027e-03,  1.210048714506280e-05,  8.502193005816187e-09, -2.848555964802535e-10,
  1.057038368746042e-12,  3.010714189610587e-15, -4.640288593343051e-17,  1.333453983207051e-19,  8.748281232590285e-22, -9.096538651342045e-24,  1.617992427956888e-26,
  7.037201152555134e-01, -4.301355173184618e-03,  1.049474653383386e-05,  3.136666185190096e-08, -3.336658574619974e-10,  3.901083235949284e-13,  8.316974784451155e-15,
 -4.530284804007278e-17, -9.630901817447565e-20,  1.994154826253907e-21, -4.902997782514816e-24, -5.385814551420629e-26,  8.197942708545588e-01, -4.648634554286822e-03,
  7.800143981488870e-06,  5.427934682265183e-08, -3.127916413254977e-10, -6.480287600726006e-13,  1.151002418514449e-14, -1.250408209320966e-17, -3.697630481474261e-19,
  1.618147337537134e-21,  9.033626711816941e-24, -9.307282501407794e-26,  9.407776296047555e-01, -4.884328511244116e-03,  4.112147234720686e-06,  7.300239219468070e-08,
 -2.075985669978317e-10, -1.756479873020874e-12,  9.838285494978077e-15,  4.318724701056946e-17, -4.487058763143772e-19, -7.899593651741450e-22,  1.963762481911446e-23,
 -7.643729478148929e-27,  1.065154811473948e+00, -4.984010217593334e-03, -3.269473067029165e-07,  8.300483767627453e-08, -2.642047933871411e-11, -2.477252511773617e-12,
  2.353675529011717e-15,  8.900467753739146e-17, -1.518122480358443e-19, -3.500053688164297e-21,  8.927013746091729e-24,  1.445102424058568e-25,  1.191156311252600e+00,
 -4.928031934461608e-03, -5.118420538047644e-06,  8.050440301310732e-08,  1.928575502142725e-10, -2.365610280110832e-12, -8.412221697436435e-15,  8.390737449199371e-17,
  3.954151511395097e-19, -3.263375973578635e-21, -1.944617614986677e-23,  1.332976773601230e-25,  1.316741543994228e+00, -4.704533686794929e-03, -9.723078036017687e-06,
  6.379237987959390e-08,  3.859855762605261e-10, -1.252950170686521e-12, -1.654273486545659e-14,  1.399950206938424e-17,  7.161551572861668e-19,  9.406417411450626e-22,
 -3.016420186379284e-23, -1.099813343667106e-25,  1.439594284660865e+00, -4.312868944774622e-03, -1.351499391285889e-05,  3.451362072553968e-08,  4.802732140818025e-10,
  5.234371272813319e-13, -1.587698612778812e-14, -7.829787714439329e-17,  3.863792063314098e-19,  4.915779212254639e-21,  7.269169347955580e-25, -2.302486439003676e-25,
  1.557138186440330e+00, -3.767043463165687e-03, -1.588157462882924e-05, -1.681567439066214e-09,  4.265265633852651e-10,  2.131523293297660e-12, -5.253989622440852e-15,
 -1.134434478685797e-16, -3.682868953057864e-19,  3.146434145693459e-21,  3.412780411769994e-23,  3.471172342037770e-26,  1.666581391312679e+00, -3.098444049491791e-03,
 -1.636666761809992e-05, -3.583276322029902e-08,  2.332130791627875e-10,  2.652199849981531e-12,  8.449613038762225e-15, -5.150587667162230e-17, -7.132489227877579e-19,
 -2.596430700210160e-21,  1.516404891602590e-23,  2.319306850751896e-25,  1.764999091892718e+00, -2.356812310484603e-03, -1.483189533887527e-05, -5.818863800876392e-08,
 -2.034384874211106e-11,  1.753503999549190e-12,  1.451012561973589e-14,  4.675846255603005e-17, -2.313134119065749e-19, -4.013867444377448e-21, -2.342123156613908e-23,
 -1.090372902682433e-26,  1.849459978427576e+00, -1.608262135110020e-03, -1.158434592481436e-05, -6.218690307272881e-08, -2.142529406012131e-10,  1.045359523612695e-13,
  8.599634428770558e-15,  7.586877044675258e-17,  3.670563229352551e-19,  2.850871698942662e-22, -1.355418283233494e-23, -1.474375236838955e-25,  1.917195703403014e+00,
 -9.293928913665854e-04, -7.400412004703311e-06, -4.825337549775585e-08, -2.592867475102047e-10, -1.045357373150794e-12, -1.665759764575735e-15,  2.117869300225332e-17,
  2.863297499766647e-19,  2.190568084386224e-21,  1.163055662384431e-23,  3.238679815876210e-26,  1.965802099769930e+00, -3.974153304643399e-04, -3.387961911799953e-06,
 -2.490308459047935e-08, -1.646955635095820e-10, -9.879467520524067e-13, -5.299400357038768e-15, -2.418559541525254e-17, -7.893352051291692e-20,  1.054641367877268e-23,
  3.149951684982863e-24,  3.585588651979978e-26,  1.993454848120354e+00, -7.756288707333504e-05, -6.865558667919286e-07, -5.372611843160651e-09, -3.914685535315239e-11,
 -2.715508143439641e-13, -1.813025109386961e-15, -1.171583745468558e-17, -7.345594422822827e-20, -4.469646999452461e-22, -2.634821475823196e-24, -1.498523883636796e-26,
  1.370666791304358e-03, -1.141714120621051e-05,  7.128242410242934e-08, -3.953339933479857e-10,  2.053447049897075e-12, -1.022870637000453e-14,  4.946548641962818e-17,
 -2.340027897624267e-19,  1.087590051724072e-21, -4.983857190555031e-24,  2.255269851638076e-26, -1.010107340968480e-28,  1.232768791814692e-02, -1.022995280288568e-04,
  6.335302390543705e-07, -3.464269296532121e-09,  1.760453529097741e-11, -8.496429425206188e-14,  3.933373743905038e-16, -1.754993084055370e-18,  7.550999938151243e-21,
 -3.128046093751977e-23,  1.239586190691106e-25, -4.653258030570848e-28,  3.419701722998470e-02, -2.816334609315441e-04,  1.715510385068372e-06, -9.110427037655418e-09,
  4.418722319723249e-11, -1.987245857960516e-13,  8.283548621528933e-16, -3.156692046205569e-18,  1.057358823804724e-20, -2.776259741441780e-23,  2.720545839238918e-26,
  3.142161200250214e-28,  6.688741030178898e-02, -5.445312360228828e-04,  3.233244085768589e-06, -1.639008910405449e-08,  7.349952782755279e-11, -2.899727809919500e-13,
  9.570077411596742e-16, -2.174717208660561e-18, -1.132460250331781e-21,  5.286017630779456e-23, -4.113231074873521e-25,  2.288917332173618e-27,  1.102573881490309e-01,
 -8.835990798757741e-04,  5.063532239522290e-06, -2.398809474955052e-08,  9.489363276672255e-11, -2.896688379787201e-13,  4.241044527111193e-16,  2.469860286690066e-18,
 -2.829856265585602e-20,  1.723437394160785e-22, -7.602875002575363e-25,  2.242003812374796e-27,  1.641095177254602e-01, -1.288870936605106e-03,  7.047669697950019e-06,
 -3.034111706581646e-08,  9.742521102742211e-11, -1.450321283155131e-13, -8.724019612151845e-16,  9.619989823245659e-18, -5.397314897068654e-20,  1.939939393136937e-22,
 -2.211673817298872e-25, -3.084765473107375e-27,  2.281824791914699e-01, -1.747735810787882e-03,  8.997057294764855e-06, -3.380525011953480e-08,  7.235426362057663e-11,
  1.559429072858977e-13, -2.623115342482635e-15,  1.527273062631013e-17, -4.881687897981145e-20, -2.046874677033902e-23,  1.428469154538405e-24, -1.043402459043977e-26,
  3.021406618937234e-01, -2.244875287285378e-03,  1.070128200598465e-05, -3.286752995293963e-08,  1.582712778329590e-11,  5.656135895017340e-13, -4.085916648826745e-15,
  1.389853297255095e-17,  9.089540677498341e-21, -4.399271095698811e-22,  2.904123190964737e-24, -8.492899982335049e-27,  3.855609792720770e-01, -2.762236309810143e-03,
  1.193935950230151e-05, -2.639631015186569e-08, -6.868032250973618e-11,  9.711860724336881e-13, -4.271333983566651e-15,  1.557330820500055e-18,  1.077736510045809e-19,
 -7.534136232121010e-22,  1.810414409677065e-24,  1.085584358514089e-26,  4.779165619093383e-01, -3.279075963278732e-03,  1.249489813684828e-05, -1.391667497542182e-08,
 -1.687605174905418e-10,  1.210449364405783e-12, -2.353074417378066e-15, -2.017537417791611e-17,  1.869491612808322e-19, -4.956069928834232e-22, -2.938881592242691e-24,
  3.418638014896968e-26,  5.785569972989417e-01, -3.772130615295129e-03,  1.217587650106583e-05,  4.117122840203363e-09, -2.630948930212348e-10,  1.114212944252337e-12,
  1.775415042182103e-15, -4.170057166202558e-17,  1.584902896795722e-19,  5.283254716500239e-22, -8.159723109730575e-24,  2.564193493743708e-26,  6.866848671138259e-01,
 -4.215981696995955e-03,  1.083940596446045e-05,  2.610083408616835e-08, -3.239718875162517e-10,  5.742105801901716e-13,  7.015846012093471e-15, -4.727823272991245e-17,
 -2.856639322149672e-20,  1.756603704295924e-21, -6.827481237720530e-24, -3.369941390817316e-26,  8.013285388828350e-01, -4.583713961290882e-03,  8.421088683540730e-06,
  4.918586264943787e-08, -3.230248432613088e-10, -3.772704938368568e-13,  1.100346414750534e-14, -2.334273882550484e-17, -3.059949410074240e-19,  1.897451715351233e-21,
  4.945014489513223e-24, -9.126202471478727e-26,  9.213115749668467e-01, -4.847986269929046e-03,  4.967129811315115e-06,  6.941298913537862e-08, -2.402775045353493e-10,
 -1.507493512445184e-12,  1.084330664502381e-14,  2.852391414947470e-17, -4.631882061081267e-19, -2.227234078386311e-23,  1.848437483071868e-23, -4.360615960620950e-26,
  1.045219832734647e+00, -4.982652491530852e-03,  6.649516228775245e-07,  8.218965478164535e-08, -7.520210601866122e-11, -2.391521342978717e-12,  4.759413403146995e-15,
  8.221153567110656e-17, -2.699274197815993e-19, -3.024025003766770e-21,  1.464672540354007e-23,  1.133256046629984e-25,  1.171368476352569e+00, -4.965066293098380e-03,
 -4.135447971691179e-06,  8.320147971641346e-08,  1.437236236140494e-10, -2.537994523328322e-12, -5.904330597547918e-15,  9.454308782971616e-17,  2.654640127934259e-19,
 -3.911173428507455e-21, -1.265802439698323e-23,  1.724265536331906e-25,  1.297772833751381e+00, -4.779153332554382e-03, -8.921411208749334e-06,  6.974628552888267e-08,
  3.570015526147259e-10, -1.642659608756809e-12, -1.582653042130160e-14,  3.721700516785685e-17,  7.272967708370105e-19, -3.445611240684098e-22, -3.361598212139628e-23,
 -4.420419774591694e-26,  1.422129377314397e+00, -4.419200950445137e-03, -1.305444780309361e-05,  4.226032033391168e-08,  4.867618140283767e-10,  1.176417357431542e-13,
 -1.786970291220276e-14, -6.311717034282954e-17,  5.613226122987930e-19,  4.730871133488145e-21, -1.021085254390432e-23, -2.628403593896522e-25,  1.541815947589535e+00,
 -3.894057570258707e-03, -1.585942528094658e-05,  5.475947591947979e-09,  4.676323780675493e-10,  1.966092950624240e-12, -8.576481003832098e-15, -1.231511621270482e-16,
 -2.302800439733406e-19,  4.519258478741546e-21,  3.390666616844275e-23, -4.850451406229536e-26,  1.653923120098626e+00, -3.231029828811278e-03, -1.677248763187216e-05,
 -3.166652148034353e-08,  2.881544891405516e-10,  2.835023805744107e-12,  6.674814912557538e-15, -7.568763655688666e-17, -7.932343940166340e-19, -1.774090754817688e-21,
  2.620999545988229e-23,  2.670173888680624e-25,  1.755330105848320e+00, -2.478263270948284e-03, -1.553089222485369e-05, -5.821422942610759e-08,  1.830979665665197e-11,
  2.116481440950885e-12,  1.569272123064664e-14,  3.686365268358367e-17, -3.926438135405158e-19, -4.943726707064850e-21, -2.261517451621900e-23,  5.183518991211038e-26,
  1.842836772180329e+00, -1.703979915221970e-03, -1.235104969423197e-05, -6.558626421462419e-08, -2.099193538048414e-10,  3.377517758213793e-13,  1.088912107884193e-14,
  8.766073635104354e-17,  3.658874105481369e-19, -3.988924219093601e-22, -2.094651934206099e-23, -1.887796041061359e-25,  1.913355956311465e+00, -9.909844773989644e-04,
 -8.005040412630016e-06, -5.257117157450380e-08, -2.805399719936057e-10, -1.077108054921581e-12, -9.319697574710998e-16,  3.169542748161495e-17,  3.738825191702666e-19,
  2.681398152380618e-21,  1.282172681929345e-23,  2.006019923751119e-26,  1.964156273142139e+00, -4.257607187518607e-04, -3.703284771955183e-06, -2.770343087332876e-08,
 -1.857826777613931e-10, -1.123542842908319e-12, -6.011709651983614e-15, -2.667772944355855e-17, -7.586562316312601e-20,  1.725708305332743e-22,  5.071693216211903e-24,
  5.241643707009849e-26,  1.993133187763064e+00, -8.332429601181535e-05, -7.549725054658877e-07, -6.044890355179840e-09, -4.504100777731108e-11, -3.192811833702610e-13,
 -2.176548637991168e-15, -1.434558220676431e-17, -9.161375034168295e-20, -5.667800612828360e-22, -3.388613574744787e-24, -1.947537890471118e-26,  1.326109468421744e-03,
 -1.086531444681602e-05,  6.672899917398550e-08, -3.640530895905126e-10,  1.860233564288328e-12, -9.116386674445766e-15,  4.337486876116082e-17, -2.019048323476847e-19,
  9.233930189748725e-22, -4.164662180239202e-24,  1.854693067655220e-26, -8.178865572726164e-29,  1.192836959936181e-02, -9.739290850342739e-05,  5.935945834100306e-07,
 -3.195694336314183e-09,  1.599580687061786e-11, -7.608757779378571e-14,  3.474177234337115e-16, -1.530460390448868e-18,  6.509420320261734e-21, -2.670968563679729e-23,
  1.051014420755827e-25, -3.937271072714640e-28,  3.309725573827596e-02, -2.683349546140879e-04,  1.610299494306136e-06, -8.434176601067900e-09,  4.040457098039232e-11,
 -1.798673989009065e-13,  7.445558426346630e-16, -2.834093954921479e-18,  9.596671353601400e-21, -2.643930498312683e-23,  3.801552114095185e-26,  1.844420702130993e-28,
  6.475979926909867e-02, -5.194324484960272e-04,  3.043431574857494e-06, -1.525926512121760e-08,  6.792480770687363e-11, -2.677377456284655e-13,  8.958728567016432e-16,
 -2.183495296402004e-18,  4.973544170358963e-22,  3.828315178821813e-23, -3.207989700971483e-25,  1.839656809563495e-27,  1.068022211134775e-01, -8.442168760335751e-04,
  4.784595561227798e-06, -2.251556886367860e-08,  8.920713745385334e-11, -2.787572578999168e-13,  4.814747763526734e-16,  1.657898958507476e-18, -2.261795953365934e-20,
  1.438884960660793e-22, -6.630693585629693e-25,  2.161156527282454e-27,  1.590645278811741e-01, -1.233919680382387e-03,  6.692829949149884e-06, -2.880656828904661e-08,
  9.433602861838226e-11, -1.629262398559698e-13, -6.261859110378111e-16,  8.002641217516684e-18, -4.717761663827425e-20,  1.828336532787394e-22, -3.276214943025063e-25,
 -1.816874843108037e-27,  2.213329477354432e-01, -1.677362108556677e-03,  8.598432534535227e-06, -3.262590936330247e-08,  7.487729882418585e-11,  9.794294653047672e-14,
 -2.217386029783506e-15,  1.370896523602107e-17, -4.863059217969694e-20,  2.806907072972114e-23,  1.012561541833645e-24, -8.494159670223104e-27,  2.933298904927061e-01,
 -2.160837541921040e-03,  1.030874745943246e-05, -3.252899304371853e-08,  2.619041207737152e-11,  4.722405142012092e-13, -3.694910969762370e-15,  1.395767277423236e-17,
 -4.749337498598445e-21, -3.314874821687553e-22,  2.513295968205434e-24, -9.124392323354016e-27,  3.747010331928535e-01, -2.668005697609672e-03,  1.161663346690853e-05,
 -2.734535383871285e-08, -5.027627957711399e-11,  8.695624887942232e-13, -4.183419069105912e-15,  4.586925553154301e-18,  8.205328144757213e-20, -6.731916432830843e-22,
  2.159934737687354e-24,  5.260548627669490e-27,  4.649990563545999e-01, -3.179828862400665e-03,  1.231248548865843e-05, -1.642641989193048e-08, -1.451586047879659e-10,
  1.147855434834961e-12, -2.837059096516605e-15, -1.449831590016099e-17,  1.673386480579094e-19, -5.847569933598628e-22, -1.561548036424371e-24,  2.830539840739081e-26,
  5.636635029841527e-01, -3.674595836484526e-03,  1.220076668586756e-05,  8.780728886391894e-11, -2.404760829995672e-10,  1.143399992932277e-12,  6.812262193078136e-16,
 -3.638523960860367e-17,  1.719238347090941e-19,  2.263011613627758e-22, -6.904336838029271e-24,  3.075507154929375e-26,  6.699962313023198e-01, -4.128100799598774e-03,
  1.112192205352905e-05,  2.101785502403283e-08, -3.109113928708368e-10,  7.266585839590001e-13,  5.688373593364168e-15, -4.723581982132788e-17,  2.945009673244518e-20,
  1.459518419459594e-21, -7.890427299037584e-24, -1.500136798016801e-26,  7.831320339005704e-01, -4.514072674583828e-03,  8.980105477163162e-06,  4.397120908599960e-08,
 -3.279878093200591e-10, -1.220727026600099e-13,  1.022327805818017e-14, -3.201119040479422e-17, -2.350731359155015e-19,  2.017336412303213e-21,  1.121144620944632e-24,
 -8.142861690265939e-26,  9.020042841809252e-01, -4.804984961741018e-03,  5.776070566417262e-06,  6.534173122697519e-08, -2.677689299054461e-10, -1.239340748359804e-12,
  1.143534037007261e-14,  1.382747139153868e-17, -4.512246729321467e-19,  6.699677253609123e-22,  1.592831393484570e-23, -7.094079575773271e-26,  1.025306074793476e+00,
 -4.973411821071867e-03,  1.642451871241137e-06,  8.061074779225497e-08, -1.217092736970572e-10, -2.250744722488332e-12,  6.924902184071370e-15,  7.195415955500155e-17,
 -3.671500950995405e-19, -2.350093806401288e-21,  1.874674376319115e-23,  7.180837635840081e-26,  1.151448417371331e+00, -4.994121016260325e-03, -3.124930266376342e-06,
  8.508819494614042e-08,  9.176551491913970e-11, -2.647105280961790e-12, -3.159971943288775e-15,  1.007026874147914e-16,  1.174457455483096e-19, -4.258441548118823e-21,
 -4.562531707266228e-24,  1.919956305722602e-25,  1.278518912189702e+00, -4.847082325071248e-03, -8.051333558474078e-06,  7.517524842009495e-08,  3.204479103679482e-10,
 -2.007382329615965e-12, -1.446235585071520e-14,  6.003004018747529e-17,  6.904227187583184e-19, -1.705745947089555e-21, -3.387532780514822e-23,  3.360287562929716e-26,
  1.404247101090244e+00, -4.521475613685075e-03, -1.250059421258170e-05,  5.004346756863836e-08,  4.846939160066205e-10, -3.302547764547659e-13, -1.936060197637401e-14,
 -4.253156132226236e-17,  7.214600073086553e-19,  4.087749071431023e-21, -2.197053255883916e-23, -2.662056427076588e-25,  1.525986566088216e+00, -4.020540021088185e-03,
 -1.574756304234373e-05,  1.326027141779510e-08,  5.046129429090833e-10,  1.718205475779790e-12, -1.210158711252444e-14, -1.276611572147481e-16, -4.395001160333762e-20,
  5.803872199742158e-21,  2.957999438135054e-23, -1.504721797725197e-25,  1.640728350724969e+00, -3.366646982880337e-03, -1.712292584305988e-05, -2.659451471767025e-08,
  3.462702150862025e-10,  2.966868778752693e-12,  4.192168154741635e-15, -1.018673459184030e-16, -8.353488982796410e-19, -4.856425139939600e-22,  3.828161944870099e-23,
  2.762949190676111e-25,  1.745164145649348e+00, -2.605296359863279e-03, -1.622624118099416e-05, -5.756184910869015e-08,  6.448122746947142e-11,  2.503902584085038e-12,
  1.652103167429721e-14,  2.128275986049229e-17, -5.861323384182040e-19, -5.778286552447505e-21, -1.845858248687420e-23,  1.416513080245840e-25,  1.835818171357451e+00,
 -1.805992941647930e-03, -1.315796587391288e-05, -6.887587607406792e-08, -2.003453556720584e-10,  6.298482721782448e-13,  1.350412989779874e-14,  9.896069541396010e-17,
  3.343345150514929e-19, -1.414836026384090e-21, -3.013732888562668e-23, -2.279895724566146e-25,  1.909259832452356e+00, -1.057626167306935e-03, -8.663540251213916e-06,
 -5.723303646266534e-08, -3.022265419848023e-10, -1.087380937029400e-12,  1.382272851817824e-16,  4.530450628112923e-17,  4.798016329141690e-19,  3.205604918375202e-21,
  1.320478937589118e-23, -5.283236148594068e-27,  1.962391798592188e+00, -4.567690544947399e-04, -4.054328716870443e-06, -3.086381866107341e-08, -2.097582379665724e-10,
 -1.277054663178959e-12, -6.791432871484473e-15, -2.896199988654586e-17, -6.538966302997101e-20,  4.278120241301697e-22,  7.857928974181580e-24,  7.545489424580098e-26,
  1.992787333647591e+00, -8.966698639692974e-05, -8.320554338479797e-07, -6.819612469317816e-09, -5.198333452540843e-11, -3.766895735100519e-13, -2.622531992457170e-15,
 -1.763161821361375e-17, -1.146786425851157e-19, -7.210754509467054e-22, -4.368768649412818e-24, -2.533230335429208e-26,  1.283688903098449e-03, -1.034846451693572e-05,
  6.253310581020077e-08, -3.356932773879266e-10,  1.687874565741642e-12, -8.140024441801592e-15,  3.811365586296012e-17, -1.746186676191402e-19,  7.859955446530254e-22,
 -3.489992228531282e-24,  1.529822095366166e-26, -6.644560524830021e-29,  1.154805859944488e-02, -9.279330708527113e-05,  5.567330597097817e-07, -2.951496563726045e-09,
  1.455408246502130e-11, -6.824110933889843e-14,  3.073420940747041e-16, -1.336765092512570e-18,  5.619540512744972e-21, -2.283348188506697e-23,  8.915133527913395e-26,
 -3.329364422492671e-28,  3.204905487699337e-02, -2.558466763152064e-04,  1.512852574186140e-06, -7.815537715797611e-09,  3.697966432942535e-11, -1.629164813080476e-13,
  6.693596065261537e-16, -2.541921962079135e-18,  8.673911757675284e-21, -2.478572218705492e-23,  4.399765867347650e-26,  9.284581101735554e-29,  6.272963023217792e-02,
 -4.957993645498431e-04,  2.866668195512279e-06, -1.421415875805284e-08,  6.278012450082191e-11, -2.469674643549529e-13,  8.351482175239739e-16, -2.147854055162354e-18,
  1.663028457836076e-21,  2.695562107027927e-23, -2.482774535656081e-25,  1.468785587720597e-27,  1.035002296572275e-01, -8.069970140672091e-04,  4.522790713731796e-06,
 -2.113221361127254e-08,  8.375090333150786e-11, -2.667219879027790e-13,  5.185063961090937e-16,  1.012068725875820e-18, -1.789283743668234e-20,  1.192259859984035e-22,
 -5.711867661084856e-25,  2.006479693489464e-27,  1.542337810319358e-01, -1.181734349254170e-03,  6.356097413045542e-06, -2.732400338302916e-08,  9.094451300485031e-11,
 -1.754304207152791e-13, -4.222768819876834e-16,  6.595602140867799e-18, -4.084803548314476e-20,  1.684245407203709e-22, -3.861061536647803e-25, -8.919955463332980e-28,
  2.147586235789287e-01, -1.610120194581828e-03,  8.214165467981872e-06, -3.141496582185442e-08,  7.633417315566511e-11,  4.915724157412141e-14, -1.855117942760628e-15,
  1.217607221020883e-17, -4.697625088108215e-20,  6.163002167433092e-23,  6.783127788050645e-25, -6.733783666128795e-27,  2.848490190457600e-01, -2.079921142959328e-03,
  9.921210255931169e-06, -3.203907369859855e-08,  3.477996664704670e-11,  3.882249029839700e-13, -3.307884070919545e-15,  1.363337298582445e-17, -1.497025171188237e-20,
 -2.389960840168717e-22,  2.112129440240952e-24, -9.011123836797712e-27,  3.642127806831489e-01, -2.576397595476152e-03,  1.128421907003643e-05, -2.801605076746422e-08,
 -3.387720664117620e-11,  7.709765555758054e-13, -4.021747498293338e-15,  6.841917371332968e-18,  5.941691817017471e-20, -5.835080443464412e-22,  2.293380360916942e-24,
  1.020690145090943e-27,  4.524754387932410e-01, -3.082155209723927e-03,  1.210217847327006e-05, -1.856912761448381e-08, -1.229122291533974e-10,  1.075479854876733e-12,
 -3.171281306435044e-15, -9.490027404239431e-18,  1.454466206608010e-19, -6.241356220652358e-22, -4.526231590068617e-25,  2.210340988958324e-26,  5.491602485323277e-01,
 -3.577049155676964e-03,  1.217949127150628e-05, -3.576312845853909e-09, -2.175238724418600e-10,  1.148151346710041e-12, -2.596783274436785e-16, -3.080393720346333e-17,
  1.754322135526624e-19, -2.213777816787004e-23, -5.506949719036208e-24,  3.223294829714497e-26,  6.536632583380078e-01, -4.038199983537978e-03,  1.134479121968464e-05,
  1.616650858175626e-08, -2.951193940037420e-10,  8.474611514444856e-13,  4.386422894550453e-15, -4.551464220610355e-17,  7.619749800983485e-20,  1.135586499531760e-21,
 -8.191323936556497e-24,  7.546019046588311e-28,  7.652226406169955e-01, -4.440210525925523e-03,  9.476234904032873e-06,  3.871688448066807e-08, -3.280523857258794e-10,
  1.117474313617322e-13,  9.232592098407062e-15, -3.836965305616663e-17, -1.624676486184162e-19,  1.994720748139235e-21, -2.140294016100678e-24, -6.614480862494896e-26,
  8.828816222503834e-01, -4.755714613642014e-03,  6.533696151576268e-06,  6.087414812257401e-08, -2.897882248910768e-10, -9.618516532755051e-13,  1.162482633280507e-14,
 -1.093137179683080e-19, -4.164432720090618e-19,  1.238944349599228e-21,  1.239850940674269e-23, -8.768892428211513e-26,  1.005444781987037e+00, -4.956439354294052e-03,
  2.596642325835980e-06,  7.831297049900936e-08, -1.649061733251937e-10, -2.061770948160727e-12,  8.763480396838235e-15,  5.900180883146194e-17, -4.376160606628567e-19,
 -1.550429978046665e-21,  2.090163982552547e-23,  2.593758715951644e-26,  1.131428431030112e+00, -5.015015310400862e-03, -2.096820240903958e-06,  8.612975024340864e-08,
  3.829500018737365e-11, -2.688826321987484e-12, -3.108826604028081e-16,  1.019894718363956e-16, -3.709670657055322e-20, -4.271148594618476e-21,  3.907327330808617e-24,
  1.892836933315784e-25,  1.259007593749896e+00, -4.907800590512595e-03, -7.119851871508852e-06,  7.996299048563552e-08,  2.769780746016227e-10, -2.331878199971980e-12,
 -1.248327762101700e-14,  8.088384991662963e-17,  6.051975051372071e-19, -3.007548527443251e-21, -3.063539582573020e-23,  1.129658872586911e-25,  1.385965177683437e+00,
 -4.618947112021288e-03, -1.185384272282939e-05,  5.772012694776187e-08,  4.733598501820986e-10, -8.064616794276520e-13, -2.020748898975341e-14, -1.728246565775711e-17,
  8.500344631946110e-19,  2.981463775464803e-21, -3.310878740932888e-23, -2.339304539231562e-25,  1.509653649853959e+00, -4.145744274567291e-03, -1.553891736635341e-05,
  2.159199526727152e-08,  5.357831625244637e-10,  1.384915181312754e-12, -1.566283490583658e-14, -1.255110375610299e-16,  1.843994100641412e-19,  6.822561134675039e-21,
  2.055840464021239e-23, -2.594932540989570e-25,  1.626985913748813e+00, -3.504808200711934e-03, -1.740684501874047e-05, -2.057504990451868e-08,  4.063670366910619e-10,
  3.030227760487232e-12,  9.652613471749723e-16, -1.285592011729419e-16, -8.223846831246853e-19,  1.283167567703428e-21,  4.993969175659395e-23,  2.460057129038425e-25,
  1.734478995606424e+00, -2.737847772434133e-03, -1.690907035557203e-05, -5.610781965891993e-08,  1.185608092905728e-10,  2.905241930107586e-12,  1.682215353365927e-14,
 -9.301736973343182e-19, -8.056470909301861e-19, -6.359591357975457e-21, -9.761321695830948e-24,  2.575968588987038e-25,  1.828378362049815e+00, -1.914616128087908e-03,
 -1.400323417460443e-05, -7.196205348790859e-08, -1.842769397562838e-10,  9.883512589603999e-13,  1.641537884170153e-14,  1.085915895153552e-16,  2.591965099068270e-19,
 -2.830340890092123e-21, -4.084031257587792e-23, -2.555463390482433e-25,  1.904886243198477e+00, -1.129765530061334e-03, -9.380066267689082e-06, -6.224199792188981e-08,
 -3.238288033307985e-10, -1.066995952698798e-12,  1.639774278336264e-15,  6.260541282006375e-17,  6.045525528382322e-19,  3.717601143642564e-21,  1.206860895544517e-23,
 -5.023317388894913e-26,  1.960497424283973e+00, -4.907442018117042e-04, -4.445703637895116e-06, -3.443341501046449e-08, -2.369961141054606e-10, -1.450000163544339e-12,
 -7.628875558822898e-15, -3.074039092899737e-17, -4.345357870340199e-20,  8.171185260893725e-22,  1.183675779435219e-23,  1.069824918993779e-25,  1.992414813778987e+00,
 -9.666550638422136e-05, -9.191413535762435e-07, -7.715211568202570e-09, -6.018877165444092e-11, -4.459944909209744e-13, -3.171749480159529e-15, -2.175270430232507e-17,
 -1.440703601766143e-19, -9.202172906236711e-22, -5.643725227055007e-24, -3.294645245587451e-26,  1.243270694262739e-03, -9.863865903875649e-06,  5.866160659355697e-08,
 -3.099416007218677e-10,  1.533839530160165e-12, -7.281238419466100e-15,  3.355838137481614e-17, -1.513644297972959e-19,  6.707010451895364e-22, -2.932721363505930e-24,
  1.265473043236583e-26, -5.415981867711424e-29,  1.118557424153744e-02, -8.847725691663434e-05,  5.226685180299331e-07, -2.729161417599093e-09,  1.326009247986257e-11,
 -6.129446751188205e-14,  2.723113964757362e-16, -1.169431330801877e-18,  4.858338416892727e-21, -1.954464090599218e-23,  7.566519021297106e-26, -2.815000146368737e-28,
  3.104929371275919e-02, -2.441091851435008e-04,  1.422511407084638e-06, -7.249080523854340e-09,  3.387637457402521e-11, -1.476753838200198e-13,  6.019400254025630e-16,
 -2.278286968626004e-18,  7.814099134220738e-21, -2.296456713466984e-23,  4.659798073351624e-26,  2.927730552539420e-29,  6.079124281047564e-02, -4.735315908284762e-04,
  2.701965655921533e-06, -1.324812285560705e-08,  5.803637409676058e-11, -2.276387414369201e-13,  7.758862633474912e-16, -2.080906705904055e-18,  2.469383247227718e-21,
  1.822319490058126e-23, -1.905534194254490e-25,  1.165244359250301e-27,  1.003430318355663e-01, -7.718066553463466e-04,  4.277070414406906e-06, -1.983419002355854e-08,
  7.854288236795103e-11, -2.539986673071810e-13,  5.394431264416470e-16,  5.039319692436075e-19, -1.399117663669210e-20,  9.808923902477684e-23, -4.870593729588624e-25,
  1.813426064915704e-27,  1.496064991362622e-01, -1.132172655135236e-03,  6.036822643244557e-06, -2.589745048790839e-08,  8.734877697703757e-11, -1.834911558141718e-13,
 -2.550100603975282e-16,  5.382432928723667e-18, -3.507026637398894e-20,  1.524049595906004e-22, -4.101270075270588e-25, -2.394100397098775e-28,  2.084472113024095e-01,
 -1.545893966736702e-03,  7.844538875931743e-06, -3.018806007840654e-08,  7.689883645707446e-11,  8.557928544965768e-15, -1.534865622008841e-15,  1.071301648538887e-17,
 -4.433629345810700e-20,  8.330531350463230e-23,  4.166172855836012e-25, -5.200967816388377e-27,  2.766856529674052e-01, -2.002079313580949e-03,  9.540322856355664e-06,
 -3.142466300903081e-08,  4.178118158151582e-11,  3.133549801190321e-13, -2.934037947173379e-15,  1.303220157602236e-17, -2.214763715554638e-20, -1.622928715031305e-22,
  1.727385900709867e-24, -8.416479970998101e-27,  3.540855970801882e-01, -2.487476689802555e-03,  1.094526629240175e-05, -2.843990542543833e-08, -1.940634713389612e-11,
  6.769495756685743e-13, -3.806586537154970e-15,  8.424891177366566e-18,  4.006370480940847e-20, -4.918444151531201e-22,  2.267885377907113e-24, -1.991375497710783e-27,
  4.403389964788384e-01, -2.986260924738340e-03,  1.186824556445097e-05, -2.036786300461523e-08, -1.021826332546083e-10,  9.966855482392303e-13, -3.375234231443113e-15,
 -5.196936762326273e-18,  1.228699677010386e-19, -6.245698334444839e-22,  3.876897583963342e-25,  1.617483249255371e-26,  5.350465707374246e-01, -3.479842313434409e-03,
  1.211644913476159e-05, -6.873611074363046e-09, -1.946897615981592e-10,  1.132201119034534e-12, -1.044001821829322e-15, -2.524260627568561e-17,  1.710104728432599e-19,
 -2.142583771799696e-22, -4.108513009376318e-24,  3.095212498214926e-26,  6.376930921347027e-01, -3.946744610670478e-03,  1.151103454246891e-05,  1.158548407669756e-08,
 -2.772190806309554e-10,  9.377534305443082e-13,  3.151845870692654e-15, -4.248516214866579e-17,  1.112241927177431e-19,  8.124231903236552e-22, -7.879159137227050e-24,
  1.279092836597670e-26,  7.476162351030756e-01, -4.362631220265987e-03,  9.909456218870519e-06,  3.349759019244760e-08, -3.236913945858159e-10,  3.199155816473737e-13,
  8.096102473826481e-15, -4.244156594345361e-17, -9.285302148286052e-20,  1.856099774267177e-21, -4.659057342701753e-24, -4.810164210886177e-26,  8.639678162871940e-01,
 -4.700603271358943e-03,  7.235780473787873e-06,  5.609877146041607e-08, -3.062431433160408e-10, -6.843539652689698e-13,  1.144254200379186e-14, -1.263386149347788e-17,
 -3.638683569896789e-19,  1.655216331347030e-21,  8.372188664679189e-24, -9.359902157408605e-26,  9.856664552738561e-01, -4.931955104559279e-03,  3.519244692194683e-06,
  7.535654857670306e-08, -2.039129167670384e-10, -1.833250994597738e-12,  1.021224753018588e-14,  4.426783825348269e-17, -4.782290222942525e-19, -7.048535461721626e-22,
  2.105495227683461e-23, -1.822138682381145e-26,  1.111341375845085e+00, -5.027649312921821e-03, -1.061360213308965e-06,  8.631281936454774e-08, -1.532611691881011e-11,
 -2.662293784130046e-12,  2.505395699361134e-15,  9.838834101739748e-17, -1.860864581215841e-19, -3.953940861667035e-21,  1.177662989536465e-23,  1.651276668773452e-25,
  1.239268652503299e+00, -4.960849490140156e-03, -6.135295663726402e-06,  8.400606899706620e-08,  2.275388239939207e-10, -2.602219728823059e-12, -9.965301608496341e-15,
  9.829234591755513e-17,  4.762638239626732e-19, -4.112044649118600e-21, -2.408362561609334e-23,  1.822378169243088e-25,  1.367304294419090e+00, -4.710879931438891e-03,
 -1.111637658882644e-05,  6.513839206364790e-08,  4.523578940651647e-10, -1.294085042186700e-12, -2.029638092456824e-14,  1.136123776578663e-17,  9.312049318132501e-19,
  1.468969771589576e-21, -4.201374473228035e-23, -1.650759816620577e-25,  1.492823899411256e+00, -4.268871498202716e-03, -1.522753358480681e-05,  3.036450804867581e-08,
  5.594421546253882e-10,  9.677342558697360e-13, -1.905661625590051e-14, -1.155459330500532e-16,  4.417819205674759e-19,  7.386018593026567e-21,  6.891326561466771e-24,
 -3.584508549990771e-25,  1.612686769842029e+00, -3.644935423590594e-03, -1.761273382588676e-05, -1.358835887366088e-08,  4.668965465881653e-10,  3.007281369439201e-12,
 -2.993014220392518e-15, -1.537308205476434e-16, -7.378004404734312e-19,  3.477247131715262e-21,  5.917067197252344e-23,  1.644056574046094e-25,  1.723252846725368e+00,
 -2.875776703863511e-03, -1.756899399366039e-05, -5.372413591168426e-08,  1.806848935585620e-10,  3.305534208102360e-12,  1.640036304581052e-14, -3.042490034503407e-17,
 -1.038538976536068e-18, -6.484717414705493e-21,  4.485096699724938e-24,  3.918889211183254e-25,  1.820490308074435e+00, -2.030144656818357e-03, -1.488374488987106e-05,
 -7.472989333508552e-08, -1.603195364054271e-10,  1.419638410163421e-12,  1.955436922091062e-14,  1.149181036953791e-16,  1.251589641054736e-19, -4.691721565196841e-21,
 -5.224005202688852e-23, -2.567789720891813e-25,  1.900212243158890e+00, -1.207883362354963e-03, -1.015875337210357e-05, -6.759120291323267e-08, -3.446213531132571e-10,
 -1.004293022980389e-12,  3.684318899363889e-15,  8.418017816258997e-17,  7.463728782639125e-19,  4.137026612948050e-21,  8.372844620249556e-24, -1.231315853758990e-25,
  1.958460605283472e+00, -5.280293678735683e-04, -4.882646275049367e-06, -3.846759600942924e-08, -2.678974507676762e-10, -1.643548388427045e-12, -8.503943331473416e-15,
 -3.155898076542504e-17, -4.276417736600567e-21,  1.396316564253083e-21,  1.743070796396758e-23,  1.492460710090961e-25,  1.992012835094303e+00, -1.044060445642805e-04,
 -1.017810357588706e-06, -8.753943860810981e-09, -6.992204467026716e-11, -5.299785864567727e-13, -3.850676770260451e-15, -2.693956536631415e-17, -1.816354629361823e-19,
 -1.177676535585879e-21, -7.300843773066190e-24, -4.278653983297006e-26,  1.204730835543474e-03, -9.409043833766543e-06,  5.508488827812258e-08, -2.865228048292904e-10,
  1.395937611222759e-12, -6.524364633087691e-15,  2.960544995964720e-17, -1.314980242171766e-19,  5.736883295485222e-22, -2.471131774418019e-24,  1.049655022469817e-26,
 -4.429370060246922e-29,  1.083982546577326e-02, -8.442339268987022e-05,  4.911522161154330e-07, -2.526462783710027e-09,  1.209699370247565e-11, -5.513498500551358e-14,
  2.416421075017217e-16, -1.024661498797478e-18,  4.206347468617362e-21, -1.675243882554459e-23,  6.426082882024776e-26, -2.381066606238022e-28,  3.009507894346013e-02,
 -2.330680548506820e-04,  1.338679591538694e-06, -6.729922852882172e-09,  3.106230818416888e-11, -1.339668228350316e-13,  5.415269975335592e-16, -2.041101992554562e-18,
  7.021106167670474e-21, -2.108885579964130e-23,  4.687374672147156e-26, -1.390338942649473e-29,  5.893936287826022e-02, -4.525363291196714e-04,  2.548412655615881e-06,
 -1.235497095531920e-08,  5.366514101116727e-11, -2.097071705011614e-13,  7.188158530509312e-16, -1.992765316510780e-18,  2.999873454214024e-21,  1.155006313739114e-23,
 -1.448993250358863e-25,  9.184788821989724e-28,  9.732276059960487e-02, -7.385211509757679e-04,  4.046434901324605e-06, -1.861743633088487e-08,  7.359327019129896e-11,
 -2.409301710197638e-13,  5.477901118370235e-16,  1.091060710393301e-19, -1.079196861479684e-20,  8.014200626408643e-23, -4.118163832062201e-25,  1.605775795227913e-27,
  1.451724626435681e-01, -1.085097673567012e-03,  5.734316673309123e-06, -2.452951215128437e-08,  8.362932451045901e-11, -1.879247578270686e-13, -1.192112509527356e-16,
  4.344791728335367e-18, -2.988018754872634e-20,  1.359326021894076e-22, -4.102809719984617e-25,  2.021168540495234e-28,  2.023868832954384e-01, -1.484565765630073e-03,
  7.489663880054329e-06, -2.895821175119005e-08,  7.672510798685849e-11, -2.483671745854540e-14, -1.254292514421442e-15,  9.345031757299497e-18, -4.108883778298034e-20,
  9.579070739344388e-23,  2.170561758243606e-25, -3.909697243761093e-27,  2.688276092457633e-01, -1.927253298020871e-03,  9.167432649973137e-06, -3.070973073126461e-08,
  4.737323398543148e-11,  2.472318638463018e-13, -2.579845824310205e-15,  1.224262174089371e-17, -2.683353467575725e-20, -1.003618748176854e-22,  1.375522742211946e-24,
 -7.545820778641302e-27,  3.443086470132871e-01, -2.401283956328158e-03,  1.060255535064767e-05, -2.864697622838863e-08, -6.761147188725124e-12,  5.885513928135884e-13,
 -3.555279273996057e-15,  9.440923846586800e-18,  2.396303442680467e-20, -4.035301900220435e-22,  2.133492215047888e-24, -3.962726617138567e-27,  4.285822594742721e-01,
 -2.892318925170234e-03,  1.161466511455724e-05, -2.184775850057291e-08, -8.306855663028602e-11,  9.143574177123971e-13, -3.469053965939364e-15, -1.620562367977725e-18,
  1.008213549174142e-19, -5.964381689723473e-22,  9.804184985561157e-25,  1.089523042222358e-26,  5.213204697709212e-01, -3.383291898350354e-03,  1.201601779758093e-05,
 -9.809085745508334e-09, -1.723503882057053e-10,  1.099273737511494e-12, -1.675552603192738e-15, -1.992278472681765e-17,  1.606599890152322e-19, -3.521816805943695e-22,
 -2.810700692475008e-24,  2.780032173095530e-26,  6.220910661998456e-01, -3.854174184574817e-03,  1.162407846331706e-05,  7.303732444540257e-09, -2.578017399459761e-10,
  9.995497837331047e-13,  2.016060130832479e-15, -3.851759297962978e-17,  1.349589241858881e-19,  5.111880939899620e-22, -7.123301861149523e-24,  2.093674632543554e-26,
  7.303266837659133e-01, -4.281835177411034e-03,  1.028059715268752e-05,  2.837986238271128e-08, -3.154477540642700e-10,  4.996862772422783e-13,  6.875906882640757e-15,
 -4.438352963138492e-17, -2.984826066407848e-20,  1.632867259486734e-21, -6.368426866696441e-24, -2.971421435684841e-26,  8.452853203484327e-01, -4.640108528641087e-03,
  7.879162665199820e-06,  5.110416238773733e-08, -3.172192246929914e-10, -4.152365120020603e-13,  1.093515309444972e-14, -2.326765142519870e-17, -2.992420596955460e-19,
  1.908200318379455e-21,  4.304466539643928e-24, -8.986503446437886e-26,  9.660005880033757e-01, -4.900242195061705e-03,  4.402781902042238e-06,  7.181432859461882e-08,
 -2.380356134319119e-10, -1.575030023258612e-12,  1.123483202316624e-14,  2.871878276249636e-17, -4.887442970173976e-19,  1.096885241689399e-22,  1.940004981119863e-23,
 -5.552445717959298e-26,  1.091220345416134e+00, -5.032005368868127e-03, -2.882169273622475e-08,  8.564582442558862e-08, -6.775157564478925e-11, -2.569906626678141e-12,
  5.156231142293020e-15,  9.026058622880432e-17, -3.182976194932545e-19, -3.348706261571454e-21,  1.818245630459769e-23,  1.236814606778232e-25,  1.219333556332880e+00,
 -5.005841708612754e-03, -5.107136039694607e-06,  8.721830518422187e-08,  1.733339811474759e-10, -2.806781592501203e-12, -7.023233892577149e-15,  1.109950063880100e-16,
  3.129722086117443e-19, -4.898911460130632e-21, -1.490490997448193e-23,  2.308323024052875e-25,  1.348288034082141e+00, -4.796563398158623e-03, -1.029222891177961e-05,
  7.214276753000432e-08,  4.216483955178255e-10, -1.773976626298776e-12, -1.955552329175273e-14,  4.166897171078202e-17,  9.523336457608267e-19, -3.294213963231801e-22,
 -4.717897749231386e-23, -6.548316730355081e-26,  1.475507297138948e+00, -4.389080798053817e-03, -1.480889776141840e-05,  3.944450207819025e-08,  5.739704966541005e-10,
  4.733963154684605e-13, -2.205381744402090e-14, -9.713364783855549e-17,  7.086241867583137e-19,  7.323135800089643e-21, -1.053746843848363e-23, -4.270561959201801e-25,
  1.597824376965017e+00, -3.786358001307317e-03, -1.772900401151683e-05, -5.642261871268371e-09,  5.259619523787374e-10,  2.881259896801967e-12, -7.605864503593492e-15,
 -1.748687062052163e-16, -5.685995236711362e-19,  5.952112285376674e-21,  6.356332795422438e-23,  2.590932966601764e-26,  1.711464629151909e+00, -3.018853106411590e-03,
 -1.819408790715539e-05, -5.028326601970087e-08,  2.506423449345953e-10,  3.684951208186443e-12,  1.504855927526972e-14, -6.732255558623653e-17, -1.264233698908591e-18,
 -5.919882114763423e-21,  2.474553131631004e-23,  5.272057168648764e-25,  1.812125851554621e+00, -2.152842928759146e-03, -1.579487172218580e-05, -7.704126485631120e-08,
 -1.269714628753435e-10,  1.927837305950207e-12,  2.279975468300779e-14,  1.157958397759338e-16, -8.400227590876348e-20, -6.998125335901071e-21, -6.275312704051927e-23,
 -2.114838901122480e-25,  1.895212898421305e+00, -1.292492995209428e-03, -1.100357641732293e-05, -7.326017536076845e-08, -3.636175167293686e-10, -8.847463135864037e-13,
  6.398519681304993e-15,  1.104993734217664e-16,  8.997658062926666e-19,  4.334146608115862e-21,  6.803362183699691e-25, -2.335079454250675e-25,  1.956267335675417e+00,
 -5.690124225184969e-04, -5.371097065212692e-06, -4.302831218097531e-08, -3.028808049299702e-10, -1.858210716986134e-12, -9.380915617558459e-15, -3.074324513911721e-17,
  6.026064336750356e-20,  2.240113091898020e-21,  2.516047002700771e-23,  2.043733123255700e-25,  1.991578232695743e+00, -1.129885750399149e-04, -1.129936981666289e-06,
 -9.962783235237059e-09, -8.151044604159393e-11, -6.321446009874935e-13, -4.693155040609696e-15, -3.349049147717915e-17, -2.297735199518521e-19, -1.510850951696061e-21,
 -9.449541258743539e-24, -5.538058904079978e-26,  1.167954765961455e-03, -8.981747799427100e-06,  5.177644027068746e-08, -2.651943114485835e-10,  1.272267771560000e-12,
 -5.856022107390477e-15,  2.616770027882890e-17, -1.144859984046749e-19,  4.918380648629097e-22, -2.087785378781634e-24,  8.728569684692901e-27, -3.635167207143448e-29,
  1.050980285657618e-02, -8.061223659760550e-05,  4.619605797025307e-07, -2.341426868858786e-09,  1.105004048239789e-11, -4.966519054801960e-14,  2.147487865818933e-16,
 -8.992315034267101e-19,  3.647105475111521e-21, -1.438033177540621e-23,  5.461025035220164e-26, -2.016068555654727e-28,  2.918372578850575e-02, -2.226734046038850e-04,
  1.260816316183820e-06, -6.253673445767318e-09,  2.850843726816126e-11, -1.216312854463894e-13,  4.874100345688287e-16, -1.828213682148540e-18,  6.295422683204196e-21,
 -1.923544061236345e-23,  4.558962213649698e-26, -4.244661264270470e-29,  5.716907338119708e-02, -4.327277823207133e-04,  2.405169435878723e-06, -1.152896328197166e-08,
  4.963905136658275e-11, -1.931139655367000e-13,  6.644173404330252e-16, -1.891159869328756e-18,  3.320518724481939e-21,  6.500478427659855e-24, -1.090329277553960e-25,
  7.188431331872356e-28,  9.443203181180258e-02, -7.070236529101231e-04,  3.829933920465176e-06, -1.747777814722271e-08,  6.890619307939779e-11, -2.277830169212801e-13,
  5.464221244041456e-16, -1.931198308311765e-19, -8.186895830373065e-21,  6.502107432134453e-23, -3.457392088220830e-25,  1.398731013436992e-27,  1.409219885091779e-01,
 -1.040378096045468e-03,  5.447866517219611e-06, -2.322162689650918e-08,  7.985153301737612e-11, -1.894296156272560e-13, -1.023019184998067e-17,  3.463778695945661e-18,
 -2.527900819393170e-20,  1.197921542588283e-22, -3.946965411365276e-25,  4.835285396001295e-28,  1.965662834307145e-01, -1.426017627471530e-03,  7.149509495779931e-06,
 -2.773613316267412e-08,  7.594778381190958e-11, -5.194514604125345e-14, -1.010510908988331e-15,  8.086723513392624e-18, -3.752253785299047e-20,  1.013600299192687e-22,
  6.910786418487420e-26, -2.852451713951363e-27,  2.612629596964831e-01, -1.855374663869155e-03,  8.803616301588649e-06, -2.991545124331276e-08,  5.172596023064118e-11,
  1.893290803590831e-13, -2.249544966232623e-15,  1.133612692273979e-17, -2.953359029838349e-20, -5.169335650776866e-23,  1.065159731667640e-24, -6.551179758396412e-27,
  3.348709734491769e-01, -2.317839542484216e-03,  1.025851624116298e-05, -2.866553117438968e-08,  4.178418633589703e-12,  5.064706479126163e-13, -3.282266541094484e-15,
  9.991412757419541e-18,  1.092640683091263e-20, -3.220660788986650e-22,  1.931448236621990e-24, -5.100758948569746e-27,  4.171971278827401e-01, -2.800471530926587e-03,
  1.134510622681214e-05, -2.303509098616701e-08, -6.561585564885882e-11,  8.309006359479627e-13, -3.472430686186961e-15,  1.270595860492970e-18,  8.015842228191656e-20,
 -5.490041742825648e-22,  1.358958829588789e-24,  6.458178005302900e-27,  5.079787489731802e-01, -3.287679815590007e-03,  1.188248108108688e-05, -1.239317244959155e-08,
 -1.508092808928681e-10,  1.052934933099025e-12, -2.163462093676173e-15, -1.500389780425727e-17,  1.462418070850373e-19, -4.413356965762376e-22, -1.677860915730405e-24,
  2.357346393617492e-26,  6.068608128271937e-01, -3.760899565172613e-03,  1.168764152396499e-05,  3.341103804444720e-09, -2.374116604822488e-10,  1.035496411668053e-12,
  1.000414540548362e-15, -3.395755360260171e-17,  1.484697707463956e-19,  2.462612780087212e-22, -6.090055455273383e-24,  2.547467037837972e-26,  7.133658694205023e-01,
 -4.198313152911711e-03,  1.059123019596706e-05,  2.342119050948682e-08, -3.039048066168974e-10,  6.497397455328994e-13,  5.628269304000928e-15, -4.444955461289156e-17,
  2.408150249273074e-20,  1.357102923591092e-21, -7.296952199442216e-24, -1.286846416006664e-26,  8.268547142238051e-01, -4.574709050846807e-03,  8.461731051963796e-06,
  4.597623623789021e-08, -3.229576083872599e-10, -1.616283540756370e-13,  1.016011849161976e-14, -3.171861688007839e-17, -2.283755494662356e-19,  2.004137960324372e-21,
  5.742403957853764e-25, -7.867366290824747e-26,  9.464754271818989e-01, -4.861639895395269e-03,  5.240711033101201e-06,  6.776864590230039e-08, -2.667838190922496e-10,
 -1.297502968247339e-12,  1.182163155667504e-14,  1.328659561999375e-17, -4.714974654751181e-19,  8.280691446528128e-22,  1.632262460211800e-23, -8.245937546870271e-26,
  1.071098340769659e+00, -5.028147229663472e-03,  9.907519856559992e-07,  8.415817507872822e-08, -1.177139036511140e-10, -2.417086611848726e-12,  7.523865149713458e-15,
  7.829634452518667e-17, -4.245821577810338e-19, -2.527401148674852e-21,  2.250188299294433e-23,  7.150567399777926e-26,  1.199235164779981e+00, -5.042469491926058e-03,
 -4.045755525697268e-06,  8.953448044060774e-08,  1.157696537840355e-10, -2.937079745408182e-12, -3.802377692300385e-15,  1.180936792413685e-16,  1.284064746813389e-19,
 -5.283736192806863e-21, -4.186482968341999e-24,  2.513621254628462e-25,  1.328942745829189e+00, -4.875326548146514e-03, -9.387289650083163e-06,  7.858026357029748e-08,
  3.815877455746319e-10, -2.225888854586460e-12, -1.796654895644259e-14,  7.158605488604752e-17,  9.061182566103683e-19, -2.240301460343628e-21, -4.750460166945658e-23,
  5.237219684519264e-26,  1.457717250477344e+00, -4.505501995740817e-03, -1.428024569148535e-05,  4.867413972891395e-08,  5.779394705749155e-10, -8.573005830613747e-14,
 -2.441725933491358e-14, -7.035830980352559e-17,  9.600459900395724e-19,  6.516118824158077e-21, -2.995141404680260e-23, -4.457801638280249e-25,  1.582395059735721e+00,
 -3.928313493645957e-03, -1.774435393403403e-05,  3.222513869981978e-09,  5.813554187046239e-10,  2.638122741402660e-12, -1.272121167350701e-14, -1.891456227755060e-16,
 -3.087568531003567e-19,  8.464741894720825e-21,  6.067991092965658e-23, -1.643909996964577e-25,  1.699094393579145e+00, -3.166745506627234e-03, -1.877093175590078e-05,
 -4.566449858850348e-08,  3.277759027526985e-10,  4.018735857562722e-12,  1.256674801992704e-14, -1.109493324538354e-16, -1.453619027085072e-18, -4.431178912607361e-21,
  5.047996552239881e-23,  6.350971304159666e-25,  1.803255862112198e+00, -2.282931290575524e-03, -1.673018449004168e-05, -7.873352965635223e-08, -8.268277277968485e-11,
  2.513384539812864e-12,  2.596297958260657e-14,  1.085757694095908e-16, -3.831130094413780e-19, -9.666143840810086e-21, -6.980329628108095e-23, -9.512477765036910e-26,
  1.889861160117247e+00, -1.384138284069223e-03, -1.191815968923260e-05, -7.921015903579986e-08, -3.795087601348386e-10, -6.906566825622206e-13,  9.918962578167677e-15,
  1.417710251335471e-16,  1.053427743392773e-18,  4.113326084027537e-21, -1.286334781418603e-23, -3.903916474504001e-25,  1.953901958148629e+00, -6.141318469928237e-04,
 -5.917780200747434e-06, -4.818423921785808e-08, -3.423646955865990e-10, -2.093382603714349e-12, -1.020111394763773e-14, -2.731163350829942e-17,  1.613617172265614e-19,
  3.445722917516733e-21,  3.562410489316365e-23,  2.735675876971770e-25,  1.991107409613431e+00, -1.225294575959874e-04, -1.257753331229848e-06, -1.137454783005402e-08,
 -9.536016887168018e-11, -7.569169760111605e-13, -5.742553042598626e-15, -4.179147062394885e-17, -2.915948610700468e-19, -1.941985237249715e-21, -1.222272429016925e-23,
 -7.125206100724726e-26,  1.132836520128578e-03, -8.579928232122244e-06,  4.871248889427089e-08, -2.457419267356728e-10,  1.161176828531999e-12, -5.264753223875967e-15,
  2.317159957853111e-17, -9.988536791049640e-20,  4.225951467068072e-22, -1.768646934985634e-24,  7.274952715415007e-27, -2.994877309378208e-29,  1.019457147694657e-02,
 -7.702600855197565e-05,  4.348923664029273e-07, -2.172300948609592e-09,  1.010630310394543e-11, -4.480063721532236e-14,  1.911292894498899e-16, -7.904023887073975e-19,
  3.166681401705379e-21, -1.236393385653575e-23,  4.643232124705908e-26, -1.710207381901663e-28,  2.831274066055632e-02, -2.128794769398638e-04,  1.188430780396731e-06,
 -5.816380875573841e-09,  2.618875855807501e-11, -1.105255875275348e-13,  4.389387848776625e-16, -1.637491842783943e-18,  5.635265497859558e-21, -1.745520416987096e-23,
  4.328960260783203e-26, -6.070500730305513e-29,  5.547578744305693e-02, -4.140266032420281e-04,  2.271462528040485e-06, -1.076478807971706e-08,  4.593200593357471e-11,
 -1.777911844734246e-13,  6.129819792184378e-16, -1.781941901704064e-18,  3.483195482227972e-21,  2.721797945006927e-24, -8.107366372778641e-26,  5.577288763559397e-28,
  9.166391384106914e-02, -6.772047140250455e-04,  3.626667542283048e-06, -1.641101415053173e-08,  6.448109189833286e-11, -2.147613076647800e-13,  5.376805841485842e-16,
 -4.202006336978975e-19, -6.080776139433712e-21,  5.236337110726253e-23, -2.885846526971951e-25,  1.201266465139241e-27,  1.368459074290818e-01, -9.978883702442423e-04,
  5.176747761122670e-06, -2.197429306630916e-08,  7.606788541090692e-11, -1.885988425611677e-13,  7.605746521012933e-17,  2.720848725527179e-18, -2.124502841564363e-20,
  1.044850020927182e-22, -3.694831355929828e-25,  6.457612025149415e-28,  1.909745261761616e-01, -1.370132315245125e-03,  6.823928537449366e-06, -2.653052296341341e-08,
  7.468401209899930e-11, -7.361256531937176e-14, -8.003417261571251e-16,  6.944689718044402e-18, -3.385164683931610e-20,  1.018770120308713e-22, -3.712290968380407e-26,
 -2.009595804931355e-27,  2.539800655463584e-01, -1.786367336404966e-03,  8.449712324173835e-06, -2.906037065405340e-08,  5.499780318791138e-11,  1.390407071884052e-13,
 -1.945588776349045e-15,  1.036895380770247e-17, -3.069437717691683e-20, -1.455261742135908e-23,  7.992545849415044e-25, -5.539382773714135e-27,  3.257615755437597e-01,
 -2.237145479018732e-03,  9.915251662911643e-06, -2.852182555113204e-08,  1.354290878304231e-11,  4.310826842895906e-13, -2.999251271330560e-15,  1.017000743283028e-17,
  6.667938393242059e-22, -2.494852433363961e-22,  1.693925106228211e-24, -5.607331557247103e-27,  4.061749892234238e-01, -2.710832979361196e-03,  1.106291978480976e-05,
 -2.395651154364554e-08, -4.982692267111580e-11,  7.482611980581672e-13, -3.403836556469135e-15,  3.530418467020968e-18,  6.143101427766608e-20, -4.900691206393966e-22,
  1.562022018385589e-24,  2.919002220750213e-27,  4.950171517024212e-01, -3.193254277882218e-03,  1.171997075152053e-05, -1.464060602451931e-08, -1.303011728329628e-10,
  9.964842486140107e-13, -2.520524407232693e-15, -1.058937451213361e-17,  1.293833047111897e-19, -4.890630052055044e-22, -7.424622737112935e-25,  1.891866512797102e-26,
  5.920043816725996e-01, -3.667301055105298e-03,  1.170563004373889e-05, -2.908123250642116e-10, -2.165358450708271e-10,  1.048640055151992e-12,  1.171279773715488e-16,
 -2.910945505561436e-17,  1.532266471409278e-19,  2.571536252619698e-23, -4.926412999958605e-24,  2.697259712278399e-26,  6.967437411626155e-01, -4.112540723112360e-03,
  1.084356107145825e-05,  1.866959019112865e-08, -2.896594044736178e-10,  7.700133433666756e-13,  4.401408201992213e-15, -4.295442944746701e-17,  6.758712085812436e-20,
  1.058268963512341e-21, -7.542312164529225e-24,  1.185823938196978e-27,  8.086946356781112e-01, -4.504896348716256e-03,  8.982377339073949e-06,  4.079598679714435e-08,
 -3.238276697890924e-10,  7.079788971980330e-14,  9.180525031684654e-15, -3.787432788683271e-17, -1.566073571778278e-19,  1.962325435350008e-21, -2.548112532765637e-24,
 -6.268631502648866e-26,  9.271177644755331e-01, -4.816535748872837e-03,  6.027517392535661e-06,  6.330801593965955e-08, -2.898752315195445e-10, -1.010992581554452e-12,
  1.198776251012699e-14, -1.205775347177362e-18, -4.308588488530432e-19,  1.403116369260514e-21,  1.232054691166666e-23, -9.745638944186418e-26,  1.051007949942770e+00,
 -5.016217246200842e-03,  1.987788023419760e-06,  8.189854662754369e-08, -1.640806004345480e-10, -2.211819291959270e-12,  9.513541052025030e-15,  6.343282595958568e-17,
 -4.987573942247378e-19, -1.580705135995639e-21,  2.442949913293229e-23,  1.623438140164731e-26,  1.179007397880276e+00, -5.070510882691953e-03, -2.962179320486926e-06,
  9.091303418884597e-08,  5.638497604196888e-11, -2.988369393752961e-12, -4.669292445461410e-16,  1.191485633985394e-16, -6.216012336134107e-20, -5.230791966571572e-21,
  6.758891735663396e-24,  2.411320259378137e-25,  1.309297356983913e+00, -4.946552752773519e-03, -8.409237039349876e-06,  8.430683626864056e-08,  3.329369239347269e-10,
 -2.629844073456789e-12, -1.557090099965769e-14,  9.893133216422675e-17,  7.921438341416790e-19, -4.058848342443376e-21, -4.255500123231787e-23,  1.712061236801625e-25,
  1.439470679290567e+00, -4.617250743264796e-03, -1.364083521983451e-05,  5.787500967547168e-08,  5.702239825017138e-10, -6.917056060511452e-13, -2.592379503701730e-14,
 -3.615273869298003e-17,  1.168401450328752e-18,  4.934108634014030e-21, -4.882209241179721e-23, -4.008246666222399e-25,  1.566398369389783e+00, -4.069951622614452e-03,
 -1.764819118100168e-05,  1.292789476221399e-08,  6.306312849227909e-10,  2.268442166190690e-12, -1.810656179281659e-14, -1.936996589208913e-16,  3.733867112600921e-20,
  1.068307637414085e-20,  4.860985945461714e-23, -3.872219806448144e-25,  1.686123740189396e+00, -3.319009492251248e-03, -1.928473692217434e-05, -3.976185191212430e-08,
  4.108872707947482e-10,  4.277670458964879e-12,  8.788065000205491e-15, -1.595719124671795e-16, -1.569881719352276e-18, -1.834505635893703e-21,  7.966428712740617e-23,
  6.770342326651686e-25,  1.793850443819635e+00, -2.420570420315094e-03, -1.768115313577910e-05, -7.961945235972099e-08, -2.594631174405983e-11,  3.171251224738587e-12,
  2.877527914998772e-14,  9.020451988585681e-17, -7.818759345673762e-19, -1.248721535157781e-20, -6.970619048086883e-23,  1.171734269402463e-25,  1.884127749452779e+00,
 -1.483389834379295e-03, -1.290552451788399e-05, -8.537845003759107e-08, -3.905995547935595e-10, -4.010249398299140e-13,  1.438182914673788e-14,  1.777137111267692e-16,
  1.187588555532827e-18,  3.197666016458330e-21, -3.443753640468999e-23, -5.987249043907949e-25,  1.951346948501700e+00, -6.638833248866651e-04, -6.530283485914129e-06,
 -5.401056575642914e-08, -3.867390181197146e-10, -2.346677503979607e-12, -1.087279750839533e-14, -1.986338012791925e-17,  3.141688769721388e-19,  5.134750439454052e-21,
  4.942472776460947e-23,  3.554980582562605e-25,  1.990596265065158e+00, -1.331646017275737e-04, -1.403927437770874e-06, -1.302932322377505e-08, -1.119772404177685e-10,
 -9.099027196952069e-13, -7.054568575957458e-15, -5.234190378230319e-17, -3.711116087862774e-19, -2.499069646202791e-21, -1.577361379206826e-23, -9.076371756133051e-26,
  1.099277966218963e-03, -8.201715904081020e-06,  4.587167935504888e-08, -2.279761663797068e-10,  1.061224062854343e-12, -4.740725099893833e-15,  2.055494595113566e-17,
 -8.732738130943499e-20,  3.638589689418464e-22, -1.502403110099995e-24,  6.074801651824799e-27, -2.478780193647393e-29,  9.893264418764093e-03, -7.364845766610123e-05,
  4.097661789518820e-07, -2.017526292070632e-09,  9.254426235713427e-12, -4.046805756497896e-14,  1.703522549596255e-16, -6.958459945694531e-19,  2.753269614187311e-21,
 -1.064929355129048e-23,  3.948517026485056e-26, -1.455451348855736e-28,  2.747980543991841e-02, -2.036442579925243e-04,  1.121077196173176e-06, -5.414487686107742e-09,
  2.407998117541553e-11, -1.005214456449616e-13,  3.955214959054937e-16, -1.466888805347986e-18,  5.037368138579231e-21, -1.578077961781478e-23,  4.034940838271027e-26,
 -7.203597451790583e-29,  5.385522359468031e-02, -3.963593844726317e-04,  2.146579744903359e-06, -1.005753998232995e-08,  4.251932187524142e-11, -1.636656849125022e-13,
  5.646586115248575e-16, -1.669492232633170e-18,  3.528350455341029e-21, -7.067666514447035e-26, -5.949775317908317e-26,  4.275029117303330e-28,  8.901189876463977e-02,
 -6.489618854123599e-04,  3.435786074163220e-06, -1.541298172825938e-08,  6.031384954203808e-11, -2.020184844826747e-13,  5.234588680286089e-16, -5.867519740003684e-19,
 -4.391240996567089e-21,  4.182201332122085e-23, -2.398194417723993e-25,  1.017820633782328e-27,  1.329355406990877e-01, -9.575087496603575e-04,  4.920234674899765e-06,
 -2.078725897172598e-08,  7.231995059096423e-11, -1.859327052288636e-13,  1.432689239316806e-16,  2.098396097061389e-18, -1.774248851833925e-20,  9.030140078619085e-23,
 -3.391550586053449e-25,  7.205301136478468e-28,  1.856011919750247e-01, -1.316794156348638e-03,  6.512680137551627e-06, -2.534833647143141e-08,  7.303481104515948e-11,
 -9.060638401505075e-14, -6.205075764918757e-16,  5.919671169009286e-18, -3.023022110920244e-20,  9.882884017830928e-23, -1.105295160971298e-25, -1.356165001407128e-27,
  2.469676043873741e-01, -1.720149380859703e-03,  8.106351479031896e-06, -2.816059962619919e-08,  5.733461790819641e-11,  9.571927920603099e-14, -1.669046594505825e-15,
  9.384062253304502e-18, -3.069891897908273e-20,  1.283057983721991e-23,  5.768873528174167e-25, -4.581440502178113e-27,  3.169694760284940e-01, -2.159188199354185e-03,
  9.574561985699288e-06, -2.823998004471078e-08,  2.146778664932501e-11,  3.625123440488558e-13, -2.715452131492773e-15,  1.006023268254909e-17, -7.154957262285130e-21,
 -1.867063786352599e-22,  1.444623586208933e-24, -5.663966546396276e-27,  3.955068256575320e-01, -2.623491977857681e-03,  1.077113783730153e-05, -2.463842171601771e-08,
 -3.566953206047088e-11,  6.679616105779405e-13, -3.280028827262322e-15,  5.226189177974069e-18,  4.493629953723346e-20, -4.258682929325776e-22,  1.628497549203358e-24,
  2.370079493954998e-28,  4.824304933706934e-01, -3.100231210043105e-03,  1.153242134389682e-05, -1.656936667762399e-08, -1.109980821596645e-10,  9.328850487104416e-13,
 -2.761741821694060e-15, -6.734994996279996e-18,  1.114305637089778e-19, -5.034847572010992e-22, -1.219817615181167e-26,  1.431408672569718e-26,  5.775223643824723e-01,
 -3.573727277907002e-03,  1.168204471869550e-05, -3.587717858129505e-09, -1.955980911347527e-10,  1.042223970377627e-12, -6.294097711429786e-16, -2.422710405160821e-17,
  1.508907341565630e-19, -1.477080126376663e-22, -3.750974782339390e-24,  2.613014966887190e-26,  6.804683844945788e-01, -4.024973675871361e-03,  1.104031454547397e-05,
  1.416357719199455e-08, -2.732988153967288e-10,  8.614919738728308e-13,  3.234277048792248e-15, -4.023999554497986e-17,  1.002982160525135e-19,  7.610078072029049e-22,
 -7.243287230315504e-24,  1.181936856402006e-26,  7.908217447034677e-01, -4.431167020201974e-03,  9.440926221580398e-06,  3.563767322369103e-08, -3.202969376219755e-10,
  2.779028677810076e-13,  8.060333901100843e-15, -4.178021710285852e-17, -8.841524419812262e-20,  1.810500576632872e-21, -4.910880775857869e-24, -4.456553661208710e-26,
  9.079527599571466e-01, -4.765357106347480e-03,  6.758768845318855e-06,  5.852384658512839e-08, -3.072285969701410e-10, -7.251995436741420e-13,  1.176919862094605e-14,
 -1.409845907614256e-17, -3.725270178892146e-19,  1.808389396530461e-21,  7.918931480025841e-24, -1.008043254794245e-25,  1.030981042521473e+00, -4.996431720201115e-03,
  2.953400800342878e-06,  7.893234241772823e-08, -2.058993900590087e-10, -1.964030204598647e-12,  1.105901014990661e-14,  4.675115584148645e-17, -5.380439116867194e-19,
 -6.047997002195695e-22,  2.399305701421459e-23, -3.484669355020315e-26,  1.158684884535972e+00, -5.089833695571267e-03, -1.867781163890597e-06,  9.133757387122488e-08,
 -3.226137493798948e-12, -2.959938176484290e-12,  2.813563404281896e-15,  1.142189050859201e-16, -2.431280833803045e-19, -4.757712190329041e-21,  1.661361518115787e-23,
  2.025977139277706e-25,  1.289383127917087e+00, -5.009693486504939e-03, -7.367391834545219e-06,  8.919373906367613e-08,  2.768415916439249e-10, -2.967586736111908e-12,
 -1.247015712337919e-14,  1.216301748003656e-16,  6.174922843335852e-19, -5.578756081466849e-21, -3.270306291104529e-23,  2.721716765861148e-25,  1.420788038756190e+00,
 -4.723445596047844e-03, -1.289216038233518e-05,  6.685384967030649e-08,  5.501086449809578e-10, -1.321649240036209e-12, -2.638880371220600e-14,  3.668349413325280e-18,
  1.306875780508978e-18,  2.656743378707588e-21, -6.422968754825023e-23, -2.888836079968034e-25,  1.549837420864437e+00, -4.210341795900031e-03, -1.743110017327322e-05,
  2.335549819502443e-08,  6.712174943433207e-10,  1.769304493613302e-12, -2.345314497447672e-14, -1.860134375370298e-16,  4.522134655317082e-19,  1.222005531643014e-20,
  2.662257553875180e-23, -6.084329226683450e-25,  1.672536290966149e+00, -3.475077626630013e-03, -1.971957798172298e-05, -3.249339047827887e-08,  4.981583942832268e-10,
  4.429253564885995e-12,  3.611536298489446e-15, -2.101919795586158e-16, -1.571465516636833e-18,  1.937411155327102e-21,  1.084459368417173e-22,  6.097373768643013e-25,
  1.783879209313647e+00, -2.565843368387586e-03, -1.863686062546952e-05, -7.948886781220544e-08,  4.457292025786271e-11,  3.888905107244043e-12,  3.087939092775962e-14,
  5.746886987604211e-17, -1.279581654812316e-18, -1.508503793073140e-20, -5.781465954603783e-23,  4.425899197123496e-25,  1.877981062330993e+00, -1.590838918200458e-03,
 -1.396776259176984e-05, -9.167168264690265e-08, -3.947427538273314e-10,  8.240595082078251e-15,  1.990494378597466e-14,  2.172367612782501e-16,  1.270910123520255e-18,
  1.221257291137424e-21, -6.623727399249019e-23, -8.529381490871573e-25,  1.948582672535785e+00, -7.188269528551429e-04, -7.217132417009182e-06, -6.058820290821376e-08,
 -4.363204415534652e-10, -2.612977475280407e-12, -1.125753010666394e-14, -6.438662772554618e-18,  5.386103112111572e-19,  7.450410489610132e-21,  6.699992360989263e-23,
  4.433326217844476e-25,  1.990040108689549e+00, -1.450533319480944e-04, -1.571660887878226e-06, -1.497626620992125e-08, -1.319944072995277e-10, -1.098228867984479e-12,
 -8.700840166202678e-15, -6.578691011374478e-17, -4.734567225227964e-19, -3.216429157483803e-21, -2.026212995352091e-23, -1.137793718293799e-25,  1.067188121507744e-03,
 -7.845403708075884e-06,  4.323479859811123e-08, -2.117291020499321e-10,  9.711512830475962e-13, -4.275481033762696e-15,  1.826497947484464e-17, -7.650443598927255e-20,
  3.138953071628017e-22, -1.279937102487510e-24,  5.078661580515397e-27, -2.064389957406283e-29,  9.605076989345155e-03, -7.046471239296907e-05,  3.864182813367437e-07,
 -1.875714671938317e-09,  8.484421435491993e-12, -3.660379551990611e-14,  1.520465005801811e-16, -6.135826665591773e-19,  2.396840602595786e-21, -9.191482637736487e-24,
  3.355809176563307e-26, -1.245711979374474e-28,  2.668276319142876e-02, -1.949291355869547e-04,  1.058350311279124e-06, -5.044789302258539e-09,  2.216124246856392e-11,
 -9.150410320993108e-14,  3.566221289142132e-16, -1.314477599700986e-18,  4.497526241829292e-21, -1.423251264833792e-23,  3.701233430396962e-26, -7.915977872220003e-29,
  5.230338296503408e-02, -3.796581872430351e-04,  2.029865442906714e-06, -9.402696691292706e-09,  3.937780570623031e-11, -1.506620870097090e-13,  5.194900760221990e-16,
 -1.557050250551896e-18,  3.487199650893267e-21, -2.107167743855714e-24, -4.309972666116487e-26,  3.212768699180820e-28,  8.646987517479000e-02, -6.221993172371206e-04,
  3.256489285957950e-06, -1.447960635711233e-08,  5.639770283290731e-11, -1.896671719528620e-13,  5.052761701979414e-16, -7.049490662222429e-19, -3.047988534007122e-21,
  3.307427937686848e-23, -1.987938730615908e-25,  8.493742339803961e-28,  1.291826770234591e-01, -9.191252709745576e-04,  4.677608223965255e-06, -1.965968331239327e-08,
  6.864012102949590e-11, -1.818504350825422e-13,  1.945457856555732e-16,  1.580094314767229e-18, -1.472811668123763e-20,  7.737642022900053e-23, -3.070183287594254e-25,
  7.311606710912641e-28,  1.804363196157611e-01, -1.265889712636948e-03,  6.215449169856760e-06, -2.419503122763890e-08,  7.108663624872652e-11, -1.036156145947828e-13,
 -4.677717736999202e-16,  5.008269003495283e-18, -2.676491231023571e-20,  9.336936803408767e-23, -1.588822659039838e-25, -8.667721751682915e-28,  2.402145904730620e-01,
 -1.656634551004852e-03,  7.773984770813624e-06, -2.723001974567688e-08,  5.886914402182887e-11,  5.870477511556268e-14, -1.419946982086852e-15,  8.413162320586335e-18,
 -2.986784822961591e-20,  3.213561401795107e-23,  3.946267554299851e-25, -3.722038181689984e-27,  3.084837789260677e-01, -2.083940854785984e-03,  9.237971181158751e-06,
 -2.784193920062860e-08,  2.808898297329275e-11,  3.006900348552380e-13, -2.437904789883122e-15,  9.734399058218260e-18, -1.289586376325884e-20, -1.338522854604333e-22,
  1.199831537537180e-24, -5.425669040193835e-27,  3.851833110382526e-01, -2.538514233742848e-03,  1.047247964404672e-05, -2.510648502919437e-08, -2.308487247817903e-11,
  5.911456911377607e-13, -3.115779304518758e-15,  6.431405069104474e-18,  3.077435837262153e-20, -3.611372778508194e-22,  1.594042087479750e-24, -1.688892327989899e-27,
  4.702127872165666e-01, -3.008795966072632e-03,  1.132353700820521e-05, -1.819973277793142e-08, -9.301646276500121e-11,  8.647264973759783e-13, -2.903119565651578e-15,
 -3.458163768118738e-18,  9.343638625081489e-20, -4.926582428263332e-22,  5.226238339969016e-25,  1.007417567581356e-26,  5.634140222906699e-01, -3.480494755552791e-03,
  1.162089929012084e-05, -6.551573129700639e-09, -1.749568217410463e-10,  1.019517556183035e-12, -1.241162633640726e-15, -1.951042493826451e-17,  1.431440471488309e-19,
 -2.753851449357793e-22, -2.650973662591981e-24,  2.365628590666023e-26,  6.645461080676024e-01, -3.936044310085881e-03,  1.118462200144187e-05,  9.932476103760582e-09,
 -2.553820391354284e-10,  9.259800057551124e-13,  2.156217289076994e-15, -3.664686803819556e-17,  1.226264368283526e-19,  4.840193065721577e-22, -6.554432187502076e-24,
  1.892303674801562e-26,  7.732507175518508e-01, -4.354015634177543e-03,  9.838046158017585e-06,  3.056749461363521e-08, -3.129005596285693e-10,  4.570517989730561e-13,
  6.860385296787326e-15, -4.360808193394013e-17, -2.719669140449298e-20,  1.580210035017491e-21, -6.472737538076258e-24, -2.661971086468149e-26,  8.890038003412157e-01,
 -4.708562380483916e-03,  7.431131717078940e-06,  5.350734647930901e-08, -3.189466547285845e-10, -4.487607904990529e-13,  1.121772257537804e-14, -2.492516835826621e-17,
 -3.027817225899737e-19,  2.037728878558539e-21,  3.595991288261341e-24, -9.426471205703644e-26,  1.011048486030762e+00, -4.969074655563610e-03,  3.879574152630515e-06,
  7.533853816798737e-08, -2.424299165938474e-10, -1.684864724236867e-12,  1.212502495435652e-14,  2.936682035339728e-17, -5.430309069885735e-19,  3.112754935231906e-22,
  2.151063689281731e-23, -7.599010167527431e-26,  1.138302599776650e+00, -5.100397088788186e-03, -7.739787326797242e-07,  9.081710401834229e-08, -6.149579444653648e-11,
 -2.855067514537854e-12,  5.878033371863233e-15,  1.038431026026665e-16, -4.004424346412826e-19, -3.931271041657808e-21,  2.427094863170331e-23,  1.426895823776228e-25,
  1.269233354660122e+00, -5.064280631268961e-03, -6.272498198980869e-06,  9.313332519775831e-08,  2.147835977421224e-10, -3.223963907910255e-12, -8.819725246400901e-15,
  1.379489252887985e-16,  3.962073806293751e-19, -6.624813447315033e-21, -1.911346546233694e-23,  3.387736060622356e-25,  1.401693271010596e+00, -4.823226496721630e-03,
 -1.203808720898027e-05,  7.540983400752098e-08,  5.173753986110605e-10, -1.948952221428695e-12, -2.568989735169788e-14,  4.650063543113414e-17,  1.353623785622914e-18,
 -1.204784823053807e-22, -7.339951684670212e-23, -1.201260010088776e-25,  1.532719192128284e+00, -4.348484480220577e-03, -1.708533339686950e-05,  3.434574776090229e-08,
  7.005631492398502e-10,  1.145976177895569e-12, -2.839164975607093e-14, -1.643541536642890e-16,  9.043304907290659e-19,  1.269317190667149e-20, -4.241841455389796e-24,
 -7.827221477535298e-25,  1.658318197909233e+00, -3.634251681427090e-03, -2.005874261033366e-05, -2.381156828776964e-08,  5.871045378618192e-10,  4.439719138041740e-12,
 -2.961111362630347e-15, -2.584761052726935e-16, -1.417619638147922e-18,  6.760432055943786e-21,  1.311489855034027e-22,  3.957925757005001e-25,  1.773311630157930e+00,
 -2.718735420110736e-03, -1.958374964679070e-05, -7.811275226053516e-08,  1.298663187565536e-10,  4.644176389330253e-12,  3.183069963274357e-14,  7.432127957742691e-18,
 -1.858488826635187e-18, -1.688723427222395e-20, -2.912010189439010e-23,  8.779201097875242e-25,  1.871387104069484e+00, -1.707088437965822e-03, -1.510562272008263e-05,
 -9.795814106616101e-08, -3.892842119824980e-10,  5.635668441540856e-13,  2.655945574430979e-14,  2.580197505901467e-16,  1.257406036290144e-18, -2.259518245410977e-21,
 -1.098036701917224e-22, -1.126903894926357e-24,  1.945587112998487e+00, -7.795949923408643e-04, -7.987849807061988e-06, -6.800210908150954e-08, -4.912852134800905e-10,
 -2.883106678485482e-12, -1.115227767219910e-14,  1.564517373048305e-17,  8.599890984653320e-19,  1.054474810071987e-20,  8.827666010449547e-23,  5.196231282426921e-25,
  1.989433557607815e+00, -1.583831285687665e-04, -1.764810917400841e-06, -1.727589776083274e-08, -1.562057141608333e-10, -1.330978287609588e-12, -1.077356366619510e-14,
 -8.295684178764143e-17, -6.051100960632577e-19, -4.134383255461085e-21, -2.581950371792933e-23, -1.389755245832989e-25,  1.036482536585895e-03, -7.509430510565488e-06,
  4.078453328843793e-08, -1.968516493866268e-10,  8.898574357569196e-13, -3.861733188333082e-15,  1.625682289296341e-17, -6.715953684337264e-20,  2.712647422358400e-22,
 -1.093931745276310e-24,  4.245534860981360e-27, -1.735701619272289e-29,  9.329261464211442e-03, -6.746114706190936e-05,  3.647006778771528e-07, -1.745627956821697e-09,
  7.787488607364356e-12, -3.315247304901157e-14,  1.358920127237472e-16, -5.419293940060290e-19,  2.088836427051644e-21, -7.953531454295530e-24,  2.846210879681217e-26,
 -1.077320103489269e-28,  2.591960518034883e-02, -1.866985912511728e-04,  9.998813990918822e-07, -4.704397271218787e-09,  2.041385055753042e-11, -8.337103691972333e-14,
  3.217566187334574e-16, -1.178475863438366e-18,  4.010950341995088e-21, -1.282330505587988e-23,  3.340916743256862e-26, -8.453966635876610e-29,  5.081652828280584e-02,
 -3.638601070557382e-04,  1.920716069349602e-06, -8.796094916119790e-09,  3.648577502445345e-11, -1.387049656900889e-13,  4.774413102701798e-16, -1.446980317839179e-18,
  3.383467217256093e-21, -3.575610741851268e-24, -3.096850249680120e-26,  2.324594259519740e-28,  8.403210256630936e-02, -5.968273679269063e-04,  3.088025124312829e-06,
 -1.360693787501243e-08,  5.272397436389103e-11, -1.777873812086625e-13,  4.843405634544695e-16, -7.848983067068344e-19, -1.991864889162556e-21,  2.582339914833969e-23,
 -1.648821332271680e-25,  6.938656435795203e-28,  1.255795495307536e-01, -8.826296745624777e-04,  4.448162315174765e-06, -1.859026964134183e-08,  6.505312234979415e-11,
 -1.767011907463217e-13,  2.325924555853328e-16,  1.151055725426182e-18, -1.215593298317709e-20,  6.573106588089640e-23, -2.755280326602627e-25,  6.930150747430551e-28,
  1.754703962144687e-01, -1.217308306440882e-03,  5.931862876200771e-06, -2.307478754355353e-08,  6.891293031692532e-11, -1.132530804337641e-13, -3.390347501410606e-16,
  4.204278283926849e-18, -2.352616515517052e-20,  8.636322445319206e-23, -1.888973987252118e-25, -5.195070744327395e-28,  2.337103892525925e-01, -1.595733623787696e-03,
  7.452908933184674e-06, -2.628049412325325e-08,  5.972098003823702e-11,  2.734603814789049e-14, -1.197565382719003e-15,  7.478641169969266e-18, -2.846423120979378e-20,
  4.487097641694357e-23,  2.474837459869751e-25, -2.988835392228575e-27,  3.002937184217347e-01, -2.011365421363561e-03,  8.906752861903356e-06, -2.734749231665998e-08,
  3.353950541509654e-11,  2.454003137943811e-13, -2.171780006139995e-15,  9.253434702894417e-18, -1.690720797996000e-20, -9.052275964697526e-23,  9.696015058920534e-25,
 -5.021424833744331e-27,  3.751948979719167e-01, -2.455944914501037e-03,  1.016936284282898e-05, -2.538525957500012e-08, -1.199463353799405e-11,  5.186276430209803e-13,
 -2.923780760543473e-15,  7.220303931658215e-18,  1.889928233297177e-20, -2.992859478513621e-22,  1.489037368162166e-24, -2.993919089471930e-27,  4.583573627481536e-01,
 -2.919105268008639e-03,  1.109676901538008e-05, -1.955345266192098e-08, -7.642484744035276e-11,  7.942113274068246e-13, -2.960721467673581e-15, -7.471374566324944e-19,
  7.617341971732874e-20, -4.640205434768769e-22,  8.822678049683836e-25,  6.368721331897921e-27,  5.496774145829110e-01, -3.387888086730755e-03,  1.152615171123596e-05,
 -9.189554495613705e-09, -1.549059655948990e-10,  9.836819163415556e-13, -1.724950778567993e-15, -1.510692369074325e-17,  1.315636141098053e-19, -3.615753761955896e-22,
 -1.683894882091083e-24,  2.018277572094231e-26,  6.489815434573654e-01, -3.846158615077942e-03,  1.127991435995635e-05,  5.996991274022669e-09, -2.364257084564482e-10,
  9.658736235079185e-13,  1.187310242069825e-15, -3.249291324509362e-17,  1.355453172989046e-19,  2.398467106791646e-22, -5.626292639826903e-24,  2.276229627704633e-26,
  7.559942677160716e-01, -4.273928383350242e-03,  1.017514713495197e-05,  2.564274362680960e-08, -3.022122261764384e-10,  6.070011136882466e-13,  5.635358915494981e-15,
 -4.362013887433230e-17,  2.479316758286740e-20,  1.302777026665235e-21, -7.282094060966270e-24, -1.059843663139077e-26,  8.702923922284412e-01, -4.646632315941242e-03,
  8.042351503654786e-06,  4.834677007828940e-08, -3.252915151710569e-10, -1.889365855427164e-13,  1.039535178437328e-14, -3.342059519340791e-17, -2.278017526370910e-19,
  2.102239425212933e-21, -2.700285462879217e-25, -8.052424921868120e-26,  9.912398899852140e-01, -4.934490210473838e-03,  4.759303223291983e-06,  7.120613661339750e-08,
 -2.731606842946856e-10, -1.385944354712286e-12,  1.270684593717498e-14,  1.232807759070425e-17, -5.172287444029958e-19,  1.095627448693905e-21,  1.750485013859804e-23,
 -1.037246946695793e-25,  1.117895500594321e+00, -5.102250709620134e-03,  3.080660384633056e-07,  8.938498638885144e-08, -1.169589136504466e-10, -2.680675220140990e-12,
  8.586367018847850e-15,  8.896296536499576e-17, -5.231662287729157e-19, -2.855428237656864e-21,  2.899934059790185e-23,  7.121166565708442e-26,  1.248883026226594e+00,
 -5.109936764643827e-03, -5.136440497799128e-06,  9.604386379592393e-08,  1.485069060289631e-10, -3.388078697735424e-12, -4.816387753709073e-15,  1.466939236150303e-16,
  1.476403807040878e-19, -7.081398524307669e-21, -3.557860243152540e-24,  3.604168913542575e-25,  1.382213681271145e+00, -4.915773973750203e-03, -1.108489456416957e-05,
  8.334303889928969e-08,  4.723614473523797e-10, -2.545015299927789e-12, -2.378619104593202e-14,  8.917366179850240e-17,  1.295691027707142e-18, -3.104077940414857e-21,
 -7.430474368517990e-23,  8.195186053157597e-26,  1.515054770150506e+00, -4.483326504487050e-03, -1.660529806526551e-05,  4.569959118881684e-08,  7.163146037283982e-10,
  4.130429948431957e-13, -3.252036449701764e-14, -1.282064788665226e-16,  1.349626719753754e-18,  1.180288971909417e-20, -4.085702171841530e-23, -8.623882542811445e-25,
  1.643458675920980e+00, -3.795698174446786e-03, -2.028520862573264e-05, -1.371395158496153e-08,  6.745766261370673e-10,  4.276940198474607e-12, -1.078956048281254e-14,
 -2.989051025660227e-16, -1.076502367974726e-18,  1.225545085123490e-20,  1.408543769016425e-22,  1.886602527661543e-26,  1.762117471429074e+00, -2.879112177102053e-03,
 -2.050543601158334e-05, -7.525037311479694e-08,  2.303689325670943e-10,  5.403322335826255e-12,  3.111367986850064e-14, -6.190714140537340e-17, -2.476762942216698e-18,
 -1.713343730867839e-20,  2.050198533435068e-23,  1.383390651597286e-24,  1.864309467478331e+00, -1.832740201647036e-03, -1.631800065017729e-05, -1.040593473623898e-07,
 -3.710303558261052e-10,  1.292127244833620e-12,  3.432847030860354e-14,  2.960060323897861e-16,  1.084366830018681e-18, -7.717967132768471e-21, -1.648318618707228e-22,
 -1.360396469019073e-24,  1.942335564722826e+00, -8.468999974325323e-04, -8.852987902216403e-06, -7.633830250616114e-08, -5.515707581520389e-10, -3.142018593404265e-12,
 -1.026674719845800e-14,  4.996571980378312e-17,  1.308801614130894e-18,  1.454670690975244e-20,  1.120360137007447e-22,  5.480619507637363e-25,  1.988770412380403e+00,
 -1.733754654024731e-04, -1.988043648920952e-06, -2.000302538923459e-08, -1.856110001322041e-10, -1.619750349360911e-12, -1.339131238679577e-14, -1.049134961444105e-16,
 -7.740781727374838e-19, -5.296719333418807e-21, -3.246956659389439e-23, -1.624928139075896e-25,  1.007082740486942e-03, -7.192366817416798e-06,  3.850525802908068e-08,
 -1.832112309937861e-10,  8.163770107865819e-13, -3.493189402797420e-15,  1.449218737016475e-17, -5.907783936343610e-20,  2.347632768266274e-22, -9.385882731964245e-25,
  3.540004292531753e-27, -1.483531522153295e-29,  9.065122344462842e-03, -6.462526284947364e-05,  3.444794209004678e-07, -1.626160358196472e-09,  7.155862074942703e-12,
 -3.006585672295207e-14,  1.216122579794217e-16, -4.794571585009560e-19,  1.821897051528504e-21, -6.905799930196342e-24,  2.401712611487607e-26, -9.501883008411750e-29,
  2.518845905874717e-02, -1.789199226128170e-04,  9.453346656682613e-07, -4.390706421102097e-09,  1.882105180392451e-11, -7.603075987897597e-14,  2.904885968015820e-16,
 -1.057261131869021e-18,  3.572454345660821e-21, -1.156302624444609e-23,  2.955885591683654e-26, -9.090310543936386e-29,  4.939116454606464e-02, -3.489068737802751e-04,
  1.818575999080791e-06, -8.233906283511517e-09,  3.382304256966161e-11, -1.277204520306074e-13,  4.384207078392691e-16, -1.340989412039427e-18,  3.234697115916311e-21,
 -4.633378012343485e-24, -2.249090131898962e-26,  1.539125411884647e-28,  8.169318726415556e-02, -5.727622252004502e-04,  2.929688056828967e-06, -1.279117627733810e-08,
  4.928265458562631e-11, -1.664333211895134e-13,  4.616020694492929e-16, -8.349795105497934e-19, -1.173979879883178e-21,  1.979485508978047e-23, -1.376230458398649e-25,
  5.456894457226269e-28,  1.221188131978884e-01, -8.479192810985849e-04,  4.231208567006053e-06, -1.757737837920195e-08,  6.157731315458800e-11, -1.707740610563252e-13,
  2.597170691456930e-16,  7.978583575745717e-19, -9.980828018088042e-21,  5.529923220268039e-23, -2.466468785366514e-25,  6.128764220476057e-28,  1.706943453430940e-01,
 -1.170942423740684e-03,  5.661504993629227e-06, -2.199070472218459e-08,  6.657560801188256e-11, -1.200595279188905e-13, -2.313979155457817e-16,  3.499687797351254e-18,
 -2.055791772684096e-20,  7.842377882344398e-23, -2.064765224085315e-25, -3.000244097209495e-28,  2.274447269581188e-01, -1.537355540167342e-03,  7.143289397777972e-06,
 -2.532207533716535e-08,  5.999692129063183e-11,  1.015920471150717e-15, -1.000660376724477e-15,  6.595296022768254e-18, -2.670068634785843e-20,  5.232414129224491e-23,
  1.294493773328752e-25, -2.402271180948812e-27,  2.923886997209578e-01, -1.941414600312143e-03,  8.581955775205167e-06, -2.677434122417538e-08,  3.794694348028383e-11,
  1.963228571593578e-13, -1.920697269504242e-15,  8.667324145394128e-18, -1.951993499086386e-20, -5.602255132883600e-23,  7.587770741342578e-25, -4.560576018216315e-27,
  3.655318952422796e-01, -2.375811002868758e-03,  9.863918377807914e-06, -2.549793605554479e-08, -2.307099991716670e-12,  4.509417155326030e-13, -2.714684727843729e-15,
  7.663912917422664e-18,  9.162789875709743e-21, -2.426341871764903e-22,  1.337463617785484e-24, -3.832378914535038e-27,  4.468569761308042e-01, -2.831289287069755e-03,
  1.085530246353981e-05, -2.065303954176762e-08, -6.125152959520865e-11,  7.231632379045965e-13, -2.949975456667007e-15,  1.430437039255171e-18,  6.016262232248097e-20,
 -4.240863281070790e-22,  1.091698590059055e-24,  3.244963352851916e-27,  5.363095247253953e-01, -3.296160626176369e-03,  1.140164765576206e-05, -1.151304559150536e-08,
 -1.356781718933030e-10,  9.376704548687072e-13, -2.091043943897067e-15, -1.111648626362220e-17,  1.175381161548678e-19, -4.123173518333231e-22, -8.821862422477281e-25,
  1.620881503525658e-26,  6.337777545571298e-01, -3.755694275722660e-03,  1.132982305523755e-05,  2.369967543855839e-09, -2.168944140261127e-10,  9.839480568449046e-13,
  3.392328671732677e-16, -2.805875413680103e-17,  1.403750736915567e-19,  3.531999975782607e-23, -4.592418466822545e-24,  2.381798692005602e-26,  7.390631906099177e-01,
 -4.191377587970849e-03,  1.045427097965868e-05,  2.091140357852653e-08, -2.888180083876596e-10,  7.277243207809348e-13,  4.431748130129775e-15, -4.213323998249246e-17,
  6.637507801670964e-20,  1.006230210410799e-21, -7.450774932417993e-24,  2.363423062099717e-27,  8.518380897616351e-01, -4.580061538991237e-03,  8.591203067895684e-06,
  4.312509943015412e-08, -3.266551215873446e-10,  4.856849440461351e-14,  9.368843715118740e-15, -3.950807722793164e-17, -1.531236776804418e-19,  2.025645928434316e-21,
 -3.428983423988973e-24, -6.263171235606088e-26,  9.715833821262959e-01, -4.893074188371434e-03,  5.586692628190333e-06,  6.663046852187591e-08, -2.978114627343320e-10,
 -1.078667067913304e-12,  1.282715334797890e-14, -3.466266964231912e-18, -4.663295295425796e-19,  1.699587903207978e-21,  1.259614095546390e-23, -1.170681780778016e-25,
  1.097498169883717e+00, -5.095531512610381e-03,  1.367727072266604e-06,  8.709674411335585e-08, -1.683200723853493e-10, -2.446689475522768e-12,  1.082912324815109e-14,
  7.080562683747874e-17, -6.045240017382701e-19, -1.654389023411252e-21,  3.052380239738246e-23, -1.243759601214636e-27,  1.228368445647732e+00, -5.146382973007780e-03,
 -3.971910113299173e-06,  9.787300424191626e-08,  7.992385924368891e-11, -3.454084750386469e-12, -6.811565368009413e-16,  1.473428937131260e-16, -1.060624098033104e-19,
 -6.910794416789783e-21,  1.189931609696380e-23,  3.345971245941378e-25,  1.362379737172353e+00, -5.000328247470732e-03, -1.004120906218912e-05,  9.046353411969588e-08,
  4.159784031508143e-10, -3.081359836468999e-12, -2.072968911504178e-14,  1.282848996505415e-16,  1.131868739801112e-18, -5.943374168323568e-21, -6.618172872096231e-23,
  2.843454714816769e-25,  1.496859528070988e+00, -4.613780124432925e-03, -1.598800463950729e-05,  5.718317735072832e-08,  7.165066447337764e-10, -4.052633828550947e-13,
 -3.544431430839964e-14, -7.860949509150695e-17,  1.735996065777325e-18,  9.414694559546782e-21, -7.817234948405180e-23, -8.099198276274885e-25,  1.627950545100586e+00,
 -3.958448233139044e-03, -2.038224741476094e-05, -2.253394729588441e-09,  7.568297723403481e-10,  3.914112427969358e-12, -1.956712914784302e-14, -3.252134642495740e-16,
 -5.349864827512855e-19,  1.776214428146307e-20,  1.306940033510017e-22, -4.998767404894477e-25,  1.750267316333722e+00, -3.046696549715055e-03, -2.138262946848913e-05,
 -7.066012408454091e-08,  3.457135834122927e-10,  6.119732724461033e-12,  2.817982610035302e-14, -1.507461188311198e-16, -3.062777205477450e-18, -1.494764566866075e-20,
  9.232955811390882e-23,  1.867296785487418e-24,  1.856709370648444e+00, -1.968377706650339e-03, -1.760132606383662e-05, -1.097414436069946e-07, -3.362586363454319e-10,
  2.219084453368087e-12,  4.305090188420078e-14,  3.248679479219277e-16,  6.730217749991991e-19, -1.554886236162338e-20, -2.273448386589303e-22, -1.444502189098389e-24,
  1.938800297009644e+00, -9.215430265350291e-04, -9.824113905253451e-06, -8.567897812115019e-08, -6.167351985029234e-10, -3.366383455503126e-12, -8.196200386903541e-15,
  1.011377194570386e-16,  1.918851390744758e-18,  1.949640167232034e-20,  1.348294074541408e-22,  4.612374496378752e-25,  1.988043506920666e+00, -1.902930266475711e-04,
 -2.247027065082453e-06, -2.325047520068634e-08, -2.214731133099769e-10, -1.979377352315438e-12, -1.670621287261278e-14, -1.329998790427135e-16, -9.899089181948478e-19,
 -6.743523409987133e-21, -3.996645675372224e-23, -1.753627610354312e-25,  9.789157399319340e-04, -6.892902027326587e-06,  3.638284965936370e-08, -1.706897588520807e-10,
  7.498616173870535e-13, -3.164408431010669e-15,  1.293828979905581e-17, -5.207995378317362e-20,  2.033709273797931e-22, -8.094678509499333e-25,  2.928838298305827e-27,
 -1.307701109211293e-29,  8.812012064481969e-03, -6.194558147697183e-05,  3.256331173934372e-07, -1.516322968473843e-09,  6.582677569879305e-12, -2.730189544185316e-14,
  1.089675686164633e-16, -4.249567885811896e-19,  1.589598527820186e-21, -6.026000153235128e-24,  2.003115516125446e-26, -8.704164787053261e-29,  2.448757810721711e-02,
 -1.715629930243721e-04,  8.944040293579325e-07, -4.101365554253402e-09,  1.736782116024685e-11, -6.940173197170499e-14,  2.624247464025752e-16, -9.493826823270271e-19,
  3.176479396435360e-21, -1.046344272845569e-23,  2.533931981149164e-26, -1.021250952920073e-28,  4.802402122675040e-02, -3.347444839049781e-04,  1.722933657776406e-06,
 -7.712613731933884e-09,  3.137087290931160e-11, -1.176373908492943e-13,  4.022959049899112e-16, -1.240309657255057e-18,  3.053129543956765e-21, -5.420080952924643e-24,
 -1.740779063974468e-26,  7.631471463146057e-29,  7.944805983875068e-02, -5.499255414327854e-04,  2.780817158270612e-06, -1.202868922357064e-08,  4.606285964506782e-11,
 -1.556390481638818e-13,  4.377965143167025e-16, -8.621631327365349e-19, -5.550659580369335e-22,  1.472622094778689e-23, -1.169135664095292e-25,  3.936600616135921e-28,
  1.187935228360810e-01, -8.148968350366572e-04,  4.026079853923970e-06, -1.661911957824134e-08,  5.822579461309235e-11, -1.643070889947012e-13,  2.778716923042776e-16,
  5.084709192186609e-19, -8.161440534356810e-21,  4.593924189833883e-23, -2.222728986068286e-25,  4.861872881881937e-28,  1.660995137566305e-01, -1.126688013343729e-03,
  5.403927666505048e-06, -2.094497424888716e-08,  6.412644591984246e-11, -1.245089691170165e-13, -1.422036769448698e-16,  2.885389089644375e-18, -1.788615447715323e-20,
  6.993749473007377e-23, -2.171625087814112e-25, -2.076723317908177e-28,  2.214076959806346e-01, -1.481408372067363e-03,  6.845180809318546e-06, -2.436320583759148e-08,
  5.979154785854879e-11, -2.087868751165666e-14, -8.276648484114730e-16,  5.771813739256967e-18, -2.474802856305544e-20,  5.552378438177734e-23,  3.355637888429160e-26,
 -1.987860185662820e-27,  2.847583327072323e-01, -1.874033518377622e-03,  8.264428269499007e-06, -2.613820183943332e-08,  4.143171880532409e-11,  1.530660958404263e-13,
 -1.687020789971272e-15,  8.015890326924563e-18, -2.103760247827969e-20, -2.955576676174711e-23,  5.675942169347063e-25, -4.146120808785077e-27,  3.561845360709431e-01,
 -2.298123521511260e-03,  9.558008018816414e-06, -2.546616547307069e-08,  6.077730041210446e-12,  3.883897792505169e-13, -2.497231722444214e-15,  7.827349481588553e-18,
  1.348670114420398e-21, -1.926832384371117e-22,  1.156145571626851e-24, -4.376314415119067e-27,  4.357039120881869e-01, -2.745453799376675e-03,  1.060205071548041e-05,
 -2.152118731117525e-08, -4.749194914173439e-11,  6.530482023550743e-13, -2.885204054811749e-15,  3.120025877908582e-18,  4.570860402744084e-20, -3.783624387533468e-22,
  1.175559225542850e-24,  6.422811417019243e-28,  5.233063833474706e-01, -3.205535568532623e-03,  1.125107576295055e-05, -1.353669415048450e-08, -1.174496879614546e-10,
  8.841613530461446e-13, -2.351920777083903e-15, -7.598249400696141e-18,  1.022203469457331e-19, -4.345557188401169e-22, -2.599300627802542e-25,  1.206474757342970e-26,
  6.189363534270806e-01, -3.664999430933305e-03,  1.133809093278249e-05, -9.427270159034658e-10, -1.971950503936540e-10,  9.831694584827065e-13, -3.835739998098423e-16,
 -2.357982038865891e-17,  1.385910253025607e-19, -1.276210096788578e-22, -3.563330780480408e-24,  2.263109506546400e-26,  7.224664284575152e-01, -4.106817089545773e-03,
  1.067797922687149e-05,  1.641213395339015e-08, -2.732940856193341e-10,  8.202009428315398e-13,  3.286791171045529e-15, -3.948677965276850e-17,  9.728782195784309e-20,
  7.132955856289304e-22, -7.128114074413892e-24,  1.167512492149127e-26,  8.336584551217406e-01, -4.509350608576342e-03,  9.077415948785372e-06,  3.791822019017348e-08,
 -3.235274130287325e-10,  2.596586417949050e-13,  8.204762641394880e-15, -4.327278861485956e-17, -8.328224434956994e-20,  1.838996606189976e-21, -5.764132919261907e-24,
 -4.354023285893084e-26,  9.521054199857665e-01, -4.845264920761454e-03,  6.357010450111026e-06,  6.170956241500091e-08, -3.163226117883612e-10, -7.736065400869058e-13,
  1.253101496635745e-14, -1.732275564055710e-17, -3.973266307502179e-19,  2.099479620200135e-21,  7.397219064980105e-24, -1.172850862391345e-25,  1.077144477400367e+00,
 -5.080458459413534e-03,  2.395161947591844e-06,  8.402690793525095e-08, -2.145057854169082e-10, -2.165232417395199e-12,  1.253357400160401e-14,  5.074227052245055e-17,
 -6.422992326289924e-19, -4.542715432910740e-22,  2.901439887663874e-23, -6.535079217093105e-26,  1.207726825312164e+00, -5.173443859474553e-03, -2.792040135325519e-06,
  9.859963709976336e-08,  1.100991696334357e-11, -3.421534717518807e-12,  3.360344316329068e-15,  1.400879635894196e-16, -3.428869905340077e-19, -6.157564591607128e-21,
  2.526921702003244e-23,  2.671156500438539e-25,  1.342224793413240e+00, -5.076207377140732e-03, -8.917830477420349e-06,  9.660043168275162e-08,  3.496872802082745e-10,
 -3.531891112568199e-12, -1.666628521623994e-14,  1.605980948016629e-16,  8.737591802213741e-19, -8.287540436635888e-21, -4.980651499105351e-23,  4.513655450508889e-25,
  1.478153219364676e+00, -4.738745398756809e-03, -1.523344082863975e-05,  6.853559049938186e-08,  6.997501425406595e-10, -1.275772438999575e-12, -3.682139508217868e-14,
 -1.830528133074939e-17,  2.010471161353473e-18,  5.623107671644828e-21, -1.099576069217160e-22, -6.112126994871436e-25,  1.611790763190210e+00, -4.121402749512789e-03,
 -2.033414035674820e-05,  1.045350115480033e-08,  8.296709625665202e-10,  3.333920752174750e-12, -2.880975737785867e-14, -3.311463394158176e-16,  1.916883319947295e-19,
  2.237797255497848e-20,  9.578221645426165e-23, -1.090452773278831e-24,  1.737733183202956e+00, -3.221045704546508e-03, -2.219320881250652e-05, -6.411444346097412e-08,
  4.744702628499248e-10,  6.733855227632556e-12,  2.251196104634812e-14, -2.564844038820064e-16, -3.513577423446395e-18, -9.500628712640929e-21,  1.823207571874581e-22,
  2.179862469888790e-24,  1.848545774057179e+00, -2.114543613560236e-03, -1.894884923334023e-05, -1.147072606370495e-07, -2.807977860690526e-10,  3.363312359731107e-12,
  5.235134268407705e-14,  3.355708543478308e-16, -6.544184364471234e-20, -2.587534230919816e-20, -2.873168929949857e-22, -1.212795642336321e-24,  1.934950183825131e+00,
 -1.004421461724739e-03, -1.091372170541565e-05, -9.609495415332613e-08, -6.857618253297048e-10, -3.521484767951422e-12, -4.391552002907895e-15,  1.748475788976382e-16,
  2.722075463174933e-18,  2.522404704084080e-20,  1.492665292747299e-22,  1.444991555231559e-25,  1.987244526146295e+00, -2.094486634112840e-04, -2.548674763578283e-06,
 -2.713386383396611e-08, -2.653912878548128e-10, -2.428829651971592e-12, -2.091247158812576e-14, -1.688848113589047e-16, -1.263299580415584e-18, -8.494690689962184e-21,
 -4.747471049962308e-23, -1.586992267022110e-25,  9.519135667360299e-04, -6.609833078813218e-06,  3.440452408658833e-08, -1.591818897007274e-10,  6.895642101735333e-13,
 -2.870679096257595e-15,  1.156693521757662e-17, -4.601683155246872e-20,  1.762032731648493e-22, -7.034962276861424e-25,  2.376003084498830e-27, -1.222327731357997e-29,
  8.569327102080864e-03, -5.941155014739380e-05,  3.080516090359501e-07, -1.415230281606956e-09,  6.061856950866725e-12, -2.482390639196212e-14,  9.774936544843046e-17,
 -3.774133922264977e-19,  1.386172043034203e-21, -5.300347342841645e-24,  1.626274386503156e-26, -8.555394829839932e-29,  2.381533142871635e-02, -1.646000056001750e-04,
  8.468102326698300e-07, -3.834251326800231e-09,  1.604067316984888e-11, -6.341138577513160e-14,  2.372098081786805e-16, -8.535757658103751e-19,  2.816908304504512e-21,
 -9.545272548007274e-24,  2.040525677795867e-26, -1.248166167617428e-28,  4.671203588590393e-02, -3.213228626828750e-04,  1.633317923622513e-06, -7.228988765539237e-09,
  2.911191936197539e-11, -1.083881780207086e-13,  3.689047758155549e-16, -1.145860779624562e-18,  2.846055403174959e-21, -6.074430543709109e-24, -1.597138138834276e-26,
 -1.491996177938224e-29,  7.729195394803066e-02, -5.282440850547447e-04,  2.640794027093928e-06, -1.131602306824165e-08,  4.305318604988936e-11, -1.454231673817900e-13,
  4.134807224549424e-16, -8.723145364730990e-19, -1.053698701830756e-22,  1.034679409877398e-23, -1.033444189367206e-25,  2.163928591341148e-28,  1.155971117529351e-01,
 -7.834703238995904e-04,  3.832132838308930e-06, -1.571342932531612e-08,  5.500734899474842e-11, -1.574953661633562e-13,  2.886891699037807e-16,  2.720887612692680e-19,
 -6.662965701409523e-21,  3.742485271706017e-23, -2.048663447808812e-25,  2.904484581643663e-28,  1.616776571015592e-01, -1.084444698708977e-03,  5.158661410056211e-06,
 -1.993903164831926e-08,  6.160835711341929e-11, -1.270147769436541e-13, -6.905933405025253e-17,  2.351621718293755e-18, -1.552698603925625e-20,  6.106348091886509e-23,
 -2.269580042808052e-25, -2.663240619713883e-28,  2.155897566912762e-01, -1.427800134653241e-03,  6.558545198184213e-06, -2.341090757544872e-08,  5.918797038496989e-11,
 -3.889095126717543e-14, -6.768398054521512e-16,  5.011951351250952e-18, -2.274537250096570e-20,  5.519219516221429e-23, -4.871539386304682e-26, -1.794345999287861e-27,
  2.773924591816699e-01, -1.809161237741117e-03,  7.954841395268734e-06, -2.545292870679213e-08,  4.410593899150693e-11,  1.151940288496859e-13, -1.472131460617397e-15,
  7.329693599710668e-18, -2.173606105197049e-20, -1.041060505954828e-23,  3.914898409788092e-25, -3.898091150739769e-27,  3.471430377706053e-01, -2.222879610594915e-03,
  9.253243487814302e-06, -2.530996129281618e-08,  1.326394157869385e-11,  3.310849843460174e-13, -2.278443120757756e-15,  7.768062238610264e-18, -4.803114469896287e-21,
 -1.504209196023514e-22,  9.536832952980064e-25, -4.831952420074469e-27,  4.248900771330950e-01, -2.661682360105124e-03,  1.033965615331145e-05, -2.218030057287945e-08,
 -3.511555587097456e-11,  5.850046552688141e-13, -2.779348752716577e-15,  4.373853940568221e-18,  3.293454151138676e-20, -3.314550386870737e-22,  1.153432605097322e-24,
 -1.611322612461524e-27,  5.106631861424649e-01, -3.116207346396343e-03,  1.107793369303788e-05, -1.527755611699148e-08, -1.003463059453790e-10,  8.255173689213178e-13,
 -2.521237514152266e-15, -4.578544210528206e-18,  8.650594233051547e-20, -4.355647068134255e-22,  1.789990667729692e-25,  7.877772317489407e-27,  6.044576197529820e-01,
 -3.574392101331653e-03,  1.130849416358864e-05, -3.941256416698171e-09, -1.776746294707124e-10,  9.665368267436055e-13, -9.825959293144276e-16, -1.924402150367393e-17,
  1.316643650392134e-19, -2.509966736116660e-22, -2.627162985851447e-24,  1.965391747623499e-26,  7.062111518207291e-01, -4.020678536580800e-03,  1.084924280685140e-05,
  1.217457740979543e-08, -2.561888811756251e-10,  8.861899524956550e-13,  2.228220717790353e-15, -3.601661700127735e-17,  1.179756994150300e-19,  4.403312495036614e-22,
 -6.480438512950789e-24,  1.712016369870819e-26,  8.157690494982240e-01, -4.434998743745967e-03,  9.501580854060106e-06,  3.279360936702581e-08, -3.164645427120847e-10,
  4.417916343056953e-13,  6.965429406867023e-15, -4.492647910003999e-17, -2.164087909380644e-20,  1.575506296897890e-21, -7.281184107532121e-24, -2.583548689851713e-26,
  9.328306395110870e-01, -4.791533888554796e-03,  7.066700068214682e-06,  5.654077417483140e-08, -3.288337092570676e-10, -4.800477288242377e-13,  1.187968714264245e-14,
 -2.878076912259110e-17, -3.176431437228547e-19,  2.294470333398073e-21,  2.425054253333991e-24, -1.073646464830335e-25,  1.056867265626011e+00, -5.057325400566240e-03,
  3.381517394888709e-06,  8.026516312717160e-08, -2.546993312820595e-10, -1.849707052425473e-12,  1.366570861013683e-14,  3.014443719282873e-17, -6.386009556477345e-19,
  6.330664867622795e-22,  2.499313501241896e-23, -1.146489315648281e-25,  1.186995868219389e+00, -5.191049569021265e-03, -1.610027972228081e-06,  9.823404088559250e-08,
 -5.630382514799985e-11, -3.295254087782396e-12,  7.097385462414289e-15,  1.257853154802126e-16, -5.437746130021479e-19, -4.938615777276232e-21,  3.497105440741245e-23,
  1.702749633615649e-25,  1.321784747283504e+00, -5.142823587161652e-03, -7.727452458497436e-06,  1.016101748317362e-07,  2.754288981155629e-10, -3.875049904707301e-12,
 -1.182545191935333e-14,  1.834413271736098e-16,  5.446651833204433e-19, -9.847204734508760e-21, -2.743692355095768e-23,  5.526395286891498e-25,  1.458959977175304e+00,
 -4.857135136454734e-03, -1.434483542903892e-05,  7.947941270531081e-08,  6.653942935273613e-10, -2.158211143405043e-12, -3.640915144877392e-14,  4.837234359519457e-17,
  2.128040026787185e-18,  7.750867531239252e-22, -1.300604674052919e-22, -2.848822345357357e-25,  1.594980925360924e+00, -4.283343625893024e-03, -2.012697979767011e-05,
  2.422096568280816e-08,  8.886908252394714e-10,  2.532682854412419e-12, -3.787019095948785e-14, -3.114872204991710e-16,  1.053149292076513e-18,  2.508115839495695e-20,
  3.538893233942604e-23, -1.635666024519824e-24,  1.724489232261641e+00, -3.401529399303209e-03, -2.291250078352307e-05, -5.541882064871563e-08,  6.139017269636356e-10,
  7.174997411452315e-12,  1.371602823672370e-14, -3.727944365800290e-16, -3.700993256298221e-18, -2.714313493283211e-22,  2.787836461085643e-22,  2.127884757988289e-24,
  1.839775599755088e+00, -2.271711161377611e-03, -2.034984333726253e-05, -1.185904505294028e-07, -2.002113140055897e-10,  4.731317324007532e-12,  6.156159994985684e-14,
  3.162598613173056e-16, -1.215141064302005e-18, -3.825737102292223e-20, -3.262657762934448e-22, -4.515121733503590e-25,  1.930750304788943e+00, -1.096535701224163e-03,
 -1.213503202164606e-05, -1.076344547177847e-07, -7.567943576651529e-10, -3.557409822349577e-12,  1.868422476985682e-15,  2.776379316730626e-16,  3.737602085147831e-18,
  3.114558029855480e-20,  1.415556081066789e-22, -5.809648231270405e-25,  1.986363783511829e+00, -2.312165507347125e-04, -2.901454654106786e-06, -3.179770076548797e-08,
 -3.193947612097362e-10, -2.992338350200362e-12, -2.625586533580815e-14, -2.145825444442086e-16, -1.604820526770158e-18, -1.051539261866856e-20, -5.295798157180247e-23,
 -7.488712921092404e-26,  9.260128681432057e-04, -6.342054322927536e-06,  3.255869261485067e-08, -1.485935146204416e-10,  6.348255224152608e-13, -2.607919926713512e-15,
  1.035372036958334e-17, -4.076624868054450e-20,  1.524585787999106e-22, -6.192262489071988e-25,  1.834460961650921e-27, -1.265130586739970e-29,  8.336504448762281e-03,
 -5.701345642521731e-05,  2.916348034340176e-07, -1.322088435255276e-09,  5.588007869524865e-12, -2.259989212868970e-14,  8.777496213249474e-17, -3.359907840686778e-19,
  1.206147988952512e-21, -4.726778014056073e-24,  1.235259614946594e-26, -9.432800097987416e-29,  2.317019500196279e-02, -1.580052991546785e-04,  8.022982500613216e-07,
 -3.587445003014484e-09,  1.482749121310355e-11, -5.799527805509034e-14,  2.145210604467717e-16, -7.687866279236256e-19,  2.486547475270239e-21, -8.850203838818271e-24,
  1.401507641027900e-26, -1.708667383517715e-28,  4.545233908444313e-02, -3.085955539906587e-04,  1.549294795384920e-06, -6.780069838476399e-09,  2.703014644888838e-11,
 -9.990938782268822e-14,  3.380619358293728e-16, -1.058412444146117e-18,  2.615412788002544e-21, -6.760662422291415e-24, -1.928034470082898e-26, -1.446418288434427e-28,
  7.522038653984980e-02, -5.076494090601114e-04,  2.509040600689830e-06, -1.064990892652086e-08,  4.024197905503904e-11, -1.357927927000618e-13,  3.890591080398361e-16,
 -8.705095731280629e-19,  1.944229326201043e-22,  6.338757069429305e-24, -9.881271269566361e-26, -2.566000197508764e-29,  1.125233711724168e-01, -7.535527807378364e-04,
  3.648749670457799e-06, -1.485813237709743e-08,  5.192722473062389e-11, -1.504983086565427e-13,  2.935140359720422e-16,  7.886930099740739e-20, -5.460821893949034e-21,
  2.940389803897186e-23, -1.984785475777947e-25, -2.645087542838373e-29,  1.574209249253442e-01, -1.044115917014910e-03,  4.925223369894112e-06, -1.897368894947884e-08,
  5.905653903345578e-11, -1.279362336984970e-13, -9.852180751145107e-18,  1.888152327488344e-18, -1.349546684487470e-20,  5.168883607214822e-23, -2.437665952334187e-25,
 -5.418843474013678e-28,  2.099817362901601e-01, -1.376439462120921e-03,  6.283267952296370e-06, -2.247095894319475e-08,  5.825865957589636e-11, -5.353151956400605e-14,
 -5.463999696211537e-16,  4.315359583974695e-18, -2.081259162646673e-20,  5.165547906316853e-23, -1.290176890704583e-25, -1.920336155868818e-27,  2.702811744226823e-01,
 -1.746732087377786e-03,  7.653710417954450e-06, -2.473065393655457e-08,  4.607272445683650e-11,  8.224680671760982e-14, -1.276674527812518e-15,  6.630830837060863e-18,
 -2.187020442627305e-20,  1.823966770811834e-24,  2.196032498041569e-25, -3.989534880850095e-27,  3.383976533999507e-01, -2.150064448730475e-03,  8.951006383813830e-06,
 -2.504766214198783e-08,  1.935632281334420e-11,  2.789902994528434e-13, -2.063853215136764e-15,  7.534657267567270e-18, -9.584312655119507e-21, -1.166901721503952e-22,
  7.282035053580911e-25, -5.476698739903714e-27,  4.144070841468604e-01, -2.580038450861948e-03,  1.007049593480523e-05, -2.265212934917270e-08, -2.407201672535512e-11,
  5.198782801267873e-13, -2.643857508583667e-15,  5.245568743396446e-18,  2.180972063441932e-20, -2.873767363728769e-22,  1.034392544654048e-24, -3.828307613604282e-27,
  4.983744056959145e-01, -3.028343260508582e-03,  1.088550386006616e-05, -1.675434007176054e-08, -8.444988433815025e-11,  7.637676594004059e-13, -2.613025955352873e-15,
 -2.059254477620552e-18,  7.102659654720279e-20, -4.227313693717164e-22,  4.310107097921698e-25,  3.524527485806666e-27,  5.903406214171129e-01, -3.484160195893891e-03,
  1.124477560577662e-05, -6.630860652290521e-09, -1.586209387953306e-10,  9.369555978736540e-13, -1.463936439048168e-15, -1.519399731964178e-17,  1.209343758241721e-19,
 -3.400135572804082e-22, -1.856813320270084e-24,  1.510261784458416e-26,  6.903028542483348e-01, -3.933368533570302e-03,  1.097133698253524e-05,  8.219916270350022e-09,
 -2.380097343493055e-10,  9.280051625048422e-13,  1.274643727948423e-15, -3.203627010203147e-17,  1.293504156737536e-19,  1.969100826267097e-22, -5.679706732326910e-24,
  1.861556750883530e-26,  7.981834515659250e-01, -4.357497353611936e-03,  9.865043404223967e-06,  2.780951780815084e-08, -3.060590897369755e-10,  5.938387377121384e-13,
  5.705907240547975e-15, -4.476965527397826e-17,  2.960236068321617e-20,  1.266013564690577e-21, -8.090146454657774e-24, -1.168082669583953e-26,  9.137817411476622e-01,
 -4.732376404086254e-03,  7.713353874273677e-06,  5.121782462685972e-08, -3.356544242263132e-10, -2.056774049353021e-13,  1.094402036555456e-14, -3.761399604119524e-17,
 -2.343950916684310e-19,  2.301401431196929e-21, -1.961868046866372e-24, -9.142714344378578e-26,  1.036698067090483e+00, -5.026492506316818e-03,  4.319085818738770e-06,
  7.591208654790991e-08, -2.883571551944963e-10, -1.513882996054145e-12,  1.422840096749172e-14,  1.025627121362897e-17, -5.991303988047807e-19,  1.521261775171275e-21,
  1.918512151656875e-23, -1.464560254858781e-25,  1.166213347141310e+00, -5.199234816339760e-03, -4.387663547839058e-07,  9.681635411378117e-08, -1.202310762527332e-10,
 -3.084773557798741e-12,  1.035103579606759e-14,  1.058226062548550e-16, -6.948713452674982e-19, -3.422044909756551e-21,  4.004949457126986e-23,  5.957969475754455e-26,
  1.301097633952430e+00, -5.199696983239202e-03, -6.484291822255921e-06,  1.053833863628863e-07,  1.955146014636565e-10, -4.095588892113173e-12, -6.499608340210914e-15,
  1.950351817694766e-16,  1.763872343390717e-19, -1.044688107967828e-20, -2.421096138859013e-24,  5.698684751140712e-25,  1.439308210499237e+00, -4.967901406920015e-03,
 -1.332878124447573e-05,  8.973352900556429e-08,  6.136413286781871e-10, -3.008093275205439e-12, -3.410443627785692e-14,  1.158943039583397e-16,  2.060320012317650e-18,
 -4.562929440261169e-21, -1.339073488817193e-22,  1.165532912769568e-25,  1.577527705885028e+00, -4.442951619581978e-03, -1.974951019727265e-05,  3.879297932155138e-08,
  9.295724290095115e-10,  1.523787189610607e-12, -4.598318891164539e-14, -2.632149840745628e-16,  1.963051636969275e-18,  2.493388884548409e-20, -4.536100746716419e-23,
 -1.991650603552358e-24,  1.710512553062214e+00, -3.587311524090175e-03, -2.351380890611949e-05, -4.443429683054692e-08,  7.597791161977631e-10,  7.365612694817759e-12,
  1.634641162761742e-15, -4.890543321391569e-16, -3.488608871896864e-18,  1.261941043305940e-20,  3.613491874605708e-22,  1.520572583192924e-24,  1.830354078017116e+00,
 -2.440248979459060e-03, -2.178875832523914e-05, -1.209536299004558e-07, -9.012134491163926e-11,  6.309301871613083e-12,  6.964736684261023e-14,  2.528032559938181e-16,
 -2.828724845067353e-18, -5.132263699557726e-20, -3.160639164845912e-22,  1.051608237443573e-24,  1.926161523552229e+00, -1.198993636565623e-03, -1.350162989789787e-05,
 -1.203070136831027e-07, -8.267900679298830e-10, -3.404692668441511e-12,  1.149269535999525e-14,  4.162039637584267e-16,  4.951513610725512e-18,  3.594663855978491e-20,
  8.844641168259967e-23, -1.965843292840424e-24,  1.985389948471840e+00, -2.560461343554164e-04, -3.315780651571540e-06, -3.742318058229408e-08, -3.860611379016377e-10,
 -3.700746393374001e-12, -3.304298376076402e-14, -2.724060678124652e-16, -2.021846513114372e-18, -1.264755150262925e-20, -5.204001051787283e-23,  1.482171086493272e-25,
  9.011545354811436e-04, -6.088548476377379e-06,  3.083483515941895e-08, -1.388404506340881e-10,  5.850623224117879e-13, -2.372596926263633e-15,  9.277310121559443e-18,
 -3.623120420732811e-20,  1.313485004474823e-22, -5.575175807823034e-25,  1.233456670644276e-27, -1.507259654854398e-29,  8.113018402617857e-03, -5.474235192827195e-05,
  2.762916372438340e-07, -1.236184955679714e-09,  5.156335875797194e-12, -2.060197853893192e-14,  7.888262441035572e-17, -3.000297637644386e-19,  1.043825020011006e-21,
 -4.321736386331156e-24,  7.713106907672917e-27, -1.200690145998904e-28,  2.255074351130475e-02, -1.517551638078148e-04,  7.606349588186271e-07, -3.359211813449928e-09,
  1.371737233062583e-11, -5.309638446743734e-14,  1.940617909328894e-16, -6.942225978382490e-19,  2.176022866760512e-21, -8.462242576285334e-24,  4.736426955257482e-27,
 -2.600754501316601e-28,  4.424224048280437e-02, -2.965194358275449e-04,  1.470464312031725e-06, -6.363142073454767e-09,  2.511074097960027e-11, -9.214230118392891e-14,
  3.095603552712233e-16, -9.787777667486938e-19,  2.356134352557329e-21, -7.713110064985324e-24, -2.985444140166134e-26, -3.531734568562747e-28,  7.322913934503512e-02,
 -4.880775372147828e-04,  2.385016921095458e-06, -1.002726504756667e-08,  3.761752749958689e-11, -1.267469788675994e-13,  3.648007680615618e-16, -8.614075723828081e-19,
  3.503339576585201e-22,  2.266215497539506e-24, -1.075203035438537e-25, -3.986431513013162e-28,  1.095664304677231e-01, -7.250620757915994e-04,  3.475339007648933e-06,
 -1.405099336092623e-08,  4.898778270029487e-11, -1.434462949287383e-13,  2.934240865489776e-16, -8.048272812697463e-20, -4.546680462679013e-21,  2.130456474943034e-23,
 -2.103489311987065e-25, -5.586782855530698e-28,  1.533218452521689e-01, -1.005608998207508e-03,  4.703124097765549e-06, -1.804924985098120e-08,  5.649948700929326e-11,
 -1.275854156743358e-13,  3.723612703080379e-17,  1.484133118028615e-18, -1.181725612973171e-20,  4.130971484741584e-23, -2.796742967199636e-25, -1.160585004964913e-27,
  2.045748251944927e-01, -1.327236163974892e-03,  6.019171746539906e-06, -2.154805818880943e-08,  5.706629862995808e-11, -6.526873791316868e-14, -4.346224773110904e-16,
  3.677941373885735e-18, -1.906744473934468e-20,  4.466566082240703e-23, -2.249683494483802e-25, -2.541521616002577e-27,  2.634148437536586e-01, -1.686676829135268e-03,
  7.361414611541771e-06, -2.398193393572926e-08,  4.742588916889212e-11,  5.375560719587563e-14, -1.100789184316789e-15,  5.933378905548285e-18, -2.169000359063389e-20,
  6.947655354594516e-24,  3.156316361374622e-26, -4.684158699297357e-27,  3.299387160551771e-01, -2.079653013589265e-03,  8.652468255367557e-06, -2.469594273506550e-08,
  2.445769774379931e-11,  2.319511176865337e-13, -1.857770843379819e-15,  7.165879004797153e-18, -1.332158844969617e-20, -9.268418009140265e-23,  4.632302067441459e-25,
 -6.702006656203267e-27,  4.042463284868140e-01, -2.500567565111318e-03,  9.796691560621949e-06, -2.295749744517101e-08, -1.429671194865715e-11,  4.582577922247245e-13,
 -2.488711297271010e-15,  5.785563859430558e-18,  1.216173572207278e-20, -2.501028926522922e-22,  8.099149819302517e-25, -6.500292713630848e-27,  4.864338964596473e-01,
 -2.942085269609935e-03,  1.067683759670958e-05, -1.798675794377510e-08, -6.980505964155352e-11,  7.006060223686144e-13, -2.641127910519910e-15, -2.634811014867012e-20,
  5.614340312964767e-20, -4.037804557786659e-22,  4.806311865906577e-25, -1.416154361690168e-27,  5.765833340485774e-01, -3.394562006170994e-03,  1.115058949823909e-05,
 -9.020928679454611e-09, -1.402654213105510e-10,  8.971414465986656e-13, -1.837125074234207e-15, -1.153307957640720e-17,  1.075018174417938e-19, -4.027034518393238e-22,
 -1.323288248494519e-24,  8.832506189889507e-27,  6.747454566951928e-01, -3.845266600489897e-03,  1.104774409786672e-05,  4.561606980717399e-09, -2.192139353519235e-10,
  9.483051780081989e-13,  4.363393960885146e-16, -2.782590392313010e-17,  1.325434704136802e-19, -1.436508221169569e-23, -4.903340794875506e-24,  1.596016014839736e-26,
  7.809133000909855e-01, -4.277324448726799e-03,  1.016979082184623e-05,  2.301460330935358e-08, -2.929137111107957e-10,  7.158848078547209e-13,  4.472020253597948e-15,
 -4.315642767859403e-17,  6.925841005613811e-20,  9.351552464861802e-22, -8.388823094878620e-24, -2.926764321428566e-27,  8.949794125590580e-01, -4.668302637261613e-03,
  8.295654412527653e-06,  4.582834409653092e-08, -3.372307740823448e-10,  4.356903170135324e-14,  9.798122619462291e-15, -4.381173768658269e-17, -1.538797948633990e-19,
  2.147614752210380e-21, -5.601384860537916e-24, -7.419330015818181e-26,  1.016666858146176e+00, -4.988376652989109e-03,  5.201409682875293e-06,  7.107476398049190e-08,
 -3.152077012145431e-10, -1.171066141642583e-12,  1.425638036230917e-14, -7.904509324068667e-18, -5.321580540431682e-19,  2.154141220167717e-21,  1.234595576958726e-23,
 -1.620312413610589e-25,  1.145416693422908e+00, -5.198135061381877e-03,  7.094981243625010e-07,  9.441355175232799e-08, -1.792157213839225e-10, -2.803407644169564e-12,
  1.298647063076595e-14,  8.192796443415509e-17, -7.888969065664917e-19, -1.800433268782233e-21,  4.023092639544535e-23, -5.010346117505693e-26,  1.280203173299641e+00,
 -5.246466006410743e-03, -5.203647236004028e-06,  1.078497140368798e-07,  1.124870805392376e-10, -4.185756826580956e-12, -1.015992978861040e-15,  1.946917801851553e-16,
 -1.955210910408663e-19, -1.005665719119197e-20,  2.142388189814052e-23,  5.002638413457310e-25,  1.419230393373256e+00, -5.070062392262564e-03, -1.219519539522024e-05,
  9.902725820161909e-08,  5.455949725121086e-10, -3.780397500727113e-12, -2.996834342610828e-14,  1.781798202059384e-16,  1.801978860917657e-18, -9.696108407866321e-21,
 -1.198349768074017e-22,  5.156185768752755e-25,  1.559443215014213e+00, -4.598830879750545e-03, -1.919395054212391e-05,  5.384761442424804e-08,  9.484553815234236e-10,
  3.396613979954897e-13, -5.234232262779825e-14, -1.865597331530545e-16,  2.806507282497815e-18,  2.132958818361693e-20, -1.351211715077234e-22, -2.027136593209378e-24,
  1.695784015520855e+00, -3.777336996102098e-03, -2.396922671770045e-05, -3.110207774177770e-08,  9.063114676319079e-10,  7.228429430942432e-12, -1.353292388590775e-14,
 -5.905190920151374e-16, -2.760891647717759e-18,  2.808586533881004e-20,  4.026966403554212e-22,  2.477349820923277e-25,  1.820235248284313e+00, -2.620379141988155e-03,
 -2.324438911992764e-05, -1.212930629895199e-07,  5.329300208003631e-11,  8.053760374435358e-12,  7.516413735540562e-14,  1.304092828133335e-16, -4.887120362268511e-18,
 -6.240899931806058e-20, -2.211355455108367e-22,  3.399535162621892e-24,  1.921140055432424e+00, -1.313011356037185e-03, -1.502687282505523e-05, -1.340611192192082e-07,
 -8.910840422802284e-10, -2.969903457567803e-12,  2.556294557266578e-14,  5.958362516819053e-16,  6.283011981363441e-18,  3.714471589804221e-20, -4.556997232525383e-23,
 -4.307980289741417e-24,  1.984309711249506e+00, -2.844796193684952e-04, -3.804510168481512e-06, -4.423809662708128e-08, -4.686638193245107e-10, -4.593052074818577e-12,
 -4.164734740363585e-14, -3.447724191490014e-16, -2.512006392530797e-18, -1.447880697680172e-20, -3.593285529015897e-23,  6.448454786967866e-25,  8.772833670701440e-04,
 -5.848378529209266e-06,  2.922338808576010e-08, -1.298473079817827e-10,  5.397571430208489e-13, -2.161658450077654e-15,  8.318723258143813e-18, -3.234103267706545e-20,
  1.119943798517077e-22, -5.227797476651730e-25,  4.643767548745682e-28, -2.044540506539956e-29,  7.898377650615516e-03, -5.258998384546061e-05,  2.619391542692412e-07,
 -1.156879825489501e-09,  4.762566571226162e-12, -1.880597298097909e-14,  7.092639649325457e-17, -2.690682110376019e-19,  8.924078810064730e-22, -4.131895741771175e-24,
  1.403952672323990e-27, -1.716468379448290e-28,  2.195564287841427e-02, -1.458276742736996e-04,  7.216070431790386e-07, -3.147982692131865e-09,  1.270048444812180e-11,
 -4.866457255628795e-14,  1.755527385312318e-16, -6.294522637694538e-19,  1.871673969818970e-21, -8.542348072524418e-24, -9.890489530431252e-27, -4.180780855657748e-28,
  4.307921603080843e-02, -2.850544595086230e-04,  1.396457706850144e-06, -5.975718487324238e-09,  2.334001248319652e-11, -8.503346785928095e-14,  2.831665385978170e-16,
 -9.080901924253406e-19,  2.052433813138936e-21, -9.306758079900826e-24, -5.229346573833723e-26, -6.922451431485862e-28,  7.131424158974314e-02, -4.694686682062568e-04,
  2.268218888726445e-06, -9.445196601133058e-09,  3.516819318984000e-11, -1.182798818756707e-13,  3.408444102756617e-16, -8.497648524500140e-19,  3.488953947084653e-22,
 -2.540501859734057e-24, -1.371038742570764e-25, -9.883586394278360e-28,  1.067207382401512e-01, -6.979207022922929e-04,  3.311336476538808e-06, -1.328975867339092e-08,
  4.618901387059968e-11, -1.364469506561348e-13,  2.892370377161619e-16, -2.153901742599283e-19, -3.939119894070036e-21,  1.217077064728724e-23, -2.526896995395595e-25,
 -1.431749012335117e-27,  1.493733089425156e-01, -9.688351951050492e-04,  4.491873038009151e-06, -1.716560979244838e-08,  5.395986608047272e-11, -1.262345169352161e-13,
  7.370523940338314e-17,  1.127499742846587e-18, -1.054635216193716e-20,  2.881066441361361e-23, -3.535218016616028e-25, -2.294287989587818e-27,  1.993605714123433e-01,
 -1.280101677484151e-03,  5.766028592455008e-06, -2.064597336458363e-08,  5.566460577601856e-11, -7.453141904009591e-14, -3.399543448491331e-16,  3.091536019610210e-18,
 -1.765137407226059e-20,  3.309320202488264e-23, -3.634779475078277e-25, -3.892802951251502e-27,  2.567841147517783e-01, -1.628923672572644e-03,  7.078215269589170e-06,
 -2.321589916330621e-08,  4.824986444824783e-11,  2.925208046349338e-14, -9.443348025941648e-16,  5.243118598894186e-18, -2.147035371266210e-20,  3.686621924809271e-24,
 -2.064687424205908e-25, -6.315335262114865e-27,  3.217566764384265e-01, -2.011611683142122e-03,  8.358610306272527e-06, -2.426986261134105e-08,  2.866684568983276e-11,
  1.897212118583824e-13, -1.663573914301234e-15,  6.689168410393494e-18, -1.640088353578337e-20, -8.063255451961054e-23,  1.227681460514881e-25, -8.984209693156798e-27,
  3.943990559237214e-01, -2.423299205465581e-03,  9.520121196929575e-06, -2.311611310382929e-08, -5.715532415265548e-12,  4.005085365887387e-13, -2.322579555521563e-15,
  6.036314871926795e-18,  3.663256212350867e-21, -2.244316462046174e-22,  4.463926632216705e-25, -1.024974690987274e-26,  4.748349923598521e-01, -2.857551877635269e-03,
  1.045474646724347e-05, -1.899498273436915e-08, -5.642587697024827e-11,  6.373998105526619e-13, -2.618873414152168e-15,  1.541151734998418e-18,  4.192299464593847e-20,
 -3.875081112397945e-22,  2.880336874194210e-25, -7.596323672012033e-27,  5.631827577809979e-01, -3.305827099382719e-03,  1.102945694343406e-05, -1.112413137634843e-08,
 -1.227877085476112e-10,  8.495503122401484e-13, -2.114139010111122e-15, -8.334569375890066e-18,  9.212463006200305e-20, -4.501754709854082e-22, -1.111868898870800e-24,
  3.749852154876030e-28,  6.595414186062767e-01, -3.756723872921971e-03,  1.108206586526691e-05,  1.206225531134339e-09, -2.002037493665598e-10,  9.499052980084462e-13,
 -2.837465886000793e-16, -2.362936710121296e-17,  1.286496002006784e-19, -1.982292113673873e-22, -4.342231834722938e-24,  8.767904650975543e-27,  7.639683570601091e-01,
 -4.194939969710870e-03,  1.041833660816346e-05,  1.844795104733661e-08, -2.776191910150694e-10,  8.089919595015538e-13,  3.299266307171810e-15, -4.046644808958569e-17,
  9.686375173791771e-20,  5.981014404275999e-22, -8.450712502734884e-24, -1.133221782167688e-27,  8.764422861274545e-01, -4.599829221088933e-03,  8.813289368438951e-06,
  4.045197330812112e-08, -3.341097877225760e-10,  2.635165405993724e-13,  8.513734777279917e-15, -4.754821935236752e-17, -8.134416282850163e-20,  1.862728832193343e-21,
 -8.541899438403776e-24, -6.038311561208500e-26,  9.968018525361588e-01, -4.943441183101178e-03,  6.023333939734474e-06,  6.586255157575268e-08, -3.352350497965540e-10,
 -8.334184963058162e-13,  1.380890364638889e-14, -2.361153658329085e-17, -4.474555658219054e-19,  2.503608379993705e-21,  5.100223222058005e-24, -1.658581704009777e-25,
  1.124642606283500e+00, -5.187980120075857e-03,  1.823462648051166e-06,  9.111521731752852e-08, -2.319962657417066e-10, -2.467106130084399e-12,  1.491946429491855e-14,
  5.595067587571601e-17, -8.255514363001502e-19, -2.651545190173517e-22,  3.582193064719475e-23, -1.476319533893700e-25,  1.259142282303569e+00, -5.282894163361406e-03,
 -3.901413774404147e-06,  1.089802979064472e-07,  2.896461805118523e-11, -4.145758808700683e-12,  4.294774831572982e-15,  1.828487556337469e-16, -5.371654580232918e-19,
 -8.797194223636896e-21,  4.049579983878904e-23,  3.560137921468830e-25,  1.398762748373053e+00, -5.162728236411841e-03, -1.095710792070692e-05,  1.071146444975026e-07,
  4.632309220444410e-10, -4.433607760107817e-12, -2.423080531100553e-14,  2.293836313275117e-16,  1.373038636696346e-18, -1.393489381773217e-20, -8.982309547891325e-23,
  8.276906495872077e-25,  1.540745245024350e+00, -4.749539753935880e-03, -1.845672876409793e-05,  6.900740718153426e-08,  9.423186438401987e-10, -9.684221233738219e-13,
 -5.620167291234886e-14, -8.567928057612919e-17,  3.456227734046950e-18,  1.421662997794606e-20, -2.179336866017522e-22, -1.671538247686518e-24,  1.680289158481162e+00,
 -3.970326348889160e-03, -2.425074791400040e-05, -1.546798078141575e-08,  1.046245631062882e-09,  6.696286833887849e-12, -3.113019601106693e-14, -6.595900896829235e-16,
 -1.461851569087030e-18,  4.389669156231668e-20,  3.741557358233504e-22, -1.626863293817540e-24,  1.809372640629923e+00, -2.812128942989864e-03, -2.468915420470613e-05,
 -1.190528628233061e-07,  2.326030346114105e-10,  9.881716521281972e-12,  7.627817941003620e-14, -6.329041075264667e-17, -7.249309235805917e-18, -6.740903419931882e-20,
 -6.829696989340662e-24,  6.415014705312505e-24,  1.915637043579238e+00, -1.439907915027503e-03, -1.672298596514737e-05, -1.487542176383371e-07, -9.428730660429298e-10,
 -2.132259592147570e-12,  4.525725268865171e-14,  8.175102436013221e-16,  7.533229579531022e-18,  3.057957072751578e-20, -3.084931016750457e-22, -7.850991933118143e-24,
  1.983107368877465e+00, -3.171739571695422e-04, -4.383575762680797e-06, -5.252936611657475e-08, -5.713511871528136e-10, -5.718005274430947e-12, -5.250630159821681e-14,
 -4.337042593942808e-16, -3.050087813744136e-18, -1.509943095596608e-20,  1.222984166120759e-23,  1.657567563867777e-24,  8.543477617889998e-04, -5.620680498107776e-06,
  2.771564469521881e-08, -1.215465122528649e-10,  4.984491376158772e-13, -1.972488014796737e-15,  7.460533247370952e-18, -2.905664417812664e-20,  9.327091008503473e-23,
 -5.245424964248026e-25, -6.160973801895966e-28, -2.913842866743347e-29,  7.692122610715332e-03, -5.054873342150087e-05,  2.485016835420526e-07, -1.083597733238129e-09,
  4.402875294304613e-12, -1.719105688196460e-14,  6.376990900442682e-17, -2.428963379769669e-19,  7.426542463604780e-22, -4.248723843543316e-24, -7.837140818057153e-27,
 -2.525676152325244e-28,  2.138364342862576e-02, -1.402025390778559e-04,  6.850191042091530e-07, -2.952338226095161e-09,  1.176793181553749e-11, -4.465632266116162e-14,
  1.587195827492765e-16, -5.745951935772583e-19,  1.552015171256651e-21, -9.370641323599806e-24, -3.325923519766156e-26, -6.553877264330223e-28,  4.196089615660648e-02,
 -2.741634107520941e-04,  1.326934776898535e-06, -5.615522908898764e-09,  2.170528053116229e-11, -7.853549326889326e-14,  2.586058737139237e-16, -8.482441508284800e-19,
  1.671189593197088e-21, -1.214254870095973e-23, -9.308820536818000e-26, -1.183655988407558e-27,  6.947195385533797e-02, -4.517668977226147e-04,  2.158176029011234e-06,
 -8.900993898620481e-09,  3.288247696033889e-11, -1.103840001157385e-13,  3.171854454462547e-16, -8.412205642712963e-19,  1.461625380739799e-22, -9.126261020364065e-24,
 -1.983441904833333e-25, -1.831158526439006e-27,  1.039810442591622e-01, -6.720555604446864e-04,  3.156204678329765e-06, -1.257219110077357e-08,  4.352893108041330e-11,
 -1.295915450233183e-13,  2.814925347589410e-16, -3.365258937894370e-19, -3.701205632700726e-21,  4.557914498887748e-25, -3.423135991643921e-25, -2.697832124664753e-27,
  1.455685540128222e-01, -9.337096741889314e-04,  4.290982891894903e-06, -1.632234328727085e-08,  5.145522877266191e-11, -1.241240314870188e-13,  1.006856555576941e-16,
  8.036575502142720e-19, -9.792222045455798e-21,  1.218270648218119e-23, -4.904364921622121e-25, -4.012344959320880e-27,  1.943308732883026e-01, -1.234949430719590e-03,
  5.523570165212119e-06, -1.976767970354138e-08,  5.409907436468440e-11, -8.171440300695421e-14, -2.611421634470644e-16,  2.542578631866425e-18, -1.676824599384595e-20,
  1.454120193302393e-23, -5.800365197475670e-25, -6.069075155344309e-27,  2.503799256742513e-01, -1.573399152907740e-03,  6.804271917143086e-06, -2.244040389322960e-08,
  4.861975612718212e-11,  8.272147674272949e-15, -8.071409651583431e-16,  4.556011235077409e-18, -2.155975147307128e-20, -1.085738654824293e-23, -5.405652372197047e-25,
 -9.027204905797300e-27,  3.138421343320965e-01, -1.945899682121111e-03,  8.070242332541819e-06, -2.378294440705847e-08,  3.207686539881428e-11,  1.519810244656537e-13,
 -1.484059172202058e-15,  6.118014313523680e-18, -1.931916177245287e-20, -8.459372427080119e-23, -3.469176508137434e-25, -1.255270161511874e-26,  3.848564227998308e-01,
 -2.348248774561924e-03,  9.242433831013623e-06, -2.314645129090675e-08,  1.750946738301608e-12,  3.468007097380644e-13, -2.153117170981012e-15,  6.026747146324947e-18,
 -4.216361845539636e-21, -2.170204818710604e-22, -1.134999962724873e-25, -1.540465679844922e-26,  4.635705967560643e-01, -2.774840066163144e-03,  1.022179945829051e-05,
 -1.979921057247168e-08, -4.430218605808476e-11,  5.752034400337841e-13, -2.559025419539061e-15,  2.660924256708494e-18,  2.807985598227638e-20, -3.848549319799970e-22,
 -2.120854192859925e-25, -1.536196191796732e-26,  5.501350297895820e-01, -3.218157527362806e-03,  1.088473131718421e-05, -1.295563704706445e-08, -1.063213415130257e-10,
  7.963283993614252e-13, -2.308733350741060e-15, -5.654612022635288e-18,  7.509441555420288e-20, -4.973532836253217e-22, -1.325927224061715e-24, -1.043031635869453e-26,
  6.446918528625941e-01, -3.668062462225172e-03,  1.107794615594509e-05, -1.845636294833180e-09, -1.813249620839673e-10,  9.356133324775073e-13, -8.890421757534658e-16,
 -1.965970943272420e-17,  1.184518593367918e-19, -3.673435797388375e-22, -4.198511591725712e-24, -2.866322974802364e-27,  7.473565876596355e-01, -4.110782031882280e-03,
  1.061360741225439e-05,  1.413940624072867e-08, -2.607374197054768e-10,  8.749454430024337e-13,  2.212371676609358e-15, -3.708769794761640e-17,  1.122892329584076e-19,
  2.579133747526682e-22, -8.600331621137408e-24, -6.806143981429489e-27,  8.581869285409899e-01, -4.527471618877518e-03,  9.266847143567278e-06,  3.515902407960855e-08,
 -3.269052661414718e-10,  4.516353117280609e-13,  7.155524126569284e-15, -4.914927425711184e-17, -2.105164378537964e-20,  1.470529077115187e-21, -1.101669168705827e-23,
 -5.330894859662469e-26,  9.771293364461515e-01, -4.892185444078756e-03,  6.781009584556263e-06,  6.038319781601476e-08, -3.486508384739544e-10, -5.114719498422245e-13,
  1.296106817853893e-14, -3.646291855752820e-17, -3.554090669647367e-19,  2.562078775527577e-21, -2.158347386399885e-24, -1.633692249835545e-25,  1.103926692093620e+00,
 -5.169085612621884e-03,  2.893009670166985e-06,  8.702847399108278e-08, -2.776462512003365e-10, -2.093224029504062e-12,  1.611669177185637e-14,  2.964263509997701e-17,
 -8.110979738635561e-19,  1.013141498514847e-21,  2.752076562043420e-23, -2.260835967120490e-25,  1.237956568402874e+00, -5.308872797561518e-03, -2.593582991687900e-06,
  1.087877129143260e-07, -5.251634853064788e-11, -3.983470174013964e-12,  9.128670084289811e-15,  1.609323304729236e-16, -8.214247374061000e-19, -6.918720082578624e-21,
  5.200737897815844e-23,  1.615415548807989e-25,  1.377944831164415e+00, -5.245124531214959e-03, -9.630284381927238e-06,  1.137876319298352e-07,  3.692872235984075e-10,
 -4.933595766462850e-12, -1.727287039537344e-14,  2.646759408574284e-16,  8.160460814076438e-19, -1.674047449442321e-20, -4.931345137806212e-23,  9.840708751662897e-25,
  1.521457382217355e+00, -4.893626869092190e-03, -1.753905551802098e-05,  8.385568558214464e-08,  9.093338460349232e-10, -2.333143408115571e-12, -5.698813814760673e-14,
  3.129328764125243e-17,  3.795062023191275e-18,  4.216809496775444e-21, -2.768033871231355e-22, -9.522912402178126e-25,  1.664019080359510e+00, -4.164780333339160e-03,
 -2.433165339083132e-05,  2.296406715355675e-09,  1.171183410489703e-09,  5.723813093926559e-12, -4.999646127608201e-14, -6.783740341591657e-16,  3.648274761028974e-19,
  5.679850898730120e-20,  2.550763993796430e-22, -3.795312108220499e-24,  1.797720160303637e+00, -3.015277784586114e-03, -2.608861737942933e-05, -1.136517756355046e-07,
  4.482556353475410e-10,  1.166268427015118e-11,  7.089663597621767e-14, -3.335407634137227e-16, -9.604463260253303e-18, -6.111163862374968e-20,  3.439308686855012e-22,
  9.447699039249043e-24,  1.909598173019355e+00, -1.581091283612837e-03, -1.859974604452747e-05, -1.641140479439034e-07, -9.726576746113669e-10, -7.432480137436181e-13,
  7.166665379012054e-14,  1.073053210122817e-15,  8.316930571848922e-18,  1.002065073154600e-20, -7.536737419971423e-22, -1.253760993842965e-23,  1.981764312160696e+00,
 -3.549285378955673e-04, -5.072785313241018e-06, -6.265866783124067e-08, -6.993555525910397e-10, -7.135405124075178e-12, -6.609654524292370e-14, -5.397396660135715e-16,
 -3.562994634307982e-18, -1.266453545380961e-20,  1.236577666972490e-22,  3.610448950804018e-24,  8.322994401063366e-04, -5.404656931294349e-06,  2.630366659489176e-08,
 -1.138774663750821e-10,  4.607256730060105e-13, -1.802878665442651e-15,  6.685844461346993e-18, -2.638154981587911e-20,  7.360839774298659e-23, -5.777057055755202e-25,
 -2.109153903994758e-27, -3.816689952724518e-29,  7.493823007458291e-03, -4.861156066371801e-05,  2.359101038320866e-07, -1.015821407563707e-09,  4.073821315222765e-12,
 -1.573965085836525e-14,  5.727796136659796e-17, -2.216625167848086e-19,  5.811352099609890e-22, -4.811055556732991e-24, -2.089947789602085e-26, -3.360479727084084e-28,
  2.083357363133226e-02, -1.348609641612813e-04,  6.506919494966359e-07, -2.770994731608447e-09,  1.091162252342849e-11, -4.103482694132651e-14,  1.432733259308387e-16,
 -5.306460346696067e-19,  1.183067908803386e-21, -1.135486869257400e-23, -6.775153324288459e-26, -8.978463280591669e-28,  4.088505487044146e-02, -2.638116910229380e-04,
  1.261581446033752e-06, -5.280474849273419e-09,  2.019474167272323e-11, -7.260835161557666e-14,  2.355322541604182e-16, -8.025902862191606e-19,  1.153030618536068e-21,
 -1.706592493545980e-23, -1.567758128089041e-25, -1.681938662696693e-27,  6.769875301437357e-02, -4.349199583001465e-04,  2.054449284498656e-06, -8.392130100821936e-09,
  3.074901480711880e-11, -1.030540335370317e-13,  2.936354488126162e-16, -8.435052848844715e-19, -3.470908660517068e-22, -1.894198311188232e-23, -2.987672120877368e-25,
 -2.684483955890993e-27,  1.013423822641047e-01, -6.473977429328610e-04,  3.009432811774063e-06, -1.189609922971955e-08,  4.100382567981871e-11, -1.229622659758416e-13,
  2.703938288408096e-16, -4.576015141429649e-19, -3.963618981550228e-21, -1.601940853447915e-23, -4.910121577494565e-25, -3.988287365321428e-27,  1.419011500554280e-01,
 -9.001514754894435e-04,  4.099972997224964e-06, -1.551878116028534e-08,  4.899855359582865e-11, -1.214726947901186e-13,  1.188379232580428e-16,  4.931582021492962e-19,
 -9.754459604719594e-21, -1.152757672787397e-23, -7.082519199717267e-25, -5.788606102587406e-27,  1.894779709520534e-01, -1.191695129377966e-03,  5.291496548859807e-06,
 -1.891548622858022e-08,  5.240756681417120e-11, -8.718783262655799e-14, -1.974186049956404e-16,  2.009326495854970e-18, -1.673338552220049e-20, -1.472525279103446e-23,
 -9.002743273789155e-25, -8.357367072454546e-27,  2.441935106208045e-01, -1.520028886438620e-03,  6.539656732387752e-06, -2.166217479899888e-08,  4.860141323296989e-11,
 -9.646906391951368e-15, -6.893247029260064e-16,  3.854840201364202e-18, -2.244389753465341e-20, -4.133448019659053e-23, -1.004630721371226e-24, -1.189954116967678e-26,
  3.061858645837525e-01, -1.882470381162790e-03,  7.788020573580898e-06, -2.324727586045238e-08,  3.477381392710153e-11,  1.183464613038253e-13, -1.321893280241099e-15,
  5.447245205519292e-18, -2.275825093440042e-20, -1.106969427339803e-22, -9.858432147804976e-25, -1.626860990337992e-26,  3.756095488573009e-01, -2.275419348138985e-03,
  8.965064456015649e-06, -2.306569868702428e-08,  8.183771820220195e-12,  2.971283533447559e-13, -1.987446111704571e-15,  5.764518277470957e-18, -1.228924540887070e-20,
 -2.367591109104202e-22, -9.118034958061171e-25, -2.058138721198864e-26,  4.526332646562606e-01, -2.694027230037128e-03,  9.980324819760334e-06, -2.041932297418093e-08,
 -3.340577827663296e-11,  5.147695414901448e-13, -2.474042647236497e-15,  3.334698287916835e-18,  1.388743071927952e-20, -4.092596354351246e-22, -1.064483887286842e-24,
 -2.298308325429098e-26,  5.374355314962951e-01, -3.131729276197071e-03,  1.071957251269069e-05, -1.453242571789528e-08, -9.096036244543742e-11,  7.392734547825089e-13,
 -2.436191047422816e-15, -3.549403990170688e-18,  5.609349549654473e-20, -5.629454590426675e-22, -2.033675194819786e-24, -2.127211205955591e-26,  6.301966421194296e-01,
 -3.579575390207628e-03,  1.103900458032984e-05, -4.598476488350035e-09, -1.628684962547686e-10,  9.080855911862488e-13, -1.388669351401199e-15, -1.611373635583712e-17,
  1.021380807825652e-19, -5.417609354652418e-22, -4.617927925637049e-24, -1.581132052641180e-26,  7.310842534973071e-01, -4.025264054725497e-03,  1.075883535695444e-05,
  1.011013804562247e-08, -2.427895303754060e-10,  9.159931225168301e-13,  1.225139968159309e-15, -3.341303137378428e-17,  1.152841727681700e-19, -9.491598067259495e-23,
 -9.112550490517529e-24, -1.639605617272359e-26,  8.402278591525891e-01, -4.451737382024745e-03,  9.657699550750082e-06,  3.000966359975445e-08, -3.162669019468280e-10,
  6.068233742034719e-13,  5.777239130280695e-15, -4.906548982621582e-17,  2.339730844812754e-20,  9.837049136239774e-22, -1.330895001607904e-23, -5.093760879683561e-26,
  9.576735451754235e-01, -4.835134476379919e-03,  7.471853652151649e-06,  5.473948095573373e-08, -3.558586025253646e-10, -2.138587305508304e-13,  1.179454939679980e-14,
 -4.639087798236739e-17, -2.664454737158089e-19,  2.333739154091508e-21, -9.201387462801196e-24, -1.552905969372703e-25,  1.083303141324350e+00, -5.141842732260780e-03,
  3.909384512116057e-06,  8.227246422654210e-08, -3.155904850051668e-10, -1.699355637114884e-12,  1.659019339404769e-14,  4.462976940716091e-18, -7.573714593088220e-19,
  1.897419683358089e-21,  1.631410815830621e-23, -2.778107528710867e-25,  1.216687819708216e+00, -5.324419905879045e-03, -1.295758485600814e-06,  1.073234757287910e-07,
 -1.296461508815906e-10, -3.713494614721726e-12,  1.323225776229140e-14,  1.310732536208117e-16, -1.031903696727427e-18, -4.758123425389174e-21,  5.449971612215042e-23,
 -4.664723442612273e-26,  1.356819028099983e+00, -5.316612186514137e-03, -8.232703362365941e-06,  1.188868939170683e-07,  2.670829488836242e-10, -5.256831073599196e-12,
 -9.589175424124832e-15,  2.808514580900082e-16,  1.883886174995469e-19, -1.784191062408663e-20, -5.957205126228615e-24,  9.573847056786871e-25,  1.501608966788204e+00,
 -5.029670928218087e-03, -1.644727042364312e-05,  9.795795747703767e-08,  8.491360313063454e-10, -3.676559104793937e-12, -5.440454909107193e-14,  1.529611762206928e-16,
  3.739905291114528e-18, -7.423423205191133e-21, -2.982288997214585e-22,  2.997377619791024e-27,  1.646971287731321e+00, -4.358996526310183e-03, -2.418811390590995e-05,
  2.187954642484620e-08,  1.272137033048170e-09,  4.299234540727037e-12, -6.850813204589227e-14, -6.323778515485511e-16,  2.547424318953903e-18,  6.305795306856646e-20,
  4.390002592146511e-23, -5.705479459552380e-24,  1.785233189988723e+00, -3.229301773792214e-03, -2.740141954187422e-05, -1.045250318460220e-07,  6.975803414085673e-10,
  1.321548715193629e-11,  5.694781209809489e-14, -6.725727252255490e-16, -1.145027649581133e-17, -3.836251576564227e-20,  8.070482547964302e-22,  1.127793565061811e-23,
  1.902963365119819e+00, -1.738031758812675e-03, -2.066264836082866e-05, -1.796912785668226e-07, -9.677329605363318e-10,  1.367468502485926e-12,  1.054441855425675e-13,
  1.337979366901703e-15,  7.988375255292779e-18, -3.266253816827332e-20, -1.417188088394919e-21, -1.754168043063511e-23,  1.980258387795835e+00, -3.987200934226423e-04,
 -5.896830628126868e-06, -7.508158649625597e-08, -8.592191766253428e-10, -8.916337042095729e-12, -8.286516137704209e-14, -6.597331816173515e-16, -3.883573097448899e-18,
 -3.632028876113273e-21,  3.540828279662417e-22,  7.213687345007725e-24,  8.110931897347757e-04, -5.199571084499582e-06,  2.498020432882809e-08, -1.067858444684382e-10,
  4.262141606735230e-13, -1.651036312853993e-15,  5.976875612326097e-18, -2.437847393543117e-20,  5.087898682867587e-23, -6.963438039356504e-25, -3.802003991833866e-27,
 -3.481155140939792e-29,  7.303075657441553e-03, -4.677195463056747e-05,  2.241011818806527e-07, -9.530859947286001e-10,  3.772282435984775e-12, -1.443752353928199e-14,
  5.130440081719491e-17, -2.060282584272017e-19,  3.892429848225057e-22, -5.949451399112322e-24, -3.584526001534914e-26, -3.074415754872590e-28,  2.030433435960752e-02,
 -1.297855295350097e-04,  6.184610370514881e-07, -2.602792494947988e-09,  1.012412850959423e-11, -3.777068457512239e-14,  1.288796120142068e-16, -4.999304988546439e-19,
  7.157364347945271e-22, -1.487614340775482e-23, -1.078809099682977e-25, -8.258712364692852e-28,  3.984959970513904e-02, -2.539671176846189e-04,  1.200107495706044e-06,
 -4.968676758080796e-09,  1.879730107612389e-11, -6.722169311529633e-14,  2.134744340108099e-16, -7.768824439098257e-19,  4.073939611738917e-22, -2.486390355084031e-23,
 -2.323947835091732e-25, -1.556744662085152e-27,  6.599131817202362e-02, -4.188789767314105e-04,  1.956628831349328e-06, -7.916259670324629e-09,  2.875648409469791e-11,
 -9.629217404044333e-14,  2.697414697434793e-16, -8.680675102585959e-19, -1.273554254851010e-21, -3.333934722821147e-23, -4.200347272668609e-25, -2.496001574817243e-27,
  9.880005361573088e-02, -6.238823247956812e-04,  2.870535962789106e-06, -1.125936401029314e-08,  3.860836018401168e-11, -1.166415777584496e-13,  2.556895167557723e-16,
 -5.978093560785501e-19, -4.937623143360429e-21, -3.929861228925404e-23, -6.713811739542763e-25, -3.709428864543097e-27,  1.383649828673645e-01, -8.680834490117525e-04,
  3.918371825725191e-06, -1.475408091591650e-08,  4.659855461327528e-11, -1.184907471839777e-13,  1.281720213635906e-16,  1.683948246256881e-19, -1.074277701447023e-20,
 -4.512333185692412e-23, -9.690660367667913e-25, -5.358984772390157e-27,  1.847944367501548e-01, -1.150256979575404e-03,  5.069483512292417e-06, -1.809115461530990e-08,
  5.062067109336608e-11, -9.131200986713850e-14, -1.487875281208173e-16,  1.457688572119845e-18, -1.800276520052336e-20, -5.829522170800495e-23, -1.274226318258719e-24,
 -7.685559945562983e-27,  2.382164018939523e-01, -1.468738217712532e-03,  6.284367188517266e-06, -2.088695935427328e-08,  4.825135359486555e-11, -2.497830815331095e-14,
 -5.917290908533524e-16,  3.104024774128852e-18, -2.478436373531104e-20, -9.222606266925009e-23, -1.533910286330963e-24, -1.090908920948402e-26,  2.987788381718234e-01,
 -1.821272458399242e-03,  7.512464212400501e-06, -2.267363282554135e-08,  3.683540108181743e-11,  8.836501353102864e-14, -1.180227726518896e-15,  4.646180220469587e-18,
 -2.762942330776369e-20, -1.647516301057961e-22, -1.709216169980989e-24, -1.500816584742196e-26,  3.666495632200725e-01, -2.204803324975600e-03,  8.689249571403214e-06,
 -2.288975545605446e-08,  1.366216160581529e-11,  2.513139149117849e-13, -1.832887196605447e-15,  5.226035309000683e-18, -2.169316294146123e-20, -2.918467327236915e-22,
 -1.835728297690399e-24, -1.938136319376667e-26,  4.420152772422544e-01, -2.615173083703219e-03,  9.732415375426838e-06, -2.087464597941970e-08, -2.369639405980929e-11,
  4.565492356588895e-13, -2.376734864324582e-15,  3.533093615745796e-18, -1.866217208172013e-21, -4.730063439418964e-22, -2.121927198061151e-24, -2.253412031790094e-26,
  5.250789896138932e-01, -3.046693890846138e-03,  1.053692875521275e-05, -1.587271494419119e-08, -7.676666263447729e-11,  6.797957692052699e-13, -2.513614271635620e-15,
 -2.096316639572452e-18,  3.412098591673895e-20, -6.646289335549641e-22, -3.060829928637634e-24, -2.229342158464777e-26,  6.160545544102548e-01, -3.491527012877573e-03,
  1.096878055389568e-05, -7.061036560336884e-09, -1.450747835050285e-10,  8.696933102690460e-13, -1.797290938627256e-15, -1.319453354457268e-17,  7.912060573487339e-20,
 -7.425076797451869e-22, -5.437099198874951e-24, -1.775100671907779e-26,  7.151560156302635e-01, -3.938772722855992e-03,  1.085745809781398e-05,  6.373351384186943e-09,
 -2.242492833339165e-10,  9.345808613389698e-13,  3.401984529971719e-16, -2.985047174916272e-17,  1.051181878907075e-19, -4.751285105037287e-22, -9.891740440453398e-24,
 -1.492804917130413e-26,  8.225775933801555e-01, -4.373120377358493e-03,  9.987877526058142e-06,  2.505355322912034e-08, -3.028546152205793e-10,  7.291046552083367e-13,
  4.418453794422882e-15, -4.785718453772515e-17,  4.870587204637325e-20,  4.087685397228867e-22, -1.534001798038185e-23, -3.679306387659054e-26,  9.384565801737328e-01,
 -4.772829173018214e-03,  8.094472424859951e-06,  4.902644800247035e-08, -3.574149600036507e-10,  5.273441759265278e-14,  1.038828509363373e-14, -5.365698148288869e-17,
 -1.906518215607946e-19,  1.835041863085017e-21, -1.552325110403265e-23, -1.256277464472361e-25,  1.062804448839600e+00, -5.106706860947594e-03,  4.865305897855255e-06,
  7.697274724044832e-08, -3.455997007605606e-10, -1.302363072539180e-12,  1.638688042347012e-14, -1.857838532683811e-17, -6.803237970751301e-19,  2.299820406623234e-21,
  3.781608536892410e-24, -2.801996728537166e-25,  1.195377507455556e+00, -5.329675237174238e-03, -2.271457698360214e-08,  1.046734118458188e-07, -2.004629287469786e-10,
 -3.355754572528285e-12,  1.641722495340141e-14,  9.572504510211411e-17, -1.164952781653763e-18, -2.673312341541737e-21,  4.853721018405230e-23, -2.102994556620385e-25,
  1.335429983443106e+00, -5.376702654268157e-03, -6.783923367032657e-06,  1.223093022034622e-07,  1.602828989928871e-10, -5.392517120421679e-12, -1.737359029647405e-15,
  2.766369824075170e-16, -4.484287608541513e-19, -1.728008653582251e-20,  3.281367755735807e-23,  7.901292200617300e-25,  1.481234889683102e+00, -5.156322185728733e-03,
 -1.519290965274105e-05,  1.108866365145661e-07,  7.629632180720033e-10, -4.917678738633278e-12, -4.850265890185891e-14,  2.660781512879084e-16,  3.260702966723001e-18,
 -1.904964669720959e-20, -2.756619885912996e-22,  1.019800794525721e-24,  1.629150450998749e+00, -4.551099272742636e-03, -2.380090206898061e-05,  4.282645424625009e-08,
  1.340302050091376e-09,  2.453868960184559e-12, -8.473274431407190e-14, -5.147150808643555e-16,  4.785055555748023e-18,  5.941898275126232e-20, -2.328565782308962e-22,
 -6.656483294144813e-24,  1.771869911198482e+00, -3.453320054664092e-03, -2.857980876122939e-05, -9.118217025802169e-08,  9.738136555227546e-10,  1.431381679528213e-11,
  3.282849657567785e-14, -1.053874312550611e-15, -1.213047352675882e-17,  3.817219315136917e-21,  1.295089326255244e-21,  1.031518719761676e-23,  1.895666611509420e+00,
 -1.912218313272528e-03, -2.291046212652212e-05, -1.948054725618026e-07, -9.118993215545565e-10,  4.375059580617845e-12,  1.462225192521468e-13,  1.562270144634053e-15,
  5.595240033103600e-18, -1.059400368763627e-19, -2.269216318914783e-21, -2.056376585432665e-23,  1.978563103199438e+00, -4.497466492913004e-04, -6.886547282295465e-06,
 -9.037029718395615e-08, -1.059002509642296e-09, -1.114082029952003e-11, -1.030736523251139e-13, -7.826523097614479e-16, -3.668497013860310e-18,  1.850588388241727e-20,
  7.990295983940218e-22,  1.358473076700586e-23,  7.906866333618150e-04, -5.004741700230688e-06,  2.373862569015358e-08, -1.002230189424895e-10,  3.945734426803198e-13,
 -1.515622765585424e-15,  5.313079141353960e-18, -2.318331058518259e-20,  2.278153625403546e-23, -8.696758260241537e-25, -4.514742822822147e-27,  1.426428190672826e-29,
  7.119502443453192e-03, -4.502388876247553e-05,  2.130169716980324e-07, -8.949745172832178e-10,  3.495384145742606e-12, -1.327424429013931e-14,  4.567568592236775e-17,
 -1.972982714071662e-19,  1.466894749397446e-22, -7.569583227663565e-24, -4.201475243904885e-26,  1.339754234939882e-28,  1.979489361915037e-02, -1.249600778584357e-04,
  5.881750462781483e-07, -2.446686408730067e-09,  9.398523244890659e-12, -3.484348860586011e-14,  1.151154043163729e-16, -4.864876831556027e-19,  9.568629063523847e-23,
 -1.968503800990450e-23, -1.238272665222328e-25,  3.998823436111581e-28,  3.885256242058310e-02, -2.445997417425336e-04,  1.142244430742038e-06, -4.678404421762308e-09,
  1.750234296911314e-11, -6.235876020376292e-14,  1.917562158444443e-16, -7.800724279218015e-19, -6.677822880524482e-22, -3.507374417485999e-23, -2.609495656869133e-25,
  8.494461432818412e-28,  6.434651754301320e-02, -4.035982489013902e-04,  1.864331901518639e-06, -7.471219292013215e-09,  2.689338084577507e-11, -9.011588422440028e-14,
  2.446604106999651e-16, -9.314439930781203e-19, -2.796443623404011e-21, -5.158169853242062e-23, -4.635855907987758e-25,  1.503266445596762e-27,  9.634961177484123e-02,
 -6.014481602505125e-04,  2.739054077470649e-06, -1.065996551164445e-08,  3.633543976215445e-11, -1.107252472054929e-13,  2.364875836815338e-16, -7.838939730559722e-19,
 -6.865716899612661e-21, -6.827780604574855e-23, -7.345303697111424e-25,  2.332272933021814e-27,  1.349542393681431e-01, -8.374321744980772e-04,  3.745718656133020e-06,
 -1.402729454303116e-08,  4.425967473681670e-11, -1.153986623660552e-13,  1.277744813060560e-16, -2.092253043561685e-19, -1.310839394441118e-20, -8.697738267022454e-23,
 -1.062412991185602e-24,  3.233429311592943e-27,  1.802731648941379e-01, -1.110555858066803e-03,  4.857188381965258e-06, -1.729601514072836e-08,  4.876168193440165e-11,
 -9.446053046753952e-14, -1.164264165083030e-16,  8.376362870291183e-19, -2.108199915711407e-20, -1.138034922674603e-22, -1.417660317250306e-24,  4.036024315927135e-27,
  2.324404299615267e-01, -1.419452772725368e-03,  6.038336897830045e-06, -2.011967794646301e-08,  4.761633458020475e-11, -3.822998614411241e-14, -5.165080817877847e-16,
  2.245171896549362e-18, -2.930027700446801e-20, -1.602353310732965e-22, -1.756236600317279e-24,  4.570596990484101e-27,  2.916122388790710e-01, -1.762250935318601e-03,
  7.243970268991364e-06, -2.207162466389518e-08,  3.832944282862702e-11,  6.149477588567011e-14, -1.063504954443654e-15,  3.652846705951961e-18, -3.491909353598254e-20,
 -2.425499538449382e-22, -2.039269394400116e-24,  4.837945639610667e-27,  3.579676440225343e-01, -2.136383953848554e-03,  8.416042330773407e-06, -2.263329251789712e-08,
  1.825995106025387e-11,  2.089918756203182e-13, -1.697965815116750e-15,  4.348146115687678e-18, -3.368853014742361e-20, -3.776716398753031e-22, -2.279694874299402e-24,
  5.297908722896994e-27,  4.317087088707010e-01, -2.538321515141084e-03,  9.479936144170067e-06, -2.118380636289333e-08, -1.512791657573028e-11,  4.006716070223268e-13,
 -2.281330953922757e-15,  3.182878181890883e-18, -2.061608546896846e-20, -5.722033655334543e-22, -2.626174109877793e-24,  7.209166930121618e-27,  5.130595704412320e-01,
 -2.963180219750840e-03,  1.033952457414947e-05, -1.699551000520941e-08, -6.377822850011899e-11,  6.188650504595706e-13, -2.560800042708700e-15, -1.412508640080589e-18,
  7.805316992133346e-21, -8.003754783045631e-22, -3.477724489120850e-24,  1.268930166154097e-26,  6.022633562230593e-01, -3.404153852439101e-03,  1.087068701023717e-05,
 -9.245546630151261e-09, -1.281408241008707e-10,  8.223848332780763e-13, -2.135616743231306e-15, -1.113350240756142e-17,  4.834655575946479e-20, -9.682863004723885e-22,
 -5.558342694417122e-24,  2.355967941386269e-26,  6.995750442062276e-01, -3.851666710950900e-03,  1.091302788308659e-05,  2.935061840108704e-09, -2.055418319896805e-10,
  9.330774144495456e-13, -4.516428582166589e-16, -2.683753556057969e-17,  8.081130780002310e-20, -8.743791961381701e-22, -9.701416444262416e-24,  3.702955069186000e-26,
  8.052467071905490e-01, -4.292096019626730e-03,  1.025994475742944e-05,  2.032984549441589e-08, -2.873196810192214e-10,  8.192529508920479e-13,  3.101626089565173e-15,
 -4.618397063540278e-17,  5.210966495183394e-20, -2.225441222657081e-22, -1.570654105622852e-23,  3.598129813184252e-26,  9.194983640165558e-01, -4.705817175402307e-03,
  8.648555225595461e-06,  4.332926999315815e-08, -3.539920975433793e-10,  2.833916267267922e-13,  8.809497548542963e-15, -5.883030679676518e-17, -1.369085833543980e-19,
  1.125920352883394e-21, -1.918614745912348e-23, -2.132474485147051e-26,  1.042461181072345e+00, -5.064185566832459e-03,  5.755010364367612e-06,  7.125592228872440e-08,
 -3.677686340171390e-10, -9.177033650046764e-13,  1.557442058294354e-14, -3.901792091621670e-17, -5.976074178698440e-19,  2.225356269627331e-21, -6.716264231969500e-24,
 -1.698150830175706e-25,  1.174066314730582e+00, -5.324892113385372e-03,  1.211978777678770e-06,  1.009513268198058e-07, -2.634428825392275e-10, -2.933866033536213e-12,
  1.856371851377489e-14,  5.726186889646163e-17, -1.228682776346727e-18, -9.369095987053448e-22,  3.815967308896916e-23, -2.242963486236757e-25,  1.313823976298388e+00,
 -5.425067796163846e-03, -5.304383872399507e-06,  1.240113574835165e-07,  5.263222189145625e-11, -5.343449357432694e-12,  5.716243572159775e-15,  2.526518344885989e-16,
 -1.039022502211251e-18, -1.532770070086453e-20,  6.360229233945131e-23,  6.294502366724038e-25,  1.460375224391669e+00, -5.272343250781826e-03, -1.379246867613455e-05,
  1.222467082878438e-07,  6.536304482989592e-10, -5.981256848928426e-12, -3.970935095095869e-14,  3.574250923898009e-16,  2.389892378399731e-18, -2.888970851363613e-20,
 -2.092937137493624e-22,  1.988752463549693e-24,  1.610569012946413e+00, -4.739083268285466e-03, -2.315706656445038e-05,  6.454885036078687e-08,  1.367973727541295e-09,
  2.665396502493673e-13, -9.669561776128762e-14, -3.297372301441871e-16,  6.686243812018183e-18,  4.431141147502216e-20, -5.175260357320219e-22, -5.962188377564327e-24,
  1.757592827109858e+00, -3.686048409486049e-03, -2.957095220890061e-05, -7.327894946394345e-08,  1.265353857614893e-09,  1.470424044159056e-11, -2.017658506182460e-15,
 -1.429028490770497e-15, -1.096124457869337e-17,  6.353419820722247e-20,  1.654124166981462e-21,  5.286210965830045e-24,  1.887636025896741e+00, -2.105092745554545e-03,
 -2.533212354641770e-05, -2.084899928196070e-07, -7.856743089163734e-10,  8.425361140827285e-12,  1.917642850510441e-13,  1.661017268819107e-15, -6.844043302860642e-20,
 -2.144600349700610e-19, -3.132337699638794e-21, -1.709642305029451e-23,  1.976646633573785e+00, -5.094826957098092e-04, -8.080464324758598e-06, -1.092389558394096e-07,
 -1.308396687474666e-09, -1.388995646246205e-11, -1.264797249124848e-13, -8.818877328609520e-16, -2.258271755057258e-18,  6.520006496507943e-20,  1.613567109017288e-21,
  2.430923303494572e-23,  7.710400161567599e-04, -4.819538335467528e-06,  2.257285004445315e-08, -9.414563485218743e-11,  3.654838452555065e-13, -1.395846190245567e-15,
  4.669213959335048e-18, -2.298688783550216e-20, -1.131470743453830e-23, -1.001532031299857e-24, -9.202863830203690e-28,  1.748322264259758e-28,  6.942748457989185e-03,
 -4.336178082041802e-05,  2.026042611850818e-07, -8.411145610140188e-10,  3.240415584512673e-12, -1.224405240930969e-14,  4.017392410166102e-17, -1.972593301481189e-19,
 -1.518385365571667e-22, -8.806162751992204e-24, -9.375588446939301e-27,  1.581681144353943e-27,  1.930428170069707e-02, -1.203696140473501e-04,  5.596945444913971e-07,
 -2.301739518348235e-09,  8.728176706059781e-12, -3.224452001492364e-14,  1.014237024358907e-16, -4.956362912163031e-19, -6.900688178924987e-22, -2.337739631530623e-23,
 -3.168421259865558e-26,  4.436644550372779e-27,  3.789209040370273e-02, -2.356816822694110e-04,  1.087743435372635e-06, -4.408101771139383e-09,  1.629940237067430e-11,
 -5.802236524202843e-14,  1.694117307009140e-16, -8.234877347833808e-19, -2.093899047545861e-21, -4.297286197455163e-23, -7.660160354978905e-26,  8.811064349324593e-27,
  6.276139619418812e-02, -3.890350321638915e-04,  1.777200566820586e-06, -7.055033775239381e-09,  2.514760915646572e-11, -8.456894917743531e-14,  2.170240251447657e-16,
 -1.053927997564071e-18, -4.945526523639477e-21, -6.581523478862064e-23, -1.523216204809153e-25,  1.478611705305108e-26,  9.398684757509164e-02, -5.800376890735149e-04,
  2.614550592275234e-06, -1.009601407552959e-08,  3.417577531242224e-11, -1.053402246150027e-13,  2.110551047391296e-16, -1.048148638512111e-18, -9.788980239883038e-21,
 -9.108869775616717e-23, -2.611221031973067e-25,  2.242860218804832e-26,  1.316633928600671e-01, -8.081278710925013e-04,  3.581564419411882e-06, -1.333743979973818e-08,
  4.198163456699139e-11, -1.124529478531028e-13,  1.155177016643850e-16, -6.863668492892734e-19, -1.691502857965453e-20, -1.202121848156338e-22, -3.935669990784277e-25,
  3.177244406037565e-26,  1.759073605128173e-01, -1.072515441092881e-03,  4.654254504380584e-06, -1.653108718411211e-08,  4.684601732656567e-11, -9.705371102596268e-14,
 -1.031069799384947e-16,  8.733985513831485e-20, -2.608178852981361e-20, -1.582351362343449e-22, -5.242813866948934e-25,  4.282258940885282e-26,  2.268577213681339e-01,
 -1.372098932828465e-03,  5.801444570725649e-06, -1.936458752249410e-08,  4.673229308360168e-11, -4.998354615774042e-14, -4.677283738431117e-16,  1.202728457308732e-18,
 -3.618597364766835e-20, -2.149808550133378e-22, -6.130818226511611e-25,  5.560734201543618e-26,  2.846774760492169e-01, -1.705348100916996e-03,  6.982826583156234e-06,
 -2.144986883023042e-08,  3.931169303231707e-11,  3.706313948468973e-14, -9.782876662468913e-16,  2.381202743917778e-18, -4.494114240980895e-20, -3.051359209550603e-22,
 -6.179792827421324e-25,  7.031393973509472e-26,  3.495550521669606e-01, -2.070136743058021e-03,  8.146326645755601e-06, -2.230986971240745e-08,  2.204145328647462e-11,
  1.695666924073154e-13, -1.593472158971445e-15,  3.036437171006920e-18, -4.871100944692421e-20, -4.457239544905009e-22, -5.300363647973770e-25,  8.753880468407405e-26,
  4.217054867888153e-01, -2.463502373648924e-03,  9.224533073761289e-06, -2.136469171735681e-08, -7.655253667490727e-12,  3.468948419895122e-13, -2.204678171321717e-15,
  2.175156281099691e-18, -4.283457370924916e-20, -6.481922808820273e-22, -4.421608297749112e-25,  1.086347324155603e-25,  5.013709670186113e-01, -2.881296236402179e-03,
  1.012985334198265e-05, -1.792029582569183e-08, -5.201869351586446e-11,  5.569319403502465e-13, -2.601363082363630e-15, -1.648018347287520e-18, -2.314162337189456e-20,
 -9.008332683913853e-22, -6.567451949707613e-25,  1.359589223949725e-25,  5.888199215624861e-01, -3.317665765482522e-03,  1.074797240174381e-05, -1.116710635933244e-08,
 -1.122301647508737e-10,  7.675303343499891e-13, -2.431221533575722e-15, -1.018323597434500e-17,  1.001964494814793e-20, -1.136831483682034e-21, -1.796802330558731e-24,
  1.723462261519349e-25,  6.843431318087342e-01, -3.764276099093301e-03,  1.092912984634437e-05, -2.051546616780191e-10, -1.870481681261492e-10,  9.134811420964675e-13,
 -1.172127560291566e-15, -2.482473481603244e-17,  4.308751631647500e-20, -1.189519453998943e-21, -4.750795138010553e-24,  2.181235537385190e-25,  7.882439186378989e-01,
 -4.209117510564866e-03,  1.047687282873305e-05,  1.586741917288126e-08, -2.702940499723318e-10,  8.783509797215461e-13,  1.829782474074392e-15, -4.476001017494606e-17,
  3.361176992663005e-20, -7.679617130791616e-22, -9.930022912355363e-24,  2.627509178364615e-25,  9.008166299486103e-01, -4.634644711914290e-03,  9.134745923147481e-06,
  3.772165813401560e-08, -3.463458315940924e-10,  4.745897004572975e-13,  7.105958466770056e-15, -6.270911639031433e-17, -1.098355180195474e-19,  4.067749313354290e-22,
 -1.466462444988492e-23,  2.707767735346542e-25,  1.022301791522483e+00, -5.014826497677548e-03,  6.574234638601700e-06,  6.524469124937769e-08, -3.824841946787694e-10,
 -5.591163539112858e-13,  1.422580121214564e-14, -5.692159043732738e-17, -5.234327448941000e-19,  1.888293251581383e-21, -7.556597953975098e-24,  1.879210401632453e-25,
  1.152793703397812e+00, -5.310426575764492e-03,  2.396247540762796e-06,  9.629149412339243e-08, -3.175580977524899e-10, -2.473560775820585e-12,  1.961353360389007e-14,
  1.768278716521432e-17, -1.236804071028337e-18,  4.540653866831805e-22,  3.369816409471625e-23,  9.721571604679935e-26,  1.292048269412655e+00, -5.461544067989821e-03,
 -3.814691025080862e-06,  1.240083064223253e-07, -5.231336506607503e-11, -5.125616574875881e-12,  1.224587168942312e-14,  2.111192603450722e-16, -1.538361180619608e-18,
 -1.222491411645745e-20,  9.244749637216074e-23,  7.613001608420723e-25,  1.439074701244726e+00, -5.376646781158790e-03, -1.226686537178071e-05,  1.316995586963738e-07,
  5.253260957360695e-10, -6.806558793235869e-12, -2.879757253208146e-14,  4.158335810618426e-16,  1.222854190835566e-18, -3.522469047923319e-20, -1.000944547138374e-22,
  3.005638793623790e-24,  1.591247597308160e+00, -4.920869794951863e-03, -2.225139490021972e-05,  8.635029851962413e-08,  1.349480376328619e-09, -2.139450343917072e-12,
 -1.027242887293639e-13, -9.472550995540860e-17,  7.851428290509441e-18,  1.903482103407359e-20, -7.255352864900822e-22, -3.106610332595954e-24,  1.742370444292387e+00,
 -3.925766977460179e-03, -3.031916817628945e-05, -5.069752612344796e-08,  1.555519208024026e-09,  1.413860591118688e-11, -4.650424189273204e-14, -1.730106159880599e-15,
 -7.448327798651450e-18,  1.319589842655668e-19,  1.702057916496077e-21, -3.601579083616257e-24,  1.878794213025622e+00, -2.317956447673383e-03, -2.790301446457281e-05,
 -2.194469550340715e-07, -5.674112777892146e-10,  1.357752703106834e-11,  2.369014772356604e-13,  1.509844951245090e-15, -1.019388629978777e-17, -3.510934103856763e-19,
 -3.578203840723805e-21, -3.424910710270659e-25,  1.974470581540112e+00, -5.797479905242758e-04, -9.526662721506211e-06, -1.325691353305792e-07, -1.618582268848045e-09,
 -1.722727938734424e-11, -1.517292399803830e-13, -9.017902137845022e-16,  1.548295519902314e-18,  1.556040842219376e-19,  3.029549258144612e-21,  4.120519663402987e-23,
  7.521160109443730e-04, -4.643377197198450e-06,  2.147728673900922e-08, -8.851536006040075e-11,  3.386350462536852e-13, -1.291582669592640e-15,  4.015152665698303e-18,
 -2.391285564135317e-20, -4.539134977183350e-23, -7.945795174903874e-25,  1.394347421851249e-26,  5.437245784128627e-28,  6.772480298379646e-03, -4.178045711680964e-05,
  1.928140498060249e-07, -7.911764647819009e-10,  3.004724817135274e-12, -1.134699774459928e-14,  3.453547226638131e-17, -2.070812770846992e-19, -4.517379578952069e-22,
 -6.978263254310232e-24,  1.249075406764008e-25,  4.909568107713844e-27,  1.883158671307154e-02, -1.160002153002872e-04,  5.328907092432090e-07, -2.167120331051138e-09,
  8.106487700544873e-12, -2.998015488202603e-14,  8.711129751674514e-17, -5.309196991596803e-19, -1.487606139528283e-21, -1.847711585862080e-23,  3.440689222945491e-25,
  1.372542583960330e-26,  3.696643869830991e-02, -2.271869770322771e-04,  1.036373355792117e-06, -4.156381992910288e-09,  1.517770101080337e-11, -5.424217445079541e-14,
  1.451848240127633e-16, -9.148273287420032e-19, -3.563524157062642e-21, -3.381468718997866e-23,  6.675430496634102e-25,  2.715316779228627e-26,  6.123316458149419e-02,
 -3.751493558582405e-04,  1.694899404949014e-06, -6.665930444557595e-09,  2.350582388806761e-11, -7.973456772265200e-14,  1.849432600732817e-16, -1.249579370642244e-18,
 -7.202435337473113e-21, -5.143457808130779e-23,  1.093542965151315e-24,  4.542098048193108e-26,  9.170777524578889e-02, -5.595967555813980e-04,  2.496610635864649e-06,
 -9.565791544878040e-09,  3.211705097421070e-11, -1.006655199051401e-13,  1.768283733515399e-16, -1.413315297330331e-18, -1.291947216594690e-20, -7.050090186102503e-23,
  1.626909780211931e-24,  6.881084723931511e-26,  1.284871886577626e-01, -7.801043038298955e-04,  3.425471627119130e-06, -1.268358316951135e-08,  3.975840997060377e-11,
 -1.099763305688234e-13,  8.806942710729398e-17, -1.296294355591922e-18, -2.104869587065166e-20, -9.195286919881238e-23,  2.284336393136708e-24,  9.765227884249546e-26,
  1.716905282511611e-01, -1.036062303524124e-03,  4.460314182900343e-06, -1.579721488541707e-08,  4.487988559551045e-11, -9.959853920006158e-14, -1.132040842459493e-16,
 -8.375606681498613e-19, -3.151085526106550e-20, -1.197263641126260e-22,  3.098918758421385e-24,  1.323355155322078e-25,  2.214606948813994e-01, -1.326604245170642e-03,
  5.573520881183883e-06, -1.862546911459685e-08,  4.562238839815220e-11, -6.094293189978960e-14, -4.514250335405784e-16, -7.739122646349774e-20, -4.352606537793608e-20,
 -1.618973709953428e-22,  4.121297980256620e-24,  1.733660523036388e-25,  2.779661938404953e-01, -1.650504341026956e-03,  6.729222463726848e-06, -2.081620771138690e-08,
  3.982268438629505e-11,  1.421167862428005e-14, -9.333880195894448e-16,  7.706719486970580e-19, -5.530324292652040e-20, -2.311765870737158e-22,  5.412348306492098e-24,
  2.214928109337632e-25,  3.414031596578456e-01, -2.006030763991418e-03,  7.880829442854128e-06, -2.193212812832791e-08,  2.505626743043369e-11,  1.321527246593205e-13,
 -1.532659709360652e-15,  1.226986878538134e-18, -6.380497250368134e-20, -3.435629119745602e-22,  7.018972110702707e-24,  2.779482432053936e-25,  4.119974438389715e-01,
 -2.390733187797607e-03,  8.967641556107078e-06, -2.143452985592900e-08, -1.242437855536047e-12,  2.945371341493333e-13, -2.166426358882815e-15,  4.402440406894738e-19,
 -6.483356839233622e-20, -5.128719847201814e-22,  8.920960028911581e-24,  3.448180590029758e-25,  4.900064788970392e-01, -2.801130908538124e-03,  9.910172537091453e-06,
 -1.866689556636342e-08, -4.150867870641717e-11,  4.938320256639971e-13, -2.662699738373931e-15, -2.896864338847027e-18, -5.398818966699822e-20, -7.371978962967973e-22,
  1.093776736146561e-23,  4.254488786065843e-25,  5.757203357741165e-01, -3.232247388410174e-03,  1.060368906577925e-05, -1.284325123298883e-08, -9.748612041088652e-11,
  7.057578225229188e-13, -2.718005811562560e-15, -1.051168471776444e-17, -2.962628773832054e-20, -9.717085696311783e-22,  1.260610070181214e-23,  5.244531516590397e-25,
  6.694608078883397e-01, -3.676902407450686e-03,  1.090930867263425e-05, -3.053530866920595e-09, -1.691155240639911e-10,  8.771244633990672e-13, -1.854479367898168e-15,
 -2.414319954319565e-17,  6.358569425658676e-23, -1.083944361137855e-21,  1.313185667113676e-23,  6.459945253160110e-25,  7.715761824690136e-01, -4.124613063308751e-03,
  1.064191991086617e-05,  1.168521228898885e-08, -2.523888863616620e-10,  9.073203373433208e-13,  5.870229446421073e-16, -4.417368553601133e-17,  2.716766460352410e-21,
 -8.065013249481478e-22,  1.180715551362728e-23,  7.874311583225724e-25,  8.824269419082071e-01, -4.559849532419255e-03,  9.554498217611362e-06,  3.226472135334816e-08,
 -3.352928394343007e-10,  6.236754964309628e-13,  5.302469501411721e-15, -6.607049078546159e-17, -1.014797754959645e-19,  2.181841450523457e-22,  9.978423402884183e-24,
  9.249562693733432e-25,  1.002352484036502e+00, -4.959205643251488e-03,  7.320141963000208e-06,  5.905346080510652e-08, -3.903909487295138e-10, -2.386541853117336e-13,
  1.240744985074782e-14, -7.261479550268960e-17, -4.571621530144092e-19,  1.950102691950303e-21,  1.655565438790225e-23,  1.002726280857117e-24,  1.131597528519581e+00,
 -5.286724572659651e-03,  3.519710457196471e-06,  9.084045904944542e-08, -3.623049747800890e-10, -2.001342008247111e-12,  1.955898240118489e-14, -2.135274995436798e-17,
 -1.193260053592862e-18,  2.106699189890060e-21,  5.566525314825655e-23,  1.026003461836298e-24,  1.270150452497865e+00, -5.486131104353087e-03, -2.334939371555831e-06,
  1.223690673783429e-07, -1.514382447544452e-10, -4.766721640209331e-12,  1.740737742595864e-14,  1.556389757899233e-16, -1.902290879955432e-18, -7.676557609859346e-21,
  1.410436440926017e-22,  1.602167903525495e-24,  1.417382041242439e+00, -5.468327806635744e-03, -1.064064235700666e-05,  1.389821978527431e-07,  3.832444147103381e-10,
 -7.354751152029066e-12, -1.680093499959233e-14,  4.341831311786298e-16, -8.208336246742000e-20, -3.620736778527817e-20,  6.141331519910886e-23,  4.449932021593334e-24,
  1.571215171246404e+00, -5.094373205787558e-03, -2.108748836723642e-05,  1.074653351087038e-07,  1.281971370561195e-09, -4.607842553901692e-12, -1.017972460229036e-13,
  1.616945379784975e-16,  7.993543172609922e-18, -1.134715826198804e-20, -7.552007956086573e-22,  2.158808343444254e-24,  1.726179041734789e+00, -4.170309689733246e-03,
 -3.076911963797033e-05, -2.362457780589074e-08,  1.823087536372138e-09,  1.241910354717442e-11, -9.747890272212937e-14, -1.879794523381584e-15, -1.537907609305325e-18,
  1.938692411084203e-19,  1.320535338750945e-21, -1.352273582136741e-23,  1.869059072969723e+00, -2.551845640110363e-03, -3.058085023620713e-05, -2.260306602831137e-07,
 -2.358236885464088e-10,  1.972095159154582e-11,  2.725155760042376e-13,  9.542814849380089e-16, -2.533162014727501e-17, -4.852455057624838e-19, -2.858861515349891e-21,
  3.684931891017584e-23,  1.971988429990690e+00, -6.627923780395966e-04, -1.128491020424630e-05, -1.614290803411988e-07, -2.001533886918735e-09, -2.116007703034734e-11,
 -1.752544441580783e-13, -7.352992222289708e-16,  9.827145416718496e-18,  3.196140117863573e-19,  5.345925122302765e-21,  6.518932601035026e-23,  7.338795390650210e-04,
 -4.475717462169221e-06,  2.044677526839486e-08, -8.329884768211702e-11,  3.137118529777236e-13, -1.203439105351387e-15,  3.322043543961844e-18, -2.565874637292023e-20,
 -5.666364821404215e-23,  4.137961137070827e-25,  5.129102631650444e-26,  1.204411306960891e-27,  6.608384496729403e-03, -4.027512086828865e-05,  1.836010372074379e-07,
 -7.448733564338261e-10,  2.785594452076594e-12, -1.058954477961319e-14,  2.850680632900382e-17, -2.240804797550349e-19, -5.471776457711678e-22,  3.891829447185432e-24,
  4.620505627285359e-25,  1.087112002091532e-26,  1.837595045578273e-02, -1.118389512949161e-04,  5.076440550876871e-07, -2.042104917302365e-09,  7.526557233005280e-12,
 -2.807373785367972e-14,  7.150608732984574e-17, -5.850797573753668e-19, -1.721024701200145e-21,  1.170116853625839e-23,  1.286180638722880e-24,  3.037193245803778e-26,
  3.607396259987340e-02, -2.190914494492473e-04,  9.879186202184105e-07, -3.922037156703048e-09,  1.412555656604449e-11, -5.107888017475614e-14,  1.178428574002528e-16,
 -1.040355780899691e-18, -3.936268769585532e-21,  2.534968194698676e-23,  2.530392733676908e-24,  6.004110715654496e-26,  5.975918780617429e-02, -3.619038513866210e-04,
  1.617112921420982e-06, -6.302366009813475e-09,  2.195254446465959e-11, -7.574312960884415e-14,  1.465367987100446e-16, -1.496511578964150e-18, -7.658064806901472e-21,
  4.659365381695516e-23,  4.208458969698901e-24,  1.003801017434293e-25,  8.950861912649510e-02, -5.400744442345701e-04,  2.384838643058915e-06, -9.067808947842425e-09,
  3.014272476878631e-11, -9.694495667474145e-14,  1.312159533246155e-16, -1.847621950084026e-18, -1.336407934141059e-20,  7.681210765881595e-23,  6.345545252426141e-24,
  1.520621290661082e-25,  1.254206300838513e-01, -7.532986950024069e-04,  3.277013186984156e-06, -1.206494372152877e-08,  3.757667674753861e-11, -1.083765194867685e-13,
  4.202870449402875e-17, -1.995011967704858e-18, -2.140545073999671e-20,  1.161612637167229e-22,  8.983596833368745e-24,  2.159474699423703e-25,  1.676164605086739e-01,
 -1.001126001443441e-03,  4.274989833271483e-06, -1.509523016392040e-08,  4.285824461800179e-11, -1.027136026886057e-13, -1.511724190478150e-16, -1.877157379885270e-18,
 -3.181505470854353e-20,  1.625527022887323e-22,  1.218695373290106e-23,  2.931213500030062e-25,  2.162420560911946e-01, -1.282897787822111e-03,  5.354352862989155e-06,
 -1.790585405046759e-08,  4.429418145925650e-11, -7.196434768328195e-14, -4.736392620071908e-16, -1.513583109426798e-18, -4.405989598181347e-20,  2.106094334882819e-22,
  1.604637321240232e-23,  3.849745107855627e-25,  2.714702773144776e-01, -1.597658893801520e-03,  6.483256397176594e-06, -2.017798437120693e-08,  3.988359375264061e-11,
 -8.136315232861844e-15, -9.374081830081709e-16, -1.067287398424572e-18, -5.675221204627749e-20,  2.509968670706589e-22,  2.067781750235885e-23,  4.933583841158277e-25,
  3.335034729013621e-01, -1.944029867365857e-03,  7.620130075484140e-06, -2.151207459377385e-08,  2.733303474780690e-11,  9.554163426525151e-14, -1.528198358598857e-15,
 -9.294427441559327e-19, -6.738069372712109e-20,  2.710189063058554e-22,  2.620938722412190e-23,  6.208594748082348e-25,  4.025763644184501e-01, -2.320020821379442e-03,
  8.710493168207916e-06, -2.141010815454621e-08,  4.128088637507933e-12,  2.424426371698033e-13, -2.185226876905039e-15, -1.824943425253522e-18, -7.223377387159932e-20,
  2.583054057813107e-22,  3.274576503587681e-23,  7.712384928340909e-25,  4.789590843611226e-01, -2.722756101675060e-03,  9.682499554614007e-06, -1.925552482871739e-08,
 -3.227875488550847e-11,  4.287382088467787e-13, -2.771136353900694e-15, -4.920247401269890e-18, -6.693169609907949e-20,  2.110321139578283e-22,  4.029689290711885e-23,
  9.500267089441704e-25,  5.629599931084799e-01, -3.148059818948890e-03,  1.044066542384493e-05, -1.429375455594356e-08, -8.404779990389511e-11,  6.368590746343700e-13,
 -3.029862932900317e-15, -1.186744881642452e-17, -4.849531219015765e-20,  1.603836288349476e-22,  4.866705394208470e-23,  1.165046799513776e-24,  6.549274519251654e-01,
 -3.589819190598284e-03,  1.085700165183030e-05, -5.621687831909421e-09, -1.520730001962160e-10,  8.244742277397722e-13, -2.535225727096431e-15, -2.459695373632427e-17,
 -2.085907624889717e-20,  2.121913366888535e-22,  5.735886898025041e-23,  1.425949372146778e-24,  7.552487939151427e-01, -4.038984081597031e-03,  1.075851328697339e-05,
  7.792506185758007e-09, -2.342018250826491e-10,  9.065547189768889e-13, -6.518767877317229e-16, -4.437821133349922e-17, -7.273584885142382e-21,  6.060248924120905e-22,
  6.576263568255772e-23,  1.740275050022245e-24,  8.643427404189792e-01, -4.481955049945568e-03,  9.909919050497230e-06,  2.700610296680535e-08, -3.216984330568189e-10,
  7.283804283809208e-13,  3.409308972985427e-15, -6.901801340731288e-17, -7.392088377009590e-20,  1.737016200449292e-21,  7.453578501212979e-23,  2.101431115433272e-24,
  9.826371215376255e-01, -4.897916388955123e-03,  7.991198900378261e-06,  5.278448013153069e-08, -3.923591783360409e-10,  3.314491097373208e-14,  1.018149799648585e-14,
 -8.588477673097952e-17, -3.610247270052672e-19,  3.875917772768984e-21,  9.042419895716909e-23,  2.469705948990331e-24,  1.110513706542477e+00, -5.254307971577866e-03,
  4.573775679626724e-06,  8.474858980651627e-08, -3.977080251094683e-10, -1.543327682369083e-12,  1.844162867602210e-14, -5.777937710109360e-17, -1.062398341456193e-18,
  5.695260927375688e-21,  1.367707503205706e-22,  2.811287185095798e-24,  1.248177801588964e+00, -5.498985186392158e-03, -8.841173977739646e-07,  1.192074342898648e-07,
 -2.422783971919170e-10, -4.303741089670367e-12,  2.088019054999129e-14,  9.159801646727865e-17, -2.055852839385522e-18, -1.407110240096784e-22,  2.499068328794666e-22,
  3.546344757952675e-24,  1.395349174657788e+00, -5.546688858626673e-03, -8.940978373930912e-06,  1.439195527893987e-07,  2.330953438987223e-10, -7.613562197875955e-12,
 -4.870763747990937e-15,  4.115936804848955e-16, -1.288641708330483e-18, -2.921500454088644e-20,  3.055539365086463e-22,  6.834822231664474e-24,  1.550508927943160e+00,
 -5.257573937042915e-03, -1.967830081874414e-05,  1.271089311508675e-07,  1.165896947357364e-09, -6.968321530046967e-12, -9.379000291396373e-14,  4.054283939496290e-16,
  7.082747013108767e-18, -3.758793003943384e-20, -5.019895379652042e-22,  9.674588830097016e-24,  1.709004425398473e+00, -4.417082784521282e-03, -3.086986226175916e-05,
  7.386857081172729e-09,  2.043811148942247e-09,  9.449219755085557e-12, -1.496876600460407e-13, -1.808446260479093e-15,  6.228293734964578e-18,  2.326343178550554e-19,
  5.769151170782609e-22, -1.902564850233072e-23,  1.858345170394263e+00, -2.807373735468802e-03, -3.330166990961512e-05, -2.262859036758953e-07,  2.256189276681606e-10,
  2.647353004375357e-11,  2.851262972551947e-13, -1.537992985030880e-16, -4.432457686630712e-17, -5.511104887206387e-19,  6.345363635636923e-26,  9.630671535057338e-23,
  1.969143620402358e+00, -7.613983524556544e-04, -1.342892960611900e-05, -1.970739755834852e-07, -2.468229540254631e-09, -2.556545422410093e-11, -1.893813841413394e-13,
 -1.893645172467621e-16,  2.594789236650806e-17,  5.989991867097754e-19,  8.826932765915790e-21,  9.292147249579999e-23,  };
  constexpr double w[9600] = {  1.230283907446598e-01, -6.586150474127330e-04,  3.783351741309412e-06, -2.274296584048054e-08,  1.400217252686490e-10,
 -8.703090793560206e-13,  5.415078030764665e-15, -3.358042976329905e-17,  2.071099255926054e-19, -1.269429431532944e-21,  7.730945796859055e-24, -4.678803471988207e-26,
  1.216707292538252e-01, -1.089471584378110e-03,  1.112063361602183e-05, -1.095400081113149e-07,  1.026462132608195e-09, -9.225439575438047e-12,  8.015568856358639e-14,
 -6.771001393217433e-16,  5.583530666653537e-18, -4.508370702547086e-20,  3.572781885960463e-22, -2.783950940677009e-24,  1.190179258256433e-01, -1.916918817104627e-03,
  2.960826186701456e-05, -4.044727633748311e-07,  5.065639767247569e-09, -5.945056393006343e-11,  6.625018615740450e-13, -7.072455492050086e-15,  7.278919314562890e-17,
 -7.256918862500498e-19,  7.034556863565451e-21, -6.649147090755193e-23,  1.151888458822488e-01, -3.076402699905824e-03,  6.593581569491301e-05, -1.189954940216167e-06,
  1.914350231931392e-08, -2.826521869842868e-10,  3.898876926587689e-12, -5.084728665289841e-14,  6.323217407944433e-16, -7.545895107059571e-18,  8.683905227903408e-20,
 -9.673614907193424e-22,  1.103473176278833e-01, -4.480357702641916e-03,  1.280187997921620e-04, -2.962720989888778e-06,  5.956979578553130e-08, -1.078829898946058e-09,
  1.798966021041457e-11, -2.802934810384940e-13,  4.123373061793192e-15, -5.771765040875842e-17,  7.733424297548855e-19, -9.963825050085902e-21,  1.046872568700110e-01,
 -6.027582627426316e-03,  2.230166605794958e-04, -6.459674621972946e-06,  1.588841315817446e-07, -3.461639997054469e-09,  6.854116105118837e-11, -1.254600830077115e-12,
  2.148840736028455e-14, -3.474987188671171e-16,  5.342639623077457e-18, -7.850601035120723e-20,  9.841640792145313e-02, -7.613261705916991e-03,  3.554584593374179e-04,
 -1.261876142582815e-05,  3.729143520691841e-07, -9.618324361640205e-09,  2.228241944570851e-10, -4.726173236501705e-12,  9.303351969710469e-14, -1.716854644741009e-15,
  2.993385586212751e-17, -4.960071149399731e-19,  9.174078582261778e-02, -9.138225181656924e-03,  5.258602146331739e-04, -2.245734636800162e-05,  7.848733275837103e-07,
 -2.363082907561613e-08,  6.323788555903401e-10, -1.535907626051626e-11,  3.436297132908189e-13, -7.160641433038991e-15,  1.401664708128004e-16, -2.593964822995397e-18,
  8.485152121896863e-02, -1.051634850444221e-02,  7.300770712382183e-04, -3.687928856223993e-05,  1.502630804583390e-06, -5.214594338361785e-08,  1.593539741706328e-09,
 -4.385118760029181e-11,  1.104058701234356e-12, -2.573666843481334e-14,  5.605845171063280e-16, -1.148834948385867e-17,  7.791519455655228e-02, -1.167944915945780e-02,
  9.594538441267962e-04, -5.644820719760143e-05,  2.646230900154186e-06, -1.046222327887425e-07,  3.612631267507482e-09, -1.115438057380826e-10,  3.131825172125774e-12,
 -8.097354610685909e-14,  1.946736481361770e-15, -4.383888056255305e-17,  7.106806222353847e-02, -1.257953264894790e-02,  1.201669984694579e-03, -8.117897786164713e-05,
  4.325298445742003e-06, -1.927183620600476e-07,  7.445605219060142e-09, -2.556121118872789e-10,  7.935949398839130e-12, -2.257738703182800e-13,  5.946213545687335e-15,
 -1.460865784241414e-16,  6.441396935856679e-02, -1.318865773721513e-02,  1.442058277517524e-03, -1.103980615588946e-04,  6.609419953313747e-06, -3.285082154740236e-07,
  1.406903738093435e-08, -5.324533577115809e-10,  1.813395782932578e-11, -5.634212209427764e-13,  1.614044767966623e-14, -4.296989486556988e-16,  5.802530890696381e-02,
 -1.349696941781202e-02,  1.665128103344278e-03, -1.427075997142591e-04,  9.497638015551018e-06, -5.215302087848699e-07,  2.454169220857416e-08, -1.015571937994752e-09,
  3.765339563355024e-11, -1.268518126160003e-12,  3.925987177011647e-14, -1.125314927586651e-15,  5.194616017613227e-02, -1.350956718494915e-02,  1.856039968881146e-03,
 -1.760644465313872e-04,  1.289468258578751e-05, -7.751199036623268e-07,  3.974090404820601e-08, -1.784156889688063e-09,  7.148716950233312e-11, -2.593448023400679e-12,
  8.615185745395743e-14, -2.642223045279745e-15,  4.619670568456998e-02, -1.324285665301154e-02,  2.001839236592582e-03, -2.079610860707947e-04,  1.660088139052454e-05,
 -1.082879257505265e-06,  6.000365734189372e-08, -2.900592714773384e-09,  1.247127274676729e-10, -4.839704304940028e-12,  1.714724870710144e-13, -5.593264813094999e-15,
  4.077813191696791e-02, -1.272091817215813e-02,  2.092338748055018e-03, -2.356770289503172e-04,  2.032002970338945e-05, -1.426334692062329e-06,  8.475441054604446e-08,
 -4.379421722258309e-09,  2.006727774248427e-10, -8.276312658627741e-12,  3.108326587601500e-13, -1.072054892962373e-14,  3.567740534971670e-02, -1.197226645975228e-02,
  2.120619806714986e-03, -2.565601708930698e-04,  2.368568022989111e-05, -1.774724704749666e-06,  1.122387353200450e-07, -6.155554592234228e-09,  2.985954851481260e-10,
 -1.300531860865942e-11,  5.146474205351890e-13, -1.866067385133899e-14,  3.087152327174492e-02, -1.102721267675311e-02,  2.083183547266867e-03, -2.682978707821762e-04,
  2.630243224897611e-05, -2.087439372258355e-06,  1.394837475738242e-07, -8.063492526138580e-09,  4.113838337426165e-10, -1.880529106343777e-11,  7.794748573830313e-13,
 -2.954602605914885e-14,  2.633102876347510e-02, -9.915903001713612e-03,  1.979823457091136e-03, -2.691449293937684e-04,  2.779582664547189e-05, -2.319018695584089e-06,
  1.625644421716076e-07, -9.839553302722072e-09,  5.246002317192708e-10, -2.501556176614513e-11,  1.079793920176474e-12, -4.255066815865938e-14,  2.202272839152096e-02,
 -8.667008844991810e-03,  1.813305307823641e-03, -2.580868942539170e-04,  2.786296876460192e-05, -2.425977435056241e-06,  1.771772319301161e-07, -1.115432102465443e-08,
  6.175830898501894e-10, -3.053659520054829e-11,  1.364801137964142e-12, -5.560615661409463e-14,  1.791165344798733e-02, -7.306984810658115e-03,  1.588938053757042e-03,
 -2.349289685948268e-04,  2.631611373206426e-05, -2.374235866764851e-06,  1.794306341416653e-07, -1.167355936240561e-08,  6.670618993873011e-10, -3.399877223525300e-11,
  1.564472890962990e-12, -6.554716098039353e-14,  1.396236694409976e-02, -5.859785981207187e-03,  1.314105233700068e-03, -2.003109519620301e-04,  2.311288887587878e-05,
 -2.145722502270652e-06,  1.666872209756393e-07, -1.113547610502484e-08,  6.527212753606280e-10, -3.409204577504464e-11,  1.606108342938543e-12, -6.882678386827191e-14,
  1.013976185273875e-02, -4.346942411546422e-03,  9.978087078196210e-04, -1.556561030587549e-04,  1.836913709337896e-05, -1.742822423430165e-06,  1.382562260061585e-07,
 -9.424387837183410e-09,  5.632499149634123e-10, -2.997320093918491e-11,  1.437642798196926e-12, -6.267736076238692e-14,  6.409668727030530e-03, -2.787976226976012e-03,
  6.502740614873480e-04, -1.030686798510470e-04,  1.235329912321053e-05, -1.189764295142335e-06,  9.575785436761891e-08, -6.619007600221509e-09,  4.009253923386743e-10,
 -2.161213254681409e-11,  1.049553286450009e-12, -4.630559774484638e-14,  2.743140481524855e-03, -1.202730075707712e-03,  2.830182304165716e-04, -4.525549165383058e-05,
  5.470900899149644e-06, -5.313103896315285e-07,  4.310685701797467e-08, -3.002769209711337e-09,  1.832417944021826e-10, -9.948755382395953e-12,  4.864834285132983e-13,
 -2.160567157878792e-14,  1.204527877976266e-01, -6.294030884608266e-04,  3.523325863948240e-06, -2.063511315966463e-08,  1.238427007391555e-10, -7.509215095172870e-13,
  4.561144397058196e-15, -2.762822162217286e-17,  1.665146294187565e-19, -9.976816660536201e-22,  5.940971117575204e-24, -3.516355286905528e-26,  1.174828245053129e-01,
 -1.005498612319434e-03,  9.898926892576249e-06, -9.449426233732704e-08,  8.597533653721056e-10, -7.510425318935273e-12,  6.347267396504714e-14, -5.218598832289388e-16,
  4.190777674764422e-18, -3.296833414872276e-20,  2.546587832438334e-22, -1.934878115590618e-24,  1.117950755681618e-01, -1.698174628994022e-03,  2.520427795227698e-05,
 -3.321336004477906e-07,  4.020853096043238e-09, -4.568598908536218e-11,  4.935116404368031e-13, -5.112135695754132e-15,  5.109609123669566e-17, -4.950810529705390e-19,
  4.667018935385578e-21, -4.292345023756371e-23,  1.038545950933046e-01, -2.601225825549538e-03,  5.332282086511517e-05, -9.242450419109826e-07,  1.432170017023953e-08,
 -2.041063016251780e-10,  2.721932183087144e-12, -3.436421137100026e-14,  4.141443522790616e-16, -4.794092668515292e-18,  5.356105813697974e-20, -5.796702497222969e-22,
  9.426991068152553e-02, -3.583714578169482e-03,  9.754211393162365e-05, -2.161181316446089e-06,  4.174463522115788e-08, -7.280724705070523e-10,  1.171441373295952e-11,
 -1.763838354694394e-13,  2.510790468396087e-15, -3.404579476652736e-17,  4.423324841823498e-19, -5.531048012072704e-21,  8.370899741131163e-02, -4.515032346117669e-03,
  1.587287116225391e-04, -4.392693869134011e-06,  1.036131770737499e-07, -2.170732065500814e-09,  4.141755750839958e-11, -7.318095523546338e-13,  1.211683565290872e-14,
 -1.896605832935469e-16,  2.825523750713829e-18, -4.027155101445459e-20,  7.281772672937116e-02, -5.286795072880044e-03,  2.343164009439209e-04, -7.940099619634646e-06,
  2.248299851804486e-07, -5.571922693658701e-09,  1.243081409996474e-10, -2.543780429216513e-12,  4.838630189981938e-14, -8.640117443085736e-16,  1.459394275771754e-17,
 -2.345273044571909e-19,  6.215488588176182e-02, -5.827016574753553e-03,  3.184430477105471e-04, -1.298225711550812e-05,  4.347292244544979e-07, -1.257621797913383e-08,
  3.241062987856512e-10, -7.595183492988087e-12,  1.642223959472311e-13, -3.311905319828410e-15,  6.282034591093029e-17, -1.127840375134754e-18,  5.215183077721724e-02,
 -6.104798364320234e-03,  4.031040106934720e-04, -1.945782651090638e-05,  7.602003981817995e-07, -2.536550303060241e-08,  7.469723868830329e-10, -1.984554728916999e-11,
  4.831964620276960e-13, -1.090831588526864e-14,  2.303967357660363e-16, -4.583870501739558e-18,  4.309807247132778e-02, -6.126527164846908e-03,  4.798457145941735e-04,
 -2.702522596183869e-05,  1.216627252215858e-06, -4.631004776597531e-08,  1.542858144448708e-09, -4.604638832883245e-11,  1.251672413987160e-12, -3.137583025903643e-14,
  7.322682047776899e-16, -1.602665730886297e-17,  3.514863973051122e-02, -5.926410538916732e-03,  5.414193704893535e-04, -3.509944373270121e-05,  1.799693908390935e-06,
 -7.734791098585886e-08,  2.888258753092835e-09, -9.600236661113388e-11,  2.890204387214376e-12, -7.984099358986084e-14,  2.044328073246609e-15, -4.888505065128645e-17,
  2.834602675714000e-02, -5.554767904119268e-03,  5.829402571333468e-04, -4.295443387976288e-05,  2.481272860394103e-06, -1.192428274053405e-07,  4.946713575363545e-09,
 -1.816341309272080e-10,  6.010258913406684e-12, -1.816676041474947e-13,  5.068867977597142e-15, -1.315789981089647e-16,  2.264900129677209e-02, -5.067009034889697e-03,
  6.023483448556649e-04, -4.985683368371847e-05,  3.211240933123045e-06, -1.709676337713758e-07,  7.813086268608815e-09, -3.144439688039550e-10,  1.135321890569320e-11,
 -3.729142098205247e-13,  1.126494430447064e-14, -3.154765463987641e-16,  1.796184196272260e-02, -4.515152182670913e-03,  6.002161892123595e-04, -5.519035503102412e-05,
  3.924874280279292e-06, -2.294519737214573e-07,  1.145739389478996e-08, -5.016084021027266e-10,  1.962236235395157e-11, -6.957551163235131e-13,  2.261131944993435e-14,
 -6.790787090321892e-16,  1.415974285190089e-02, -3.942565346780732e-03,  5.791131339188279e-04, -5.853983271832416e-05,  4.553547130993688e-06, -2.898162356822081e-07,
  1.568816795108767e-08, -7.416801246183047e-10,  3.121906835530752e-11, -1.187178914790793e-12,  4.125324714279019e-14, -1.320867351779669e-15,  1.110833305712037e-02,
 -3.381707209353850e-03,  5.427851131282228e-04, -5.972203393183503e-05,  5.035617694896488e-06, -3.460451610490622e-07,  2.015104242082986e-08, -1.021373802190219e-09,
  4.594813760824937e-11, -1.861998311400358e-12,  6.876364275591290e-14, -2.333760438386550e-15,  8.676993025335911e-03, -2.854136071163427e-03,  4.953701557188590e-04,
 -5.876798551693168e-05,  5.324789504570710e-06, -3.919136215185624e-07,  2.436710509087427e-08, -1.314821847805744e-09,  6.279660492643276e-11, -2.694765929621483e-12,
  1.051312597848113e-13, -3.760454809224463e-15,  6.746728434632329e-03, -2.371912519803688e-03,  4.407860816569709e-04, -5.587276573988733e-05,  5.394465577452408e-06,
 -4.219196431687101e-07,  2.780267858050309e-08, -1.585997342090380e-09,  7.989068899231923e-11, -3.607753980372691e-12,  1.478055748497308e-13, -5.540392313878414e-15,
  5.213843233106829e-03, -1.939624167671229e-03,  3.823404018178142e-04, -5.133187972387945e-05,  5.238014580613679e-06, -4.320143093354194e-07,  2.995316349733961e-08,
 -1.794002784745122e-09,  9.468987140433277e-11, -4.471967192403937e-12,  1.912573626468905e-13, -7.470457254563966e-15,  3.990708161111059e-03, -1.556476391202794e-03,
  3.225481960072396e-04, -4.548033869031462e-05,  4.865916830166382e-06, -4.200124379726159e-07,  3.042140682511848e-08, -1.900041696693890e-09,  1.044022322260577e-10,
 -5.124693930990071e-12,  2.274474156989387e-13, -9.205139131763475e-15,  3.004736155712462e-03, -1.218121413391890e-03,  2.631093139282110e-04, -3.864459812943196e-05,
  4.301228551594319e-06, -3.856742104748600e-07,  2.897528942006481e-08, -1.874453607440120e-09,  1.065318261523734e-10, -5.401511760037158e-12,  2.473155036076499e-13,
 -1.031244147296848e-14,  2.196399653065326e-03, -9.180838797320260e-04,  2.049873126297221e-04, -3.111142998164411e-05,  3.574750021028544e-06, -3.305278922382719e-07,
  2.557693338411489e-08, -1.702291233547646e-09,  9.942526805285233e-11, -5.175214207151210e-12,  2.430053919844238e-13, -1.038065578746475e-14,  1.516852060890367e-03,
 -6.487670864761853e-04,  1.485400615357598e-04, -2.311330941058114e-05,  2.720914649087519e-06, -2.575408445122525e-07,  2.038367472804294e-08, -1.386415360346118e-09,
  8.268377984359168e-11, -4.391030669204825e-12,  2.101997595254339e-13, -9.146907903775714e-15,  9.255111817460734e-04, -4.021038493219587e-04,  9.366887508309587e-05,
 -1.482778515520312e-05,  1.774989764174964e-06, -1.707470317435418e-07,  1.372659798039703e-08, -9.477518153729082e-10,  5.734494539928131e-11, -3.087984478707704e-12,
  1.498108819559151e-13, -6.603129446359239e-15,  3.882948027801991e-04, -1.701650296249630e-04,  4.002020637514210e-05, -6.395827988162364e-06,  7.727659020106085e-07,
 -7.500767778311241e-08,  6.082433220869907e-09, -4.234790814560137e-10,  2.582967802796501e-11, -1.401693295032641e-12,  6.850894638754441e-14, -3.041218646916477e-15,
  1.179900264868917e-01, -6.021743857882352e-04,  3.287116369896956e-06, -1.876808225444792e-08,  1.098592611336150e-10, -6.501666285140665e-13,  3.857063576915384e-15,
 -2.283141400616324e-17,  1.345277583512695e-19, -7.882745939272926e-22,  4.591722647738224e-24, -2.659104351192729e-26,  1.136123470653481e-01, -9.306199705662888e-04,
  8.842830347841144e-06, -8.186181703208374e-08,  7.236686294319242e-10, -6.148302491808594e-12,  5.057274977730293e-14, -4.049338404575085e-16,  3.168480428973992e-18,
 -2.429842128470928e-20,  1.830374772295242e-22, -1.356731028635532e-24,  1.053818607860587e-01, -1.511454636643257e-03,  2.157648307362152e-05, -2.745117123548954e-07,
  3.214871197560804e-09, -3.538988988646487e-11,  3.708204865785581e-13, -3.729590049261886e-15,  3.622362206264109e-17, -3.412940564445666e-19,  3.130438670103902e-21,
 -2.802921796406081e-23,  9.423773199611055e-02, -2.215400221004627e-03,  4.348271765583062e-05, -7.245075589363772e-07,  1.082201276445658e-08, -1.489745923370385e-10,
  1.922007771373709e-12, -2.350467270946081e-14,  2.746802314889515e-16, -3.086047852727852e-18,  3.348957756018969e-20, -3.523010754181433e-22,  8.134616288039781e-02,
 -2.896774974934634e-03,  7.518015268355929e-05, -1.596012376634187e-06,  2.963713193104476e-08, -4.981337279978038e-10,  7.738087416993873e-12, -1.126590958323704e-13,
  1.552598814371107e-15, -2.040438415062360e-17,  2.571768179094945e-19, -3.122361130269351e-21,  6.789052333351768e-02, -3.430849443637345e-03,  1.146882144873928e-04,
 -3.034443991573276e-06,  6.868125998978364e-08, -1.384391176343287e-09,  2.546630469590686e-11, -4.345520973266306e-13,  6.958454884054698e-15, -1.054660979918590e-16,
  1.523051225577213e-18, -2.106273653469858e-20,  5.489252373247473e-02, -3.739759687441194e-03,  1.574071712185729e-04, -5.093630783062576e-06,  1.382516828423770e-07,
 -3.293434038950304e-09,  7.078305747489414e-11, -1.397924354120037e-12,  2.570211420955557e-14, -4.442087693270204e-16,  7.270615571674977e-18, -1.133402822829745e-19,
  4.310005770205920e-02, -3.801064224940191e-03,  1.972840733217728e-04, -7.679030156278091e-06,  2.464221876071056e-07, -6.850782898662818e-09,  1.700549979740397e-10,
 -3.845647059898241e-12,  8.036942691526322e-14, -1.568815895151301e-15,  2.883821385396443e-17, -5.023184076547570e-19,  3.295155422210736e-02, -3.640219394225876e-03,
  2.285537467069878e-04, -1.054063538063972e-05,  3.948478454286509e-07, -1.266686812798589e-08,  3.594432296479779e-10, -9.219570802406378e-12,  2.170708046328140e-13,
 -4.745550262503773e-15,  9.718718595927009e-17, -1.877043142223530e-18,  2.460411491844392e-02, -3.313256512110291e-03,  2.472642610608679e-04, -1.332546524183768e-05,
  5.758807723928420e-07, -2.109819141244050e-08,  6.780060638755495e-10, -1.955442424720278e-11,  5.144957328335561e-13, -1.250104201722640e-14,  2.831614923819226e-16,
 -6.021841421157578e-18,  1.800030593457494e-02, -2.887288664609863e-03,  2.520380305475777e-04, -1.566883244668032e-05,  7.726896467123502e-07, -3.201640087688262e-08,
  1.154956325895532e-09, -3.715224001818000e-11,  1.084127108295308e-12, -2.906880273080953e-14,  7.233396629995867e-16, -1.682906484070350e-17,  1.294725030994374e-02,
 -2.424721935666127e-03,  2.439556259296600e-04, -1.728614617966230e-05,  9.626757195507652e-07, -4.469916708482540e-08,  1.794995135736387e-09, -6.390578639365662e-11,
  2.053376527101778e-12, -6.034715260327339e-14,  1.639122695774080e-15, -4.146597615520761e-17,  9.188194828474919e-03, -1.973904504093529e-03,  2.258141561546644e-04,
 -1.803136919972369e-05,  1.122879912790273e-06, -5.791185257627090e-08,  2.568064127095487e-09, -1.004409264962683e-10,  3.529049274157938e-12, -1.129405687086700e-13,
  3.327793792560314e-15, -9.099907896387547e-17,  6.456073004227771e-03, -1.566086727940361e-03,  2.011609261149269e-04, -1.790789658949163e-05,  1.235255896264763e-06,
 -7.016119703507695e-08,  3.408900478040093e-09, -1.454123119663893e-10,  5.549134126661041e-12, -1.921545976010452e-13,  6.104970485263662e-15, -1.794163745053934e-16,
  4.506813970666974e-03, -1.216891478767272e-03,  1.734462635176486e-04, -1.703890116406837e-05,  1.290002440506428e-06, -8.002529796566116e-08,  4.227664274458691e-09,
 -1.952895852577248e-10,  8.040509733595495e-12, -2.993712260634281e-13,  1.019478645599773e-14, -3.201731480282950e-16,  3.135364840520235e-03, -9.300762967658763e-04,
  1.454780234176609e-04, -1.561655559776862e-05,  1.286224126557358e-06, -8.644051654732486e-08,  4.928038463404181e-09, -2.447870480833159e-10,  1.080191059940642e-11,
 -4.297468580186867e-13,  1.559330463922663e-14, -5.203735011959232e-16,  2.179524197509310e-03, -7.017811671973706e-04,  1.192000066942576e-04, -1.385042276497378e-05,
  1.230316438355674e-06, -8.885994440483059e-08,  5.426345999585886e-09, -2.878189819710116e-10,  1.352303058779288e-11, -5.712913992194978e-13,  2.195633285788163e-14,
 -7.741852825431396e-16,  1.516631915158321e-03, -5.241763675234916e-04,  9.571663614461317e-05, -1.192850702466532e-05,  1.133122237995963e-06, -8.726110574766563e-08,
  5.665625210398721e-09, -3.186577195285840e-10,  1.583623072252674e-11, -7.059633255628920e-13,  2.856706999506508e-14, -1.058232591776433e-15,  1.057023205228678e-03,
 -3.880832344594826e-04,  7.545472690217765e-05, -9.995686679164946e-06,  1.006961144009951e-06, -8.203638275911338e-08,  5.621464360133445e-09, -3.329304688928755e-10,
  1.738484431029387e-11, -8.126505740676789e-13,  3.441525080351136e-14, -1.331666172929133e-15,  7.367703956887892e-04, -2.845762785493796e-04,  5.836824273736226e-05,
 -8.147591446550308e-06,  8.632878569663665e-07, -7.382663758260048e-08,  5.299845845943227e-09, -3.282062179576208e-10,  1.788759937765846e-11, -8.712032537355011e-13,
  3.837819097934971e-14, -1.542155618376022e-15,  5.110622335993366e-04, -2.057827143881182e-04,  4.412578339438628e-05, -6.434835150319530e-06,  7.112794360066169e-07,
 -6.335577134802333e-08,  4.729667269960860e-09, -3.041100462964607e-10,  1.718303901962569e-11, -8.663761758508166e-13,  3.945607397439565e-14, -1.636804051172720e-15,
  3.487589607707693e-04, -1.451421056236419e-04,  3.225333817146536e-05, -4.872266736990704e-06,  5.572944936329812e-07, -5.130378190727859e-08,  3.953370658438058e-09,
 -2.620624569441780e-10,  1.524723319642250e-11, -7.907046768749673e-13,  3.699634411406623e-14, -1.575036540261037e-15,  2.281874957086237e-04, -9.735104400764979e-05,
  2.222768920976699e-05, -3.449229891938767e-06,  4.049658713564615e-07, -3.823259507380767e-08,  3.018535587095949e-09, -2.048211631249449e-10,  1.218736067988066e-11,
 -6.458064149678061e-13,  3.084974998451874e-14, -1.339723133648612e-15,  1.340151103364918e-04, -5.815326990858815e-05,  1.352814612714304e-05, -2.138592562365366e-06,
  2.556645888789118e-07, -2.456227588623802e-08,  1.972140151480376e-09, -1.360027150079765e-10,  8.219481654586626e-12, -4.421181687384367e-13,  2.142582430058111e-14,
 -9.433925946066208e-16,  5.503017941233158e-05, -2.410381705599904e-05,  5.665573593939471e-06, -9.049160480283493e-07,  1.092722386556469e-07, -1.060042158695881e-08,
  8.591243781922498e-10, -5.978301885881789e-11,  3.644499934899332e-12, -1.976745703971514e-13,  9.656718659297138e-15, -4.284700708194585e-16,  1.156325373543160e-01,
 -5.767493976791661e-04,  3.072032480642949e-06, -1.710954005298757e-08,  9.773224939963558e-11, -5.648070135835434e-13,  3.274026360375861e-15, -1.894728926532746e-17,
  1.091924980658139e-19, -6.259956752114009e-22,  3.568498552426488e-24, -2.022805542929246e-26,  1.100253970554421e-01, -8.636187924374654e-04,  7.926106412971540e-06,
 -7.120455921271171e-08,  6.119776073912740e-10, -5.059917529300288e-12,  4.053201545227990e-14, -3.162342095242817e-16,  2.412320585319414e-18, -1.804311676047721e-20,
  1.326146873997113e-22, -9.594353076856683e-25,  9.966157042101877e-02, -1.351195707507782e-03,  1.856908753651749e-05, -2.282858921521467e-07,  2.588243342572751e-09,
 -2.762290074701241e-11,  2.809323469253913e-13, -2.745072267720467e-15,  2.592264233800821e-17, -2.376305661377167e-19,  2.121875904489563e-21, -1.850526855560314e-23,
  8.602066836638386e-02, -1.899582455899565e-03,  3.573676442085943e-05, -5.728921157361577e-07,  8.255223193861716e-09, -1.098448413055121e-10,  1.371913511969126e-12,
 -1.626145665190170e-14,  1.843777170645919e-16, -2.011585688321323e-18,  2.121446104222889e-20, -2.170300288370428e-22,  7.085110742531871e-02, -2.364577596544205e-03,
  5.857438125414724e-05, -1.192408749499274e-06,  2.130246091456832e-08, -3.452727623884870e-10,  5.181506671712528e-12, -7.298410434785973e-14,  9.742966325912194e-16,
 -1.241597191535386e-17,  1.518843470319079e-19, -1.791207991009615e-21,  5.579536728411887e-02, -2.642223105155841e-03,  8.405185487517413e-05, -2.127563735548820e-06,
  4.623633597042948e-08, -8.971763270460607e-10,  1.591983645128507e-11, -2.624728075044869e-13,  4.066559032503679e-15, -5.970591856202917e-17,  8.361114393087195e-19,
 -1.122325628894900e-20,  4.211205460044327e-02, -2.691858365732936e-03,  1.076483703390043e-04, -3.328059644095952e-06,  8.662466229983491e-08, -1.984391413431306e-09,
  4.110164539934693e-11, -7.836824306402456e-13,  1.393180169044150e-14, -2.331172916376643e-16,  3.698337336148748e-18, -5.593946877885991e-20,  3.055125285013859e-02,
 -2.533493364510247e-03,  1.249002751180633e-04, -4.642628613917432e-06,  1.428041800851334e-07, -3.816163717652618e-09,  9.125954053767869e-11, -1.991911668233384e-12,
  4.024325944074192e-14, -7.604590662427227e-16,  1.354890191212587e-17, -2.289960439105258e-19,  2.137605102226352e-02, -2.226934437576616e-03,  1.329199114285083e-04,
 -5.856490068854598e-06,  2.103398345850116e-07, -6.487633180741338e-09,  1.773989064757415e-10, -4.392944855488144e-12,  1.000175450773420e-13, -2.117426734878274e-15,
  4.204614057990420e-17, -7.882920184999221e-19,  1.447969048282353e-02, -1.845255054373469e-03,  1.311440020696739e-04, -6.760299305646652e-06,  2.803874376350355e-07,
 -9.884768390570162e-09,  3.063400286935882e-10, -8.536392665636113e-12,  2.173567150568860e-13, -5.118218771794106e-15,  1.124970895272299e-16, -2.324229401421504e-18,
  9.535961834413510e-03, -1.453304169262259e-03,  1.211177906163849e-04, -7.216193123141331e-06,  3.420730859577426e-07, -1.365855509037263e-08,  4.757984473744119e-10,
 -1.480636316620865e-11,  4.186328764277905e-13, -1.089123779687668e-14,  2.632902331945900e-16, -5.957985361929331e-18,  6.134024186465808e-03, -1.096255006669268e-03,
  1.056303028983929e-04, -7.191203343767093e-06,  3.858099197824052e-07, -1.729674264607893e-08,  6.719583322355992e-10, -2.318295314088040e-11,  7.229316477917802e-13,
 -2.064751158768476e-14,  5.456709327862806e-16, -1.344652832313321e-17,  3.872909765182210e-03, -7.977010647663049e-04,  8.771055270390771e-05, -6.749465330610611e-06,
  4.059983764864261e-07, -2.026677367926257e-08,  8.713953073522513e-10, -3.309708457122686e-11,  1.130868009779457e-12, -3.523915575840295e-14,  1.012161659010530e-15,
 -2.700941322512963e-17,  2.412498428313356e-03, -5.638011257176393e-04,  6.987990933679003e-05, -6.015613936846971e-06,  4.020470954434651e-07, -2.216493443163364e-08,
  1.046922541289059e-09, -4.347531609834378e-11,  1.617183559236853e-12, -5.464853022398066e-14,  1.696146511242305e-15, -4.874481721084801e-17,  1.490378626422051e-03,
 -3.896066453820542e-04,  5.380866221487091e-05, -5.130594977967879e-06,  3.776312196601378e-07, -2.280915139702866e-08,  1.174841430437884e-09, -5.297764180316277e-11,
  2.131680935163356e-12, -7.764668445954735e-14,  2.589278292712162e-15, -7.970185743452518e-17,  9.177970649871518e-04, -2.648758836982705e-04,  4.031808804935371e-05,
 -4.217125768499777e-06,  3.388862126963449e-07, -2.224873922947966e-08,  1.240554651339411e-09, -6.033180516789121e-11,  2.609155539103096e-12, -1.018230812515866e-13,
  3.627182655952109e-15, -1.189308900998113e-16,  5.660961974780685e-04, -1.781746618662661e-04,  2.957786819296518e-05, -3.362026461175226e-06,  2.924540129254541e-07,
 -2.070580277347093e-08,  1.240664911628987e-09, -6.462702090653211e-11,  2.984526818187135e-12, -1.240222504609488e-13,  4.691945887466237e-15, -1.629639352267360e-16,
  3.511579347660311e-04, -1.191659673218251e-04,  2.135642757089745e-05, -2.613805535757885e-06,  2.440382020441196e-07, -1.848606285902285e-08,  1.181537100526865e-09,
 -6.546561047216079e-11,  3.207180246781677e-12, -1.410298533722246e-13,  5.632602239492693e-15, -2.060587163287141e-16,  2.197028223782417e-04, -7.952618941858886e-05,
  1.523571057697224e-05, -1.989593865648746e-06,  1.976952346873681e-07, -1.589595700946496e-08,  1.075681252164118e-09, -6.294863281656575e-11,  3.249623817483065e-12,
 -1.502494861815340e-13,  6.296677528369137e-15, -2.412177570732266e-16,  1.387568946542889e-04, -5.303303754961253e-05,  1.075720525627082e-05, -1.485391623580457e-06,
  1.557529751398432e-07, -1.318727684110233e-08,  9.376834091433564e-10, -5.754040353553505e-11,  3.108739999376087e-12, -1.501488291695252e-13,  6.561633422700848e-15,
 -2.616584898397954e-16,  8.822254816689328e-05, -3.526245931687758e-05,  7.501937017332920e-06, -1.085575515435926e-06,  1.191032675674917e-07, -1.053323519132066e-08,
  7.809618403622633e-10, -4.988626861893984e-11,  2.801064758392580e-12, -1.403842996810157e-13,  6.356598724806349e-15, -2.622507861801762e-16,  5.593996040648315e-05,
 -2.316970788056424e-05,  5.122278633017784e-06, -7.698623453220695e-07,  8.762593084146360e-08, -8.028704757964680e-09,  6.158790081386141e-10, -4.064864606423810e-11,
  2.355181069624428e-12, -1.216507042762891e-13,  5.670191052345689e-15, -2.405139421821265e-16,  3.453596296589076e-05, -1.469359715522125e-05,  3.344866227904131e-06,
 -5.175071569378041e-07,  6.058440228784907e-08, -5.703869315609662e-09,  4.491299126457538e-10, -3.039738460145334e-11,  1.804268252672939e-12, -9.538199563717034e-14,
  4.545995237636717e-15, -1.969913009531210e-16,  1.946465935953690e-05, -8.435048605035640e-06,  1.959348893888770e-06, -3.092887790717396e-07,  3.692200254381339e-08,
 -3.542269144458805e-09,  2.840335839938854e-10, -1.956226163488463e-11,  1.180797875228117e-12, -6.343785997570244e-14,  3.070756236163676e-15, -1.350570023584678e-16,
  7.809026736725915e-06, -3.418569241731279e-06,  8.030388628502412e-07, -1.281837912691099e-07,  1.546929992497232e-08, -1.499773316337416e-09,  1.214804724213711e-10,
 -8.448559224094208e-12,  5.147585117833542e-13, -2.790509076105359e-14,  1.362496377133085e-15, -6.042351133836594e-17,  1.133734283894379e-01, -5.529686442214100e-04,
  2.875740876488276e-06, -1.563209738629391e-08,  8.718085868193938e-11, -4.922217096354749e-13,  2.789219392078387e-15, -1.578780318528944e-17,  8.902531039264937e-20,
 -4.995572042439587e-22,  2.787989762422579e-24, -1.547558280323692e-26,  1.066925533161882e-01, -8.034686640888582e-04,  7.127225350218043e-06, -6.217251150726733e-08,
  5.198323828941444e-10, -4.185246428014521e-12,  3.266737564172534e-14, -2.484861358123481e-16,  1.848895367148709e-18, -1.349445920690618e-20,  9.681976594262682e-23,
 -6.840107631789860e-25,  9.453748464059368e-02, -1.212936457828787e-03,  1.606101618030778e-05, -1.909518694523804e-07,  2.097436179020340e-09, -2.171648842501290e-11,
  2.145057896168772e-13, -2.037510552232901e-15,  1.871810398482452e-17, -1.670329555392984e-19,  1.452722561705348e-21, -1.234641168651263e-23,  7.895355060799138e-02,
 -1.639097805362841e-03,  2.958746194735192e-05, -4.567383611166226e-07,  6.353886257384297e-09, -8.177754562363941e-11,  9.893750322286451e-13, -1.137326783254791e-14,
  1.251851893401726e-16, -1.326990188494563e-18,  1.360710817165224e-20, -1.354393355056771e-22,  6.224690366992469e-02, -1.947908023279561e-03,  4.610276252288035e-05,
 -9.006926628743748e-07,  1.549163562840674e-08, -2.422908098547885e-10,  3.514786272421071e-12, -4.792412781292277e-14,  6.200324735047902e-16, -7.665534450101334e-18,
  9.105405058110830e-20, -1.043525059967148e-21,  4.642572246260517e-02, -2.060595290209302e-03,  6.242864545830175e-05, -1.512828637288060e-06,  3.158661935334608e-08,
 -5.903635619997833e-10,  1.011026082950027e-11, -1.611346045093151e-13,  2.416567481252784e-15, -3.438438178174624e-17,  4.671134998458986e-19, -6.088203640325552e-21,
  3.284374716404720e-02, -1.969558095270552e-03,  7.487313573925042e-05, -2.212615590863203e-06,  5.525465603530788e-08, -1.217733177285726e-09,  2.431705590297330e-11,
 -4.477957245008699e-13,  7.699767886900662e-15, -1.247757781643723e-16,  1.919268436230674e-18, -2.817481300931220e-20,  2.211090381958307e-02, -1.723406553644475e-03,
  8.071859449979201e-05, -2.865981178972993e-06,  8.452246188847503e-08, -2.171689890447636e-09,  5.004462100650914e-11, -1.054528648269249e-12,  2.060019912196749e-14,
 -3.769077928256871e-16,  6.509776524211471e-18, -1.067739598150828e-19,  1.421937608031334e-02, -1.396016533401164e-03,  7.920178260840269e-05, -3.333860027889656e-06,
  1.148073761949983e-07, -3.404739167497021e-09,  8.971739524703037e-11, -2.145003157750171e-12,  4.722762387966777e-14, -9.682522492606114e-16,  1.864273360720614e-17,
 -3.392881301602156e-19,  8.773889025299646e-03, -1.057114330396476e-03,  7.151541882579472e-05, -3.525232496277312e-06,  1.402915963643049e-07, -4.758403950962568e-09,
  1.421945286907247e-10, -3.827828329951978e-12,  9.430927530704051e-14, -2.151903656501058e-15,  4.589019914716615e-17, -9.209547925876479e-19,  5.220522926110717e-03,
 -7.550286542372519e-04,  6.002917871290050e-05, -3.425688509049802e-06,  1.560276743263779e-07, -6.001136000834006e-09,  2.018001145999423e-10, -6.073069403970456e-12,
  1.663205101106735e-13, -4.197150497166877e-15,  9.854296277793386e-17, -2.168254551563540e-18,  3.012077206645431e-03, -5.129795564310026e-04,  4.728970828480766e-05,
 -3.090676341600539e-06,  1.596302963128737e-07, -6.905764625042757e-09,  2.593949985119339e-10, -8.667867602718170e-12,  2.621973941333396e-13, -7.274087491086427e-15,
  1.869627678268637e-16, -4.485845288639275e-18,  1.695498980420522e-03, -3.342928195504190e-04,  3.528571758674823e-05, -2.614054402755425e-06,  1.517515384013851e-07,
 -7.326079339314371e-09,  3.051934093605796e-10, -1.124921361594454e-11,  3.735422979455734e-13, -1.132684923194161e-14,  3.169549890279560e-16, -8.249037006428434e-18,
  9.372486386243102e-04, -2.106719898984208e-04,  2.516191330965092e-05, -2.092130639105417e-06,  1.353369506986274e-07, -7.235066017054373e-09,  3.319253669836559e-10,
 -1.340771195807599e-11,  4.857686547886141e-13, -1.600757740452982e-14,  4.850214460488037e-16, -1.362146424610635e-17,  5.123082229693721e-04, -1.294442039454408e-04,
  1.729818349132876e-05, -1.598839440214257e-06,  1.142769743255562e-07, -6.713486437459373e-09,  3.368155521859139e-10, -1.481306123633759e-11,  5.820057857920839e-13,
 -2.072287853220100e-14,  6.761746194353294e-16, -2.038506290015812e-17,  2.788631424986587e-04, -7.817173604236671e-05,  1.156279810270193e-05, -1.176916719225606e-06,
  9.216676884162094e-08, -5.904745899249114e-09,  3.216790724145539e-10, -1.530222451850874e-11,  6.479763308176995e-13, -2.478392557082705e-14,  8.660446531915561e-16,
 -2.787917026492756e-17,  1.522148035036698e-04, -4.676041115230087e-05,  7.576169223443502e-06, -8.413656336912124e-07,  7.158779728930082e-08, -4.963059566295592e-09,
  2.914971599864115e-10, -1.489806527120726e-11,  6.756313742621451e-13, -2.759352876167494e-14,  1.026747349474658e-15, -3.510140250094263e-17,  8.385813465130953e-05,
 -2.790446922077297e-05,  4.902008313121436e-06, -5.885187394091962e-07,  5.394721499641590e-08, -4.015683167843438e-09,  2.524216827568918e-10, -1.376558261113782e-11,
  6.642356318021086e-13, -2.878866806410853e-14,  1.133982350183500e-15, -4.093959549736739e-17,  4.688324109918851e-05, -1.671266685860091e-05,  3.151530363472732e-06,
 -4.052831569371300e-07,  3.968343318855611e-08, -3.146363917053440e-09,  2.100851805309861e-10, -1.213817078997345e-11,  6.190205805383698e-13, -2.828946728300176e-14,
  1.172420552096108e-15, -4.443841097123031e-17,  2.669211292973535e-05, -1.008605598584248e-05,  2.021484682283970e-06, -2.758928924144473e-07,  2.860651295942219e-08,
 -2.396208674711475e-09,  1.686454307065303e-10, -1.024799910344200e-11,  5.485131873374149e-13, -2.625665031098467e-14,  1.137659122335977e-15, -4.499711540060795e-17,
  1.547381592446781e-05, -6.135514927620841e-06,  1.294210492503478e-06, -1.857207329124488e-07,  2.021278385122786e-08, -1.773829112944798e-09,  1.305485933378442e-10,
 -8.280484409789829e-12,  4.618104956743031e-13, -2.299598119426849e-14,  1.034835001059963e-15, -4.244202677581271e-17,  9.070910150644028e-06, -3.737625019445846e-06,
  8.216884823569625e-07, -1.228186383967629e-07,  1.390503992338185e-08, -1.267549632026212e-09,  9.675807129856030e-11, -6.356239856302852e-12,  3.666294830580816e-13,
 -1.885598009160599e-14,  8.752699767663331e-16, -3.698055524202782e-17,  5.261380987485790e-06, -2.231816211116247e-06,  5.063995802086619e-07, -7.809640069016354e-08,
  9.114203949810537e-09, -8.555020859321091e-10,  6.716896357279281e-11, -4.533448869792966e-12,  2.683727370223823e-13, -1.415126854033484e-14,  6.728130081009618e-16,
 -2.908668970350125e-17,  2.836386411205938e-06, -1.227378529380739e-06,  2.846497272731899e-07, -4.486160836634281e-08,  5.347189143895879e-09, -5.122399368947365e-10,
  4.101437270036811e-11, -2.820867622663498e-12,  1.700429445563284e-13, -9.123727984544496e-15,  4.410931996780945e-16, -1.937690364945846e-17,  1.109642516387355e-06,
 -4.854877738935270e-07,  1.139694122594612e-07, -1.818029252988458e-08,  2.192596750465624e-09, -2.124419737709906e-10,  1.719707762377826e-11, -1.195284613674055e-12,
  7.278462916703829e-14, -3.943427376210808e-15,  1.924361448684565e-16, -8.529532143533755e-18,  1.112064101470960e-01, -5.306900699606056e-04,  2.696211588440637e-06,
 -1.431246669260226e-08,  7.797162629519782e-11, -4.302791100321562e-13,  2.384486715298742e-15, -1.320647799825773e-17,  7.289487961393188e-20, -4.005311933732755e-22,
  2.189283352676136e-24, -1.190469443589369e-26,  1.035881807178282e-01, -7.492998435230115e-04,  6.428428659134007e-06, -5.448448535523720e-08,  4.434367980990143e-10,
 -3.478458692004204e-12,  2.647004372043462e-14, -1.964019206532052e-16,  1.426122576155069e-18, -1.016193287064547e-20,  7.120600184333140e-23, -4.914599090651713e-25,
  8.992896679913209e-02, -1.093074798839610e-03,  1.395747059411796e-05, -1.606060599796910e-07,  1.710294332265242e-09, -1.719044837189177e-11,  1.650114267807474e-13,
 -1.524508890874550e-15,  1.363210701465700e-17, -1.184799719698355e-19,  1.004161794307717e-21, -8.320543006993293e-24,  7.283813261274991e-02, -1.422709720266494e-03,
  2.466650323485791e-05, -3.669711033023018e-07,  4.932155733566016e-09, -6.144194796652684e-11,  7.205113199388003e-13, -8.037276038818463e-15,  8.592765783072996e-17,
 -8.854367716418220e-19,  8.832312065850268e-21, -8.557531189535861e-23,  5.512996130260824e-02, -1.618446062682159e-03,  3.663542595102904e-05, -6.874286772383253e-07,
  1.139126620019774e-08, -1.720283195261954e-10,  2.413735117905816e-12, -3.187639469490782e-14,  3.999007941726104e-16, -4.798777054183942e-18,  5.537471714461687e-20,
 -6.169842660125849e-22,  3.907827014118740e-02, -1.626009063795255e-03,  4.695624048606420e-05, -1.090107384061576e-06,  2.188109564203852e-08, -3.941469327319562e-10,
  6.517990533673938e-12, -1.004695230156743e-13,  1.459183630576016e-15, -2.012930448428974e-17,  2.653851627556427e-19, -3.359821777642551e-21,  2.601433954843791e-02,
 -1.463413531766792e-03,  5.291465841780932e-05, -1.495479452497695e-06,  3.584851797691220e-08, -7.604160467658548e-10,  1.464606395526309e-11, -2.605837449384370e-13,
  4.335425030336685e-15, -6.806342094120464e-17,  1.015372518046780e-18, -1.447059450238604e-20,  1.631954429369515e-02, -1.195156681891132e-03,  5.319452766289091e-05,
 -1.804677498795379e-06,  5.104535557451871e-08, -1.261394989699992e-09,  2.801815814924942e-11, -5.701124527641600e-13,  1.077121107407944e-14, -1.908537923024629e-16,
  3.196075261230088e-18, -5.088212991925075e-20,  9.687275228504695e-03, -8.957052611021178e-04,  4.829960113279752e-05, -1.942423917370626e-06,  6.414246656739147e-08,
 -1.829171211287022e-09,  4.645360710827778e-11, -1.072401513018502e-12,  2.283538727770699e-14, -4.534092660960965e-16,  8.465220507739937e-18, -1.495590169029777e-19,
  5.467420099781601e-03, -6.222297704900923e-04,  4.005412915315110e-05, -1.887601742857228e-06,  7.206790354958510e-08, -2.351499048987208e-09,  6.775000706797993e-11,
 -1.761729318962378e-12,  4.199581296292654e-14, -9.284476251194175e-16,  1.920823697714507e-17, -3.744051764773307e-19,  2.950260695024464e-03, -4.044493990613564e-04,
  3.065587669426930e-05, -1.674829020566517e-06,  7.326498368631003e-08, -2.713490564566495e-09,  8.805521003682287e-11, -2.562016328568253e-12,  6.794485160053725e-14,
 -1.662716715751903e-15,  3.790471596762063e-17, -8.107537887616625e-19,  1.531701974943733e-03, -2.482438825019345e-04,  2.187370710723349e-05, -1.371382078795764e-06,
  6.814540914704802e-08, -2.843135664767243e-09,  1.032049148359399e-10, -3.338659677220183e-12,  9.792287935329159e-14, -2.637733253915916e-15,  6.590895720308948e-17,
 -1.539116903484690e-18,  7.705314291215185e-04, -1.452027718798303e-04,  1.469599415737924e-05, -1.047109052966283e-06,  5.861495914507271e-08, -2.734625772282258e-09,
  1.102998432167757e-10, -3.942901701142212e-12,  1.271648149894372e-13, -3.750102304769298e-15,  1.021780118265054e-16, -2.592232123426189e-18,  3.785183780511613e-04,
 -8.169810514098438e-05,  9.390308599702660e-06, -7.532614305212716e-07,  4.711548320489533e-08, -2.440211426833896e-09,  1.086445780583523e-10, -4.265463383284021e-12,
  1.504102987084809e-13, -4.829985962943147e-15,  1.427713878349177e-16, -3.915826310796674e-18,  1.831126023511735e-04, -4.464291739826327e-05,  5.764209029734047e-06,
 -5.158045501493251e-07,  3.576019126370899e-08, -2.041205126629060e-09,  9.965235678037419e-11, -4.270613077920135e-12,  1.637040517305823e-13, -5.693218120780461e-15,
  1.816310954662234e-16, -5.359106540277950e-18,  8.801322787430903e-05, -2.392458380984508e-05,  3.433820274272542e-06, -3.396691207018469e-07,  2.589144286302934e-08,
 -1.616886861396448e-09,  8.597404560563881e-11, -3.996539326069789e-12,  1.655570732398003e-13, -6.200873662779101e-15,  2.123823226951090e-16, -6.707139409221537e-18,
  4.241707201537643e-05, -1.269834721604891e-05,  2.005170459871516e-06, -2.172819391144759e-07,  1.806162766914607e-08, -1.224792108508394e-09,  7.044024996352443e-11,
 -3.528836349769567e-12,  1.570123025010115e-13, -6.296942472455211e-15,  2.302680446252032e-16, -7.742463961665028e-18,  2.068189691942034e-05, -6.738896822838998e-06,
  1.158890668257060e-06, -1.363145349388881e-07,  1.225419492430183e-08, -8.954098259239746e-10,  5.530003017347158e-11, -2.965467814034350e-12,  1.408182875706615e-13,
 -6.010515259797737e-15,  2.333153652442597e-16, -8.306412448114916e-18,  1.028613731279548e-05, -3.606762808599152e-06,  6.686792810941069e-07, -8.459073735632048e-08,
  8.153708919791629e-09, -6.368755356326067e-10,  4.192237923616062e-11, -2.389443295872074e-12,  1.202851129935968e-13, -5.429353712768419e-15,  2.223620819336448e-16,
 -8.333410940403253e-18,  5.251842032668910e-06, -1.960130142357547e-06,  3.878120318665398e-07, -5.226757252727438e-08,  5.354525205361514e-09, -4.433823925489059e-10,
  3.086413051771882e-11, -1.855929981541223e-12,  9.834633322602810e-14, -4.662863823575452e-15,  2.001936537235886e-16, -7.849247841413907e-18,  2.760797393895178e-06,
 -1.085187215780599e-06,  2.267993391607868e-07, -3.225295358577794e-08,  3.479818467886541e-09, -3.028480038964693e-10,  2.211196349184296e-11, -1.391896182073013e-12,
  7.706502908140434e-14, -3.810892654483351e-15,  1.703563588871083e-16, -6.942671533525475e-18,  1.488302167041291e-06, -6.097886795779245e-07,  1.332440821665563e-07,
 -1.979738493233863e-08,  2.228485508998619e-09, -2.020218561118637e-10,  1.533976679769406e-11, -1.002604098098193e-12,  5.755055866989200e-14, -2.946150833127016e-15,
  1.361500377780250e-16, -5.728032950303633e-18,  8.072633003121118e-07, -3.413176717540844e-07,  7.717087055632793e-08, -1.185960035071379e-08,  1.379384639140302e-09,
 -1.290539979945215e-10,  1.010089972585779e-11, -6.797000306622123e-13,  4.012159825466621e-14, -2.109785069996362e-15,  1.000436550701501e-16, -4.314114702809230e-18,
  4.147868746641390e-07, -1.792078922373434e-07,  4.148966140149528e-08, -6.527686937458825e-09,  7.767578035017040e-10, -7.429055489998661e-11,  5.939115549898713e-12,
 -4.078675404406279e-13,  2.455106082394088e-14, -1.315475368961285e-15,  6.351291420557652e-17, -2.786508928156643e-18,  1.579050868172538e-07, -6.904350251447687e-08,
  1.619693506173976e-08, -2.581925997772150e-09,  3.111752025601085e-10, -3.012983357301200e-11,  2.437411129971833e-12, -1.693054268724781e-13,  1.030320240352261e-14,
 -5.578877524998421e-16,  2.720866538946729e-17, -1.205316414560627e-18,  1.091257306087336e-01, -5.097868018003547e-04,  2.531673019641258e-06, -1.313077710711709e-08,
  6.990967645801947e-11, -3.772379609987122e-13,  2.045309383156522e-15, -1.108861920354158e-17,  5.993363445418315e-20, -3.225869904367415e-22,  1.727555476815166e-24,
 -9.206152236606979e-27,  1.006898589618960e-01, -7.003721266613097e-04,  5.814995899678811e-06, -4.791331415181234e-08,  3.798002805045371e-10, -2.904331199405613e-12,
  2.155838386988462e-14, -1.561091921361683e-16,  1.106751253146282e-18, -7.702796887355502e-21,  5.273717836375543e-23, -3.557560308401859e-25,  8.576840505332360e-02,
 -9.886837250319355e-04,  1.218369981705886e-05, -1.357903218619441e-07,  1.402869508924127e-09, -1.369679611232432e-11,  1.278425335896578e-13, -1.149436645060287e-15,
  1.000959633698925e-17, -8.477308243302309e-20,  7.004937339730519e-22, -5.661658750411911e-24,  6.751584604941603e-02, -1.241738406986620e-03,  2.069863231366254e-05,
 -2.970190558650830e-07,  3.859500105660290e-09, -4.656667254318579e-11,  5.296177972933399e-13, -5.736152073360267e-15,  5.959825847153989e-17, -5.972942948039601e-19,
  5.798741252502727e-21, -5.471457775009182e-23,  4.919415282942359e-02, -1.355503248671031e-03,  2.937572958737447e-05, -5.298247898926541e-07,  8.464548254647355e-09,
 -1.235086648103580e-10,  1.677146452808233e-12, -2.146413212556254e-14,  2.612417140421670e-16, -3.044255501651884e-18,  3.414163367001900e-20, -3.699926609874532e-22,
  3.325036223930662e-02, -1.297280910032979e-03,  3.574052981880427e-05, -7.954433533000335e-07,  1.535928311674563e-08, -2.667994141468332e-10,  4.262706091643132e-12,
 -6.357921210011518e-14,  8.946561527611389e-16, -1.197065737937833e-17,  1.532240660288522e-19, -1.884962362627635e-21,  2.090604801496369e-02, -1.103171495858606e-03,
  3.796419560057585e-05, -1.026696445762739e-06,  2.363659090128893e-08, -4.828015790663256e-10,  8.973047134943627e-12, -1.543120491781218e-13,  2.485040529063021e-15,
 -3.780901456617912e-17,  5.472078316895089e-19, -7.573164727856233e-21,  1.227021733948819e-02, -8.440449523389723e-04,  3.571127545965177e-05, -1.158039497079866e-06,
  3.142604637959641e-08, -7.471321949568035e-10,  1.600103945388964e-11, -3.144936303049283e-13,  5.748032233983692e-15, -9.865757947054351e-17,  1.602230429169702e-18,
 -2.476316699310872e-20,  6.751029053849173e-03, -5.875300940939511e-04,  3.011245925321622e-05, -1.157132527932022e-06,  3.664603344197816e-08, -1.005068065740099e-09,
  2.460339674233290e-11, -5.485002244664368e-13,  1.129695754328348e-14, -2.172588636948420e-16,  3.933598510243019e-18, -6.746998380668168e-20,  3.499504288928383e-03,
 -3.758728525222665e-04,  2.301559547689849e-05, -1.036797853052693e-06,  3.797310320113146e-08, -1.191867383257956e-09,  3.310672591414520e-11, -8.315498511910747e-13,
  1.917789124301647e-14, -4.107843280177588e-16,  8.244276209892022e-18, -1.560682790060465e-19,  1.719176929974642e-03, -2.231499240038983e-04,  1.611504413251984e-05,
 -8.425117319349827e-07,  3.538601667164081e-08, -1.261664247833806e-09,  3.950051554710738e-11, -1.110889324499108e-12,  2.852254265879664e-14, -6.767231559401089e-16,
  1.497611395305096e-17, -3.113256901921451e-19,  8.058866987694294e-04, -1.241275745721630e-04,  1.044490428268649e-05, -6.277595626656825e-07,  2.999448181112104e-08,
 -1.206289372989909e-09,  4.229728109920852e-11, -1.324111852112359e-12,  3.764107591660400e-14, -9.841062846026748e-16,  2.389652058673278e-17, -5.429322840121599e-19,
  3.632881632713710e-04, -6.533252214236081e-05,  6.333126954945066e-06, -4.336012564772611e-07,  2.338636344843212e-08, -1.053653949180254e-09,  4.112160912807306e-11,
 -1.424776340359790e-12,  4.460543991287475e-14, -1.278614187348816e-15,  3.390455841973141e-17, -8.380526393415413e-19,  1.588789525045235e-04, -3.287344301222128e-05,
  3.631416676748639e-06, -2.807248950000085e-07,  1.696153096233617e-08, -8.503228721385254e-10,  3.671095468165450e-11, -1.399815333025781e-12,  4.800773546385214e-14,
 -1.501275429113781e-15,  4.326511434341897e-17, -1.158171655123644e-18,  6.806896623944972e-05, -1.598519629990333e-05,  1.991371865675879e-06, -1.723044198425075e-07,
  1.157407281898681e-08, -6.412507877331036e-10,  3.043527022433962e-11, -1.269839300528110e-12,  4.745112738234403e-14, -1.610577895381745e-15,  5.020136407487698e-17,
 -1.448634705355683e-18,  2.887349230759558e-05, -7.597795201314194e-06,  1.056561496869872e-06, -1.014362659144824e-07,  7.516968374843592e-09, -4.570701556233128e-10,
  2.369691169789090e-11, -1.075418634735393e-12,  4.354208106359272e-14, -1.595654424003693e-15,  5.352401848300705e-17, -1.656963091342163e-18,  1.226287116527151e-05,
 -3.571684954522437e-06,  5.488732737495538e-07, -5.795658959474412e-08,  4.700935833970397e-09, -3.114540088635756e-10,  1.752140523809181e-11, -8.595407181829044e-13,
  3.748762048151052e-14, -1.475033087172920e-15,  5.296540459510414e-17, -1.750166366901216e-18,  5.274871921085537e-06, -1.680488071420880e-06,  2.825167091475189e-07,
 -3.251666927878568e-08,  2.863336752069914e-09, -2.051547666611185e-10,  1.243591880019161e-11, -6.551328111420325e-13,  3.058731578722352e-14, -1.284626198992826e-15,
  4.910258096975840e-17, -1.722559887527961e-18,  2.323666207364362e-06, -8.004275966278786e-07,  1.457190747878998e-07, -1.811314946826102e-08,  1.716904468773501e-09,
 -1.319815594181297e-10,  8.556665197160946e-12, -4.806927052935602e-13,  2.386640383804949e-14, -1.063164707725389e-15,  4.299775718666195e-17, -1.592173514474837e-18,
  1.058431529661510e-06, -3.897839644469826e-07,  7.605136597383458e-08, -1.011213456655748e-08,  1.022597768415775e-09, -8.363596126401909e-11,  5.753726341067609e-12,
 -3.421170331608256e-13,  1.793548405793869e-14, -8.417051668156115e-16,  3.578555467408361e-17, -1.390051227725643e-18,  5.016873618361379e-07, -1.953378657854598e-07,
  4.041745887140126e-08, -5.691759829389666e-09,  6.083457898170129e-10, -5.247036673682525e-11,  3.798291694291005e-12, -2.371420543601815e-13,  1.302748044350761e-14,
 -6.394153038864304e-16,  2.837992680125010e-17, -1.148731717798621e-18,  2.473178424815943e-07, -1.007076856284167e-07,  2.186026083664492e-08, -3.226961113602203e-09,
  3.609747228367670e-10, -3.252818052023705e-11,  2.455772302660659e-12, -1.596308023208306e-13,  9.115064955956528e-15, -4.642886878185759e-16,  2.135347103544486e-17,
 -8.942698106916989e-19,  1.248189679974387e-07, -5.258704694721678e-08,  1.184391202111094e-08, -1.813246934120294e-09,  2.101223606882604e-10, -1.958939655119745e-11,
  1.528044755158500e-12, -1.024901181410736e-13,  6.031030361771123e-15, -3.161966595643232e-16,  1.495095029825673e-17, -6.429630307434435e-19,  6.089103068318429e-08,
 -2.626304790885411e-08,  6.068963614045589e-09, -9.530746877112778e-10,  1.132059075251987e-10, -1.080837193594537e-11,  8.626208947786935e-13, -5.914483435211681e-14,
  3.554630840851961e-15, -1.901776787462094e-16,  9.168880447280819e-18, -4.017145434634568e-19,  2.250485017132718e-08, -9.833688786046192e-09,  2.305191330039552e-09,
 -3.671952350283232e-10,  4.422245746225246e-11, -4.278848457556679e-12,  3.459071487172166e-13, -2.401102030508286e-14,  1.460256873903235e-15, -7.901858284159050e-17,
  3.851437561253340e-18, -1.705132806180218e-19,  1.071261183413240e-01, -4.901452360949295e-04,  2.380574406286575e-06, -1.207001507161653e-08,  6.283171868179948e-11,
 -3.316698644319286e-13,  1.760023163156029e-15, -9.343969215481632e-18,  4.947266254752116e-20, -2.609418541513824e-22,  1.369617767641628e-24, -7.155551998254352e-27,
  9.797790922220802e-02, -6.560529319045609e-04,  5.274667266537321e-06, -4.227450782603410e-08,  3.265532593410195e-10, -2.435623055328256e-12,  1.764419818321386e-14,
 -1.247515606052270e-16,  8.639333802033956e-19, -5.875618011780370e-21,  3.932240019479159e-23, -2.593728043856637e-25,  8.199880184042169e-02, -8.973702692886986e-04,
  1.068036314228114e-05, -1.153795161922004e-07,  1.157184632741424e-09, -1.098122927038192e-11,  9.971972324847630e-14, -8.730028923281841e-16,  7.407408609025217e-18,
 -6.116156420087398e-20,  4.929645919282064e-22, -3.888146352106474e-24,  6.285889115794552e-02, -1.089423029755163e-03,  1.747627835464574e-05, -2.420780707257118e-07,
  3.043300268674490e-09, -3.558606231938807e-11,  3.927668422061820e-13, -4.132598727161815e-15,  4.174957344458448e-17, -4.071482904760362e-19,  3.848858126081964e-21,
 -3.538283617319645e-23,  4.420490443801555e-02, -1.143801118841564e-03,  2.375547722181019e-05, -4.121549586154683e-07,  6.352693770244588e-09, -8.961702097256105e-11,
  1.178421190021252e-12, -1.462315114064383e-14,  1.727574826713373e-16, -1.955885491051876e-18,  2.132873815059721e-20, -2.249085917681001e-22,  2.857803876970557e-02,
 -1.045732434047253e-03,  2.751009475591434e-05, -5.873759462613499e-07,  1.091731827192592e-08, -1.829816017030106e-10,  2.826087913776653e-12, -4.080752937731325e-14,
  5.566056469350449e-16, -7.226703118280931e-18,  8.984341016996070e-20, -1.074392608937989e-21,  1.703095673619527e-02, -8.429747350270859e-04,  2.762854691587132e-05,
 -7.153805164823865e-07,  1.582571665205350e-08, -3.114327348150175e-10,  5.587708248235324e-12, -9.291988346328088e-14,  1.448970554987107e-15, -2.137257845944093e-17,
  3.001951329215915e-19, -4.035773319261780e-21,  9.388131574643818e-03, -6.064063193140084e-04,  2.439881898003852e-05, -7.565566558546421e-07,  1.970532927541203e-08,
 -4.508793273356246e-10,  9.313610149846962e-12, -1.768714649439267e-13,  3.128173873375772e-15, -5.202226969331835e-17,  8.195295682572396e-19, -1.229905938844070e-20,
  4.807058042553740e-03, -3.935475550371375e-04,  1.917278711597649e-05, -7.040937695764326e-07,  2.138947523464702e-08, -5.643023303978012e-10,  1.331756597541787e-11,
 -2.867628711578314e-13,  5.713560525147506e-15, -1.064425089608543e-16,  1.869146676512239e-18, -3.112819938607484e-20,  2.297969723692841e-03, -2.327516412192069e-04,
  1.355368128488548e-05, -5.835795570940558e-07,  2.050315655234361e-08, -6.190419392117037e-10,  1.657807002854356e-11, -4.022070983928712e-13,  8.974437773276530e-15,
 -1.862420550463693e-16,  3.625909997163024e-18, -6.666139371098237e-20,  1.031812360137259e-03, -1.266740780986575e-04,  8.711126951412182e-06, -4.356655677293200e-07,
  1.756402823363272e-08, -6.027294576195393e-10,  1.820248946737045e-11, -4.947243849203480e-13,  1.229560603508725e-14, -2.827882976038462e-16,  6.074216605400149e-18,
 -1.227022875669252e-19,  4.382710450276246e-04, -6.407143571517769e-05,  5.144424941267820e-06, -2.962178399918997e-07,  1.360223885549679e-08, -5.270845678914253e-10,
  1.784550551533740e-11, -5.404102382099142e-13,  1.488459218655992e-14, -3.775782018852817e-16,  8.907168354240678e-18, -1.968330835531932e-19,  1.775720917532378e-04,
 -3.042964833689776e-05,  2.822186219780135e-06, -1.855087089035745e-07,  9.633279122141402e-09, -4.188647054576346e-10,  1.580828893994518e-11, -5.305904582162703e-13,
  1.611636513537930e-14, -4.488296668183039e-16,  1.157710978374725e-17, -2.786842765224733e-19,  6.928590395600632e-05, -1.372023025549599e-05,  1.454793858681121e-06,
 -1.082632665813400e-07,  6.312854557156565e-09, -3.060801627141887e-10,  1.280396289062993e-11, -4.738339105562815e-13,  1.579443800900776e-14, -4.806819615427259e-16,
  1.349751105244783e-17, -3.524424344250315e-19,  2.631854586529966e-05, -5.943045261459184e-06,  7.133002190686881e-07, -5.960472230590245e-08,  3.874984448088723e-09,
 -2.081779390275671e-10,  9.596977430618192e-12, -3.894973504043333e-13,  1.417694825271308e-14, -4.692728946873625e-16,  1.428063151621822e-17, -4.027471332776047e-19,
  9.850972073662579e-06, -2.504922825658669e-06,  3.369938695270912e-07, -3.135899591858815e-08,  2.256517862195671e-09, -1.334496778448666e-10,  6.739147679227664e-12,
 -2.982955140954395e-13,  1.179391708954312e-14, -4.225181469798190e-16,  1.386919833783671e-17, -4.205607758386436e-19,  3.681525873000260e-06, -1.041462744389531e-06,
  1.555181788270654e-07, -1.598005768189482e-08,  1.263186242605502e-09, -8.167372592488573e-11,  4.489627157938329e-12, -2.154571999449693e-13,  9.202246916216540e-15,
 -3.549281627732480e-16,  1.250410097865078e-17, -4.057270688333547e-19,  1.393060858208785e-06, -4.332491399003144e-07,  7.110103253747327e-08, -7.996992020285282e-09,
  6.889503950660464e-10, -4.834799504413104e-11,  2.873489166015972e-12, -1.485646288493949e-13,  6.813490604509871e-15, -2.813237455012323e-16,  1.057958412855041e-17,
 -3.654228864653027e-19,  5.412827484155303e-07, -1.829204148710699e-07,  3.265784800929716e-08, -3.983954523928232e-09,  3.709364798438633e-10, -2.803369330091131e-11,
  1.788324866008909e-12, -9.892871038612384e-14,  4.840275306520955e-15, -2.126208478359142e-16,  8.484918222291362e-18, -3.102104408605842e-19,  2.188188609288178e-07,
 -7.942354146595282e-08,  1.526528021955365e-08, -2.000410248462488e-09,  1.994970054523745e-10, -1.610139584708299e-11,  1.093786022456815e-12, -6.425837632022162e-14,
  3.330302913752302e-15, -1.545876652289987e-16,  6.504010954155812e-18, -2.501346259378299e-19,  9.297616623649491e-08, -3.582964453914661e-08,  7.333351486616434e-09,
 -1.021832584937245e-09,  1.081111520681118e-10, -9.234619863680491e-12,  6.623271558166057e-13, -4.098813207373973e-14,  2.232808417541053e-15, -1.087130736419775e-16,
  4.788223189604349e-18, -1.923983122794834e-19,  4.166697294062091e-08, -1.685271004408641e-08,  3.631869227225394e-09, -5.323543260072118e-10,  5.914684036312436e-11,
 -5.295276466476590e-12,  3.972985930309962e-13, -2.567245170089459e-14,  1.457632921825851e-15, -7.384554605145826e-17,  3.378754378710636e-18, -1.408032077070601e-19,
  1.946188673384934e-08, -8.167568824188406e-09,  1.831799674672468e-09, -2.792780225928482e-10,  3.223376836483490e-11, -2.993567501385221e-12,  2.326506363774758e-13,
 -1.554961058868316e-14,  9.119369051414372e-16, -4.765731695437882e-17,  2.246468100132793e-18, -9.632456524420370e-20,  8.976185267109193e-09, -3.864356245048659e-09,
  8.911733967064857e-10, -1.396684618972796e-10,  1.655732367342580e-11, -1.577835076051182e-12,  1.256993782157034e-13, -8.603454804479992e-15,  5.162065594437991e-16,
 -2.757339923393315e-17,  1.327322082468870e-18, -5.806772190806199e-20,  3.212677407474928e-09, -1.402818388027346e-09,  3.285874771411655e-10, -5.229967918874225e-11,
  6.293744105453370e-12, -6.085073144972252e-13,  4.915642211597284e-14, -3.409749013261721e-15,  2.072245587010473e-16, -1.120598954374964e-17,  5.458350229845946e-19,
 -2.415034464970998e-20,  1.052027327472726e-01, -4.716634009968076e-04,  2.241554367105103e-06, -1.111556552447243e-08,  5.660042387099589e-11, -2.923983056579012e-13,
  1.519215525963827e-15, -7.901158871265498e-18,  4.099353570066976e-20, -2.119624015056133e-22,  1.090750585872561e-24, -5.589027583599651e-27,  9.543500000509408e-02,
 -6.157995060031383e-04,  4.797186188404037e-06, -3.741748116247559e-08,  2.818078228870536e-10, -2.051139960982725e-12,  1.450843948425906e-14, -1.002074533310369e-16,
  6.781760230114671e-19, -4.508999013402402e-21,  2.950992744858928e-23, -1.904061294854733e-25,  7.857186109895523e-02, -8.171667127415898e-04,  9.400050674733735e-06,
 -9.849937810531731e-08,  9.596430768200217e-10, -8.856405951320040e-12,  7.828846738924817e-14, -6.677000372543245e-16,  5.522872851045579e-18, -4.447883405795007e-20,
  3.498476199930113e-22, -2.693914342551643e-24,  5.876352283796873e-02, -9.604557207980925e-04,  1.484156926034746e-05, -1.986036582972900e-07,  2.417196714692593e-09,
 -2.740979662907630e-11,  2.937498358540568e-13, -3.004213418233088e-15,  2.952549452566978e-17, -2.803200767763501e-19,  2.581477751934067e-21, -2.313197389294930e-23,
  3.998073544777089e-02, -9.719396888930974e-04,  1.936495170689858e-05, -3.234426728875205e-07,  4.812981530177755e-09, -6.568321957193512e-11,  8.368537380668514e-13,
 -1.007441674576984e-14,  1.155846317586907e-16, -1.271978487846734e-18,  1.349317478486401e-20, -1.385068102622844e-22,  2.479448350443026e-02, -8.511321919267793e-04,
  2.139983491703390e-05, -4.386458207451958e-07,  7.852861073962817e-09, -1.270718374686567e-10,  1.898182251197411e-12, -2.654808695044408e-14,  3.511624251538217e-16,
 -4.426084628514541e-18,  5.346622530923774e-20, -6.217610274276193e-22,  1.405225328995915e-02, -6.524101064911431e-04,  2.037909793133937e-05, -5.055106035120162e-07,
  1.075170737293762e-08, -2.039452744822436e-10,  3.534130017757251e-12, -5.685366983200567e-14,  8.588138721731798e-16, -1.228547570537564e-17,  1.675241422463203e-19,
 -2.188451751481725e-21,  7.302142482309683e-03, -4.427846729202732e-04,  1.694945592385671e-05, -5.027675736114419e-07,  1.257372745239143e-08, -2.769979920086683e-10,
  5.520723778819366e-12, -1.013338299476504e-13,  1.734780994714266e-15, -2.796088658585597e-17,  4.273836767898163e-19, -6.229491687402474e-21,  3.493331214432746e-03,
 -2.689009222017259e-04,  1.245421122917203e-05, -4.371834721619841e-07,  1.274270185912132e-08, -3.234570222717532e-10,  7.361005775479893e-12, -1.531222348450415e-13,
  2.951890443482786e-15, -5.328092198507799e-17,  9.075677547618274e-19, -1.467693210246400e-20,  1.546258938709021e-03, -1.475745325293854e-04,  8.171275720256805e-06,
 -3.362736598277812e-07,  1.133350873900852e-08, -3.291784885591818e-10,  8.499484815272642e-12, -1.991920249569569e-13,  4.300222014106110e-15, -8.646315214331357e-17,
  1.632970945653735e-18, -2.915636785117647e-20,  6.370893885996505e-04, -7.390203857119234e-05,  4.837196323189104e-06, -2.313575178185783e-07,  8.951223207294646e-09,
 -2.955954467729646e-10,  8.609852952997183e-12, -2.261192262894898e-13,  5.439258966442766e-15, -1.212513019581554e-16,  2.527560069709979e-18, -4.960824741226672e-20,
  2.461139345657703e-04, -3.410676725445616e-05,  2.611095353570603e-06, -1.439610406410992e-07,  6.350451184148578e-09, -2.370123338022135e-10,  7.745703112433871e-12,
 -2.268311887384166e-13,  6.051514485336547e-15, -1.489020668661418e-16,  3.411562663678912e-18, -7.330618591869136e-20,  8.991210784265680e-05, -1.466047053988432e-05,
  1.299560414137656e-06, -8.194730157555899e-08,  4.094397755549238e-09, -1.717105419609604e-10,  6.263456417503284e-12, -2.035498360163796e-13,  5.995725562806553e-15,
 -1.621531326796483e-16,  4.066846290432347e-18, -9.529902906775270e-20,  3.137801277663971e-05, -5.937022379330726e-06,  6.035049630821914e-07, -4.319079384049617e-08,
  2.428350166912084e-09, -1.137802951315455e-10,  4.608495854480961e-12, -1.654076834860969e-13,  5.355462890714746e-15, -1.585240066544181e-16,  4.334717388596456e-18,
 -1.103457492563543e-19,  1.058375146608007e-05, -2.294055053315918e-06,  2.649015267550468e-07, -2.135176408203563e-08,  1.342022149099851e-09, -6.984395570079890e-11,
  3.124599594872191e-12, -1.232551111517141e-13,  4.366440873458129e-15, -1.408509809317256e-16,  4.181839749046847e-18, -1.151872816375761e-19,  3.496789396242994e-06,
 -8.576898874048272e-07,  1.114602579812482e-07, -1.003977465434440e-08,  7.006620677088097e-10, -4.025799222830000e-11,  1.978246509283722e-12, -8.532377048292344e-14,
  3.291378923097008e-15, -1.151756739302862e-16,  3.696742015370382e-18, -1.097190700649009e-19,  1.148748242608854e-06, -3.150710270922085e-07,  4.564694424271235e-08,
 -4.557981901707066e-09,  3.506880416777057e-10, -2.210228042253489e-11,  1.185905479078793e-12, -5.561820377300982e-14,  2.324077513596166e-15, -8.778941952932843e-17,
  3.031853382649035e-18, -9.652388856792588e-20,  3.814217990161732e-07, -1.156112399923318e-07,  1.849336407482174e-08, -2.029837641283105e-09,  1.708721996931474e-10,
 -1.173107269956378e-11,  6.828617846368717e-13, -3.461403760184714e-14,  1.557880960237350e-15, -6.318022756318572e-17,  2.335649917841203e-18, -7.936714234165854e-20,
  1.302115542337813e-07, -4.310653220367083e-08,  7.537085468008918e-09, -9.012140707403721e-10,  8.232557932141425e-11, -6.110168875654370e-12,  3.831327432974416e-13,
 -2.085071189264602e-14,  1.004394311849281e-15, -4.347021121147386e-17,  1.710328971254955e-18, -6.169083635243797e-20,  4.647831653282170e-08, -1.660707652218739e-08,
  3.140593230827395e-09, -4.051602093607141e-10,  3.980642440190528e-11, -3.167392418033775e-12,  2.122717337984940e-13, -1.231101396720768e-14,  6.302563379547622e-16,
 -2.891517692640470e-17,  1.203045579277881e-18, -4.577749730419540e-20,  1.759807661778357e-08, -6.705835841548592e-09,  1.356405763424760e-09, -1.868471657965097e-10,
  1.955269851288256e-11, -1.652739983968860e-12,  1.173605004874545e-13, -7.194091542380210e-15,  3.883568736061801e-16, -1.874584228197005e-17,  8.188650689808200e-19,
 -3.264547335856294e-20,  7.125033185200677e-09, -2.860621924459110e-09,  6.116546371246341e-10, -8.896896841495231e-11,  9.812083622969224e-12, -8.722708560102628e-13,
  6.500588899968517e-14, -4.173598715483546e-15,  2.355197641824232e-16, -1.186207484662529e-17,  5.397153052422717e-19, -2.237208228338490e-20,  3.062291979630560e-09,
 -1.279683408423903e-09,  2.856844697804513e-10, -4.335890540897049e-11,  4.982596276880893e-12, -4.608031302297528e-13,  3.566905224470818e-14, -2.374896990610883e-15,
  1.387719528665636e-16, -7.226837091800769e-18,  3.395214352714945e-19, -1.451172132587609e-20,  1.329221729794823e-09, -5.710872393718844e-10,  1.314086819287267e-10,
 -2.054976837636430e-11,  2.430943328798772e-12, -2.311834851892299e-13,  1.838120932643400e-14, -1.255724005311678e-15,  7.520705621566535e-17, -4.010246641670494e-18,
  1.927228650578265e-19, -8.417802719814381e-21,  4.594280528662400e-10, -2.004583528183265e-10,  4.691471972139444e-11, -7.460910634203576e-12,  8.971058438758927e-13,
 -8.666657115508189e-14,  6.995638863212374e-15, -4.848875194118764e-16,  2.944701535729149e-17, -1.591261047147124e-18,  7.745565453809091e-20, -3.424722636642792e-21,
  1.033511203945460e-01, -4.542495498273931e-04,  2.113414456491398e-06, -1.025483405398469e-08,  5.109988688248425e-11, -2.584504509330028e-13,  1.315258403754167e-15,
 -6.703493463853132e-18,  3.409243903437151e-20, -1.728736751785235e-22,  8.724361356440702e-25, -4.386198653857075e-27,  9.304581748451214e-02, -5.791444032445749e-04,
  4.373934992300632e-06, -3.321873108445087e-08,  2.440518443298170e-10, -1.734297063190394e-12,  1.198358505939139e-14, -8.089060451961025e-17,  5.352262635907422e-19,
 -3.480350948075147e-21,  2.228383444105728e-23, -1.407035131947185e-25,  7.544646065943143e-02, -7.464460832149966e-04,  8.304652792594505e-06, -8.446604091871356e-08,
  7.998871133299626e-10, -7.183247660617191e-12,  6.184438653513311e-14, -5.141028218204717e-16,  4.147382898351799e-18, -3.259400317340396e-20,  2.502899972966810e-22,
 -1.882398452015398e-24,  5.514494742980967e-02, -8.506379736338600e-04,  1.267345281005140e-05, -1.639578206298702e-07,  1.933201835057452e-09, -2.127111046754635e-11,
  2.214735299755313e-13, -2.202765134691915e-15,  2.107116413568768e-17, -1.948533055047251e-19,  1.748853217791344e-21, -1.528161667941392e-23,  3.637995921669938e-02,
 -8.313293886234097e-04,  1.590562473721474e-05, -2.559419227384535e-07,  3.679306428298048e-09, -4.860464174167760e-11,  6.003469821514598e-13, -7.015049037334084e-15,
  7.820048968222426e-17, -8.368825879683137e-19,  8.639790084220277e-21, -8.636906164591402e-23,  2.170179469042170e-02, -6.990307696863531e-04,  1.681347082510650e-05,
 -3.310879509170601e-07,  5.712764530564120e-09, -8.929951333074340e-11,  1.290862171317702e-12, -1.749569252288204e-14,  2.245300018190794e-16, -2.748485428192434e-18,
  3.227335350480002e-20, -3.651084867410443e-22,  1.173401426444606e-02, -5.109999003763573e-04,  1.522410392965116e-05, -3.619962138222597e-07,  7.406518837525863e-09,
 -1.354902109375778e-10,  2.268720711434071e-12, -3.532218479386023e-14,  5.170750926645476e-16, -7.176385255177417e-18,  9.503474668357196e-20, -1.206759270410128e-21,
  5.768311535493511e-03, -3.282804497583052e-04,  1.196143568132303e-05, -3.395712795263282e-07,  8.157779403071171e-09, -1.730999865396930e-10,  3.329978479639644e-12,
 -5.909753288313802e-14,  9.796156130990848e-16, -1.530728184549918e-17,  2.270779324074454e-19, -3.215478600181804e-21,  2.588084527428208e-03, -1.872218455410323e-04,
  8.245354467004238e-06, -2.767407646404718e-07,  7.741386479864047e-09, -1.891178407546828e-10,  4.151151738376633e-12, -8.343961792935015e-14,  1.556694175640921e-15,
 -2.722830084453724e-17,  4.499676763944521e-19, -7.067234395047311e-21,  1.064917259711889e-03, -9.569948580275224e-05,  5.038072426281003e-06, -1.981721568674755e-07,
  6.407667173616471e-09, -1.790503834836611e-10,  4.457833925414642e-12, -1.009261940315591e-13,  2.108224366548469e-15, -4.107278518811530e-17,  7.525437423446103e-19,
 -1.304970151646029e-20,  4.042184762664821e-04, -4.426066925737043e-05,  2.756368243950548e-06, -1.260503238689391e-07,  4.679611739050157e-09, -1.486953020918591e-10,
  4.176834558921508e-12, -1.059896818218730e-13,  2.467443313697937e-15, -5.330815908923288e-17,  1.078344888121414e-18, -2.056174244868709e-20,  1.425582171418309e-04,
 -1.870476597227520e-05,  1.364421399173424e-06, -7.199643183050849e-08,  3.049778353266476e-09, -1.095957632789924e-10,  3.456231741551519e-12, -9.785412965819748e-14,
  2.528024868156200e-15, -6.032274521228390e-17,  1.341998516755960e-18, -2.803284479894315e-20,  4.712009062530665e-05, -7.299964130124433e-06,  6.178958898816597e-07,
 -3.735028714885180e-08,  1.794442253867443e-09, -7.254575859772101e-11,  2.556382849666209e-12, -8.040279207755961e-14,  2.295742192141715e-15, -6.027008894683290e-17,
  1.469197921757322e-18, -3.350164194584454e-20,  1.474906872032265e-05, -2.662138406915660e-06,  2.591176982360656e-07, -1.781624510184874e-08,  9.650487346227632e-10,
 -4.366454637447680e-11,  1.711237790283046e-12, -5.953184555802959e-14,  1.871105296118796e-15, -5.383911666371644e-17,  1.432852196137794e-18, -3.554125489364706e-20,
  4.425997475901345e-06, -9.192389811564105e-07,  1.019822092703117e-07, -7.919639061090221e-09,  4.807512954239992e-10, -2.421536374356798e-11,  1.050395465889706e-12,
 -4.024024999253394e-14,  1.386454179774490e-15, -4.355344672155628e-17,  1.260739294182246e-18, -3.389505949267853e-20,  1.291809066004413e-06, -3.050766775404246e-07,
  3.823849202712591e-08, -3.329614915526925e-09,  2.250989346548718e-10, -1.255205618102074e-11,  5.995891464488814e-13, -2.517622826767184e-14,  9.467144644566221e-16,
 -3.233272412992953e-17,  1.013948250899892e-18, -2.943354507077071e-20,  3.728341475275233e-07, -9.896323184119473e-08,  1.388853391468338e-08, -1.345767850567052e-09,
  1.006525374722009e-10, -6.176391564124030e-12,  3.231195856629730e-13, -1.479476710351705e-14,  6.042701641587090e-16, -2.233466538341813e-17,  7.554948256178959e-19,
 -2.358051349430139e-20,  1.084009199630214e-07, -3.196696350030125e-08,  4.976432388275113e-09, -5.322856284598309e-10,  4.372623695750586e-11, -2.933362586911670e-12,
  1.670485914379597e-13, -8.293258590270621e-15,  3.659414627494421e-16, -1.456362180173364e-17,  5.287889342907531e-19, -1.766292587846124e-20,  3.239618476496382e-08,
 -1.048979265311494e-08,  1.793630386787645e-09, -2.099306284614213e-10,  1.879182098400291e-11, -1.368131031157162e-12,  8.423446280399031e-14, -4.505288045805337e-15,
  2.134681334801068e-16, -9.094672614652123e-18,  3.524981408293582e-19, -1.253387175094749e-20,  1.015907113836655e-08, -3.568676674664280e-09,  6.631965254609318e-10,
 -8.412944131597292e-11,  8.134075958647665e-12, -6.374335619600108e-13,  4.210479643762175e-14, -2.408507437309051e-15,  1.216954578054109e-16, -5.513851071878227e-18,
  2.266911770048024e-19, -8.528515140210121e-21,  3.406955115293299e-09, -1.282424584668535e-09,  2.560998118722181e-10, -3.484285610347199e-11,  3.603104609181206e-12,
 -3.011353209000498e-13,  2.115451225187625e-14, -1.283529742288772e-15,  6.861544266415908e-17, -3.281374800097179e-18,  1.420725361201097e-19, -5.616317266971557e-21,
  1.238133350953425e-09, -4.930969343561044e-10,  1.045327636419815e-10, -1.507819371097238e-11,  1.649618793217830e-12, -1.455268033879121e-13,  1.076636705501364e-14,
 -6.864380047271844e-16,  3.847989006829346e-17, -1.925824833818510e-18,  8.709569450898963e-20, -3.589544206912358e-21,  4.866495351222651e-10, -2.024137169052826e-10,
  4.496080590639371e-11, -6.790107110644064e-12,  7.765768576755190e-13, -7.149290404265747e-14,  5.509934005266398e-15, -3.653361840666639e-16,  2.126300514275023e-17,
 -1.103123261419589e-18,  5.163800595162640e-20, -2.199486449374895e-21,  1.978083989199455e-10, -8.479821487539849e-11,  1.946509535961408e-11, -3.036689137883869e-12,
  3.583955162265243e-13, -3.400772232559755e-14,  2.698157418638358e-15, -1.839494512217702e-16,  1.099540353258985e-17, -5.852042342311749e-19,  2.807289451314145e-20,
 -1.224064824785046e-21,  6.582345553680958e-11, -2.869694376521254e-11,  6.710114440668814e-12, -1.066158280663384e-12,  1.280827466340990e-13, -1.236306507557455e-14,
  9.971045550465232e-16, -6.905646244860253e-17,  4.190497655127921e-18, -2.262754290003109e-19,  1.100603764214127e-20, -4.862906295234189e-22,  1.015671765772346e-01,
 -4.378209490507122e-04,  1.995096846149973e-06, -9.476934509747706e-09,  4.623194992271837e-11, -2.290188634742568e-13,  1.141944327256004e-15, -5.705735196885124e-18,
  2.845330748044817e-20, -1.415454874008806e-22,  7.007251643546653e-25, -3.458122175760901e-27,  9.079678857161484e-02, -5.456835785899372e-04,  3.997643155520622e-06,
 -2.957649919377531e-08,  2.120680360972519e-10, -1.472044793317756e-12,  9.940753679407414e-15, -6.560742212683823e-17,  4.245918063826298e-19, -2.701363349081926e-21,
  1.692778145899612e-23, -1.046372152173157e-25,  7.258742474519268e-02, -6.838560793832943e-04,  7.363356999361512e-06, -7.274115933503288e-08,  6.699719724094504e-10,
 -5.857742925483203e-12,  4.914402852778758e-14, -3.983794625932184e-16,  3.135904420621043e-18, -2.405995982795968e-20,  1.804543420005445e-22, -1.326107234816562e-24,
  5.193341195099431e-02, -7.566250502273358e-04,  1.087838873947024e-05, -1.361608454927830e-07,  1.556305333425999e-09, -1.662571105230351e-11,  1.682705888663532e-13,
 -1.628435006739771e-15,  1.516895716679548e-17, -1.366904202169110e-19,  1.196209072622862e-21, -1.019714555646832e-23,  3.329100154769481e-02, -7.154379366523647e-04,
  1.315782092152568e-05, -2.041289404317092e-07,  2.836738145359437e-09, -3.629622288097606e-11,  4.348659417030577e-13, -4.934758947965773e-15,  5.347540523461121e-17,
 -5.567801137130445e-19,  5.596488172319186e-21, -5.450649052334217e-23,  1.915155203992775e-02, -5.789869232604866e-04,  1.333493340754548e-05, -2.524413974363118e-07,
  4.200739110115806e-09, -6.346871145403751e-11,  8.883070470231578e-13, -1.167305335282437e-14,  1.454106738941197e-16, -1.729460116545127e-18,  1.974826264130054e-20,
 -2.174239296742825e-22,  9.908683521653493e-03, -4.047565813295927e-04,  1.151049069850170e-05, -2.625173812952596e-07,  5.169834850057482e-09, -9.125426867833635e-11,
  1.477195776481824e-12, -2.226830949624442e-14,  3.160365879198506e-16, -4.257112157416274e-18,  5.476945997920480e-20, -6.762395417197415e-22,  4.623583400409297e-03,
 -2.469069253925208e-04,  8.568150073697586e-06, -2.329053493073167e-07,  5.377295654723862e-09, -1.099477193578644e-10,  2.042332138463133e-12, -3.505754624215069e-14,
  5.628721496559046e-16, -8.529488275257717e-18,  1.228384386044648e-19, -1.690269489775235e-21,  1.952724157783447e-03, -1.326927691972068e-04,  5.558405381700921e-06,
 -1.784278956767000e-07,  4.791721279792541e-09, -1.126919927392363e-10,  2.386520303680747e-12, -4.636417804217048e-14,  8.373064981072951e-16, -1.419516382478351e-17,
  2.276350386195807e-19, -3.472924706296029e-21,  7.498114747864199e-04, -6.340294251017592e-05,  3.173469652127807e-06, -1.193238505449886e-07,  3.701915593012529e-09,
 -9.953355894360790e-11,  2.389808540493689e-12, -5.227533926102810e-14,  1.056699209878076e-15, -1.994929309466929e-17,  3.546262943902072e-19, -5.972868059686961e-21,
  2.632360121232881e-04, -2.718234354795255e-05,  1.610096294011919e-06, -7.038979150655328e-08,  2.507306160820580e-09, -7.665579739087393e-11,  2.076494041347909e-12,
 -5.091040701149169e-14,  1.146979489511025e-15, -2.401507659756142e-17,  4.713852997954172e-19, -8.731796200402578e-21,  8.508159952838778e-05, -1.055702450691469e-05,
  7.333098389183473e-07, -3.701796523907293e-08,  1.505333238342279e-09, -5.207215613105005e-11,  1.584292604716783e-12, -4.335660967969620e-14,  1.084456021142957e-15,
 -2.508942060877594e-17,  5.418718870490990e-19, -1.100160364467802e-20,  2.553490891012721e-05, -3.753406362887283e-06,  3.030960049984775e-07, -1.755128542077663e-08,
  8.103764222732211e-10, -3.156742090670793e-11,  1.074149336364885e-12, -3.268341564034634e-14,  9.042723361772187e-16, -2.303662869514968e-17,  5.456251584989684e-19,
 -1.210290254450668e-20,  7.190777421251272e-06, -1.236144425191664e-06,  1.150783725502331e-07, -7.594932746341816e-09,  3.960332660016196e-10, -1.729164392798827e-11,
  6.552928122619838e-13, -2.208337610670494e-14,  6.734195294569756e-16, -1.882620290416250e-17,  4.874039158611303e-19, -1.177468613847523e-20,  1.924207152218131e-06,
 -3.822590028074530e-07,  4.068925405215771e-08, -3.040883707591383e-09,  1.781043412962035e-10, -8.674836934537740e-12,  3.645585707475424e-13, -1.355331919822381e-14,
  4.538435275438007e-16, -1.387451154899946e-17,  3.913264233493421e-19, -1.026263765123568e-20,  4.967491961979240e-07, -1.127431723518958e-07,  1.360897024114107e-08,
 -1.144036873804525e-09,  7.483589029918496e-11, -4.045687084885240e-12,  1.876815235718811e-13, -7.665048650958660e-15,  2.807354093893336e-16, -9.350065063705964e-18,
  2.862690052825994e-19, -8.121774123648036e-21,  1.259457383505078e-07, -3.229230439382377e-08,  4.382916777481615e-09, -4.115416592304673e-10,  2.988267851608816e-11,
 -1.783266321195337e-12,  9.086389051917191e-14, -4.057675127052868e-15,  1.618377290218208e-16, -5.847875245183748e-18,  1.935840858904881e-19, -5.918857298334415e-21,
  3.201363704238841e-08, -9.168304446223308e-09,  1.386776735813164e-09, -1.443390841893610e-10,  1.155563168310751e-11, -7.565634972625140e-13,  4.210302853893963e-14,
 -2.045031922178269e-15,  8.838131728216692e-17, -3.448444949114743e-18,  1.228679670514298e-19, -4.030899162381018e-21,  8.348213588475698e-09, -2.639532412954822e-09,
  4.406932994536335e-10, -5.041863089858883e-11,  4.416840597509038e-12, -3.150601506637538e-13,  1.902566026275186e-14, -9.990397845542062e-16,  4.651542421508284e-17,
 -1.949029912017444e-18,  7.435206149089924e-20, -2.604065220056324e-21,  2.288800039404008e-09, -7.893291520839946e-10,  1.439543965211790e-10, -1.793402806614589e-11,
  1.704382589497643e-12, -1.314019077604774e-13,  8.546050601989170e-15, -4.817093239942524e-16,  2.400090500562065e-17, -1.073039992568655e-18,  4.355868582087264e-20,
 -1.619038986697504e-21,  6.757171524163778e-10, -2.509730747455070e-10,  4.942781409948071e-11, -6.634944964754821e-12,  6.773699871776086e-13, -5.592516361258985e-14,
  3.883350862899832e-15, -2.330317446787789e-16,  1.232733004814322e-17, -5.836585133316962e-19,  2.503070051105840e-20, -9.805609455112598e-22,  2.189294655247099e-10,
 -8.642173254441285e-11,  1.814992223157647e-11, -2.594238927865528e-12,  2.813511241091699e-13, -2.461437590012260e-14,  1.806628822615829e-15, -1.143195635403090e-16,
  6.362521393841945e-18, -3.162540539044786e-19,  1.420950244638310e-20, -5.819983303539619e-22,  7.817731209061307e-11, -3.234970616744487e-11,  7.146021146247846e-12,
 -1.073385088756829e-12,  1.221244104060533e-13, -1.118714948316207e-14,  8.581050939527735e-16, -5.663958631372918e-17,  3.282287062779542e-18, -1.695848012954126e-19,
  7.907241384583077e-21, -3.355450569276115e-22,  2.959566394247831e-11, -1.265651636990906e-11,  2.897566431730985e-12, -4.508606280354741e-13,  5.307716341368096e-14,
 -5.024229219132454e-15,  3.976950770322657e-16, -2.705301493028879e-17,  1.613630487892148e-18, -8.570687669751721e-20,  4.103441540575971e-21, -1.785895971150790e-22,
  9.449648245359463e-12, -4.116160467718283e-12,  9.615391730388789e-13, -1.526298318236098e-13,  1.831885058246891e-14, -1.766588165187925e-15,  1.423520917427148e-16,
 -9.850400539048401e-18,  5.972466315161638e-19, -3.222372726231756e-20,  1.566141182109459e-21, -6.914632421152206e-23,  9.984711138952912e-02, -4.223028307440831e-04,
  1.885665426259089e-06, -8.772429759734299e-09,  4.191321112113805e-11, -2.034309615632118e-13,  9.942016912893136e-16, -4.871633846559013e-18,  2.382759535091380e-20,
 -1.163346095025264e-22,  5.650526750311023e-25, -2.738725602248231e-27,  8.867584732038866e-02, -5.150665790838210e-04,  3.662152494332702e-06, -2.640657310737936e-08,
  1.848716932639599e-10, -1.254060874246530e-12,  8.280225289489007e-15, -5.345428057820136e-17,  3.384983248772149e-19, -2.107979331892708e-21,  1.293298297657919e-23,
 -7.829255652662292e-26,  6.996453184431357e-02, -6.282670721156335e-04,  6.551111977776880e-06, -6.289836117643675e-08,  5.637635364033148e-10, -4.801555517358408e-12,
  3.927338505676977e-14, -3.106024814644945e-16,  2.386754365902441e-18, -1.788528693121237e-20,  1.310738542704212e-22, -9.415548175938658e-25,  4.907118375546571e-02,
 -6.757342644881488e-04,  9.383561607117029e-06, -1.137152201004979e-07,  1.260748081995045e-09, -1.308375731777614e-11,  1.287914204993999e-13, -1.213338109374930e-15,
  1.101128112107987e-17, -9.673403945359550e-20,  8.257704650159478e-22, -6.870150963859106e-24,  3.062528207858259e-02, -6.192536716070799e-04,  1.095836138797846e-05,
 -1.640251834809989e-07,  2.204915509463216e-09, -2.734123687932111e-11,  3.179192364081673e-13, -3.505335034438389e-15,  3.694317240418401e-17, -3.743986737035465e-19,
  3.665603110228571e-21, -3.479627359984927e-23,  1.703127247794133e-02, -4.833715044434491e-04,  1.067048807887370e-05, -1.943285674311567e-07,  3.120575855132611e-09,
 -4.559819101248005e-11,  6.182331522688988e-13, -7.880546817035312e-15,  9.533132857997668e-17, -1.102127905569922e-18,  1.224317991738772e-20, -1.312319843288646e-22,
  8.455690643400042e-03, -3.239944615125437e-04,  8.802064698254344e-06, -1.926675533774962e-07,  3.654127863239469e-09, -6.226875057407843e-11,  9.749360523404892e-13,
 -1.423645860385282e-14,  1.959641477372306e-16, -2.562998888798354e-18,  3.204616960362992e-20, -3.848661577285671e-22,  3.757209778543369e-03, -1.882298949636069e-04,
  6.224736506162707e-06, -1.620975095443935e-07,  3.598418240992860e-09, -7.092884113128613e-11,  1.272728639614073e-12, -2.113887321312642e-14,  3.288542263668043e-16,
 -4.834235421942546e-18,  6.760887099016737e-20, -9.042672317348224e-22,  1.498964271012736e-03, -9.563977957159354e-05,  3.811892872203887e-06, -1.170714508383913e-07,
  3.019343276563731e-09, -6.838221030356449e-11,  1.397599556582644e-12, -2.625036870254009e-14,  4.590076083463318e-16, -7.544264056251979e-18,  1.174213444136496e-19,
 -1.740509302257717e-21,  5.391514692005596e-04, -4.286907201032041e-05,  2.040158664209472e-06, -7.333880598912495e-08,  2.183489045000096e-09, -5.649873859927863e-11,
  1.308430598886928e-12, -2.765706058874309e-14,  5.410826163461752e-16, -9.899957187579912e-18,  1.707618101579397e-19, -2.793748275940766e-21,  1.757472914609294e-04,
 -1.709935584553207e-05,  9.631338144732674e-07, -4.024920757546514e-08,  1.375549029972943e-09, -4.046356040170105e-11,  1.057034621718380e-12, -2.503965434928684e-14,
  5.459394764130234e-16, -1.107778953613981e-17,  2.109929724778989e-19, -3.796743670037965e-21,  5.226150015260046e-05, -6.125480809968936e-06,  4.049520396638575e-07,
 -1.954985126016409e-08,  7.629900670489137e-10, -2.540110574938012e-11,  7.454661226861893e-13, -1.971615314071511e-14,  4.773829796875327e-16, -1.070678968570904e-17,
  2.244578994901529e-19, -4.428654585185352e-21,  1.429467422365879e-05, -1.990895818718474e-06,  1.532521026710084e-07, -8.496193162651016e-09,  3.768206778603572e-10,
 -1.413764525395917e-11,  4.643587113980739e-13, -1.366424391084274e-14,  3.662159885049453e-16, -9.050315469925517e-18,  2.082120589172695e-19, -4.491406844924653e-21,
  3.633567045091184e-06, -5.939749507959297e-07,  5.282970549256857e-08, -3.343859062098945e-09,  1.677327309732804e-10, -7.062733799728009e-12,  2.586671397409382e-13,
 -8.439810886534162e-15,  2.495792681620492e-16, -6.775754419326646e-18,  1.705728125188468e-19, -4.011514808108727e-21,  8.693312125582226e-07, -1.648985973470446e-07,
  1.681864997103491e-08, -1.208306745373792e-09,  6.821852197729424e-11, -3.210260793572591e-12,  1.306043202500281e-13, -4.708666336915536e-15,  1.531385899445639e-16,
 -4.553200101680567e-18,  1.250534085100084e-19, -3.197223324391994e-21,  1.988383244517049e-07, -4.328912226540687e-08,  5.024616629372292e-09, -4.072688540111897e-10,
  2.574833650848097e-11, -1.348118381762352e-12,  6.067920732671288e-14, -2.408303164848623e-15,  8.584052917029865e-17, -2.785920099782390e-18,  8.321390088734881e-20,
 -2.305779338384329e-21,  4.430551884447197e-08, -1.095195486805506e-08,  1.435263833741672e-09, -1.304070661151965e-10,  9.181296415461999e-12, -5.322095217046839e-13,
  2.638390873199282e-14, -1.147976925614338e-15,  4.466930080893002e-17, -1.576574713262766e-18,  5.103200387905326e-20, -1.527255766799236e-21,  9.834574355180532e-09,
 -2.730063285033230e-09,  4.005620568185094e-10, -4.050912098757993e-11,  3.156379906393863e-12, -2.014333483472038e-13,  1.094188998562590e-14, -5.194206264673229e-16,
  2.196433712379213e-17, -8.394129178036510e-19,  2.932278447589117e-20, -9.440240122005541e-22,  2.231364395104958e-09, -6.877042073137060e-10,  1.119334237120117e-10,
 -1.249952280115220e-11,  1.070190814677443e-12, -7.470153454344738e-14,  4.419380086406118e-15, -2.275877548431002e-16,  1.040230878136494e-17, -4.282596392583877e-19,
  1.606562163917254e-20, -5.537563523969691e-22,  5.323995132724470e-10, -1.799798580085078e-10,  3.216607863008279e-11, -3.930254476943447e-12,  3.666943886806100e-13,
 -2.778113290300792e-14,  1.777123436481738e-15, -9.860678255023299e-17,  4.840146609696465e-18, -2.133395001180893e-19,  8.543736132657411e-21, -3.134964110091503e-22,
  1.375266308700728e-10, -5.034072191103627e-11,  9.765988027711203e-12, -1.291995976156336e-12,  1.300843989851620e-13, -1.059943844290904e-14,  7.268542140291930e-16,
 -4.310156002246758e-17,  2.254441583564145e-18, -1.055988137970213e-19,  4.482560192655714e-21, -1.738995152744190e-22,  3.944700195429034e-11, -1.542099853393927e-11,
  3.205667711126303e-12, -4.536634231902354e-13,  4.873493272226337e-14, -4.225186922232638e-15,  3.074568860912110e-16, -1.929646545826956e-17,  1.065618612978687e-18,
 -5.257593854377353e-20,  2.345639860608712e-21, -9.543037293984340e-23,  1.270767719221617e-11, -5.228726007390631e-12,  1.148035528019948e-12, -1.714236052026486e-13,
  1.939297427525524e-14, -1.766852133060776e-15,  1.348252372411982e-16, -8.855390369499434e-18,  5.107669935060609e-19, -2.627168732355595e-20,  1.219751905359470e-21,
 -5.155049977595816e-23,  4.454145765142095e-12, -1.899722545365261e-12,  4.336585814766934e-13, -6.728445503535368e-14,  7.899170110953145e-15, -7.457509319657719e-16,
  5.888097000433191e-17, -3.995666538106257e-18,  2.377786658621550e-19, -1.260154606763326e-20,  6.020570097807730e-22, -2.614982141827168e-23,  1.359527021654527e-12,
 -5.916386364393438e-13,  1.380636989391159e-13, -2.189279405983854e-14,  2.624941745877709e-15, -2.528887955843860e-16,  2.035845298862543e-17, -1.407457327893528e-18,
  8.526070230669902e-20, -4.596187789163741e-21,  2.231989331898809e-22, -9.846511565722113e-24,  9.818741970604529e-02, -4.076274845853623e-04,  1.784289749388720e-06,
 -8.133115772539226e-09,  3.807258084876221e-11, -1.811245487926816e-13,  8.678708914554028e-16, -4.172022351905591e-18,  2.001895800960791e-20, -9.596757529449393e-23,
  4.573737851897227e-25, -2.178680426066906e-27,  8.667223710738775e-02, -4.869884280002469e-04,  3.362227255759430e-06, -2.363896606889075e-08,  1.616625363261289e-10,
 -1.072138805678679e-12,  6.924418961263324e-15, -4.374305012061160e-17,  2.711492322439275e-19, -1.653425621624566e-21,  9.935531647366798e-24, -5.892637295162273e-26,
  6.755170833687357e-02, -5.787309336633652e-04,  5.847442085744410e-06, -5.459798992476700e-08,  4.764957966718492e-10, -3.955286872423227e-12,  3.155575747754160e-14,
 -2.435921278608112e-16,  1.828068061485398e-18, -1.338501074276076e-20,  9.588761946821901e-23, -6.735663179871828e-25,  4.651020054175491e-02, -6.058000294823755e-04,
  8.131889594389457e-06, -9.547958165751643e-08,  1.027423935268880e-09, -1.036363169553794e-11,  9.926972678038810e-14, -9.108682146141351e-16,  8.057176010514112e-18,
 -6.903584169633337e-20,  5.751072274506637e-22, -4.671613023284633e-24,  2.831193035796291e-02, -5.388992740003362e-04,  9.184943025362850e-06, -1.327376840773688e-07,
  1.727082293700389e-09, -2.076689296855159e-11,  2.344798061894022e-13, -2.513252376072913e-15,  2.577274060478624e-17, -2.543452859352047e-19,  2.426593912463568e-21,
 -2.246018871601784e-23,  1.525485839247715e-02, -4.065509948087780e-04,  8.610446141775001e-06, -1.509581476244609e-07,  2.340752355083496e-09, -3.309728280186076e-11,
  4.349352475342705e-13, -5.380492245130159e-15,  6.323624214737977e-17, -7.109352737280394e-19,  7.686194554144707e-21, -8.023974408497427e-23,  7.287191138549891e-03,
 -2.619190771912195e-04,  6.803529238800392e-06, -1.430169845537912e-07,  2.613779370725441e-09, -4.302229540757953e-11,  6.518251748115031e-13, -9.224200814147370e-15,
  1.231997148497271e-16, -1.565112148869216e-18,  1.902553020219127e-20, -2.223265170845090e-22,  3.092818683265918e-03, -1.453318617437245e-04,  4.583074998678121e-06,
 -1.143935325861742e-07,  2.442878814283345e-09, -4.644078420108530e-11,  8.053183647089075e-13, -1.294711758381109e-14,  1.952289759518291e-16, -2.784997656081139e-18,
  3.783555560651285e-20, -4.920280613171900e-22,  1.169533933008332e-03, -7.003603504483574e-05,  2.657046254946279e-06, -7.810360725281653e-08,  1.935207255988194e-09,
 -4.222207456930587e-11,  8.330828575829675e-13, -1.513236298540508e-14,  2.562678864626421e-16, -4.084537909931174e-18,  6.171719887535815e-20, -8.889993517469456e-22,
  3.954817310878035e-04, -2.955012699688345e-05,  1.337302554437645e-06, -4.596847818758853e-08,  1.313679989197267e-09, -3.272014170688266e-11,  7.310272025884706e-13,
 -1.493453929456013e-14,  2.828307316210443e-16, -5.015991837083600e-18,  8.396301200931046e-20, -1.334509281513509e-21,  1.201581831885461e-04, -1.100570140491371e-05,
  5.893799062983380e-07, -2.354328588340107e-08,  7.720037022340755e-10, -2.185137635107818e-11,  5.505111785976641e-13, -1.260055752990556e-14,  2.658833088292543e-16,
 -5.228702893895105e-18,  9.663649795569514e-20, -1.689291946191361e-21,  3.300205813557599e-05, -3.649838048327198e-06,  2.295380412426945e-07, -1.059476035889267e-08,
  3.967721763836634e-10, -1.271082079411145e-11,  3.597837027446858e-13, -9.195209936447577e-15,  2.155001743129792e-16, -4.684967888412612e-18,  9.532432493457108e-20,
 -1.827544254344028e-21,  8.258050664698766e-06, -1.088317139333194e-06,  7.979768940926818e-08, -4.233179464694017e-09,  1.802718394299893e-10, -6.511885456399283e-12,
  2.063943321569393e-13, -5.871827873710732e-15,  1.524003964987183e-16, -3.652623132432169e-18,  8.160224530120741e-20, -1.711392609849259e-21,  1.901407207739466e-06,
 -2.951049014017605e-07,  2.505101418934415e-08, -1.519465057852344e-09,  7.327183663777872e-11, -2.973675028008815e-12,  1.051978270418214e-13, -3.321638345411634e-15,
  9.521138699032695e-17, -2.509138625543522e-18,  6.139376337952880e-20, -1.405037178278307e-21,  4.079302364586731e-07, -7.375372083383475e-08,  7.198709681969552e-09,
 -4.966558329673886e-10,  2.700501182801210e-11, -1.226847071212726e-12,  4.828440740824170e-14, -1.687021308684899e-15,  5.325529025009846e-17, -1.539071596880125e-18,
  4.113863928425898e-20, -1.024823791366106e-21,  8.284064248190946e-08, -1.726728427429855e-08,  1.924381043818585e-09, -1.502062060425365e-10,  9.168037559987980e-12,
 -4.644324633041466e-13,  2.026396209075717e-14, -7.809248754815046e-16,  2.706749795220600e-17, -8.553832484093729e-19,  2.490857313874417e-20, -6.736319389670143e-22,
  1.623720257590517e-08, -3.861931665618069e-09,  4.878765998630061e-10, -4.283329690930296e-11,  2.920329983261889e-12, -1.642455562591037e-13,  7.913572243569539e-15,
 -3.351568729639367e-16,  1.271153367582877e-17, -4.378380555858181e-19,  1.384652249847488e-20, -4.052942366823546e-22,  3.145528556702867e-09, -8.447314669300019e-10,
  1.200205056665515e-10, -1.177570926417789e-11,  8.917776715310360e-13, -5.540460474970243e-14,  2.934254891138044e-15, -1.359869564651511e-16,  5.620779542900243e-18,
 -2.102016351693744e-19,  7.192657336138941e-21, -2.270445825765536e-22,  6.194768322504097e-10, -1.857579507233560e-10,  2.942578223805343e-11, -3.202457692029731e-12,
  2.676070827359128e-13, -1.825572000905414e-14,  1.056824485533156e-15, -5.331578294406805e-17,  2.389759241644385e-18, -9.657499703852382e-20,  3.559358349692673e-21,
 -1.206361137619565e-22,  1.280787597812310e-10, -4.237289864554777e-11,  7.409775751643629e-12, -8.867179198660453e-13,  8.111458460274003e-14, -6.031600437115172e-15,
  3.790679194970218e-16, -2.068333978654454e-17,  9.992052453902678e-19, -4.338008588214828e-20,  1.712402922820605e-21, -6.197768239468261e-23,  2.877349992747146e-11,
 -1.036621913524498e-11,  1.978390998634195e-12, -2.576413543865545e-13,  2.555469819736658e-14, -2.052832990053848e-15,  1.388871257019576e-16, -8.131125966203000e-18,
  4.201640741473199e-19, -1.945456348675788e-20,  8.167965371100981e-22, -3.135797957072788e-23,  7.253737919596952e-12, -2.805596352972402e-12,  5.767262065263625e-13,
 -8.073685463246701e-14,  8.583768595241083e-15, -7.368928928926906e-16,  5.312247855561415e-17, -3.304543762071310e-18,  1.809535640304592e-19, -8.856539254996219e-21,
  3.921198205971536e-22, -1.583763311035077e-23,  2.092390347690003e-12, -8.555772235338859e-13,  1.866047527448988e-13, -2.768292965894642e-14,  3.112268947846020e-15,
 -2.818710755950178e-16,  2.138769074971799e-17, -1.397212719466769e-18,  8.017764225594129e-20, -4.103941361804115e-21,  1.896567142128887e-22, -7.980184132666231e-24,
  6.746774986900446e-13, -2.869087539338610e-13,  6.528531915272371e-14, -1.009764188360923e-14,  1.181881838850353e-15, -1.112575682265361e-16,  8.760118739130459e-18,
 -5.928952606137096e-19,  3.519389573953444e-20, -1.860687171303009e-21,  8.869291375727536e-23, -3.843868478882592e-24,  1.960514472561373e-13, -8.523101059782222e-14,
  1.986703818221236e-14, -3.146799639567474e-15,  3.768892695411074e-16, -3.627142826551753e-17,  2.916998785389752e-18, -2.014644597496057e-19,  1.219266771822278e-20,
 -6.566720795697796e-22,  3.186086585960571e-23, -1.404354306466197e-24,  9.658485455282043e-02, -3.937334685540909e-04,  1.690231346089868e-06, -7.551841158101412e-09,
  3.464927775329980e-11, -1.616281288699838e-13,  7.595275112805257e-16, -3.583341264067753e-18,  1.687159030974521e-20, -7.945320960875002e-23,  3.715290781099275e-25,
 -1.740999849405768e-27,  8.477634247136451e-02, -4.611828811011002e-04,  3.093399806689236e-06, -2.121527772660505e-08,  1.417872549692518e-10, -9.197223174861564e-13,
  5.812658924365448e-15, -3.594673961972936e-17,  2.181964521304255e-19, -1.303330666529167e-21,  7.673382369258546e-24, -4.460277256578774e-26,  6.532636959962651e-02,
 -5.344482493819425e-04,  5.235526543342785e-06, -4.756795989320646e-08,  4.044433395975339e-10, -3.273605493245578e-12,  2.548667293353696e-14, -1.921177317114085e-16,
  1.408661507001529e-18, -1.008202773836977e-20,  7.062953485642105e-23, -4.853529528850659e-25,  4.421022898053677e-02, -5.450634260634970e-04,  7.078324137825923e-06,
 -8.057770726460508e-08,  8.420515619858254e-10, -8.260222305331838e-12,  7.703088000738053e-14, -6.887361661471106e-16,  5.940827986407646e-18, -4.966785875605685e-20,
  4.039453881006820e-22, -3.204965411275976e-24,  2.629382823434415e-02, -4.713510637476448e-04,  7.745113447591746e-06, -1.081436602119822e-07,  1.362767563744385e-09,
 -1.589847186313685e-11,  1.744015601751904e-13, -1.818068903023012e-15,  1.814905995799143e-17, -1.744894409780496e-19,  1.622873583472801e-21, -1.465215377999712e-23,
  1.375578560452274e-02, -3.443235938057138e-04,  7.003522880798001e-06, -1.182819113239587e-07,  1.772076818086781e-09, -2.425970626107778e-11,  3.091498974121062e-13,
 -3.713369715892385e-15,  4.242016077045904e-17, -4.639678558041412e-19,  4.883847915621844e-21, -4.967497041756903e-23,  6.338425942279960e-03, -2.137049877658882e-04,
  5.312384834755296e-06, -1.073105200640493e-07,  1.890950152788523e-09, -3.007958069826876e-11,  4.412165611940388e-13, -6.053643873391715e-15,  7.848498420877774e-17,
 -9.688511610294647e-19,  1.145439821396821e-20, -1.302861744723273e-22,  2.576979431065282e-03, -1.135580197944927e-04,  3.417311118051652e-06, -8.179950922347206e-08,
  1.681265708384684e-09, -3.084058438472838e-11,  5.170497648217526e-13, -8.049519520404570e-15,  1.176930796770456e-16, -1.629808716011005e-18,  2.151543218472361e-20,
 -2.721232705385169e-22,  9.266332579675200e-04, -5.206003453198351e-05,  1.880878261653652e-06, -5.293845798405893e-08,  1.260654475751004e-09, -2.650644859366874e-11,
  5.050790352624484e-13, -8.875289998595548e-15,  1.456132859856600e-16, -2.251228517644211e-18,  3.303123374876966e-20, -4.624725110576314e-22,  2.956303634367003e-04,
 -2.074505183166652e-05,  8.929382334549131e-07, -2.935726844104252e-08,  8.055057290095692e-10, -1.931701342166357e-11,  4.164531729956348e-13, -8.224720792680777e-15,
  1.508061011058392e-16, -2.592910588351229e-18,  4.212722116899316e-20, -6.505732956571091e-22,  8.403404990652405e-05, -7.239837341575865e-06,  3.685857738140567e-07,
 -1.407423173055540e-08,  4.428382545217827e-10, -1.206192301123879e-11,  2.930938752119667e-13, -6.482650460846823e-15,  1.323952894851695e-16, -2.523470609475777e-18,
  4.525860531604959e-20, -7.686041149386147e-22,  2.140037102835073e-05, -2.230816427251554e-06,  1.334123066214052e-07, -5.886262976541908e-09,  2.114996962919795e-10,
 -6.519318009873835e-12,  1.779636875579239e-13, -4.394899796815960e-15,  9.968916547322240e-17, -2.100603870184483e-18,  4.147928399781817e-20, -7.726595394459664e-22,
  4.917904620346076e-06, -6.124858509131094e-07,  4.274772818844731e-08, -2.168939386267867e-09,  8.865558064928168e-11, -3.082434851205064e-12,  9.425122191875618e-14,
 -2.591807309142950e-15,  6.512963226588965e-17, -1.513543569886092e-18,  3.282872994481730e-20, -6.692367009563164e-22,  1.029458992289707e-06, -1.514650210510127e-07,
  1.225973142698312e-08, -7.120771068177309e-10,  3.299074804903892e-11, -1.289814405651978e-12,  4.405400164424968e-14, -1.345552589271009e-15,  3.737012793745850e-17,
 -9.556118444724906e-19,  2.271794281124024e-20, -5.057571030017661e-22,  1.986926861899991e-07, -3.418154525766456e-08,  3.188777774760322e-09, -2.110634657084041e-10,
  1.104341599810073e-11, -4.839918237414236e-13,  1.841467938125593e-14, -6.231368989275331e-16,  1.908227367023097e-17, -5.357376342447555e-19,  1.392925638467363e-20,
 -3.379321902058676e-22,  3.591422562966698e-08, -7.153533333150388e-09,  7.643555044053472e-10, -5.738282868766626e-11,  3.377778563871853e-12, -1.653991867280801e-13,
  6.989557890946093e-15, -2.613367764247291e-16,  8.801795850115631e-18, -2.706527598346956e-19,  7.678360986527387e-21, -2.025413732775042e-22,  6.200921866014787e-09,
 -1.416228535377476e-09,  1.721836970936717e-10, -1.458659367820881e-11,  9.618556829356897e-13, -5.242816846331883e-14,  2.452541557366571e-15, -1.010080650532768e-16,
  3.730686989040518e-18, -1.252985052537205e-19,  3.868322052068857e-21, -1.106571938483931e-22,  1.048328489366525e-09, -2.717965976868009e-10,  3.733058707998127e-11,
 -3.547965433352450e-12,  2.607855568302669e-13, -1.575339429933575e-14,  8.124821117570171e-16, -3.672126912350938e-17,  1.482105100264856e-18, -5.418607767723176e-20,
  1.814571818418098e-21, -5.611371389337437e-23,  1.788662975659389e-10, -5.208248095692933e-11,  8.015648999357794e-12, -8.488596798581222e-13,  6.913179143156960e-14,
 -4.603029747578387e-15,  2.604314501565281e-16, -1.285645810831597e-17,  5.645181137633736e-19, -2.237121038941069e-20,  8.092917612704437e-22, -2.694690999949245e-23,
  3.191990427276254e-11, -1.031654493526205e-11,  1.762333798901463e-12, -2.062436429827167e-13,  1.847268805885115e-14, -1.346488645372442e-15,  8.304126180651311e-17,
 -4.450778706960137e-18,  2.114006870099934e-19, -9.031208263607624e-21,  3.510793221935780e-22, -1.252293725139241e-23,  6.199767635511145e-12, -2.195178919077433e-12,
  4.115793384515962e-13, -5.269323648471096e-14,  5.142582465994074e-15, -4.068236406450001e-16,  2.712740092661681e-17, -1.566459122959390e-18,  7.989418132557193e-20,
 -3.653673934934319e-21,  1.515998364503827e-22, -5.755279099743504e-24,  1.363525257984575e-12, -5.212321421415207e-13,  1.058416344817359e-13, -1.464247005634840e-14,
  1.539278459366290e-15, -1.307339202340986e-16,  9.329245189273143e-18, -5.747652022231952e-19,  3.118670062387309e-20, -1.513172904664788e-21,  6.644334957227524e-23,
 -2.662645138988847e-24,  3.494045690386597e-13, -1.418885693775531e-13,  3.072012247881041e-14, -4.524889662580168e-15,  5.052456859422724e-16, -4.546198164013989e-17,
  3.428265374955132e-18, -2.226485756728549e-19,  1.270528451619083e-20, -6.468824808229816e-22,  2.974389067258589e-23, -1.245542177009507e-24,  1.029188775908469e-13,
 -4.362457243946319e-14,  9.891827098850557e-15, -1.524696658978571e-15,  1.778677034783757e-16, -1.669073689828122e-17,  1.310214037710987e-18, -8.842149058555526e-20,
  5.234234923683678e-21, -2.760072966442127e-22,  1.312350034302997e-23, -5.674072860999098e-25,  2.834284490408817e-14, -1.230815055747325e-14,  2.865502571064066e-15,
 -4.533274770213634e-16,  5.423075549793691e-17, -5.213172641753765e-18,  4.187902466428255e-19, -2.889340428814428e-20,  1.746849701664324e-21, -9.398916435708261e-23,
  4.555902725405210e-24, -2.006304308193170e-25,  9.503640342953772e-02, -3.805649209624705e-04,  1.602832025896585e-06, -7.022355839472644e-09,  3.159117920346633e-11,
 -1.445450075684857e-13,  6.663420409395542e-16, -3.086490526687017e-18,  1.426130011496280e-20, -6.601706068409313e-23,  3.027751168792140e-25, -1.397866667536213e-27,
  8.297954564596986e-02, -4.374168002213898e-04,  2.851844684342376e-06, -1.908658606378332e-08,  1.247102206565657e-10, -7.915489367252973e-13,  4.897249728089123e-15,
 -2.965956580934788e-17,  1.763594752617114e-19, -1.032280909177044e-21,  5.956608064699452e-24, -3.394623470517611e-26,  6.326887886912581e-02, -4.947420592013726e-04,
  4.701479875545890e-06, -4.158915014740464e-08,  3.446772779560868e-10, -2.721700040394762e-12,  2.068755131502458e-14, -1.523417093883373e-16,  1.091808594890103e-18,
 -7.641420356163131e-21,  5.236890139061682e-23, -3.521751724442909e-25,  4.213741213521872e-02, -4.920874588700591e-04,  6.187085203227817e-06, -6.833225997150970e-08,
  6.938768698522004e-10, -6.622961624188700e-12,  6.015968882881825e-14, -5.243760652922368e-16,  4.412597104788646e-18, -3.601148605743778e-20,  2.860460066671547e-22,
 -2.217617478526243e-24,  2.452462008040626e-02, -4.142331486062609e-04,  6.568414288814293e-06, -8.867191253601624e-08,  1.082847196312942e-09, -1.226346419028054e-11,
  1.307645930314377e-13, -1.326436334662795e-15,  1.289570262781212e-17, -1.208362567704735e-19,  1.096053017058808e-21, -9.656446086051674e-24,  1.248219312901032e-02,
 -2.935253581927703e-04,  5.739463407500592e-06, -9.343988057083915e-08,  1.353388590993756e-09, -1.794859379567078e-11,  2.219147195229350e-13, -2.589361064317013e-15,
  2.876404109126768e-17, -3.061956681729854e-19,  3.139340659165096e-21, -3.112250462263719e-23,  5.561118777332018e-03, -1.758847253120992e-04,  4.188054966125875e-06,
 -8.134561265839845e-08,  1.382861497712499e-09, -2.126992911542574e-11,  3.022033700627069e-13, -4.021864639150455e-15,  5.063706570076574e-17, -6.076379250207285e-19,
  6.989480064798837e-21, -7.740943916043917e-23,  2.171796457027744e-03, -8.973145186403883e-05,  2.578755389769761e-06, -5.922913355392324e-08,  1.172278943726116e-09,
 -2.075925817017043e-11,  3.366303350699807e-13, -5.076903068480549e-15,  7.200340056506261e-17, -9.682689981057119e-19,  1.242480646421848e-20, -1.528845613649379e-22,
  7.448997425315069e-04, -3.924755126266018e-05,  1.351068807412783e-06, -3.642629155754665e-08,  8.340490491965830e-10, -1.690677640158569e-11,  3.112329055785509e-13,
 -5.292479406828194e-15,  8.414792186322496e-17, -1.262281948925056e-18,  1.798948286150900e-20, -2.448791963451260e-22,  2.249806320609888e-04, -1.481778336349831e-05,
  6.067969080997846e-07, -1.908633298269779e-08,  5.029510936163957e-10, -1.161620213747208e-11,  2.417195028603138e-13, -4.616026496122458e-15,  8.196440947643960e-17,
 -1.366533494546074e-18,  2.155358867690386e-20, -3.234632449024106e-22,  6.005110107615856e-05, -4.862388107407026e-06,  2.353346112637302e-07, -8.590598812633258e-09,
  2.593984028181482e-10, -6.800011558458947e-12,  1.593895765489879e-13, -3.407070322115479e-15,  6.735463065420638e-17, -1.244394581922801e-18,  2.165972812718345e-20,
 -3.573737989905774e-22,  1.423417143614010e-05, -1.397116513159367e-06,  7.942963398000276e-08, -3.349442360487579e-09,  1.154604153890706e-10, -3.424282170616385e-12,
  9.014662745592123e-14, -2.151072694638031e-15,  4.722333570440935e-17, -9.644448131016361e-19,  1.848156648901041e-20, -3.344791638797013e-22,  3.015826646812667e-06,
 -3.544928892063950e-07,  2.353663634428645e-08, -1.141738922721434e-09,  4.478138246001649e-11, -1.498277844235310e-12,  4.418742242132909e-14, -1.174283785953183e-15,
  2.856502299544233e-17, -6.435358576812576e-19,  1.354935766176335e-20, -2.684396733435259e-22,  5.761233023068190e-07, -8.023564892573033e-08,  6.186797902650682e-09,
 -3.438806263271812e-10,  1.529897964511095e-11, -5.759437224785547e-13,  1.898488259505847e-14, -5.607014732131406e-16,  1.508311957750646e-17, -3.741313429051559e-19,
  8.638909173353252e-21, -1.870267429413744e-22,  1.003826797964394e-07, -1.640332001041063e-08,  1.460881090182652e-09, -9.268108834252240e-11,  4.662802960555381e-12,
 -1.970043179158906e-13,  7.241784446164937e-15, -2.372056740115110e-16,  7.042809821867674e-18, -1.919885894947458e-19,  4.853181048829578e-21, -1.146114754458398e-22,
  1.619618781663790e-08, -3.076871905234299e-09,  3.147539780562493e-10, -2.270063345848175e-11,  1.287385311516081e-12, -6.088014692424317e-14,  2.489720932476399e-15,
 -9.024812807174391e-17,  2.951430425608376e-18, -8.824919609994005e-20,  2.437570124829651e-21, -6.267688802837481e-23,  2.467993043645630e-09, -5.401497496181416e-10,
  6.309810166171508e-11, -5.150687483680182e-12,  3.280922651871348e-13, -1.731274117848873e-14,  7.855117060303473e-16, -3.143046437684522e-17,  1.129501510682246e-18,
 -3.695960648700743e-20,  1.113047820867186e-21, -3.109381551064266e-23,  3.642996628817454e-10, -9.099376418168172e-11,  1.206002675168360e-11, -1.108600141910212e-12,
  7.897941825313882e-14, -4.632983362930680e-15,  2.324269742412119e-16, -1.023361324804506e-17,  4.029177345870824e-19, -1.438744968240376e-20,  4.711021226373042e-22,
 -1.425981914001263e-23,  5.377930953295117e-11, -1.517489089930924e-11,  2.264931334500370e-12, -2.330204650470246e-13,  1.846841211833935e-14, -1.198613919834537e-15,
  6.619696041708448e-17, -3.194049095707407e-18,  1.372426192743511e-19, -5.327975604214327e-21,  1.890042870880342e-22, -6.177048138122196e-24,  8.255068141822682e-12,
 -2.601585707070975e-12,  4.333935052327112e-13, -4.952305205266419e-14,  4.336814032849250e-15, -3.094630198790464e-16,  1.870573769918707e-17, -9.836930007189092e-19,
  4.588833973942011e-20, -1.927124336657119e-21,  7.370590753949650e-23, -2.588732642936083e-24,  1.378339489800797e-12, -4.788865360562635e-13,  8.807590733451038e-14,
 -1.107016455002347e-14,  1.061683340641398e-15, -8.261252958540162e-17,  5.423273686536841e-18, -3.085649490887108e-19,  1.551855218654620e-20, -7.003003505724417e-22,
  2.869191935296766e-23, -1.076247589088781e-24,  2.624732972129639e-13, -9.904841514700935e-14,  1.984496284353699e-14, -2.710137369140827e-15,  2.814172023534480e-16,
 -2.362416611540600e-17,  1.667310965915186e-18, -1.016515649438881e-19,  5.461122065534902e-21, -2.624880323750477e-22,  1.142315157299220e-23, -4.539010018259479e-25,
  5.925089134685742e-14, -2.387790120343728e-14,  5.128109941029945e-15, -7.494245926602706e-16,  8.305412691774863e-17, -7.420057989762967e-18,  5.557657021160386e-19,
 -3.586296152209983e-20,  2.034049402606791e-21, -1.029642941941951e-22,  4.708343569904146e-24, -1.961375584895377e-25,  1.582215040399039e-14, -6.682502551867163e-15,
  1.509383375186047e-15, -2.317697689796910e-16,  2.693930297982890e-17, -2.519142901059611e-18,  1.970967122698037e-19, -1.325940337181590e-20,  7.825536835805908e-22,
 -4.114702102961228e-23,  1.951115454346334e-24, -8.413985761558536e-26,  4.108647087545859e-15, -1.782084183042776e-15,  4.143466877000846e-16, -6.546463353144871e-17,
  7.821456946693535e-18, -7.509486277950817e-19,  6.025460204975015e-20, -4.152379702441022e-21,  2.507708530541798e-22, -1.347845716764367e-23,  6.526714182323882e-25,
 -2.871388649537030e-26,  9.353926720734070e-02, -3.680709592402179e-04,  1.521503845838110e-06, -6.539183746339207e-09,  2.885345847291124e-11, -1.295404058482430e-13,
  5.859680775731484e-16, -2.665932505432307e-18,  1.208863524953978e-20, -5.505210325605291e-23,  2.474339139801910e-25, -1.128352792852456e-27,  8.127410373256154e-02,
 -4.154854407192896e-04,  2.634275351631112e-06, -1.721175565949792e-08,  1.099904698176853e-10, -6.833756046913042e-13,  4.140515917075166e-15, -2.456743908161416e-17,
  1.431493575285659e-19, -8.213748958453201e-22,  4.646683324752058e-24, -2.597299540928081e-26,  6.136210064903462e-02, -4.590367158262944e-04,  4.233786356095653e-06,
 -3.648419152308016e-08,  2.948821538784673e-10, -2.272678089045888e-12,  1.687247436724308e-14, -1.214294555339849e-16,  8.509685109620028e-19, -5.826311970003612e-21,
  3.907651675391715e-23, -2.572590558529556e-25,  4.026311620066824e-02, -4.456915721122902e-04,  5.429580241923503e-06, -5.821617527528466e-08,  5.747443301860716e-10,
 -5.340486910689700e-12,  4.727381286940717e-14, -4.018848349501180e-16,  3.300624445318831e-18, -2.630498419845209e-20,  2.041508002118214e-22, -1.547088043943347e-24,
  2.296643560952566e-02, -3.656651437435754e-04,  5.600730542170364e-06, -7.314983202828337e-08,  8.661780343826214e-10, -9.527902040883895e-12,  9.880352066301874e-14,
 -9.756799753271569e-16,  9.242135807118064e-18, -8.443906612802586e-20,  7.472567577991128e-22, -6.426729079242789e-24,  1.139330763966877e-02, -2.517521605165228e-04,
  4.737138323031025e-06, -7.439096320048359e-08,  1.042300852727694e-09, -1.339803582577744e-11,  1.608002020963637e-13, -1.823490065606530e-15,  1.970627297083745e-17,
 -2.042523194314789e-19,  2.040525176630127e-21, -1.972424339475835e-23,  4.918897891130556e-03, -1.459386842434691e-04,  3.331803456224440e-06, -6.226417920553906e-08,
  1.021737198587754e-09, -1.520372736278300e-11,  2.093373229336769e-13, -2.703541376510050e-15,  3.306951358235875e-17, -3.859055550419557e-19,  4.320428536273757e-21,
 -4.660694689656477e-23,  1.850041196239265e-03, -7.165447169072388e-05,  1.968143760946029e-06, -4.339921488895580e-08,  8.275910835017607e-10, -1.415468408989247e-11,
  2.221088492406414e-13, -3.246368886737540e-15,  4.467772393149144e-17, -5.836413605186295e-19,  7.282231144546717e-21, -8.720313761438199e-23,  6.070476748103173e-04,
 -2.998389263155656e-05,  9.840526206384400e-07, -2.542614617461792e-08,  5.600169889565999e-10, -1.094868022600016e-11,  1.947904317979682e-13, -3.206591370465552e-15,
  4.942357470956585e-17, -7.195677822695560e-19,  9.963496687669534e-21, -1.318951229183266e-22,  1.741398793942882e-04, -1.075855653700308e-05,  4.192901491275237e-07,
 -1.262164664736763e-08,  3.195290782681722e-10, -7.109666460578978e-12,  1.428375803295926e-13, -2.638248309477758e-15,  4.537720291720205e-17, -7.337633087104797e-19,
  1.123745580943719e-20, -1.639176924420002e-22,  4.380152255649310e-05, -3.330634176574907e-06,  1.532558007588933e-07, -5.348912616808247e-09,  1.550270552235465e-10,
 -3.911980723448030e-12,  8.846666499160903e-14, -1.827862041807991e-15,  3.498302025720952e-17, -6.265670534698066e-19,  1.058528785634271e-20, -1.697001484706228e-22,
  9.700347867745479e-06, -8.955791076104517e-07,  4.839191521069824e-08, -1.950181590007176e-09,  6.449421927872886e-11, -1.840376711497366e-12,  4.672468036184853e-14,
 -1.077329747855447e-15,  2.289071080766965e-17, -4.531142480519967e-19,  8.426414508498273e-21, -1.481635767863435e-22,  1.902274496310646e-06, -2.107745624860276e-07,
  1.330596239173684e-08, -6.169032089687448e-10,  2.321249703516665e-11, -7.472172058210227e-13,  2.125203587990321e-14, -5.457244119547587e-16,  1.284880653304411e-17,
 -2.805858640949913e-19,  5.733779679066514e-21, -1.103855365304370e-22,  3.329296256814538e-07, -4.382381345786969e-08,  3.216472962467236e-09, -1.709870666370703e-10,
  7.301422221040347e-12, -2.645686140185868e-13,  8.413673522060060e-15, -2.402037458990880e-16,  6.256689759135683e-18, -1.504972466511023e-19,  3.374342721626297e-21,
 -7.102089365556132e-23,  5.256099200287563e-08, -8.144374365592857e-09,  6.916811340835957e-10, -4.202400412483340e-11,  2.031471192944751e-12, -8.269233145320286e-14,
  2.935198400661422e-15, -9.301535774600766e-17,  2.676338768722468e-18, -7.080755058132736e-20,  1.739464085159093e-21, -3.996984074455935e-23,  7.594033012779053e-09,
 -1.373345211536245e-09,  1.343152628884988e-10, -9.295759968671946e-12,  5.074116712493643e-13, -2.315388950790143e-14,  9.156365662277956e-16, -3.215425049335863e-17,
  1.020391924052389e-18, -2.964889832945127e-20,  7.968639995088862e-22, -1.996129975353183e-23,  1.023676226841722e-09, -2.142511734336518e-10,  2.400848455886529e-11,
 -1.885860548796389e-12,  1.159040906364081e-13, -5.914537264572458e-15,  2.600279440804380e-16, -1.009916071938083e-17,  3.528242666199077e-19, -1.123924327247906e-20,
  3.299175491803185e-22, -8.994056684233498e-24,  1.320713873987556e-10, -3.171214956393639e-11,  4.048564133549861e-12, -3.593913108315211e-13,  2.478243343548396e-14,
 -1.409957285321763e-15,  6.872602995586539e-17, -2.944704241225429e-18,  1.129859206870096e-19, -3.936814377793307e-21,  1.259323075424480e-22, -3.727995148345954e-24,
  1.685678994551851e-11, -4.599351267312304e-12,  6.645063038010832e-13, -6.630752335813170e-14,  5.106759966213589e-15, -3.226181543226482e-16,  1.737050555240622e-17,
 -8.182499484945155e-19,  3.436777749874322e-20, -1.305695444264891e-21,  4.537593428556737e-23, -1.454263437813210e-24,  2.219064987111052e-12, -6.805506673774409e-13,
  1.103590503843395e-13, -1.229288642397548e-14,  1.050949971675875e-15, -7.331429186219343e-17,  4.337877838479907e-18, -2.235582969339740e-19,  1.023117179382055e-20,
 -4.219389161811340e-22,  1.586172432595548e-23, -5.480474920938950e-25,  3.167960709781622e-13, -1.078183837805903e-13,  1.942035268216832e-14, -2.392790175708666e-15,
  2.251987009846514e-16, -1.721445862970285e-17,  1.111251795341347e-18, -6.222951213223524e-20,  3.082940227856988e-21, -1.371513262567210e-22,  5.543573212516878e-24,
 -2.052856669284786e-25,  5.183788909383754e-14, -1.928583690627812e-14,  3.807723231188598e-15, -5.127109584762211e-16,  5.253009732064390e-17, -4.354142046390553e-18,
  3.036331820577806e-19, -1.830259547103123e-20,  9.727629863509918e-22, -4.628110536680666e-23,  1.994688184427137e-24, -7.853524464453002e-26,  1.021810833448665e-14,
 -4.083137881780333e-15,  8.691119791732099e-16, -1.259175257064250e-16,  1.383995539031830e-17, -1.226815705134070e-18,  9.120959780038974e-20, -5.844412336108503e-21,
  3.292767709964465e-22, -1.656304029524358e-23,  7.528607928101967e-25, -3.118436487790483e-26,  2.453296057717231e-15, -1.032022829165414e-15,  2.321054928620137e-16,
 -3.549123718762577e-17,  4.108704204849030e-18, -3.827434806221978e-19,  2.983680926397993e-20, -2.000291318077307e-21,  1.176667796079055e-22, -6.167632837886236e-24,
  2.915877107689622e-25, -1.253889324861097e-26,  5.973628788263761e-16, -2.587619917207986e-16,  6.007770066179935e-17, -9.478482066157464e-18,  1.130890049801620e-18,
 -1.084338702995823e-19,  8.689381369347574e-21, -5.980824891228162e-22,  3.607673076579587e-23, -1.936850767836254e-24,  9.368611639741147e-26, -4.117337130466048e-27,
  9.209084128018112e-02, -3.562051532126161e-04,  1.445720483853815e-06, -6.097515389374642e-09,  2.639745474231537e-11, -1.163309780922137e-13,  5.164528102270142e-16,
 -2.308989082725085e-18,  1.027355500730419e-20, -4.608166535539384e-23,  2.026274281006987e-25, -9.168059046460932e-28,  7.965304319155150e-02, -3.952084895470851e-04,
  2.437859213090856e-06, -1.555607391344351e-08,  9.726352632414370e-11, -5.917663470227292e-13,  3.512556631801878e-15, -2.042601897309511e-17,  1.166674846295843e-19,
 -6.564746702852428e-22,  3.641954107360841e-24, -1.997507686313993e-26,  5.959103042249454e-02, -4.268407752745832e-04,  3.822853015818513e-06, -3.210880687680405e-08,
  2.532177020073583e-10, -1.905645443525369e-12,  1.382418062536453e-14, -9.727355781160632e-17,  6.668288977224559e-19, -4.467952297408157e-21,  2.933669164630651e-23,
 -1.891411641456840e-25,  3.856300924859629e-02, -4.049007113285667e-04,  4.782826597231622e-06, -4.981672074194436e-08,  4.784269963072832e-10, -4.329835436732520e-12,
  3.736786501273980e-14, -3.099645277455568e-16,  2.485597191698465e-18, -1.935262480947668e-20,  1.468040124137788e-22, -1.087861742796230e-24,  2.158814185541244e-02,
 -3.241485800575314e-04,  4.800190573248562e-06, -6.069532928007830e-08,  6.972815036366847e-10, -7.453641887083069e-12,  7.520610953645156e-14, -7.233104326151122e-16,
  6.678572791292832e-18, -5.951841006281129e-20,  5.140910317652877e-22, -4.317742141629664e-24,  1.045681450826779e-02, -2.171613983139883e-04,  3.936299637100025e-06,
 -5.966431123656811e-08,  8.091378722909726e-10, -1.008653612364956e-11,  1.175686722873052e-13, -1.296338893245318e-15,  1.363488418633606e-17, -1.376590330616774e-19,
  1.340551812963267e-21, -1.263933320162592e-23,  4.384083898667502e-03, -1.220164804172415e-04,  2.673504375493532e-06, -4.809974430861766e-08,  7.623395508165382e-10,
 -1.098017868759640e-11,  1.465812190257684e-13, -1.837879627989122e-15,  2.184978619772782e-17, -2.480549132128358e-19,  2.703959562459502e-21, -2.842173205052158e-23,
  1.591906894674795e-03, -5.778715499562740e-05,  1.518320069517345e-06, -3.216110621860785e-08,  5.912000777260152e-10, -9.770872585884373e-12,  1.484286582770545e-13,
 -2.103373192158923e-15,  2.810064384803444e-17, -3.567302275505632e-19,  4.329420450067907e-21, -5.046944054134661e-23,  5.011195728699356e-04, -2.319473327698035e-05,
  7.262208751701414e-07, -1.799124951683088e-08,  3.813517755923052e-10, -7.193851632032952e-12,  1.237423240732574e-13, -1.972666315275976e-15,  2.948464988899720e-17,
 -4.167667986463614e-19,  5.608366360936277e-21, -7.221933417887357e-23,  1.369648873036001e-04, -7.932872751305151e-06,  2.943540016953658e-07, -8.482916569730133e-09,
  2.063879213142173e-10, -4.425555008989391e-12,  8.586987533577874e-14, -1.534456374130538e-15,  2.557147929628141e-17, -4.011460119786112e-19,  5.966555065114942e-21,
 -8.461008919479747e-23,  3.257710087104732e-05, -2.324442933905304e-06,  1.017006252354296e-07, -3.394402361930439e-09,  9.444875103066933e-11, -2.294689301309348e-12,
  5.007561410804459e-14, -1.000260039776807e-15,  1.853649555450610e-17, -3.219020266694810e-19,  5.279081375404535e-21, -8.224321102988629e-23,  6.765608992886060e-06,
 -5.869570734954276e-07,  3.013907947447947e-08, -1.160744834662314e-09,  3.682860112398689e-11, -1.011222067903193e-12,  2.476128988850872e-14, -5.516936817744780e-16,
  1.134592867465424e-17, -2.176879451232558e-19,  3.928771620028655e-21, -6.711696449367044e-23,  1.232802132865017e-06, -1.286029116885989e-07,  7.715712992205241e-09,
 -3.418104269499999e-10,  1.233653852279127e-11, -3.820286001100120e-13,  1.047739409440275e-14, -2.599470347688504e-16,  5.923298270293423e-18, -1.253696286381740e-19,
  2.486315421521344e-21, -4.650798438286654e-23,  1.984541567396218e-07, -2.465418334068984e-08,  1.721096937332973e-09, -8.745959997721075e-11,  3.583192258562878e-12,
 -1.249314628421674e-13,  3.831890746221358e-15, -1.057212769318640e-16,  2.665776973817434e-18, -6.216613157796289e-20,  1.353124136193610e-21, -2.768119599837473e-23,
  2.849763574008987e-08, -4.180123834008105e-09,  3.381778274143030e-10, -1.966117959967937e-11,  9.126425574648061e-13, -3.577174410505035e-14,  1.225458799777063e-15,
 -3.755387880519511e-17,  1.046694922655344e-18, -2.686518777550259e-20,  6.411202203642594e-22, -1.432865123341049e-23,  3.699859207859293e-09, -6.357284741533384e-10,
  5.936338285336127e-11, -3.938296780804620e-12,  2.067273351616717e-13, -9.095229135607038e-15,  3.475567578013967e-16, -1.181630080629932e-17,  3.636432486798164e-19,
 -1.026185347419919e-20,  2.682177956413876e-22, -6.542028096772299e-24,  4.424235739752848e-10, -8.836419783063424e-11,  9.483374737735214e-12, -7.158604183839456e-13,
  4.240112405268952e-14, -2.090290784176858e-15,  8.896378691822370e-17, -3.350974225742371e-18,  1.137184938154012e-19, -3.523849023088156e-21,  1.007519413607908e-22,
 -2.678510110205568e-24,  4.997046999449519e-11, -1.150874310326561e-11,  1.412731834333233e-12, -1.209195803465971e-13,  8.059703858426766e-15, -4.441840936237976e-16,
  2.101258413449704e-17, -8.752365800666539e-19,  3.269493936153981e-20, -1.110596456315463e-21,  3.467629084688830e-23, -1.003116771774940e-24,  5.513722010759395e-12,
 -1.451447005453695e-12,  2.026026228749815e-13, -1.957504125159008e-14,  1.462773958990985e-15, -8.982929491720926e-17,  4.709318919388078e-18, -2.163180043800858e-19,
  8.871572852677038e-21, -3.295045510298903e-22,  1.120721049998854e-23, -3.519034709832094e-25,  6.210153857196417e-13, -1.849431109908393e-13,  2.913817325631707e-14,
 -3.158543963485457e-15,  2.632121462799635e-16, -1.792517764992469e-17,  1.036822132705449e-18, -5.230176052151984e-20,  2.345564934526679e-21, -9.489073860799145e-23,
  3.502638732521786e-24, -1.189413992335519e-25,  7.542375346730291e-14, -2.509853802177991e-14,  4.419770603226897e-15, -5.329776747413387e-16,  4.915396617558836e-17,
 -3.686207411380192e-18,  2.337019484334790e-19, -1.286597205902347e-20,  6.272000926115690e-22, -2.747913656582252e-23,  1.094697796249478e-24, -3.998441048994201e-26,
  1.052498894784504e-14, -3.854916963244812e-15,  7.489602224991127e-16, -9.930414373007798e-17,  1.002666006264526e-17, -8.196991725988961e-19,  5.642054983764286e-20,
 -3.359288402799865e-21,  1.764722938084116e-22, -8.303778391161888e-24,  3.541589178772777e-25, -1.380637823507969e-26,  1.794928410110180e-15, -7.105375525702089e-16,
  1.497547362741759e-16, -2.149044105516293e-17,  2.340719832579249e-18, -2.057111491226835e-19,  1.516994557946902e-20, -9.645828048458351e-22,  5.395021827331787e-23,
 -2.695082943559594e-24,  1.217032423576948e-25, -5.009928154410893e-27,  3.840021978666776e-16, -1.608210798001079e-16,  3.599740738568521e-17, -5.478871399850072e-18,
  6.314609656489666e-19, -5.857540205470278e-20,  4.547979409848094e-21, -3.037433369908013e-22,  1.780322450959244e-23, -9.299797183015571e-25,  4.382362921850911e-26,
 -1.878691295649613e-27,  8.713176607295833e-17, -3.768931352912127e-17,  8.736775317893925e-18, -1.376271303645973e-18,  1.639584830584265e-19, -1.569824121747537e-20,
  1.256238776202769e-21, -8.635071255607421e-23,  5.202076819900330e-24, -2.789411815136318e-25,  1.347657761646373e-26, -5.916025037393032e-28,  9.068869869277975e-02,
 -3.449250625269682e-04,  1.375009799393446e-06, -5.693116947844287e-09,  2.418973275273660e-11, -1.046762606324046e-13,  4.561649857566662e-16, -2.005289830833961e-18,
  8.751260730929416e-21, -3.873172000214939e-23,  1.660709155883842e-25, -7.517741146071140e-28,  7.811006891879400e-02, -3.764267223730427e-04,  2.260147382265259e-06,
 -1.409014686982943e-08,  8.622697790941057e-11, -5.139271333155399e-13,  2.989533220028968e-15, -1.704430488749467e-17,  9.545794779901805e-20, -5.269478347799579e-22,
  2.867375414031759e-24, -1.544000180005426e-26,  5.794248625913892e-02, -3.977330825535166e-04,  3.460654470187510e-06, -2.834508467408998e-08,  2.182138393210699e-10,
 -1.604278680590083e-12,  1.137660495263161e-14, -7.829741282773535e-17,  5.252439751665114e-19, -3.445284250197597e-21,  2.215452699201767e-23, -1.399272431004322e-25,
  3.701632097871422e-02, -3.689054477935336e-04,  4.228247399691804e-06, -4.280873179821771e-08,  4.001394351694677e-10, -3.528772265949562e-12,  2.970523823181656e-14,
 -2.405265600809248e-16,  1.884009020707338e-18, -1.433594405234180e-20,  1.063341927593136e-22, -7.707864373244576e-25,  2.036399132124609e-02, -2.884814956034523e-04,
  4.134166091710337e-06, -5.063981462225795e-08,  5.647345605581790e-10, -5.869424450685534e-12,  5.764958579809063e-14, -5.402536598732486e-16,  4.864457671059248e-18,
 -4.230312627763438e-20,  3.567717835972416e-22, -2.927267101412144e-24,  9.646906901124110e-03, -1.883291960091277e-04,  3.291812928161886e-06, -4.819015083846807e-08,
  6.329201775917677e-10, -7.655388439192657e-12,  8.670253330750624e-14, -9.299624202955948e-16,  9.523911672273200e-18, -9.369882878739246e-20,  8.897811651881291e-22,
 -8.185849036645768e-24,  3.935410665414426e-03, -1.027454062561509e-04,  2.162819680043176e-06, -3.748417212625962e-08,  5.741230082305096e-10, -8.008309496214002e-12,
  1.037025924526664e-13, -1.262913360719973e-15,  1.459888300184448e-17, -1.613011140342463e-19,  1.712602141290904e-21, -1.754626563699475e-23,  1.382816062806859e-03,
 -4.703720783893904e-05,  1.183269567453990e-06, -2.409003064806149e-08,  4.271138733168695e-10, -6.824476907834721e-12,  1.004079760347044e-13, -1.380113273353867e-15,
  1.790566470104831e-17, -2.209737570473833e-19,  2.609457243218739e-21, -2.962231911151095e-23,  4.187260769006440e-04, -1.815479089811385e-05,  5.426633425098758e-07,
 -1.289630248627658e-08,  2.631962529006445e-10, -4.792691670419335e-12,  7.973732388898811e-14, -1.231452682762845e-15,  1.785506965889601e-17, -2.451079246989056e-19,
  3.206515099766048e-21, -4.017639981951337e-23,  1.093695781898284e-04, -5.935148888468932e-06,  2.097778389490210e-07, -5.789924797915489e-09,  1.354321645847980e-10,
 -2.799649683359382e-12,  5.248066452352562e-14, -9.075811365862524e-16,  1.465843975831487e-17, -2.231387400289092e-19,  3.224101906392211e-21, -4.445728352546606e-23,
  2.468071640406333e-05, -1.651185687013635e-06,  6.870851282394493e-08, -2.193514695587141e-09,  5.861028695835110e-11, -1.371342592143094e-12,  2.888467609911627e-14,
 -5.579165226944862e-16,  1.001311525153256e-17, -1.686273148519929e-19,  2.684921060323275e-21, -4.065345476709487e-23,  4.824140741209216e-06, -3.928934600522902e-07,
  1.917011563841376e-08, -7.055911478235689e-10,  2.148046621318860e-11, -5.675778181457102e-13,  1.340553126142649e-14, -2.886508779401732e-16,  5.746237526903299e-18,
 -1.068700449421612e-19,  1.871943009350805e-21, -3.107179338681518e-23,  8.199344484785630e-07, -8.043137674027202e-08,  4.584474790762245e-09, -1.940245924374779e-10,
  6.716192831653468e-12, -2.000663786295085e-13,  5.290697651456646e-15, -1.268186903022768e-16,  2.796604745491269e-18, -5.736720555505461e-20,  1.104058100058808e-21,
 -2.006484212602151e-23,  1.218891715860720e-07, -1.427064679887722e-08,  9.469156044856349e-10, -4.597704787581956e-11,  1.806675654849459e-12, -6.059501522916839e-14,
  1.792136356606588e-15, -4.777304273071646e-17,  1.165878025492795e-18, -2.635384755416001e-20,  5.567585206045579e-22, -1.106827651160141e-23,  1.598370616576582e-08,
 -2.215723453063727e-09,  1.705895355574265e-10, -9.483720018732178e-12,  4.224722393186801e-13, -1.593709345515868e-14,  5.267006830540601e-16, -1.560213402280705e-17,
  4.210793383221974e-19, -1.048113065206220e-20,  2.428957565708260e-22, -5.278209738331258e-24,  1.871732353337785e-09, -3.049857057872577e-10,  2.715619992038843e-11,
 -1.725257599370916e-12,  8.701490303222043e-14, -3.688447972622921e-15,  1.361074986350393e-16, -4.477280247228920e-18,  1.335445922795019e-19, -3.658060434942651e-21,
  9.293397225072155e-23, -2.205987597302414e-24,  1.991752846262738e-10, -3.788175781969940e-11,  3.887592542360293e-12, -2.816507322656626e-13,  1.605987533921302e-14,
 -7.641082745003726e-16,  3.145457106033129e-17, -1.148097200655565e-18,  3.781752680721178e-20, -1.139129493844241e-21,  3.170140750622144e-23, -8.213385878379529e-25,
  1.973655235435722e-11, -4.350055153710699e-12,  5.125071491549512e-13, -4.223227951564018e-14,  2.717264402901052e-15, -1.448891306039245e-16,  6.644719902718585e-18,
 -2.687863337446321e-19,  9.766133053865012e-21, -3.231213082900510e-22,  9.839173491895396e-24, -2.779125775750715e-25,  1.883662520137008e-12, -4.772854354560083e-13,
  6.424109366089484e-14, -5.999624272610875e-15,  4.343405241777924e-16, -2.589226775453982e-17,  1.320010428120719e-18, -5.905598756012879e-20,  2.362321950305026e-21,
 -8.568873021429821e-23,  2.849644254280182e-24, -8.758415571649285e-26,  1.812081856153348e-13, -5.228477185829048e-14,  7.987516979348095e-15, -8.410944766294761e-16,
  6.821163709226293e-17, -4.528255761986818e-18,  2.557041242463519e-19, -1.260969027709399e-20,  5.535087192847404e-22, -2.194203566421937e-23,  7.944579519475550e-25,
 -2.648837875852519e-26,  1.863857675362968e-14, -6.052063995302639e-15,  1.040006571837234e-15, -1.225390285815561e-16,  1.105713404632575e-17, -8.123471774344563e-19,
  5.051475974730380e-20, -2.730649042098196e-21,  1.308370255920087e-22, -5.639331664516609e-24,  2.212005875913900e-25, -7.961634915691231e-27,  2.201562271638099e-15,
 -7.925617209828615e-16,  1.512962614335391e-16, -1.972524321028368e-17,  1.960181858974953e-18, -1.578603483437217e-19,  1.071284882876408e-20, -6.293736226417004e-22,
  3.264752769092034e-23, -1.517949123892050e-24,  6.401191909371395e-26, -2.468810089021947e-27,  3.217247045230606e-16, -1.260325601163650e-16,  2.627426464691091e-17,
 -3.730952770722207e-18,  4.023273964071311e-19, -3.502518440731062e-20,  2.559920604526233e-21, -1.614046236421671e-22,  8.955784964815045e-24, -4.440203923140490e-25,
  1.990796043493492e-26, -8.139893914007753e-28,  6.073668606311443e-17, -2.531083489248619e-17,  5.635537979875376e-18, -8.533341854779345e-19,  9.786781164570986e-20,
 -9.036120831755847e-21,  6.984969419568150e-22, -4.645505189590932e-23,  2.712065080040591e-24, -1.411364925539363e-25,  6.627077298416004e-27, -2.831384887115104e-28,
  1.275391802188444e-17, -5.508127708798692e-18,  1.274654195524145e-18, -2.004519148719344e-19,  2.384125695743788e-20, -2.279098510674210e-21,  1.821080942013680e-22,
 -1.249957649421310e-23,  7.519771526970548e-25, -4.026835747675545e-26,  1.943022583847145e-27, -8.519202424597217e-29,  8.933057500641560e-02, -3.341918294738166e-04,
  1.308947400046254e-06, -5.322253123459518e-09,  2.220129737758537e-11, -9.437167789031051e-14,  4.037365970608879e-16, -1.746339158104806e-18,  7.468885154790815e-21,
 -3.271064517873436e-23,  1.359024428352997e-25, -6.254440686262686e-28,  7.663948564845671e-02, -3.589991732497151e-04,  2.099016416705261e-06, -1.278900148192298e-08,
  7.662897904858878e-11, -4.475768151810956e-13,  2.552356453083404e-15, -1.427229902140860e-17,  7.839859504917425e-20, -4.247573067689688e-22,  2.267211498488689e-24,
 -1.199491501060738e-26,  5.640485087021082e-02, -3.713514023798650e-04,  3.140449256022249e-06, -2.509622537202000e-08,  1.886904231495412e-10, -1.355757584513418e-12,
  9.402093896528602e-15, -6.331440254914970e-17,  4.157861726384979e-19, -2.670879706677152e-21,  1.682590843233359e-23, -1.041407072163866e-25,  3.560524456792369e-02,
 -3.370305727578367e-04,  3.750746514823956e-06, -3.693454184560541e-08,  3.361810193771287e-10, -2.890299978896973e-12,  2.374243442338296e-14, -1.877368604353241e-16,
  1.436957151040287e-18, -1.069012589672083e-20,  7.756029173708222e-23, -5.501394542057931e-25,  1.927256905169503e-02, -2.576937275980813e-04,  3.577059197037046e-06,
 -4.247283835970874e-08,  4.600419520231591e-10, -4.651084333378371e-12,  4.449108503001409e-14, -4.064367758107045e-16,  3.570159715595418e-18, -3.030858370743890e-20,
  2.496762916332395e-22, -2.001976341139443e-24,  8.942825246961956e-03, -1.641466087513338e-04,  2.769582349123652e-06, -3.918350133409271e-08,  4.986774600967475e-10,
 -5.855444128474900e-12,  6.446837737812807e-14, -6.729458361023648e-16,  6.713199662388986e-18, -6.438517077910374e-20,  5.964432232386501e-22, -5.356055186077455e-24,
  3.556390811032878e-03, -8.709727774001933e-05,  1.763247273074625e-06, -2.945544287641730e-08,  4.362328167834515e-10, -5.895924283773407e-12,  7.409454326099799e-14,
 -8.768120548289191e-16,  9.859339176652549e-18, -1.060598793710668e-19,  1.097226673427630e-21, -1.096107284231781e-23,  1.211920034968020e-03, -3.862078115074698e-05,
  9.310788126521654e-07, -1.822925431933114e-08,  3.118980152375322e-10, -4.820345317844505e-12,  6.872073390774132e-14, -9.165671153471488e-16,  1.155275503479182e-17,
 -1.386504531354291e-19,  1.593674554358494e-21, -1.762296184295465e-23,  3.539016558150594e-04, -1.436758047696365e-05,  4.103187390649208e-07, -9.358673845538174e-09,
  1.839884874286247e-10, -3.235546954369370e-12,  5.208749639372529e-14, -7.796059838606014e-16,  1.096916487321601e-17, -1.462886086645478e-19,  1.861024166128889e-21,
 -2.269521412621126e-23,  8.859230125041427e-05, -4.501855198047196e-06,  1.516526351986801e-07, -4.010292895063206e-09,  9.022153622829909e-11, -1.798675021638566e-12,
  3.258525722934053e-14, -5.455299229372162e-16,  8.541815136077829e-18, -1.262108199457057e-19,  1.771954599493412e-21, -2.376421475184918e-23,  1.902863990964930e-05,
 -1.192727974284926e-06,  4.721675910711134e-08, -1.442224443471916e-09,  3.701616931678667e-11, -8.343093367355446e-13,  1.696599132915096e-14, -3.169560661224906e-16,
  5.510346711495855e-18, -9.000915583727634e-20,  1.391675194240721e-21, -2.048325953157549e-23,  3.512902964624304e-06, -2.683196383550337e-07,  1.244047171583933e-08,
 -4.376503879046914e-10,  1.278556615757909e-11, -3.251509205328021e-13,  7.408604559327629e-15, -1.541863375780781e-16,  2.971504034790614e-18, -5.357622202727892e-20,
  9.108823490579900e-22, -1.469154096599874e-23,  5.590426977848824e-07, -5.150656414711454e-08,  2.788329573984335e-09, -1.127241889282842e-10,  3.742159368355459e-12,
 -1.072296526169716e-13,  2.734218569336166e-15, -6.332001547180048e-17,  1.351310493281421e-18, -2.686495644961726e-20,  5.017298053902872e-22, -8.858769377534887e-24,
  7.705200783699469e-08, -8.489710676931485e-09,  5.351273049701608e-10, -2.481733155848663e-11,  9.350988685485745e-13, -3.016334191499553e-14,  8.600609814425962e-16,
 -2.214792916289937e-17,  5.230520303461343e-19, -1.145857698855714e-20,  2.349235492969897e-22, -4.537727068980306e-24,  9.264611765380876e-09, -1.211715334172284e-09,
  8.870006732406324e-11, -4.712305923935510e-12,  2.013548292990119e-13, -7.307340982964396e-15,  2.328874492324538e-16, -6.666217857776411e-18,  1.741535008502022e-19,
 -4.202570478366908e-21,  9.454905552591549e-23, -1.997079343346375e-24,  9.824221910909770e-10, -1.515148192352598e-10,  1.284857791514724e-11, -7.809617235498506e-13,
  3.781683138532105e-14, -1.543402144831446e-15,  5.496459227153592e-17, -1.748443749983319e-18,  5.051925015259244e-20, -1.342586657028907e-21,  3.313776126457412e-23,
 -7.651691034403891e-25,  9.335970267056915e-11, -1.687265612930823e-11,  1.653233982463638e-12, -1.148143445148834e-13,  6.295875821248515e-15, -2.888363760074737e-16,
  1.149054182629076e-17, -4.061047836526608e-19,  1.297461349311836e-20, -3.796407971773208e-22,  1.027700135152132e-23, -2.593248238917801e-25,  8.137880334688373e-12,
 -1.712520251860279e-12,  1.933011382076871e-13, -1.531211815414834e-14,  9.497746445279155e-16, -4.894153210386201e-17,  2.173606873446274e-18, -8.530398005869797e-20,
  3.011942164626642e-21, -9.697985982317858e-23,  2.877633847648003e-24, -7.930064270314007e-26,  6.726071364868654e-13, -1.636448885564459e-13,  2.119643515096560e-14,
 -1.910212940983815e-15,  1.337701190821649e-16, -7.730385268236928e-18,  3.827623290776439e-19, -1.665950581675474e-20,  6.492808499240595e-22, -2.297723627028635e-23,
  7.464091160177543e-25, -2.243487336619998e-26,  5.520951561345974e-14, -1.539689873378810e-14,  2.276054788142898e-15, -2.323960899603154e-16,  1.831142668683987e-17,
 -1.183200993243003e-18,  6.513773060957109e-20, -3.136166702707794e-21,  1.345831485219810e-22, -5.221968083592319e-24,  1.852653066382565e-25, -6.058905292220898e-27,
  4.790329912288855e-15, -1.514465678042939e-15,  2.534626397855546e-16, -2.912762489862690e-17,  2.567351568155114e-18, -1.845077685007865e-19,  1.123796589387449e-20,
 -5.957282959283301e-22,  2.802190192612933e-23, -1.186892049413504e-24,  4.579136737962594e-26, -1.622528967259283e-27,  4.754952449383857e-16, -1.679540664177014e-16,
  3.144917507235486e-17, -4.025493502005433e-18,  3.931537284427319e-19, -3.114940890247447e-20,  2.081639468673448e-21, -1.205354960854452e-22,  6.167583852738395e-24,
 -2.830776221080777e-25,  1.179215851583448e-26, -4.495659837049924e-28,  5.895421300435474e-17, -2.282730749586456e-17,  4.701586709246797e-18, -6.599009850801486e-19,
  7.038012240909339e-20, -6.063615425962109e-21,  4.388497473893001e-22, -2.741477389252096e-23,  1.507912886149831e-24, -7.414605009787559e-26,  3.298512703508183e-27,
 -1.338764682372710e-28,  9.718346211076966e-18, -4.027516615244044e-18,  8.914624974263067e-19, -1.342148295351815e-19,  1.530921258011645e-20, -1.406212413377008e-21,
  1.081709035903404e-22, -7.160954667674398e-24,  4.162345288726860e-25, -2.157140017268760e-26,  1.008919156815992e-27, -4.294580934083194e-29,  1.874075217493247e-18,
 -8.079725410567447e-19,  1.866236891762660e-19, -2.929399715213908e-20,  3.477920933782627e-21, -3.319002609988390e-22,  2.647644786081918e-23, -1.814440728779236e-24,
  1.089930412280605e-25, -5.828177063383906e-27,  2.808328215475178e-28, -1.229693074936305e-29,  8.801435469607137e-02, -3.239698197755927e-04,  1.247151062903192e-06,
 -4.981621514187829e-09,  2.040693499949917e-11, -8.524281390499693e-14,  3.580153084325572e-16, -1.525179015861466e-18,  6.382792045218049e-21, -2.779548195096443e-23,
  1.105237999591979e-25, -5.337238486948294e-28,  7.523612980903673e-02, -3.428007302525610e-04,  1.952619802010423e-06, -1.163135278174661e-08,  6.825904607482373e-11,
 -3.908457914386458e-13,  2.185674921840321e-15, -1.199168322886316e-17,  6.462013767918571e-20, -3.437993140213467e-22,  1.799800903408048e-24, -9.367609198575741e-27,
  5.496785497266044e-02, -3.473830873378868e-04,  2.856552162406092e-06, -2.228241628233058e-08,  1.636955863569348e-10, -1.149961899939448e-12,  7.801984732158053e-15,
 -5.142622976757350e-17,  3.307215193925024e-19, -2.081187126161344e-21,  1.284913235233820e-23, -7.795497566104775e-26,  3.431445074029387e-02, -3.087102180293511e-04,
  3.337993412690247e-06, -3.198883152266451e-08,  2.836728360941766e-10, -2.378700405315723e-12,  1.907571393181349e-14, -1.473572814667800e-16,  1.102580615739468e-18,
 -8.022319827097000e-21,  5.695447539168383e-23, -3.954303847728699e-25,  1.829596694053550e-02, -2.309975298812095e-04,  3.108657338806383e-06, -3.580197353073625e-08,
  3.768390059697387e-10, -3.707894658278166e-12,  3.455906240999192e-14, -3.078818220874490e-16,  2.639450535489600e-18, -2.188247135157399e-20,  1.761424285221989e-22,
 -1.380717115187910e-24,  8.327754592506420e-03, -1.437435019751484e-04,  2.343644580498740e-06, -3.206346187712765e-08,  3.956316796499182e-10, -4.512025753375541e-12,
  4.831529522846301e-14, -4.910290284664137e-16,  4.773487440753610e-18, -4.464762459403799e-20,  4.036248029472408e-22, -3.539173088993936e-24,  3.234131483886903e-03,
 -7.429487854823193e-05,  1.448060617773389e-06, -2.333019463342141e-08,  3.342787243134837e-10, -4.379859664701154e-12,  5.344213124512169e-14, -6.147938283225947e-16,
  6.727346126896037e-18, -7.048547623727773e-20,  7.107703668947859e-22, -6.925705854026353e-24,  1.071059540879314e-03, -3.196910378046317e-05,  7.393566655450142e-07,
 -1.392855865810477e-08,  2.301031263241044e-10, -3.441446514611078e-12,  4.756176627237017e-14, -6.158097467184276e-16,  7.543685498303587e-18, -8.807731183129431e-20,
  9.857371641726909e-22, -1.062164459753627e-23,  3.023498562258711e-04, -1.148871293764720e-05,  3.137434165484996e-07, -6.871389336465529e-09,  1.301964694985310e-10,
 -2.212127156487834e-12,  3.447313362268249e-14, -5.002369503982008e-16,  6.832578775514345e-18, -8.855395611893754e-20,  1.095849077047298e-21, -1.301081033687499e-23,
  7.273789968152045e-05, -3.459069541444038e-06,  1.111279415858009e-07, -2.816732228035523e-09,  6.097468055840229e-11, -1.172795160571137e-12,  2.054093832167435e-14,
 -3.330227573437735e-16,  5.056719777257557e-18, -7.254351976155979e-20,  9.899012330275823e-22, -1.291534015967866e-23,  1.491629373815141e-05, -8.752903382026069e-07,
  3.297717985223122e-08, -9.640254072952106e-10,  2.377450648860619e-11, -5.163468681072910e-13,  1.014019599640588e-14, -1.832723914163192e-16,  3.087169666492824e-18,
 -4.892292683170346e-20,  7.346800289044284e-22, -1.051317213463578e-23,  2.609739612853670e-06, -1.867634476577583e-07,  8.229185157065781e-09, -2.767397778985953e-10,
  7.759711204061443e-12, -1.899649295366336e-13,  4.176317865317848e-15, -8.402217030130048e-17,  1.567862467161522e-18, -2.740844613678251e-20,  4.523546344146420e-22,
 -7.090220154801968e-24,  3.903106903143528e-07, -3.373531773919708e-08,  1.734206430040722e-09, -6.696607860258705e-11,  2.132079748166699e-12, -5.876954537568005e-14,
  1.444998936083569e-15, -3.233175247956176e-17,  6.677646414681356e-19, -1.286657114706825e-20,  2.331889528900214e-22, -4.000113220830663e-24,  5.007576432275725e-08,
 -5.185062904140297e-09,  3.103102124004691e-10, -1.374149908339917e-11,  4.963808882486528e-13, -1.539706195428283e-14,  4.232034980798072e-16, -1.052679048185927e-17,
  2.405480906573387e-19, -5.106639465149557e-21,  1.015910846335656e-22, -1.906406361960311e-24,  5.543642106262033e-09, -6.829456788561503e-10,  4.749375630967979e-11,
 -2.409814760062758e-12,  9.872631694901475e-14, -3.445558987656970e-15,  1.058620001821861e-16, -2.927251802518373e-18,  7.400585318867368e-20, -1.730902036151455e-21,
  3.779487115281034e-23, -7.757671664119237e-25,  5.345154197648446e-10, -7.787752595204945e-11,  6.282320581224836e-12, -3.650150792339930e-13,  1.695813196403932e-14,
 -6.659694612050320e-16,  2.287650760581934e-17, -7.033632811395894e-19,  1.967779668424020e-20, -5.071436195155477e-22,  1.215583025446545e-23, -2.729263653541935e-25,
  4.553645271600000e-11, -7.803331275499555e-12,  7.289342659714901e-13, -4.847022519590975e-14,  2.553506811513779e-15, -1.128603189017908e-16,  4.335623990433120e-18,
 -1.482656474987761e-19,  4.591426023692998e-21, -1.304215113061601e-22,  3.432166049884896e-24, -8.429999005855070e-26,  3.502615102971427e-12, -7.020893233527536e-13,
  7.579012935657186e-14, -5.762805411500321e-15,  3.441662830653785e-16, -1.711946045606737e-17,  7.355502683487822e-19, -2.798008205977393e-20,  9.591928229115067e-22,
 -3.003119969342629e-23,  8.676527729468207e-25, -2.331055031486241e-26,  2.511656873278792e-13, -5.853013796292458e-14,  7.280984396515161e-15, -6.320780797526278e-16,
  4.275258196318448e-17, -2.391751208661865e-18,  1.148749331111210e-19, -4.858540888832035e-21,  1.842920312362254e-22, -6.356461173935446e-24,  2.015087557708992e-25,
 -5.917802447846865e-27,  1.758634592206898e-14, -4.728483975934791e-15,  6.749204859399458e-16, -6.669533499916922e-17,  5.097280574397728e-18, -3.200931906891260e-19,
  1.715576955412202e-20, -8.054047948933880e-22,  3.374840315148819e-23, -1.280255828608619e-24,  4.445905248870367e-26, -1.424751443728546e-27,  1.283003159141558e-15,
 -3.940076807991396e-16,  6.408676528760922e-17, -7.169577202910862e-18,  6.162321113639134e-19, -4.325397878913694e-20,  2.576745520162971e-21, -1.337725292259188e-22,
  6.169681798532233e-24, -2.565014653683235e-25,  9.723079755429057e-27, -3.388141799289366e-28,  1.062873615173485e-16, -3.676395980674809e-17,  6.740168060094543e-18,
 -8.456093853254643e-19,  8.104328811586130e-20, -6.308172461147775e-21,  4.145895653149775e-22, -2.363253581597113e-23,  1.191466927678111e-24, -5.392645827258952e-26,
  2.216914750636195e-27, -8.346889783075895e-29,  1.106747029749047e-17, -4.230053248789796e-18,  8.596150600864184e-19, -1.191103422380795e-19,  1.254985338142683e-20,
 -1.068920056116478e-21,  7.653247126486928e-23, -4.732631993645089e-24,  2.578307555477122e-25, -1.256378536005752e-26,  5.541675964523876e-28, -2.231139511715792e-29,
  1.575112429649221e-18, -6.487110682308095e-19,  1.426436627416358e-19, -2.133923244801314e-20,  2.419343632570636e-21, -2.209558146715692e-22,  1.690494204505979e-23,
 -1.113407631033583e-24,  6.440570733309418e-26, -3.322631746431482e-27,  1.547336040407317e-28, -6.559601910771552e-30,  2.765506990124817e-19, -1.190018759070088e-19,
  2.742973140619655e-20, -4.296814728025481e-21,  5.091358760563055e-22, -4.849580992661994e-23,  3.861674020557179e-24, -2.641881323163733e-25,  1.584373374720646e-26,
 -8.458853448279795e-28,  4.069832441314482e-29, -1.779529316968553e-30,  8.673805889991162e-02, -3.142263050251396e-04,  1.189275883793761e-06, -4.668296668473996e-09,
  1.878465875503453e-11, -7.714072167403377e-14,  3.180251808549938e-16, -1.336131351950828e-18,  5.456252778695967e-21, -2.382489395853429e-23,  8.841702537261010e-26,
 -4.773605836644875e-28,  7.389531027292016e-02, -3.277200864282294e-04,  1.819347409003455e-06, -1.059900334971300e-08,  6.094065592847066e-11, -3.421960910869207e-13,
  1.877091553119627e-15, -1.010874045654536e-17,  5.344569780896732e-20, -2.794203038343317e-22,  1.433758711218773e-24, -7.359525715988190e-27,  5.362239462925113e-02,
 -3.255573850105769e-04,  2.604150636265468e-06, -1.983757593184443e-08,  1.424580891575915e-10, -9.788634318473164e-13,  6.499620360985091e-15, -4.194904492692984e-17,
  2.642798725048759e-19, -1.629720412983436e-21,  9.864388500712585e-24, -5.867763749997446e-26,  3.313069097045462e-02, -2.834680363294554e-04,  2.979866992687754e-06,
 -2.780711786045897e-08,  2.403623202981418e-10, -1.966660323143897e-12,  1.540319765354003e-14, -1.162877561705808e-16,  8.509142170111867e-19, -6.057203161010094e-21,
  4.209564483531101e-23, -2.861575905510900e-25,  1.741913201586588e-02, -2.077496227914306e-04,  2.712901353329805e-06, -3.032351575290629e-08,  3.103234170565200e-10,
 -2.973063267097724e-12,  2.701146536287937e-14, -2.347743533803488e-16,  1.965120993207119e-18, -1.591608017672259e-20,  1.252338788503092e-22, -9.599806747067392e-25,
  7.787985444007478e-03, -1.264322506459929e-04,  1.994077761539298e-06, -2.639665801357985e-08,  3.159564689806423e-10, -3.501564343066245e-12,  3.648394083008886e-14,
 -3.611593440070637e-16,  3.422817558595470e-18, -3.123329282172377e-20,  2.756474603460331e-22, -2.360884270328662e-24,  2.958467967482152e-03, -6.374555113923768e-05,
  1.197509071576095e-06, -1.861826744593766e-08,  2.582297310349348e-10, -3.281655408720828e-12,  3.889620954371250e-14, -4.351762440679828e-16,  4.635841149777657e-18,
 -4.732624129444112e-20,  4.653432483667945e-22, -4.424193506389416e-24,  9.540361992093048e-04, -2.666508851183943e-05,  5.922184941194754e-07, -1.074092630118932e-08,
  1.714218298398589e-10, -2.482276989614146e-12,  3.327137572989584e-14, -4.183629567033519e-16,  4.982830190637742e-18, -5.661878486680426e-20,  6.172009082816374e-22,
 -6.482609050769780e-24,  2.609385769663031e-04, -9.276271191036249e-06,  2.424591973232256e-07, -5.101585918543484e-09,  9.320914687161207e-11, -1.530813729963428e-12,
  2.310263844355079e-14, -3.251470251406911e-16,  4.312779399583905e-18, -5.433933757004937e-20,  6.543293284560912e-22, -7.565722593979929e-24,  6.048686242219384e-05,
 -2.690287172027919e-06,  8.248551122031044e-08, -2.004869011516777e-09,  4.177848014855709e-11, -7.755882540883993e-13,  1.313776548017726e-14, -2.063390683597724e-16,
  3.039337067728271e-18, -4.234682255814126e-20,  5.617861678046596e-22, -7.132457249199410e-24,  1.187769453039928e-05, -6.519863059338217e-07,  2.338894525945567e-08,
 -6.545889151223246e-10,  1.551701398989707e-11, -3.248434267911377e-13,  6.162587879520247e-15, -1.077869482089467e-16,  1.759645337414103e-18, -2.705977383276840e-20,
  3.947654145497882e-22, -5.493326664184909e-24,  1.975959778126352e-06, -1.323597933031255e-07,  5.543540749854993e-09, -1.782413209116625e-10,  4.798008399462859e-12,
 -1.130958288454105e-13,  2.399523661838143e-15, -4.667659013912888e-17,  8.434755565313187e-19, -1.429875138130736e-20,  2.291177021115916e-22, -3.490353305036423e-24,
  2.787419922543125e-07, -2.257456902934001e-08,  1.101861678368903e-09, -4.064091811278853e-11,  1.241032791878734e-12, -3.290964244628405e-14,  7.803164799832971e-16,
 -1.687017480968384e-17,  3.372275434452078e-19, -6.297895862555978e-21,  1.107698807188448e-22, -1.846125191283523e-24,  3.341985418696909e-08, -3.247416490287774e-09,
  1.844499409608240e-10, -7.797572521035469e-12,  2.699986756621635e-13, -8.052775576110430e-15,  2.133471828867396e-16, -5.125637293499644e-18,  1.133234241502102e-19,
 -2.331153953066947e-21,  4.499707319699593e-23, -8.202714282842568e-25,  3.420601240819595e-09, -3.962746461581079e-10,  2.616081920198586e-11, -1.267138639604488e-12,
  4.975497964913647e-14, -1.669413194665762e-15,  4.943395841115021e-17, -1.320167164097229e-18,  3.229168643300777e-20, -7.318572562871058e-22,  1.550643922916121e-23,
 -3.092275874881588e-25,  3.011676365964103e-10, -4.137424263759274e-11,  3.171583857675709e-12, -1.760121555528554e-13,  7.840605958873949e-15, -2.961257989471744e-16,
  9.807007577763374e-18, -2.913117899647152e-19,  7.888025954388583e-21, -1.970707273381915e-22,  4.585480176641156e-24, -1.000719878435920e-25,  2.309568565252291e-11,
 -3.744652896551002e-12,  3.330115927821588e-13, -2.117840790833006e-14,  1.070926995255688e-15, -4.556445272166736e-17,  1.689065433588875e-18, -5.585215174413214e-20,
  1.675442161725777e-21, -4.617429791112947e-23,  1.180598436501778e-24, -2.821038912316897e-26,  1.573273323981282e-12, -2.996669302036861e-13,  3.088312270253754e-14,
 -2.250852973737881e-15,  1.292717800792569e-16, -6.200460403677565e-18,  2.574794245089415e-19, -9.485015216735289e-21,  3.154358290223276e-22, -9.595485020998134e-24,
  2.697329627735034e-25, -7.059837991703723e-27,  9.812143458934470e-14, -2.184446487817596e-14,  2.604481822080762e-15, -2.174313169193443e-16,  1.418339007629141e-17,
 -7.671231751365878e-19,  3.569660279900181e-20, -1.465436831346393e-21,  5.404344413121957e-23, -1.814963970071046e-24,  5.609727277723364e-26, -1.608214740551114e-27,
  5.863610738813191e-15, -1.515966222753782e-15,  2.084690466860829e-16, -1.989977810024995e-17,  1.472653895986181e-18, -8.973687098205905e-20,  4.675755678509407e-21,
 -2.137603710072412e-22,  8.735474366341217e-24, -3.236205365818661e-25,  1.098848788331591e-26, -3.447116857738338e-28,  3.587889051707618e-16, -1.067587610198037e-16,
  1.683879482789474e-17, -1.830253396805747e-18,  1.531292600315801e-19, -1.048062087730731e-20,  6.097572163747156e-22, -3.095907245542986e-23,  1.398211192707270e-24,
 -5.698918020841322e-26,  2.120114475836459e-27, -7.257822130598388e-29,  2.464838800887909e-17, -8.330935690674839e-18,  1.492479306035771e-18, -1.831940216952555e-19,
  1.720071282492100e-20, -1.313335459498662e-21,  8.477053712952420e-23, -4.750725227758669e-24,  2.357129375474119e-25, -1.050868421296303e-26,  4.258943984269753e-28,
 -1.582083325268829e-29,  2.133418993914315e-18, -8.036587295497655e-19,  1.609002074038787e-19, -2.197954797018348e-20,  2.284959852428780e-21, -1.921789852784697e-22,
  1.359744257353220e-23, -8.315179044089899e-25,  4.482747711261530e-26, -2.162880000284230e-27,  9.451422293549725e-29, -3.771894284803928e-30,  2.589615741161968e-19,
 -1.059083234235663e-19,  2.311647842353591e-20, -3.433619443241136e-21,  3.866659300089010e-22, -3.508929282632645e-23,  2.668538132376391e-24, -1.747651354068441e-25,
  1.005555599536615e-26, -5.161494587089721e-28,  2.392272055118599e-29, -1.009609901367662e-30,  4.100144351413994e-20, -1.760579685534896e-20,  4.048781102286396e-21,
 -6.328052244213230e-22,  7.481974921457798e-23, -7.111942384018600e-24,  5.652013314406921e-25, -3.859444989750669e-26,  2.310422342963433e-27, -1.231412895720828e-28,
  5.915084505586113e-30, -2.582351996028871e-31,  8.549983436544255e-02, -3.049311813890263e-04,  1.135010047551978e-06, -4.379682313951750e-09,  1.731523870810696e-11,
 -6.993809677250001e-14,  2.829335950269064e-16, -1.174612397181700e-18,  4.657228383139298e-21, -2.070090520732608e-23,  6.787615517563786e-26, -4.648192977246328e-28,
  7.261275669641373e-02, -3.136579881579742e-04,  1.697791496359937e-06, -9.676349375560410e-09,  5.452527019976411e-11, -3.003580850048704e-13,  1.616553661267929e-15,
 -8.548959562748701e-18,  4.434527344356636e-20, -2.280647836270510e-22,  1.145163513655809e-24, -5.827589146002360e-27,  5.236037665290903e-02, -3.056390696877477e-04,
  2.379156054920616e-06, -1.770677197987098e-08,  1.243503073187298e-10, -8.360633945164540e-13,  5.435139492120435e-15, -3.435942857673019e-17,  2.121317420297454e-19,
 -1.282268539925405e-21,  7.612030583303548e-24, -4.440104845436181e-26,  3.204247187194503e-02, -2.609013276019587e-04,  2.668020531377365e-06, -2.425695479095502e-08,
  2.044772279485532e-10, -1.633169809144007e-12,  1.249775030559772e-14, -9.224557670950736e-17,  6.603587045205185e-19, -4.600397999484010e-21,  3.130969325575572e-23,
 -2.084235767668285e-25,  1.662934884065777e-02, -1.874218335662337e-04,  2.376956273667242e-06, -2.580092191722729e-08,  2.568470323052621e-10, -2.397063209662718e-12,
  2.123846241833691e-14, -1.801682593192595e-16,  1.472988029045131e-18, -1.165899548510800e-20,  8.970801861541879e-23, -6.726604442605042e-25,  7.312270219316534e-03,
 -1.116657574741246e-04,  1.705483876059760e-06, -2.185725790443352e-08,  2.539220370957190e-10, -2.735889998556290e-12,  2.774993848431280e-14, -2.676792527115516e-16,
  2.474178252309130e-18, -2.203418516407932e-20,  1.899111050280363e-22, -1.589315081897707e-24,  2.721323894925609e-03, -5.499359491439453e-05,  9.968676860403266e-07,
 -1.496479621678833e-08,  2.010251267863006e-10, -2.479057047285752e-12,  2.855556730600562e-14, -3.108456607447009e-16,  3.225015435645083e-18, -3.209116502025003e-20,
  3.077904518053454e-22, -2.856190803980927e-24,  8.560962146054040e-04, -2.239978800546125e-05,  4.782759580827867e-07, -8.355636670638401e-09,  1.288982788011879e-10,
 -1.808041881072144e-12,  2.351409297947684e-14, -2.872668548725080e-16,  3.327852540900893e-18, -3.681384906500781e-20,  3.910177846558903e-22, -4.004547302521654e-24,
  2.273580724727515e-04, -7.558266263464223e-06,  1.892676634066985e-07, -3.827880247392058e-09,  6.747360831240779e-11, -1.071646641907292e-12,  1.566912803181965e-14,
 -2.139723369922214e-16,  2.757169471163111e-18, -3.378339806098882e-20,  3.959719957775970e-22, -4.460153405203239e-24,  5.090772972887153e-05, -2.116349646898334e-06,
  6.197649503226715e-08, -1.445159053886037e-09,  2.900314280901532e-11, -5.198890806767546e-13,  8.520409491651465e-15, -1.296824636286204e-16,  1.853635592177428e-18,
 -2.509062807750187e-20,  3.236998599601133e-22, -4.000182946162898e-24,  9.599591285913666e-06, -4.925206030659263e-07,  1.683259438943242e-08, -4.511778246994479e-10,
  1.028413252294597e-11, -2.075966721410158e-13,  3.805692612944621e-15, -6.443448043321469e-17,  1.019746040432697e-18, -1.522116867933368e-20,  2.157711197981990e-22,
 -2.920407212513386e-24,  1.523309868012741e-06, -9.541557199109142e-08,  3.799651846314273e-09, -1.168345527756354e-10,  3.020067971969527e-12, -6.855970039795759e-14,
  1.404132005095429e-15, -2.641497171298437e-17,  4.623483148373566e-19, -7.601909683219105e-21,  1.182824569031368e-22, -1.751559853623805e-24,  2.034028503237307e-07,
 -1.541700729888755e-08,  7.144941839781258e-10, -2.517348007341800e-11,  7.373673462343752e-13, -1.881345243552677e-14,  4.302304152895627e-16, -8.988469299613195e-18,
  1.739170754936741e-19, -3.148371273620437e-21,  5.374348653205727e-23, -8.702963131980580e-25,  2.287832694647059e-08, -2.083308973025556e-09,  1.122677644557918e-10,
 -4.530140430589089e-12,  1.503504558310883e-13, -4.311553694854987e-15,  1.101018888507683e-16, -2.554823933795463e-18,  5.464980653407563e-20, -1.089294881879668e-21,
  2.040028264769497e-23, -3.612464782698222e-25,  2.173994135549719e-09, -2.364509282008566e-10,  1.480874234156425e-11, -6.844448477128743e-13,  2.575058887890549e-14,
 -8.304505109029523e-16,  2.369567677292061e-17, -6.110495288519333e-19,  1.445832919134681e-20, -3.174744319772849e-22,  6.525981219295154e-24, -1.264167684342299e-25,
  1.755464914184498e-10, -2.269647886968640e-11,  1.651614665857835e-12, -8.748740090459277e-14,  3.734675598638665e-15, -1.355900678825394e-16,  4.327470069918094e-18,
 -1.241432462470915e-19,  3.252314958688924e-21, -7.874048542832375e-23,  1.777979760881534e-24, -3.770345048275700e-26,  1.217088926875636e-11, -1.863036620659984e-12,
  1.575140554568089e-13, -9.570951453941844e-15,  4.641521675674269e-16, -1.899643083729229e-17,  6.790759418524340e-19, -2.169977820522292e-20,  6.302067838709362e-22,
 -1.684191831515767e-23,  4.181715392115467e-25, -9.716157186102471e-27,  7.371714271696788e-13, -1.331015095118766e-13,  1.307329947854402e-14, -9.120616276200559e-16,
  5.031551542652053e-17, -2.324767469510208e-18,  9.321716367772626e-20, -3.322640464088432e-21,  1.071099623130601e-22, -3.163383065978144e-24,  8.645803333237597e-26,
 -2.203057088235752e-27,  4.011042975628881e-14, -8.508305957491214e-15,  9.703122739008816e-16, -7.776798555913542e-17,  4.885296216098705e-18, -2.551185503521412e-19,
  1.148794982530933e-20, -4.572657341488722e-22,  1.637865685849608e-23, -5.350624178619719e-25,  1.610945214332302e-26, -4.504485458026268e-28,  2.048391098129186e-15,
 -5.078250469345175e-16,  6.712806301114662e-17, -6.177749648444014e-18,  4.419229435034756e-19, -2.609022486563602e-20,  1.319753545617372e-21, -5.867779961070009e-23,
  2.335752466462004e-24, -8.440906135002062e-26,  2.799397708039102e-27, -8.587805710533662e-29,  1.049550646788989e-16, -3.017752245804066e-17,  4.604886623761262e-18,
 -4.852860421059779e-19,  3.944911629560023e-20, -2.628352934846729e-21,  1.491109240694530e-22, -7.393643212495054e-24,  3.265565572269294e-25, -1.303270286369838e-26,
  4.752820374230310e-28, -1.596667948964545e-29,  5.944919519011232e-18, -1.958808815894990e-18,  3.421656693585745e-19, -4.101076117239531e-20,  3.765765954883424e-21,
 -2.815943635904698e-22,  1.782391478295337e-23, -9.807213647854356e-25,  4.782649012754983e-26, -2.097799325311667e-27,  8.372272149616785e-29, -3.065298369912092e-30,
  4.233244988345768e-19, -1.568996294572459e-19,  3.089700817975893e-20, -4.154650743657553e-21,  4.255581902117136e-22, -3.529802311068291e-23,  2.465130196858020e-24,
 -1.489148578228197e-25,  7.936202998489529e-27, -3.787877083115184e-28,  1.638421292528098e-29, -6.476071904918907e-31,  4.325864492341079e-20, -1.755214160709623e-20,
  3.799411356269014e-21, -5.598608503840981e-22,  6.257281839290114e-23, -5.638176001638453e-24,  4.259275166223369e-25, -2.771965580428040e-26,  1.585514462021095e-27,
 -8.093181645574091e-29,  3.731399378402584e-30, -1.566986133427317e-31,  6.110562055956993e-21, -2.617631964348950e-21,  6.004356472547778e-22, -9.361092493251612e-23,
  1.104160670531606e-23, -1.047159842438294e-24,  8.303959126079846e-26, -5.658620715456633e-27,  3.380840086324999e-28, -1.798562770013093e-29,  8.624025117205905e-31,
 -3.758631124741950e-32,  8.429794345664034e-02, -2.960567199779617e-04,  1.084071128824623e-06, -4.113470532669649e-09,  1.598180099178915e-11, -6.352619057850314e-14,
  2.520223549161863e-16, -1.037021287196310e-18,  3.955859041318528e-21, -1.840460254554620e-23,  4.655898114719360e-26, -5.176443676419487e-28,  7.138457435772998e-02,
 -3.005257333251432e-04,  1.586718106142290e-06, -8.849972955307666e-09,  4.888748998216558e-11, -2.642801773138265e-13,  1.395875424630531e-15, -7.252914693336729e-18,
  3.690102894585296e-20, -1.870218208387552e-22,  9.153882415882320e-25, -4.672800671621646e-27,  5.117458728750156e-02, -2.874231493594348e-04,  2.178082715165798e-06,
 -1.584416361165719e-08,  1.088593363985750e-10, -7.164383895130083e-13,  4.561568724507681e-15, -2.825465045743828e-17,  1.710108968672374e-19, -1.013502743037042e-21,
  5.903622898242834e-24, -3.376364308126849e-26,  3.103978673611835e-02, -2.406682601040457e-04,  2.395539486005554e-06, -2.123116634274749e-08,  1.746158003817540e-10,
 -1.361975268236788e-12,  1.018744228251057e-14, -7.353906554546429e-17,  5.152412283351766e-19, -3.513685739464070e-21,  2.343080428838991e-23, -1.527304922278634e-25,
  1.591582597896940e-02, -1.695782369827812e-04,  2.090505709084246e-06, -2.204882866852645e-08,  2.136203447138200e-10, -1.942914746978420e-12,  1.679517291709568e-14,
 -1.391096559409604e-16,  1.111309899678666e-18, -8.599042242946854e-21,  6.472704253710417e-23, -4.748536402795789e-25,  6.891326084637921e-03, -9.900590353525892e-05,
  1.465878230217137e-06, -1.819845803473426e-08,  2.053004335482456e-10, -2.151568798990747e-12,  2.125381334623424e-14, -1.998576950089144e-16,  1.802365302215401e-18,
 -1.567092248095926e-20,  1.319559945917379e-22, -1.079335361331961e-24,  2.516234587143341e-03, -4.768582493870240e-05,  8.350653757826552e-07, -1.211056918258209e-08,
  1.576483541510229e-10, -1.887494154763295e-12,  2.113863530269946e-14, -2.239792057853674e-16,  2.264079276352019e-18, -2.196770708701709e-20,  2.055935736312019e-22,
 -1.862745825682302e-24,  7.735605585229127e-04, -1.894215233093394e-05,  3.892815852616952e-07, -6.554421504092979e-09,  9.778666393508036e-11, -1.329316404120158e-12,
  1.678194103463515e-14, -1.992754900218465e-16,  2.246247444447543e-18, -2.420053863780211e-20,  2.505417956586354e-22, -2.502710236167535e-24,  1.998862891223984e-04,
 -6.211015972269403e-06,  1.491643030184548e-07, -2.901204469703026e-09,  4.936310366568206e-11, -7.585356303021260e-13,  1.075003558692038e-14, -1.424917133929504e-16,
  1.784369882478186e-18, -2.126951278335096e-20,  2.427387536361593e-22, -2.664328456408400e-24,  4.333430232154419e-05, -1.682740187045964e-06,  4.710864682954777e-08,
 -1.054304269206873e-09,  2.038753862455793e-11, -3.530229240016472e-13,  5.599942217929086e-15, -8.262724326210521e-17,  1.146460097726843e-18, -1.508091533021247e-20,
  1.892634416732013e-22, -2.277150382896491e-24,  7.868111149669850e-06, -3.770052014631131e-07,  1.228326922999260e-08, -3.154375695557437e-10,  6.916534795435748e-12,
 -1.346750760244716e-13,  2.386559934430430e-15, -3.912682072641419e-17,  6.004663118354952e-19, -8.701969684487605e-21,  1.198948406731571e-22, -1.578712917919623e-24,
  1.194598491948576e-06, -6.989840886510676e-08,  2.647624218480237e-09, -7.787636625218714e-11,  1.933631706366271e-12, -4.228771419721995e-14,  8.362334220933869e-16,
 -1.521747876855268e-17,  2.580499639419230e-19, -4.115977045542460e-21,  6.219962176903334e-23, -8.954857532713287e-25,  1.515031136238750e-07, -1.073415161801887e-08,
  4.723908730889731e-10, -1.590019933380675e-11,  4.468221040401117e-13, -1.097072283128862e-14,  2.420032877662021e-16, -4.886579182268971e-18,  9.153172967102560e-20,
 -1.606340436411704e-21,  2.661557344934778e-23, -4.188101554211965e-25,  1.604722208734518e-08, -1.367446822492030e-09,  6.990035883567599e-11, -2.691989777874822e-12,
  8.563530574966385e-14, -2.361203914775015e-15,  5.811981315904177e-17, -1.302582771096953e-18,  2.695852170102514e-20, -5.206696609467212e-22,  9.460851385338349e-24,
 -1.627372682036462e-25,  1.421558214633983e-09, -1.449171985394647e-10,  8.605560455168043e-12, -3.794044132392762e-13,  1.367385115125951e-14, -4.237820606285720e-16,
  1.165008228453360e-17, -2.900566447255672e-19,  6.638185966751239e-21, -1.412018386097017e-22,  2.815614617068071e-24, -5.297454696415809e-26,  1.057396912249612e-10,
 -1.284167115012941e-11,  8.863000648287702e-13, -4.478353451088734e-14,  1.831133611517899e-15, -6.388101147913344e-17,  1.964141462138497e-18, -5.439898057040997e-20,
  1.378443511308591e-21, -3.233111739000430e-23,  7.082607544015367e-25, -1.458993167754929e-26,  6.657910078281028e-12, -9.600828667139647e-13,  7.707261283993812e-14,
 -4.470199896623907e-15,  2.077487828878287e-16, -8.173535488214203e-18,  2.815965145003744e-19, -8.691076143816448e-21,  2.442419357259806e-22, -6.326418056776399e-24,
  1.524690090771136e-25, -3.443186478096554e-27,  3.601160854180723e-13, -6.148495818101650e-14,  5.746067977531202e-15, -3.832301205574275e-16,  2.028554258076217e-17,
 -9.020045047141804e-19,  3.489400913950780e-20, -1.202508588311472e-21,  3.754816987705010e-23, -1.075907625969213e-24,  2.857114074960676e-26, -7.083234840858709e-28,
  1.715713697676036e-14, -3.458285977177544e-15,  3.764805339909615e-16, -2.892039930673291e-17,  1.747072421241547e-18, -8.797963383194012e-20,  3.829362009785169e-21,
 -1.476327385487769e-22,  5.130991136951314e-24, -1.629030302319158e-25,  4.773421085853880e-27, -1.300755737316580e-28,  7.503587014968226e-16, -1.778670169960668e-16,
  2.254871313578220e-17, -1.996722646081702e-18,  1.378327999225107e-19, -7.871848958570531e-21,  3.860266254580671e-22, -1.667027573661943e-23,  6.456059441624141e-25,
 -2.273282201430074e-26,  7.355997781718491e-28, -2.204561700568072e-29,  3.217185003326298e-17, -8.912976557125692e-18,  1.312569917422864e-18, -1.338290289073852e-19,
  1.055002872508474e-20, -6.830746291523084e-22,  3.772805826772833e-23, -1.824313355096682e-24,  7.869143322014326e-26, -3.071226430849420e-27,  1.096641082185546e-28,
 -3.611269932131291e-30,  1.495028963458046e-18, -4.789769197886857e-19,  8.139126466462387e-20, -9.505860124950082e-21,  8.520176095169923e-22, -6.228952740433234e-23,
  3.860293913389288e-24, -2.082379708226135e-25,  9.967764876562404e-27, -4.296154748281599e-28,  1.686464858347961e-29, -6.079020823057337e-31,  8.669626319305909e-20,
 -3.155446082725139e-20,  6.100485824564521e-21, -8.061305885291278e-22,  8.123157584282484e-23, -6.635403163785584e-24,  4.568058165637404e-25, -2.722665400761629e-26,
  1.432817204268095e-27, -6.758082286394544e-29,  2.890706681947189e-30, -1.130651112560226e-31,  7.355753979188443e-21, -2.957958373293365e-21,  6.343340699521374e-22,
 -9.263836690567479e-23,  1.026661625547063e-23, -9.177717546585121e-25,  6.881749080668218e-26, -4.447504033503338e-27,  2.527247349254456e-28, -1.282081160492640e-29,
  5.876833303659225e-31, -2.454499847197721e-32,  9.159586652613021e-22, -3.913361515053167e-22,  8.950921393918126e-23, -1.391615495849075e-23,  1.637080071693993e-24,
 -1.548648787737213e-25,  1.225134405449361e-26, -8.329544193263246e-28,  4.965897347892101e-29, -2.636381452812888e-30,  1.261671088662350e-31, -5.488612033680589e-33,
  8.313075510336533e-02, -2.875773449557348e-04,  1.036202846212092e-06, -3.867606892956237e-09,  1.476948195343490e-11, -5.781238932654163e-14,  2.246606726736632e-16,
 -9.207220265868043e-19,  3.321002831268327e-21, -1.703509832234751e-23,  2.076219916527045e-26, -6.770941805948427e-28,  7.020720457385185e-02, -2.882438799939186e-04,
  1.485042917924818e-06, -8.108304446791682e-09,  4.392111102342046e-11, -2.330886904280705e-13,  1.208361447393086e-15, -6.173125205995649e-18,  3.078025640612492e-20,
 -1.542497991678385e-22,  7.293239600265339e-25, -3.833253831662113e-27,  5.005858027041950e-02, -2.707304493844050e-04,  1.997948957760082e-06, -1.421135436127832e-08,
  9.556432205550565e-11, -6.158680800657897e-13,  3.841875182065884e-15, -2.332325539960584e-17,  1.384405737735979e-19, -8.045557978155922e-22,  4.601750431064794e-24,
 -2.578548372088815e-26,  3.011389318654371e-02, -2.224775319417717e-04,  2.156670899457880e-06, -1.864261316301029e-08,  1.496636499612859e-10, -1.140433390179954e-12,
  8.341377828434441e-15, -5.890670396687410e-17,  4.041172862072825e-19, -2.698076660113086e-21,  1.764190985893982e-23, -1.125318946132423e-25,  1.526936371957260e-02,
 -1.538572475876037e-04,  1.845212485096379e-06, -1.892112412916071e-08,  1.784970068793488e-10, -1.582822079379269e-12,  1.335477065850685e-14, -1.080392529994667e-16,
  8.437202392007298e-19, -6.383794083392602e-21,  4.703297179708555e-23, -3.375811484038322e-25,  6.517448178836355e-03, -8.809966127553114e-05,  1.265870385807067e-06,
 -1.523197885939160e-08,  1.669482916813835e-10, -1.702599140795493e-12,  1.638720500934317e-14, -1.502758545284403e-16,  1.322796338350742e-18, -1.123239407752559e-20,
  9.244116045264743e-23, -7.391927730750037e-25,  2.337988897932586e-03, -4.154642882430096e-05,  7.037108401136899e-07, -9.864623621559864e-09,  1.245031635089624e-10,
 -1.447914726787745e-12,  1.577308692294082e-14, -1.627423441678214e-16,  1.603446996597719e-18, -1.517542178501246e-20,  1.386376536102978e-22, -1.226781977221574e-24,
  7.035573729375487e-04, -1.611780115167965e-05,  3.192047320640041e-07, -5.182402495877318e-09,  7.481484240925966e-11, -9.861247876588039e-13,  1.209020871213778e-14,
 -1.395974386217620e-16,  1.531706771326413e-18, -1.607750973373126e-20,  1.622914102869291e-22, -1.581743585002428e-24,  1.772259049075662e-04, -5.144600791172843e-06,
  1.186300363933854e-07, -2.219991347920634e-09,  3.647979929076448e-11, -5.426054889147402e-13,  7.456695389680698e-15, -9.597664743747889e-17,  1.168456132340957e-18,
 -1.355402175602185e-20,  1.506652172352896e-22, -1.611971086033968e-24,  3.728412949204792e-05, -1.351424982186431e-06,  3.620287552419556e-08, -7.780029691523630e-10,
  1.450313970416704e-11, -2.426953497061320e-13,  3.727758178455796e-15, -5.334176013904536e-17,  7.186964546056706e-19, -9.190410570887393e-21,  1.122308702157583e-22,
 -1.315061497197136e-24,  6.535058846083008e-06, -2.921849432658473e-07,  9.082269804087448e-09, -2.235457811205598e-10,  4.717171728281858e-12, -8.863241141212432e-14,
  1.518810427227284e-15, -2.411933264930742e-17,  3.590468278745173e-19, -5.053290847864931e-21,  6.768732750865439e-23, -8.672943356896249e-25,  9.521141320343550e-07,
 -5.198738230096839e-08,  1.873999888532540e-09, -5.274352633712720e-11,  1.258358535714596e-12, -2.651955494703242e-14,  5.064981895572194e-16, -8.918263707013586e-18,
  1.465508810888219e-19, -2.268138339333951e-21,  3.329581231514997e-23, -4.661299342027995e-25,  1.150682676188852e-07, -7.611532785372815e-09,  3.181508126218691e-10,
 -1.023197323287120e-11,  2.759136149961123e-13, -6.520446515527971e-15,  1.387713624836876e-16, -2.708689042643605e-18,  4.912536386416716e-20, -8.359042619646168e-22,
  1.344525101384853e-23, -2.056076489067903e-25,  1.151995426734751e-08, -9.173184382606993e-10,  4.447447642063351e-11, -1.634674715117077e-12,  4.984453261187848e-14,
 -1.321531904061542e-15,  3.135649046033789e-17, -6.788139075356214e-19,  1.359340125772852e-20, -2.544033288344189e-22,  4.485204378622679e-24, -7.494409384463241e-26,
  9.552546333916874e-10, -9.112243162681078e-11,  5.128288222705576e-12, -2.156190308532588e-13,  7.443009345488852e-15, -2.216549842770794e-16,  5.870241926418528e-18,
 -1.410980114416973e-19,  3.123040100510093e-21, -6.434768543892452e-23,  1.244582637114761e-24, -2.274113782529901e-26,  6.574360674462645e-11, -7.485520367157576e-12,
  4.895957886261530e-13, -2.358539414946869e-14,  9.233503532620387e-16, -3.094237556068048e-17,  9.162750497054708e-19, -2.449399864204757e-20,  6.001773269565062e-22,
 -1.363433660201426e-23,  2.896999587348804e-25, -5.795792439887491e-27,  3.776972482942981e-12, -5.119564616499908e-13,  3.897605970246660e-14, -2.155966125457996e-15,
  9.595381933259627e-17, -3.626939817788737e-18,  1.203658763736346e-19, -3.586346761993192e-21,  9.748189537575925e-23, -2.446279134375687e-24,  5.720214679356039e-26,
 -1.255037123937918e-27,  1.832831574956242e-13, -2.951751629765504e-14,  2.620524676119093e-15, -1.668768926425351e-16,  8.467065781085421e-18, -3.620073430330948e-19,
  1.350026068683941e-20, -4.494837174024008e-22,  1.358544874535998e-23, -3.774381630368769e-25,  9.732655963566655e-27, -2.346188584483196e-28,  7.678026120902683e-15,
 -1.466532664208326e-15,  1.520977281582331e-16, -1.118051503196987e-17,  6.486241035029550e-19, -3.146024614764398e-20,  1.322141554644990e-21, -4.932077595925805e-23,
  1.661699872188138e-24, -5.122726611892529e-26,  1.459703547195055e-27, -3.873354589859352e-29,  2.884004222683983e-16, -6.517002144799189e-17,  7.904908590322136e-18,
 -6.722237140307172e-19,  4.470215857431647e-20, -2.465960538028521e-21,  1.170719576215367e-22, -4.904234091536980e-24,  1.845671987785424e-25, -6.325326326639709e-27,
  1.994941750545014e-28, -5.835040658612789e-30,  1.035020274480806e-17, -2.754455655375484e-18,  3.904745645513644e-19, -3.843368137836023e-20,  2.932450918305786e-21,
 -1.841827871871809e-22,  9.888230510274102e-24, -4.655831717048113e-25,  1.958652266248915e-26, -7.466094271460557e-28,  2.607111901148612e-29, -8.406119197226903e-31,
  3.930044786920665e-19, -1.220831768548259e-19,  2.013033336390765e-20, -2.285865018927160e-21,  1.995910057124406e-22, -1.424016867655945e-23,  8.626322031992543e-25,
 -4.555104145974507e-26,  2.137157318463224e-27, -9.039276731206725e-29,  3.485903827938751e-30, -1.235661224219881e-31,  1.837813099066382e-20, -6.554277625728913e-21,
  1.241498203930058e-21, -1.609158204195228e-22,  1.592485804424570e-23, -1.279074174255356e-24,  8.667978207249272e-26, -5.090696172571749e-27,  2.642233711235358e-28,
 -1.230177889914042e-29,  5.198143964780157e-31, -2.009982018346111e-32,  1.275871161548037e-21, -5.078684628662618e-22,  1.077688993901307e-22, -1.558079197357824e-23,
  1.710451198558476e-24, -1.515526084200133e-25,  1.126987475773137e-26, -7.226975467928001e-28,  4.076793056661064e-29, -2.054050603295426e-30,  9.354969479638696e-32,
 -3.883618978063914e-33,  1.381907890232748e-22, -5.886461603956184e-23,  1.342088672840663e-23, -2.080087384619087e-24,  2.439746167561680e-25, -2.301480712103096e-26,
  1.815864055847163e-27, -1.231481964138897e-28,  7.324363003239514e-30, -3.879714804848424e-31,  1.852710237526277e-32, -8.043460191373450e-34,  8.199673658892850e-02,
 -2.794694360319797e-04,  9.911722031084009e-07, -3.640260762911562e-09,  1.366512420506478e-11, -5.271844948825445e-14,  2.002768540654110e-16, -8.241647720746098e-19,
  2.714788281223607e-21, -1.688218426340150e-23, -1.548460386471216e-26, -1.003097388303735e-27,  6.907738992057122e-02, -2.767411330631952e-04,  1.391810800910201e-06,
 -7.441341987067043e-09,  3.953589746983709e-11, -2.060558219740496e-13,  1.048506984236691e-15, -5.271693027236248e-18,  2.571343765876577e-20, -1.282663349894619e-22,
  5.739062095067872e-25, -3.275888066918244e-27,  4.900658109547321e-02, -2.554039138741069e-04,  1.836196049762751e-06, -1.277606765765675e-08,  8.411859141916969e-11,
 -5.310246338070705e-13,  3.246732152001649e-15, -1.932315891441437e-17,  1.125338884723916e-19, -6.412804911338600e-22,  3.605878873373548e-24, -1.975478828017168e-26,
  2.925712822572769e-02, -2.060799671369860e-04,  1.946608328431893e-06, -1.642012255434184e-08,  1.287305007181617e-10, -9.586567954199616e-13,  6.859350402027547e-15,
 -4.740196329303758e-17,  3.185811676705862e-19, -2.082146704274766e-21,  1.336729805018508e-23, -8.327694831844405e-26,  1.468208563097577e-02, -1.399575081196169e-04,
  1.634303772313861e-06, -1.630198517298872e-08,  1.498155886202293e-10, -1.295757933289166e-12,  1.067553892777380e-14, -8.438133891730889e-17,  6.444722910394433e-19,
 -4.768796339082619e-21,  3.441488355427455e-23, -2.415479332773647e-25,  6.184206692270590e-03, -7.866087912629986e-05,  1.098055467841954e-06, -1.281320225639612e-08,
  1.365116354243630e-10, -1.355365285872349e-12,  1.271604620650652e-14, -1.137616433695341e-16,  9.778349063467651e-19, -8.111297646052209e-21,  6.527636903090404e-23,
 -5.103157394067458e-25,  2.182357911706614e-03, -3.635845366709984e-05,  5.963946666223252e-07, -8.085122358350391e-09,  9.898926470447908e-11, -1.118712992992373e-12,
  1.185957635173405e-14, -1.192000934064297e-16,  1.145186973930662e-18, -1.057544704711489e-20,  9.434680383757121e-23, -8.155713445444695e-25,  6.438264555967690e-04,
 -1.379397167500823e-05,  2.635949482278143e-07, -4.128615106582255e-09,  5.770389777161161e-11, -7.378190267724390e-13,  8.788875476106094e-15, -9.871505373790672e-17,
  1.054741815908795e-18, -1.078986854978906e-20,  1.062356029726350e-22, -1.010531868258669e-24,  1.583898582364251e-04, -4.292963412931318e-06,  9.516325302809098e-08,
 -1.714250980644588e-09,  2.721968533856355e-11, -3.920802843941503e-13,  5.227016439482785e-15, -6.535585583433559e-17,  7.738310817601624e-19, -8.738453143113557e-21,
  9.464279467520596e-23, -9.873208454148914e-25,  3.240366710991430e-05, -1.095540925856948e-06,  2.811342548344931e-08, -5.803876829723775e-10,  1.043515369410607e-11,
 -1.688304991787635e-13,  2.512004807549175e-15, -3.487249196230300e-17,  4.564111025897271e-19, -5.675540303263354e-21,  6.746153245612481e-23, -7.700547680291105e-25,
  5.496294608650258e-06, -2.290968175846037e-07,  6.799911464043768e-09, -1.604799312916876e-10,  3.260394455908099e-12, -5.913784868275770e-14,  9.803073882853469e-16,
 -1.508448206929841e-17,  2.178834564763030e-19, -2.978980129324694e-21,  3.880324861354267e-23, -4.839404945140629e-25,  7.705750913881233e-07, -3.922120349820392e-08,
  1.346305562745417e-09, -3.626869604810225e-11,  8.317494923492715e-13, -1.689736848282915e-14,  3.117902330068423e-16, -5.313427940073563e-18,  8.463362693227295e-20,
 -1.271275660227784e-21,  1.813261568874130e-23, -2.468944907088803e-25,  8.902914235582527e-08, -5.491264082121145e-09,  2.180740417389794e-10, -6.702582645792337e-12,
  1.734787953786988e-13, -3.946906099347117e-15,  8.106107825378293e-17, -1.529805168650114e-18,  2.686851957295670e-20, -4.433561205881095e-22,  6.923812262630039e-24,
 -1.029113697926847e-25,  8.454828199919649e-09, -6.282012110062834e-10,  2.888795107434201e-11, -1.013393784971281e-12,  2.962206849338167e-14, -7.552713123514082e-16,
  1.727664017094596e-17, -3.613004121440477e-19,  7.001182247772787e-21, -1.269778327215023e-22,  2.172234465989956e-24, -3.525999102924871e-26,  6.588997884974972e-10,
 -5.871445323795732e-11,  3.130657535596905e-12, -1.255053504040779e-13,  4.149148839316142e-15, -1.187251009462076e-16,  3.028983727776075e-18, -7.028429303202153e-20,
  1.504490636763899e-21, -3.002558410841539e-23,  5.632735442229741e-25, -9.994879061847808e-27,  4.214366050431151e-11, -4.489988535953530e-12,  2.781066669780700e-13,
 -1.276699449482239e-14,  4.784038850663601e-16, -1.539592385496414e-17,  4.389881439161068e-19, -1.132437398512445e-20,  2.682697987240014e-22, -5.901559522016573e-24,
  1.216022214633964e-25, -2.362259874968016e-27,  2.219592820300714e-12, -2.821750749198656e-13,  2.035065915214942e-14, -1.072764425757911e-15,  4.569536211382876e-17,
 -1.658580695374438e-18,  5.299688120949528e-20, -1.523782381718345e-21,  4.004529529027365e-23, -9.732336056835176e-25,  2.207243426125316e-26, -4.703347234855170e-28,
  9.710660624774166e-14, -1.471438722660042e-14,  1.239071851775294e-15, -7.525383589851104e-17,  3.656543855970077e-18, -1.501995069870619e-19,  5.395893299683219e-21,
 -1.734533383226345e-22,  5.071468730929196e-24, -1.365327536684463e-25,  3.416740011853499e-27, -8.004529434665154e-29,  3.593478929189360e-15, -6.485655291674473e-16,
  6.395700434681237e-17, -4.491960717034213e-18,  2.499357107984825e-19, -1.166273941001970e-20,  4.727614424102787e-22, -1.704825032223132e-23,  5.563197849437903e-25,
 -1.663925203672944e-26,  4.607000278297722e-28, -1.189515957352776e-29,  1.163492145987601e-16, -2.498589974950533e-17,  2.892994493137229e-18, -2.358004359089555e-19,
  1.508040918163998e-20, -8.023413533854116e-22,  3.682709764129469e-23, -1.494654495253857e-24,  5.459874253634434e-26, -1.819217556911626e-27,  5.586607870075403e-29,
 -1.593215448671465e-30,  3.499746802598231e-18, -8.917862933639691e-19,  1.213751739372729e-19, -1.150697212436576e-20,  8.480734244190070e-22, -5.158010425894427e-23,
  2.687331296578315e-24, -1.230257953259893e-25,  5.040663702635850e-27, -1.874195135391056e-28,  6.392460914111336e-30, -2.015803482206721e-31,  1.082614164842490e-19,
 -3.250807261453249e-20,  5.187471806087494e-21, -5.713695947862811e-22,  4.849816593107452e-23, -3.370384153700856e-24,  1.992230855144863e-25, -1.028136544851079e-26,
  4.721139251024660e-28, -1.956869356748226e-29,  7.404068813327779e-31, -2.577867200783980e-32,  4.044832143481061e-21, -1.409997752385589e-21,  2.610759267450531e-22,
 -3.312350650889688e-23,  3.213368822607789e-24, -2.533505158807732e-25,  1.687439520235340e-26, -9.751375631428885e-28,  4.985254244252446e-29, -2.288339744983347e-30,
  9.541380735181057e-32, -3.643507393334430e-33,  2.262763808519093e-22, -8.903250775756152e-23,  1.866824953905646e-23, -2.668492777910010e-24,  2.898429295553824e-25,
 -2.542702001115793e-26,  1.873340440155945e-27, -1.190922205685715e-28,  6.663721263841999e-30, -3.331983274274399e-31,  1.506716512896931e-32, -6.213236916524599e-34,
  2.100078285674463e-23, -8.915389229278333e-24,  2.025348213248141e-24, -3.128114399715918e-25,  3.656824592228524e-26, -3.438781305882400e-27,  2.705172354343768e-28,
 -1.829474071846888e-29,  1.085230457027944e-30, -5.734140435112082e-32,  2.731809348658793e-33, -1.183358986239557e-34,  8.089444608408294e-02, -2.717111524835074e-04,
  9.487669566410874e-07, -3.429800243218002e-09,  1.265700078262957e-11, -4.817947580944670e-14,  1.783237068956962e-16, -7.472297822342428e-19,  2.083974777667905e-21,
 -1.852666651502796e-23, -7.063516651271574e-26, -1.536668526425570e-27,  6.799214359888447e-02, -2.659533818716317e-04,  1.306178442056937e-06, -6.840417872803030e-09,
  3.565492948871833e-11, -1.825740785220666e-13,  9.117550103361024e-16, -4.518589117527634e-18,  2.147532254802449e-20, -1.080866619574323e-22,  4.372818220605348e-25,
 -2.971959003816715e-27,  4.801340486656661e-02, -2.413054970023111e-04,  1.690621374998014e-06, -1.151107729683808e-08,  7.423550554161572e-11, -4.592090977699444e-13,
  2.752817330642749e-15, -1.606522662586404e-17,  9.184785512625577e-20, -5.129856918127592e-22,  2.842336591397655e-24, -1.515280499425558e-26,  2.846275374305256e-02,
 -1.912616529010614e-04,  1.761320061267108e-06, -1.450530643039448e-08,  1.111017738786644e-10, -8.088731966679111e-13,  5.664247500839724e-15, -3.831023725096112e-17,
  2.524280953136731e-19, -1.613935955471781e-21,  1.019948913770749e-23, -6.178966409695724e-26,  1.414722054972961e-02, -1.276267063228975e-04,  1.452250041735362e-06,
 -1.409909944734936e-08,  1.262825861825927e-10, -1.065716337430597e-12,  8.577556673232348e-15, -6.625882759081343e-17,  4.952132597275342e-19, -3.583114678954660e-21,
  2.536154659296871e-23, -1.738127743713792e-25,  5.886208093639114e-03, -7.045629548187943e-05,  9.565585160256312e-07, -1.083031549466833e-08,  1.122153604908859e-10,
 -1.085121065199471e-12,  9.928245608647557e-15, -8.667993339230494e-17,  7.278799866850215e-19, -5.899233788127333e-21,  4.645546698608518e-23, -3.549715685107878e-25,
  2.045887832420474e-03, -3.195006244293821e-05,  5.081849813806096e-07, -6.665887860576038e-09,  7.921095535750881e-11, -8.703207739155057e-13,  8.982596237962716e-15,
 -8.798200544016283e-17,  8.245629114094037e-19, -7.431955830698524e-21,  6.477734966192742e-23, -5.470981346691926e-25,  5.925750814477170e-04, -1.186874158179270e-05,
  2.191388927112503e-07, -3.312818567683966e-09,  4.485124981922998e-11, -5.565719360726807e-13,  6.444363162264725e-15, -7.043782611135664e-17,  7.331736982264369e-19,
 -7.312159361703123e-21,  7.024945544257648e-23, -6.523428612380608e-25,  1.426200524343128e-04, -3.607092256823758e-06,  7.696705049784177e-08, -1.335228158504317e-09,
  2.049765316705726e-11, -2.860597967058023e-13,  3.701191658824907e-15, -4.497321032845399e-17,  5.180786256831534e-19, -5.697223168973723e-21,  6.014140174483516e-23,
 -6.119239998454640e-25,  2.843090244577575e-05, -8.958906451161145e-07,  2.204889006487999e-08, -4.374669904621257e-10,  7.590125212204456e-12, -1.187808479069786e-13,
  1.712692868015940e-15, -2.307538767176373e-17,  2.934759553407303e-19, -3.549987044164390e-21,  4.108504193225296e-23, -4.569875033959053e-25,  4.677652582426492e-06,
 -1.815959791401993e-07,  5.151899167520224e-09, -1.166279561029877e-10,  2.282386882860654e-12, -3.998032119941943e-14,  6.413480106752733e-16, -9.565754870132201e-18,
  1.341102514085309e-19, -1.781783598435157e-21,  2.257586976452598e-23, -2.741226305806168e-25,  6.327633207714295e-07, -2.998869357172432e-08,  9.809678515178557e-10,
 -2.530328285980649e-11,  5.579997762479732e-13, -1.093144243605506e-14,  1.949370923207687e-16, -3.216226739905693e-18,  4.967009832985153e-20, -7.242987487317681e-22,
  1.004017007607252e-23, -1.329899668131580e-25,  7.010336533738007e-08, -4.026587839400778e-09,  1.519984954860993e-10, -4.465710742080017e-12,  1.109715848429193e-13,
 -2.431333475027447e-15,  4.819945485794008e-17, -8.796912563153065e-19,  1.496547185623265e-20, -2.395194299067324e-22,  3.632360946630137e-24, -5.248347058073973e-26,
  6.337239511836178e-09, -4.387003442391467e-10,  1.913703278103106e-11, -6.407882211669410e-13,  1.795848501373285e-14, -4.404042893516330e-16,  9.713565213937265e-18,
 -1.962604403249345e-19,  3.680563572784804e-21, -6.469630683859136e-23,  1.074034249532005e-24, -1.693744827728092e-26,  4.659781384778458e-10, -3.872264648488222e-11,
  1.955729734924396e-12, -7.474783811246457e-14,  2.366580278677037e-15, -6.506701936361191e-17,  1.599177877316927e-18, -3.582281908839360e-20,  7.415976163590910e-22,
 -1.433561145038169e-23,  2.608413758519243e-25, -4.494641567845720e-27,  2.782008257596573e-11, -2.767979954530262e-12,  1.622650359041451e-13, -7.096015464770850e-15,
  2.544470561871460e-16, -7.862311881792727e-18,  2.158252466885437e-19, -5.371891487991587e-21,  1.230158010859064e-22, -2.620204912219938e-24,  5.234897506280360e-26,
 -9.873066186104774e-28,  1.349685059696039e-12, -1.605681250323185e-13,  1.095927359849686e-14, -5.501666827568354e-16,  2.241739025027557e-17, -7.809964768540527e-19,
  2.401866292314730e-20, -6.661840401215890e-22,  1.692143853584574e-23, -3.981525826235430e-25,  8.755401135292617e-27, -1.811397142628280e-28,  5.350700489108813e-14,
 -7.609041012749389e-15,  6.068864581897501e-16, -3.511625080975507e-17,  1.632634608531817e-18, -6.438515602972496e-20,  2.226743824815814e-21, -6.906844678516340e-23,
  1.952454122421835e-24, -5.090802332220896e-26,  1.235750959888801e-27, -2.812120479282312e-29,  1.757955883594709e-15, -2.989432945339035e-16,  2.797722218765749e-17,
 -1.874668778776859e-18,  9.991881742656626e-20, -4.480843070937383e-21,  1.750291876332057e-22, -6.096093567457053e-24,  1.925136840317031e-25, -5.582066909628850e-27,
  1.500652403079075e-28, -3.767509446909647e-30,  4.927704462499015e-17, -1.002456392187538e-17,  1.105362688051776e-18, -8.618980413209716e-20,  5.292630680561479e-21,
 -2.711947223392331e-22,  1.201893885369049e-23, -4.720361760770675e-25,  1.671832572970933e-26, -5.410223470390394e-28,  1.616094180689885e-29, -4.489503263326478e-31,
  1.245270287114593e-18, -3.027935309910960e-19,  3.945945300044907e-20, -3.595013269551843e-21,  2.554220697359547e-22, -1.501626825811776e-23,  7.579948006734455e-25,
 -3.368917501271231e-26,  1.342496997781399e-27, -4.862626161774579e-29,  1.618023124144184e-30, -4.984393189842162e-32,  3.132776137358861e-20, -9.062734306562218e-21,
  1.395586404795053e-21, -1.487309330331030e-22,  1.224528997117719e-23, -8.272559326871652e-25,  4.762817700354365e-26, -2.398236635479758e-27,  1.076165304845994e-28,
 -4.365079075843994e-30,  1.618263188500482e-31, -5.527182775523781e-33,  9.272446400474944e-22, -3.150686664585052e-22,  5.688320144161976e-23, -7.048344950871342e-24,
  6.689189558997600e-25, -5.167415039534257e-26,  3.377010882732055e-27, -1.917245960489669e-28,  9.640714708354719e-30, -4.357208333354572e-31,  1.790524602293972e-32,
 -6.744690295907578e-34,  4.114189420317773e-23, -1.597503956806534e-23,  3.304559560272977e-24, -4.663412244665792e-25,  5.004892137134790e-26, -4.341883780127859e-27,
  3.165788960253978e-28, -1.993130965723321e-29,  1.105185267907310e-30, -5.479508479961618e-32,  2.458238210333764e-33, -1.006202528211336e-34,  3.217722719654474e-24,
 -1.360754174311134e-24,  3.078672598884332e-25, -4.736243666005986e-26,  5.516126913027752e-27, -5.169009721407794e-28,  4.052850321485882e-29, -2.732367906155437e-30,
  1.616071490063690e-31, -8.515400656660297e-33,  4.046246051157560e-34, -1.748430243152816e-35,  7.982252584623395e-02, -2.642822762946796e-04,  9.087933614546714e-07,
 -3.234771398875203e-09,  1.173455048696471e-11, -4.414387964672068e-14,  1.582299184074206e-16, -6.919027540302407e-19,  1.348149193414887e-21, -2.289258675179566e-23,
 -1.522698818115810e-25, -2.160732973863541e-27,  6.694872238980341e-02, -2.558228662485096e-04,  1.227399538903033e-06, -6.298003589793178e-09,  3.221240745370641e-11,
 -1.621360304284622e-13,  7.942930961896726e-16, -3.890513646070140e-18,  1.786798251018753e-20, -9.316256021862997e-23,  3.099641824647617e-25, -2.824224926237066e-27,
  4.707438559334215e-02, -2.283135410668031e-04,  1.559323201897415e-06, -1.039334016679688e-08,  6.567721061006450e-11, -3.982235866136031e-13,  2.341511769273006e-15,
 -1.340086855355847e-17,  7.527639598412305e-20, -4.115174802691881e-22,  2.256817079249511e-24, -1.161491766873235e-26,  2.772482694955693e-02, -1.778383106831476e-04,
  1.597411265426133e-06, -1.285006053346132e-08,  9.620134113202241e-11, -6.849417131259665e-13,  4.696446124911292e-15, -3.108843523804774e-17,  2.010612301003834e-19,
 -1.255304530740620e-21,  7.847634812042700e-24, -4.590362079935972e-26,  1.365892463823638e-02, -1.166526641247306e-04,  1.294515186289247e-06, -1.223850757645930e-08,
  1.068853711334927e-10, -8.804397937023700e-13,  6.926087151711573e-15, -5.229410177477534e-17,  3.827804002352639e-19, -2.706248807961280e-21,  1.883156397390009e-23,
 -1.256938217217244e-25,  5.618905761284324e-03, -6.329472910416832e-05,  8.366910157352199e-07, -9.196322897897392e-09,  9.271194232825514e-11, -8.735197412382267e-13,
  7.797761455290576e-15, -6.645553931656514e-17,  5.455083625168078e-19, -4.319176788722465e-21,  3.331976398420669e-23, -2.486755961565610e-25,  1.925740698796437e-03,
 -2.818425056736654e-05,  4.352599435170387e-07, -5.526837538389223e-09,  6.377524170694002e-11, -6.815492354990191e-13,  6.851592732773083e-15, -6.542025671716988e-17,
  5.983836594835693e-19, -5.264882906897990e-21,  4.486119574469724e-23, -3.701813431960488e-25,  5.483707356360929e-04, -1.026324072982144e-05,  1.833489495522608e-07,
 -2.676472436597120e-09,  3.511944105075238e-11, -4.231483197386813e-13,  4.764556624854952e-15, -5.069728624310517e-17,  5.142889894461996e-19, -5.001919648162136e-21,
  4.691022556282831e-23, -4.253486899931787e-25,  1.293290137708867e-04, -3.050276893870403e-06,  6.273782797336820e-08, -1.048605636010672e-09,  1.557167815676396e-11,
 -2.106429521999824e-13,  2.646236033908882e-15, -3.125998253726969e-17,  3.504940121850501e-19, -3.754622584639668e-21,  3.864487702337935e-23, -3.836091850154453e-25,
  2.516956822090027e-05, -7.386004810627496e-07,  1.745621988897205e-08, -3.329985647529266e-10,  5.578241309733851e-12, -8.447598985210134e-14,  1.180899053647945e-15,
 -1.544731543166409e-17,  1.909789736776161e-19, -2.247932195917492e-21,  2.533897699945644e-23, -2.747184006439344e-25,  4.025637976374854e-06, -1.454138741918272e-07,
  3.947565514100086e-09, -8.575334305571088e-11,  1.617284539118180e-12, -2.737069595036476e-14,  4.250633956664945e-16, -6.147385248658337e-18,  8.368107632385077e-20,
 -1.080691440308382e-21,  1.332313223431783e-23, -1.575425197330383e-25,  5.267752573911193e-07, -2.321883656559342e-08,  7.244285938033898e-10, -1.789778982927539e-11,
  3.796966735672494e-13, -7.175578383616869e-15,  1.237077605509621e-16, -1.976629547431412e-18,  2.960605705109188e-20, -4.192229352306270e-22,  5.649096429233291e-24,
 -7.280855145704025e-26,  5.612780460002886e-08, -2.998094951351707e-09,  1.076414099441358e-10, -3.023820727599641e-12,  7.216683113155111e-14, -1.523073988860595e-15,
  2.915284180840862e-17, -5.146872204215425e-19,  8.483150170854803e-21, -1.317166872224616e-22,  1.940120987542343e-24, -2.725547605953890e-26,  4.846037650362892e-09,
 -3.120727210274966e-10,  1.291736846365621e-11, -4.129045268369760e-13,  1.109716021672807e-14, -2.618014184224143e-16,  5.568650728087732e-18, -1.087232017182254e-19,
  1.973552775449096e-21, -3.362649866872026e-23,  5.417917829569840e-25, -8.301601395789966e-27,  3.374919777829281e-10, -2.610786506415731e-11,  1.248930363366873e-12,
 -4.550620574554999e-14,  1.379866223338911e-15, -3.645501008832711e-17,  8.631787577683796e-19, -1.866763429776493e-20,  3.737621829718416e-22, -6.998495264418680e-24,
  1.235116370763184e-25, -2.066769392431702e-27,  1.888908606573460e-11, -1.751605932372109e-12,  9.713964103863329e-14, -4.045523205244692e-15,  1.387910542384872e-16,
 -4.117204419458480e-18,  1.087965563287867e-19, -2.612540935307901e-21,  5.782729619640394e-23, -1.192464621874667e-24,  2.309795138688120e-26, -4.228913609145133e-28,
  8.482140729463368e-13, -9.421557520470931e-14,  6.080333801919318e-15, -2.905173867682477e-16,  1.131876145319716e-17, -3.783632776819895e-19,  1.119593643237885e-20,
 -2.994713608812714e-22,  7.350147372957562e-24, -1.673947412324111e-25,  3.568210214725566e-27, -7.165688860059967e-29,  3.063041276489610e-14, -4.077268073947691e-15,
  3.076037252693788e-16, -1.694131840355170e-17,  7.530775448829938e-19, -2.849426743719917e-20,  9.481661523683998e-22, -2.836332380450339e-23,  7.748104227448891e-25,
 -1.955690952491467e-26,  4.602766256582175e-28, -1.016975091004899e-29,  8.983013859234068e-16, -1.435041657741665e-16,  1.272247294622475e-17, -8.122020192972526e-19,
  4.142127424913436e-20, -1.783396727553311e-21,  6.706933932966020e-23, -2.254322642484976e-24,  6.884339091500266e-26, -1.933787518794989e-27,  5.044262430752769e-29,
 -1.230576493959904e-30,  2.190858074003649e-17, -4.208146897349605e-18,  4.408696172562935e-19, -3.282554399627157e-20,  1.932386260218953e-21, -9.522878422165265e-23,
  4.069953614450326e-24, -1.545035244947341e-25,  5.299929126707336e-27, -1.664099546936011e-28,  4.830678880338431e-30, -1.306032323509984e-31,  4.667149410414334e-19,
 -1.079048493897892e-19,  1.342704499994454e-20, -1.172866322942536e-21,  8.017252252693875e-23, -4.547924731323658e-24,  2.220672747104283e-25, -9.567909345402690e-27,
  3.703200334094245e-28, -1.304998399925740e-29,  4.231187777993256e-31, -1.271873891266011e-32,  9.544693242854900e-21, -2.650583969609350e-21,  3.927039864760522e-22,
 -4.038923643091232e-23,  3.218087278098516e-24, -2.109076902782365e-25,  1.180508786755677e-26, -5.789893573591219e-28,  2.534904294687976e-29, -1.004695698699220e-30,
  3.644551399305469e-32, -1.219565472396421e-33,  2.221464888544335e-22, -7.334928386344935e-23,  1.287643329942638e-23, -1.554380252453301e-24,  1.439934895079747e-25,
 -1.087706941694361e-26,  6.961984334092258e-28, -3.876705023029536e-29,  1.914427941877156e-30, -8.507263435630113e-32,  3.440915217217809e-33, -1.277028803269637e-34,
  7.692155861165304e-24, -2.941825728259822e-24,  5.992413825908811e-25, -8.334656057204954e-26,  8.824895298922001e-27, -7.560353089615869e-28,  5.448550667233213e-29,
 -3.393302062457231e-30,  1.862645997869736e-31, -9.148241407435029e-33,  4.068059613154607e-34, -1.651460526896064e-35,  4.976149797733620e-25, -2.095115895324794e-25,
  4.718129134757105e-26, -7.226004046495070e-27,  8.380429447918496e-28, -7.822024991588399e-29,  6.110248229526158e-30, -4.105094916428399e-31,  2.420037269948732e-32,
 -1.271242764008588e-33,  6.023034597413150e-35, -2.595528357453237e-36,  7.877969601146438e-02, -2.571640724230101e-04,  8.710741371086957e-07, -3.053881789425020e-09,
  1.088810063345617e-11, -4.057477430125788e-14,  1.393272212011378e-16, -6.633170935475421e-19,  3.903951846432028e-22, -3.099056975741276e-23, -2.535139075393562e-25,
 -2.255795002676035e-27,  6.594460272206082e-02, -2.462974522315787e-04,  1.154812133768246e-06, -5.807546991370069e-09,  2.915181456202763e-11, -1.443186174478973e-13,
  6.928750428059423e-16, -3.370246675176564e-18,  1.470788616248631e-20, -8.318612459677493e-23,  1.911481586833970e-25, -2.496434589692281e-27,  4.618531515270075e-02,
 -2.163205576549879e-04,  1.440654857927855e-06, -9.403290088014919e-09,  5.824565940130285e-11, -3.462708861389416e-13,  1.997902824535431e-15, -1.121258306421206e-17,
  6.197133517745943e-20, -3.306181235609326e-22,  1.807662496391875e-24, -8.935996664142719e-27,  2.703809129955244e-02, -1.656506594417032e-04,  1.452012865720903e-06,
 -1.141458897960743e-08,  8.356273319253098e-11, -5.819853669870253e-13,  3.909661834969295e-15, -2.532067145938485e-17,  1.610679578391694e-19, -9.780998811771267e-22,
  6.096855351502329e-24, -3.432952661453072e-26,  1.321213544874088e-02, -1.068562001421591e-04,  1.157360953784252e-06, -1.066065442922814e-08,  9.082702265311905e-11,
 -7.304854646342861e-13,  5.619668860559960e-15, -4.146869476951026e-17,  2.976824237212007e-19, -2.052667743854983e-21,  1.409600792715463e-23, -9.152013463355389e-26,
  5.378448910983808e-03, -5.701867151939129e-05,  7.346902550876742e-07, -7.843125620145719e-09,  7.697190573713645e-11, -7.068649486919034e-13,  6.159735851160004e-15,
 -5.124984236409576e-17,  4.115892046790301e-19, -3.181693470871161e-21,  2.408600768506780e-23, -1.755277136176869e-25,  1.819571009368056e-03, -2.495109320482737e-05,
  3.746378222317282e-07, -4.607133071463182e-09,  5.165074821640633e-11, -5.370919547032803e-13,  5.261704163473031e-15, -4.898773180152352e-17,  4.375759122075500e-19,
 -3.758101157774187e-21,  3.133180281166901e-23, -2.526233263961376e-25,  5.100606299598159e-04, -8.915972409820268e-06,  1.543423516474059e-07, -2.176503320199759e-09,
  2.769393617753012e-11, -3.241278675324212e-13,  3.550748170122371e-15, -3.679266677834202e-17,  3.639259247067459e-19, -3.452346201648141e-21,  3.162330141197614e-23,
 -2.800491180048286e-25,  1.180576013538039e-04, -2.594770992646659e-06,  5.152083326139906e-08, -8.299872602277461e-10,  1.192907453516399e-11, -1.564842461801028e-13,
  1.909607875511533e-15, -2.193864028901521e-17,  2.395149876308211e-19, -2.500109383020010e-21,  2.509992309592352e-23, -2.431456831943893e-25,  2.247114244746873e-05,
 -6.135364531210728e-07,  1.394460837563042e-08, -2.558584972367298e-10,  4.140378187319865e-12, -6.070245562113377e-14,  8.230357649784492e-16, -1.045659789691088e-17,
  1.257177854708863e-19, -1.440365129313066e-21,  1.581883972125618e-23, -1.672155802409112e-25,  3.501196666722690e-06, -1.175478814074971e-07,  3.057367784403004e-09,
 -6.375532502332769e-11,  1.159367238045218e-12, -1.896468572691885e-14,  2.852386556860602e-16, -4.001394739551648e-18,  5.290450191247227e-20, -6.643253495113792e-22,
  7.971337984265766e-24, -9.181878217624019e-26,  4.442631751992005e-07, -1.818916923645672e-08,  5.418455157905251e-10, -1.282647655906982e-11,  2.618912913658090e-13,
 -4.776212188933098e-15,  7.963486477512258e-17, -1.232676058306162e-18,  1.791200558958851e-20, -2.463601978863738e-22,  3.227964534598578e-24, -4.049128643425625e-26,
  4.565282071643053e-08, -2.264568043039992e-09,  7.738931760302704e-11, -2.079227183562587e-12,  4.767644173298125e-14, -9.695643984890366e-16,  1.792377968768164e-17,
 -3.061858475868884e-19,  4.890603560929438e-21, -7.368500075306693e-23,  1.054384098284634e-24, -1.440451572175663e-26,  3.776834307329536e-09, -2.258901864488742e-10,
  8.876026989014814e-12, -2.708963085445550e-13,  6.983651644492968e-15, -1.585334105066015e-16,  3.252702237177137e-18, -6.137914460282370e-20,  1.078625972783495e-21,
 -1.781730073309776e-23,  2.786557104061872e-25, -4.149088293165791e-27,  2.500499870416727e-10, -1.797428815892832e-11,  8.144758724225205e-13, -2.829164154152470e-14,
  8.216990423289727e-16, -2.086216950191365e-17,  4.759444833258659e-19, -9.938293522236076e-21,  1.924650353209234e-22, -3.491027339390122e-24,  5.976189190168575e-26,
 -9.711646824384790e-28,  1.317550855623506e-11, -1.136368968740621e-12,  5.959960973092592e-14, -2.363309561655024e-15,  7.756586555259331e-17, -2.208886854370785e-18,
  5.618591237745093e-20, -1.301607928104051e-21,  2.784625744781446e-23, -5.558990274336550e-25,  1.043887902802928e-26, -1.855203828870804e-28,  5.502502330656090e-13,
 -5.693172977756785e-14,  3.471521200157561e-15, -1.577913471372976e-16,  5.876200522429921e-18, -1.884222902314364e-19,  5.363285576457551e-21, -1.383181608798756e-22,
  3.279638213671839e-24, -7.227953735605523e-26,  1.493195328408915e-27, -2.910070865536235e-29,  1.819623713940777e-14, -2.261224280657408e-15,  1.611697860544572e-16,
 -8.441600736377812e-18,  3.585445130620469e-19, -1.300891681100588e-20,  4.162911735366919e-22, -1.200431114974668e-23,  3.167586176386139e-25, -7.736706159888823e-27,
  1.764727656165823e-28, -3.784336915468712e-30,  4.790533549421548e-16, -7.167689702399878e-17,  6.009335404803933e-18, -3.650344714730223e-19,  1.779413589264410e-20,
 -7.348914158562621e-22,  2.658737522719897e-23, -8.617830903927550e-25,  2.543201412397195e-26, -6.916023338479793e-28,  1.749353474299108e-29, -4.144412201933457e-31,
  1.022231296553083e-17, -1.847587761351897e-18,  1.834917924199138e-19, -1.302253859909876e-20,  7.338297724443805e-22, -3.473495201550905e-23,  1.429925802558911e-24,
 -5.241233130968559e-26,  1.739574232750077e-27, -5.294542750094707e-29,  1.492262697525836e-30, -3.923134227279167e-32,  1.843784764327206e-19, -4.038132553819479e-20,
  4.784539862211358e-21, -3.997888994882846e-22,  2.624041627036142e-23, -1.433786455430013e-24,  6.761417262290531e-26, -2.820007075241651e-27,  1.058680349785802e-28,
 -3.625165916077410e-30,  1.143946398987422e-31, -3.351630288496501e-33,  3.068269335251455e-21, -8.147832049713927e-22,  1.157766008871145e-22, -1.146061720971658e-23,
  8.816170768372001e-25, -5.593489140480659e-26,  3.037964337154468e-27, -1.448763508511065e-28,  6.178612687876729e-30, -2.389306370486671e-31,  8.468857843959993e-33,
 -2.772817251440335e-34,  5.581301173130172e-23, -1.784558803499711e-23,  3.036854966641849e-24, -3.561848955874780e-25,  3.213065826828376e-26, -2.368218542983525e-27,
  1.481684923163627e-28, -8.077825662154008e-30,  3.911140584347922e-31, -1.706274512791136e-32,  6.783227519475958e-34, -2.477097370183838e-35,  1.483870210717225e-24,
 -5.576954978347122e-25,  1.116267020673605e-25, -1.527252744809274e-26,  1.592604085000346e-27, -1.345260479045485e-28,  9.568879329629209e-30, -5.887440256892987e-31,
  3.195420302025611e-32, -1.552974570339263e-33,  6.838297365704508e-35, -2.750742403002415e-36,  7.777352665599155e-26, -3.257904812637601e-26,  7.297671742327227e-27,
 -1.111983354372446e-27,  1.283469636139997e-28, -1.192592197162870e-29,  9.277091185209661e-31, -6.208314979514595e-32,  3.646515122302373e-33, -1.908924569420298e-34,
  9.015100846645604e-36, -3.873134723489318e-37,  7.776474891411762e-02, -2.503391646132333e-04,  8.354466052402186e-07, -2.885988763787747e-09,  1.010854192911097e-11,
 -3.745348920492003e-14,  1.207465273015463e-16, -6.708076039500177e-19, -9.286250498043082e-22, -4.273249547750934e-23, -3.180624312603013e-25, -6.718437040871158e-29,
  6.497745944599036e-02, -2.373300017732456e-04,  1.087827735046572e-06, -5.363336590985364e-09,  2.642435179839205e-11, -1.287715549900690e-13,  6.046564133694614e-16,
 -2.946233679487068e-18,  1.182674488487260e-20, -7.745201355350611e-23,  1.054671292356119e-25, -1.107570839971793e-27,  4.534239044286170e-02, -2.052313438159989e-04,
  1.333186578276609e-06, -8.524260462367846e-09,  5.177542142735942e-11, -3.018750750077007e-13,  1.710019575780485e-15, -9.406713026161249e-18,  5.128143557823107e-20,
 -2.655740540167713e-22,  1.457729357998081e-24, -7.130416265836569e-27,  2.639788432097931e-02, -1.545605803742287e-04,  1.322691590127642e-06, -1.016583568327656e-08,
  7.280679528514990e-11, -4.961097297616434e-13,  3.267867241508691e-15, -2.068561187214391e-17,  1.299056584401909e-19, -7.619021690107148e-22,  4.768339591565060e-24,
 -2.674943317973381e-26,  1.280245168505351e-02, -9.808538358664568e-05,  1.037693077984486e-06, -9.317347946597751e-09,  7.747726979672389e-11, -6.085350493340097e-13,
  4.581530649373159e-15, -3.302377875514061e-17,  2.330357759371551e-19, -1.561735088173541e-21,  1.062184994624588e-23, -6.799237708194688e-26,  5.161561395002349e-03,
 -5.149770771757551e-05,  6.475202669703654e-07, -6.717103639717010e-09,  6.420397444973102e-11, -5.748624720604075e-13,  4.893156037377603e-15, -3.973980929679449e-17,
  3.126787618083371e-19, -2.356542482836140e-21,  1.753603910958586e-23, -1.253874698410354e-25,  1.725429510607254e-03, -2.216185801855553e-05,  3.239772328799536e-07,
 -3.860233966910013e-09,  4.206829073226439e-11, -4.258055287755414e-13,  4.067349190205334e-15, -3.692825986324175e-17,  3.224002311873750e-19, -2.701706378754989e-21,
  2.205840831258562e-23, -1.740992312009325e-25,  4.767108244958286e-04, -7.778637245462203e-06,  1.306831005433825e-07, -1.780958604671913e-09,  2.198645631663528e-11,
 -2.500629632141489e-13,  2.666518550423151e-15, -2.691366618549469e-17,  2.597248293967834e-19, -2.403255837704466e-21,  2.151252165292641e-23, -1.862179807600114e-25,
  1.084440580400724e-04, -2.219421661755149e-06,  4.261042852282487e-08, -6.618636932658367e-10,  9.212085475138757e-12, -1.172356746856241e-13,  1.390367205942540e-15,
 -1.553959712452874e-17,  1.652718979786268e-19, -1.681356425995119e-21,  1.647165962958090e-23, -1.557884270616493e-25,  2.022214159872736e-05, -5.132203691014365e-07,
  1.123494203087672e-08, -1.983435420038828e-10,  3.102303018221453e-12, -4.405229627069263e-14,  5.795712288193307e-16, -7.154224394676311e-18,  8.367952569166448e-20,
 -9.334633049093943e-22,  9.991836375932562e-24, -1.030158927296105e-25,  3.075487641760093e-06, -9.586043268969947e-08,  2.392194918678597e-09, -4.790276209992573e-11,
  8.403579691077475e-13, -1.329220280415817e-14,  1.937023653126501e-16, -2.636680664324089e-18,  3.387199539371412e-20, -4.136878504392374e-22,  4.832842703516940e-24,
 -5.424263220986898e-26,  3.792929930748338e-07, -1.440548059778188e-08,  4.102239668730824e-10, -9.307232615310691e-12,  1.829866575463150e-13, -3.221768012561461e-15,
  5.197055202963065e-17, -7.795870834105200e-19,  1.099359354169035e-20, -1.469098041815447e-22,  1.872196824767574e-24, -2.286254864917630e-26,  3.769129616370458e-08,
 -1.733623582810697e-09,  5.644406558381226e-11, -1.450787294798737e-12,  3.197439479763812e-14, -6.267757430241529e-16,  1.119434849556360e-17, -1.850858838755433e-19,
  2.865712360177342e-21, -4.190718455025135e-23,  5.826918316040419e-25, -7.742916730603511e-27,  2.997097381618340e-09, -1.662014942580919e-10,  6.203366371495826e-12,
 -1.808027620525586e-13,  4.472320497487650e-15, -9.771540333830321e-17,  1.934373719689694e-18, -3.528733509817927e-20,  6.004576819816332e-22, -9.617721408091248e-24,
  1.460315127431737e-25, -2.113255506436349e-27,  1.893125698028428e-10, -1.262107971328717e-11,  5.418693190289625e-13, -1.794520413394833e-14,  4.993003140747565e-16,
 -1.218430297442289e-17,  2.678642684106154e-19, -5.401258389997476e-21,  1.011860479440462e-22, -1.778111221581412e-24,  2.952814997881017e-26, -4.660375005219541e-28,
  9.429906084396773e-12, -7.548494411234916e-13,  3.743572044516992e-14, -1.413202284359049e-15,  4.437197132576691e-17, -1.213034852587440e-18,  2.970110705862791e-20,
 -6.637939769817933e-22,  1.372578867953468e-23, -2.652646660829724e-25,  4.829026278158623e-27, -8.330422967023889e-29,  3.680045584575358e-13, -3.538194916639988e-14,
  2.037291904851415e-15, -8.805659557854789e-17,  3.133647926144215e-18, -9.636590199995939e-20,  2.638116346705877e-21, -6.558825733874999e-23,  1.502143884107894e-24,
 -3.203151415816002e-26,  6.412141829312844e-28, -1.212548207527968e-29,  1.120394475030541e-14, -1.296279277666448e-15,  8.719439417842792e-17, -4.340019957493924e-18,
  1.760322858260601e-19, -6.121636756524752e-21,  1.883100793625189e-22, -5.232584492573764e-24,  1.333228683650548e-25, -3.149961488966320e-27,  6.961187585908365e-29,
 -1.448343223678502e-30,  2.663537642883216e-16, -3.721055746888558e-17,  2.945442650575486e-18, -1.700440264824055e-19,  7.915511264441912e-21, -3.133263567330609e-22,
  1.089715549578820e-23, -3.403920121753154e-25,  9.701304011402582e-27, -2.552581760235360e-28,  6.257310650673300e-30, -1.438830645389488e-31,  5.003006999959996e-18,
 -8.479015444303640e-19,  7.965084869634358e-20, -5.379112883237454e-21,  2.897461537980199e-22, -1.315694335074915e-23,  5.211353308145778e-25, -1.842485162540590e-26,
  5.911307654715343e-28, -1.742452507425570e-29,  4.764312881535334e-31, -1.216970893802432e-32,  7.681188995546238e-20, -1.587387262301933e-20,  1.785844919996926e-21,
 -1.424210457134405e-22,  8.958602252687862e-24, -4.706982036747122e-25,  2.140487684460413e-26, -8.629697603835527e-28,  3.138334295367640e-29, -1.042948922303818e-30,
  3.199389312067266e-32, -9.126679809825220e-34,  1.042672670638817e-21, -2.636728809251761e-22,  3.581552123612888e-23, -3.402863292130116e-24,  2.521224610970416e-25,
 -1.545229213837807e-26,  8.127843505783858e-28, -3.762137520197554e-29,  1.560345403548774e-30, -5.878270053847179e-32,  2.032960657837421e-33, -6.504014939670994e-35,
  1.475713769882159e-23, -4.551536687062074e-24,  7.483355324313704e-25, -8.503064249458676e-26,  7.450087643679032e-27, -5.345596309041678e-28,  3.262406076681716e-29,
 -1.738041711395594e-30,  8.236534934945965e-32, -3.521974601870789e-33,  1.374137563301323e-34, -4.930787864346465e-36,  2.964582150241358e-25, -1.092072976551426e-25,
  2.142593875016080e-26, -2.877268225859289e-27,  2.949120307890361e-28, -2.451791123084748e-29,  1.718520405289598e-30, -1.043059962253944e-31,  5.590182124754154e-33,
 -2.685111808760089e-34,  1.169485159424128e-35, -4.656635200040115e-37,  1.230358531777837e-26, -5.123627389698673e-27,  1.140657747913754e-27, -1.727947220031471e-28,
  1.983546308628183e-29, -1.833728781956930e-30,  1.419688129369452e-31, -9.458718741212593e-33,  5.532755919993814e-34, -2.885183983241187e-35,  1.357634214851170e-36,
 -5.813037307590812e-38,  7.677654387407537e-02, -2.437914256469240e-04,  8.017609331944886e-07, -2.730093663280186e-09,  9.386906218546364e-12, -3.478582949189561e-14,
  1.012995456184288e-16, -7.275018235657170e-19, -2.681356469917889e-21, -5.372036748453434e-23, -1.726399914266435e-25,  8.086912435868788e-27,  6.404514696425680e-02,
 -2.288778233719053e-04,  1.025921923713067e-06, -4.960389250511822e-09,  2.398756636628442e-11, -1.152095187632102e-13,  5.270465857407083e-16, -2.611618922282132e-18,
  9.110928766475190e-21, -7.324872355054748e-23,  1.353138762494799e-25,  3.142230297458759e-27,  4.454216750358208e-02, -1.949613775716102e-04,  1.235673641862912e-06,
 -7.742010191049786e-09,  4.612791247777423e-11, -2.638182736365920e-13,  1.468245181531055e-15, -7.908018905174058e-18,  4.269747706479862e-20, -2.132568087658208e-22,
  1.162569358922528e-24, -6.532792304806124e-27,  2.580005945874018e-02, -1.444479316635555e-04,  1.207376866912313e-06, -9.076232004566021e-09,  6.362429860403967e-11,
 -4.241856259781796e-13,  2.742993946191971e-15, -1.693289736577137e-17,  1.056384112007433e-19, -5.935018982840602e-22,  3.671585106396642e-24, -2.405073949611434e-26,
  1.242603370033976e-02, -9.021088550685841e-05,  9.329396158634731e-07, -8.169402785401266e-09,  6.633538298692324e-11, -5.088808030909698e-13,  3.753364997293603e-15,
 -2.638974230102375e-17,  1.837852236718534e-19, -1.191866068884653e-21,  7.974168792476403e-24, -5.392128299194107e-26,  4.965443940852769e-03, -4.662333721060231e-05,
  5.727188774577198e-07, -5.775796308334382e-09,  5.379648007380995e-11, -4.697224592401002e-13,  3.908673865877896e-15, -3.096619872664437e-17,  2.392404722045114e-19,
 -1.754578159842979e-21,  1.280370435349311e-23, -9.217720255665320e-26,  1.641687678762521e-03, -1.974450324068574e-05,  2.814282175374046e-07, -3.250298053380176e-09,
  3.445025535771395e-11, -3.395153769418076e-13,  3.164304084598725e-15, -2.801128061420925e-17,  2.393321203851794e-19, -1.955612853062025e-21,  1.562585856415880e-23,
 -1.218595938463966e-25,  4.475598209255632e-04, -6.813036849789883e-06,  1.112678573867175e-07, -1.465948527456911e-09,  1.756865622642682e-11, -1.942447229507245e-13,
  2.017383512838371e-15, -1.983546896229944e-17,  1.869064231187712e-19, -1.686765277787073e-21,  1.475459190020177e-23, -1.252732325023142e-25,  1.002011531009421e-04,
 -1.907969115788726e-06,  3.548054196412899e-08, -5.315528539264432e-10,  7.168683121265470e-12, -8.854223658048227e-14,  1.021035273779789e-15, -1.110448864852000e-17,
  1.151180854611509e-19, -1.141582088048648e-21,  1.091519697549906e-23, -1.009332120432618e-25,  1.833505388686433e-05, -4.320798631432216e-07,  9.125840402799037e-09,
 -1.550623368130493e-10,  2.345569826238995e-12, -3.227231845132640e-14,  4.121920297860235e-16, -4.945085755679901e-18,  5.629615717527901e-20, -6.116067964379253e-22,
  6.382380163611448e-24, -6.422236519482228e-26,  2.726978404888067e-06, -7.881230790028582e-08,  1.890017842935056e-09, -3.635426077574735e-11,  6.156016048188663e-13,
 -9.419323681886960e-15,  1.330522945133477e-16, -1.757966666554557e-18,  2.195153776485871e-20, -2.608363176675454e-22,  2.967568870089980e-24, -3.246773640027965e-26,
  3.275916278508884e-07, -1.152515459492449e-08,  3.141783673752613e-10, -6.833923716919150e-12,  1.294425736836640e-13, -2.201078099360767e-15,  3.436484050859065e-17,
 -4.997206074156585e-19,  6.841165562093424e-21, -8.884867619175017e-23,  1.101569568586305e-24, -1.309948778372001e-26,  3.156077879001601e-08, -1.343877721764222e-09,
  4.173337121900524e-11, -1.026475647042397e-12,  2.175392448903072e-14, -4.111860770046881e-16,  7.097566578921787e-18, -1.136145582423897e-19,  1.705697780502359e-21,
 -2.421638069244733e-23,  3.272608146492751e-25, -4.230842787623538e-27,  2.419344589548717e-09, -1.241702863709294e-10,  4.405922559833926e-12, -1.226582816689884e-13,
  2.912227707310253e-15, -6.125942796890097e-17,  1.170376397846157e-18, -2.064493899616091e-20,  3.402446968823551e-22, -5.285545150113470e-24,  7.792811542254908e-26,
 -1.096214911583321e-27,  1.463042148971810e-10, -9.028167025019684e-12,  3.674233619677395e-13, -1.160211446106982e-14,  3.093183723724531e-16, -7.256385501636706e-18,
  1.537563288617602e-19, -2.994403255700939e-21,  5.427347227112105e-23, -9.241035850023050e-25,  1.488863353245150e-26, -2.282440501436748e-28,  6.916967004258534e-12,
 -5.127484992459216e-13,  2.404651707493597e-14, -8.641336443159356e-16,  2.595745764222402e-17, -6.812598509518345e-19,  1.605773273851777e-20, -3.462390039316506e-22,
  6.920166070381340e-24, -1.294748808104559e-25,  2.285053699828623e-27, -3.826277703519557e-29,  2.534161312097316e-13, -2.258484999873110e-14,  1.227487409011991e-15,
 -5.043543833532572e-17,  1.714844458395487e-18, -5.056834178081316e-20,  1.331294832446984e-21, -3.190408541189244e-23,  7.057108433598108e-25, -1.455874675291956e-26,
  2.823750359807702e-28, -5.180599524369467e-30,  7.141170233755517e-15, -7.670900570654835e-16,  4.865057572683574e-17, -2.299724733567432e-18,  8.903455393659780e-20,
 -2.966508738684309e-21,  8.769129828898293e-23, -2.347297078313121e-24,  5.773330964597873e-26, -1.319095850282500e-27,  2.823508365565033e-29, -5.698119868110036e-31,
  1.542262610684304e-16, -2.005390270297097e-17,  1.496495451954904e-18, -8.202150341165918e-20,  3.642986012228145e-21, -1.381144530455557e-22,  4.614718412342992e-24,
 -1.388363660948058e-25,  3.819313396669303e-27, -9.718132679862435e-29,  2.307596181125962e-30, -5.147612239399665e-32,  2.566557302230457e-18, -4.064016944026719e-19,
  3.603419117715499e-20, -2.311983667520957e-21,  1.188865809757907e-22, -5.173042262507411e-24,  1.969478092243652e-25, -6.710195790567684e-27,  2.079259719201361e-28,
 -5.930927893377710e-30,  1.571974800189570e-31, -3.898448154719994e-33,  3.374977146662121e-20, -6.554513212244342e-21,  6.982189874154713e-22, -5.302778867581007e-23,
  3.190710247635625e-24, -1.609419531510382e-25,  7.047229764095899e-27, -2.742755469778423e-28,  9.650214051356309e-30, -3.108799437450661e-31,  9.260667424015163e-33,
 -2.569368219221489e-34,  3.751719006369307e-22, -8.994900299567470e-23,  1.164005879504545e-23, -1.058505350754732e-24,  7.535309205835715e-26, -4.451713129981470e-27,
  2.263339224641902e-28, -1.015040359949341e-29,  4.087435380196149e-31, -1.497842037652256e-32,  5.047224733306764e-34, -1.575720332902130e-35,  4.120509785671837e-24,
 -1.220689013277339e-24,  1.932052310248439e-25, -2.120183867719761e-26,  1.799338671952161e-27, -1.253776291757203e-28,  7.447539693304315e-30, -3.869433124499836e-31,
  1.791464765234077e-32, -7.495654537559172e-34,  2.865680310840814e-35, -1.008926344466209e-36,  6.159768484758269e-26, -2.217170935595616e-26,  4.251817174896917e-27,
 -5.590086295703479e-28,  5.619153698729930e-29, -4.588607033047102e-30,  3.163601395422600e-31, -1.891093693536249e-32,  9.993026203762245e-34, -4.737421449038753e-35,
  2.038361818562907e-36, -8.024860662375618e-38,  1.973747175312094e-27, -8.162942383018245e-28,  1.804393893648556e-28, -2.715056357312319e-29,  3.097163965787075e-30,
 -2.846602422295211e-31,  2.191981430497351e-32, -1.453098513408615e-33,  8.460081364416210e-35, -4.392526034135614e-36,  2.058526120444970e-37, -8.780666702156578e-39,
  7.581400239519977e-02, -2.375058814901389e-04,  7.698784020796498e-07, -2.585343925335285e-09,  8.713793749138171e-12, -3.261058938995887e-14,  7.943333005955671e-17,
 -8.446176212518507e-19, -4.612018803659746e-21, -4.871735134145274e-23,  5.674939657166614e-25,  2.806185035905271e-26,  6.314568241778802e-02, -2.209021928226390e-04,
  9.686261804666650e-07, -4.594358743565646e-09,  2.180410410994880e-11, -1.034073496431073e-13,  4.576161921179121e-16, -2.360811072478401e-18,  6.625709554989673e-21,
 -6.267017399415430e-23,  4.655575989598775e-25,  1.307087975932290e-26,  4.378152157844395e-02, -1.854354470612753e-04,  1.147029681766489e-06, -7.044332517891813e-09,
  4.118675941302692e-11, -2.310898765319215e-13,  1.264855662224366e-15, -6.656132764492450e-18,  3.578630640363872e-20, -1.727209676002305e-22,  8.547583091658829e-25,
 -7.846975068544597e-27,  2.524091957831651e-02, -1.352078923520163e-04,  1.104301214969612e-06, -8.122690635013872e-09,  5.576239473894429e-11, -3.636800168490662e-13,
  2.313176762344056e-15, -1.386807967279862e-17,  8.665577435322426e-20, -4.684722321006911e-22,  2.548841320727919e-24, -2.835818984073827e-26,  1.207952080913530e-02,
 -8.312219959021505e-05,  8.409543133552094e-07, -7.184802959183533e-09,  5.700199658111134e-11, -4.270399868521348e-13,  3.090750299925840e-15, -2.113807843611355e-17,
  1.460668240037451e-19, -9.183946009713411e-22,  5.728721135908530e-24, -4.992132076682337e-26,  4.787694890055932e-03, -4.230487403788247e-05,  5.082795076702519e-07,
 -4.985391258353216e-09,  4.527411679526988e-11, -3.855088546241614e-13,  3.139965097184435e-15, -2.422981223785358e-17,  1.843792150820314e-19, -1.316883831636240e-21,
  9.222645497361726e-24, -7.270855265716311e-26,  1.566978075364783e-03, -1.764021185633911e-05,  2.455204583983287e-07, -2.749542065561926e-09,  2.836006271511351e-11,
 -2.721794296959480e-13,  2.477427951131550e-15, -2.136825482680376e-17,  1.789916119837684e-19, -1.426719080329276e-21,  1.106459904458831e-23, -8.804039556852393e-26,
  4.219829246964859e-04, -5.988759896725038e-06,  9.524289778528389e-08, -1.213475870281159e-09,  1.412621579210407e-11, -1.518686707636438e-13,  1.537349289640284e-15,
 -1.472211828279622e-17,  1.355976216826738e-19, -1.193920157359054e-21,  1.017475796666217e-23, -8.574454618836649e-26,  9.309915291886594e-05, -1.647815865273494e-06,
  2.973570444725718e-08, -4.297879358038327e-10,  5.619702378398974e-12, -6.738739398026061e-14,  7.560582055447358e-16, -8.001978182367232e-18,  8.091549609053469e-20,
 -7.824239847131664e-22,  7.294548190163245e-24, -6.624006145545302e-26,  1.674180329886193e-05, -3.659239186333487e-07,  7.470588082525003e-09, -1.222029512251541e-10,
  1.788805821839224e-12, -2.385640228346357e-14,  2.959619750887669e-16, -3.451663751243579e-18,  3.826544631067495e-20, -4.050042924994738e-22,  4.119642209970435e-24,
 -4.052833892346976e-26,  2.439425374749304e-06, -6.528299384185324e-08,  1.507167209259749e-09, -2.785363804877408e-11,  4.555367998781197e-13, -6.745290245717552e-15,
  9.240033765350000e-17, -1.185378838112797e-18,  1.439348507731699e-20, -1.664488977164748e-22,  1.844466478626340e-24, -1.968660117293133e-26,  2.860441200851347e-07,
 -9.307624048234669e-09,  2.432782110644302e-10, -5.074550634342524e-12,  9.265153697673651e-14, -1.522167563384959e-15,  2.301132986306423e-17, -3.244882452630959e-19,
  4.314067269653077e-21, -5.446913156725090e-23,  6.571538034950475e-25, -7.613134339113020e-27,  2.678258887852639e-08, -1.053934340372870e-09,  3.125992844949303e-11,
 -7.359275411845813e-13,  1.500470103190687e-14, -2.735746353757314e-16,  4.565555235872667e-18, -7.077848714248411e-20,  1.030655437337518e-21, -1.420991086820092e-23,
  1.866855085668833e-25, -2.348735601866830e-27,  1.984843106209724e-09, -9.410246946467692e-11,  3.177621235748085e-12, -8.451443843169882e-14,  1.926790594364085e-15,
 -3.903320373033988e-17,  7.199407269960543e-19, -1.228315113718671e-20,  1.961158100412844e-22, -2.955417155762075e-24,  4.231945252861785e-26, -5.787966332295178e-28,
  1.152942802699068e-10, -6.571402549876509e-12,  2.536826292879585e-13, -7.638876693026338e-15,  1.951982327436326e-16, -4.403169201966109e-18,  8.994449465307865e-20,
 -1.692133363773786e-21,  2.967856132366212e-23, -4.897121585196570e-25,  7.655845384695045e-27, -1.140129204707430e-28,  5.193798929248163e-12, -3.557085334645887e-13,
  1.577899402721788e-14, -5.397721642891155e-16,  1.551395379187433e-17, -3.909363571901608e-19,  8.871514976425438e-21, -1.845705590886802e-22,  3.565958162004639e-24,
 -6.459552279031372e-26,  1.105268107507884e-27, -1.796545059861739e-29,  1.794531659102125e-13, -1.478634010096324e-14,  7.584039903351446e-16, -2.961618523830024e-17,
  9.620151630752622e-19, -2.720131284839987e-20,  6.886377874266561e-22, -1.590681780087104e-23,  3.398113019146919e-25, -6.781754547951755e-27,  1.274362276973784e-28,
 -2.268151088320203e-30,  4.705501206363953e-15, -4.679184428459418e-16,  2.796060364530336e-17, -1.254548217014968e-18,  4.634425485217789e-20, -1.478994912944882e-21,
  4.200210034865789e-23, -1.082799646413829e-24,  2.570261213226641e-26, -5.677782147467310e-28,  1.176869525768622e-29, -2.303170462060768e-31,  9.288536823178561e-17,
 -1.120459678797961e-17,  7.872086280988868e-19, -4.092361527320666e-20,  1.733015826356015e-21, -6.289021470756549e-23,  2.017641949212023e-24, -5.843561531010823e-26,
  1.550911083114275e-27, -3.814490650825992e-29,  8.769852132045645e-31, -1.897036256953067e-32,  1.378844061445706e-18, -2.032305603662957e-19,  1.697445187009775e-20,
 -1.033177567420937e-21,  5.065787898328241e-23, -2.110041413539695e-24,  7.714498482951991e-26, -2.530793876561026e-27,  7.568022403528065e-29, -2.087414806432778e-30,
  5.359263935878626e-32, -1.289490691539674e-33,  1.563779066325925e-20, -2.841956923712990e-21,  2.858708511684775e-22, -2.063192706176222e-23,  1.185416080436259e-24,
 -5.731387579696187e-26,  2.413147091269956e-27, -9.054921285879513e-29,  3.078691503408102e-30, -9.603519533177059e-32,  2.775030471083873e-33, -7.480898432978866e-35,
  1.431219791943321e-22, -3.238021317225805e-23,  3.978179847385386e-24, -3.452697485137903e-25,  2.355897873942814e-26, -1.338752137264409e-27,  6.566409655844963e-29,
 -2.848218101852029e-30,  1.111777278683597e-31, -3.956972296906506e-33,  1.297303696326843e-34, -3.946958756427506e-36,  1.219133316137394e-24, -3.452600954536811e-25,
  5.240203405309279e-26, -5.535324564563490e-27,  4.537154789455515e-28, -3.062318715097979e-29,  1.766413004225507e-30, -8.931574766887200e-32,  4.032092777267473e-33,
 -1.647864002398393e-34,  6.163111706859129e-36, -2.125758220434656e-37,  1.337186112981509e-26, -4.686039910137903e-27,  8.755020644703476e-28, -1.123727862144048e-28,
  1.104976283963646e-29, -8.843009508975384e-31,  5.984792427300223e-32, -3.516907095650468e-33,  1.829319222378200e-34, -8.546421876440380e-36,  3.627670432438118e-37,
 -1.410297070557738e-38,  3.217883363933003e-28, -1.320100285649597e-28,  2.893890882671008e-29, -4.320495206429155e-30,  4.892963040263772e-31, -4.467118192789866e-32,
  3.418621602465502e-33, -2.253320315886369e-34,  1.304959394334928e-35, -6.742093350971486e-37,  3.145158420654461e-38, -1.335850959524935e-39,  7.487610371907685e-02,
 -2.314686295663592e-04,  7.396695889792855e-07, -2.451045698064619e-09,  8.078638093651515e-12, -3.100605215649374e-14,  5.350210250644968e-17, -1.012913535440308e-18,
 -5.573821263258874e-21,  8.383313467510007e-24,  2.563116424994608e-24,  6.591404701071532e-26,  6.227723066441768e-02, -2.133679352944449e-04,  9.155206932314419e-07,
 -4.261463591297084e-09,  1.984054623057693e-11, -9.319575839245322e-14,  3.941760860728278e-16, -2.179895850294616e-18,  4.885464798729109e-21, -2.779247291358131e-23,
  1.412786744335865e-24,  3.153752762869673e-26,  4.305761226157317e-02, -1.765864756155859e-04,  1.066304276196174e-06, -6.420730485416630e-09,  3.685407632865584e-11,
 -2.028459251201474e-13,  1.093624317954763e-15, -5.604588988363283e-18,  3.009208289066308e-20, -1.464103362503186e-22,  4.312273053810965e-25, -1.190785761740881e-26,
  2.471716021171802e-02, -1.267487382410013e-04,  1.011951511703863e-06, -7.285791319191483e-09,  4.901405967365104e-11, -3.125250455044423e-13,  1.961282215444786e-15,
 -1.134788201510676e-17,  7.129646772949853e-20, -3.947753593601865e-22,  1.036097768396751e-24, -4.207871273730211e-26,  1.175996229955250e-02, -7.672455496007786e-05,
  7.599395506621657e-07, -6.337259181936119e-09,  4.915764122699852e-11, -3.594652720749299e-13,  2.559641828350062e-15, -1.695306846401551e-17,  1.165894650472014e-19,
 -7.344911371275290e-22,  3.412979426424592e-24, -5.725350350422264e-26,  4.626245621161759e-03, -3.846618266718468e-05,  4.525593525841130e-07, -4.318811501923786e-09,
  3.826584668714188e-11, -3.176656044542200e-13,  2.537477621457708e-15, -1.902306561621775e-17,  1.428694801524222e-19, -1.008965016138976e-21,  6.226792953162328e-24,
 -6.533086670327976e-26,  1.500146960154928e-03, -1.580070595988418e-05,  2.150788167961477e-07, -2.336291565363397e-09,  2.346574777395195e-11, -2.192982428955366e-13,
  1.952150879094299e-15, -1.638404613130878e-17,  1.347263918313979e-19, -1.054782453909597e-21,  7.679805129582260e-24, -6.772120613113898e-26,  3.994646830288993e-04,
 -5.281439703162202e-06,  8.194320172560971e-08, -1.009882517005114e-09,  1.142679162861359e-11, -1.194656778927087e-13,  1.179936040412964e-15, -1.099900930415737e-17,
  9.911015621441408e-20, -8.540949524906162e-22,  7.000053632690772e-24, -6.046966071756387e-26,  8.695302739884928e-05, -1.429127873007267e-06,  2.507626239078423e-08,
 -3.497400102884171e-10,  4.436668588789913e-12, -5.166221725964947e-14,  5.643891688415855e-16, -5.812298773826144e-18,  5.736494549433294e-20, -5.417211440200877e-22,
  4.900353388318094e-24, -4.423336646706646e-26,  1.538899167352175e-05, -3.115723083860141e-07,  6.161298797361744e-09, -9.704368048288642e-11,  1.375542091909494e-12,
 -1.778712181588774e-14,  2.144744517328716e-16, -2.431837668582587e-18,  2.626646494609946e-20, -2.710706270677450e-22,  2.683008015270701e-24, -2.592421551952804e-26,
  2.200453528847055e-06, -5.444824726468133e-08,  1.212564767733036e-09, -2.153422029549934e-11,  3.403658545196508e-13, -4.878989261648538e-15,  6.484967541278146e-17,
 -8.079600095806236e-19,  9.544091533581285e-21, -1.074724749643746e-22,  1.159413654420378e-24, -1.209388490090378e-26,  2.523531653326903e-07, -7.581908587069759e-09,
  1.903629080221428e-10, -3.808496094258606e-12,  6.706851008800328e-14, -1.064969504588633e-15,  1.559627390627787e-17, -2.133289261293320e-19,  2.755383607471511e-21,
 -3.383469806231653e-23,  3.972232917590407e-25, -4.486680529931289e-27,  2.301633838662056e-08, -8.354784026751557e-10,  2.370628295902972e-11, -5.342831276441362e-13,
  1.048584377686832e-14, -1.844817791939488e-16,  2.977799549303328e-18, -4.472164591816432e-20,  6.318505850846172e-22, -8.462573700179260e-24,  1.081000456193258e-25,
 -1.324092658546531e-27,  1.653520768124767e-09, -7.226786949503427e-11,  2.325407657367155e-12, -5.909762927440851e-14,  1.294340829257838e-15, -2.526036354648468e-17,
  4.499470661735628e-19, -7.427116970706817e-21,  1.149124351651070e-22, -1.680325886545501e-24,  2.337296504967050e-26, -3.108817739756280e-28,  9.255404060521824e-11,
 -4.861517286507405e-12,  1.781891885314752e-13, -5.117292403288803e-15,  1.253762567345631e-16, -2.720137047334441e-18,  5.358106413605099e-20, -9.739819483224589e-22,
  1.653412358115748e-23, -2.644402695954607e-25,  4.012045379780863e-27, -5.805156742619523e-29,  3.987664996582214e-12, -2.516927820428608e-13,  1.056622577476889e-14,
 -3.440801895678343e-16,  9.464306006139704e-18, -2.290191976881010e-19,  5.004411305520869e-21, -1.004729858711750e-22,  1.876676537824484e-24, -3.291689810152813e-26,
  5.461038872079587e-28, -8.617251597637012e-30,  1.305128703427795e-13, -9.915199913335487e-15,  4.799529376193709e-16, -1.781007353654990e-17,  5.526925254537271e-19,
 -1.498465016750532e-20,  3.648043198519006e-22, -8.122252067230247e-24,  1.675735359810468e-25, -3.235286002905753e-27,  5.889824678910000e-29, -1.016932894137887e-30,
  3.201076763918880e-15, -2.937836599934750e-16,  1.653174304019784e-17, -7.037582028265071e-19,  2.479967892777407e-20, -7.578944444401401e-22,  2.067417386807202e-23,
 -5.132123186728877e-25,  1.175506311848240e-26, -2.510183679494399e-28,  5.037529949009959e-30, -9.558587137764444e-32,  5.811016431360684e-17, -6.480782748744865e-18,
  4.282013908469168e-19, -2.109636003119524e-20,  8.512796074854928e-22, -2.955498880760277e-23,  9.100210679771365e-25, -2.536179106426878e-26,  6.491500450360699e-28,
 -1.542699077597723e-29,  3.432838969796375e-31, -7.198027412062753e-33,  7.749137393165358e-19, -1.059045335637585e-19,  8.317047658865597e-21, -4.795938906502342e-22,
  2.239784956464797e-23, -8.922452815335667e-25,  3.130100482625379e-26, -9.879763719043682e-28,  2.849171348974545e-29, -7.593927274700523e-31,  1.887367865871724e-32,
 -4.403166894661550e-34,  7.637572746225555e-21, -1.293150778382903e-21,  1.225042357058596e-22, -8.384971009458059e-24,  4.592570380205924e-25, -2.125313478850533e-26,
  8.593258368017460e-28, -3.105087816359342e-29,  1.019073498379057e-30, -3.074855917507108e-32,  8.610317265020170e-34, -2.253176042953798e-35,  5.794109305792095e-23,
 -1.230845848959723e-23,  1.430639509864587e-24, -1.181735223721861e-25,  7.710337290619922e-27, -4.205582134457209e-28,  1.986289633061554e-29, -8.318659524120949e-31,
  3.142570646742506e-32, -1.084718045383534e-33,  3.455278855870074e-35, -1.023122711155336e-36,  3.834348664133974e-25, -1.032681805407027e-25,  1.496780803170098e-26,
 -1.516651922926000e-27,  1.197077320172701e-28, -7.805374570144988e-30,  4.361613308401266e-31, -2.141615425795707e-32,  9.408524660682769e-34, -3.748907748433236e-35,
  1.369318357549651e-36, -4.619680981377157e-38,  3.047978887915318e-27, -1.035561027256369e-27,  1.877975439999328e-28, -2.345570348607746e-29,  2.249799306041451e-30,
 -1.760073961216165e-31,  1.166664684761148e-32, -6.725948689495931e-34,  3.437359930400959e-35, -1.579936920083893e-36,  6.605722430142686e-38, -2.532321014797904e-39,
  5.345955879876385e-29, -2.172150804520625e-29,  4.715470142608072e-30, -6.976097695346811e-31,  7.834261834941438e-32, -7.097338289528192e-33,  5.392989512916768e-34,
 -3.531455799308841e-35,  2.032812186690757e-36, -1.044382200912587e-37,  4.846711753761645e-39, -2.048642921550962e-40,  };
  int offset = -25;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 25;
    if (std::isnan(t)) {
      fill_n(rr+offset, 25, 0.5);
      fill_n(ww+offset, 25, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 25; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=25; ++j) {
        const int boxof = it*300+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
