/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.res.StringManager;

public class ContextNamingInfoListener
implements LifecycleListener {
    private static final String PATH_ENTRY_NAME = "context/path";
    private static final String ENCODED_PATH_ENTRY_NAME = "context/encodedPath";
    private static final String WEBAPP_VERSION_ENTRY_NAME = "context/webappVersion";
    private static final String NAME_ENTRY_NAME = "context/name";
    private static final String BASE_NAME_ENTRY_NAME = "context/baseName";
    private static final String DISPLAY_NAME_ENTRY_NAME = "context/displayName";
    private static final Log log = LogFactory.getLog(ContextNamingInfoListener.class);
    private static final StringManager sm = StringManager.getManager(ContextNamingInfoListener.class);
    private boolean emptyOnRoot = true;

    public void setEmptyOnRoot(boolean bl) {
        this.emptyOnRoot = bl;
    }

    public boolean isEmptyOnRoot() {
        return this.emptyOnRoot;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if (lifecycleEvent.getType().equals("configure_start")) {
            if (!(lifecycleEvent.getLifecycle() instanceof Context)) {
                log.warn((Object)sm.getString("listener.notContext", new Object[]{lifecycleEvent.getLifecycle().getClass().getSimpleName()}));
                return;
            }
            Context context = (Context)lifecycleEvent.getLifecycle();
            String string = context.getPath();
            String string2 = context.getEncodedPath();
            String string3 = context.getName();
            if (!this.emptyOnRoot && string.isEmpty()) {
                string2 = "/";
                string = "/";
                string3 = "ROOT" + string3;
            }
            this.addEnvEntry(context, PATH_ENTRY_NAME, string);
            this.addEnvEntry(context, ENCODED_PATH_ENTRY_NAME, string2);
            this.addEnvEntry(context, WEBAPP_VERSION_ENTRY_NAME, context.getWebappVersion());
            this.addEnvEntry(context, NAME_ENTRY_NAME, string3);
            this.addEnvEntry(context, BASE_NAME_ENTRY_NAME, context.getBaseName());
            this.addEnvEntry(context, DISPLAY_NAME_ENTRY_NAME, context.getDisplayName());
        }
    }

    private void addEnvEntry(Context context, String string, String string2) {
        ContextEnvironment contextEnvironment = new ContextEnvironment();
        contextEnvironment.setName(string);
        contextEnvironment.setOverride(true);
        contextEnvironment.setType("java.lang.String");
        contextEnvironment.setValue(string2);
        if (log.isDebugEnabled()) {
            log.info((Object)sm.getString("contextNamingInfoListener.envEntry", new Object[]{string, string2}));
        }
        context.getNamingResources().addEnvironment(contextEnvironment);
    }
}

