/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.Permission;
import org.apache.solr.security.RuleBasedAuthorizationPluginBase;

public class RuleBasedAuthorizationPlugin
extends RuleBasedAuthorizationPluginBase {
    private final Map<String, Set<String>> usersVsRoles = new HashMap<String, Set<String>>();
    private boolean useShortName;

    @Override
    public void init(Map<String, Object> initInfo) {
        super.init(initInfo);
        Map<String, Object> map = SecurityConfHandler.getMapValue(initInfo, "user-role");
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> o;
            Map.Entry<String, Object> e = o = iterator.next();
            String roleName = e.getKey();
            this.usersVsRoles.put(roleName, Permission.readValueAsSet(map, roleName));
        }
        this.useShortName = Boolean.parseBoolean(initInfo.getOrDefault("useShortName", Boolean.FALSE).toString());
    }

    @Override
    public Set<String> getUserRoles(AuthorizationContext context) {
        if (this.useShortName) {
            return this.usersVsRoles.get(context.getUserName());
        }
        return this.getUserRoles(context.getUserPrincipal());
    }

    @Override
    public Set<String> getUserRoles(Principal principal) {
        return this.usersVsRoles.get(principal.getName());
    }
}

