/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bool;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.bool.BoolBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.bool.BoolBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypes;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.Boolean})
public final class BoolBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = BoolBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BoolBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.nb_xor, isComplex=true)
    @GenerateNodeFactory
    static abstract class XorNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        XorNode() {
        }

        @Specialization
        static Object doBool(boolean self, boolean other) {
            return self ^ other;
        }

        @Fallback
        static Object doOther(VirtualFrame frame, Object self, Object other, @Cached IntBuiltins.XorNode xorNode) {
            return xorNode.execute(frame, self, other);
        }
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @GenerateNodeFactory
    static abstract class OrNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        OrNode() {
        }

        @Specialization
        static Object doBool(boolean self, boolean other) {
            return self || other;
        }

        @Fallback
        static Object doOther(VirtualFrame frame, Object self, Object other, @Cached IntBuiltins.OrNode orNode) {
            return orNode.execute(frame, self, other);
        }
    }

    @Slot(value=Slot.SlotKind.nb_and, isComplex=true)
    @GenerateNodeFactory
    static abstract class AndNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        AndNode() {
        }

        @Specialization
        static Object doBool(boolean self, boolean other) {
            return self && other;
        }

        @Fallback
        static Object doOther(VirtualFrame frame, Object self, Object other, @Cached IntBuiltins.AndNode andNode) {
            return andNode.execute(frame, self, other);
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class RepNode
    extends StrNode {
        RepNode() {
        }
    }

    @Slot(value=Slot.SlotKind.tp_str, isComplex=true)
    @TypeSystemReference(value=PythonIntegerTypes.class)
    @GenerateNodeFactory
    static abstract class StrNode
    extends PythonUnaryBuiltinNode {
        StrNode() {
        }

        @Specialization
        static TruffleString doBoolean(boolean self) {
            return self ? StringLiterals.T_TRUE : StringLiterals.T_FALSE;
        }

        @Specialization
        public static TruffleString doLong(long self) {
            return self == 1L ? StringLiterals.T_TRUE : StringLiterals.T_FALSE;
        }

        @Specialization
        public static TruffleString doPInt(PInt self) {
            return self.isZero() ? StringLiterals.T_FALSE : StringLiterals.T_TRUE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="bool", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class BoolNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        public static boolean bool(VirtualFrame frame, Object cls, Object obj, @Cached PyObjectIsTrueNode isTrue) {
            return isTrue.execute((Frame)frame, obj);
        }
    }
}

