/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.implementation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import schemacrawler.ermodel.model.EntityType;
import schemacrawler.ermodel.model.RelationshipCardinality;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableReference;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.OptionalBoolean;

public final class TableEntityModelInferrer {
    private final Table table;
    private final Set<Set<Column>> uniqueIndexes;
    private final Set<Set<Column>> indexes;
    private final Set<ForeignKey> importedForeignKeys;
    private final Set<Column> tablePkColumns;
    private final Map<NamedObjectKey, Set<Column>> importedColumnsMap;
    private final Map<NamedObjectKey, Set<Column>> pkColumnsMap;
    private final Map<NamedObjectKey, Set<Column>> parentPkColumnsMap;

    public TableEntityModelInferrer(Table table) {
        this.table = Objects.requireNonNull(table, "No table provided");
        this.uniqueIndexes = new HashSet<Set<Column>>();
        this.indexes = new HashSet<Set<Column>>();
        this.importedForeignKeys = new HashSet<ForeignKey>();
        this.tablePkColumns = new HashSet<Column>();
        this.importedColumnsMap = new HashMap<NamedObjectKey, Set<Column>>();
        this.pkColumnsMap = new HashMap<NamedObjectKey, Set<Column>>();
        this.parentPkColumnsMap = new HashMap<NamedObjectKey, Set<Column>>();
        if (!MetaDataUtility.isPartial(table)) {
            this.buildSupportingLookups();
            this.buildIndexesLookup();
        }
    }

    public boolean inferBridgeTable() {
        if (this.importedForeignKeys.size() < 2) {
            return false;
        }
        long countDistinctFk = this.importedForeignKeys.stream().map(TableReference::getPrimaryKeyTable).distinct().count();
        if (countDistinctFk < 2L) {
            return false;
        }
        for (ForeignKey fk1 : this.importedForeignKeys) {
            for (ForeignKey fk2 : this.importedForeignKeys) {
                if (fk1.equals(fk2) || fk1.getPrimaryKeyTable().equals(fk2.getPrimaryKeyTable())) continue;
                HashSet combinedFkColumns = new HashSet(this.importedColumnsMap.get(fk1.key()));
                combinedFkColumns.addAll(this.importedColumnsMap.get(fk2.key()));
                if (!this.uniqueIndexes.contains(combinedFkColumns)) continue;
                return true;
            }
        }
        return false;
    }

    public EntityType inferEntityType() {
        if (MetaDataUtility.isPartial(this.table)) {
            return EntityType.unknown;
        }
        if (!this.table.hasPrimaryKey()) {
            return EntityType.non_entity;
        }
        for (ForeignKey fk : this.importedForeignKeys) {
            Set<Column> fkParentColumns = this.pkColumnsMap.get(fk.key());
            Set<Column> parentPkColumns = this.parentPkColumnsMap.get(fk.key());
            Set<Column> fkChildColumns = this.importedColumnsMap.get(fk.key());
            if (!parentPkColumns.isEmpty() && parentPkColumns.equals(fkParentColumns) && this.tablePkColumns.equals(fkChildColumns)) {
                return EntityType.subtype;
            }
            if (parentPkColumns.isEmpty() || !parentPkColumns.equals(fkParentColumns) || !this.tablePkColumns.containsAll(fkChildColumns) || this.tablePkColumns.size() <= fkChildColumns.size()) continue;
            return EntityType.weak_entity;
        }
        boolean pkHasFkColumn = this.tablePkColumns.stream().anyMatch(Column::isPartOfForeignKey);
        if (!pkHasFkColumn) {
            HashSet<Table> referencedTables = new HashSet<Table>(this.table.getReferencedTables());
            referencedTables.remove(this.table);
            if (referencedTables.size() < 2) {
                return EntityType.strong_entity;
            }
        }
        return EntityType.unknown;
    }

    public RelationshipCardinality inferCardinality(TableReference fk) {
        if (!this.isFkValid(fk)) {
            return RelationshipCardinality.unknown;
        }
        Set<Column> importedColumns = this.findOrGetImportedKeys(fk);
        boolean isForeignKeyUnique = this.uniqueIndexes.contains(importedColumns);
        boolean isForeignKeyOptional = fk.isOptional();
        RelationshipCardinality cardinality = isForeignKeyUnique ? (isForeignKeyOptional ? RelationshipCardinality.zero_one : RelationshipCardinality.one_one) : (isForeignKeyOptional ? RelationshipCardinality.zero_many : RelationshipCardinality.one_many);
        return cardinality;
    }

    public Optional<Table> inferSuperType() {
        if (this.inferEntityType() != EntityType.subtype) {
            return Optional.empty();
        }
        for (ForeignKey fk : this.importedForeignKeys) {
            Set<Column> fkParentColumns = this.pkColumnsMap.get(fk.key());
            Set<Column> parentPkColumns = this.parentPkColumnsMap.get(fk.key());
            if (!parentPkColumns.equals(fkParentColumns)) continue;
            return Optional.of(fk.getPrimaryKeyTable());
        }
        return Optional.empty();
    }

    public OptionalBoolean coveredByIndex(TableReference fk) {
        if (!this.isFkValid(fk)) {
            return OptionalBoolean.unknown;
        }
        Set<Column> importedColumns = this.findOrGetImportedKeys(fk);
        for (Set<Column> indexColumns : this.indexes) {
            if (!indexColumns.containsAll(importedColumns)) continue;
            return OptionalBoolean.true_value;
        }
        return OptionalBoolean.false_value;
    }

    public OptionalBoolean coveredByUniqueIndex(TableReference fk) {
        if (!this.isFkValid(fk)) {
            return OptionalBoolean.unknown;
        }
        Set<Column> importedColumns = this.findOrGetImportedKeys(fk);
        return OptionalBoolean.fromBoolean(this.uniqueIndexes.contains(importedColumns));
    }

    public String toString() {
        return this.table.toString();
    }

    private void buildIndexesLookup() {
        if (this.table.hasPrimaryKey()) {
            Set<TableConstraintColumn> pkColumns = Set.copyOf(this.table.getPrimaryKey().getConstrainedColumns());
            this.uniqueIndexes.add(pkColumns);
            this.indexes.add(pkColumns);
        }
        if (this.table.hasIndexes()) {
            for (Index index : this.table.getIndexes()) {
                Set<IndexColumn> indexColumns = Set.copyOf(index.getColumns());
                this.indexes.add(indexColumns);
                if (!index.isUnique()) continue;
                this.uniqueIndexes.add(indexColumns);
            }
        }
    }

    private void buildSupportingLookups() {
        for (ForeignKey fk : this.table.getImportedForeignKeys()) {
            if (fk.isSelfReferencing()) continue;
            this.importedForeignKeys.add(fk);
        }
        if (this.table.hasPrimaryKey()) {
            this.tablePkColumns.addAll(this.table.getPrimaryKey().getConstrainedColumns());
        }
        for (ForeignKey fk : this.importedForeignKeys) {
            Set<Column> fkParentColumns = Set.copyOf(fk.getColumnReferences().stream().map(ColumnReference::getPrimaryKeyColumn).toList());
            this.pkColumnsMap.put(fk.key(), fkParentColumns);
            this.findOrGetImportedKeys(fk);
            Table parentTable = fk.getPrimaryKeyTable();
            if (!MetaDataUtility.isPartial(parentTable) && parentTable.hasPrimaryKey()) {
                Set<TableConstraintColumn> parentPkColumns = Set.copyOf(parentTable.getPrimaryKey().getConstrainedColumns());
                this.parentPkColumnsMap.put(fk.key(), parentPkColumns);
                continue;
            }
            this.parentPkColumnsMap.put(fk.key(), Collections.emptySet());
        }
    }

    private Set<Column> findOrGetImportedKeys(TableReference fk) {
        Objects.requireNonNull(fk, "No foreign key provided");
        return this.importedColumnsMap.computeIfAbsent(fk.key(), key -> Set.copyOf(fk.getColumnReferences().stream().map(ColumnReference::getForeignKeyColumn).toList()));
    }

    private boolean isFkValid(TableReference fk) {
        boolean isNotValid = fk == null || MetaDataUtility.isPartial(this.table) || !fk.getForeignKeyTable().equals(this.table);
        return !isNotValid;
    }
}

