/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

public class NodeFactoryUtils {

    static final class BinaryToTernaryBuiltinNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        PythonTernaryBuiltinNode delegate;

        public BinaryToTernaryBuiltinNode(PythonTernaryBuiltinNode delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object execute(VirtualFrame frame, Object arg, Object arg2) {
            return this.delegate.execute(frame, arg, arg2, PNone.NO_VALUE);
        }

        public static <T extends PythonTernaryBuiltinNode> WrapperNodeFactory<BinaryToTernaryBuiltinNode, T> wrapFactory(NodeFactory<T> wrappedFactory) {
            return new WrapperNodeFactory<BinaryToTernaryBuiltinNode, PythonTernaryBuiltinNode>(wrappedFactory, BinaryToTernaryBuiltinNode.class, BinaryToTernaryBuiltinNode::new);
        }
    }

    public static final class WrapperNodeFactory<TWrapper, TWrapped>
    extends NodeFactoryBase<TWrapper> {
        private final NodeFactory<TWrapped> wrappedFactory;
        private final Class<TWrapper> nodeClass;
        private final WrapperFactory<TWrapper, TWrapped> wrapperFactory;

        public WrapperNodeFactory(NodeFactory<TWrapped> wrappedFactory, Class<TWrapper> nodeClass, WrapperFactory<TWrapper, TWrapped> wrapperFactory) {
            this.wrappedFactory = wrappedFactory;
            this.nodeClass = nodeClass;
            this.wrapperFactory = wrapperFactory;
        }

        public static <TWrapper, TWrapped> WrapperNodeFactory<TWrapper, TWrapped> wrap(NodeFactory<TWrapped> wrappedFactory, Class<TWrapper> nodeClass, WrapperFactory<TWrapper, TWrapped> wrapperFactory) {
            return new WrapperNodeFactory<TWrapper, TWrapped>(wrappedFactory, nodeClass, wrapperFactory);
        }

        @Override
        public Class<?> getWrappedNodeClass() {
            return this.wrappedFactory.getNodeClass();
        }

        public Class<TWrapper> getNodeClass() {
            return this.nodeClass;
        }

        @Override
        TWrapper create() {
            return this.wrapperFactory.create(this.wrappedFactory.createNode(new Object[0]));
        }
    }

    @FunctionalInterface
    public static interface WrapperFactory<TWrapper, TWrapped> {
        public TWrapper create(TWrapped var1);
    }

    public static abstract class NodeFactoryBase<T>
    implements NodeFactory<T> {
        public T createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return this.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        abstract T create();

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public Class<?> getWrappedNodeClass() {
            return this.getNodeClass();
        }

        public static <K> Class<?> getWrappedNodeClass(NodeFactory<K> factory) {
            if (factory instanceof NodeFactoryBase) {
                NodeFactoryBase nfb = (NodeFactoryBase)factory;
                return nfb.getWrappedNodeClass();
            }
            return factory.getNodeClass();
        }
    }
}

