/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.nfi.backend.libffi.AbstractNativePointer;

@GeneratedBy(value=AbstractNativePointer.class)
final class AbstractNativePointerGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private AbstractNativePointerGen() {
    }

    static {
        LibraryExport.register(AbstractNativePointer.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=AbstractNativePointer.class)
    static class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, AbstractNativePointer.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof AbstractNativePointer);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof AbstractNativePointer);
            return new Cached(receiver);
        }

        @GeneratedBy(value=AbstractNativePointer.class)
        static class Uncached
        extends InteropLibrary
        implements UnadoptableNode {
            private final Class<? extends AbstractNativePointer> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((AbstractNativePointer)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractNativePointer)receiver).isPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractNativePointer)receiver).asPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractNativePointer)receiver).isNull();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractNativePointer)receiver).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractNativePointer)receiver).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractNativePointer)receiver).toDisplayString(allowSideEffects);
            }
        }

        @GeneratedBy(value=AbstractNativePointer.class)
        static class Cached
        extends InteropLibrary {
            private final Class<? extends AbstractNativePointer> receiverClass_;

            protected Cached(Object receiver) {
                AbstractNativePointer castReceiver = (AbstractNativePointer)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractNativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isPointer();
            }

            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractNativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).asPointer();
            }

            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractNativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isNull();
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractNativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractNativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractNativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).toDisplayString(allowSideEffects);
            }
        }
    }
}

