/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConverterUtils {
    private ConverterUtils() {
    }

    public static void validateDouble(Double input) {
        Validate.isTrue((!Double.isNaN(input) ? 1 : 0) != 0, (String)"NaN is not supported by the default converters.", (Object[])new Object[0]);
        Validate.isTrue((boolean)Double.isFinite(input), (String)"Infinite numbers are not supported by the default converters.", (Object[])new Object[0]);
    }

    public static void validateFloat(Float input) {
        Validate.isTrue((!Float.isNaN(input.floatValue()) ? 1 : 0) != 0, (String)"NaN is not supported by the default converters.", (Object[])new Object[0]);
        Validate.isTrue((boolean)Float.isFinite(input.floatValue()), (String)"Infinite numbers are not supported by the default converters.", (Object[])new Object[0]);
    }

    public static String padLeft(int paddingAmount, int valueToPad) {
        String result;
        String value = Integer.toString(valueToPad);
        if (value.length() == paddingAmount) {
            result = value;
        } else {
            int padding = paddingAmount - value.length();
            StringBuilder sb = new StringBuilder(paddingAmount);
            for (int i = 0; i < padding; ++i) {
                sb.append('0');
            }
            result = sb.append(value).toString();
        }
        return result;
    }

    public static String[] splitNumberOnDecimal(String valueToSplit) {
        int i = valueToSplit.indexOf(46);
        if (i == -1) {
            return new String[]{valueToSplit, "0"};
        }
        return new String[]{valueToSplit.substring(0, i), valueToSplit.substring(i + 1)};
    }

    public static LocalDateTime convertFromLocalDate(LocalDate localDate) {
        return LocalDateTime.of(localDate, LocalTime.MIDNIGHT);
    }
}

