/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.ml;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.Nullable;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLAgentType;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.QuestionAnsweringInputDataSet;
import org.opensearch.ml.common.dataset.TextDocsInputDataSet;
import org.opensearch.ml.common.dataset.TextSimilarityInputDataSet;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.input.execute.agent.AgentMLInput;
import org.opensearch.ml.common.input.parameter.MLAlgoParams;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.output.model.ModelResultFilter;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.neuralsearch.ml.dto.AgentExecutionDTO;
import org.opensearch.neuralsearch.ml.dto.AgentInfoDTO;
import org.opensearch.neuralsearch.processor.InferenceRequest;
import org.opensearch.neuralsearch.processor.MapInferenceRequest;
import org.opensearch.neuralsearch.processor.SimilarityInferenceRequest;
import org.opensearch.neuralsearch.processor.TextInferenceRequest;
import org.opensearch.neuralsearch.processor.highlight.SentenceHighlightingRequest;
import org.opensearch.neuralsearch.query.AgenticSearchQueryBuilder;
import org.opensearch.neuralsearch.util.RetryUtil;

public class MLCommonsClientAccessor {
    @Generated
    private static final Logger log = LogManager.getLogger(MLCommonsClientAccessor.class);
    private final MachineLearningNodeClient mlClient;
    private static final Gson gson = new Gson();

    public void inferenceSentence(@NonNull String modelId, @NonNull String inputText, @NonNull ActionListener<List<Number>> listener) {
        Objects.requireNonNull(modelId, "modelId is marked non-null but is null");
        Objects.requireNonNull(inputText, "inputText is marked non-null but is null");
        Objects.requireNonNull(listener, "listener is marked non-null but is null");
        this.inferenceSentences((TextInferenceRequest)((TextInferenceRequest.TextInferenceRequestBuilder)((TextInferenceRequest.TextInferenceRequestBuilder)TextInferenceRequest.builder().modelId(modelId)).inputTexts(List.of(inputText))).build(), (ActionListener<List<List<Number>>>)ActionListener.wrap(response -> {
            if (response.size() != 1) {
                listener.onFailure((Exception)new IllegalStateException("Unexpected number of vectors produced. Expected 1 vector to be returned, but got [" + response.size() + "]"));
                return;
            }
            listener.onResponse((Object)((List)response.getFirst()));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void inferenceSentences(@NonNull TextInferenceRequest inferenceRequest, @NonNull ActionListener<List<List<Number>>> listener) {
        Objects.requireNonNull(inferenceRequest, "inferenceRequest is marked non-null but is null");
        Objects.requireNonNull(listener, "listener is marked non-null but is null");
        this.retryableInference(inferenceRequest, 0, () -> this.createMLTextInput(inferenceRequest.getTargetResponseFilters(), inferenceRequest.getInputTexts()), this::buildVectorFromResponse, listener);
    }

    public void inferenceSentencesWithMapResult(@NonNull TextInferenceRequest inferenceRequest, @Nullable MLAlgoParams mlAlgoParams, @NonNull ActionListener<List<Map<String, ?>>> listener) {
        Objects.requireNonNull(inferenceRequest, "inferenceRequest is marked non-null but is null");
        Objects.requireNonNull(listener, "listener is marked non-null but is null");
        this.retryableInference(inferenceRequest, 0, () -> {
            MLInput input = this.createMLTextInput(null, inferenceRequest.getInputTexts());
            if (mlAlgoParams != null) {
                input.setParameters(mlAlgoParams);
            }
            return input;
        }, this::buildMapResultFromResponse, listener);
    }

    public void inferenceSentencesMap(@NonNull MapInferenceRequest inferenceRequest, @NonNull ActionListener<List<Number>> listener) {
        Objects.requireNonNull(inferenceRequest, "inferenceRequest is marked non-null but is null");
        Objects.requireNonNull(listener, "listener is marked non-null but is null");
        this.retryableInference(inferenceRequest, 0, () -> this.createMLMultimodalInput(inferenceRequest.getTargetResponseFilters(), inferenceRequest.getInputObjects()), this::buildSingleVectorFromResponse, listener);
    }

    public void inferenceSimilarity(@NonNull SimilarityInferenceRequest inferenceRequest, @NonNull ActionListener<List<Float>> listener) {
        Objects.requireNonNull(inferenceRequest, "inferenceRequest is marked non-null but is null");
        Objects.requireNonNull(listener, "listener is marked non-null but is null");
        this.retryableInference(inferenceRequest, 0, () -> this.createMLTextPairsInput(inferenceRequest.getQueryText(), inferenceRequest.getInputTexts()), mlOutput -> this.buildVectorFromResponse((MLOutput)mlOutput).stream().map(v -> Float.valueOf(((Number)v.getFirst()).floatValue())).collect(Collectors.toList()), listener);
    }

    private <T> void retryableInference(InferenceRequest inferenceRequest, int retryTime, Supplier<MLInput> mlInputSupplier, Function<MLOutput, T> mlOutputBuilder, ActionListener<T> listener) {
        MLInput mlInput = mlInputSupplier.get();
        this.mlClient.predict(inferenceRequest.getModelId(), mlInput, ActionListener.wrap(mlOutput -> {
            Object result = mlOutputBuilder.apply((MLOutput)mlOutput);
            listener.onResponse(result);
        }, e -> RetryUtil.handleRetryOrFailure(e, retryTime, () -> this.lambda$retryableInference$8(inferenceRequest, retryTime, (Supplier)mlInputSupplier, mlOutputBuilder, listener), listener)));
    }

    private MLInput createMLTextInput(List<String> targetResponseFilters, List<String> inputText) {
        ModelResultFilter modelResultFilter = new ModelResultFilter(false, true, targetResponseFilters, null);
        TextDocsInputDataSet inputDataset = new TextDocsInputDataSet(inputText, modelResultFilter);
        return new MLInput(FunctionName.TEXT_EMBEDDING, null, (MLInputDataset)inputDataset);
    }

    private MLInput createMLTextPairsInput(String query, List<String> inputText) {
        TextSimilarityInputDataSet inputDataset = new TextSimilarityInputDataSet(query, inputText);
        return new MLInput(FunctionName.TEXT_SIMILARITY, null, (MLInputDataset)inputDataset);
    }

    private <T extends Number> List<List<T>> buildVectorFromResponse(MLOutput mlOutput) {
        ArrayList<List<T>> vector = new ArrayList<List<T>>();
        ModelTensorOutput modelTensorOutput = (ModelTensorOutput)mlOutput;
        List tensorOutputList = modelTensorOutput.getMlModelOutputs();
        for (ModelTensors tensors : tensorOutputList) {
            List tensorsList = tensors.getMlModelTensors();
            for (ModelTensor tensor : tensorsList) {
                vector.add(Arrays.stream(tensor.getData()).map(value -> value).collect(Collectors.toList()));
            }
        }
        return vector;
    }

    private List<Map<String, ?>> buildMapResultFromResponse(MLOutput mlOutput) {
        ModelTensorOutput modelTensorOutput = (ModelTensorOutput)mlOutput;
        List tensorOutputList = modelTensorOutput.getMlModelOutputs();
        if (CollectionUtils.isEmpty((Collection)tensorOutputList) || CollectionUtils.isEmpty((Collection)((ModelTensors)tensorOutputList.get(0)).getMlModelTensors())) {
            throw new IllegalStateException("Empty model result produced. Expected at least [1] tensor output and [1] model tensor, but got [0]");
        }
        ArrayList resultMaps = new ArrayList();
        for (ModelTensors tensors : tensorOutputList) {
            List tensorList = tensors.getMlModelTensors();
            for (ModelTensor tensor : tensorList) {
                resultMaps.add(tensor.getDataAsMap());
            }
        }
        return resultMaps;
    }

    private String buildQueryResultFromResponseOfOutput(MLOutput mlOutput) {
        if (!(mlOutput instanceof ModelTensorOutput)) {
            throw new IllegalStateException("Expected ModelTensorOutput but got: " + mlOutput.getClass().getSimpleName());
        }
        ModelTensorOutput modelTensorOutput = (ModelTensorOutput)mlOutput;
        List tensorOutputList = modelTensorOutput.getMlModelOutputs();
        if (CollectionUtils.isEmpty((Collection)tensorOutputList)) {
            throw new IllegalStateException("Empty model result produced. Expected at least [1] tensor output, but got [0]");
        }
        for (ModelTensors tensors : tensorOutputList) {
            List tensorList = tensors.getMlModelTensors();
            if (CollectionUtils.isEmpty((Collection)tensorList)) continue;
            for (ModelTensor tensor : tensorList) {
                String result = tensor.getResult();
                if (result == null || result.trim().isEmpty()) continue;
                return result;
            }
        }
        throw new IllegalStateException("No valid DSL result found in model output");
    }

    private <T extends Number> List<T> buildSingleVectorFromResponse(MLOutput mlOutput) {
        List<List<T>> vector = this.buildVectorFromResponse(mlOutput);
        return vector.isEmpty() ? new ArrayList() : vector.get(0);
    }

    private List<Map<String, Object>> processHighlightingOutput(ModelTensorOutput modelTensorOutput) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        try {
            List tensorOutputList = modelTensorOutput.getMlModelOutputs();
            if (CollectionUtils.isEmpty((Collection)tensorOutputList)) {
                return results;
            }
            for (ModelTensors tensors : tensorOutputList) {
                List tensorsList = tensors.getMlModelTensors();
                if (CollectionUtils.isEmpty((Collection)tensorsList)) {
                    log.warn("No tensors in model output");
                    continue;
                }
                for (ModelTensor tensor : tensorsList) {
                    Map dataMap = tensor.getDataAsMap();
                    if (dataMap == null || dataMap.isEmpty()) continue;
                    Map typedDataMap = dataMap;
                    results.add(typedDataMap);
                }
            }
            if (results.isEmpty()) {
                results.add(Collections.emptyMap());
            }
            return results;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error processing sentence highlighting output", e);
        }
    }

    private MLInput createMLMultimodalInput(List<String> targetResponseFilters, Map<String, String> input) {
        ArrayList<String> inputText = new ArrayList<String>();
        inputText.add(input.get("inputText"));
        if (input.containsKey("inputImage")) {
            inputText.add(input.get("inputImage"));
        }
        ModelResultFilter modelResultFilter = new ModelResultFilter(false, true, targetResponseFilters, null);
        TextDocsInputDataSet inputDataset = new TextDocsInputDataSet(inputText, modelResultFilter);
        return new MLInput(FunctionName.TEXT_EMBEDDING, null, (MLInputDataset)inputDataset);
    }

    public void getModel(@NonNull String modelId, @NonNull ActionListener<MLModel> listener) {
        Objects.requireNonNull(modelId, "modelId is marked non-null but is null");
        Objects.requireNonNull(listener, "listener is marked non-null but is null");
        this.retryableGetModel(modelId, 0, listener);
    }

    public void getModels(@NonNull Set<String> modelIds, @NonNull Consumer<Map<String, MLModel>> onSuccess, @NonNull Consumer<Exception> onFailure) {
        Objects.requireNonNull(modelIds, "modelIds is marked non-null but is null");
        Objects.requireNonNull(onSuccess, "onSuccess is marked non-null but is null");
        Objects.requireNonNull(onFailure, "onFailure is marked non-null but is null");
        if (modelIds.isEmpty()) {
            try {
                onSuccess.accept(Collections.emptyMap());
            }
            catch (Exception e2) {
                onFailure.accept(e2);
            }
            return;
        }
        ConcurrentHashMap modelMap = new ConcurrentHashMap();
        AtomicInteger counter = new AtomicInteger(modelIds.size());
        AtomicBoolean hasError = new AtomicBoolean(false);
        List<String> errors = Collections.synchronizedList(new ArrayList());
        for (String modelId : modelIds) {
            try {
                this.getModel(modelId, (ActionListener<MLModel>)ActionListener.wrap(model -> {
                    modelMap.put(modelId, model);
                    if (counter.decrementAndGet() == 0) {
                        if (hasError.get()) {
                            onFailure.accept(new RuntimeException(String.join((CharSequence)";", errors)));
                        } else {
                            try {
                                onSuccess.accept(modelMap);
                            }
                            catch (Exception e) {
                                onFailure.accept(e);
                            }
                        }
                    }
                }, e -> this.handleGetModelException(hasError, errors, modelId, (Exception)e, counter, onFailure)));
            }
            catch (Exception e3) {
                this.handleGetModelException(hasError, errors, modelId, e3, counter, onFailure);
            }
        }
    }

    private void handleGetModelException(AtomicBoolean hasError, List<String> errors, String modelId, Exception e, AtomicInteger counter, @NonNull Consumer<Exception> onFailure) {
        Objects.requireNonNull(onFailure, "onFailure is marked non-null but is null");
        hasError.set(true);
        errors.add("Failed to fetch model [" + modelId + "]: " + e.getMessage());
        if (counter.decrementAndGet() == 0) {
            onFailure.accept(new RuntimeException(String.join((CharSequence)";", errors)));
        }
    }

    private void retryableGetModel(@NonNull String modelId, int retryTime, @NonNull ActionListener<MLModel> listener) {
        Objects.requireNonNull(modelId, "modelId is marked non-null but is null");
        Objects.requireNonNull(listener, "listener is marked non-null but is null");
        this.mlClient.getModel(modelId, null, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> RetryUtil.handleRetryOrFailure(e, retryTime, () -> this.retryableGetModel(modelId, retryTime + 1, listener), listener)));
    }

    public void batchInferenceSentenceHighlighting(final @NonNull String modelId, @NonNull List<SentenceHighlightingRequest> batchRequests, @NonNull FunctionName modelType, @NonNull ActionListener<List<List<Map<String, Object>>>> listener) {
        Objects.requireNonNull(modelId, "modelId is marked non-null but is null");
        Objects.requireNonNull(batchRequests, "batchRequests is marked non-null but is null");
        Objects.requireNonNull(modelType, "modelType is marked non-null but is null");
        Objects.requireNonNull(listener, "listener is marked non-null but is null");
        if (modelType != FunctionName.REMOTE) {
            listener.onFailure((Exception)new IllegalArgumentException(String.format(Locale.ROOT, "Model [%s] with type [%s] does not support batch inference. Batch inference is only supported for REMOTE models. Please set 'batch_inference' to false or use a remote model.", modelId, modelType)));
            return;
        }
        InferenceRequest inferenceRequest = new InferenceRequest(this){

            @Override
            public String getModelId() {
                return modelId;
            }
        };
        this.retryableInference(inferenceRequest, 0, () -> this.createBatchHighlightingMLInput(batchRequests), this::parseBatchHighlightingOutput, listener);
    }

    private MLInput createBatchHighlightingMLInput(List<SentenceHighlightingRequest> batchRequests) {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startArray();
            for (SentenceHighlightingRequest request : batchRequests) {
                builder.startObject().field("question", request.getQuestion()).field("context", request.getContext()).endObject();
            }
            builder.endArray();
            parameters.put("inputs", builder.toString());
            RemoteInferenceInputDataSet inputDataset = new RemoteInferenceInputDataSet(parameters);
            return MLInput.builder().algorithm(FunctionName.REMOTE).inputDataset((MLInputDataset)inputDataset).build();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create batch highlighting ML input", e);
        }
    }

    public void inferenceSentenceHighlighting(@NonNull SentenceHighlightingRequest inferenceRequest, @NonNull ActionListener<List<Map<String, Object>>> listener) {
        Objects.requireNonNull(inferenceRequest, "inferenceRequest is marked non-null but is null");
        Objects.requireNonNull(listener, "listener is marked non-null but is null");
        this.inferenceSentenceHighlighting(inferenceRequest, FunctionName.QUESTION_ANSWERING, listener);
    }

    public void inferenceSentenceHighlighting(@NonNull SentenceHighlightingRequest inferenceRequest, @NonNull FunctionName modelType, @NonNull ActionListener<List<Map<String, Object>>> listener) {
        Objects.requireNonNull(inferenceRequest, "inferenceRequest is marked non-null but is null");
        Objects.requireNonNull(modelType, "modelType is marked non-null but is null");
        Objects.requireNonNull(listener, "listener is marked non-null but is null");
        if (modelType == FunctionName.QUESTION_ANSWERING) {
            this.retryableInference(inferenceRequest, 0, () -> this.createLocalHighlightingMLInput(inferenceRequest), mlOutput -> this.parseSingleHighlightingOutput((MLOutput)mlOutput), listener);
        } else if (modelType == FunctionName.REMOTE) {
            this.retryableInference(inferenceRequest, 0, () -> this.createRemoteHighlightingMLInput(inferenceRequest), mlOutput -> this.parseSingleHighlightingOutput((MLOutput)mlOutput), listener);
        } else {
            listener.onFailure((Exception)new IllegalArgumentException("Unsupported model type for highlighting: " + String.valueOf(modelType)));
        }
    }

    private MLInput createLocalHighlightingMLInput(SentenceHighlightingRequest inferenceRequest) {
        try {
            QuestionAnsweringInputDataSet inputDataset = new QuestionAnsweringInputDataSet(inferenceRequest.getQuestion(), inferenceRequest.getContext());
            return new MLInput(FunctionName.QUESTION_ANSWERING, null, (MLInputDataset)inputDataset);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create local highlighting ML input", e);
        }
    }

    private MLInput createRemoteHighlightingMLInput(SentenceHighlightingRequest inferenceRequest) {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startArray();
            builder.startObject().field("question", inferenceRequest.getQuestion()).field("context", inferenceRequest.getContext()).endObject();
            builder.endArray();
            parameters.put("inputs", builder.toString());
            RemoteInferenceInputDataSet inputDataset = new RemoteInferenceInputDataSet(parameters);
            return MLInput.builder().algorithm(FunctionName.REMOTE).inputDataset((MLInputDataset)inputDataset).build();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create remote highlighting ML input", e);
        }
    }

    private List<Map<String, Object>> parseSingleHighlightingOutput(MLOutput mlOutput) {
        List highlightsList;
        if (!(mlOutput instanceof ModelTensorOutput)) {
            throw new IllegalStateException("Expected ModelTensorOutput but got: " + mlOutput.getClass().getSimpleName());
        }
        ModelTensorOutput modelTensorOutput = (ModelTensorOutput)mlOutput;
        List tensorsList = modelTensorOutput.getMlModelOutputs();
        if (tensorsList.isEmpty() || ((ModelTensors)tensorsList.get(0)).getMlModelTensors().isEmpty()) {
            return List.of(Map.of("highlights", Collections.emptyList()));
        }
        Map dataMap = ((ModelTensor)((ModelTensors)tensorsList.get(0)).getMlModelTensors().get(0)).getDataAsMap();
        Object highlightsObj = dataMap.get("highlights");
        if (highlightsObj == null) {
            return List.of(Map.of("highlights", Collections.emptyList()));
        }
        if (highlightsObj instanceof List && !(highlightsList = (List)highlightsObj).isEmpty()) {
            List<List<Map<String, Object>>> batchResults;
            Object firstItem = highlightsList.get(0);
            if (firstItem instanceof Map) {
                Map resultMap = dataMap;
                return List.of(resultMap);
            }
            if (firstItem instanceof List && (batchResults = this.parseBatchHighlightingOutput(mlOutput)) != null && !batchResults.isEmpty() && batchResults.get(0) != null) {
                return List.of(Map.of("highlights", batchResults.get(0)));
            }
        }
        return List.of(Map.of("highlights", Collections.emptyList()));
    }

    public void getAgentDetails(@NonNull String agentId, @NonNull ActionListener<AgentInfoDTO> listener) {
        Objects.requireNonNull(agentId, "agentId is marked non-null but is null");
        Objects.requireNonNull(listener, "listener is marked non-null but is null");
        this.retryableGetAgentDetails(agentId, 0, listener);
    }

    private void retryableGetAgentDetails(String agentId, int retryTime, ActionListener<AgentInfoDTO> listener) {
        this.mlClient.getAgent(agentId, ActionListener.wrap(mlAgent -> {
            if (mlAgent == null) {
                listener.onFailure((Exception)new IllegalStateException("Agent not found"));
                return;
            }
            boolean hasSystemPrompt = false;
            boolean hasUserPrompt = false;
            if (mlAgent.getMlAgent().getLlm() != null && mlAgent.getMlAgent().getLlm().getParameters() != null) {
                Map parameters = mlAgent.getMlAgent().getLlm().getParameters();
                hasSystemPrompt = parameters.containsKey("system_prompt");
                hasUserPrompt = parameters.containsKey("user_prompt");
            }
            AgentInfoDTO agentInfoDTO = new AgentInfoDTO(mlAgent.getMlAgent().getType(), hasSystemPrompt, hasUserPrompt);
            listener.onResponse((Object)agentInfoDTO);
        }, e -> RetryUtil.handleRetryOrFailure(e, retryTime, () -> this.retryableGetAgentDetails(agentId, retryTime + 1, listener), listener)));
    }

    public void executeAgent(@NonNull SearchRequest request, @NonNull AgenticSearchQueryBuilder agenticQuery, @NonNull String agentId, @NonNull AgentInfoDTO agentInfo, @NonNull NamedXContentRegistry xContentRegistry, @NonNull ActionListener<AgentExecutionDTO> listener) throws IOException {
        Objects.requireNonNull(request, "request is marked non-null but is null");
        Objects.requireNonNull(agenticQuery, "agenticQuery is marked non-null but is null");
        Objects.requireNonNull(agentId, "agentId is marked non-null but is null");
        Objects.requireNonNull(agentInfo, "agentInfo is marked non-null but is null");
        Objects.requireNonNull(xContentRegistry, "xContentRegistry is marked non-null but is null");
        Objects.requireNonNull(listener, "listener is marked non-null but is null");
        this.retryableExecuteAgent(request, agenticQuery, agentId, agentInfo, xContentRegistry, 0, listener);
    }

    private void retryableExecuteAgent(SearchRequest request, AgenticSearchQueryBuilder agenticQuery, String agentId, AgentInfoDTO agentInfo, NamedXContentRegistry xContentRegistry, int retryTime, ActionListener<AgentExecutionDTO> listener) throws IOException {
        Object[] indices;
        MLAgentType type;
        String agentType = agentInfo.getType();
        boolean hasSystemPrompt = agentInfo.isHasSystemPrompt();
        boolean hasUserPrompt = agentInfo.isHasUserPrompt();
        try {
            type = MLAgentType.from((String)agentType);
        }
        catch (IllegalArgumentException e2) {
            listener.onFailure((Exception)new IllegalArgumentException("Unsupported agent type: " + agentType));
            return;
        }
        if (type == MLAgentType.FLOW && agenticQuery.getMemoryId() != null) {
            throw new IllegalArgumentException("Flow agent does not support memory_id");
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("question", agenticQuery.getQueryText());
        if (agenticQuery.getMemoryId() != null) {
            parameters.put("memory_id", agenticQuery.getMemoryId());
        }
        if ((indices = request.indices()) != null && indices.length > 0) {
            if (type == MLAgentType.FLOW && indices.length > 1) {
                throw new IllegalArgumentException("Flow agent does not support multiple indices");
            }
            parameters.put("index_name", type == MLAgentType.FLOW ? indices[0] : Arrays.toString(indices));
        }
        if (agenticQuery.getQueryFields() != null && !agenticQuery.getQueryFields().isEmpty()) {
            parameters.put("query_fields", gson.toJson(agenticQuery.getQueryFields()));
        }
        if (!hasSystemPrompt && type != MLAgentType.FLOW) {
            parameters.put("system_prompt", this.loadSystemPrompt());
        }
        if (!hasUserPrompt && type != MLAgentType.FLOW) {
            parameters.put("user_prompt", this.loadUserPrompt());
        }
        RemoteInferenceInputDataSet dataset = RemoteInferenceInputDataSet.builder().parameters(parameters).build();
        AgentMLInput agentMLInput = new AgentMLInput(agentId, null, FunctionName.AGENT, (MLInputDataset)dataset);
        if (type != MLAgentType.FLOW && type != MLAgentType.CONVERSATIONAL) {
            listener.onFailure((Exception)new IllegalArgumentException("Unsupported agent type: " + agentType));
            return;
        }
        this.mlClient.execute(FunctionName.AGENT, (Input)agentMLInput, ActionListener.wrap(response -> {
            MLOutput mlOutput = (MLOutput)response.getOutput();
            String dslQuery = null;
            String agentStepsSummary = null;
            String memoryId = null;
            if (type == MLAgentType.FLOW) {
                dslQuery = this.extractFlowAgentResult(mlOutput);
            } else if (type == MLAgentType.CONVERSATIONAL) {
                Map<String, String> conversationalResult = this.extractConversationalAgentResult(mlOutput, xContentRegistry);
                dslQuery = conversationalResult.get("dsl_query");
                agentStepsSummary = conversationalResult.get("agent_steps_summary");
                memoryId = conversationalResult.get("memory_id");
            }
            listener.onResponse((Object)new AgentExecutionDTO(this.removeTrailingDecimalZeros(dslQuery), agentStepsSummary, memoryId));
        }, e -> RetryUtil.handleRetryOrFailure(e, retryTime, () -> {
            try {
                this.retryableExecuteAgent(request, agenticQuery, agentId, agentInfo, xContentRegistry, retryTime + 1, listener);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }, listener)));
    }

    private String removeTrailingDecimalZeros(String query) {
        if (query == null || query.isBlank()) {
            return query;
        }
        Pattern TRAILING_ZEROS_PATTERN = Pattern.compile("(?<![0-9A-Za-z.])(-?\\d+)\\.0+(?![0-9Ee.])");
        return TRAILING_ZEROS_PATTERN.matcher(query).replaceAll("$1");
    }

    private String extractFlowAgentResult(MLOutput mlOutput) {
        if (!(mlOutput instanceof ModelTensorOutput)) {
            throw new IllegalStateException("Expected ModelTensorOutput but got: " + mlOutput.getClass().getSimpleName());
        }
        ModelTensorOutput modelTensorOutput = (ModelTensorOutput)mlOutput;
        List tensorOutputList = modelTensorOutput.getMlModelOutputs();
        if (CollectionUtils.isEmpty((Collection)tensorOutputList)) {
            throw new IllegalStateException("Empty model result produced. Expected at least [1] tensor output, but got [0]");
        }
        for (ModelTensors tensors : tensorOutputList) {
            List tensorList = tensors.getMlModelTensors();
            if (CollectionUtils.isEmpty((Collection)tensorList)) continue;
            for (ModelTensor tensor : tensorList) {
                String result = tensor.getResult();
                if (result == null || result.trim().isEmpty()) continue;
                return result;
            }
        }
        throw new IllegalStateException("No valid DSL result found in model output");
    }

    private Map<String, String> extractConversationalAgentResult(MLOutput mlOutput, NamedXContentRegistry xContentRegistry) {
        if (!(mlOutput instanceof ModelTensorOutput)) {
            throw new IllegalStateException("Expected ModelTensorOutput but got: " + mlOutput.getClass().getSimpleName());
        }
        ModelTensorOutput modelTensorOutput = (ModelTensorOutput)mlOutput;
        List tensorOutputList = modelTensorOutput.getMlModelOutputs();
        if (CollectionUtils.isEmpty((Collection)tensorOutputList)) {
            throw new IllegalStateException("Empty model result produced. Expected at least [1] tensor output, but got [0]");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (ModelTensors tensors : tensorOutputList) {
            List tensorList = tensors.getMlModelTensors();
            if (CollectionUtils.isEmpty((Collection)tensorList)) continue;
            for (ModelTensor tensor : tensorList) {
                String responseJsonString;
                Object responseObj;
                Map dataMap;
                String tensorName = tensor.getName();
                if ("memory_id".equals(tensorName)) {
                    String memoryId = tensor.getResult();
                    if (memoryId == null || memoryId.trim().isEmpty()) continue;
                    result.put("memory_id", memoryId);
                    continue;
                }
                if (!"response".equals(tensorName) || (dataMap = tensor.getDataAsMap()) == null || !dataMap.containsKey("response") || !((responseObj = dataMap.get("response")) instanceof String) || (responseJsonString = (String)responseObj).isBlank()) continue;
                try {
                    XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, null, (InputStream)new BytesArray(responseJsonString).streamInput());
                    try {
                        if (parser.currentToken() == null) {
                            parser.nextToken();
                        }
                        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                            throw new IllegalStateException("Expected START_OBJECT in response, but got: " + String.valueOf(parser.currentToken()));
                        }
                        Map responseMap = parser.map();
                        Object dslQueryObj = responseMap.get("dsl_query");
                        Object stepsSummaryObj = responseMap.get("agent_steps_summary");
                        if (dslQueryObj != null) {
                            try {
                                String dslJson = gson.toJson(dslQueryObj);
                                result.put("dsl_query", dslJson);
                            }
                            catch (Exception e) {
                                throw new IllegalStateException("Failed to serialize dsl_query to JSON", e);
                            }
                        }
                        if (stepsSummaryObj == null) continue;
                        result.put("agent_steps_summary", stepsSummaryObj.toString());
                    }
                    finally {
                        if (parser == null) continue;
                        parser.close();
                    }
                }
                catch (IOException e) {
                    log.error("Failed to parse agent response JSON: {}", (Object)responseJsonString, (Object)e);
                    throw new IllegalStateException("Failed to parse agent response using XContentParser: " + e.getMessage(), e);
                }
            }
        }
        if (!result.containsKey("dsl_query")) {
            throw new IllegalStateException("No valid 'dsl_query' found in conversational agent response");
        }
        return result;
    }

    private String loadSystemPrompt() throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("agentic-system-prompt.txt");
        return new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
    }

    private String loadUserPrompt() throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("agentic-user-prompt.txt");
        return new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
    }

    private List<List<Map<String, Object>>> parseBatchHighlightingOutput(MLOutput mlOutput) {
        List<Map<String, ?>> tensorMaps;
        ArrayList<List<Map<String, Object>>> results = new ArrayList<List<Map<String, Object>>>();
        if (mlOutput == null) {
            log.error("ML output is null in batch highlighting parsing");
            throw new IllegalStateException("ML output cannot be null");
        }
        try {
            tensorMaps = this.buildMapResultFromResponse(mlOutput);
        }
        catch (IllegalStateException e) {
            log.warn("No valid tensor output in batch highlighting response: {}", (Object)e.getMessage());
            return results;
        }
        for (Map<String, ?> dataMap : tensorMaps) {
            if (dataMap == null) {
                log.warn("Null data map in tensor, adding empty result");
                results.add(new ArrayList());
                continue;
            }
            Object highlightsObj = dataMap.get("highlights");
            if (highlightsObj == null) {
                results.add(new ArrayList());
                continue;
            }
            if (!(highlightsObj instanceof List)) {
                log.error("Invalid highlights type: expected List, got: {}", (Object)highlightsObj.getClass().getSimpleName());
                throw new IllegalStateException("Expected highlights to be a List, but got: " + highlightsObj.getClass().getSimpleName());
            }
            List highlightsList = (List)highlightsObj;
            if (highlightsList.isEmpty()) {
                results.add(new ArrayList());
                continue;
            }
            Object firstElement = highlightsList.get(0);
            if (firstElement == null) {
                results.add(new ArrayList());
                continue;
            }
            if (firstElement instanceof List) {
                for (Object docHighlights : highlightsList) {
                    results.add(this.processDocumentHighlights(docHighlights));
                }
                continue;
            }
            if (firstElement instanceof Map) {
                results.add(this.processDocumentHighlights(highlightsList));
                continue;
            }
            log.error("Invalid highlights structure: expected list of lists or list of maps, got list of: {}", (Object)firstElement.getClass().getSimpleName());
            throw new IllegalStateException("Expected highlights to be a list of lists or list of maps, but got list of: " + firstElement.getClass().getSimpleName());
        }
        return results;
    }

    private List<Map<String, Object>> processDocumentHighlights(Object docHighlights) {
        ArrayList<Map<String, Object>> highlights = new ArrayList<Map<String, Object>>();
        if (docHighlights == null) {
            return highlights;
        }
        if (!(docHighlights instanceof List)) {
            log.error("Invalid document highlights type: expected List, got: {}", (Object)docHighlights.getClass().getSimpleName());
            throw new IllegalStateException("Expected document highlights to be a List, but got: " + docHighlights.getClass().getSimpleName());
        }
        List highlightList = (List)docHighlights;
        for (Object item : highlightList) {
            if (item == null) continue;
            if (!(item instanceof Map)) {
                log.error("Invalid highlight item type: expected Map, got: {}", (Object)item.getClass().getSimpleName());
                throw new IllegalStateException("Expected highlight item to be a Map, but got: " + item.getClass().getSimpleName());
            }
            Map highlight = (Map)item;
            if (!highlight.containsKey("start") || !highlight.containsKey("end")) {
                log.warn("Highlight missing required fields (start/end), skipping: {}", (Object)highlight);
                continue;
            }
            highlights.add(highlight);
        }
        return highlights;
    }

    @Generated
    public MLCommonsClientAccessor(MachineLearningNodeClient mlClient) {
        this.mlClient = mlClient;
    }

    private /* synthetic */ void lambda$retryableInference$8(InferenceRequest inferenceRequest, int retryTime, Supplier mlInputSupplier, Function mlOutputBuilder, ActionListener listener) {
        this.retryableInference(inferenceRequest, retryTime + 1, mlInputSupplier, mlOutputBuilder, listener);
    }
}

