/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.GeoShapeRelation;
import org.opensearch.client.opensearch._types.query_dsl.FieldLookup;
import org.opensearch.client.opensearch._types.query_dsl.GeoShape;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GeoShapeQueryField
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, GeoShapeQueryField> {
    @Nullable
    private final FieldLookup indexedShape;
    @Nullable
    private final GeoShapeRelation relation;
    @Nonnull
    private final GeoShape shape;
    public static final JsonpDeserializer<GeoShapeQueryField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoShapeQueryField::setupGeoShapeQueryFieldDeserializer);

    private GeoShapeQueryField(Builder builder) {
        this.indexedShape = builder.indexedShape;
        this.relation = builder.relation;
        this.shape = ApiTypeHelper.requireNonNull(builder.shape, this, "shape");
    }

    public static GeoShapeQueryField of(Function<Builder, ObjectBuilder<GeoShapeQueryField>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final FieldLookup indexedShape() {
        return this.indexedShape;
    }

    @Nullable
    public final GeoShapeRelation relation() {
        return this.relation;
    }

    @Nonnull
    public final GeoShape shape() {
        return this.shape;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.indexedShape != null) {
            generator.writeKey("indexed_shape");
            this.indexedShape.serialize(generator, mapper);
        }
        if (this.relation != null) {
            generator.writeKey("relation");
            this.relation.serialize(generator, mapper);
        }
        generator.writeKey("shape");
        this.shape.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGeoShapeQueryFieldDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexedShape, FieldLookup._DESERIALIZER, "indexed_shape");
        op.add(Builder::relation, GeoShapeRelation._DESERIALIZER, "relation");
        op.add(Builder::shape, GeoShape._DESERIALIZER, "shape");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.indexedShape);
        result = 31 * result + Objects.hashCode(this.relation);
        result = 31 * result + this.shape.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoShapeQueryField other = (GeoShapeQueryField)o;
        return Objects.equals(this.indexedShape, other.indexedShape) && Objects.equals(this.relation, other.relation) && this.shape.equals(other.shape);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, GeoShapeQueryField> {
        @Nullable
        private FieldLookup indexedShape;
        @Nullable
        private GeoShapeRelation relation;
        private GeoShape shape;

        public Builder() {
        }

        private Builder(GeoShapeQueryField o) {
            this.indexedShape = o.indexedShape;
            this.relation = o.relation;
            this.shape = o.shape;
        }

        private Builder(Builder o) {
            this.indexedShape = o.indexedShape;
            this.relation = o.relation;
            this.shape = o.shape;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder indexedShape(@Nullable FieldLookup value) {
            this.indexedShape = value;
            return this;
        }

        @Nonnull
        public final Builder indexedShape(Function<FieldLookup.Builder, ObjectBuilder<FieldLookup>> fn) {
            return this.indexedShape(fn.apply(new FieldLookup.Builder()).build());
        }

        @Nonnull
        public final Builder relation(@Nullable GeoShapeRelation value) {
            this.relation = value;
            return this;
        }

        @Nonnull
        public final Builder shape(GeoShape value) {
            this.shape = value;
            return this;
        }

        @Nonnull
        public final Builder shape(Function<GeoShape.Builder, ObjectBuilder<GeoShape>> fn) {
            return this.shape(fn.apply(new GeoShape.Builder()).build());
        }

        @Override
        @Nonnull
        public GeoShapeQueryField build() {
            this._checkSingleUse();
            return new GeoShapeQueryField(this);
        }
    }
}

