/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.infotheory.example;

import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import com.oracle.labs.mlrg.olcut.config.UsageException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tribuo.util.infotheory.InformationTheory;
import org.tribuo.util.infotheory.impl.CachedTriple;

public class InformationTheoryDemo {
    private static final Logger logger = Logger.getLogger(InformationTheoryDemo.class.getName());
    private static final Random rng = new Random(1L);

    public static List<Integer> generateUniform(int length, int alphabetSize) {
        ArrayList<Integer> vector = new ArrayList<Integer>(length);
        for (int i = 0; i < length; ++i) {
            vector.add(i, rng.nextInt(alphabetSize));
        }
        return vector;
    }

    public static CachedTriple<List<Integer>, List<Integer>, List<Integer>> generateXOR(int length) {
        ArrayList<Integer> first = new ArrayList<Integer>(length);
        ArrayList<Integer> second = new ArrayList<Integer>(length);
        ArrayList<Integer> xor = new ArrayList<Integer>(length);
        for (int i = 0; i < length; ++i) {
            int firstVal = rng.nextInt(2);
            int secondVal = rng.nextInt(2);
            int xorVal = firstVal ^ secondVal;
            first.add(i, firstVal);
            second.add(i, secondVal);
            xor.add(i, xorVal);
        }
        return new CachedTriple<List<Integer>, List<Integer>, List<Integer>>(first, second, xor);
    }

    public static CachedTriple<List<Integer>, List<Integer>, List<Integer>> generateCorrelated(int length, int alphabetSize, double xyCorrelation, double xzCorrelation) {
        ArrayList<Integer> first = new ArrayList<Integer>(length);
        ArrayList<Integer> second = new ArrayList<Integer>(length);
        ArrayList<Integer> third = new ArrayList<Integer>(length);
        for (int i = 0; i < length; ++i) {
            int firstVal = rng.nextInt(alphabetSize);
            first.add(firstVal);
            double xyDraw = rng.nextDouble();
            if (xyDraw < xyCorrelation) {
                second.add(firstVal);
            } else {
                second.add(rng.nextInt(alphabetSize));
            }
            double xzDraw = rng.nextDouble();
            if (xzDraw < xzCorrelation) {
                third.add(firstVal);
                continue;
            }
            third.add(rng.nextInt(alphabetSize));
        }
        return new CachedTriple<List<Integer>, List<Integer>, List<Integer>>(first, second, third);
    }

    public static void main(String[] args) {
        List<Integer> z;
        List<Integer> y;
        List<Integer> x;
        DemoOptions options = new DemoOptions();
        try {
            ConfigurationManager configurationManager = new ConfigurationManager(args, (Options)options, false);
        }
        catch (UsageException e) {
            System.out.println(e.getUsage());
        }
        switch (options.type) {
            case RANDOM: {
                x = InformationTheoryDemo.generateUniform(1000, 5);
                y = InformationTheoryDemo.generateUniform(1000, 5);
                z = InformationTheoryDemo.generateUniform(1000, 5);
                break;
            }
            case XOR: {
                CachedTriple<List<Integer>, List<Integer>, List<Integer>> trip = InformationTheoryDemo.generateXOR(1000);
                x = trip.getA();
                y = trip.getB();
                z = trip.getC();
                break;
            }
            case CORRELATED: {
                CachedTriple<List<Integer>, List<Integer>, List<Integer>> tripC = InformationTheoryDemo.generateCorrelated(1000, 5, 0.7, 0.5);
                x = tripC.getA();
                y = tripC.getB();
                z = tripC.getC();
                break;
            }
            default: {
                logger.log(Level.WARNING, "Unknown test case, exiting");
                return;
            }
        }
        double hx = InformationTheory.entropy(x);
        double hy = InformationTheory.entropy(y);
        double hz = InformationTheory.entropy(z);
        double hxy = InformationTheory.jointEntropy(x, y);
        double hxz = InformationTheory.jointEntropy(x, z);
        double hyz = InformationTheory.jointEntropy(y, z);
        double ixy = InformationTheory.mi(x, y);
        double ixz = InformationTheory.mi(x, z);
        double iyz = InformationTheory.mi(y, z);
        InformationTheory.GTestStatistics gxy = InformationTheory.gTest(x, y, null);
        InformationTheory.GTestStatistics gxz = InformationTheory.gTest(x, z, null);
        InformationTheory.GTestStatistics gyz = InformationTheory.gTest(y, z, null);
        if (InformationTheory.LOG_BASE == InformationTheory.LOG_2) {
            logger.log(Level.INFO, "Using log_2");
        } else if (InformationTheory.LOG_BASE == InformationTheory.LOG_E) {
            logger.log(Level.INFO, "Using log_e");
        } else {
            logger.log(Level.INFO, "Using unexpected log base, LOG_BASE = " + InformationTheory.LOG_BASE);
        }
        logger.log(Level.INFO, "The entropy of X, H(X) is " + hx);
        logger.log(Level.INFO, "The entropy of Y, H(Y) is " + hy);
        logger.log(Level.INFO, "The entropy of Z, H(Z) is " + hz);
        logger.log(Level.INFO, "The joint entropy of X and Y, H(X,Y) is " + hxy);
        logger.log(Level.INFO, "The joint entropy of X and Z, H(X,Z) is " + hxz);
        logger.log(Level.INFO, "The joint entropy of Y and Z, H(Y,Z) is " + hyz);
        logger.log(Level.INFO, "The mutual information between X and Y, I(X;Y) is " + ixy);
        logger.log(Level.INFO, "The mutual information between X and Z, I(X;Z) is " + ixz);
        logger.log(Level.INFO, "The mutual information between Y and Z, I(Y;Z) is " + iyz);
        logger.log(Level.INFO, "The G-Test between X and Y, G(X;Y) is " + gxy);
        logger.log(Level.INFO, "The G-Test between X and Z, G(X;Z) is " + gxz);
        logger.log(Level.INFO, "The G-Test between Y and Z, G(Y;Z) is " + gyz);
    }

    public static class DemoOptions
    implements Options {
        @Option(charName=116, longName="type", usage="The type of the input distribution.")
        public DistributionType type = DistributionType.RANDOM;

        public String getOptionsDescription() {
            return "A demo class showing how to calculate various mutual informations from different inputs.";
        }
    }

    public static enum DistributionType {
        RANDOM,
        XOR,
        CORRELATED;

    }
}

