/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt;

import java.util.function.Consumer;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.mqtt.MqttClient;
import software.amazon.awssdk.crt.mqtt.MqttClientConnectionEvents;
import software.amazon.awssdk.crt.mqtt.MqttException;
import software.amazon.awssdk.crt.mqtt.MqttMessage;
import software.amazon.awssdk.crt.mqtt.QualityOfService;
import software.amazon.awssdk.crt.mqtt.WebsocketHandshakeTransformArgs;
import software.amazon.awssdk.crt.mqtt5.Mqtt5Client;

public final class MqttConnectionConfig
extends CrtResource {
    private String endpoint;
    private int port;
    private SocketOptions socketOptions;
    private MqttClient mqttClient;
    private Mqtt5Client mqtt5Client;
    private String clientId;
    private String username;
    private String password;
    private MqttClientConnectionEvents connectionCallbacks;
    private int keepAliveSecs = 0;
    private int pingTimeoutMs = 0;
    private long minReconnectTimeoutSecs = 0L;
    private long maxReconnectTimeoutSecs = 0L;
    private int protocolOperationTimeoutMs = 0;
    private boolean cleanSession = true;
    private MqttMessage willMessage;
    private QualityOfService deprecatedWillQos;
    private Boolean deprecatedWillRetain;
    private boolean useWebsockets = false;
    private HttpProxyOptions proxyOptions;
    private Consumer<WebsocketHandshakeTransformArgs> websocketHandshakeTransform;

    @Override
    protected void releaseNativeHandle() {
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    public void setConnectionCallbacks(MqttClientConnectionEvents connectionCallbacks) {
        this.connectionCallbacks = connectionCallbacks;
    }

    public MqttClientConnectionEvents getConnectionCallbacks() {
        return this.connectionCallbacks;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setSocketOptions(SocketOptions socketOptions) {
        this.swapReferenceTo(this.socketOptions, socketOptions);
        this.socketOptions = socketOptions;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public boolean getCleanSession() {
        return this.cleanSession;
    }

    @Deprecated
    public void setKeepAliveMs(int keepAliveMs) {
        this.keepAliveSecs = keepAliveMs / 1000;
    }

    @Deprecated
    public int getKeepAliveMs() {
        return this.keepAliveSecs * 1000;
    }

    public void setKeepAliveSecs(int keepAliveSecs) {
        this.keepAliveSecs = keepAliveSecs;
    }

    public int getKeepAliveSecs() {
        return this.keepAliveSecs;
    }

    public void setPingTimeoutMs(int pingTimeoutMs) {
        this.pingTimeoutMs = pingTimeoutMs;
    }

    public int getPingTimeoutMs() {
        return this.pingTimeoutMs;
    }

    public void setReconnectTimeoutSecs(long minTimeoutSecs, long maxTimeoutSecs) {
        this.minReconnectTimeoutSecs = minTimeoutSecs;
        this.maxReconnectTimeoutSecs = maxTimeoutSecs;
    }

    public long getMinReconnectTimeoutSecs() {
        return this.minReconnectTimeoutSecs;
    }

    public long getMaxReconnectTimeoutSecs() {
        return this.maxReconnectTimeoutSecs;
    }

    public void setProtocolOperationTimeoutMs(int protocolOperationTimeoutMs) {
        this.protocolOperationTimeoutMs = protocolOperationTimeoutMs;
    }

    public int getProtocolOperationTimeoutMs() {
        return this.protocolOperationTimeoutMs;
    }

    public void setMqttClient(MqttClient mqttClient) {
        this.swapReferenceTo(this.mqttClient, mqttClient);
        this.mqttClient = mqttClient;
    }

    public MqttClient getMqttClient() {
        return this.mqttClient;
    }

    public void setMqtt5Client(Mqtt5Client mqtt5Client) {
        this.swapReferenceTo(this.mqtt5Client, mqtt5Client);
        this.mqtt5Client = mqtt5Client;
    }

    public Mqtt5Client getMqtt5Client() {
        return this.mqtt5Client;
    }

    public void setLogin(String user, String pass) throws MqttException {
        this.username = user;
        this.password = pass;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setWillMessage(MqttMessage willMessage) {
        this.willMessage = willMessage;
    }

    public MqttMessage getWillMessage() {
        if (this.willMessage == null || this.deprecatedWillRetain == null && this.deprecatedWillQos == null) {
            return this.willMessage;
        }
        QualityOfService qos = this.deprecatedWillQos == null ? this.willMessage.getQos() : this.deprecatedWillQos;
        boolean retain = this.deprecatedWillRetain == null ? this.willMessage.getRetain() : this.deprecatedWillRetain.booleanValue();
        return new MqttMessage(this.willMessage.getTopic(), this.willMessage.getPayload(), qos, retain);
    }

    @Deprecated
    public void setWillQos(QualityOfService qos) {
        this.deprecatedWillQos = qos;
    }

    @Deprecated
    public QualityOfService getWillQos() {
        if (this.deprecatedWillQos != null) {
            return this.deprecatedWillQos;
        }
        if (this.willMessage != null) {
            return this.willMessage.getQos();
        }
        return null;
    }

    @Deprecated
    public void setWillRetain(boolean retain) {
        this.deprecatedWillRetain = retain;
    }

    @Deprecated
    public boolean getWillRetain() {
        if (this.deprecatedWillRetain != null) {
            return this.deprecatedWillRetain;
        }
        if (this.willMessage != null) {
            return this.willMessage.getRetain();
        }
        return false;
    }

    public void setUseWebsockets(boolean useWebsockets) {
        this.useWebsockets = useWebsockets;
    }

    public boolean getUseWebsockets() {
        return this.useWebsockets;
    }

    public void setWebsocketProxyOptions(HttpProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
    }

    public HttpProxyOptions getWebsocketProxyOptions() {
        return this.proxyOptions;
    }

    public void setHttpProxyOptions(HttpProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
    }

    public HttpProxyOptions getHttpProxyOptions() {
        return this.proxyOptions;
    }

    public void setWebsocketHandshakeTransform(Consumer<WebsocketHandshakeTransformArgs> handshakeTransform) {
        this.websocketHandshakeTransform = handshakeTransform;
    }

    public Consumer<WebsocketHandshakeTransformArgs> getWebsocketHandshakeTransform() {
        return this.websocketHandshakeTransform;
    }

    public MqttConnectionConfig clone() {
        try (MqttConnectionConfig clone = new MqttConnectionConfig();){
            clone.setEndpoint(this.getEndpoint());
            clone.setPort(this.getPort());
            clone.setSocketOptions(this.getSocketOptions());
            clone.setMqttClient(this.getMqttClient());
            clone.setMqtt5Client(this.getMqtt5Client());
            clone.setClientId(this.getClientId());
            clone.setUsername(this.getUsername());
            clone.setPassword(this.getPassword());
            clone.setConnectionCallbacks(this.getConnectionCallbacks());
            clone.setKeepAliveSecs(this.getKeepAliveSecs());
            clone.setPingTimeoutMs(this.getPingTimeoutMs());
            clone.setProtocolOperationTimeoutMs(this.getProtocolOperationTimeoutMs());
            clone.setCleanSession(this.getCleanSession());
            clone.setWillMessage(this.getWillMessage());
            clone.setUseWebsockets(this.getUseWebsockets());
            clone.setHttpProxyOptions(this.getHttpProxyOptions());
            clone.setWebsocketHandshakeTransform(this.getWebsocketHandshakeTransform());
            clone.setReconnectTimeoutSecs(this.getMinReconnectTimeoutSecs(), this.getMaxReconnectTimeoutSecs());
            clone.addRef();
            MqttConnectionConfig mqttConnectionConfig = clone;
            return mqttConnectionConfig;
        }
    }
}

