/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.pipeline.apache;

import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseContext;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.protocol.HttpContext;

public class HttpServiceResponseContext
implements ServiceResponseContext {
    private HttpResponse clientResponse;
    private HttpContext httpContext;

    public HttpServiceResponseContext(HttpResponse clientResponse, HttpContext httpContext) {
        this.clientResponse = clientResponse;
        this.httpContext = httpContext;
    }

    @Override
    public Object getProperty(String name) {
        return this.httpContext.getAttribute(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.httpContext.setAttribute(name, value);
    }

    @Override
    public int getStatus() {
        return this.clientResponse.getStatusLine().getStatusCode();
    }

    @Override
    public void setStatus(int status) {
        this.clientResponse.setStatusCode(status);
    }

    @Override
    public boolean hasEntity() {
        return this.clientResponse.getEntity() != null;
    }

    @Override
    public String getHeader(String name) {
        Header first = this.clientResponse.getFirstHeader(name);
        if (first != null) {
            return first.getValue();
        }
        return null;
    }

    @Override
    public void setHeader(String name, String value) {
        this.clientResponse.setHeader(name, value);
    }

    @Override
    public void removeHeader(String name) {
        this.clientResponse.removeHeaders(name);
    }

    @Override
    public InputStream getEntityInputStream() {
        try {
            return this.clientResponse.getEntity().getContent();
        }
        catch (IOException e) {
            return null;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Override
    public void setEntityInputStream(InputStream entity) {
        this.clientResponse.setEntity((HttpEntity)new InputStreamEntity(entity));
    }
}

