"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFontStyle = exports.renderPanelTitle = void 0;
var common_1 = require("../../../../../utils/common");
var dimensions_1 = require("../../../../../utils/dimensions");
var axis_type_utils_1 = require("../../../utils/axis_type_utils");
var axis_utils_1 = require("../../../utils/axis_utils");
var text_1 = require("../primitives/text");
var debug_1 = require("../utils/debug");
function renderPanelTitle(ctx, props) {
    var position = props.axisSpec.position, axisPanelTitle = props.axisStyle.axisPanelTitle, panelTitle = props.panelTitle;
    if (!panelTitle || !axisPanelTitle.visible) {
        return null;
    }
    return axis_type_utils_1.isHorizontalAxis(position) ? renderHorizontalTitle(ctx, props) : renderVerticalTitle(ctx, props);
}
exports.renderPanelTitle = renderPanelTitle;
function renderVerticalTitle(ctx, props) {
    var height = props.size.height, _a = props.axisSpec, position = _a.position, hideAxis = _a.hide, title = _a.title, maxLabelBboxWidth = props.dimension.maxLabelBboxWidth, _b = props.axisStyle, axisTitle = _b.axisTitle, axisPanelTitle = _b.axisPanelTitle, tickLine = _b.tickLine, tickLabel = _b.tickLabel, debug = props.debug, panelTitle = props.panelTitle;
    if (!panelTitle) {
        return null;
    }
    var font = getFontStyle(axisPanelTitle);
    var tickDimension = axis_utils_1.shouldShowTicks(tickLine, hideAxis) ? tickLine.size + tickLine.padding : 0;
    var panelTitlePadding = dimensions_1.getSimplePadding(axisPanelTitle.visible && panelTitle ? axisPanelTitle.padding : 0);
    var titleDimension = title ? axis_utils_1.getTitleDimension(axisTitle) : 0;
    var labelPadding = dimensions_1.getSimplePadding(tickLabel.padding);
    var labelWidth = tickLabel.visible ? labelPadding.outer + maxLabelBboxWidth + labelPadding.inner : 0;
    var top = height;
    var left = position === common_1.Position.Left
        ? titleDimension + panelTitlePadding.outer
        : tickDimension + labelWidth + panelTitlePadding.inner;
    if (debug) {
        debug_1.renderDebugRect(ctx, { x: left, y: top, width: height, height: font.fontSize }, undefined, undefined, -90);
    }
    text_1.renderText(ctx, {
        x: left + font.fontSize / 2,
        y: top - height / 2,
    }, panelTitle, font, -90);
}
function renderHorizontalTitle(ctx, props) {
    var width = props.size.width, _a = props.axisSpec, position = _a.position, hideAxis = _a.hide, title = _a.title, maxLabelBboxHeight = props.dimension.maxLabelBboxHeight, _b = props.axisStyle, axisTitle = _b.axisTitle, axisPanelTitle = _b.axisPanelTitle, tickLine = _b.tickLine, tickLabel = _b.tickLabel, debug = props.debug, panelTitle = props.panelTitle;
    if (!panelTitle) {
        return;
    }
    var font = getFontStyle(axisPanelTitle);
    var tickDimension = axis_utils_1.shouldShowTicks(tickLine, hideAxis) ? tickLine.size + tickLine.padding : 0;
    var panelTitlePadding = dimensions_1.getSimplePadding(axisPanelTitle.visible && panelTitle ? axisPanelTitle.padding : 0);
    var titleDimension = title ? axis_utils_1.getTitleDimension(axisTitle) : 0;
    var labelPadding = dimensions_1.getSimplePadding(tickLabel.padding);
    var labelHeight = tickLabel.visible ? maxLabelBboxHeight + labelPadding.outer + labelPadding.inner : 0;
    var top = position === common_1.Position.Top
        ? titleDimension + panelTitlePadding.outer
        : labelHeight + tickDimension + panelTitlePadding.inner;
    var left = 0;
    if (debug) {
        debug_1.renderDebugRect(ctx, { x: left, y: top, width: width, height: font.fontSize });
    }
    text_1.renderText(ctx, {
        x: left + width / 2,
        y: top + font.fontSize / 2,
    }, panelTitle, font);
}
function getFontStyle(_a) {
    var fontFamily = _a.fontFamily, fontStyle = _a.fontStyle, fill = _a.fill, fontSize = _a.fontSize;
    return {
        fontFamily: fontFamily,
        fontVariant: 'normal',
        fontStyle: fontStyle ? fontStyle : 'normal',
        fontWeight: 'normal',
        textColor: fill,
        textOpacity: 1,
        fill: fill,
        align: 'center',
        baseline: 'middle',
        fontSize: fontSize,
    };
}
exports.getFontStyle = getFontStyle;
//# sourceMappingURL=panel_title.js.map