/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.output;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.openapidiff.core.exception.RendererException;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedApiResponse;
import org.openapitools.openapidiff.core.model.ChangedContent;
import org.openapitools.openapidiff.core.model.ChangedMediaType;
import org.openapitools.openapidiff.core.model.ChangedMetadata;
import org.openapitools.openapidiff.core.model.ChangedOpenApi;
import org.openapitools.openapidiff.core.model.ChangedOperation;
import org.openapitools.openapidiff.core.model.ChangedParameter;
import org.openapitools.openapidiff.core.model.ChangedParameters;
import org.openapitools.openapidiff.core.model.ChangedResponse;
import org.openapitools.openapidiff.core.model.ChangedSchema;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;
import org.openapitools.openapidiff.core.model.Endpoint;
import org.openapitools.openapidiff.core.output.HttpStatus;
import org.openapitools.openapidiff.core.output.Render;
import org.openapitools.openapidiff.core.utils.RefPointer;
import org.openapitools.openapidiff.core.utils.RefType;

public class AsciidocRender
implements Render {
    private static final int LINE_LENGTH = 74;
    protected static RefPointer<Schema<?>> refPointer = new RefPointer(RefType.SCHEMAS);
    protected ChangedOpenApi diff;

    @Override
    public void render(ChangedOpenApi diff, OutputStreamWriter outputStreamWriter) {
        this.diff = diff;
        if (diff.isUnchanged()) {
            this.safelyAppend(outputStreamWriter, this.bigTitle(diff.getNewSpecOpenApi().getInfo().getTitle(), diff.getNewSpecOpenApi().getInfo().getVersion()));
            this.safelyAppend(outputStreamWriter, System.lineSeparator());
            this.safelyAppend(outputStreamWriter, System.lineSeparator());
            this.safelyAppend(outputStreamWriter, "NOTE: No differences. Specifications are equivalent");
        } else {
            this.safelyAppend(outputStreamWriter, this.bigTitle(diff.getNewSpecOpenApi().getInfo().getTitle(), diff.getNewSpecOpenApi().getInfo().getVersion()));
            this.safelyAppend(outputStreamWriter, System.lineSeparator());
            this.safelyAppend(outputStreamWriter, ":reproducible:");
            this.safelyAppend(outputStreamWriter, System.lineSeparator());
            this.safelyAppend(outputStreamWriter, ":sectlinks:");
            this.safelyAppend(outputStreamWriter, System.lineSeparator());
            this.safelyAppend(outputStreamWriter, ":toc:");
            this.safelyAppend(outputStreamWriter, System.lineSeparator());
            this.safelyAppend(outputStreamWriter, System.lineSeparator());
            List<Endpoint> newEndpoints = diff.getNewEndpoints();
            this.listEndpoints(newEndpoints, "What's New", outputStreamWriter);
            List<Endpoint> missingEndpoints = diff.getMissingEndpoints();
            this.listEndpoints(missingEndpoints, "What's Deleted", outputStreamWriter);
            List<Endpoint> deprecatedEndpoints = diff.getDeprecatedEndpoints();
            this.listEndpoints(deprecatedEndpoints, "What's Deprecated", outputStreamWriter);
            List<ChangedOperation> changedOperations = diff.getChangedOperations();
            this.ol_changed(changedOperations, outputStreamWriter);
            this.safelyAppend(outputStreamWriter, System.lineSeparator());
            this.safelyAppend(outputStreamWriter, diff.isCompatible() ? "NOTE: API changes are backward compatible" : "WARNING: API changes broke backward compatibility");
            this.safelyAppend(outputStreamWriter, System.lineSeparator());
        }
        try {
            outputStreamWriter.close();
        }
        catch (IOException e) {
            throw new RendererException(e);
        }
    }

    private void ol_changed(List<ChangedOperation> operations, OutputStreamWriter outputStreamWriter) {
        if (null == operations || operations.isEmpty()) {
            return;
        }
        this.safelyAppend(outputStreamWriter, this.title("What's Changed", 2));
        this.safelyAppend(outputStreamWriter, System.lineSeparator());
        for (ChangedOperation operation : operations) {
            String pathUrl = operation.getPathUrl();
            String method = operation.getHttpMethod().toString();
            String desc = Optional.ofNullable(operation.getSummary()).map(ChangedMetadata::getRight).orElse("");
            this.safelyAppend(outputStreamWriter, this.itemEndpoint(method, pathUrl, desc));
            this.safelyAppend(outputStreamWriter, System.lineSeparator());
            if (Changed.result(operation.getOperationId()).isDifferent()) {
                this.safelyAppend(outputStreamWriter, "* Operation ID:");
                this.safelyAppend(outputStreamWriter, System.lineSeparator());
                this.safelyAppend(outputStreamWriter, String.format("** Changed %s to %s", operation.getOperationId().getLeft(), operation.getOperationId().getRight()));
                this.safelyAppend(outputStreamWriter, System.lineSeparator());
            }
            if (Changed.result(operation.getParameters()).isDifferent()) {
                this.safelyAppend(outputStreamWriter, "* Parameter:");
                this.safelyAppend(outputStreamWriter, System.lineSeparator());
                this.safelyAppend(outputStreamWriter, this.ul_param(operation.getParameters()));
                this.safelyAppend(outputStreamWriter, System.lineSeparator());
            }
            if (operation.resultRequestBody().isDifferent()) {
                this.safelyAppend(outputStreamWriter, "* Request:");
                this.safelyAppend(outputStreamWriter, System.lineSeparator());
                this.safelyAppend(outputStreamWriter, this.ul_content(operation.getRequestBody().getContent(), true, 2));
                this.safelyAppend(outputStreamWriter, System.lineSeparator());
            }
            if (!operation.resultApiResponses().isDifferent()) continue;
            this.safelyAppend(outputStreamWriter, "* Return Type:");
            this.safelyAppend(outputStreamWriter, System.lineSeparator());
            this.safelyAppend(outputStreamWriter, this.ul_response(operation.getApiResponses()));
            this.safelyAppend(outputStreamWriter, System.lineSeparator());
        }
    }

    private String ul_response(ChangedApiResponse changedApiResponse) {
        Map<String, ApiResponse> addResponses = changedApiResponse.getIncreased();
        Map<String, ApiResponse> delResponses = changedApiResponse.getMissing();
        Map<String, ChangedResponse> changedResponses = changedApiResponse.getChanged();
        StringBuilder sb = new StringBuilder();
        for (String string : addResponses.keySet()) {
            sb.append(this.itemResponse("** Add ", string));
        }
        for (String string : delResponses.keySet()) {
            sb.append(this.itemResponse("** Deleted ", string));
        }
        for (Map.Entry entry : changedResponses.entrySet()) {
            sb.append(this.itemChangedResponse("** Changed ", (String)entry.getKey(), (ChangedResponse)entry.getValue()));
        }
        return sb.toString();
    }

    private String itemResponse(String title, String code) {
        StringBuilder sb = new StringBuilder();
        String status = "";
        if (!code.equals("default") && !code.matches("[1-5]XX")) {
            status = HttpStatus.getReasonPhrase(Integer.parseInt(code));
        }
        sb.append(title).append(code).append(' ').append(status).append(System.lineSeparator());
        return sb.toString();
    }

    private String itemChangedResponse(String title, String contentType, ChangedResponse response) {
        return this.itemResponse(title, contentType) + "** Media types:" + System.lineSeparator() + this.ul_content(response.getContent(), false, 3);
    }

    private String ul_content(ChangedContent changedContent, boolean isRequest, int indent) {
        StringBuilder sb = new StringBuilder();
        if (changedContent == null) {
            return sb.toString();
        }
        for (String propName : changedContent.getIncreased().keySet()) {
            sb.append(this.itemContent("Added ", propName, indent));
        }
        for (String propName : changedContent.getMissing().keySet()) {
            sb.append(this.itemContent("Deleted ", propName, indent));
        }
        for (String propName : changedContent.getChanged().keySet()) {
            sb.append(this.itemContent("Changed ", propName, indent, changedContent.getChanged().get(propName), isRequest));
        }
        return sb.toString();
    }

    private String itemContent(String title, String contentType, int indent) {
        return StringUtils.repeat('*', indent) + " " + title + contentType + System.lineSeparator();
    }

    private String itemContent(String title, String contentType, int indent, ChangedMediaType changedMediaType, boolean isRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.itemContent(title, contentType, indent)).append(this.itemContent("Schema:", "", indent)).append(changedMediaType.isCompatible() ? "Backward compatible" : "Broken compatibility").append(System.lineSeparator());
        if (!changedMediaType.isCompatible() && changedMediaType.getSchema() != null) {
            sb.append(this.incompatibilities(changedMediaType.getSchema()));
        }
        return sb.toString();
    }

    private String incompatibilities(ChangedSchema schema) {
        return this.incompatibilities("", schema);
    }

    private String incompatibilities(String propName, ChangedSchema schema) {
        StringBuilder sb = new StringBuilder();
        if (schema.getItems() != null) {
            sb.append(this.items(propName, schema.getItems()));
        }
        if (schema.isCoreChanged() == DiffResult.INCOMPATIBLE && schema.isChangedType()) {
            String type = this.type(schema.getOldSchema()) + " -> " + this.type(schema.getNewSchema());
            sb.append(this.property(propName, "Changed property type", type));
            sb.append(System.lineSeparator());
            sb.append(System.lineSeparator());
        }
        String prefix = propName.isEmpty() ? "" : propName + ".";
        sb.append(this.properties(prefix, "Missing property", schema.getMissingProperties(), schema.getContext()));
        schema.getChangedProperties().forEach((name, property) -> sb.append(this.incompatibilities(prefix + name, (ChangedSchema)property)));
        return sb.toString();
    }

    private String items(String propName, ChangedSchema schema) {
        return this.incompatibilities(propName + "[n]", schema);
    }

    private String properties(String propPrefix, String title, Map<String, Schema<?>> properties, DiffContext context) {
        StringBuilder sb = new StringBuilder();
        if (properties != null) {
            properties.forEach((key, value) -> sb.append(this.resolveProperty(propPrefix, (Schema<?>)value, (String)key, title)));
        }
        return sb.toString();
    }

    private String resolveProperty(String propPrefix, Schema<?> value, String key, String title) {
        try {
            return this.property(propPrefix + key, title, this.resolve(value));
        }
        catch (Exception e) {
            return this.property(propPrefix + key, title, this.type(value));
        }
    }

    protected String property(String name, String title, Schema<?> schema) {
        return this.property(name, title, this.type(schema));
    }

    protected String property(String name, String title, String type) {
        return String.format("*** %s: %s (%s)", title, name, type);
    }

    protected Schema<?> resolve(Schema<?> schema) {
        return refPointer.resolveRef(this.diff.getNewSpecOpenApi().getComponents(), schema, schema.get$ref());
    }

    protected String type(Schema<?> schema) {
        String result = "object";
        if (schema == null) {
            result = "no schema";
        } else if (schema instanceof ArraySchema) {
            result = "array";
        } else if (schema.getType() != null) {
            result = schema.getType();
        }
        return result;
    }

    private String ul_param(ChangedParameters changedParameters) {
        List<Parameter> addParameters = changedParameters.getIncreased();
        List<Parameter> delParameters = changedParameters.getMissing();
        List<ChangedParameter> changed = changedParameters.getChanged();
        StringBuilder sb = new StringBuilder();
        for (Parameter parameter : addParameters) {
            sb.append(this.itemParam("** Add ", parameter));
        }
        for (ChangedParameter changedParameter : changed) {
            sb.append(this.li_changedParam(changedParameter));
        }
        for (Parameter parameter : delParameters) {
            sb.append(this.itemParam("** Delete ", parameter));
        }
        return sb.toString();
    }

    private String itemParam(String title, Parameter param) {
        return title + param.getName() + " in " + param.getIn() + System.lineSeparator();
    }

    private String li_changedParam(ChangedParameter changeParam) {
        if (changeParam.isDeprecated()) {
            return this.itemParam("** Deprecated ", changeParam.getNewParameter());
        }
        return this.itemParam("** Changed ", changeParam.getNewParameter());
    }

    private String listEndpoints(List<Endpoint> endpoints, String title, OutputStreamWriter outputStreamWriter) {
        if (null == endpoints || endpoints.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.title(title));
        for (Endpoint endpoint : endpoints) {
            sb.append(this.itemEndpoint(endpoint.getMethod().toString(), endpoint.getPathUrl(), endpoint.getSummary()));
            sb.append(System.lineSeparator());
        }
        return sb.append(System.lineSeparator()).toString();
    }

    private String itemEndpoint(String method, String path, String desc) {
        return String.format("=== %s%s", StringUtils.rightPad(method, 6), path);
    }

    public String bigTitle(String title, String version) {
        int ch = 61;
        return String.format("= %s (v %s)", title.toUpperCase(), version);
    }

    public String title(String title) {
        return this.title(title, 45);
    }

    public String title(String title, int level) {
        String little = StringUtils.repeat("=", level);
        return String.format("%s %s", little, title);
    }
}

