/*
 * SPDX-FileCopyrightText: Copyright (c) 2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _clC87e_h_
#define _clC87e_h_

#ifdef __cplusplus
extern "C" {
#endif

#define NVC87E_WINDOW_CHANNEL_DMA                                               (0x0000C87E)

// dma opcode instructions
#define NVC87E_DMA                                                                     
#define NVC87E_DMA_OPCODE                                                        31:29 
#define NVC87E_DMA_OPCODE_METHOD                                            0x00000000 
#define NVC87E_DMA_OPCODE_JUMP                                              0x00000001 
#define NVC87E_DMA_OPCODE_NONINC_METHOD                                     0x00000002 
#define NVC87E_DMA_OPCODE_SET_SUBDEVICE_MASK                                0x00000003 
#define NVC87E_DMA_METHOD_COUNT                                                  27:18 
#define NVC87E_DMA_METHOD_OFFSET                                                  13:2 
#define NVC87E_DMA_DATA                                                           31:0 
#define NVC87E_DMA_DATA_NOP                                                 0x00000000 
#define NVC87E_DMA_JUMP_OFFSET                                                    11:2 
#define NVC87E_DMA_SET_SUBDEVICE_MASK_VALUE                                       11:0 

// class methods
#define NVC87E_PUT                                                              (0x00000000)
#define NVC87E_PUT_PTR                                                          9:0
#define NVC87E_GET                                                              (0x00000004)
#define NVC87E_GET_PTR                                                          9:0
#define NVC87E_UPDATE                                                           (0x00000200)
#define NVC87E_UPDATE_RELEASE_ELV                                               0:0
#define NVC87E_UPDATE_RELEASE_ELV_FALSE                                         (0x00000000)
#define NVC87E_UPDATE_RELEASE_ELV_TRUE                                          (0x00000001)
#define NVC87E_UPDATE_FLIP_LOCK_PIN                                             8:4
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_NONE                               (0x00000000)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN(i)                                 (0x00000001 +(i))
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN__SIZE_1                            16
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_0                                  (0x00000001)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_1                                  (0x00000002)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_2                                  (0x00000003)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_3                                  (0x00000004)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_4                                  (0x00000005)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_5                                  (0x00000006)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_6                                  (0x00000007)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_7                                  (0x00000008)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_8                                  (0x00000009)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_9                                  (0x0000000A)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_A                                  (0x0000000B)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_B                                  (0x0000000C)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_C                                  (0x0000000D)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_D                                  (0x0000000E)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_E                                  (0x0000000F)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_F                                  (0x00000010)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_INTERNAL_FLIP_LOCK_0                        (0x00000014)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_INTERNAL_FLIP_LOCK_1                        (0x00000015)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_INTERNAL_FLIP_LOCK_2                        (0x00000016)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_INTERNAL_FLIP_LOCK_3                        (0x00000017)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK(i)                       (0x00000018 +(i))
#define NVC87E_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK__SIZE_1                  8
#define NVC87E_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_0                        (0x00000018)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_1                        (0x00000019)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_2                        (0x0000001A)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_3                        (0x0000001B)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_4                        (0x0000001C)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_5                        (0x0000001D)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_6                        (0x0000001E)
#define NVC87E_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_7                        (0x0000001F)
#define NVC87E_UPDATE_INTERLOCK_WITH_WIN_IMM                                    12:12
#define NVC87E_UPDATE_INTERLOCK_WITH_WIN_IMM_DISABLE                            (0x00000000)
#define NVC87E_UPDATE_INTERLOCK_WITH_WIN_IMM_ENABLE                             (0x00000001)
#define NVC87E_SET_SEMAPHORE_ACQUIRE_HI                                         (0x00000204)
#define NVC87E_SET_SEMAPHORE_ACQUIRE_HI_VALUE                                   31:0
#define NVC87E_GET_LINE                                                         (0x00000208)
#define NVC87E_GET_LINE_LINE                                                    15:0
#define NVC87E_SET_SEMAPHORE_CONTROL                                            (0x0000020C)
#define NVC87E_SET_SEMAPHORE_CONTROL_OFFSET                                     7:0
#define NVC87E_SET_SEMAPHORE_CONTROL_SKIP_ACQ                                   11:11
#define NVC87E_SET_SEMAPHORE_CONTROL_SKIP_ACQ_FALSE                             (0x00000000)
#define NVC87E_SET_SEMAPHORE_CONTROL_SKIP_ACQ_TRUE                              (0x00000001)
#define NVC87E_SET_SEMAPHORE_CONTROL_PAYLOAD_SIZE                               15:15
#define NVC87E_SET_SEMAPHORE_CONTROL_PAYLOAD_SIZE_PAYLOAD_32BIT                 (0x00000000)
#define NVC87E_SET_SEMAPHORE_CONTROL_PAYLOAD_SIZE_PAYLOAD_64BIT                 (0x00000001)
#define NVC87E_SET_SEMAPHORE_CONTROL_ACQ_MODE                                   13:12
#define NVC87E_SET_SEMAPHORE_CONTROL_ACQ_MODE_EQ                                (0x00000000)
#define NVC87E_SET_SEMAPHORE_CONTROL_ACQ_MODE_CGEQ                              (0x00000001)
#define NVC87E_SET_SEMAPHORE_CONTROL_ACQ_MODE_STRICT_GEQ                        (0x00000002)
#define NVC87E_SET_SEMAPHORE_CONTROL_REL_MODE                                   14:14
#define NVC87E_SET_SEMAPHORE_CONTROL_REL_MODE_WRITE                             (0x00000000)
#define NVC87E_SET_SEMAPHORE_CONTROL_REL_MODE_WRITE_AWAKEN                      (0x00000001)
#define NVC87E_SET_SEMAPHORE_ACQUIRE                                            (0x00000210)
#define NVC87E_SET_SEMAPHORE_ACQUIRE_VALUE                                      31:0
#define NVC87E_SET_SEMAPHORE_RELEASE                                            (0x00000214)
#define NVC87E_SET_SEMAPHORE_RELEASE_VALUE                                      31:0
#define NVC87E_SET_CONTEXT_DMA_SEMAPHORE                                        (0x00000218)
#define NVC87E_SET_CONTEXT_DMA_SEMAPHORE_HANDLE                                 31:0
#define NVC87E_SET_CONTEXT_DMA_NOTIFIER                                         (0x0000021C)
#define NVC87E_SET_CONTEXT_DMA_NOTIFIER_HANDLE                                  31:0
#define NVC87E_SET_NOTIFIER_CONTROL                                             (0x00000220)
#define NVC87E_SET_NOTIFIER_CONTROL_MODE                                        0:0
#define NVC87E_SET_NOTIFIER_CONTROL_MODE_WRITE                                  (0x00000000)
#define NVC87E_SET_NOTIFIER_CONTROL_MODE_WRITE_AWAKEN                           (0x00000001)
#define NVC87E_SET_NOTIFIER_CONTROL_OFFSET                                      11:4
#define NVC87E_SET_SIZE                                                         (0x00000224)
#define NVC87E_SET_SIZE_WIDTH                                                   15:0
#define NVC87E_SET_SIZE_HEIGHT                                                  31:16
#define NVC87E_SET_STORAGE                                                      (0x00000228)
#define NVC87E_SET_STORAGE_BLOCK_HEIGHT                                         3:0
#define NVC87E_SET_STORAGE_BLOCK_HEIGHT_NVD_BLOCK_HEIGHT_ONE_GOB                (0x00000000)
#define NVC87E_SET_STORAGE_BLOCK_HEIGHT_NVD_BLOCK_HEIGHT_TWO_GOBS               (0x00000001)
#define NVC87E_SET_STORAGE_BLOCK_HEIGHT_NVD_BLOCK_HEIGHT_FOUR_GOBS              (0x00000002)
#define NVC87E_SET_STORAGE_BLOCK_HEIGHT_NVD_BLOCK_HEIGHT_EIGHT_GOBS             (0x00000003)
#define NVC87E_SET_STORAGE_BLOCK_HEIGHT_NVD_BLOCK_HEIGHT_SIXTEEN_GOBS           (0x00000004)
#define NVC87E_SET_STORAGE_BLOCK_HEIGHT_NVD_BLOCK_HEIGHT_THIRTYTWO_GOBS         (0x00000005)
#define NVC87E_SET_PARAMS                                                       (0x0000022C)
#define NVC87E_SET_PARAMS_FORMAT                                                7:0
#define NVC87E_SET_PARAMS_FORMAT_I8                                             (0x0000001E)
#define NVC87E_SET_PARAMS_FORMAT_R4G4B4A4                                       (0x0000002F)
#define NVC87E_SET_PARAMS_FORMAT_R5G6B5                                         (0x000000E8)
#define NVC87E_SET_PARAMS_FORMAT_A1R5G5B5                                       (0x000000E9)
#define NVC87E_SET_PARAMS_FORMAT_R5G5B5A1                                       (0x0000002E)
#define NVC87E_SET_PARAMS_FORMAT_A8R8G8B8                                       (0x000000CF)
#define NVC87E_SET_PARAMS_FORMAT_X8R8G8B8                                       (0x000000E6)
#define NVC87E_SET_PARAMS_FORMAT_A8B8G8R8                                       (0x000000D5)
#define NVC87E_SET_PARAMS_FORMAT_X8B8G8R8                                       (0x000000F9)
#define NVC87E_SET_PARAMS_FORMAT_A2R10G10B10                                    (0x000000DF)
#define NVC87E_SET_PARAMS_FORMAT_A2B10G10R10                                    (0x000000D1)
#define NVC87E_SET_PARAMS_FORMAT_R16_G16_B16_A16_NVBIAS                         (0x00000023)
#define NVC87E_SET_PARAMS_FORMAT_R16_G16_B16_A16                                (0x000000C6)
#define NVC87E_SET_PARAMS_FORMAT_RF16_GF16_BF16_AF16                            (0x000000CA)
#define NVC87E_SET_PARAMS_FORMAT_Y8_U8__Y8_V8_N422                              (0x00000028)
#define NVC87E_SET_PARAMS_FORMAT_U8_Y8__V8_Y8_N422                              (0x00000029)
#define NVC87E_SET_PARAMS_FORMAT_Y8___U8V8_N444                                 (0x00000035)
#define NVC87E_SET_PARAMS_FORMAT_Y8___U8V8_N422                                 (0x00000036)
#define NVC87E_SET_PARAMS_FORMAT_Y8___V8U8_N420                                 (0x00000038)
#define NVC87E_SET_PARAMS_FORMAT_Y8___U8___V8_N444                              (0x0000003A)
#define NVC87E_SET_PARAMS_FORMAT_Y8___U8___V8_N420                              (0x0000003B)
#define NVC87E_SET_PARAMS_FORMAT_Y10___U10V10_N444                              (0x00000055)
#define NVC87E_SET_PARAMS_FORMAT_Y10___U10V10_N422                              (0x00000056)
#define NVC87E_SET_PARAMS_FORMAT_Y10___V10U10_N420                              (0x00000058)
#define NVC87E_SET_PARAMS_FORMAT_Y12___U12V12_N444                              (0x00000075)
#define NVC87E_SET_PARAMS_FORMAT_Y12___U12V12_N422                              (0x00000076)
#define NVC87E_SET_PARAMS_FORMAT_Y12___V12U12_N420                              (0x00000078)
#define NVC87E_SET_PARAMS_CLAMP_BEFORE_BLEND                                    18:18
#define NVC87E_SET_PARAMS_CLAMP_BEFORE_BLEND_DISABLE                            (0x00000000)
#define NVC87E_SET_PARAMS_CLAMP_BEFORE_BLEND_ENABLE                             (0x00000001)
#define NVC87E_SET_PARAMS_SWAP_UV                                               19:19
#define NVC87E_SET_PARAMS_SWAP_UV_DISABLE                                       (0x00000000)
#define NVC87E_SET_PARAMS_SWAP_UV_ENABLE                                        (0x00000001)
#define NVC87E_SET_PARAMS_FMT_ROUNDING_MODE                                     22:22
#define NVC87E_SET_PARAMS_FMT_ROUNDING_MODE_ROUND_TO_NEAREST                    (0x00000000)
#define NVC87E_SET_PARAMS_FMT_ROUNDING_MODE_ROUND_DOWN                          (0x00000001)
#define NVC87E_SET_PLANAR_STORAGE(b)                                            (0x00000230 + (b)*0x00000004)
#define NVC87E_SET_PLANAR_STORAGE_PITCH                                         12:0
#define NVC87E_SET_SEMAPHORE_RELEASE_HI                                         (0x0000023C)
#define NVC87E_SET_SEMAPHORE_RELEASE_HI_VALUE                                   31:0
#define NVC87E_SET_CONTEXT_DMA_ISO(b)                                           (0x00000240 + (b)*0x00000004)
#define NVC87E_SET_CONTEXT_DMA_ISO_HANDLE                                       31:0
#define NVC87E_SET_OFFSET(b)                                                    (0x00000260 + (b)*0x00000004)
#define NVC87E_SET_OFFSET_ORIGIN                                                31:0
#define NVC87E_SET_POINT_IN(b)                                                  (0x00000290 + (b)*0x00000004)
#define NVC87E_SET_POINT_IN_X                                                   15:0
#define NVC87E_SET_POINT_IN_Y                                                   31:16
#define NVC87E_SET_SIZE_IN                                                      (0x00000298)
#define NVC87E_SET_SIZE_IN_WIDTH                                                15:0
#define NVC87E_SET_SIZE_IN_HEIGHT                                               31:16
#define NVC87E_SET_SIZE_OUT                                                     (0x000002A4)
#define NVC87E_SET_SIZE_OUT_WIDTH                                               15:0
#define NVC87E_SET_SIZE_OUT_HEIGHT                                              31:16
#define NVC87E_SET_CONTROL_INPUT_SCALER                                         (0x000002A8)
#define NVC87E_SET_CONTROL_INPUT_SCALER_VERTICAL_TAPS                           2:0
#define NVC87E_SET_CONTROL_INPUT_SCALER_VERTICAL_TAPS_TAPS_2                    (0x00000001)
#define NVC87E_SET_CONTROL_INPUT_SCALER_VERTICAL_TAPS_TAPS_5                    (0x00000004)
#define NVC87E_SET_CONTROL_INPUT_SCALER_HORIZONTAL_TAPS                         6:4
#define NVC87E_SET_CONTROL_INPUT_SCALER_HORIZONTAL_TAPS_TAPS_2                  (0x00000001)
#define NVC87E_SET_CONTROL_INPUT_SCALER_HORIZONTAL_TAPS_TAPS_5                  (0x00000004)
#define NVC87E_SET_INPUT_SCALER_COEFF_VALUE                                     (0x000002AC)
#define NVC87E_SET_INPUT_SCALER_COEFF_VALUE_DATA                                9:0
#define NVC87E_SET_INPUT_SCALER_COEFF_VALUE_INDEX                               19:12
#define NVC87E_SET_COMPOSITION_CONTROL                                          (0x000002EC)
#define NVC87E_SET_COMPOSITION_CONTROL_COLOR_KEY_SELECT                         1:0
#define NVC87E_SET_COMPOSITION_CONTROL_COLOR_KEY_SELECT_DISABLE                 (0x00000000)
#define NVC87E_SET_COMPOSITION_CONTROL_COLOR_KEY_SELECT_SRC                     (0x00000001)
#define NVC87E_SET_COMPOSITION_CONTROL_COLOR_KEY_SELECT_DST                     (0x00000002)
#define NVC87E_SET_COMPOSITION_CONTROL_DEPTH                                    11:4
#define NVC87E_SET_COMPOSITION_CONTROL_BYPASS                                   16:16
#define NVC87E_SET_COMPOSITION_CONTROL_BYPASS_DISABLE                           (0x00000000)
#define NVC87E_SET_COMPOSITION_CONTROL_BYPASS_ENABLE                            (0x00000001)
#define NVC87E_SET_COMPOSITION_CONSTANT_ALPHA                                   (0x000002F0)
#define NVC87E_SET_COMPOSITION_CONSTANT_ALPHA_K1                                7:0
#define NVC87E_SET_COMPOSITION_CONSTANT_ALPHA_K2                                15:8
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT                                    (0x000002F4)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT      3:0
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_ZERO (0x00000000)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_ONE  (0x00000001)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_K1   (0x00000002)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_K1_TIMES_SRC (0x00000005)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_K1_TIMES_DST (0x00000006)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT   7:4
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_ZERO (0x00000000)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_ONE (0x00000001)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_K1 (0x00000002)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_K1_TIMES_SRC (0x00000005)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_K1_TIMES_DST (0x00000006)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT      11:8
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_ZERO (0x00000000)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_ONE  (0x00000001)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_K1   (0x00000002)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_K2   (0x00000003)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_NEG_K1 (0x00000004)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_K1_TIMES_DST (0x00000006)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_NEG_K1_TIMES_SRC (0x00000007)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT   15:12
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_ZERO (0x00000000)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_ONE (0x00000001)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_K1 (0x00000002)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_K2 (0x00000003)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_NEG_K1 (0x00000004)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_K1_TIMES_DST (0x00000006)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_NEG_K1_TIMES_SRC (0x00000007)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_MATCH_SELECT      19:16
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_MATCH_SELECT_ZERO (0x00000000)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_MATCH_SELECT_K1   (0x00000002)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_MATCH_SELECT_K2   (0x00000003)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_NO_MATCH_SELECT   23:20
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_NO_MATCH_SELECT_ZERO (0x00000000)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_NO_MATCH_SELECT_K1 (0x00000002)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_NO_MATCH_SELECT_K2 (0x00000003)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_NO_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_MATCH_SELECT      27:24
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_MATCH_SELECT_ZERO (0x00000000)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_MATCH_SELECT_ONE  (0x00000001)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_MATCH_SELECT_K2   (0x00000003)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_MATCH_SELECT_NEG_K1_TIMES_SRC (0x00000007)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_NO_MATCH_SELECT   31:28
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_NO_MATCH_SELECT_ZERO (0x00000000)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_NO_MATCH_SELECT_ONE (0x00000001)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_NO_MATCH_SELECT_K2 (0x00000003)
#define NVC87E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_NO_MATCH_SELECT_NEG_K1_TIMES_SRC (0x00000007)
#define NVC87E_SET_KEY_ALPHA                                                    (0x000002F8)
#define NVC87E_SET_KEY_ALPHA_MIN                                                15:0
#define NVC87E_SET_KEY_ALPHA_MAX                                                31:16
#define NVC87E_SET_KEY_RED_CR                                                   (0x000002FC)
#define NVC87E_SET_KEY_RED_CR_MIN                                               15:0
#define NVC87E_SET_KEY_RED_CR_MAX                                               31:16
#define NVC87E_SET_KEY_GREEN_Y                                                  (0x00000300)
#define NVC87E_SET_KEY_GREEN_Y_MIN                                              15:0
#define NVC87E_SET_KEY_GREEN_Y_MAX                                              31:16
#define NVC87E_SET_KEY_BLUE_CB                                                  (0x00000304)
#define NVC87E_SET_KEY_BLUE_CB_MIN                                              15:0
#define NVC87E_SET_KEY_BLUE_CB_MAX                                              31:16
#define NVC87E_SET_PRESENT_CONTROL                                              (0x00000308)
#define NVC87E_SET_PRESENT_CONTROL_MIN_PRESENT_INTERVAL                         3:0
#define NVC87E_SET_PRESENT_CONTROL_BEGIN_MODE                                   6:4
#define NVC87E_SET_PRESENT_CONTROL_BEGIN_MODE_NON_TEARING                       (0x00000000)
#define NVC87E_SET_PRESENT_CONTROL_BEGIN_MODE_IMMEDIATE                         (0x00000001)
#define NVC87E_SET_PRESENT_CONTROL_TIMESTAMP_MODE                               8:8
#define NVC87E_SET_PRESENT_CONTROL_TIMESTAMP_MODE_DISABLE                       (0x00000000)
#define NVC87E_SET_PRESENT_CONTROL_TIMESTAMP_MODE_ENABLE                        (0x00000001)
#define NVC87E_SET_PRESENT_CONTROL_STEREO_MODE                                  13:12
#define NVC87E_SET_PRESENT_CONTROL_STEREO_MODE_MONO                             (0x00000000)
#define NVC87E_SET_PRESENT_CONTROL_STEREO_MODE_PAIR_FLIP                        (0x00000001)
#define NVC87E_SET_PRESENT_CONTROL_STEREO_MODE_AT_ANY_FRAME                     (0x00000002)
#define NVC87E_SET_ACQ_SEMAPHORE_VALUE_HI                                       (0x0000030C)
#define NVC87E_SET_ACQ_SEMAPHORE_VALUE_HI_VALUE                                 31:0
#define NVC87E_SET_ACQ_SEMAPHORE_CONTROL                                        (0x00000330)
#define NVC87E_SET_ACQ_SEMAPHORE_CONTROL_OFFSET                                 7:0
#define NVC87E_SET_ACQ_SEMAPHORE_CONTROL_PAYLOAD_SIZE                           15:15
#define NVC87E_SET_ACQ_SEMAPHORE_CONTROL_PAYLOAD_SIZE_PAYLOAD_32BIT             (0x00000000)
#define NVC87E_SET_ACQ_SEMAPHORE_CONTROL_PAYLOAD_SIZE_PAYLOAD_64BIT             (0x00000001)
#define NVC87E_SET_ACQ_SEMAPHORE_CONTROL_ACQ_MODE                               13:12
#define NVC87E_SET_ACQ_SEMAPHORE_CONTROL_ACQ_MODE_EQ                            (0x00000000)
#define NVC87E_SET_ACQ_SEMAPHORE_CONTROL_ACQ_MODE_CGEQ                          (0x00000001)
#define NVC87E_SET_ACQ_SEMAPHORE_CONTROL_ACQ_MODE_STRICT_GEQ                    (0x00000002)
#define NVC87E_SET_ACQ_SEMAPHORE_VALUE                                          (0x00000334)
#define NVC87E_SET_ACQ_SEMAPHORE_VALUE_VALUE                                    31:0
#define NVC87E_SET_CONTEXT_DMA_ACQ_SEMAPHORE                                    (0x00000338)
#define NVC87E_SET_CONTEXT_DMA_ACQ_SEMAPHORE_HANDLE                             31:0
#define NVC87E_SET_SCAN_DIRECTION                                               (0x0000033C)
#define NVC87E_SET_SCAN_DIRECTION_HORIZONTAL_DIRECTION                          0:0
#define NVC87E_SET_SCAN_DIRECTION_HORIZONTAL_DIRECTION_FROM_LEFT                (0x00000000)
#define NVC87E_SET_SCAN_DIRECTION_HORIZONTAL_DIRECTION_FROM_RIGHT               (0x00000001)
#define NVC87E_SET_SCAN_DIRECTION_VERTICAL_DIRECTION                            1:1
#define NVC87E_SET_SCAN_DIRECTION_VERTICAL_DIRECTION_FROM_TOP                   (0x00000000)
#define NVC87E_SET_SCAN_DIRECTION_VERTICAL_DIRECTION_FROM_BOTTOM                (0x00000001)
#define NVC87E_SET_SCAN_DIRECTION_COLUMN_ORDER                                  2:2
#define NVC87E_SET_SCAN_DIRECTION_COLUMN_ORDER_FALSE                            (0x00000000)
#define NVC87E_SET_SCAN_DIRECTION_COLUMN_ORDER_TRUE                             (0x00000001)
#define NVC87E_SET_TIMESTAMP_ORIGIN_LO                                          (0x00000340)
#define NVC87E_SET_TIMESTAMP_ORIGIN_LO_TIMESTAMP_LO                             31:0
#define NVC87E_SET_TIMESTAMP_ORIGIN_HI                                          (0x00000344)
#define NVC87E_SET_TIMESTAMP_ORIGIN_HI_TIMESTAMP_HI                             31:0
#define NVC87E_SET_UPDATE_TIMESTAMP_LO                                          (0x00000348)
#define NVC87E_SET_UPDATE_TIMESTAMP_LO_TIMESTAMP_LO                             31:0
#define NVC87E_SET_UPDATE_TIMESTAMP_HI                                          (0x0000034C)
#define NVC87E_SET_UPDATE_TIMESTAMP_HI_TIMESTAMP_HI                             31:0
#define NVC87E_SET_INTERLOCK_FLAGS                                              (0x00000370)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CORE                          0:0
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CORE_DISABLE                  (0x00000000)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CORE_ENABLE                   (0x00000001)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR(i)                     ((i)+1):((i)+1)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR__SIZE_1                8
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR_DISABLE                (0x00000000)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR_ENABLE                 (0x00000001)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR0                       1:1
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR0_DISABLE               (0x00000000)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR0_ENABLE                (0x00000001)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR1                       2:2
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR1_DISABLE               (0x00000000)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR1_ENABLE                (0x00000001)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR2                       3:3
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR2_DISABLE               (0x00000000)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR2_ENABLE                (0x00000001)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR3                       4:4
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR3_DISABLE               (0x00000000)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR3_ENABLE                (0x00000001)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR4                       5:5
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR4_DISABLE               (0x00000000)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR4_ENABLE                (0x00000001)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR5                       6:6
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR5_DISABLE               (0x00000000)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR5_ENABLE                (0x00000001)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR6                       7:7
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR6_DISABLE               (0x00000000)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR6_ENABLE                (0x00000001)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR7                       8:8
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR7_DISABLE               (0x00000000)
#define NVC87E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR7_ENABLE                (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS                                       (0x00000374)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW(i)              ((i)+0):((i)+0)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW__SIZE_1         32
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW_DISABLE         (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW_ENABLE          (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW0                0:0
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW0_DISABLE        (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW0_ENABLE         (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW1                1:1
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW1_DISABLE        (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW1_ENABLE         (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW2                2:2
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW2_DISABLE        (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW2_ENABLE         (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW3                3:3
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW3_DISABLE        (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW3_ENABLE         (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW4                4:4
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW4_DISABLE        (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW4_ENABLE         (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW5                5:5
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW5_DISABLE        (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW5_ENABLE         (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW6                6:6
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW6_DISABLE        (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW6_ENABLE         (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW7                7:7
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW7_DISABLE        (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW7_ENABLE         (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW8                8:8
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW8_DISABLE        (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW8_ENABLE         (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW9                9:9
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW9_DISABLE        (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW9_ENABLE         (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW10               10:10
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW10_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW10_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW11               11:11
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW11_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW11_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW12               12:12
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW12_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW12_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW13               13:13
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW13_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW13_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW14               14:14
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW14_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW14_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW15               15:15
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW15_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW15_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW16               16:16
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW16_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW16_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW17               17:17
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW17_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW17_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW18               18:18
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW18_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW18_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW19               19:19
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW19_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW19_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW20               20:20
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW20_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW20_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW21               21:21
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW21_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW21_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW22               22:22
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW22_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW22_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW23               23:23
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW23_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW23_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW24               24:24
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW24_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW24_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW25               25:25
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW25_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW25_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW26               26:26
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW26_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW26_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW27               27:27
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW27_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW27_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW28               28:28
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW28_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW28_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW29               29:29
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW29_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW29_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW30               30:30
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW30_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW30_ENABLE        (0x00000001)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW31               31:31
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW31_DISABLE       (0x00000000)
#define NVC87E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW31_ENABLE        (0x00000001)
#define NVC87E_SET_EXT_PACKET_CONTROL                                           (0x00000398)
#define NVC87E_SET_EXT_PACKET_CONTROL_ENABLE                                    0:0
#define NVC87E_SET_EXT_PACKET_CONTROL_ENABLE_DISABLE                            (0x00000000)
#define NVC87E_SET_EXT_PACKET_CONTROL_ENABLE_ENABLE                             (0x00000001)
#define NVC87E_SET_EXT_PACKET_CONTROL_LOCATION                                  4:4
#define NVC87E_SET_EXT_PACKET_CONTROL_LOCATION_VSYNC                            (0x00000000)
#define NVC87E_SET_EXT_PACKET_CONTROL_LOCATION_VBLANK                           (0x00000001)
#define NVC87E_SET_EXT_PACKET_CONTROL_FREQUENCY                                 8:8
#define NVC87E_SET_EXT_PACKET_CONTROL_FREQUENCY_EVERY_FRAME                     (0x00000000)
#define NVC87E_SET_EXT_PACKET_CONTROL_FREQUENCY_ONCE                            (0x00000001)
#define NVC87E_SET_EXT_PACKET_CONTROL_HEADER_OVERRIDE                           12:12
#define NVC87E_SET_EXT_PACKET_CONTROL_HEADER_OVERRIDE_DISABLE                   (0x00000000)
#define NVC87E_SET_EXT_PACKET_CONTROL_HEADER_OVERRIDE_ENABLE                    (0x00000001)
#define NVC87E_SET_EXT_PACKET_CONTROL_SIZE                                      27:16
#define NVC87E_SET_EXT_PACKET_DATA                                              (0x0000039C)
#define NVC87E_SET_EXT_PACKET_DATA_DB0                                          7:0
#define NVC87E_SET_EXT_PACKET_DATA_DB1                                          15:8
#define NVC87E_SET_EXT_PACKET_DATA_DB2                                          23:16
#define NVC87E_SET_EXT_PACKET_DATA_DB3                                          31:24
#define NVC87E_SET_FMT_COEFFICIENT_C00                                          (0x00000400)
#define NVC87E_SET_FMT_COEFFICIENT_C00_VALUE                                    20:0
#define NVC87E_SET_FMT_COEFFICIENT_C01                                          (0x00000404)
#define NVC87E_SET_FMT_COEFFICIENT_C01_VALUE                                    20:0
#define NVC87E_SET_FMT_COEFFICIENT_C02                                          (0x00000408)
#define NVC87E_SET_FMT_COEFFICIENT_C02_VALUE                                    20:0
#define NVC87E_SET_FMT_COEFFICIENT_C03                                          (0x0000040C)
#define NVC87E_SET_FMT_COEFFICIENT_C03_VALUE                                    20:0
#define NVC87E_SET_FMT_COEFFICIENT_C10                                          (0x00000410)
#define NVC87E_SET_FMT_COEFFICIENT_C10_VALUE                                    20:0
#define NVC87E_SET_FMT_COEFFICIENT_C11                                          (0x00000414)
#define NVC87E_SET_FMT_COEFFICIENT_C11_VALUE                                    20:0
#define NVC87E_SET_FMT_COEFFICIENT_C12                                          (0x00000418)
#define NVC87E_SET_FMT_COEFFICIENT_C12_VALUE                                    20:0
#define NVC87E_SET_FMT_COEFFICIENT_C13                                          (0x0000041C)
#define NVC87E_SET_FMT_COEFFICIENT_C13_VALUE                                    20:0
#define NVC87E_SET_FMT_COEFFICIENT_C20                                          (0x00000420)
#define NVC87E_SET_FMT_COEFFICIENT_C20_VALUE                                    20:0
#define NVC87E_SET_FMT_COEFFICIENT_C21                                          (0x00000424)
#define NVC87E_SET_FMT_COEFFICIENT_C21_VALUE                                    20:0
#define NVC87E_SET_FMT_COEFFICIENT_C22                                          (0x00000428)
#define NVC87E_SET_FMT_COEFFICIENT_C22_VALUE                                    20:0
#define NVC87E_SET_FMT_COEFFICIENT_C23                                          (0x0000042C)
#define NVC87E_SET_FMT_COEFFICIENT_C23_VALUE                                    20:0
#define NVC87E_SET_ILUT_CONTROL                                                 (0x00000440)
#define NVC87E_SET_ILUT_CONTROL_INTERPOLATE                                     0:0
#define NVC87E_SET_ILUT_CONTROL_INTERPOLATE_DISABLE                             (0x00000000)
#define NVC87E_SET_ILUT_CONTROL_INTERPOLATE_ENABLE                              (0x00000001)
#define NVC87E_SET_ILUT_CONTROL_MIRROR                                          1:1
#define NVC87E_SET_ILUT_CONTROL_MIRROR_DISABLE                                  (0x00000000)
#define NVC87E_SET_ILUT_CONTROL_MIRROR_ENABLE                                   (0x00000001)
#define NVC87E_SET_ILUT_CONTROL_MODE                                            3:2
#define NVC87E_SET_ILUT_CONTROL_MODE_SEGMENTED                                  (0x00000000)
#define NVC87E_SET_ILUT_CONTROL_MODE_DIRECT8                                    (0x00000001)
#define NVC87E_SET_ILUT_CONTROL_MODE_DIRECT10                                   (0x00000002)
#define NVC87E_SET_ILUT_CONTROL_SIZE                                            18:8
#define NVC87E_SET_CONTEXT_DMA_ILUT                                             (0x00000444)
#define NVC87E_SET_CONTEXT_DMA_ILUT_HANDLE                                      31:0
#define NVC87E_SET_OFFSET_ILUT                                                  (0x00000448)
#define NVC87E_SET_OFFSET_ILUT_ORIGIN                                           31:0
#define NVC87E_SET_CSC00CONTROL                                                 (0x0000045C)
#define NVC87E_SET_CSC00CONTROL_ENABLE                                          0:0
#define NVC87E_SET_CSC00CONTROL_ENABLE_DISABLE                                  (0x00000000)
#define NVC87E_SET_CSC00CONTROL_ENABLE_ENABLE                                   (0x00000001)
#define NVC87E_SET_CSC00COEFFICIENT_C00                                         (0x00000460)
#define NVC87E_SET_CSC00COEFFICIENT_C00_VALUE                                   20:0
#define NVC87E_SET_CSC00COEFFICIENT_C01                                         (0x00000464)
#define NVC87E_SET_CSC00COEFFICIENT_C01_VALUE                                   20:0
#define NVC87E_SET_CSC00COEFFICIENT_C02                                         (0x00000468)
#define NVC87E_SET_CSC00COEFFICIENT_C02_VALUE                                   20:0
#define NVC87E_SET_CSC00COEFFICIENT_C03                                         (0x0000046C)
#define NVC87E_SET_CSC00COEFFICIENT_C03_VALUE                                   20:0
#define NVC87E_SET_CSC00COEFFICIENT_C10                                         (0x00000470)
#define NVC87E_SET_CSC00COEFFICIENT_C10_VALUE                                   20:0
#define NVC87E_SET_CSC00COEFFICIENT_C11                                         (0x00000474)
#define NVC87E_SET_CSC00COEFFICIENT_C11_VALUE                                   20:0
#define NVC87E_SET_CSC00COEFFICIENT_C12                                         (0x00000478)
#define NVC87E_SET_CSC00COEFFICIENT_C12_VALUE                                   20:0
#define NVC87E_SET_CSC00COEFFICIENT_C13                                         (0x0000047C)
#define NVC87E_SET_CSC00COEFFICIENT_C13_VALUE                                   20:0
#define NVC87E_SET_CSC00COEFFICIENT_C20                                         (0x00000480)
#define NVC87E_SET_CSC00COEFFICIENT_C20_VALUE                                   20:0
#define NVC87E_SET_CSC00COEFFICIENT_C21                                         (0x00000484)
#define NVC87E_SET_CSC00COEFFICIENT_C21_VALUE                                   20:0
#define NVC87E_SET_CSC00COEFFICIENT_C22                                         (0x00000488)
#define NVC87E_SET_CSC00COEFFICIENT_C22_VALUE                                   20:0
#define NVC87E_SET_CSC00COEFFICIENT_C23                                         (0x0000048C)
#define NVC87E_SET_CSC00COEFFICIENT_C23_VALUE                                   20:0
#define NVC87E_SET_CSC0LUT_CONTROL                                              (0x000004A0)
#define NVC87E_SET_CSC0LUT_CONTROL_INTERPOLATE                                  0:0
#define NVC87E_SET_CSC0LUT_CONTROL_INTERPOLATE_DISABLE                          (0x00000000)
#define NVC87E_SET_CSC0LUT_CONTROL_INTERPOLATE_ENABLE                           (0x00000001)
#define NVC87E_SET_CSC0LUT_CONTROL_MIRROR                                       1:1
#define NVC87E_SET_CSC0LUT_CONTROL_MIRROR_DISABLE                               (0x00000000)
#define NVC87E_SET_CSC0LUT_CONTROL_MIRROR_ENABLE                                (0x00000001)
#define NVC87E_SET_CSC0LUT_CONTROL_ENABLE                                       4:4
#define NVC87E_SET_CSC0LUT_CONTROL_ENABLE_DISABLE                               (0x00000000)
#define NVC87E_SET_CSC0LUT_CONTROL_ENABLE_ENABLE                                (0x00000001)
#define NVC87E_SET_CSC0LUT_SEGMENT_SIZE                                         (0x000004A4)
#define NVC87E_SET_CSC0LUT_SEGMENT_SIZE_IDX                                     5:0
#define NVC87E_SET_CSC0LUT_SEGMENT_SIZE_VALUE                                   18:16
#define NVC87E_SET_CSC0LUT_ENTRY                                                (0x000004A8)
#define NVC87E_SET_CSC0LUT_ENTRY_IDX                                            10:0
#define NVC87E_SET_CSC0LUT_ENTRY_VALUE                                          31:16
#define NVC87E_SET_CSC01CONTROL                                                 (0x000004BC)
#define NVC87E_SET_CSC01CONTROL_ENABLE                                          0:0
#define NVC87E_SET_CSC01CONTROL_ENABLE_DISABLE                                  (0x00000000)
#define NVC87E_SET_CSC01CONTROL_ENABLE_ENABLE                                   (0x00000001)
#define NVC87E_SET_CSC01COEFFICIENT_C00                                         (0x000004C0)
#define NVC87E_SET_CSC01COEFFICIENT_C00_VALUE                                   20:0
#define NVC87E_SET_CSC01COEFFICIENT_C01                                         (0x000004C4)
#define NVC87E_SET_CSC01COEFFICIENT_C01_VALUE                                   20:0
#define NVC87E_SET_CSC01COEFFICIENT_C02                                         (0x000004C8)
#define NVC87E_SET_CSC01COEFFICIENT_C02_VALUE                                   20:0
#define NVC87E_SET_CSC01COEFFICIENT_C03                                         (0x000004CC)
#define NVC87E_SET_CSC01COEFFICIENT_C03_VALUE                                   20:0
#define NVC87E_SET_CSC01COEFFICIENT_C10                                         (0x000004D0)
#define NVC87E_SET_CSC01COEFFICIENT_C10_VALUE                                   20:0
#define NVC87E_SET_CSC01COEFFICIENT_C11                                         (0x000004D4)
#define NVC87E_SET_CSC01COEFFICIENT_C11_VALUE                                   20:0
#define NVC87E_SET_CSC01COEFFICIENT_C12                                         (0x000004D8)
#define NVC87E_SET_CSC01COEFFICIENT_C12_VALUE                                   20:0
#define NVC87E_SET_CSC01COEFFICIENT_C13                                         (0x000004DC)
#define NVC87E_SET_CSC01COEFFICIENT_C13_VALUE                                   20:0
#define NVC87E_SET_CSC01COEFFICIENT_C20                                         (0x000004E0)
#define NVC87E_SET_CSC01COEFFICIENT_C20_VALUE                                   20:0
#define NVC87E_SET_CSC01COEFFICIENT_C21                                         (0x000004E4)
#define NVC87E_SET_CSC01COEFFICIENT_C21_VALUE                                   20:0
#define NVC87E_SET_CSC01COEFFICIENT_C22                                         (0x000004E8)
#define NVC87E_SET_CSC01COEFFICIENT_C22_VALUE                                   20:0
#define NVC87E_SET_CSC01COEFFICIENT_C23                                         (0x000004EC)
#define NVC87E_SET_CSC01COEFFICIENT_C23_VALUE                                   20:0
#define NVC87E_SET_TMO_CONTROL                                                  (0x00000500)
#define NVC87E_SET_TMO_CONTROL_INTERPOLATE                                      0:0
#define NVC87E_SET_TMO_CONTROL_INTERPOLATE_DISABLE                              (0x00000000)
#define NVC87E_SET_TMO_CONTROL_INTERPOLATE_ENABLE                               (0x00000001)
#define NVC87E_SET_TMO_CONTROL_SAT_MODE                                         3:2
#define NVC87E_SET_TMO_CONTROL_SIZE                                             18:8
#define NVC87E_SET_TMO_LOW_INTENSITY_ZONE                                       (0x00000508)
#define NVC87E_SET_TMO_LOW_INTENSITY_ZONE_END                                   29:16
#define NVC87E_SET_TMO_LOW_INTENSITY_VALUE                                      (0x0000050C)
#define NVC87E_SET_TMO_LOW_INTENSITY_VALUE_LIN_WEIGHT                           8:0
#define NVC87E_SET_TMO_LOW_INTENSITY_VALUE_NON_LIN_WEIGHT                       20:12
#define NVC87E_SET_TMO_LOW_INTENSITY_VALUE_THRESHOLD                            31:24
#define NVC87E_SET_TMO_MEDIUM_INTENSITY_ZONE                                    (0x00000510)
#define NVC87E_SET_TMO_MEDIUM_INTENSITY_ZONE_START                              13:0
#define NVC87E_SET_TMO_MEDIUM_INTENSITY_ZONE_END                                29:16
#define NVC87E_SET_TMO_MEDIUM_INTENSITY_VALUE                                   (0x00000514)
#define NVC87E_SET_TMO_MEDIUM_INTENSITY_VALUE_LIN_WEIGHT                        8:0
#define NVC87E_SET_TMO_MEDIUM_INTENSITY_VALUE_NON_LIN_WEIGHT                    20:12
#define NVC87E_SET_TMO_MEDIUM_INTENSITY_VALUE_THRESHOLD                         31:24
#define NVC87E_SET_TMO_HIGH_INTENSITY_ZONE                                      (0x00000518)
#define NVC87E_SET_TMO_HIGH_INTENSITY_ZONE_START                                13:0
#define NVC87E_SET_TMO_HIGH_INTENSITY_VALUE                                     (0x0000051C)
#define NVC87E_SET_TMO_HIGH_INTENSITY_VALUE_LIN_WEIGHT                          8:0
#define NVC87E_SET_TMO_HIGH_INTENSITY_VALUE_NON_LIN_WEIGHT                      20:12
#define NVC87E_SET_TMO_HIGH_INTENSITY_VALUE_THRESHOLD                           31:24
#define NVC87E_SET_CONTEXT_DMA_TMO_LUT                                          (0x00000528)
#define NVC87E_SET_CONTEXT_DMA_TMO_LUT_HANDLE                                   31:0
#define NVC87E_SET_OFFSET_TMO_LUT                                               (0x0000052C)
#define NVC87E_SET_OFFSET_TMO_LUT_ORIGIN                                        31:0
#define NVC87E_SET_CSC10CONTROL                                                 (0x0000053C)
#define NVC87E_SET_CSC10CONTROL_ENABLE                                          0:0
#define NVC87E_SET_CSC10CONTROL_ENABLE_DISABLE                                  (0x00000000)
#define NVC87E_SET_CSC10CONTROL_ENABLE_ENABLE                                   (0x00000001)
#define NVC87E_SET_CSC10COEFFICIENT_C00                                         (0x00000540)
#define NVC87E_SET_CSC10COEFFICIENT_C00_VALUE                                   20:0
#define NVC87E_SET_CSC10COEFFICIENT_C01                                         (0x00000544)
#define NVC87E_SET_CSC10COEFFICIENT_C01_VALUE                                   20:0
#define NVC87E_SET_CSC10COEFFICIENT_C02                                         (0x00000548)
#define NVC87E_SET_CSC10COEFFICIENT_C02_VALUE                                   20:0
#define NVC87E_SET_CSC10COEFFICIENT_C03                                         (0x0000054C)
#define NVC87E_SET_CSC10COEFFICIENT_C03_VALUE                                   20:0
#define NVC87E_SET_CSC10COEFFICIENT_C10                                         (0x00000550)
#define NVC87E_SET_CSC10COEFFICIENT_C10_VALUE                                   20:0
#define NVC87E_SET_CSC10COEFFICIENT_C11                                         (0x00000554)
#define NVC87E_SET_CSC10COEFFICIENT_C11_VALUE                                   20:0
#define NVC87E_SET_CSC10COEFFICIENT_C12                                         (0x00000558)
#define NVC87E_SET_CSC10COEFFICIENT_C12_VALUE                                   20:0
#define NVC87E_SET_CSC10COEFFICIENT_C13                                         (0x0000055C)
#define NVC87E_SET_CSC10COEFFICIENT_C13_VALUE                                   20:0
#define NVC87E_SET_CSC10COEFFICIENT_C20                                         (0x00000560)
#define NVC87E_SET_CSC10COEFFICIENT_C20_VALUE                                   20:0
#define NVC87E_SET_CSC10COEFFICIENT_C21                                         (0x00000564)
#define NVC87E_SET_CSC10COEFFICIENT_C21_VALUE                                   20:0
#define NVC87E_SET_CSC10COEFFICIENT_C22                                         (0x00000568)
#define NVC87E_SET_CSC10COEFFICIENT_C22_VALUE                                   20:0
#define NVC87E_SET_CSC10COEFFICIENT_C23                                         (0x0000056C)
#define NVC87E_SET_CSC10COEFFICIENT_C23_VALUE                                   20:0
#define NVC87E_SET_CSC1LUT_CONTROL                                              (0x00000580)
#define NVC87E_SET_CSC1LUT_CONTROL_INTERPOLATE                                  0:0
#define NVC87E_SET_CSC1LUT_CONTROL_INTERPOLATE_DISABLE                          (0x00000000)
#define NVC87E_SET_CSC1LUT_CONTROL_INTERPOLATE_ENABLE                           (0x00000001)
#define NVC87E_SET_CSC1LUT_CONTROL_MIRROR                                       1:1
#define NVC87E_SET_CSC1LUT_CONTROL_MIRROR_DISABLE                               (0x00000000)
#define NVC87E_SET_CSC1LUT_CONTROL_MIRROR_ENABLE                                (0x00000001)
#define NVC87E_SET_CSC1LUT_CONTROL_ENABLE                                       4:4
#define NVC87E_SET_CSC1LUT_CONTROL_ENABLE_DISABLE                               (0x00000000)
#define NVC87E_SET_CSC1LUT_CONTROL_ENABLE_ENABLE                                (0x00000001)
#define NVC87E_SET_CSC1LUT_SEGMENT_SIZE                                         (0x00000584)
#define NVC87E_SET_CSC1LUT_SEGMENT_SIZE_IDX                                     5:0
#define NVC87E_SET_CSC1LUT_SEGMENT_SIZE_VALUE                                   18:16
#define NVC87E_SET_CSC1LUT_ENTRY                                                (0x00000588)
#define NVC87E_SET_CSC1LUT_ENTRY_IDX                                            10:0
#define NVC87E_SET_CSC1LUT_ENTRY_VALUE                                          31:16
#define NVC87E_SET_CSC11CONTROL                                                 (0x0000059C)
#define NVC87E_SET_CSC11CONTROL_ENABLE                                          0:0
#define NVC87E_SET_CSC11CONTROL_ENABLE_DISABLE                                  (0x00000000)
#define NVC87E_SET_CSC11CONTROL_ENABLE_ENABLE                                   (0x00000001)
#define NVC87E_SET_CSC11COEFFICIENT_C00                                         (0x000005A0)
#define NVC87E_SET_CSC11COEFFICIENT_C00_VALUE                                   20:0
#define NVC87E_SET_CSC11COEFFICIENT_C01                                         (0x000005A4)
#define NVC87E_SET_CSC11COEFFICIENT_C01_VALUE                                   20:0
#define NVC87E_SET_CSC11COEFFICIENT_C02                                         (0x000005A8)
#define NVC87E_SET_CSC11COEFFICIENT_C02_VALUE                                   20:0
#define NVC87E_SET_CSC11COEFFICIENT_C03                                         (0x000005AC)
#define NVC87E_SET_CSC11COEFFICIENT_C03_VALUE                                   20:0
#define NVC87E_SET_CSC11COEFFICIENT_C10                                         (0x000005B0)
#define NVC87E_SET_CSC11COEFFICIENT_C10_VALUE                                   20:0
#define NVC87E_SET_CSC11COEFFICIENT_C11                                         (0x000005B4)
#define NVC87E_SET_CSC11COEFFICIENT_C11_VALUE                                   20:0
#define NVC87E_SET_CSC11COEFFICIENT_C12                                         (0x000005B8)
#define NVC87E_SET_CSC11COEFFICIENT_C12_VALUE                                   20:0
#define NVC87E_SET_CSC11COEFFICIENT_C13                                         (0x000005BC)
#define NVC87E_SET_CSC11COEFFICIENT_C13_VALUE                                   20:0
#define NVC87E_SET_CSC11COEFFICIENT_C20                                         (0x000005C0)
#define NVC87E_SET_CSC11COEFFICIENT_C20_VALUE                                   20:0
#define NVC87E_SET_CSC11COEFFICIENT_C21                                         (0x000005C4)
#define NVC87E_SET_CSC11COEFFICIENT_C21_VALUE                                   20:0
#define NVC87E_SET_CSC11COEFFICIENT_C22                                         (0x000005C8)
#define NVC87E_SET_CSC11COEFFICIENT_C22_VALUE                                   20:0
#define NVC87E_SET_CSC11COEFFICIENT_C23                                         (0x000005CC)
#define NVC87E_SET_CSC11COEFFICIENT_C23_VALUE                                   20:0
#define NVC87E_SET_CLAMP_RANGE                                                  (0x000005D0)
#define NVC87E_SET_CLAMP_RANGE_LOW                                              15:0
#define NVC87E_SET_CLAMP_RANGE_HIGH                                             31:16
#define NVC87E_SW_RESERVED(b)                                                   (0x000005D4 + (b)*0x00000004)
#define NVC87E_SW_RESERVED_VALUE                                                31:0

#ifdef __cplusplus
};     /* extern "C" */
#endif
#endif // _clC87e_h
