/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.net.URI;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IDPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.IndexedEndpointType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.SSODescriptorType;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.core.saml.v2.util.SAMLMetadataUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IDPMetadataDescriptor {
    public static String getIDPDescriptor(URI loginPostEndpoint, URI loginRedirectEndpoint, URI logoutEndpoint, URI artifactResolutionService, String entityId, boolean wantAuthnRequestsSigned, List<Element> signingCerts) throws ProcessingException {
        return IDPMetadataDescriptor.getIDPDescriptor(null, null, loginPostEndpoint, loginRedirectEndpoint, logoutEndpoint, artifactResolutionService, entityId, wantAuthnRequestsSigned, signingCerts, null);
    }

    public static String getIDPDescriptor(KeyWrapper keyWrapper, SignatureAlgorithm sigAlg, URI loginPostEndpoint, URI loginRedirectEndpoint, URI logoutEndpoint, URI artifactResolutionService, String entityId, boolean wantAuthnRequestsSigned, List<Element> signingCerts) throws ProcessingException {
        return IDPMetadataDescriptor.getIDPDescriptor(null, null, loginPostEndpoint, loginRedirectEndpoint, logoutEndpoint, artifactResolutionService, entityId, wantAuthnRequestsSigned, signingCerts, null);
    }

    public static String getIDPDescriptor(KeyWrapper keyWrapper, SignatureAlgorithm sigAlg, URI loginPostEndpoint, URI loginRedirectEndpoint, URI logoutEndpoint, URI artifactResolutionService, String entityId, boolean wantAuthnRequestsSigned, List<Element> signingCerts, Long expiration) throws ProcessingException {
        EntityDescriptorType entityDescriptor = new EntityDescriptorType(entityId);
        if (expiration != null) {
            try {
                Duration cacheDuration = DatatypeFactory.newInstance().newDuration(TimeUnit.SECONDS.toMillis(expiration));
                entityDescriptor.setCacheDuration(cacheDuration);
            }
            catch (DatatypeConfigurationException e) {
                throw new ProcessingException("Cannot create datatype factory to create duration", (Throwable)e);
            }
        }
        IDPSSODescriptorType spIDPDescriptor = new IDPSSODescriptorType(Arrays.asList(JBossSAMLURIConstants.PROTOCOL_NSURI.get()));
        spIDPDescriptor.setWantAuthnRequestsSigned(Boolean.valueOf(wantAuthnRequestsSigned));
        spIDPDescriptor.addNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get());
        spIDPDescriptor.addNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get());
        spIDPDescriptor.addNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get());
        spIDPDescriptor.addNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get());
        spIDPDescriptor.addSingleLogoutService(new EndpointType(JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.getUri(), logoutEndpoint));
        spIDPDescriptor.addSingleLogoutService(new EndpointType(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri(), logoutEndpoint));
        spIDPDescriptor.addSingleLogoutService(new EndpointType(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri(), logoutEndpoint));
        spIDPDescriptor.addSingleLogoutService(new EndpointType(JBossSAMLURIConstants.SAML_SOAP_BINDING.getUri(), logoutEndpoint));
        spIDPDescriptor.addSingleSignOnService(new EndpointType(JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.getUri(), loginPostEndpoint));
        spIDPDescriptor.addSingleSignOnService(new EndpointType(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri(), loginRedirectEndpoint));
        spIDPDescriptor.addSingleSignOnService(new EndpointType(JBossSAMLURIConstants.SAML_SOAP_BINDING.getUri(), loginPostEndpoint));
        spIDPDescriptor.addSingleSignOnService(new EndpointType(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri(), loginPostEndpoint));
        spIDPDescriptor.addArtifactResolutionService(new IndexedEndpointType(JBossSAMLURIConstants.SAML_SOAP_BINDING.getUri(), artifactResolutionService));
        if (wantAuthnRequestsSigned && signingCerts != null) {
            for (Element key : signingCerts) {
                KeyDescriptorType keyDescriptor = new KeyDescriptorType();
                keyDescriptor.setUse(KeyTypes.SIGNING);
                keyDescriptor.setKeyInfo(key);
                spIDPDescriptor.addKeyDescriptor(keyDescriptor);
            }
        }
        entityDescriptor.addChoiceType(new EntityDescriptorType.EDTChoiceType(Arrays.asList(new EntityDescriptorType.EDTDescriptorChoiceType((SSODescriptorType)spIDPDescriptor))));
        if (sigAlg != null && keyWrapper != null && keyWrapper.getCertificate() != null && keyWrapper.getPrivateKey() != null) {
            try {
                return SAMLMetadataUtil.signEntityDescriptorType((EntityDescriptorType)entityDescriptor, (SignatureAlgorithm)sigAlg, (String)keyWrapper.getKid(), (X509Certificate)keyWrapper.getCertificate(), (KeyPair)new KeyPair(keyWrapper.getCertificate().getPublicKey(), (PrivateKey)keyWrapper.getPrivateKey()));
            }
            catch (ConfigurationException | ParsingException e) {
                throw new ProcessingException("Cannot sign IDP metadata with key " + keyWrapper.getKid(), e);
            }
        }
        return SAMLMetadataUtil.writeEntityDescriptorType((EntityDescriptorType)entityDescriptor);
    }

    public static Element buildKeyInfoElement(String keyName, String pemEncodedCertificate) throws ParserConfigurationException {
        DocumentBuilder db = DocumentUtil.getDocumentBuilder();
        Document doc = db.newDocument();
        Element keyInfo = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:KeyInfo");
        if (keyName != null) {
            Element keyNameElement = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:KeyName");
            keyNameElement.setTextContent(keyName);
            keyInfo.appendChild(keyNameElement);
        }
        Element x509Data = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:X509Data");
        Element x509Certificate = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:X509Certificate");
        x509Certificate.setTextContent(pemEncodedCertificate);
        x509Data.appendChild(x509Certificate);
        keyInfo.appendChild(x509Data);
        return keyInfo;
    }
}

