/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ServiceAttributes;
import io.opentelemetry.semconv.incubating.HostIncubatingAttributes;
import io.quarkus.opentelemetry.runtime.OpenTelemetryUtil;
import java.util.List;

public class TracerUtil {
    private TracerUtil() {
    }

    public static Resource mapResourceAttributes(List<String> resourceAttributes, String serviceName, String hostname) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        if (!resourceAttributes.isEmpty()) {
            OpenTelemetryUtil.convertKeyValueListToMap(resourceAttributes).forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        }
        if (serviceName != null) {
            attributesBuilder.put(ServiceAttributes.SERVICE_NAME.getKey(), serviceName);
        }
        if (hostname != null) {
            attributesBuilder.put(HostIncubatingAttributes.HOST_NAME, (Object)hostname);
        }
        return Resource.create((Attributes)attributesBuilder.build());
    }
}

