/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import java.io.IOException;
import java.io.InputStream;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;

class LscpInputStream {
    private InputStream in;
    private StringBuffer buf = new StringBuffer();

    public LscpInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public synchronized String readLine() throws IOException, LscpException {
        int n;
        this.buf.setLength(0);
        while ((n = this.in.read()) != -1) {
            if (n == 13) {
                this.checkLF();
                break;
            }
            this.buf.append((char)n);
        }
        if (n == -1) {
            if (this.buf.length() > 0) {
                throw new LscpException(LscpI18n.getLogMsg("LscpInputStream.EOL!"));
            }
            return null;
        }
        return this.buf.toString();
    }

    public synchronized int available() throws IOException {
        return this.in.available();
    }

    private void skipLine() throws IOException, LscpException {
        int n;
        while ((n = this.in.read()) != -1) {
            if (n != 13) continue;
            this.checkLF();
            break;
        }
    }

    private void checkLF() throws IOException, LscpException {
        int n = this.in.read();
        if (n == -1) {
            throw new LscpException(LscpI18n.getLogMsg("LscpInputStream.EOF!"));
        }
        if (n != 10) {
            throw new LscpException(LscpI18n.getLogMsg("LscpInputStream.EOL!"));
        }
    }
}

