/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.watch;

import db.Transaction;
import ghidra.app.plugin.core.debug.gui.watch.DebuggerWatchesProvider;
import ghidra.app.plugin.core.debug.gui.watch.SavedSettings;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.services.DebuggerControlService;
import ghidra.async.AsyncUtils;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.debug.api.watch.WatchRow;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.pcode.exec.DebuggerPcodeUtils;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExpression;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeEncodeException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class DefaultWatchRow
implements WatchRow {
    public static final int TRUNCATE_BYTES_LENGTH = 64;
    private static final String KEY_EXPRESSION = "expression";
    private static final String KEY_DATA_TYPE = "dataType";
    private static final String KEY_SETTINGS = "settings";
    private final DebuggerWatchesProvider provider;
    private final Object lock = new Object();
    private String expression;
    private String typePath;
    private DataType dataType;
    private SettingsImpl settings = new SettingsImpl();
    private SavedSettings savedSettings = new SavedSettings((Settings)this.settings);
    private volatile PcodeExpression compiled;
    private volatile TraceMemoryState state;
    private volatile Address address;
    private volatile Symbol symbol;
    private volatile AddressSetView reads;
    private volatile byte[] value;
    private volatile byte[] prevValue;
    private volatile String valueString;
    private volatile Object valueObj;
    private volatile Throwable error = null;

    public DefaultWatchRow(DebuggerWatchesProvider provider, String expression) {
        this.provider = provider;
        this.expression = expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void blank() {
        Object object = this.lock;
        synchronized (object) {
            this.state = null;
            this.address = null;
            this.symbol = null;
            this.reads = null;
            this.value = null;
            this.valueString = null;
            this.valueObj = null;
        }
    }

    protected void recompile() {
        this.compiled = null;
        this.error = null;
        if (this.provider.language == null) {
            return;
        }
        if (this.expression == null || this.expression.length() == 0) {
            return;
        }
        try {
            this.compiled = DebuggerPcodeUtils.compileExpression((ServiceProvider)this.provider.getTool(), this.provider.current, this.expression);
        }
        catch (Exception e) {
            this.error = e;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reevaluate() {
        String expression;
        PcodeExecutor<byte[]> prevExec;
        PcodeExecutor<DebuggerPcodeUtils.WatchValue> executor;
        Object object = this.lock;
        synchronized (object) {
            this.blank();
            executor = this.provider.asyncWatchExecutor;
            prevExec = this.provider.prevValueExecutor;
            if (executor == null) {
                this.provider.contextChanged();
                return;
            }
            expression = this.expression;
        }
        ((CompletableFuture)CompletableFuture.runAsync(() -> {
            byte[] prevValue;
            Object object = this.lock;
            synchronized (object) {
                this.recompile();
                if (this.compiled == null) {
                    return;
                }
            }
            DebuggerPcodeUtils.WatchValue fullValue = (DebuggerPcodeUtils.WatchValue)this.compiled.evaluate(executor);
            try {
                prevValue = prevExec == null ? null : (byte[])this.compiled.evaluate(prevExec);
            }
            catch (Exception e) {
                Msg.trace((Object)this, (Object)"Error in evaluating previous value. Ignoring.", (Throwable)e);
                prevValue = null;
            }
            Object object2 = this.lock;
            synchronized (object2) {
                if (executor != this.provider.asyncWatchExecutor) {
                    return;
                }
                if (!Objects.equals(expression, this.expression)) {
                    return;
                }
                TracePlatform platform = this.provider.current.getPlatform();
                this.prevValue = prevValue;
                this.value = fullValue.bytes().bytes();
                this.error = null;
                this.state = fullValue.state();
                this.address = platform.mapGuestToHost(fullValue.address());
                this.symbol = this.computeSymbol();
                this.reads = fullValue.reads();
                this.valueObj = this.parseAsDataTypeObj();
                this.valueString = this.parseAsDataTypeStr();
            }
        }, this.provider.workQueue).exceptionally(e -> {
            this.error = e;
            return null;
        })).thenRunAsync(() -> {
            this.provider.watchTableModel.fireTableDataChanged();
            this.provider.contextChanged();
        }, AsyncUtils.SWING_EXECUTOR);
    }

    private ByteMemBufferImpl createMemBuffer() {
        return new ByteMemBufferImpl(this.address, this.value, this.provider.language.isBigEndian()){

            public Memory getMemory() {
                return DefaultWatchRow.this.provider.current.getTrace().getProgramView().getMemory();
            }
        };
    }

    protected String parseAsDataTypeStr() {
        if (this.dataType == null || this.value == null) {
            return "";
        }
        ByteMemBufferImpl buffer = this.createMemBuffer();
        return this.dataType.getRepresentation((MemBuffer)buffer, (Settings)this.settings, this.value.length);
    }

    protected Object parseAsDataTypeObj() {
        if (this.dataType == null || this.value == null) {
            return null;
        }
        ByteMemBufferImpl buffer = this.createMemBuffer();
        return this.dataType.getValue((MemBuffer)buffer, (Settings)this.settings, this.value.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpression(String expression) {
        Object object = this.lock;
        synchronized (object) {
            if (!Objects.equals(this.expression, expression)) {
                this.prevValue = null;
            }
            this.expression = expression;
            this.compiled = null;
            this.reevaluate();
        }
    }

    public String getExpression() {
        return this.expression;
    }

    protected void updateType() {
        DataTypeManagerService dtms;
        this.dataType = null;
        if (this.typePath == null) {
            return;
        }
        Trace trace = this.provider.current.getTrace();
        if (trace != null) {
            this.dataType = trace.getDataTypeManager().getDataType(this.typePath);
            if (this.dataType != null) {
                return;
            }
        }
        if ((dtms = (DataTypeManagerService)this.provider.getTool().getService(DataTypeManagerService.class)) != null) {
            this.dataType = dtms.getBuiltInDataTypesManager().getDataType(this.typePath);
        }
    }

    public void setTypePath(String typePath) {
        this.typePath = typePath;
        this.updateType();
    }

    public String getTypePath() {
        return this.typePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataType(DataType dataType) {
        Object object = this.lock;
        synchronized (object) {
            if (dataType instanceof Pointer) {
                Pointer ptrType = (Pointer)dataType;
                if (this.address != null && this.address.isRegisterAddress()) {
                    AddressSpace space = this.provider.current.getTrace().getBaseAddressFactory().getDefaultAddressSpace();
                    DataTypeManager dtm = ptrType.getDataTypeManager();
                    dataType = new PointerTypedef(null, ptrType.getDataType(), ptrType.getLength(), dtm, space);
                    if (dtm != null) {
                        try (Transaction tid = dtm.openTransaction("Resolve data type");){
                            dataType = dtm.resolve(dataType, DataTypeConflictHandler.DEFAULT_HANDLER);
                        }
                    }
                }
            }
            this.typePath = dataType == null ? null : dataType.getPathName();
            this.dataType = dataType;
            this.settings.setDefaultSettings(dataType == null ? null : dataType.getDefaultSettings());
            this.valueString = this.parseAsDataTypeStr();
            this.valueObj = this.parseAsDataTypeObj();
            this.provider.contextChanged();
            if (dataType != null) {
                this.savedSettings.read(dataType.getSettingsDefinitions(), dataType.getDefaultSettings());
            }
        }
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Settings getSettings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void settingsChanged() {
        Object object = this.lock;
        synchronized (object) {
            if (this.dataType != null) {
                this.savedSettings.write(this.dataType.getSettingsDefinitions(), this.dataType.getDefaultSettings());
            }
            this.valueString = this.parseAsDataTypeStr();
        }
        this.provider.watchTableModel.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address getAddress() {
        Object object = this.lock;
        synchronized (object) {
            return this.address;
        }
    }

    public AddressRange getRange() {
        Object object = this.lock;
        synchronized (object) {
            if (this.address == null || this.value == null) {
                return null;
            }
            if (this.address.isConstantAddress()) {
                return new AddressRangeImpl(this.address, this.address);
            }
            try {
                return new AddressRangeImpl(this.address, (long)this.value.length);
            }
            catch (AddressOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRawValueString() {
        Object object = this.lock;
        synchronized (object) {
            byte[] value = this.value;
            SleighLanguage language = this.provider.language;
            if (value == null || language == null) {
                return "??";
            }
            if (this.address == null || !this.address.getAddressSpace().isMemorySpace()) {
                BigInteger asBigInt = Utils.bytesToBigInteger((byte[])value, (int)value.length, (boolean)this.provider.language.isBigEndian(), (boolean)false);
                return "0x" + asBigInt.toString(16);
            }
            if (value.length > 64) {
                return "{ " + NumericUtilities.convertBytesToString((byte[])value, (int)0, (int)64, (String)" ") + " ... }";
            }
            return "{ " + NumericUtilities.convertBytesToString((byte[])value, (String)" ") + " }";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressSetView getReads() {
        Object object = this.lock;
        synchronized (object) {
            return this.reads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceMemoryState getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getValue() {
        Object object = this.lock;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValueString() {
        Object object = this.lock;
        synchronized (object) {
            return this.valueString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueObject() {
        Object object = this.lock;
        synchronized (object) {
            return this.valueObj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRawValueEditable() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.provider.isEditsEnabled()) {
                return false;
            }
            if (this.address == null) {
                return false;
            }
            DebuggerControlService controlService = this.provider.controlService;
            if (controlService == null) {
                return false;
            }
            DebuggerControlService.StateEditor editor = controlService.createStateEditor(this.provider.current);
            return editor.isVariableEditable(this.address, this.getValueLength());
        }
    }

    public void setRawValueString(String valueString) {
        if (!this.isRawValueEditable()) {
            throw new IllegalStateException("Watch is not editable");
        }
        if ((valueString = valueString.trim()).startsWith("{")) {
            if (!valueString.endsWith("}")) {
                throw new NumberFormatException("Byte array values must be hex enclosed in {}");
            }
            this.setRawValueBytesString(valueString.substring(1, valueString.length() - 1));
            return;
        }
        this.setRawValueIntString(valueString);
    }

    public void setRawValueBytesString(String bytesString) {
        this.setRawValueBytes(NumericUtilities.convertStringToBytes((String)bytesString));
    }

    public void setRawValueIntString(String intString) {
        BigInteger val = (intString = intString.trim()).startsWith("0x") ? new BigInteger(intString.substring(2), 16) : new BigInteger(intString, 10);
        this.setRawValueBytes(Utils.bigIntegerToBytes((BigInteger)val, (int)this.value.length, (boolean)this.provider.language.isBigEndian()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRawValueBytes(byte[] bytes) {
        Object object = this.lock;
        synchronized (object) {
            DebuggerControlService controlService;
            if (this.address == null) {
                throw new IllegalStateException("Cannot write to watch variable without an address");
            }
            if (bytes.length > this.value.length) {
                throw new IllegalArgumentException("Byte arrays cannot exceed length of variable");
            }
            if (bytes.length < this.value.length) {
                byte[] fillOld = Arrays.copyOf(this.value, this.value.length);
                System.arraycopy(bytes, 0, fillOld, 0, bytes.length);
                bytes = fillOld;
            }
            if ((controlService = this.provider.controlService) == null) {
                throw new AssertionError((Object)"No control service");
            }
            DebuggerControlService.StateEditor editor = controlService.createStateEditor(this.provider.current);
            editor.setVariable(this.address, bytes).exceptionally(ex -> {
                Msg.showError((Object)this, null, (String)"Write Failed", (Object)"Could not modify watch value (on target)", (Throwable)ex);
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueString(String valueString) {
        Object object = this.lock;
        synchronized (object) {
            if (this.dataType == null || this.value == null) {
                this.provider.getTool().setStatusInfo("Watch no value or no data type", true);
                return;
            }
            try {
                byte[] encoded = this.dataType.encodeRepresentation(valueString, (MemBuffer)new ByteMemBufferImpl(this.address, this.value, this.provider.language.isBigEndian()), SettingsImpl.NO_SETTINGS, this.value.length);
                this.setRawValueBytes(encoded);
            }
            catch (DataTypeEncodeException e) {
                this.provider.getTool().setStatusInfo(e.getMessage(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValueEditable() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRawValueEditable()) {
                return false;
            }
            if (this.dataType == null) {
                return false;
            }
            return this.dataType.isEncodable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValueLength() {
        Object object = this.lock;
        synchronized (object) {
            return this.value == null ? 0 : this.value.length;
        }
    }

    protected Symbol computeSymbol() {
        if (this.address == null || !this.address.isMemoryAddress()) {
            return null;
        }
        DebuggerCoordinates current = this.provider.current;
        Trace trace = current.getTrace();
        Collection labels = trace.getSymbolManager().labels().getAt(current.getSnap(), null, this.address, false);
        if (!labels.isEmpty()) {
            return (Symbol)labels.iterator().next();
        }
        if (this.provider.mappingService == null) {
            return null;
        }
        DefaultTraceLocation dloc = new DefaultTraceLocation(trace, null, Lifespan.at((long)current.getSnap()), this.address);
        ProgramLocation sloc = this.provider.mappingService.getOpenMappedLocation((TraceLocation)dloc);
        if (sloc == null) {
            return null;
        }
        Program program = sloc.getProgram();
        SymbolTable table = program.getSymbolTable();
        Symbol primary = table.getPrimarySymbol(this.address);
        if (primary != null) {
            return primary;
        }
        SymbolIterator sit = table.getSymbolsAsIterator(sloc.getByteAddress());
        if (sit.hasNext()) {
            return sit.next();
        }
        Function function = program.getFunctionManager().getFunctionContaining(this.address);
        if (function != null) {
            return function.getSymbol();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol getSymbol() {
        Object object = this.lock;
        synchronized (object) {
            return this.symbol;
        }
    }

    public String getErrorMessage() {
        if (this.error == null) {
            return "";
        }
        String message = this.error.getMessage();
        if (message != null && message.trim().length() != 0) {
            return message;
        }
        return this.error.getClass().getSimpleName();
    }

    public Throwable getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKnown() {
        Object object = this.lock;
        synchronized (object) {
            return this.state == TraceMemoryState.KNOWN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChanged() {
        Object object = this.lock;
        synchronized (object) {
            if (this.prevValue == null) {
                return false;
            }
            return !Arrays.equals(this.value, this.prevValue);
        }
    }

    protected void writeConfigState(SaveState saveState) {
        saveState.putString(KEY_EXPRESSION, this.expression);
        saveState.putString(KEY_DATA_TYPE, this.typePath);
        saveState.putSaveState(KEY_SETTINGS, this.savedSettings.getState());
    }

    protected void readConfigState(SaveState saveState) {
        this.setExpression(saveState.getString(KEY_EXPRESSION, ""));
        this.setTypePath(saveState.getString(KEY_DATA_TYPE, null));
        this.savedSettings.setState(saveState.getSaveState(KEY_SETTINGS));
        if (this.dataType != null) {
            this.savedSettings.read(this.dataType.getSettingsDefinitions(), this.dataType.getDefaultSettings());
        }
    }
}

