/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.ep;

import com.google.gson.JsonElement;
import ghidra.program.model.address.Address;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.ep.ExtEntryPoint;
import sarif.managers.ExtEntryPointSarifMgr;

public class SarifEntryPointWriter
extends AbstractExtWriter {
    private List<Address> entryPoints;

    public SarifEntryPointWriter(List<Address> request, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.entryPoints = request;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genCode(monitor);
        this.root.add("entryPoints", (JsonElement)this.objects);
    }

    private void genCode(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.entryPoints.size());
        for (Address addr : this.entryPoints) {
            ExtEntryPoint isf = new ExtEntryPoint(addr);
            SarifObject sarif = new SarifObject(ExtEntryPointSarifMgr.SUBKEY, ExtEntryPointSarifMgr.KEY, this.getTree(isf), addr, addr);
            this.objects.add(this.getTree(sarif));
            monitor.increment();
        }
    }
}

