/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import db.DBHandle;
import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapAddressSetView;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceSpaceBased;
import ghidra.trace.database.symbol.DBTraceEquate;
import ghidra.trace.database.symbol.DBTraceEquateManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.symbol.TraceEquateSpace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceEquateSpace
implements DBTraceSpaceBased,
TraceEquateSpace {
    protected final DBTraceEquateManager manager;
    protected final DBHandle dbh;
    protected final AddressSpace space;
    protected final TraceThread thread;
    protected final int frameLevel;
    protected final ReadWriteLock lock;
    protected final Language baseLanguage;
    protected final DBTrace trace;
    protected final AddressRangeImpl fullSpace;
    protected final DBTraceAddressSnapRangePropertyMapSpace<DBTraceEquateReference, DBTraceEquateReference> equateMapSpace;

    public DBTraceEquateSpace(DBTraceEquateManager manager, DBHandle dbh, AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent, TraceThread thread) throws VersionException, IOException {
        this.manager = manager;
        this.dbh = dbh;
        this.space = space;
        this.thread = thread;
        this.frameLevel = ent.getFrameLevel();
        this.lock = manager.getLock();
        this.baseLanguage = manager.getBaseLanguage();
        this.trace = manager.getTrace();
        this.fullSpace = new AddressRangeImpl(space.getMinAddress(), space.getMaxAddress());
        DBCachedObjectStoreFactory factory = this.trace.getStoreFactory();
        long threadKey = ent.getThreadKey();
        int frameLevel = ent.getFrameLevel();
        this.equateMapSpace = new DBTraceAddressSnapRangePropertyMapSpace(DBTraceEquateReference.tableName(space, threadKey, frameLevel), factory, this.lock, space, thread, ent.getFrameLevel(), DBTraceEquateReference.class, (t, s, r) -> new DBTraceEquateReference(this, t, s, r));
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.space;
    }

    @Override
    public TraceThread getThread() {
        return this.thread;
    }

    @Override
    public int getFrameLevel() {
        return this.frameLevel;
    }

    @Override
    public AddressSetView getReferringAddresses(Lifespan span) {
        return new DBTraceAddressSnapRangePropertyMapAddressSetView<DBTraceEquateReference>(this.space, this.lock, this.equateMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting((AddressRange)this.fullSpace, span)), e -> true);
    }

    @Override
    public void clearReferences(Lifespan span, AddressSetView asv, TaskMonitor monitor) throws CancelledException {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            for (AddressRange range : asv) {
                this.clearReferences(span, range, monitor);
            }
        }
    }

    @Override
    public void clearReferences(Lifespan span, AddressRange range, TaskMonitor monitor) throws CancelledException {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            for (DBTraceEquateReference eref : this.equateMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).values()) {
                DBTraceUtils.makeWay(eref, span, (d, r) -> d.setLifespan((Lifespan)r), d -> this.equateMapSpace.deleteData((DBTraceEquateReference)d));
            }
        }
    }

    @Override
    public DBTraceEquate getReferencedByValue(long snap, Address address, int operandIndex, long value) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            for (DBTraceEquateReference eref : this.equateMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).values()) {
                DBTraceEquate equate = (DBTraceEquate)this.manager.equateStore.getObjectAt(eref.equateKey);
                assert (equate != null);
                if (equate.getValue() != value) continue;
                DBTraceEquate dBTraceEquate = equate;
                return dBTraceEquate;
            }
            Iterator iterator = null;
            return iterator;
        }
    }

    public Collection<? extends DBTraceEquate> getReferenced(long snap, Address address, int operandIndex) {
        return this.equateMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).values().stream().filter(r -> {
            if (r.type != EquateRefType.OP) {
                return false;
            }
            return r.opOrHash == (long)operandIndex;
        }).map(r -> (DBTraceEquate)this.manager.equateStore.getObjectAt(r.equateKey)).toList();
    }

    public Collection<? extends DBTraceEquate> getReferenced(long snap, Address address) {
        return this.equateMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).values().stream().map(r -> (DBTraceEquate)this.manager.equateStore.getObjectAt(r.equateKey)).toList();
    }

    @Override
    public void invalidateCache() {
        this.equateMapSpace.invalidateCache();
    }

    @DBAnnotatedObjectInfo(version=0)
    protected static class DBTraceEquateReference
    extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<DBTraceEquateReference> {
        private static final String TABLE_NAME = "EquateRefs";
        private static final String EQUATE_COLUMN_NAME = "Equate";
        private static final String OP_HASH_COLUMN_NAME = "OpOrHash";
        private static final String TYPE_COLUMN_NAME = "Type";
        @DBAnnotatedColumn(value="Equate")
        static DBObjectColumn EQUATE_COLUMN;
        @DBAnnotatedColumn(value="OpOrHash")
        static DBObjectColumn OP_HASH_COLUMN;
        @DBAnnotatedColumn(value="Type")
        static DBObjectColumn TYPE_COLUMN;
        @DBAnnotatedField(column="Equate", indexed=true)
        long equateKey;
        @DBAnnotatedField(column="OpOrHash")
        long opOrHash;
        @DBAnnotatedField(column="Type")
        EquateRefType type;
        protected final DBTraceEquateSpace space;

        public static String tableName(AddressSpace space, long threadKey, int frameLevel) {
            return DBTraceUtils.tableName(TABLE_NAME, space, threadKey, frameLevel);
        }

        public DBTraceEquateReference(DBTraceEquateSpace space, DBTraceAddressSnapRangePropertyMapTree<DBTraceEquateReference, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(tree, store, record);
            this.space = space;
        }

        protected void setRecordValue(DBTraceEquateReference value) {
        }

        protected DBTraceEquateReference getRecordValue() {
            return this;
        }

        protected void setLifespan(Lifespan lifespan) {
            this.doSetLifespan(lifespan);
        }
    }

    protected static enum EquateRefType {
        OP,
        HASH;

    }
}

