/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.framework.Application;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public abstract class GFileSystemBase
implements GFileSystem {
    protected String fileSystemName;
    protected GFileImpl root;
    protected ByteProvider provider;
    private FSRLRoot fsFSRL;
    private FileSystemRefManager refManager = new FileSystemRefManager(this);
    protected FileSystemService fsService;

    protected GFileSystemBase(String fileSystemName, ByteProvider provider) {
        this.fileSystemName = fileSystemName;
        this.provider = provider;
    }

    public String toString() {
        return "File system " + this.getType() + " - " + this.getDescription() + " - " + this.getName();
    }

    @Override
    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    public void setFSRL(FSRLRoot fsrl) {
        this.root = new GFileImpl(this, null, true, -1L, fsrl.withPath("/"));
        this.fsFSRL = fsrl;
    }

    public void setFilesystemService(FileSystemService fsService) {
        this.fsService = fsService;
    }

    public abstract boolean isValid(TaskMonitor var1) throws IOException;

    public abstract void open(TaskMonitor var1) throws IOException, CryptoException, CancelledException;

    @Override
    public void close() throws IOException {
        this.refManager.onClose();
        this.provider.close();
        this.provider = null;
    }

    @Override
    public boolean isClosed() {
        return this.provider == null;
    }

    @Override
    public final String getName() {
        return this.fileSystemName;
    }

    @Override
    public abstract List<GFile> getListing(GFile var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void debug(byte[] bytes, String fileName) {
        block5: {
            try {
                if (!SystemUtilities.isInDevelopmentMode()) break block5;
                File file = Application.createTempFile((String)fileName, (String)".ghidra.tmp");
                try (FileOutputStream out = new FileOutputStream(file);){
                    ((OutputStream)out).write(bytes);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected Comparator<String> getFilenameComparator() {
        return String::compareTo;
    }

    @Override
    public GFile lookup(String path) throws IOException {
        return this.lookup(path, this.getFilenameComparator());
    }

    @Override
    public GFile lookup(String path, Comparator<String> nameComp) throws IOException {
        String[] parts;
        if (path == null || path.equals("/")) {
            return this.root;
        }
        nameComp = Objects.requireNonNullElseGet(nameComp, this::getFilenameComparator);
        GFile current = this.root;
        block0: for (String part : parts = path.split("/")) {
            if (part.isEmpty()) continue;
            List<GFile> listing = this.getListing(current);
            for (GFile gf : listing) {
                if (nameComp.compare(part, gf.getName()) != 0) continue;
                current = gf;
                continue block0;
            }
            return null;
        }
        return current;
    }

    @Override
    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }
}

