/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.util.demangler.DemangledDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.StructureDataType;
import java.util.ArrayList;
import java.util.List;

public class DemangledStructure
extends DemangledDataType {
    private List<Field> fields = new ArrayList<Field>();
    private String categoryPath;
    private boolean packed;

    public DemangledStructure(String mangled, String originalDemangled, String name, String categoryPath, boolean packed) {
        super(mangled, originalDemangled, name);
        this.setStruct();
        this.categoryPath = categoryPath;
        this.packed = packed;
    }

    public void addField(String name, DemangledDataType type) {
        this.fields.add(new Field(name, null, type));
    }

    public void addField(String name, String description, DemangledDataType type) {
        this.fields.add(new Field(name, description, type));
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public DataType getDataType(DataTypeManager dataTypeManager) {
        String name = this.getName();
        if (name == null) {
            return DataType.DEFAULT;
        }
        StructureDataType struct = new StructureDataType(name, 0, dataTypeManager);
        for (Field field : this.fields) {
            struct.add(field.type().getDataType(dataTypeManager), field.name(), field.description());
        }
        struct.setPackingEnabled(this.packed);
        struct.setCategoryPath(new CategoryPath(this.categoryPath));
        return struct;
    }

    public record Field(String name, String description, DemangledDataType type) {
    }
}

