/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.streams;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.CliStreamHeader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliAbstractStream;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class CliStreamBlob
extends CliAbstractStream {
    protected Map<Integer, CliBlob> blobMap = new LinkedHashMap<Integer, CliBlob>();

    public static String getName() {
        return "#Blob";
    }

    public CliStreamBlob(CliStreamHeader header, long offset, int rva, BinaryReader reader) throws IOException {
        super(header, offset, rva, reader);
    }

    @Override
    public boolean parse() throws IOException {
        CliBlob blob;
        this.reader.setPointerIndex(this.offset);
        this.reader.readNextByte();
        for (int bytesRead = 1; bytesRead < this.header.getSize(); bytesRead += blob.getSize()) {
            blob = new CliBlob(bytesRead, this.reader);
            if (blob.getContentsSize() <= 0) continue;
            this.blobMap.put(bytesRead, blob);
        }
        return true;
    }

    public CliBlob getBlob(int index) {
        return this.blobMap.get(index);
    }

    public boolean updateBlob(CliBlob updatedBlob, Address addr, Program program) {
        int structureOffset;
        Data containingData = program.getListing().getDefinedDataContaining(addr);
        if (containingData == null || !containingData.isStructure()) {
            Msg.error((Object)this, (Object)("Containing data of " + updatedBlob.getName() + " at address " + String.valueOf(addr) + " is not a structure."));
            return false;
        }
        Structure containingStructure = (Structure)containingData.getDataType();
        DataTypeComponent oldBlobDataComponent = containingStructure.getComponentAt(structureOffset = (int)addr.subtract(containingData.getAddress()));
        if (oldBlobDataComponent == null) {
            Msg.error((Object)this, (Object)("Existing blob at address " + String.valueOf(addr) + " was not found."));
            return false;
        }
        DataType oldBlobDataType = oldBlobDataComponent.getDataType();
        DataType newBlobDataType = updatedBlob.toDataType((DataTypeManager)program.getDataTypeManager());
        if (oldBlobDataType.getLength() != newBlobDataType.getLength()) {
            Msg.error((Object)this, (Object)("Cannot replace existing blob at address " + String.valueOf(addr) + " with " + updatedBlob.getName() + " because they have different sizes (Old: " + oldBlobDataType.getLength() + ", New: " + newBlobDataType.getLength() + ")."));
            return false;
        }
        containingStructure.replaceAtOffset(structureOffset, newBlobDataType, updatedBlob.getSize(), updatedBlob.getName(), updatedBlob.getContentsComment());
        return true;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Streams"), this.header.getName(), 0);
        struct.add(BYTE, "Reserved", "Always 0");
        for (Map.Entry<Integer, CliBlob> entry : this.blobMap.entrySet()) {
            int index = entry.getKey();
            CliBlob blob = entry.getValue();
            struct.add(blob.toDataType(), blob.getSize(), "[" + Integer.toHexString(index) + "]", null);
        }
        return struct;
    }
}

