/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class RelocationInfo
implements StructConverter {
    private static int R_SCATTERED_LE = Integer.MIN_VALUE;
    private static int R_SCATTERED_BE = 1;
    private int r_scattered;
    private int r_address;
    private int r_value;
    private int r_pcrel;
    private int r_length;
    private int r_extern;
    private int r_type;

    public RelocationInfo(BinaryReader reader) throws IOException {
        int i1 = reader.readNextInt();
        int i2 = reader.readNextInt();
        if (reader.isBigEndian() && (i1 & R_SCATTERED_BE) != 0) {
            this.r_scattered = 1;
            this.r_pcrel = i1 >> 1 & 1;
            this.r_length = i1 >> 2 & 3;
            this.r_type = i1 >> 4 & 0xF;
            this.r_address = i1 >> 8 & 0xFFFFFF;
            this.r_extern = 1;
            this.r_value = i2;
        } else if ((i1 & R_SCATTERED_LE) != 0) {
            this.r_scattered = 1;
            this.r_extern = 1;
            this.r_address = i1 & 0xFFFFFF;
            this.r_type = i1 >> 24 & 0xF;
            this.r_length = i1 >> 28 & 3;
            this.r_pcrel = i1 >> 30 & 1;
            this.r_value = i2;
        } else {
            this.r_scattered = 0;
            this.r_address = i1;
            this.r_value = i2 & 0xFFFFFF;
            this.r_pcrel = i2 >> 24 & 1;
            this.r_length = i2 >> 25 & 3;
            this.r_extern = i2 >> 27 & 1;
            this.r_type = i2 >> 28 & 0xF;
        }
    }

    public int getAddress() {
        return this.r_address;
    }

    public int getValue() {
        return this.r_value;
    }

    public boolean isPcRelocated() {
        return this.r_pcrel == 1;
    }

    public int getLength() {
        return this.r_length;
    }

    public boolean isExternal() {
        return this.r_extern == 1;
    }

    public boolean isScattered() {
        return this.r_scattered == 1;
    }

    public int getType() {
        return this.r_type;
    }

    public long[] toValues() {
        return new long[]{0L, (long)this.r_address & 0xFFFFFFFFL, (long)this.r_value & 0xFFFFFFFFL, (long)this.r_pcrel & 0xFFFFFFFFL, (long)this.r_length & 0xFFFFFFFFL, (long)this.r_extern & 0xFFFFFFFFL, (long)this.r_type & 0xFFFFFFFFL};
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Address:      " + Long.toHexString(this.r_address));
        buffer.append('\n');
        buffer.append("Value:        " + Integer.toHexString(this.r_value));
        buffer.append('\n');
        buffer.append("Scattered:    " + this.isScattered());
        buffer.append('\n');
        buffer.append("PC Relocated: " + this.isPcRelocated());
        buffer.append('\n');
        buffer.append("Length:       " + Integer.toHexString(this.r_length) + this.getLengthString());
        buffer.append('\n');
        buffer.append("External:     " + this.isExternal());
        buffer.append('\n');
        buffer.append("Type:         " + Integer.toHexString(this.r_type));
        buffer.append('\n');
        return buffer.toString();
    }

    private String getLengthString() {
        switch (this.r_length) {
            case 0: {
                return " (1 byte)";
            }
            case 1: {
                return " (2 bytes)";
            }
            case 2: {
                return " (4 bytes)";
            }
            case 3: {
                return " (8 bytes)";
            }
        }
        return "";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct;
        if (this.isScattered()) {
            struct = new StructureDataType("scattered_relocation_info", 0);
            try {
                struct.insertBitFieldAt(0, DWORD.getLength(), 0, DWORD, 24, "r_address", "");
                struct.insertBitFieldAt(0, DWORD.getLength(), 24, DWORD, 4, "r_type", "");
                struct.insertBitFieldAt(0, DWORD.getLength(), 28, DWORD, 2, "r_length", "");
                struct.insertBitFieldAt(0, DWORD.getLength(), 30, DWORD, 1, "r_pcrel", "");
                struct.insertBitFieldAt(0, DWORD.getLength(), 31, DWORD, 1, "r_scattered", "");
            }
            catch (InvalidDataTypeException e) {
                struct.add(DWORD, "r_mask", "{r_address,r_type,r_length,r_pcrel,r_scattered}");
            }
            struct.add(DWORD, "r_value", null);
        } else {
            struct = new StructureDataType("relocation_info", 0);
            struct.add(DWORD, "r_address", null);
            try {
                struct.insertBitFieldAt(4, DWORD.getLength(), 0, DWORD, 24, "r_symbolnum", "");
                struct.insertBitFieldAt(4, DWORD.getLength(), 24, DWORD, 1, "r_pcrel", "");
                struct.insertBitFieldAt(4, DWORD.getLength(), 25, DWORD, 2, "r_length", "");
                struct.insertBitFieldAt(4, DWORD.getLength(), 27, DWORD, 1, "r_extern", "");
                struct.insertBitFieldAt(4, DWORD.getLength(), 28, DWORD, 4, "r_type", "");
            }
            catch (InvalidDataTypeException e) {
                struct.add(DWORD, "r_mask", "{r_symbolnum,r_pcrel,r_length,r_extern,r_type}");
            }
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

