/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GComboBox;
import docking.widgets.label.GLabel;
import docking.widgets.textfield.IntegerTextField;
import ghidra.app.util.AddressFactoryService;
import ghidra.app.util.AddressInput;
import ghidra.app.util.HexLong;
import ghidra.app.util.ImporterDocumentListener;
import ghidra.app.util.Option;
import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.exception.AssertException;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.TwoColumnPairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.commons.collections4.map.LazyMap;

public class OptionsEditorPanel
extends JPanel {
    private static final int MAX_PER_COLUMN = 11;
    private static final int MAX_BOOLEANS_WITH_SELECT_ALL = 5;
    private int columns;
    private AddressFactoryService addressFactoryService;

    public OptionsEditorPanel(List<Option> options, AddressFactoryService addressFactoryService) {
        super((LayoutManager)new VerticalLayout(5));
        this.addressFactoryService = addressFactoryService;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.columns = options.stream().filter(o -> !o.isHidden()).count() > 11L ? 2 : 1;
        Map<String, List<Option>> optionGroupMap = this.organizeByGroup(options);
        for (List<Option> optionGroup : optionGroupMap.values()) {
            this.add(this.buildOptionGroupPanel(optionGroup));
        }
    }

    private Component buildOptionGroupPanel(List<Option> optionGroup) {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel innerPanel = this.buildInnerOptionsPanel(optionGroup);
        panel.add((Component)innerPanel, "Center");
        if (this.needsSelectAllDeselectAllButton(optionGroup)) {
            panel.add(this.buildSelectAllDeselectAllButtonPanel(innerPanel), "South");
        }
        panel.setBorder(this.createBorder(optionGroup.get(0).getGroup()));
        return panel;
    }

    private Component buildSelectAllDeselectAllButtonPanel(JPanel innerPanel) {
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 5, 5));
        List<JCheckBox> list = this.findAllCheckBoxes(innerPanel);
        buttonPanel.add(this.buildSelectAll(list));
        buttonPanel.add(this.buildDeselectAll(list));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        return buttonPanel;
    }

    private JPanel buildInnerOptionsPanel(List<Option> optionGroup) {
        JPanel panel = new JPanel(this.getBestLayout());
        for (Option option : optionGroup) {
            Component editorComponent = this.getEditorComponent(option);
            if (editorComponent == null) continue;
            GLabel label = new GLabel(option.getName(), 4);
            panel.add((Component)label);
            editorComponent.setName(option.getName());
            editorComponent.getAccessibleContext().setAccessibleName(option.getName());
            panel.add(editorComponent);
        }
        return panel;
    }

    private LayoutManager getBestLayout() {
        if (this.columns == 2) {
            return new TwoColumnPairLayout(4, 50, 4, 0);
        }
        return new PairLayout(4, 4);
    }

    private Component buildSelectAll(List<JCheckBox> list) {
        JPanel panel = new JPanel(new FlowLayout(1));
        JButton button = new JButton("Select All");
        button.addActionListener(e -> {
            for (JCheckBox jCheckBox : list) {
                jCheckBox.setSelected(true);
            }
        });
        panel.add(button);
        return panel;
    }

    private Component buildDeselectAll(List<JCheckBox> list) {
        JPanel panel = new JPanel(new FlowLayout(1));
        JButton button = new JButton("Deselect All");
        button.addActionListener(e -> {
            for (JCheckBox jCheckBox : list) {
                jCheckBox.setSelected(false);
            }
        });
        panel.add(button);
        return panel;
    }

    private boolean needsSelectAllDeselectAllButton(List<Option> optionGroup) {
        int booleanCount = 0;
        for (Option option : optionGroup) {
            if (!Boolean.class.isAssignableFrom(option.getValueClass())) continue;
            ++booleanCount;
        }
        return booleanCount > 5;
    }

    private Border createBorder(String group) {
        if (group != null) {
            return BorderFactory.createTitledBorder(group);
        }
        return BorderFactory.createEmptyBorder(10, 10, 10, 10);
    }

    private Map<String, List<Option>> organizeByGroup(List<Option> options) {
        LazyMap map = LazyMap.lazyMap(new LinkedHashMap(), () -> new ArrayList());
        for (Option option : options) {
            if (option.isHidden()) continue;
            String group = option.getGroup();
            List optionGroup = (List)map.get(group);
            optionGroup.add(option);
        }
        return map;
    }

    private List<JCheckBox> findAllCheckBoxes(JPanel panel) {
        ArrayList<JCheckBox> list = new ArrayList<JCheckBox>();
        this.gatherCheckBoxes(panel, list);
        return list;
    }

    private void gatherCheckBoxes(Container container, ArrayList<JCheckBox> list) {
        Component[] comps;
        for (Component element : comps = container.getComponents()) {
            if (element instanceof JCheckBox) {
                list.add((JCheckBox)element);
            }
            if (!(element instanceof Container)) continue;
            Container subContainer = (Container)element;
            this.gatherCheckBoxes(subContainer, list);
        }
    }

    private Component getEditorComponent(Option option) {
        Component customEditorComponent = option.getCustomEditorComponent();
        if (customEditorComponent != null) {
            return customEditorComponent;
        }
        Class<?> optionClass = option.getValueClass();
        if (Address.class.isAssignableFrom(optionClass)) {
            return this.getAddressEditorComponent(option);
        }
        if (Boolean.class.isAssignableFrom(optionClass)) {
            return this.getBooleanEditorComponent(option);
        }
        if (Long.class.isAssignableFrom(optionClass)) {
            return this.getLongEditorComponent(option);
        }
        if (Integer.class.isAssignableFrom(optionClass)) {
            return this.getIntegerEditorComponent(option);
        }
        if (HexLong.class.isAssignableFrom(optionClass)) {
            return this.getHexLongEditorComponent(option);
        }
        if (String.class.isAssignableFrom(optionClass)) {
            return this.getStringEditorComponent(option);
        }
        if (AddressSpace.class.isAssignableFrom(optionClass)) {
            return this.getAddressSpaceEditorComponent(option);
        }
        throw new AssertException("Attempted to get default editor component for Option type: " + optionClass.getName() + ". Please register a custom editor");
    }

    private Component getAddressSpaceEditorComponent(Option option) {
        AddressSpace[] spaces;
        if (this.addressFactoryService == null) {
            return null;
        }
        GComboBox combo = new GComboBox();
        AddressFactory addressFactory = this.addressFactoryService.getAddressFactory();
        for (AddressSpace space : spaces = addressFactory == null ? new AddressSpace[]{} : addressFactory.getAddressSpaces()) {
            combo.addItem(space);
        }
        AddressSpace space = (AddressSpace)option.getValue();
        if (space != null) {
            combo.setSelectedItem(space);
        }
        combo.addActionListener(arg_0 -> OptionsEditorPanel.lambda$getAddressSpaceEditorComponent$4(option, (JComboBox)combo, arg_0));
        return combo;
    }

    private Component getStringEditorComponent(Option option) {
        SaveState state = option.getState();
        String defaultValue = (String)option.getValue();
        String value = state != null ? state.getString(option.getName(), defaultValue) : defaultValue;
        option.setValue(value);
        JTextField tf = new JTextField(5);
        tf.setName(option.getName());
        tf.getDocument().addDocumentListener(new ImporterDocumentListener(option, tf, state));
        tf.setText(value);
        return tf;
    }

    private Component getHexLongEditorComponent(Option option) {
        SaveState state = option.getState();
        HexLong defaultValue = (HexLong)option.getValue();
        long value = state != null ? state.getLong(option.getName(), defaultValue.longValue()) : defaultValue.longValue();
        option.setValue(new HexLong(value));
        IntegerTextField field = new IntegerTextField();
        field.setValue(value);
        field.setHexMode();
        field.addChangeListener(e -> {
            option.setValue(new HexLong(field.getLongValue()));
            if (state != null) {
                state.putLong(option.getName(), field.getLongValue());
            }
        });
        return field.getComponent();
    }

    private Component getIntegerEditorComponent(Option option) {
        SaveState state = option.getState();
        int defaultValue = (Integer)option.getValue();
        int value = state != null ? state.getInt(option.getName(), defaultValue) : defaultValue;
        option.setValue(value);
        IntegerTextField field = new IntegerTextField();
        field.setValue(value);
        field.addChangeListener(e -> {
            option.setValue(field.getIntValue());
            if (state != null) {
                state.putInt(option.getName(), field.getIntValue());
            }
        });
        return field.getComponent();
    }

    private Component getLongEditorComponent(Option option) {
        SaveState state = option.getState();
        long defaultValue = (Long)option.getValue();
        long value = state != null ? state.getLong(option.getName(), defaultValue) : defaultValue;
        option.setValue(value);
        IntegerTextField field = new IntegerTextField();
        field.setValue(value);
        field.addChangeListener(e -> {
            option.setValue(field.getLongValue());
            if (state != null) {
                state.putLong(option.getName(), field.getLongValue());
            }
        });
        return field.getComponent();
    }

    private Component getBooleanEditorComponent(Option option) {
        SaveState state = option.getState();
        boolean defaultValue = (Boolean)option.getValue();
        boolean initialState = state != null ? state.getBoolean(option.getName(), defaultValue) : defaultValue;
        option.setValue(initialState);
        GCheckBox cb = new GCheckBox();
        cb.setName(option.getName());
        cb.setSelected(initialState);
        cb.addItemListener(e -> {
            option.setValue(cb.isSelected());
            if (state != null) {
                state.putBoolean(option.getName(), cb.isSelected());
            }
        });
        return cb;
    }

    private Component getAddressEditorComponent(Option option) {
        if (this.addressFactoryService == null) {
            return null;
        }
        AddressFactory addressFactory = this.addressFactoryService.getAddressFactory();
        AddressInput addressInput = new AddressInput(a -> option.setValue(a));
        addressInput.setName(option.getName());
        Address addr = (Address)option.getValue();
        if (addr == null && addressFactory != null) {
            addr = addressFactory.getDefaultAddressSpace().getAddress(0L);
            option.setValue(addr);
        }
        addressInput.setAddressFactory(addressFactory);
        addressInput.setAddress(addr);
        return addressInput;
    }

    private static /* synthetic */ void lambda$getAddressSpaceEditorComponent$4(Option option, JComboBox combo, ActionEvent e) {
        option.setValue(combo.getSelectedItem());
    }
}

