/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import docking.ComponentProvider;
import docking.DockingWindowManager;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.nav.LocationMemento;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableRegistry;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.services.GoToService;
import ghidra.app.services.NavigationHistoryService;
import ghidra.app.services.ProgramManager;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.bean.opteditor.OptionsVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Tool State History", description="This plugin maintains a history of tool states. It is used in conjunction with other plugins to cause program viewer plugins to change their focus to a certain address. As viewer plugins are directed to one or more addresses, it maintains information about where the viewers have been to support ability for the viewers to go back to a previous \"focus\" point.", servicesRequired={ProgramManager.class}, servicesProvided={NavigationHistoryService.class}, eventsConsumed={ProgramClosedPluginEvent.class})
public class NavigationHistoryPlugin
extends Plugin
implements NavigationHistoryService,
NavigatableRemovalListener,
OptionsChangeListener {
    private static final String MAX_NAVIGATION_HISTORY_SIZE_OPTION_NAME = "Max Navigation History Size";
    private static final String HISTORY_LIST = "HISTORY_LIST_";
    private static final String LIST_COUNT = "LIST_COUNT";
    private static final String LOCATION_COUNT = "LOCATION_COUNT";
    private static final String NAV_ID = "NAV_ID";
    private static final String CURRENT_LOCATION_INDEX = "CURRENT_LOC_INDEX";
    private static final String MEMENTO_DATA = "MEMENTO_DATA";
    private static final String MEMENTO_CLASS = "MEMENTO_CLASS";
    private Map<Navigatable, HistoryList> historyListMap = new HashMap<Navigatable, HistoryList>();
    private static final int ABSOLUTE_MAX_HISTORY_SIZE = 400;
    private static final int ABSOLUTE_MIN_HISTORY_SIZE = 10;
    static final int MAX_HISTORY_SIZE = 30;
    private int maxHistorySize = 30;
    private SaveState dataSaveState;

    public NavigationHistoryPlugin(PluginTool tool) {
        super(tool);
        tool.getOptions("Tool");
    }

    protected void dispose() {
        ToolOptions options = this.tool.getOptions("Tool");
        options.removeOptionsChangeListener((OptionsChangeListener)this);
        super.dispose();
    }

    protected void init() {
        this.initOptions();
    }

    public void readDataState(SaveState saveState) {
        this.dataSaveState = saveState;
    }

    public void dataStateRestoreCompleted() {
        if (this.dataSaveState == null) {
            return;
        }
        ProgramManager pm = (ProgramManager)this.tool.getService(ProgramManager.class);
        Program[] programs = pm.getAllOpenPrograms();
        int count = this.dataSaveState.getInt(LIST_COUNT, 0);
        for (int i = 0; i < count; ++i) {
            Element xmlElement = this.dataSaveState.getXmlElement(HISTORY_LIST + i);
            this.restoreHistoryList(xmlElement, programs);
        }
        this.dataSaveState = null;
        this.notifyHistoryChange();
    }

    private void initOptions() {
        ToolOptions options = this.tool.getOptions("Tool");
        options.registerOption(MAX_NAVIGATION_HISTORY_SIZE_OPTION_NAME, (Object)30, null, "The maximum number of items to display in the tool's navigation history.");
        this.maxHistorySize = options.getInt(MAX_NAVIGATION_HISTORY_SIZE_OPTION_NAME, 30);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (MAX_NAVIGATION_HISTORY_SIZE_OPTION_NAME.equals(optionName)) {
            int newMaxHistorySize = options.getInt(MAX_NAVIGATION_HISTORY_SIZE_OPTION_NAME, 30);
            if (newMaxHistorySize > 400) {
                throw new OptionsVetoException("History size cannot be greater than 400");
            }
            if (newMaxHistorySize < 10) {
                throw new OptionsVetoException("History size cannot be less than 10");
            }
            this.maxHistorySize = newMaxHistorySize;
            this.updateHistoryListMaxSize(this.maxHistorySize);
        }
    }

    private void updateHistoryListMaxSize(int maxLocations) {
        Collection<HistoryList> historyLists = this.historyListMap.values();
        for (HistoryList historyList : historyLists) {
            historyList.setMaxLocations(maxLocations);
        }
    }

    private void restoreHistoryList(Element xmlElement, Program[] programs) {
        SaveState saveState = new SaveState(xmlElement);
        Navigatable nav = NavigatableRegistry.getNavigatable(saveState.getLong(NAV_ID, 0L));
        if (nav == null) {
            return;
        }
        nav.addNavigatableListener(this);
        HistoryList historyList = new HistoryList(this.maxHistorySize);
        this.historyListMap.put(nav, historyList);
        int count = saveState.getInt(LOCATION_COUNT, 0);
        for (int i = 0; i < count; ++i) {
            LocationMemento memento = this.restoreLocation(i, saveState, programs);
            if (memento == null) continue;
            historyList.addLocation(memento);
        }
        int currentLocationIndex = saveState.getInt(CURRENT_LOCATION_INDEX, historyList.size());
        historyList.setCurrentLocationIndex(currentLocationIndex);
    }

    public void writeDataState(SaveState saveState) {
        int count = 0;
        for (Navigatable navigatable : this.historyListMap.keySet()) {
            HistoryList historyList = this.historyListMap.get(navigatable);
            SaveState listSaveState = new SaveState();
            this.writeDataState(listSaveState, navigatable, historyList);
            saveState.putXmlElement(HISTORY_LIST + count, listSaveState.saveToXml());
            ++count;
        }
        saveState.putInt(LIST_COUNT, count);
    }

    public void writeDataState(SaveState saveState, Navigatable navigatable, HistoryList historyList) {
        saveState.putLong(NAV_ID, navigatable.getInstanceID());
        saveState.putInt(LOCATION_COUNT, historyList.size());
        saveState.putInt(CURRENT_LOCATION_INDEX, historyList.getCurrentLocationIndex());
        for (int i = 0; i < historyList.size(); ++i) {
            LocationMemento location = historyList.getLocation(i);
            this.saveLocation(i, saveState, location);
        }
    }

    @Override
    public void nextFunction(Navigatable navigatable) {
        if (this.hasNextFunction(navigatable)) {
            HistoryList historyList = this.historyListMap.get(navigatable);
            LocationMemento memento = historyList.nextFunction(navigatable, true);
            this.navigate(navigatable, memento);
        }
    }

    @Override
    public void previousFunction(Navigatable navigatable) {
        if (this.hasPreviousFunction(navigatable)) {
            HistoryList historyList = this.historyListMap.get(navigatable);
            this.addCurrentLocationToHistoryIfAppropriate(navigatable, historyList.getCurrentLocation());
            LocationMemento memento = historyList.previousFunction(navigatable, true);
            this.navigate(navigatable, memento);
        }
    }

    @Override
    public boolean hasNextFunction(Navigatable navigatable) {
        HistoryList historyList = this.historyListMap.get(navigatable);
        return historyList != null && historyList.hasNextFunction(navigatable);
    }

    @Override
    public boolean hasPreviousFunction(Navigatable navigatable) {
        HistoryList historyList = this.historyListMap.get(navigatable);
        return historyList != null && historyList.hasPreviousFunction(navigatable);
    }

    @Override
    public void next(Navigatable navigatable) {
        if (this.hasNext(navigatable)) {
            HistoryList historyList = this.historyListMap.get(navigatable);
            LocationMemento nextLocation = historyList.next();
            this.navigate(navigatable, nextLocation);
        }
    }

    @Override
    public void previous(Navigatable navigatable) {
        if (this.hasPrevious(navigatable)) {
            HistoryList historyList = this.historyListMap.get(navigatable);
            this.addCurrentLocationToHistoryIfAppropriate(navigatable, historyList.getCurrentLocation());
            LocationMemento previousLocation = historyList.previous();
            this.navigate(navigatable, previousLocation);
        }
    }

    private void addCurrentLocationToHistoryIfAppropriate(Navigatable navigatable, LocationMemento location) {
        if (!this.hasNext(navigatable)) {
            HistoryList historyList = this.historyListMap.get(navigatable);
            LocationMemento currentLocation = navigatable.getMemento();
            if (currentLocation.isValid()) {
                historyList.addLocation(currentLocation);
            }
        }
    }

    @Override
    public void next(Navigatable navigatable, LocationMemento location) {
        while (this.hasNext(navigatable)) {
            HistoryList historyList = this.historyListMap.get(navigatable);
            LocationMemento nextLocation = historyList.next();
            if (nextLocation != location) continue;
            this.navigate(navigatable, nextLocation);
            break;
        }
    }

    private void navigate(Navigatable navigatable, LocationMemento memento) {
        if (memento == null) {
            return;
        }
        navigatable.goTo(memento.getProgram(), memento.getProgramLocation());
        navigatable.setMemento(memento);
        if (navigatable.isVisible()) {
            navigatable.requestFocus();
        }
        this.tool.contextChanged(null);
    }

    @Override
    public void previous(Navigatable navigatable, LocationMemento location) {
        this.addCurrentLocationToHistoryIfAppropriate(navigatable, location);
        while (this.hasPrevious(navigatable)) {
            HistoryList historyList = this.historyListMap.get(navigatable);
            LocationMemento previousLocation = historyList.previous();
            if (previousLocation != location) continue;
            this.navigate(navigatable, previousLocation);
            break;
        }
    }

    @Override
    public List<LocationMemento> getNextLocations(Navigatable navigatable) {
        HistoryList historyList = this.historyListMap.get(navigatable);
        if (historyList != null) {
            return historyList.getNextLocations();
        }
        return new ArrayList<LocationMemento>();
    }

    @Override
    public List<LocationMemento> getPreviousLocations(Navigatable navigatable) {
        HistoryList historyList = this.historyListMap.get(navigatable);
        if (historyList == null) {
            return new ArrayList<LocationMemento>();
        }
        List<LocationMemento> previousLocations = historyList.getPreviousLocations();
        if (!this.hasNext(navigatable)) {
            LocationMemento currentHistoryLocation = historyList.getCurrentLocation();
            LocationMemento currentLocation = navigatable.getMemento();
            if (!currentLocation.equals(currentHistoryLocation)) {
                previousLocations.add(0, currentHistoryLocation);
            }
        }
        return previousLocations;
    }

    @Override
    public boolean hasNext(Navigatable navigatable) {
        HistoryList historyList = this.historyListMap.get(navigatable);
        return historyList != null && historyList.hasNext();
    }

    @Override
    public boolean hasPrevious(Navigatable navigatable) {
        HistoryList historyList = this.historyListMap.get(navigatable);
        return historyList != null && historyList.hasPrevious();
    }

    @Override
    public void clear(Navigatable navigatable) {
        this.historyListMap.remove(navigatable);
        this.notifyHistoryChange();
    }

    @Override
    public void clear(Program program) {
        for (HistoryList historyList : this.historyListMap.values()) {
            this.clear(historyList, program);
        }
        this.notifyHistoryChange();
    }

    private void clear(HistoryList historyList, Program program) {
        for (int i = historyList.size() - 1; i >= 0; --i) {
            LocationMemento location = historyList.getLocation(i);
            if (location.getProgram() != program) continue;
            historyList.remove(location);
        }
    }

    private void notifyHistoryChange() {
        if (this.tool != null) {
            this.tool.contextChanged(null);
        }
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramClosedPluginEvent) {
            this.clear(((ProgramClosedPluginEvent)event).getProgram());
        }
    }

    @Override
    public void addNewLocation(Navigatable navigatable) {
        LocationMemento memento;
        HistoryList historyList = this.historyListMap.get(navigatable = this.getHistoryNavigatable(navigatable));
        if (historyList == null) {
            navigatable.addNavigatableListener(this);
            historyList = new HistoryList(this.maxHistorySize);
            this.historyListMap.put(navigatable, historyList);
        }
        if ((memento = navigatable.getMemento()).isValid()) {
            historyList.addLocation(memento);
            this.notifyHistoryChange();
        }
    }

    private Navigatable getHistoryNavigatable(Navigatable navigatable) {
        if (!navigatable.isConnected()) {
            return navigatable;
        }
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            return service.getDefaultNavigatable();
        }
        return null;
    }

    @Override
    public void navigatableRemoved(Navigatable navigatable) {
        navigatable.removeNavigatableListener(this);
        this.clear(navigatable);
    }

    private void saveLocation(int index, SaveState saveState, LocationMemento memento) {
        SaveState mementoSaveState = new SaveState();
        memento.saveState(mementoSaveState);
        Element element = mementoSaveState.saveToXml();
        saveState.putString(MEMENTO_CLASS + index, memento.getClass().getName());
        saveState.putXmlElement(MEMENTO_DATA + index, element);
    }

    private LocationMemento restoreLocation(int index, SaveState saveState, Program[] programs) {
        Element mementoElement = saveState.getXmlElement(MEMENTO_DATA + index);
        if (mementoElement == null) {
            return null;
        }
        SaveState mementoState = new SaveState(mementoElement);
        LocationMemento locationMemento = null;
        try {
            locationMemento = LocationMemento.getLocationMemento(mementoState, programs);
        }
        catch (IllegalArgumentException iae) {
            Msg.trace((Object)this, (Object)("Unable to restore LocationMemento: " + iae.getMessage()), (Throwable)iae);
        }
        return locationMemento;
    }

    private static class HistoryList {
        private List<LocationMemento> list = new ArrayList<LocationMemento>();
        private int currentLocation = 0;
        private int maxLocations;

        HistoryList(int maxLocations) {
            this.maxLocations = maxLocations;
        }

        int getCurrentLocationIndex() {
            return this.currentLocation;
        }

        void setCurrentLocationIndex(int index) {
            if (index >= 0 && index < this.list.size()) {
                this.currentLocation = index;
            }
        }

        int size() {
            return this.list.size();
        }

        LocationMemento getLocation(int index) {
            return this.list.get(index);
        }

        LocationMemento getCurrentLocation() {
            return this.list.get(this.currentLocation);
        }

        void addLocation(LocationMemento newValue) {
            if (this.list.isEmpty()) {
                this.list.add(newValue);
                this.currentLocation = 0;
                return;
            }
            while (this.list.size() - 1 > this.currentLocation) {
                this.list.remove(this.list.size() - 1);
            }
            LocationMemento lastLocation = this.list.get(this.list.size() - 1);
            if (!newValue.equals(lastLocation)) {
                this.list.add(newValue);
            } else {
                this.list.set(this.list.size() - 1, newValue);
            }
            if (this.list.size() > this.maxLocations) {
                this.list.remove(0);
            }
            this.currentLocation = this.list.size() - 1;
        }

        void setMaxLocations(int maxLocations) {
            this.maxLocations = maxLocations;
        }

        boolean hasNext() {
            if (this.list.isEmpty()) {
                return false;
            }
            return this.currentLocation < this.list.size() - 1;
        }

        boolean hasPrevious() {
            if (this.list.isEmpty()) {
                return false;
            }
            return this.currentLocation > 0;
        }

        LocationMemento next() {
            if (this.hasNext()) {
                ++this.currentLocation;
                return this.list.get(this.currentLocation);
            }
            return null;
        }

        LocationMemento previous() {
            if (this.hasPrevious()) {
                --this.currentLocation;
                return this.list.get(this.currentLocation);
            }
            return null;
        }

        boolean hasNextFunction(Navigatable navigatable) {
            return this.nextFunction(navigatable, false) != null;
        }

        boolean hasPreviousFunction(Navigatable navigatable) {
            return this.previousFunction(navigatable, false) != null;
        }

        private LocationMemento nextFunction(Navigatable navigatable, boolean moveTo) {
            if (this.list.isEmpty()) {
                return null;
            }
            Function currentFunction = this.getCurrentFunction(navigatable);
            for (int i = this.currentLocation + 1; i < this.list.size(); ++i) {
                LocationMemento memento = this.list.get(i);
                ProgramLocation otherLocation = memento.getProgramLocation();
                Address address = otherLocation.getAddress();
                FunctionManager functionManager = otherLocation.getProgram().getFunctionManager();
                Function historyFunction = functionManager.getFunctionContaining(address);
                if (historyFunction == null || historyFunction.equals((Object)currentFunction)) continue;
                if (moveTo) {
                    this.currentLocation = i;
                }
                return memento;
            }
            return null;
        }

        private Function getCurrentFunction(Navigatable navigatable) {
            ProgramLocation location = navigatable.getLocation();
            if (location == null) {
                return null;
            }
            Program program = location.getProgram();
            FunctionManager functionManager = program.getFunctionManager();
            return functionManager.getFunctionContaining(location.getAddress());
        }

        private LocationMemento previousFunction(Navigatable navigatable, boolean moveTo) {
            if (this.list.isEmpty()) {
                return null;
            }
            Function startFunction = this.getPreviousStartFunction(navigatable);
            for (int i = this.currentLocation - 1; i >= 0; --i) {
                LocationMemento memento = this.list.get(i);
                ProgramLocation otherLocation = memento.getProgramLocation();
                Address address = otherLocation.getAddress();
                FunctionManager functionManager = otherLocation.getProgram().getFunctionManager();
                Function historyFunction = functionManager.getFunctionContaining(address);
                if (historyFunction == null || historyFunction.equals((Object)startFunction)) continue;
                if (moveTo) {
                    this.currentLocation = i;
                }
                return memento;
            }
            return null;
        }

        private Function getPreviousStartFunction(Navigatable navigatable) {
            ProgramLocation location = this.getProgramLocation(navigatable);
            if (location == null) {
                return null;
            }
            Address currentAddress = location.getAddress();
            Program program = location.getProgram();
            FunctionManager functionManager = program.getFunctionManager();
            return functionManager.getFunctionContaining(currentAddress);
        }

        private ProgramLocation getProgramLocation(Navigatable navigatable) {
            LocationMemento memento;
            Navigatable activeNavigatable;
            ProgramLocation location;
            DockingWindowManager dwm = DockingWindowManager.getActiveInstance();
            ComponentProvider activeProvider = dwm.getActiveComponentProvider();
            if (activeProvider instanceof Navigatable && (location = this.validateProgramLocation(activeNavigatable = (Navigatable)activeProvider, (memento = activeNavigatable.getMemento()).getProgramLocation())) != null) {
                return location;
            }
            ProgramLocation location2 = navigatable.getLocation();
            return this.validateProgramLocation(navigatable, location2);
        }

        private ProgramLocation validateProgramLocation(Navigatable navigatable, ProgramLocation location) {
            if (location == null) {
                return null;
            }
            if (this.isClosedProgram(navigatable, location)) {
                return null;
            }
            return location;
        }

        private boolean isClosedProgram(Navigatable navigatable, ProgramLocation location) {
            Program program = location.getProgram();
            if (program.isClosed()) {
                Msg.showError((Object)this, null, (String)"Closed Program", (Object)"The Navigation History Plugin is using a closed program.\nProgram: %s\nNavigatable: %s\nLocation: %s @ %s".formatted(program.getName(), navigatable.getClass().getSimpleName(), location.getClass().getSimpleName(), location.getAddress()));
                return true;
            }
            return false;
        }

        void remove(LocationMemento location) {
            for (int i = 0; i < this.list.size(); ++i) {
                LocationMemento loc = this.list.get(i);
                if (!loc.equals(location)) continue;
                this.list.remove(i);
                if (this.currentLocation > 0 && this.currentLocation >= i) {
                    --this.currentLocation;
                }
                return;
            }
        }

        List<LocationMemento> getPreviousLocations() {
            ArrayList<LocationMemento> previousLocations = new ArrayList<LocationMemento>();
            for (int i = 0; i < this.currentLocation; ++i) {
                previousLocations.add(this.list.get(i));
            }
            Collections.reverse(previousLocations);
            return previousLocations;
        }

        List<LocationMemento> getNextLocations() {
            ArrayList<LocationMemento> nextLocations = new ArrayList<LocationMemento>();
            for (int i = this.currentLocation + 1; i < this.list.size(); ++i) {
                nextLocations.add(this.list.get(i));
            }
            return nextLocations;
        }
    }
}

