/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff.relocation;

import ghidra.app.util.bin.format.RelocationException;
import ghidra.app.util.bin.format.coff.CoffFileHeader;
import ghidra.app.util.bin.format.coff.CoffRelocation;
import ghidra.app.util.bin.format.coff.relocation.CoffRelocationContext;
import ghidra.app.util.bin.format.coff.relocation.CoffRelocationHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;

public class ARM_CoffRelocationHandler
implements CoffRelocationHandler {
    public static final short IMAGE_REL_ARM_ABSOLUTE = 0;
    public static final short IMAGE_REL_ARM_ADDR32 = 1;
    public static final short IMAGE_REL_ARM_ADDR32NB = 2;
    public static final short IMAGE_REL_ARM_BRANCH24 = 3;
    public static final short IMAGE_REL_ARM_BRANCH11 = 4;
    public static final short IMAGE_REL_ARM_REL32 = 10;
    public static final short IMAGE_REL_ARM_SECTION = 14;
    public static final short IMAGE_REL_ARM_SECREL = 15;
    public static final short IMAGE_REL_ARM_MOV32 = 16;
    public static final short IMAGE_REL_THUMB_MOV32 = 17;
    public static final short IMAGE_REL_THUMB_BRANCH20 = 18;
    public static final short IMAGE_REL_THUMB_BRANCH24 = 20;
    public static final short IMAGE_REL_THUMB_BLX23 = 21;
    public static final short IMAGE_REL_ARM_PAIR = 22;

    public boolean canRelocate(CoffFileHeader fileHeader) {
        switch (fileHeader.getMachine()) {
            case 448: 
            case 452: {
                return true;
            }
        }
        return false;
    }

    public RelocationResult relocate(Address address, CoffRelocation relocation, CoffRelocationContext relocationContext) throws MemoryAccessException, RelocationException {
        Program program = relocationContext.getProgram();
        Memory mem = program.getMemory();
        int byteLength = 4;
        int bytesToAdjust = mem.getInt(address);
        Address symbolAddr = relocationContext.getSymbolAddress(relocation);
        switch (relocation.getType()) {
            case 0: {
                return RelocationResult.SKIPPED;
            }
            case 1: {
                mem.setInt(address, (int)symbolAddr.getOffset());
                break;
            }
            case 2: {
                mem.setInt(address, (int)symbolAddr.getOffset());
                break;
            }
            case 17: {
                int symAddress = (int)symbolAddr.getOffset();
                long highImmed16 = this.getImmed16(symAddress >> 16);
                long lowImmed16 = this.getImmed16(symAddress & 0xFFFF);
                long longBytesToAdjust = mem.getLong(address);
                longBytesToAdjust = longBytesToAdjust | highImmed16 << 32 | lowImmed16;
                byteLength = 8;
                mem.setLong(address, longBytesToAdjust);
                break;
            }
            case 20: {
                int displacement = (int)symbolAddr.subtract(address) - 4;
                int adjustment = this.getThAddr24(displacement);
                int adjusted = (bytesToAdjust &= 0xD000F800) | adjustment;
                mem.setInt(address, adjusted);
                break;
            }
            case 21: {
                int displacement = (int)symbolAddr.subtract(address) - 4;
                int adjustment = this.getThAddr24(displacement);
                int adjusted = (bytesToAdjust &= 0xD000F800) | adjustment;
                mem.setInt(address, adjusted);
                break;
            }
            default: {
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }

    private int getImmed16(int value) {
        int immed12_imm8 = value & 0xFF;
        int immed12_imm3 = value >> 8 & 7;
        int immed12_i = value >> 11 & 1;
        int sop003 = value >> 12 & 0xF;
        return immed12_imm3 << 28 | immed12_imm8 << 16 | immed12_i << 10 | sop003;
    }

    private int getThAddr24(int displacement) {
        int offset10s;
        int part2J1 = (displacement & 0x800000) >> 23;
        int part2J2 = (displacement & 0x400000) >> 22;
        int part2off = (displacement & 0xFFE) >> 1;
        int offset10 = (displacement & 0x3FF000) >> 12;
        int n = offset10s = displacement < 0 ? 1 : 0;
        if (displacement >= 0) {
            part2J1 ^= 1;
            part2J2 ^= 1;
        }
        int adjustment = part2J1 << 29 | part2J2 << 27 | part2off << 16 | offset10s << 10 | offset10;
        return adjustment;
    }
}

