/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.builder.GraphTypeBuilder;

public class SubGraphFunction<V, E>
implements Function<Graph<V, E>, List<Graph<V, E>>> {
    @Override
    public List<Graph<V, E>> apply(Graph<V, E> graph) {
        ArrayList<Graph<V, Graph>> subGraphList = new ArrayList<Graph<V, Graph>>();
        ConnectivityInspector connectivityInspector = new ConnectivityInspector(graph);
        List componentVertices = connectivityInspector.connectedSets();
        if (componentVertices.size() > 1) {
            for (Set vertexSet : componentVertices) {
                Graph subGraph = GraphTypeBuilder.forGraph(graph).buildGraph();
                vertexSet.forEach(arg_0 -> ((Graph)subGraph).addVertex(arg_0));
                for (Object v : vertexSet) {
                    Graphs.successorListOf(graph, v).forEach(s -> subGraph.addEdge(v, s, graph.getEdge(v, s)));
                    Graphs.predecessorListOf(graph, v).forEach(p -> subGraph.addEdge(p, v, graph.getEdge(p, v)));
                }
                subGraphList.add(subGraph);
            }
        }
        return subGraphList;
    }
}

