/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.png;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.ios.png.CrushedPNGConstants;
import ghidra.file.formats.ios.png.CrushedPNGUtil;
import ghidra.file.formats.ios.png.PNGChunk;
import ghidra.file.formats.ios.png.ProcessedPNG;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

@FileSystemInfo(type="crushedpng", description="Crushed PNG", factory=GFileSystemBaseFactory.class)
public class CrushedPNGFileSystem
extends GFileSystemBase {
    private ProcessedPNG png;
    private GFileImpl pngGFile;

    public CrushedPNGFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public void close() throws IOException {
        super.close();
        this.pngGFile = null;
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        int signatureLength = CrushedPNGConstants.SIGNATURE_BYTES.length;
        byte[] signatureArray = new byte[signatureLength];
        signatureArray = this.provider.readBytes(0L, (long)signatureLength);
        if (Arrays.equals(signatureArray, CrushedPNGConstants.SIGNATURE_BYTES)) {
            byte[] insertedChunkID = this.provider.readBytes((long)(signatureArray.length + 4), 4L);
            return Arrays.equals(insertedChunkID, CrushedPNGConstants.INSERTED_IOS_CHUNK);
        }
        return false;
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        BinaryReader reader = new BinaryReader(this.provider, false);
        monitor.setMessage("Opening iOS Crushed PNG...");
        this.png = new ProcessedPNG(reader, monitor);
        Object uncrushedPngFilename = this.getName();
        if ("png".equalsIgnoreCase(FilenameUtils.getExtension((String)uncrushedPngFilename))) {
            uncrushedPngFilename = FilenameUtils.removeExtension((String)uncrushedPngFilename) + ".uncrushed.png";
        }
        this.pngGFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)uncrushedPngFilename, (boolean)false, (long)1L, null);
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return directory == null || directory.equals((Object)this.root) ? Arrays.asList(this.pngGFile) : Collections.emptyList();
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        FileAttributes result = new FileAttributes();
        result.add(FileAttributeType.SIZE_ATTR, (Object)this.png.getTotalLength());
        result.add("Type", (Object)"Crushed PNG Image");
        int chunkNum = 0;
        for (PNGChunk chunk : this.png.getChunkArray()) {
            result.add("PNG Chunk " + chunkNum++, (Object)chunk.getIDString());
        }
        return result;
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        try {
            return new ByteArrayProvider(CrushedPNGUtil.getUncrushedPNGBytes(this.png), file.getFSRL());
        }
        catch (Exception e) {
            throw new IOException("Error converting crushed PNG bitmap", e);
        }
    }
}

