/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import java.io.IOException;

public class DumpFileReader
extends BinaryReader {
    private int size;

    public DumpFileReader(ByteProvider provider, boolean isLittleEndian, int size) {
        super(provider, isLittleEndian);
        this.size = size;
    }

    public long readNextPointer() throws IOException {
        return this.size == 32 ? (long)this.readNextInt() : this.readNextLong();
    }

    public long readPointer(long offset) throws IOException {
        return this.size == 32 ? (long)this.readInt(offset) : this.readLong(offset);
    }

    public int getPointerSize() {
        return this.size / 8;
    }

    public void setPointerSize(int size) {
        this.size = size;
    }
}

