/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client.tables;

import ghidra.features.bsim.query.client.tables.CachedStatement;
import ghidra.features.bsim.query.client.tables.SQLComplexTable;
import ghidra.features.bsim.query.description.DatabaseInformation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class KeyValueTable
extends SQLComplexTable {
    private final String INSERT_STMT = "INSERT INTO keyvaluetable (key,value) VALUES(?,?)";
    private final String UPDATE_STMT = "UPDATE keyvaluetable SET value = ? WHERE key = ?";
    private final String SELECT_STMT = "SELECT value FROM keyvaluetable WHERE key = ?";
    private final CachedStatement<PreparedStatement> insertStatement = new CachedStatement();
    private final CachedStatement<PreparedStatement> updateStatement = new CachedStatement();
    private final CachedStatement<PreparedStatement> selectStatement = new CachedStatement();

    public KeyValueTable() {
        super("keyvaluetable", null);
    }

    @Override
    public void close() {
        this.insertStatement.close();
        this.updateStatement.close();
        this.selectStatement.close();
        super.close();
    }

    @Override
    public void create(Statement st) throws SQLException {
        st.executeUpdate("CREATE TABLE keyvaluetable (key TEXT UNIQUE,value TEXT)");
    }

    @Override
    public void drop(Statement st) throws SQLException {
        throw new UnsupportedOperationException("KeyValueTable may not be dropped");
    }

    @Override
    public long insert(Object ... arguments) throws SQLException {
        if (arguments == null || arguments.length != 2 || !(arguments[0] instanceof String) || !(arguments[1] instanceof String)) {
            throw new IllegalArgumentException("Insert method for KeyValueTable must take exactly two arguments: String and String");
        }
        String key = (String)arguments[0];
        String value = (String)arguments[1];
        PreparedStatement s = this.updateStatement.prepareIfNeeded(() -> this.db.prepareStatement("UPDATE keyvaluetable SET value = ? WHERE key = ?"));
        s.setString(2, key);
        s.setString(1, value);
        if (s.executeUpdate() == 1) {
            return 0L;
        }
        s = this.insertStatement.prepareIfNeeded(() -> this.db.prepareStatement("INSERT INTO keyvaluetable (key,value) VALUES(?,?)"));
        s.setString(1, key);
        s.setString(2, value);
        s.executeUpdate();
        return 0L;
    }

    public void writeBasicInfo(DatabaseInformation info) throws SQLException {
        this.insert("name", info.databasename);
        this.insert("owner", info.owner);
        this.insert("description", info.description);
        this.insert("major", Integer.toString(info.major));
        this.insert("minor", Integer.toString(info.minor));
        this.insert("settings", Integer.toString(info.settings));
        this.insert("layout", Integer.toString(info.layout_version));
        String tf = info.readonly ? "t" : "f";
        this.insert("readonly", tf);
        tf = info.trackcallgraph ? "t" : "f";
        this.insert("trackcallgraph", tf);
        String datename = info.dateColumnName;
        if (datename == null) {
            datename = "Ingest Date";
        }
        this.insert("datecolumn", datename);
        this.writeExecutableCategories(info);
        this.writeFunctionTags(info);
    }

    public void writeExecutableCategories(DatabaseInformation info) throws SQLException {
        if (info.execats == null) {
            this.insert("execatcount", "0");
            return;
        }
        this.insert("execatcount", Integer.toString(info.execats.size()));
        for (int i = 0; i < info.execats.size(); ++i) {
            String key = "execat" + Integer.toString(i + 1);
            this.insert(key, info.execats.get(i));
        }
    }

    public void writeFunctionTags(DatabaseInformation info) throws SQLException {
        if (info.functionTags == null) {
            this.insert("functiontagcount", "0");
            return;
        }
        this.insert("functiontagcount", Integer.toString(info.functionTags.size()));
        for (int i = 0; i < info.functionTags.size(); ++i) {
            String key = "functiontag" + Integer.toString(i + 1);
            this.insert(key, info.functionTags.get(i));
        }
    }

    public String getValue(String key) throws SQLException {
        PreparedStatement s = this.selectStatement.prepareIfNeeded(() -> this.db.prepareStatement("SELECT value FROM keyvaluetable WHERE key = ?"));
        s.setString(1, key);
        try (ResultSet rs = s.executeQuery();){
            if (!rs.next()) {
                throw new SQLException("Could not fetch key value: " + key);
            }
            String value = rs.getString(1);
            String string = value;
            return string;
        }
    }
}

