/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.formatter.BaksmaliWriter;
import org.jf.dexlib2.iface.instruction.SwitchElement;
import org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableIntEncodedValue;

public class SparseSwitchMethodItem
extends InstructionMethodItem<SparseSwitchPayload> {
    private final List<SparseSwitchTarget> targets;
    private boolean commentedOut;

    public SparseSwitchMethodItem(MethodDefinition methodDef, int codeAddress, SparseSwitchPayload instruction) {
        super(methodDef, codeAddress, instruction);
        int baseCodeAddress = methodDef.getSparseSwitchBaseAddress(codeAddress);
        this.targets = new ArrayList<SparseSwitchTarget>();
        if (baseCodeAddress >= 0) {
            for (SwitchElement switchElement : instruction.getSwitchElements()) {
                LabelMethodItem label = methodDef.getLabelCache().internLabel(new LabelMethodItem(methodDef.classDef.options, baseCodeAddress + switchElement.getOffset(), "sswitch_"));
                this.targets.add(new SparseSwitchLabelTarget(switchElement.getKey(), label));
            }
        } else {
            this.commentedOut = true;
            for (SwitchElement switchElement : instruction.getSwitchElements()) {
                this.targets.add(new SparseSwitchOffsetTarget(switchElement.getKey(), switchElement.getOffset()));
            }
        }
    }

    @Override
    public boolean writeTo(BaksmaliWriter writer) throws IOException {
        if (this.commentedOut) {
            writer = this.methodDef.classDef.getCommentingWriter(writer);
        }
        writer.write(".sparse-switch\n");
        writer.indent(4);
        for (SparseSwitchTarget target : this.targets) {
            writer.writeEncodedValue((EncodedValue)new ImmutableIntEncodedValue(target.getKey()));
            writer.write(" -> ");
            target.writeTargetTo(writer);
            this.writeCommentIfResourceId(writer, target.getKey());
            writer.write(10);
        }
        writer.deindent(4);
        writer.write(".end sparse-switch");
        return true;
    }

    private static class SparseSwitchOffsetTarget
    extends SparseSwitchTarget {
        private final int target;

        public SparseSwitchOffsetTarget(int key, int target) {
            super(key);
            this.target = target;
        }

        @Override
        public void writeTargetTo(BaksmaliWriter writer) throws IOException {
            if (this.target >= 0) {
                writer.write(43);
            }
            writer.writeSignedIntAsDec(this.target);
        }
    }

    private static class SparseSwitchLabelTarget
    extends SparseSwitchTarget {
        private final LabelMethodItem target;

        public SparseSwitchLabelTarget(int key, LabelMethodItem target) {
            super(key);
            this.target = target;
        }

        @Override
        public void writeTargetTo(BaksmaliWriter writer) throws IOException {
            this.target.writeTo(writer);
        }
    }

    private static abstract class SparseSwitchTarget {
        private final int key;

        public SparseSwitchTarget(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public abstract void writeTargetTo(BaksmaliWriter var1) throws IOException;
    }
}

