/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.unix;

import com.sun.jna.LastErrorException;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import ghidra.pty.unix.PosixC;
import java.io.IOException;
import java.io.InputStream;

public class FdInputStream
extends InputStream {
    private static final PosixC LIB_POSIX = PosixC.INSTANCE;
    private final int fd;
    private volatile boolean closed = false;

    FdInputStream(int fd) {
        this.fd = fd;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        byte[] buf = new byte[1];
        if (0 == this.read(buf)) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int ret;
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (len == 0) {
            return 0;
        }
        Memory buf = new Memory((long)len);
        try {
            ret = LIB_POSIX.read(this.fd, (Pointer)buf, len);
        }
        catch (LastErrorException e) {
            if (e.getErrorCode() == 5 || e.getErrorCode() == 9) {
                throw new IOException(e);
            }
            throw e;
        }
        buf.read(0L, b, off, ret);
        return ret;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

