/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.markuptable;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.Settings;
import ghidra.feature.vt.api.stringable.FunctionNameStringable;
import ghidra.feature.vt.api.stringable.MultipleSymbolStringable;
import ghidra.feature.vt.api.stringable.SymbolStringable;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.util.exception.AssertException;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import java.awt.Component;
import org.apache.commons.lang3.StringUtils;

public class MarkupItemValueRenderer
extends AbstractGhidraColumnRenderer<Stringable> {
    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        super.getTableCellRendererComponent(data);
        Object value = data.getValue();
        boolean isSelected = data.isSelected();
        if (!(value instanceof Stringable) && value != null) {
            throw new AssertException("Incorrect column value for the markup item value column: " + value.getClass().getSimpleName());
        }
        String text = this.asString((Stringable)value);
        this.configureRendererForStringable((Stringable)value, text, isSelected);
        return this;
    }

    private String asString(Stringable stringable) {
        if (stringable == null) {
            return "";
        }
        String text = stringable.getDisplayString();
        if (StringUtils.isBlank((CharSequence)text)) {
            return "";
        }
        return text;
    }

    private void configureRendererForStringable(Stringable stringable, String text, boolean isSelected) {
        if (stringable == null) {
            this.setText(text);
            return;
        }
        if (StringUtils.isBlank((CharSequence)text)) {
            this.setText(text);
            return;
        }
        this.setText(text);
        boolean isSymbol = false;
        if (stringable instanceof SymbolStringable) {
            isSymbol = true;
        } else if (stringable instanceof FunctionNameStringable) {
            isSymbol = true;
        } else if (stringable instanceof MultipleSymbolStringable) {
            isSymbol = true;
        }
        if (!isSymbol) {
            return;
        }
        this.setBold();
    }

    public String getFilterString(Stringable t, Settings settings) {
        return this.asString(t);
    }
}

